/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.TableSorter;

class EventWellOccTableModel
extends AbstractTableModel {
    private static final String[] columnTitles = new String[]{"Well", "Version", "Sample", "Type", "LOC Age (Ma)"};
    private static final String[] columnTooltips = new String[]{null, null, null, null, "Derived from well/version LOC if present"};
    private static final int[] columnWidths = new int[]{80, 50, 50, 50, 50};
    private static final int COL_WELL = 0;
    private static final int COL_INTERP = 1;
    private static final int COL_SAMP = 2;
    private static final int COL_TYPE = 3;
    private static final int COL_AGE = 4;
    private SBdb db;
    List<SBEvent.WellEventQueryResult> events;

    EventWellOccTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.events == null) {
            return "";
        }
        SBEvent.WellEventQueryResult event = this.events.get(row);
        try {
            switch (col) {
                case 1: {
                    return event.interpName;
                }
                case 0: {
                    return event.wellName;
                }
                case 2: {
                    return event.sample;
                }
                case 3: {
                    return WellEvent.getType((char)event.type);
                }
                case 4: {
                    if (this.db == null) {
                        return "";
                    }
                    WellInterp wellInterp = this.db.getAddWell(event.wellID).getInterp(event.interpID);
                    if (wellInterp != null) {
                        wellInterp.loadLOC(event.wellID);
                        if (wellInterp.getLOC() != null) {
                            double age = wellInterp.getLOC().getAge(event.sample.getDepth(), false);
                            if (age > 0.0) {
                                return SB.floatString((double)age, (int)3);
                            }
                            return "";
                        }
                        return "";
                    }
                    return "";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.events == null) {
            return 0;
        }
        return this.events.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 2: {
                return Sample.class;
            }
        }
        return String.class;
    }

    void setupTable(JTable jTableWells, TableSorter wellSorter, SBdb sbdb) {
        this.db = sbdb;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            jTableWells.getColumnModel().getColumn(i).setHeaderValue(columnTitles[i]);
            jTableWells.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        SB.setTableHeaderBold((JTable)jTableWells);
        wellSorter.addMouseListenerToHeaderInTable(jTableWells);
        jTableWells.getTableHeader().addMouseMotionListener((MouseMotionListener)wellSorter.createColumnHeaderToolTips(columnTooltips, jTableWells));
    }
}

