/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import jsbugs.DateRenderer;
import jsbugs.TableModelSB;
import model2.SBdb;
import model2.WellEvent;

public class EventsTableModel
extends TableModelSB {
    List<WellEvent> events = null;
    char units = (char)77;
    static String[] columnTitles = new String[]{"Sample", "Event Type", "Event Name", "Qualifier", "Discipline", "Comments", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{55, 55, 120, 45, 35, 100, 30, 30};
    static final int COL_SAMPLE = 0;
    static final int COL_TYPE = 1;
    static final int COL_EVENT = 2;
    static final int COL_QUAL = 3;
    static final int COL_DISC = 4;
    static final int COL_COMMENTS = 5;
    static final int COL_MODIFIER = 6;
    static final int COL_MODIFIED = 7;

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        WellEvent event = this.events.get(row);
        switch (col) {
            case 0: {
                return event.getSample().toString(this.units, false, false, true);
            }
            case 1: {
                return event.getType();
            }
            case 2: {
                return event.getEvent().toString();
            }
            case 3: {
                return event.getQualifier();
            }
            case 4: {
                char discID = event.getDiscID();
                if (discID != '\u0000') {
                    return SBdb.getDiscAbr((char)discID);
                }
                return "";
            }
            case 6: {
                return event.getModifierAbr();
            }
            case 7: {
                return event.getModified();
            }
            case 5: {
                return event.getComments();
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 7: 
        }
        return Date.class;
    }

    @Override
    public int getRowCount() {
        if (this.events == null) {
            return 0;
        }
        return this.events.size();
    }

    void setupTable(JTable table, SBdb sbdb) {
        this.init(table, sbdb);
        table.getColumnModel().getColumn(7).setCellRenderer(new DateRenderer());
    }

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String getPrefString() {
        return "TMEVENTS";
    }

    @Override
    String getPrefOrderString() {
        return "TOEVENTS";
    }

    @Override
    final String getAutoResizeString() {
        return "TAREVENTS";
    }
}

