/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

class FloatRenderer
extends JLabel
implements TableCellRenderer {
    NumberFormat formatter = new DecimalFormat("##0.00####");
    Color backGround = new Color(150, 255, 255);
    Border selectedBorder = null;

    public FloatRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
    }

    public FloatRenderer(Color backGround) {
        this.backGround = backGround;
        this.setOpaque(true);
        this.setHorizontalAlignment(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object string, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(this.backGround);
        if (string != null) {
            this.setText(string.toString());
        } else {
            this.setText("");
        }
        if (isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(null);
        }
        return this;
    }

    public void setValue(Object value) {
        this.setText(value == null ? "" : this.formatter.format(value));
    }
}

