/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.ChartPanel;
import jsbugs.FrameJsbugs;
import jsbugs.PanelTaxon;
import jsbugs.WellBlock;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class FrameChart
extends JFrame
implements Observer {
    SBdb dataModel;
    private float zoom = 1.0f;
    ChartJPanel chartJPanel = new ChartJPanel(null);
    List<Image> imageList = new LinkedList<Image>();
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenu jMenuInsert;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemProperties;
    private JMenuItem jMenuItemZoomIn;
    private JMenuItem jMenuItemZoomOut;
    private JMenu jMenuPanel;
    private JMenu jMenuView;
    private JScrollPane jScrollPaneChart;
    private JToolBar jToolBar1;

    public FrameChart(SBdb dataModel) {
        this.dataModel = dataModel;
        this.setTitle("Charts - StrataBugs");
        this.initComponents();
        this.init();
        SB.centreWindow((Frame)this);
    }

    private void createImageList() {
        String[] pngs = new String[]{"48Charts.png", "32Charts.png", "24Charts.png", "16Charts.png"};
        Image img = null;
        for (int i = 0; i < pngs.length; ++i) {
            img = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/FrameIcon_Charts/" + pngs[i]));
            this.imageList.add(img);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jScrollPaneChart = new JScrollPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuView = new JMenu();
        this.jMenuItemZoomIn = new JMenuItem();
        this.jMenuItemZoomOut = new JMenuItem();
        this.jMenuPanel = new JMenu();
        this.jMenuItemProperties = new JMenuItem();
        this.jMenuInsert = new JMenu();
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FrameChart.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                FrameChart.this.formComponentShown(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomIn24.png")));
        this.jButtonZoomIn.setToolTipText("Zoom in");
        this.jButtonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameChart.this.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomOut24.png")));
        this.jButtonZoomOut.setToolTipText("Zoom out");
        this.jButtonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameChart.this.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        this.jMenuFile.setText("File");
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameChart.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuView.setText("View");
        this.jMenuItemZoomIn.setText("Zoom In");
        this.jMenuItemZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameChart.this.jMenuItemZoomInActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemZoomIn);
        this.jMenuItemZoomOut.setText("Zoom Out");
        this.jMenuItemZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameChart.this.jMenuItemZoomOutActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemZoomOut);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuPanel.setText("Panel");
        this.jMenuItemProperties.setText("Properties");
        this.jMenuPanel.add(this.jMenuItemProperties);
        this.jMenuInsert.setText("Insert");
        this.jMenuPanel.add(this.jMenuInsert);
        this.jMenuBar1.add(this.jMenuPanel);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jToolBar1, -1, 784, Short.MAX_VALUE).add((Component)this.jScrollPaneChart, -1, 784, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 36, -2).addPreferredGap(0).add((Component)this.jScrollPaneChart, -1, 555, Short.MAX_VALUE)));
        this.pack();
    }

    private void init() {
        this.chartJPanel.chart = new Chart();
        this.jScrollPaneChart.getViewport().add((Component)this.chartJPanel, null);
        this.chartJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrameChart.this.chartPanelMouseClicked(evt);
            }
        });
        this.chartJPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                FrameChart.this.chartPanelMouseMoved(evt);
            }
        });
        this.createImageList();
        this.setIconImages(this.imageList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chartPanelMouseClicked(MouseEvent evt) {
        try {
            if (evt.getClickCount() > 1) {
                Point2D point = this.chartJPanel.getPoint(evt.getPoint());
                ChartBlock block = this.chartJPanel.chart.getSelectedBlock(point);
                ChartPanel panel = this.chartJPanel.chart.getSelectedPanel(point);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void chartPanelMouseMoved(MouseEvent evt) {
        try {
            this.chartJPanel.setToolTipText(this.chartJPanel.getTooltip(evt));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.setScrollPaneSize();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.setScrollPaneSize();
    }

    private void jMenuItemZoomInActionPerformed(ActionEvent evt) {
        this.zoom *= 2.0f;
        this.setScrollPaneSize();
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom /= 2.0f;
        this.setScrollPaneSize();
    }

    private void jMenuItemZoomOutActionPerformed(ActionEvent evt) {
        this.zoom /= 2.0f;
        this.setScrollPaneSize();
    }

    @Override
    public void update(Observable obs, Object o) {
        Chart chart = this.chartJPanel.chart;
        for (WellBlock wellBlock : chart.blocks) {
            if (wellBlock.well != obs) continue;
            PanelTaxon panel = (PanelTaxon)wellBlock.panels.get(0);
            System.out.println("Resetting panel data for well: " + wellBlock.well);
            try {
                panel.setData(chart.chartProperties, null);
                this.chartJPanel.repaint();
            }
            catch (Exception e) {
                System.out.println("ERROR: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    void setScrollPaneSize() {
        this.chartJPanel.setSize(this.zoom);
        this.chartJPanel.revalidate();
        this.chartJPanel.repaint();
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom *= 2.0f;
        this.setScrollPaneSize();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

