/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableModel;
import jsbugs.BiocomTab;
import jsbugs.BiocomTableModel;
import jsbugs.Chart;
import jsbugs.DialogAgeCurves;
import jsbugs.DialogBiocom;
import jsbugs.DialogEnv;
import jsbugs.DialogIGD;
import jsbugs.DialogInterval;
import jsbugs.DialogLithdesc;
import jsbugs.DialogSQPick;
import jsbugs.DialogSelectWell;
import jsbugs.DialogWellEvent;
import jsbugs.EnvTab;
import jsbugs.EnvTableModel;
import jsbugs.EventTab;
import jsbugs.EventsTableModel;
import jsbugs.FrameJsbugs;
import jsbugs.GUI;
import jsbugs.IGDTab;
import jsbugs.IGDZonesTab;
import jsbugs.InternalFrameEnvSchemes;
import jsbugs.InternalFrameIGD;
import jsbugs.InternalFrameIGDSchemeChart;
import jsbugs.InternalFrameIGDSchemes;
import jsbugs.InternalFrameSubsidence;
import jsbugs.SQPickTab;
import jsbugs.SQPickTableModel;
import jsbugs.SchemeBlock;
import jsbugs.TableModelSB;
import jsbugs.ZonesTableModel;
import model2.AgeCurve;
import model2.Biocom;
import model2.CompositeStandard;
import model2.IGDInterval;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.InterpHdr;
import model2.Project;
import model2.SBdb;
import model2.SQPick;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class FrameInterpretations
extends JFrame
implements Observer {
    SBdb sbdb;
    List frameslist = new LinkedList();
    FrameJsbugs parent = null;
    InternalFrameSubsidence frameSubsidence = null;
    InternalFrameIGDSchemes frameSchemes = null;
    InternalFrameEnvSchemes frameEnvSchemes = null;
    InternalFrameIGDSchemeChart frameSchemeChart = null;
    List<IGDTab> igdTabs = new LinkedList<IGDTab>();
    char units = (char)68;
    List<Image> imageList = new LinkedList<Image>();
    private ButtonGroup buttonGroupUnits;
    private ButtonGroup buttonGroupWindows;
    private JButton jButtonAddInterval;
    private JButton jButtonCascade;
    private JButton jButtonCloseWindow;
    private JButton jButtonDeleteInterval;
    private JButton jButtonEditInterval;
    private JButton jButtonOpen;
    private JButton jButtonTile;
    private JCheckBoxMenuItem jCheckBoxMenuItemEnvScheme;
    private JCheckBoxMenuItem jCheckBoxMenuScheme;
    private JDesktopPane jDesktopPane;
    private JMenu jMenu1;
    private JMenuBar jMenuBar;
    private JMenu jMenuFile;
    private JMenu jMenuHelpMenu;
    private JMenuItem jMenuItemAgeCurves;
    private JMenuItem jMenuItemArrangeIcons;
    private JMenuItem jMenuItemCascade;
    private JMenuItem jMenuItemCloseWindow;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemHelpMain;
    private JMenuItem jMenuItemHelpMenu;
    private JMenuItem jMenuItemLithdesc;
    private JMenuItem jMenuItemSubsidence;
    private JMenuItem jMenuItemTile;
    private JMenuItem jMenuOpenIGD;
    private JMenu jMenuUnits;
    private JMenu jMenuView;
    private JMenu jMenuWindows;
    private JRadioButtonMenuItem jRadioButtonMenuItemDrilled;
    private JRadioButtonMenuItem jRadioButtonMenuItemFeet;
    private JRadioButtonMenuItem jRadioButtonMenuItemMetres;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPopupMenu.Separator jSeparator4;
    private JToolBar jToolBar1;

    public FrameInterpretations(FrameJsbugs parent, SBdb sbdb, Project project) {
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
        this.init();
    }

    @Override
    public FrameJsbugs getParent() {
        return this.parent;
    }

    private void createImageList() {
        String[] pngs = new String[]{"48Int.png", "32Int.png", "24Int.png", "16Int.png"};
        for (int i = 0; i < pngs.length; ++i) {
            Image img = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/FrameIcon_Int/" + pngs[i]));
            this.imageList.add(img);
        }
    }

    @Override
    public void update(Observable obs, Object arg) {
        System.out.println("obs: " + obs + " arg: " + arg);
        try {
            if (!(obs instanceof Project) && obs instanceof WellInterp) {
                int igdType = 0;
                WellInterp wellInterp = (WellInterp)obs;
                if (arg.getClass() == IGDIntervalZone.class) {
                    IGDIntervalZone zone = (IGDIntervalZone)arg;
                    igdType = zone.getIGDType();
                } else if (arg.getClass() == Biocom.class) {
                    igdType = 19;
                } else if (arg.getClass() == Integer.class) {
                    igdType = (Integer)arg;
                } else if (arg.getClass() == IGDIntervalEnv.class) {
                    igdType = 5;
                } else if (arg.getClass() == SQPick.class) {
                    igdType = 10;
                } else if (arg.getClass() == WellEvent.class) {
                    igdType = 20;
                }
                switch (igdType) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 10: 
                    case 19: 
                    case 20: {
                        System.out.println("Updating tab.....");
                        for (IGDTab tab : this.igdTabs) {
                            if (tab.interpID != wellInterp.getHeader().getInterpID()) continue;
                            try {
                                if (tab.well.getInterp(tab.interpID) != wellInterp) continue;
                                tab.sorter.reallocateIndexes();
                                tab.sorter.sort((Object)this);
                                tab.sorter.fireTableDataChanged();
                            }
                            catch (Exception ex) {
                                System.out.println("Exception from getting interp inside FrameInterpretations update method: " + ex.getMessage());
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error in update method: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void init() {
        this.setTitle("Schemes & Interpretations - StrataBugs");
        this.createImageList();
        this.setIconImages(this.imageList);
        this.jRadioButtonMenuItemDrilled.setSelected(true);
    }

    private InternalFrameIGD createInternalFrame(int igdType, int interpID) {
        JInternalFrame[] frames = this.jDesktopPane.getAllFrames();
        InternalFrameIGD frame = new InternalFrameIGD(this, igdType, interpID);
        this.jDesktopPane.add(frame);
        frame.setTitle("Window #" + (frames.length + 1));
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        int margin = frames.length * 24;
        int width = this.jDesktopPane.getBounds().width * 2 / 3 - 24;
        int height = this.jDesktopPane.getBounds().height * 2 / 3 - 24;
        frame.setBounds(frames.length + margin, frames.length + margin, width, height);
        this.frameslist.add(frame);
        frame.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                SB.jInternalFrameActivated((InternalFrameEvent)evt, (JDesktopPane)FrameInterpretations.this.jDesktopPane, (JMenu)FrameInterpretations.this.jMenuWindows);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                SB.jInternalFrameClosing((InternalFrameEvent)evt, (JDesktopPane)FrameInterpretations.this.jDesktopPane, (JMenu)FrameInterpretations.this.jMenuWindows);
                FrameInterpretations.this.frameslist.remove(this);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        return frame;
    }

    @Deprecated
    private void createMenu() {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(frame.getTitle(), true);
        this.jMenuWindows.add(menuItem);
        this.buttonGroupWindows.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.menuItemActionPerformed(evt);
            }
        });
    }

    private void editZone(IGDIntervalZone zone, WellInterp wellInterp, Well well) throws SQLException, SBException {
        DialogInterval dialog = new DialogInterval(this, true, zone.getIGDType(), this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, zone, null, null, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void editPick(SQPick pick, WellInterp wellInterp, Well well) throws SQLException, SBException {
        DialogSQPick dialog = new DialogSQPick(this, true, this.sbdb, null, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, pick, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void editEvent(WellEvent event, Well well, WellInterp wellInterp) throws SBException, SQLException {
        DialogWellEvent dialog = new DialogWellEvent(this, true, this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, event, null, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void editBiocom(Biocom biocom, Well well, WellInterp wellInterp) throws SBException, SQLException {
        DialogBiocom dialog = new DialogBiocom(this, true, this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, biocom, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void editEnv(IGDIntervalEnv env, Well well, WellInterp wellInterp) throws SQLException, SBException {
        DialogEnv dialog = new DialogEnv(this, true, this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, env, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jTableIGDKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteIntervalActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openIGDFrame() {
        block29: {
            if (!this.parent.checkRLMlicence()) {
                JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                this.jMenuItemExitActionPerformed(null);
                return;
            }
            try {
                Iterator<Well> it;
                DialogIGD dialogIGD = new DialogIGD((Frame)this, true, this.sbdb);
                dialogIGD.setLocationRelativeTo(this);
                dialogIGD.setVisible(true);
                if (!dialogIGD.isOK) break block29;
                if (dialogIGD.project == null || dialogIGD.project.getID() == 0) {
                    DialogSelectWell dialogWells = new DialogSelectWell((Frame)this, true, this.sbdb, true);
                    dialogWells.setLocationRelativeTo(this);
                    dialogWells.setVisible(true);
                    if (dialogWells.selection == null) {
                        return;
                    }
                    it = dialogWells.selection.iterator();
                } else {
                    it = dialogIGD.project.getWellIterator();
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                InternalFrameIGD frame = this.createInternalFrame(dialogIGD.igdType, dialogIGD.interpID);
                InterpHdr interpHdr = this.sbdb.getInterp(dialogIGD.interpID);
                block23: while (it.hasNext()) {
                    Well well = it.next();
                    JScrollPane pane = frame.addPane(well);
                    switch (dialogIGD.igdType) {
                        case 2: 
                        case 3: 
                        case 4: {
                            WellInterp wellInterp;
                            TableModelSB model = new ZonesTableModel();
                            TableSorter sorter = new TableSorter((TableModel)model);
                            JTable table = new JTable((TableModel)sorter);
                            table.setAutoResizeMode(4);
                            table.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent evt) {
                                    if (evt.getClickCount() > 1) {
                                        FrameInterpretations.this.jButtonEditIntervalActionPerformed(null);
                                    }
                                }
                            });
                            table.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyPressed(KeyEvent evt) {
                                    FrameInterpretations.this.jTableIGDKeyPressed(evt);
                                }
                            });
                            ((ZonesTableModel)model).setupTable(table, this.sbdb);
                            sorter.addMouseListenerToHeaderInTable(table);
                            pane.getViewport().add(table);
                            pane.setViewportView(table);
                            IGDZonesTab tab = new IGDZonesTab();
                            tab.table = table;
                            tab.sorter = sorter;
                            tab.well = well;
                            tab.interpID = dialogIGD.interpID;
                            tab.igdType = dialogIGD.igdType;
                            (tab.model = model).units = this.units == 'D' ? well.getWellUnits() : this.units;
                            tab.scrollPane = pane;
                            this.igdTabs.add(tab);
                            well.loadInterps();
                            try {
                                wellInterp = well.getAddInterp(interpHdr);
                                well.loadInterp(wellInterp);
                                wellInterp.getIGDSchemes(dialogIGD.igdType);
                                ((ZonesTableModel)model).zones = wellInterp.getIGDList(dialogIGD.igdType, 0);
                                wellInterp.addObserver((Observer)this);
                            }
                            catch (SBException sbe) {
                                System.out.println("No interpretation found for ID: " + dialogIGD.interpID + " for well: " + well);
                            }
                            sorter.reallocateIndexes();
                            sorter.fireTableDataChanged();
                            continue block23;
                        }
                        case 10: {
                            WellInterp wellInterp;
                            TableModelSB model = new SQPickTableModel();
                            TableSorter sorter = new TableSorter((TableModel)model);
                            JTable table = new JTable((TableModel)sorter);
                            table.setAutoResizeMode(4);
                            table.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent evt) {
                                    if (evt.getClickCount() > 1) {
                                        FrameInterpretations.this.jButtonEditIntervalActionPerformed(null);
                                    }
                                }
                            });
                            table.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyPressed(KeyEvent evt) {
                                    FrameInterpretations.this.jTableIGDKeyPressed(evt);
                                }
                            });
                            ((SQPickTableModel)model).setupTable(table, this.sbdb);
                            sorter.addMouseListenerToHeaderInTable(table);
                            pane.getViewport().add(table);
                            pane.setViewportView(table);
                            SQPickTab stab = new SQPickTab();
                            stab.table = table;
                            stab.sorter = sorter;
                            stab.well = well;
                            stab.interpID = dialogIGD.interpID;
                            stab.igdType = dialogIGD.igdType;
                            (stab.model = model).units = this.units == 'D' ? well.getWellUnits() : this.units;
                            stab.scrollPane = pane;
                            this.igdTabs.add(stab);
                            well.loadInterps();
                            try {
                                wellInterp = well.getAddInterp(interpHdr);
                                well.loadInterp(wellInterp);
                                ((SQPickTableModel)model).picks = wellInterp.getSQPicks();
                                wellInterp.addObserver((Observer)this);
                            }
                            catch (SBException sbe) {
                                System.out.println("No interpretation found for ID: " + dialogIGD.interpID + " for well: " + well);
                            }
                            sorter.reallocateIndexes();
                            sorter.fireTableDataChanged();
                            continue block23;
                        }
                        case 20: {
                            WellInterp wellInterp;
                            TableModelSB model = new EventsTableModel();
                            TableSorter sorter = new TableSorter((TableModel)model);
                            JTable table = new JTable((TableModel)sorter);
                            table.setAutoResizeMode(4);
                            table.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent evt) {
                                    if (evt.getClickCount() > 1) {
                                        FrameInterpretations.this.jButtonEditIntervalActionPerformed(null);
                                    }
                                }
                            });
                            table.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyPressed(KeyEvent evt) {
                                    FrameInterpretations.this.jTableIGDKeyPressed(evt);
                                }
                            });
                            ((EventsTableModel)model).setupTable(table, this.sbdb);
                            sorter.addMouseListenerToHeaderInTable(table);
                            pane.getViewport().add(table);
                            pane.setViewportView(table);
                            EventTab eventTab = new EventTab();
                            eventTab.table = table;
                            eventTab.sorter = sorter;
                            eventTab.well = well;
                            eventTab.interpID = dialogIGD.interpID;
                            eventTab.igdType = dialogIGD.igdType;
                            (eventTab.model = model).units = this.units == 'D' ? well.getWellUnits() : this.units;
                            eventTab.scrollPane = pane;
                            this.igdTabs.add(eventTab);
                            well.loadInterps();
                            try {
                                wellInterp = well.getAddInterp(interpHdr);
                                well.loadInterp(wellInterp);
                                ((EventsTableModel)model).events = wellInterp.getEvents();
                                wellInterp.addObserver((Observer)this);
                            }
                            catch (SBException sbe) {
                                System.out.println("No interpretation found for ID: " + dialogIGD.interpID + " for well: " + well);
                            }
                            sorter.reallocateIndexes();
                            sorter.fireTableDataChanged();
                            continue block23;
                        }
                        case 19: {
                            WellInterp wellInterp;
                            TableModelSB model = new BiocomTableModel();
                            TableSorter sorter = new TableSorter((TableModel)model);
                            JTable table = new JTable((TableModel)sorter);
                            table.setAutoResizeMode(4);
                            table.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent evt) {
                                    if (evt.getClickCount() > 1) {
                                        FrameInterpretations.this.jButtonEditIntervalActionPerformed(null);
                                    }
                                }
                            });
                            table.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyPressed(KeyEvent evt) {
                                    FrameInterpretations.this.jTableIGDKeyPressed(evt);
                                }
                            });
                            ((BiocomTableModel)model).setupTable(table, this.sbdb);
                            sorter.addMouseListenerToHeaderInTable(table);
                            pane.getViewport().add(table);
                            pane.setViewportView(table);
                            BiocomTab biocomTab = new BiocomTab();
                            biocomTab.table = table;
                            biocomTab.sorter = sorter;
                            biocomTab.well = well;
                            biocomTab.interpID = dialogIGD.interpID;
                            biocomTab.igdType = dialogIGD.igdType;
                            (biocomTab.model = model).units = this.units == 'D' ? well.getWellUnits() : this.units;
                            biocomTab.scrollPane = pane;
                            this.igdTabs.add(biocomTab);
                            well.loadInterps();
                            try {
                                wellInterp = well.getAddInterp(interpHdr);
                                well.loadInterp(wellInterp);
                                ((BiocomTableModel)model).comments = wellInterp.getComments();
                                wellInterp.addObserver((Observer)this);
                            }
                            catch (SBException sbe) {
                                System.out.println("No interpretation found for ID: " + dialogIGD.interpID + " for well: " + well);
                            }
                            sorter.reallocateIndexes();
                            sorter.fireTableDataChanged();
                            continue block23;
                        }
                        case 5: {
                            WellInterp wellInterp;
                            TableModelSB model = new EnvTableModel();
                            TableSorter sorter = new TableSorter((TableModel)model);
                            JTable table = new JTable((TableModel)sorter);
                            table.setAutoResizeMode(4);
                            table.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent evt) {
                                    if (evt.getClickCount() > 1) {
                                        FrameInterpretations.this.jButtonEditIntervalActionPerformed(null);
                                    }
                                }
                            });
                            table.addKeyListener(new KeyAdapter(){

                                @Override
                                public void keyPressed(KeyEvent evt) {
                                    FrameInterpretations.this.jTableIGDKeyPressed(evt);
                                }
                            });
                            ((EnvTableModel)model).setupTable(table, this.sbdb);
                            sorter.addMouseListenerToHeaderInTable(table);
                            pane.getViewport().add(table);
                            pane.setViewportView(table);
                            EnvTab envTab = new EnvTab();
                            envTab.table = table;
                            envTab.sorter = sorter;
                            envTab.well = well;
                            envTab.interpID = dialogIGD.interpID;
                            envTab.igdType = dialogIGD.igdType;
                            (envTab.model = model).units = this.units == 'D' ? well.getWellUnits() : this.units;
                            envTab.scrollPane = pane;
                            this.igdTabs.add(envTab);
                            well.loadInterps();
                            try {
                                wellInterp = well.getAddInterp(interpHdr);
                                well.loadInterp(wellInterp);
                                ((EnvTableModel)model).envs = wellInterp.getEnvs();
                                wellInterp.addObserver((Observer)this);
                            }
                            catch (SBException sbe) {
                                System.out.println("No interpretation found for ID: " + dialogIGD.interpID + " for well: " + well);
                            }
                            sorter.reallocateIndexes();
                            sorter.fireTableDataChanged();
                            continue block23;
                        }
                    }
                    throw new SBException("Unknown IGD Type in FrameInterpretations");
                }
                String title = IGDInterval.getIGDName((int)dialogIGD.igdType) + " : " + this.sbdb.getInterp(dialogIGD.interpID);
                if (dialogIGD.project != null && dialogIGD.project.getID() > 0) {
                    title = title + " : " + dialogIGD.project.toString();
                }
                frame.setTitle(title);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void menuItemActionPerformed(ActionEvent evt) {
        JInternalFrame[] frames = this.jDesktopPane.getAllFrames();
        AbstractButton item = null;
        for (int m = 0; m < this.jMenuWindows.getItemCount(); ++m) {
            JMenuItem menuItem;
            if (this.jMenuWindows.getItem(m) == null || (menuItem = this.jMenuWindows.getItem(m)).getClass() != JCheckBoxMenuItem.class) continue;
            item = (JCheckBoxMenuItem)menuItem;
            if (item.isSelected()) break;
            item = null;
        }
        if (item == null) {
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            if (!item.getText().equals(frames[i].getTitle())) continue;
            try {
                frames[i].setSelected(true);
                continue;
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupWindows = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.jButtonOpen = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonAddInterval = new JButton();
        this.jButtonEditInterval = new JButton();
        this.jButtonDeleteInterval = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonCascade = new JButton();
        this.jButtonTile = new JButton();
        this.jButtonCloseWindow = new JButton();
        this.jDesktopPane = new JDesktopPane();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuOpenIGD = new JMenuItem();
        this.jMenuItemSubsidence = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuView = new JMenu();
        this.jCheckBoxMenuScheme = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemEnvScheme = new JCheckBoxMenuItem();
        this.jMenuItemAgeCurves = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItemLithdesc = new JMenuItem();
        this.jMenuUnits = new JMenu();
        this.jRadioButtonMenuItemMetres = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemFeet = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemDrilled = new JRadioButtonMenuItem();
        this.jMenuWindows = new JMenu();
        this.jMenuItemCascade = new JMenuItem();
        this.jMenuItemTile = new JMenuItem();
        this.jMenuItemCloseWindow = new JMenuItem();
        this.jMenuItemArrangeIcons = new JMenuItem();
        this.jMenuHelpMenu = new JMenu();
        this.jMenuItemHelpMain = new JMenuItem();
        this.jMenuItemHelpMenu = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jButtonOpen.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameInterpretations_Open.png")));
        this.jButtonOpen.setToolTipText("Open project interpretation");
        this.jButtonOpen.setMargin(new Insets(4, 4, 2, 4));
        this.jButtonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jButtonOpenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpen);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setMaximumSize(new Dimension(5, 30));
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonAddInterval.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameInterpretations_AddInterval.png")));
        this.jButtonAddInterval.setToolTipText("Add new interval");
        this.jButtonAddInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jButtonAddIntervalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonAddInterval);
        this.jButtonEditInterval.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameInterpretations_EditInterval.png")));
        this.jButtonEditInterval.setToolTipText("Edit selected interval");
        this.jButtonEditInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jButtonEditIntervalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonEditInterval);
        this.jButtonDeleteInterval.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameInterpretations_DeleteInterval.png")));
        this.jButtonDeleteInterval.setToolTipText("Delete selected interval(s)");
        this.jButtonDeleteInterval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jButtonDeleteIntervalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDeleteInterval);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(5, 30));
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonCascade.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameInterpretations_Cascade.png")));
        this.jButtonCascade.setToolTipText("Cascade windows");
        this.jButtonCascade.setMargin(new Insets(4, 4, 2, 4));
        this.jButtonCascade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jButtonCascadeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonCascade);
        this.jButtonTile.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameInterpretations_Tile.png")));
        this.jButtonTile.setToolTipText("Tile windows");
        this.jButtonTile.setMargin(new Insets(4, 4, 2, 4));
        this.jButtonTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jButtonTileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonTile);
        this.jButtonCloseWindow.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameInterpretations_CloseWindow.png")));
        this.jButtonCloseWindow.setToolTipText("Close active window");
        this.jButtonCloseWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jButtonCloseWindowActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonCloseWindow);
        this.jDesktopPane.setBackground(new Color(102, 102, 102));
        this.jMenuFile.setText("File");
        this.jMenuOpenIGD.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuOpenIGD.setText("Open project interpretation...");
        this.jMenuOpenIGD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuOpenIGDActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuOpenIGD);
        this.jMenuItemSubsidence.setText("Subsidence curves...");
        this.jMenuItemSubsidence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemSubsidenceActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSubsidence);
        this.jMenuFile.add(this.jSeparator4);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuView.setText("Schemes");
        this.jCheckBoxMenuScheme.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jCheckBoxMenuScheme.setText("Stratigraphic Schemes");
        this.jCheckBoxMenuScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jCheckBoxMenuSchemeActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jCheckBoxMenuScheme);
        this.jCheckBoxMenuItemEnvScheme.setText("Palaeoenvironment Schemes");
        this.jCheckBoxMenuItemEnvScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jCheckBoxMenuItemEnvSchemeActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jCheckBoxMenuItemEnvScheme);
        this.jMenuItemAgeCurves.setText("Age Curves...");
        this.jMenuItemAgeCurves.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemAgeCurvesActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemAgeCurves);
        this.jMenu1.setText("Lithology");
        this.jMenuItemLithdesc.setText("Description and grain size...");
        this.jMenuItemLithdesc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemLithdescActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItemLithdesc);
        this.jMenuView.add(this.jMenu1);
        this.jMenuBar.add(this.jMenuView);
        this.jMenuUnits.setText("Units");
        this.buttonGroupUnits.add(this.jRadioButtonMenuItemMetres);
        this.jRadioButtonMenuItemMetres.setText("Metres");
        this.jRadioButtonMenuItemMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jRadioButtonMenuItemMetresActionPerformed(evt);
            }
        });
        this.jMenuUnits.add(this.jRadioButtonMenuItemMetres);
        this.buttonGroupUnits.add(this.jRadioButtonMenuItemFeet);
        this.jRadioButtonMenuItemFeet.setText("Feet");
        this.jRadioButtonMenuItemFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jRadioButtonMenuItemFeetActionPerformed(evt);
            }
        });
        this.jMenuUnits.add(this.jRadioButtonMenuItemFeet);
        this.buttonGroupUnits.add(this.jRadioButtonMenuItemDrilled);
        this.jRadioButtonMenuItemDrilled.setText("as Drilled");
        this.jRadioButtonMenuItemDrilled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jRadioButtonMenuItemDrilledActionPerformed(evt);
            }
        });
        this.jMenuUnits.add(this.jRadioButtonMenuItemDrilled);
        this.jMenuBar.add(this.jMenuUnits);
        this.jMenuWindows.setText("Windows");
        this.jMenuItemCascade.setText("Cascade");
        this.jMenuItemCascade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemCascadeActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemCascade);
        this.jMenuItemTile.setText("Tile");
        this.jMenuItemTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemTileActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemTile);
        this.jMenuItemCloseWindow.setText("Close active window");
        this.jMenuItemCloseWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemCloseWindowActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemCloseWindow);
        this.jMenuItemArrangeIcons.setText("Arrange icons");
        this.jMenuItemArrangeIcons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemArrangeIconsActionPerformed(evt);
            }
        });
        this.jMenuWindows.add(this.jMenuItemArrangeIcons);
        this.jMenuBar.add(this.jMenuWindows);
        this.jMenuHelpMenu.setText("Help");
        this.jMenuItemHelpMain.setText("Schemes & Interpretations help...");
        this.jMenuItemHelpMain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemHelpMainActionPerformed(evt);
            }
        });
        this.jMenuHelpMenu.add(this.jMenuItemHelpMain);
        this.jMenuItemHelpMenu.setText("Menus...");
        this.jMenuItemHelpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameInterpretations.this.jMenuItemHelpMenuActionPerformed(evt);
            }
        });
        this.jMenuHelpMenu.add(this.jMenuItemHelpMenu);
        this.jMenuBar.add(this.jMenuHelpMenu);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, -1, -2).add(447, 447, 447)).add((Component)this.jDesktopPane, -1, 970, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 30, -2).add(8, 8, 8).add((Component)this.jDesktopPane, -1, 823, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonEditIntervalActionPerformed(ActionEvent evt) {
        try {
            JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
            if (!(frame instanceof InternalFrameIGD)) {
                JOptionPane.showMessageDialog(this, "Select an interpretation", this.getTitle(), 0);
                return;
            }
            InternalFrameIGD igdFrame = (InternalFrameIGD)frame;
            Well well = igdFrame.getActive();
            if (well == null) {
                JOptionPane.showMessageDialog(this, "No active zone list ", this.getTitle(), 0);
                return;
            }
            WellInterp wellInterp = well.getInterp(igdFrame.getInterpID());
            IGDTab igdTab = null;
            int igdType = igdFrame.getIGDType();
            for (IGDTab tab : this.igdTabs) {
                if (igdFrame.getScrollPane() != tab.scrollPane) continue;
                igdTab = tab;
                break;
            }
            if (igdTab == null) {
                JOptionPane.showMessageDialog(this, "Error locating selected tabbed scroll pane.", this.getTitle(), 0);
                return;
            }
            if (igdTab.table == null) {
                JOptionPane.showMessageDialog(this, "Error locating selected tabbed pane.", this.getTitle(), 0);
                return;
            }
            int nRows = igdTab.table.getSelectedRowCount();
            if (nRows != 1) {
                JOptionPane.showMessageDialog(this, "Select one interval to edit", this.getTitle(), 2);
                return;
            }
            int row = igdTab.table.getSelectedRow();
            switch (igdType) {
                case 2: 
                case 3: 
                case 4: {
                    IGDZonesTab igdZonesTab = (IGDZonesTab)igdTab;
                    IGDIntervalZone zone = igdZonesTab.model.zones.get(igdZonesTab.sorter.getIndexOf(row));
                    this.editZone(zone, wellInterp, well);
                    break;
                }
                case 10: {
                    SQPickTab pickTab = (SQPickTab)igdTab;
                    SQPick pick = pickTab.model.picks.get(pickTab.sorter.getIndexOf(row));
                    this.editPick(pick, wellInterp, well);
                    break;
                }
                case 20: {
                    EventTab eventTab = (EventTab)igdTab;
                    WellEvent event = eventTab.model.events.get(eventTab.sorter.getIndexOf(row));
                    this.editEvent(event, well, wellInterp);
                    break;
                }
                case 19: {
                    BiocomTab biocomTab = (BiocomTab)igdTab;
                    Biocom biocom = biocomTab.model.comments.get(biocomTab.sorter.getIndexOf(row));
                    this.editBiocom(biocom, well, wellInterp);
                    break;
                }
                case 5: {
                    EnvTab envTab = (EnvTab)igdTab;
                    IGDIntervalEnv envZone = envTab.model.envs.get(envTab.sorter.getIndexOf(row));
                    this.editEnv(envZone, well, wellInterp);
                }
            }
            igdTab.table.clearSelection();
            wellInterp.notifyObservers((Object)igdType);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage() + '\n' + SB.sql, this.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
    }

    private void jButtonDeleteIntervalActionPerformed(ActionEvent evt) {
        try {
            JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
            if (!(frame instanceof InternalFrameIGD)) {
                JOptionPane.showMessageDialog(this, "Select an interpretation", this.getTitle(), 0);
                return;
            }
            InternalFrameIGD igdFrame = (InternalFrameIGD)frame;
            Well well = igdFrame.getActive();
            if (well == null) {
                JOptionPane.showMessageDialog(this, "No active zone list ", this.getTitle(), 0);
                return;
            }
            WellInterp wellInterp = well.getInterp(igdFrame.getInterpID());
            IGDTab igdTab = null;
            int igdType = igdFrame.getIGDType();
            for (IGDTab tab : this.igdTabs) {
                if (tab.igdType != igdType || tab.well != well || tab.interpID != wellInterp.getHeader().getInterpID()) continue;
                igdTab = tab;
                break;
            }
            if (igdTab.table == null) {
                JOptionPane.showMessageDialog(this, "Error locating selected tabbed pane.", this.getTitle(), 0);
                return;
            }
            int nRows = igdTab.table.getSelectedRowCount();
            if (nRows == 0) {
                JOptionPane.showMessageDialog(this, "Select interval(s) to delete", this.getTitle(), 2);
                return;
            }
            String msg = "Really delete ";
            msg = nRows == 1 ? msg + "this interval?" : msg + "these " + nRows + " intervals?";
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) {
                return;
            }
            switch (igdType) {
                case 2: 
                case 3: 
                case 4: {
                    IGDZonesTab igdZonesTab = (IGDZonesTab)igdTab;
                    LinkedList<IGDIntervalZone> toKill = new LinkedList<IGDIntervalZone>();
                    for (int row : igdZonesTab.table.getSelectedRows()) {
                        toKill.add(igdZonesTab.model.zones.get(igdZonesTab.sorter.getIndexOf(row)));
                    }
                    int zoneIgdType = 0;
                    for (IGDIntervalZone zone : toKill) {
                        zoneIgdType = zone.getIGDType();
                        wellInterp.deleteZone(well, zone);
                        this.sbdb.commit();
                    }
                    break;
                }
                case 10: {
                    SQPickTab picksTab = (SQPickTab)igdTab;
                    LinkedList<SQPick> picksToKill = new LinkedList<SQPick>();
                    for (int row : picksTab.table.getSelectedRows()) {
                        picksToKill.add(picksTab.model.picks.get(picksTab.sorter.getIndexOf(row)));
                    }
                    for (SQPick pick : picksToKill) {
                        wellInterp.deleteSQPick(pick, well.getWellID());
                        this.sbdb.commit();
                    }
                    break;
                }
                case 20: {
                    EventTab eventsTab = (EventTab)igdTab;
                    LinkedList<WellEvent> eventsToKill = new LinkedList<WellEvent>();
                    for (int row : eventsTab.table.getSelectedRows()) {
                        eventsToKill.add(eventsTab.model.events.get(eventsTab.sorter.getIndexOf(row)));
                    }
                    for (WellEvent event : eventsToKill) {
                        wellInterp.deleteEvent(event, well.getWellID());
                        this.sbdb.commit();
                    }
                    break;
                }
                case 19: {
                    BiocomTab biocomTab = (BiocomTab)igdTab;
                    LinkedList<Biocom> biocomsToKill = new LinkedList<Biocom>();
                    for (int row : biocomTab.table.getSelectedRows()) {
                        biocomsToKill.add(biocomTab.model.comments.get(biocomTab.sorter.getIndexOf(row)));
                    }
                    for (Biocom biocom : biocomsToKill) {
                        wellInterp.deleteBiocom(biocomTab.well.getWellID(), biocom);
                        this.sbdb.commit();
                    }
                    break;
                }
                case 5: {
                    EnvTab envTab = (EnvTab)igdTab;
                    LinkedList<IGDIntervalEnv> envsToKill = new LinkedList<IGDIntervalEnv>();
                    for (int row : envTab.table.getSelectedRows()) {
                        envsToKill.add(envTab.model.envs.get(envTab.sorter.getIndexOf(row)));
                    }
                    for (IGDIntervalEnv env : envsToKill) {
                        wellInterp.deleteEnv(env, well.getWellID());
                        this.sbdb.commit();
                    }
                    break;
                }
            }
            igdTab.table.clearSelection();
            wellInterp.notifyObservers((Object)igdType);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage() + '\n' + SB.sql, this.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
    }

    private void jButtonAddIntervalActionPerformed(ActionEvent evt) {
        try {
            JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
            if (!(frame instanceof InternalFrameIGD)) {
                JOptionPane.showMessageDialog(this, "Select an interpretation", this.getTitle(), 0);
                return;
            }
            InternalFrameIGD igdFrame = (InternalFrameIGD)frame;
            Well well = igdFrame.getActive();
            if (well == null) {
                JOptionPane.showMessageDialog(this, "No active zone list", this.getTitle(), 0);
                return;
            }
            well.loadInterps();
            WellInterp wellInterp = well.getAddInterp(this.sbdb.getInterp(igdFrame.getInterpID()));
            if (igdFrame.getIGDType() == 10) {
                DialogSQPick dialog = new DialogSQPick(this, true, this.sbdb, null, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, null, null, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            } else if (igdFrame.getIGDType() == 20) {
                DialogWellEvent dialog = new DialogWellEvent(this, true, this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, null, null, null, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            } else if (igdFrame.getIGDType() == 19) {
                DialogBiocom dialog = new DialogBiocom(this, true, this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, null, null, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            } else if (igdFrame.getIGDType() == 5) {
                DialogEnv dialog = new DialogEnv(this, true, this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, null, null, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            } else {
                DialogInterval dialog = new DialogInterval(this, true, igdFrame.getIGDType(), this.sbdb, well, wellInterp, this.units == 'D' ? well.getWellUnits() : this.units, null, null, null, null, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening dialog: " + e.getMessage(), this.getTitle(), 0);
        }
    }

    private void jMenuItemArrangeIconsActionPerformed(ActionEvent evt) {
        JInternalFrame[] frames = this.jDesktopPane.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        for (int i = 0; i <= frames.length; ++i) {
            if (!frames[i].isIcon()) continue;
        }
    }

    private void jMenuItemCloseWindowActionPerformed(ActionEvent evt) {
        this.closeActiveFrame();
    }

    private void jButtonCloseWindowActionPerformed(ActionEvent evt) {
        this.closeActiveFrame();
    }

    private void closeActiveFrame() {
        JInternalFrame frame = this.jDesktopPane.getSelectedFrame();
        if (frame == null) {
            return;
        }
        if (this.frameSchemes != null && frame == this.frameSchemes) {
            frame.setVisible(false);
            this.jCheckBoxMenuScheme.setSelected(false);
        } else {
            try {
                frame.setClosed(true);
            }
            catch (PropertyVetoException pve) {
                pve.printStackTrace();
            }
        }
    }

    private void jMenuItemTileActionPerformed(ActionEvent evt) {
        SB.tile((JDesktopPane)this.jDesktopPane);
    }

    private void jMenuItemCascadeActionPerformed(ActionEvent evt) {
        SB.cascade((JDesktopPane)this.jDesktopPane);
    }

    private void jButtonCascadeActionPerformed(ActionEvent evt) {
        SB.cascade((JDesktopPane)this.jDesktopPane);
    }

    private void jButtonTileActionPerformed(ActionEvent evt) {
        SB.tile((JDesktopPane)this.jDesktopPane);
    }

    private void jCheckBoxMenuSchemeActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMenuScheme.isSelected()) {
            if (this.frameSchemes == null) {
                this.frameSchemes = new InternalFrameIGDSchemes(this, this.sbdb, this.jCheckBoxMenuScheme);
                this.jDesktopPane.add(this.frameSchemes);
            }
            this.frameSchemes.setVisible(true);
        } else if (this.frameSchemes != null) {
            this.frameSchemes.setVisible(false);
        }
    }

    private void jMenuOpenIGDActionPerformed(ActionEvent evt) {
        this.openIGDFrame();
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        this.openIGDFrame();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemSubsidenceActionPerformed(ActionEvent evt) {
        try {
            if (this.frameSubsidence == null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.frameSubsidence = new InternalFrameSubsidence(this, this.sbdb);
                if (this.frameSubsidence.cancel) {
                    this.frameSubsidence = null;
                    return;
                }
                this.jDesktopPane.add(this.frameSubsidence);
            }
            this.frameSubsidence.setVisible(true);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jCheckBoxMenuItemEnvSchemeActionPerformed(ActionEvent evt) {
        try {
            if (this.jCheckBoxMenuItemEnvScheme.isSelected()) {
                if (this.frameEnvSchemes == null) {
                    this.frameEnvSchemes = new InternalFrameEnvSchemes(this, this.sbdb, this.jCheckBoxMenuItemEnvScheme);
                    this.jDesktopPane.add(this.frameEnvSchemes);
                }
                this.frameEnvSchemes.setVisible(true);
            } else if (this.frameEnvSchemes != null) {
                this.frameEnvSchemes.setVisible(false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error opening frame:" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void jMenuItemLithdescActionPerformed(ActionEvent evt) {
        try {
            DialogLithdesc dialog = new DialogLithdesc((Frame)this, true, this.sbdb);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error opening frame:" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void jMenuItemHelpMainActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("schemes.html");
    }

    private void jMenuItemHelpMenuActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("schemes_menu.html");
    }

    private void jRadioButtonMenuItemMetresActionPerformed(ActionEvent evt) {
        this.setUnits('M');
    }

    private void jRadioButtonMenuItemFeetActionPerformed(ActionEvent evt) {
        this.setUnits('F');
    }

    private void jRadioButtonMenuItemDrilledActionPerformed(ActionEvent evt) {
        this.setUnits('D');
    }

    private void jMenuItemAgeCurvesActionPerformed(ActionEvent evt) {
        DialogAgeCurves dialog = new DialogAgeCurves((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    void setUnits(char units) {
        for (IGDTab igdTab : this.igdTabs) {
            char unitsToSet = units;
            if (units == 'D') {
                unitsToSet = igdTab.well.getWellUnits();
            }
            if (igdTab instanceof IGDZonesTab) {
                ((IGDZonesTab)igdTab).model.units = unitsToSet;
            } else if (igdTab instanceof EnvTab) {
                ((EnvTab)igdTab).model.units = unitsToSet;
            } else if (igdTab instanceof SQPickTab) {
                ((SQPickTab)igdTab).model.units = unitsToSet;
            }
            igdTab.sorter.fireTableDataChanged();
        }
        this.units = units;
    }

    void drawScheme(CompositeStandard[] std, IGDScheme[] schemes, AgeCurve ageCurve) throws SQLException {
        if (this.frameSchemeChart == null || !this.frameSchemeChart.isVisible()) {
            this.frameSchemeChart = new InternalFrameIGDSchemeChart(this, this.sbdb, std, schemes);
            this.frameSchemeChart.chartJPanel.chart.calcChartSize();
            GUI.setScrollPaneSize(this.frameSchemeChart.chartJPanel, this.frameSchemeChart.chartJPanel.zoom, 1.5f);
            this.jDesktopPane.add(this.frameSchemeChart);
        } else {
            Chart chart = this.frameSchemeChart.chartJPanel.chart;
            SchemeBlock block = (SchemeBlock)chart.blocks.get(0);
            for (CompositeStandard compositeStandard : std) {
                if (compositeStandard == null) continue;
                compositeStandard.loadEvents();
                block.addCompositeStandard(compositeStandard, this.sbdb);
            }
            for (CompositeStandard compositeStandard : schemes) {
                if (compositeStandard == null) continue;
                block.addScheme((IGDScheme)compositeStandard);
            }
            if (ageCurve != null) {
                block.addAgeCurve(ageCurve);
            }
            this.frameSchemeChart.chartJPanel.chart.calcChartSize();
            GUI.setScrollPaneSize(this.frameSchemeChart.chartJPanel, this.frameSchemeChart.chartJPanel.zoom, 1.5f);
        }
        this.frameSchemeChart.setVisible(true);
        if (this.frameSchemeChart.isIcon()) {
            try {
                this.frameSchemeChart.setIcon(false);
            }
            catch (PropertyVetoException e) {
                SB.showStackError((String)"", (Exception)e);
            }
        }
    }
}

