/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.reprisesoftware.rlm.RlmException;
import com.reprisesoftware.rlm.RlmHandle;
import com.reprisesoftware.rlm.RlmLicense;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import jsbugs.ConnectionParameters;
import jsbugs.DialogAbnSchemes;
import jsbugs.DialogAutoMergeTaxa;
import jsbugs.DialogChartScales;
import jsbugs.DialogConnect;
import jsbugs.DialogConnectionManager;
import jsbugs.DialogDBInfo;
import jsbugs.DialogEventPrefix;
import jsbugs.DialogHelpAbout;
import jsbugs.DialogLicenceCheck;
import jsbugs.DialogLogDefs;
import jsbugs.DialogManageImages;
import jsbugs.DialogMiscColours;
import jsbugs.DialogRLMRoam;
import jsbugs.DialogRefresh;
import jsbugs.DialogSBChartLogPath;
import jsbugs.DialogSBLogin;
import jsbugs.DialogSQLQuery;
import jsbugs.DialogSelectAnalyst;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectWell;
import jsbugs.FrameChart;
import jsbugs.FrameInterpretations;
import jsbugs.FrameOrganiser;
import jsbugs.FrameOverlay;
import jsbugs.FrameSamples;
import jsbugs.FrameTaxaDB;
import jsbugs.FrameWells;
import jsbugs.JPanelWell;
import jsbugs.Jsbugs;
import model2.Lastval;
import model2.Licence;
import model2.Project;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.BareBonesBrowserLaunch;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class FrameJsbugs
extends JFrame {
    SBdb sbdb = null;
    FrameSamples samplesFrame = null;
    HashSet<FrameOrganiser> organiserFrames = new HashSet();
    FrameChart chartFrame = null;
    FrameWells wellsFrame = null;
    FrameTaxaDB taxadbFrame = null;
    private FrameOverlay frameOverlay = null;
    FrameInterpretations interpretationsFrame = null;
    private Project project;
    SimpleDateFormat refreshTimeFormat = new SimpleDateFormat("HH:mm:ss");
    Image backgroundImage;
    private SwingWorker dataRefreshTask = null;
    static final String WWW_HELP_PATH = "http://www.stratadata.co.uk/StrataBugs/v2.0/help/";
    static String helpRoot = "http://www.stratadata.co.uk/StrataBugs/v2.0/help/";
    static final String HELP_PREF = "help_path";
    List<Image> imageList = new LinkedList<Image>();
    RlmHandle handle = null;
    RlmLicense license = null;
    boolean licenseIsServed = false;
    Date licenseBeatfailure = null;
    final long licenseMaxTimeout = 1800L;
    private static String product = "StrataBugs";
    private static String ver = "2.0";
    private static int count = 1;
    private static int productType = 4;
    static ConnectionParameters parms = null;
    static final String LIC_FAIL_STRING = "StrataBugs licence no longer available.";
    private ButtonGroup buttonGroupEnvPref;
    private ButtonGroup buttonGroupHelpLocation;
    private ButtonGroup buttonGroupLGSSamplePrec;
    private ButtonGroup buttonGroupSampleDepths;
    private ButtonGroup buttonGroupSizes;
    private JButton jButtonCharts;
    private JButton jButtonInt;
    private JButton jButtonOrganiser;
    private JButton jButtonSamples;
    private JButton jButtonTaxaDB;
    private JButton jButtonWells;
    private JCheckBoxMenuItem jCheckBoxMenuItemExportSingleUser;
    private JCheckBoxMenuItem jCheckBoxMenuItemSQLtoCmd;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelDB;
    private JLabel jLabelLicencee;
    private JLabel jLabelLocation;
    private JLabel jLabelRefresh;
    private JLabel jLabelUpdates;
    private JLabel jLabelUser;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenu jMenuConfig;
    private JMenu jMenuEnvEntry;
    private JMenu jMenuExport;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemChartScales;
    private JMenuItem jMenuItemConfigAbn;
    private JMenuItem jMenuItemConfigPersonnel;
    private JMenuItem jMenuItemConnect;
    private JMenuItem jMenuItemContents;
    private JMenuItem jMenuItemCopyDatabase;
    private JMenuItem jMenuItemDBInfo;
    private JMenuItem jMenuItemEditWirelineLogPaths;
    private JMenuItem jMenuItemEventPrefix;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportABR;
    private JMenuItem jMenuItemGrants;
    private JMenuItem jMenuItemHelpAbout;
    private JMenuItem jMenuItemHelpCP;
    private JMenuItem jMenuItemImageStorage;
    private JMenuItem jMenuItemLoad;
    private JMenuItem jMenuItemLogDef;
    private JMenuItem jMenuItemManageConnections;
    private JMenuItem jMenuItemMergeDuplicateEvents;
    private JMenuItem jMenuItemMiscColours;
    private JMenuItem jMenuItemNullBaseDepths;
    private JMenuItem jMenuItemNullTopDepths;
    private JMenuItem jMenuItemQuery;
    private JMenuItem jMenuItemRLMRoam;
    private JMenuItem jMenuItemRefresh;
    private JMenuItem jMenuItemSBUpdate;
    private JMenuItem jMenuItemScreen;
    private JMenuItem jMenuItemSpro;
    private JMenuItem jMenuItemautoMergeTaxa;
    private JMenu jMenuSampleDepths;
    private JMenu jMenuSetHelpLocation;
    private JMenu jMenuTools;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelInfo;
    private JPanel jPanelInt;
    private JPanel jPanelSamples;
    private JPanel jPanelTaxaDB;
    private JPanel jPanelWells;
    private JRadioButtonMenuItem jRadioButtonMenuItemDepthsBase;
    private JRadioButtonMenuItem jRadioButtonMenuItemDepthsTop;
    private JRadioButtonMenuItem jRadioButtonMenuItemGuiSizes100;
    private JRadioButtonMenuItem jRadioButtonMenuItemGuiSystem;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpLocalFF;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpLocalFolder;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpLocalIE;
    private JRadioButtonMenuItem jRadioButtonMenuItemHelpWeb;
    private JRadioButtonMenuItem jRadioButtonMenuItemLOG1;
    private JRadioButtonMenuItem jRadioButtonMenuItemLOG2;
    private JRadioButtonMenuItem jRadioButtonMenuItemLOG3;
    private JRadioButtonMenuItem jRadioButtonMenuItemMultiple;
    private JRadioButtonMenuItem jRadioButtonMenuItemSingle;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;

    static String getVersion() {
        return ver;
    }

    public FrameJsbugs() {
        this.preComponentInit();
        this.initComponents();
        this.init();
        this.getRlmLicence();
        if (this.license != null && this.license.daysToExpiration() > 0 && this.license.daysToExpiration() < 30) {
            String string = "" + (this.license.daysToExpiration() - 1) + " day(s) remaining with current licence.";
            string = this.license.isRoaming() ? string + "\n(Roaming licence checked out from server)" : string + "\nContact StrataData now for licence renewal.";
            JOptionPane.showMessageDialog(null, string, "StrataBugs", 2);
        }
        try {
            this.connect(false, false);
            this.project = this.sbdb.getProject(0);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "SQL Error: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
            System.exit(1);
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
            System.exit(1);
        }
        this.setUpdatesLabel();
        this.setExportDataMenu();
    }

    private void setUpdatesLabel() {
        int _30_DAYS = 720;
        int hours = this.checkForUpdate("prod");
        if (hours > 0) {
            this.jLabelUpdates.setText("Update available");
            if (hours < 720) {
                this.jLabelUpdates.setForeground(new Color(51, 102, 204));
            } else {
                this.jLabelUpdates.setForeground(new Color(200, 0, 0));
            }
            int days = hours / 24;
            this.jLabelUpdates.setToolTipText("<html>" + days + " days since last update.<br/>Download updates using the Updater button on www.stratadata.co.uk</html>");
        } else {
            hours = this.checkForUpdate("test");
            if (hours > 0) {
                this.jLabelUpdates.setText("Test update available");
                if (hours < 720) {
                    this.jLabelUpdates.setForeground(new Color(51, 102, 204));
                } else {
                    this.jLabelUpdates.setForeground(new Color(200, 0, 0));
                }
                int days = hours / 24;
                this.jLabelUpdates.setToolTipText("<html>" + days + " days since last update.<br/>Download updates using the Updater button on www.stratadata.co.uk</html>");
            } else {
                this.jLabelUpdates.setText(" ");
            }
        }
    }

    private void checkLicenceTable() throws SQLException {
        String licenseText;
        if (this.license.getCustomer() != null && (licenseText = this.license.getCustomer()).length() > 0) {
            Licence SBlicence = this.sbdb.licence;
            int breakIndex = licenseText.indexOf(47);
            if (breakIndex > 0) {
                String rlmCompany = licenseText.substring(0, breakIndex);
                String rlmLocation = licenseText.substring(breakIndex + 1);
                if (!SBlicence.getCompany().equals(rlmCompany) || !SBlicence.getLocation().equals(rlmLocation)) {
                    SBlicence.setLicence(rlmCompany, rlmLocation);
                    this.sbdb.commit();
                }
            }
        }
    }

    final void getRlmLicence() {
        String licFileMsg = "";
        try {
            this.handle = new RlmHandle(".", "", "");
            if (this.handle == null) {
                System.out.println("Null handle returned from RLMHandle");
                System.exit(1);
            }
        }
        catch (UnsatisfiedLinkError e) {
            JOptionPane.showMessageDialog(this, "Cannot load RLM library: " + e.getMessage(), "StrataBugs", 0);
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (RlmException e) {
            JOptionPane.showMessageDialog(this, "Error fetching licence handle: " + e.getMessage(), "StrataBugs", 0);
            System.out.println(e.getMessage());
            System.exit(1);
        }
        try {
            this.license = new RlmLicense(this.handle, product, ver, count);
            if (this.license.getMaxRoam() > 0 & this.license.getMaxRoamCount() > 0 && this.license.getIssuer().equalsIgnoreCase("user_roam")) {
                this.jMenuItemRLMRoam.setEnabled(true);
            }
            System.out.println("License expiration date: " + this.license.getExpiration());
            System.out.println("Maximum share: " + this.license.getMaxShare());
            System.out.println("License is roaming: " + this.license.isRoaming());
        }
        catch (RlmException e) {
            String[] hostIDs;
            String hostID = "";
            for (String s : hostIDs = this.handle.getAllHostIDs(1)) {
                hostID = hostID + s;
                hostID = hostID + " ";
            }
            hostIDs = this.handle.getAllHostIDs(3);
            if (hostID.length() > 0) {
                hostID = hostID + "/ ";
            }
            for (String s : hostIDs) {
                hostID = hostID + s;
                hostID = hostID + " ";
            }
            e.printStackTrace();
            DialogLicenceCheck dialog = new DialogLicenceCheck(null, true, e.getMessage(), hostID);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    public boolean isDemoLicense() {
        int type = this.license.getType();
        switch (type) {
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    boolean checkRLMlicence() {
        if (this.license == null) {
            this.getRlmLicence();
            if (this.license == null) {
                return false;
            }
        }
        try {
            if (this.license.getServer() != null && !this.license.getServer().isEmpty()) {
                System.out.println("License server: " + this.license.getServer());
                this.licenseIsServed = true;
            }
            if (this.license.getAttrHealth() == 0) {
                this.licenseBeatfailure = null;
                return true;
            }
            if (!this.licenseIsServed) {
                return false;
            }
            if (this.licenseBeatfailure == null) {
                this.licenseBeatfailure = new Date();
                System.out.println("Missed licence check from server at: " + this.licenseBeatfailure);
            } else if (this.licenseBeatfailure.getTime() < System.currentTimeMillis() - 1800000L) {
                this.licenseBeatfailure = null;
                this.license.checkin();
                this.getRlmLicence();
            } else {
                System.out.println("Missed further licence check from server at: " + new Date());
            }
            return true;
        }
        catch (RlmException rlmx) {
            JOptionPane.showMessageDialog(this, "Exception when checking RLM licence: " + rlmx.toString(), this.getTitle(), 1);
            rlmx.printStackTrace();
            return false;
        }
    }

    void addSamplesWell(Well well, boolean makeVisible) throws SQLException, SBException {
        if (this.samplesFrame == null) {
            this.samplesFrame = new FrameSamples(this, this.sbdb, well, false);
        } else {
            this.samplesFrame.addWellTab(well);
        }
        if (makeVisible) {
            this.samplesFrame.setVisible(true);
        }
    }

    void setSamplesSmpdtl(Well well, Smpdtl smpdtl) throws SQLException, SBException {
        this.addSamplesWell(well, true);
        JPanelWell wellPanel = this.samplesFrame.addWellTab(well);
        this.samplesFrame.setSelectedWellTab(wellPanel);
        wellPanel.setSmpdtl(smpdtl);
    }

    void setSamplesWell(Well well) throws SQLException, SBException {
        this.addSamplesWell(well, true);
        JPanelWell wellPanel = this.samplesFrame.addWellTab(well);
    }

    void setProject(Project project) {
        this.project = project;
    }

    final void connect(boolean force, boolean alwaysShowLoginDialog) throws SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            if (!force && JOptionPane.showConfirmDialog(this, "Close current connection?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            if (this.dataRefreshTask != null) {
                this.dataRefreshTask.cancel(true);
            }
            try {
                this.sbdb.commit();
                this.sbdb.close();
            }
            catch (SQLException ex) {
                System.out.println("Error closing existing connection: " + ex.getMessage());
                ex.printStackTrace();
            }
            this.sbdb = null;
            if (this.interpretationsFrame != null) {
                this.interpretationsFrame.dispose();
                this.interpretationsFrame = null;
            }
            if (this.wellsFrame != null) {
                this.wellsFrame.dispose();
                this.wellsFrame = null;
            }
            if (this.samplesFrame != null) {
                this.samplesFrame.dispose();
                this.samplesFrame = null;
            }
            if (this.chartFrame != null) {
                this.chartFrame.dispose();
                this.chartFrame = null;
            }
            for (FrameOrganiser frame : this.organiserFrames) {
                frame.dispose();
            }
            this.organiserFrames.clear();
            if (this.frameOverlay != null) {
                this.frameOverlay.dispose();
                this.frameOverlay = null;
            }
        }
        int attempts = 0;
        boolean silent = false;
        String DSN = null;
        Object tablePrefix = null;
        String UID = null;
        String pwd = null;
        boolean saveUID = false;
        Preferences prefRoot = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0");
        if (!alwaysShowLoginDialog && (silent = prefRoot.getBoolean("silent", false))) {
            DSN = prefRoot.get("sbdsn", null);
            if (DSN != null) {
                Preferences pref = prefRoot.node(DSN);
                UID = pref.get("uid", null);
                pwd = pref.get("pwd", null);
            } else {
                silent = false;
            }
        }
        while (true) {
            DialogConnect dialog = new DialogConnect((Frame)this, true);
            if (!silent) {
                SB.centreDialog((Dialog)dialog);
                dialog.setVisible(true);
                if (dialog.parms == null) {
                    System.exit(0);
                }
            }
            parms = dialog.parms;
            try {
                this.sbdb = new SBdb();
                this.sbdb.connect(FrameJsbugs.parms.driverName, FrameJsbugs.parms.hostName, FrameJsbugs.parms.instanceName == null ? null : FrameJsbugs.parms.instanceName + (FrameJsbugs.parms.SQLServerIntegratedSecurity ? ";integratedSecurity=true" : ""), FrameJsbugs.parms.UID, FrameJsbugs.parms.pwd);
                if (!this.sbdb.validSchema()) {
                    throw new SBException("Connection sucessful but schema invalid. (Cannot access PREF_SYSTEM table)");
                }
            }
            catch (Exception e) {
                if (attempts < 3) {
                    silent = false;
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Error getting database connection: " + e.getMessage(), this.getTitle(), 0);
                    ++attempts;
                    continue;
                }
                JOptionPane.showMessageDialog(this, "Error getting database connection: " + e.getMessage() + "\nStrataBugs will exit", this.getTitle(), 1);
                System.exit(1);
                continue;
            }
            break;
        }
        try {
            String abr = this.sbdb.getDefaultUser(FrameJsbugs.parms.UID);
            boolean silentsblogon = false;
            if (abr != null) {
                alwaysShowLoginDialog = false;
                silentsblogon = true;
                FrameJsbugs.parms.sbUID = abr;
                prefRoot.remove("silentsblogin");
            }
            if (!silentsblogon) {
                silentsblogon = prefRoot.getBoolean("silentsblogin", false);
            }
            boolean loggedIn = false;
            if (!alwaysShowLoginDialog && silentsblogon) {
                try {
                    loggedIn = this.sbdb.login(FrameJsbugs.parms.sbUID, FrameJsbugs.parms.sbPwd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    loggedIn = false;
                }
            }
            if (!loggedIn) {
                DialogSBLogin dialog = new DialogSBLogin((Frame)this, true, parms, this.sbdb);
                SB.centreDialog((Dialog)dialog);
                dialog.setVisible(true);
                if (!dialog.isOK) {
                    System.exit(0);
                }
            }
            this.checkLicenceTable();
            this.jLabelUser.setText(this.sbdb.getUser().getNameID());
            this.jLabelLicencee.setText(this.sbdb.licence.getCompany());
            this.jLabelLocation.setText(this.sbdb.licence.getLocation());
            this.jLabelDB.setText(FrameJsbugs.parms.name);
            this.setCurrent();
            Taxon.includeAuthorInString = Lastval.getInt((SBdb)this.sbdb, (String)"TAXONAUTH") > 0;
            Taxon.includeCategoryInString = Lastval.getInt((SBdb)this.sbdb, (String)"TAXONCAT") > 0;
            Taxon.includeAlphaInString = Lastval.getInt((SBdb)this.sbdb, (String)"TAXONALPHA") > 0;
            this.setSampleTops();
            this.sbdb.monitorInterval = Lastval.getInt((SBdb)this.sbdb, (String)"DMONITOR") * 1000;
            this.setLogDp();
            this.startRefresh();
        }
        catch (SQLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error getting database connection: " + e.getMessage() + "\nSQL: " + SB.sql, this.getTitle(), 0);
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error getting database connection: " + e.getMessage(), this.getTitle(), 0);
            System.exit(1);
        }
    }

    private int checkForUpdate(String release) {
        String[] module = new String[]{"jsbugs2_0.jar", "Model2.jar"};
        boolean[] inLib = new boolean[]{false, true};
        try {
            for (int i = 0; i < module.length; ++i) {
                Date releasedDate;
                URL releasedFile = this.makeURL(release, module[i]);
                System.out.println("Checking connection for: " + releasedFile);
                HttpURLConnection conn = (HttpURLConnection)releasedFile.openConnection();
                System.out.println("Opened connection...");
                File currentFile = new File(inLib[i] ? "lib/" + module[i] : module[i]);
                if (!currentFile.exists()) {
                    System.out.println("Update check - can't find file: " + currentFile);
                    return 0;
                }
                Date localDate = new Date(currentFile.lastModified());
                int timeOut = 1000;
                conn.setConnectTimeout(timeOut);
                conn.setReadTimeout(timeOut);
                System.out.println("Getting conn.getLastModified()");
                if (conn.getLastModified() == 0L || (releasedDate = new Date(conn.getLastModified())).getTime() <= localDate.getTime() + 3600000L) continue;
                return (int)((releasedDate.getTime() - localDate.getTime()) / 3600000L);
            }
        }
        catch (Exception ex) {
            System.out.println("Error checking for update.");
            ex.printStackTrace();
        }
        return 0;
    }

    URL makeURL(String release, String module) throws Exception {
        return new URL("http://www.stratadata.co.uk/StrataBugs/v2.0/" + release + "/" + module);
    }

    private void startRefresh() {
        if (this.sbdb.monitorInterval > 0L) {
            this.jLabelRefresh.setForeground(Color.BLACK);
            this.dataRefreshTask = new SwingWorker(){

                public Object doInBackground() {
                    try {
                        while (!this.isCancelled()) {
                            FrameJsbugs.this.jLabelRefresh.setText("Refreshing...");
                            Date time = new Date();
                            System.out.println("Refreshing data...." + time);
                            FrameJsbugs.this.sbdb.refresh();
                            System.out.print("...done.");
                            FrameJsbugs.this.jLabelRefresh.setText("Updated: " + FrameJsbugs.this.refreshTimeFormat.format(time));
                            System.out.flush();
                            Thread.sleep(FrameJsbugs.this.sbdb.monitorInterval);
                        }
                    }
                    catch (InterruptedException ex) {
                        System.out.println("Interrupted sleeping data refresh task");
                        FrameJsbugs.this.jLabelRefresh.setText("Data refresh interrupted");
                    }
                    catch (SBException sbe) {
                        SB.showStackError((String)"Error during data refresh", (Exception)((Object)sbe));
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error during data refresh", sql, FrameJsbugs.this.sbdb);
                    }
                    catch (RuntimeException re) {
                        SB.showStackError((String)"Error during data refresh", (Exception)re);
                        FrameJsbugs.this.jLabelRefresh.setText("Data refresh error");
                    }
                    return null;
                }
            };
            this.dataRefreshTask.execute();
        } else {
            SBdb.DBType dBType = this.sbdb.getDBType();
            this.sbdb.getDBType();
            if (dBType == SBdb.DBType.MSSQLSERVER) {
                this.jLabelRefresh.setForeground(Color.BLACK);
                this.dataRefreshTask = new SwingWorker(){

                    public Object doInBackground() {
                        try {
                            while (!this.isCancelled()) {
                                FrameJsbugs.this.jLabelRefresh.setText("Refreshing taxa...");
                                Date time = new Date();
                                System.out.println("Refreshing taxa...." + time);
                                FrameJsbugs.this.sbdb.refreshTaxa();
                                System.out.print("...done.");
                                FrameJsbugs.this.jLabelRefresh.setText("Updated taxa: " + FrameJsbugs.this.refreshTimeFormat.format(time));
                                System.out.flush();
                                Thread.sleep(FrameJsbugs.this.sbdb.taxaMonitorInterval);
                            }
                        }
                        catch (InterruptedException ex) {
                            System.out.println("Interrupted sleeping taxa refresh task");
                            FrameJsbugs.this.jLabelRefresh.setText("Taxa refresh interrupted");
                        }
                        catch (SBException sbe) {
                            SB.showStackError((String)"Error during taxa refresh", (Exception)((Object)sbe));
                        }
                        catch (SQLException sql) {
                            FrameJsbugs.showStackError("SQL Error during taxa refresh", sql, FrameJsbugs.this.sbdb);
                        }
                        catch (RuntimeException re) {
                            SB.showStackError((String)"Error during taxa refresh", (Exception)re);
                            FrameJsbugs.this.jLabelRefresh.setText("Taxa refresh error");
                        }
                        return null;
                    }
                };
                this.dataRefreshTask.execute();
            } else {
                this.jLabelRefresh.setText("Data refresh off");
                this.jLabelRefresh.setForeground(Color.gray);
            }
        }
    }

    private void preComponentInit() {
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/ControlPanel.gif"));
    }

    static void openHelp(String page) {
        try {
            if (helpRoot.startsWith("file:///")) {
                String file = helpRoot.substring("file:///".length()) + page;
                if (!new File(file).exists()) {
                    JOptionPane.showMessageDialog(null, "Help page '" + file + "' does not exist.", "StrataBugs Help", 2);
                    return;
                }
            } else if (!helpRoot.startsWith("http://127.0.0.1:8082/resource/jar:file:/") && helpRoot.startsWith("jar:file:/")) {
                Runtime.getRuntime().exec("\"C:\\Program Files\\Mozilla firefox\\firefox.exe\"  \"" + helpRoot + page + " \"");
                return;
            }
            URL url = new URL(helpRoot + page);
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void init() {
        this.setTitle("StrataBugs");
        this.createImageList();
        this.setIconImages(this.imageList);
        String userHelpPath = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").get(HELP_PREF, "");
        if (userHelpPath != null && userHelpPath.length() > 0) {
            if (userHelpPath.startsWith("http://")) {
                this.jRadioButtonMenuItemHelpLocalIE.setSelected(true);
                helpRoot = userHelpPath;
            } else if (userHelpPath.startsWith("jar:file:")) {
                this.jRadioButtonMenuItemHelpLocalFF.setSelected(true);
                helpRoot = userHelpPath;
            } else {
                String filePath = userHelpPath.substring("file:///".length());
                if (new File(filePath).exists()) {
                    helpRoot = userHelpPath;
                    this.jRadioButtonMenuItemHelpLocalFolder.setSelected(true);
                } else {
                    Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").remove(HELP_PREF);
                    this.jRadioButtonMenuItemHelpWeb.setSelected(true);
                }
            }
        } else {
            this.jRadioButtonMenuItemHelpWeb.setSelected(true);
        }
        boolean resizegui = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").getBoolean("resizegui", true);
        this.jRadioButtonMenuItemGuiSizes100.setSelected(resizegui);
        this.jRadioButtonMenuItemGuiSystem.setSelected(!resizegui);
        System.out.print("Max Memory       : ");
        System.out.format("%,d%n", Runtime.getRuntime().maxMemory());
        UIManager.put("List.timeFactor", 500L);
    }

    void setSampleTops() {
        if (this.sbdb != null) {
            if (this.sbdb.useSampleTops()) {
                this.jRadioButtonMenuItemDepthsTop.setSelected(true);
            } else {
                this.jRadioButtonMenuItemDepthsBase.setSelected(true);
            }
        }
    }

    void setLogDp() {
        try {
            int dp = Sample.getLogDp((SBdb)this.sbdb);
            switch (dp) {
                case 1: {
                    this.jRadioButtonMenuItemLOG1.setSelected(true);
                    break;
                }
                case 2: {
                    this.jRadioButtonMenuItemLOG2.setSelected(true);
                    break;
                }
                case 3: {
                    this.jRadioButtonMenuItemLOG3.setSelected(true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setenvPref() {
        if (this.sbdb != null) {
            if (this.sbdb.allowMultipleEnvSchemes()) {
                this.jRadioButtonMenuItemMultiple.setSelected(true);
            } else {
                this.jRadioButtonMenuItemSingle.setSelected(true);
            }
        }
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.buttonGroupHelpLocation = new ButtonGroup();
        this.buttonGroupSampleDepths = new ButtonGroup();
        this.buttonGroupLGSSamplePrec = new ButtonGroup();
        this.buttonGroupEnvPref = new ButtonGroup();
        this.buttonGroupSizes = new ButtonGroup();
        this.jPanel2 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                boolean fullyLoaded = g.drawImage(FrameJsbugs.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonTaxaDB = new JButton();
        this.jButtonCharts = new JButton();
        this.jButtonSamples = new JButton();
        this.jButtonWells = new JButton();
        this.jLabel1 = new JLabel();
        this.jButtonInt = new JButton();
        this.jButtonOrganiser = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabelRefresh = new JLabel();
        this.jPanelInfo = new JPanel();
        this.jLabelLicencee = new JLabel();
        this.jLabelUser = new JLabel();
        this.jLabelLocation = new JLabel();
        this.jLabelDB = new JLabel();
        this.jLabelUpdates = new JLabel();
        this.jPanelTaxaDB = new JPanel();
        this.jLabel6 = new JLabel();
        this.jPanelInt = new JPanel();
        this.jLabel7 = new JLabel();
        this.jPanelWells = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanelSamples = new JPanel();
        this.jLabel2 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemConnect = new JMenuItem();
        this.jMenuItemManageConnections = new JMenuItem();
        this.jMenuItemLoad = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuConfig = new JMenu();
        this.jMenuItemRefresh = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemConfigAbn = new JMenuItem();
        this.jMenuItemConfigPersonnel = new JMenuItem();
        this.jMenuItemLogDef = new JMenuItem();
        this.jMenuItemMiscColours = new JMenuItem();
        this.jMenuItemChartScales = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuSampleDepths = new JMenu();
        this.jRadioButtonMenuItemDepthsTop = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemDepthsBase = new JRadioButtonMenuItem();
        this.jMenu3 = new JMenu();
        this.jRadioButtonMenuItemLOG1 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemLOG2 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemLOG3 = new JRadioButtonMenuItem();
        this.jMenuItemImageStorage = new JMenuItem();
        this.jMenuExport = new JMenu();
        this.jCheckBoxMenuItemExportSingleUser = new JCheckBoxMenuItem();
        this.jMenuItemExportABR = new JMenuItem();
        this.jMenuItemEventPrefix = new JMenuItem();
        this.jMenuEnvEntry = new JMenu();
        this.jRadioButtonMenuItemSingle = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemMultiple = new JRadioButtonMenuItem();
        this.jMenu4 = new JMenu();
        this.jRadioButtonMenuItemGuiSizes100 = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemGuiSystem = new JRadioButtonMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemRLMRoam = new JMenuItem();
        this.jMenuItemSpro = new JMenuItem();
        this.jMenuItemScreen = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemSBUpdate = new JMenuItem();
        this.jMenuTools = new JMenu();
        this.jMenuItemQuery = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemCopyDatabase = new JMenuItem();
        this.jMenuItemGrants = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jCheckBoxMenuItemSQLtoCmd = new JCheckBoxMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItemNullTopDepths = new JMenuItem();
        this.jMenuItemNullBaseDepths = new JMenuItem();
        this.jMenuItemautoMergeTaxa = new JMenuItem();
        this.jMenuItemMergeDuplicateEvents = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemEditWirelineLogPaths = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemContents = new JMenuItem();
        this.jMenuItemHelpCP = new JMenuItem();
        this.jMenuSetHelpLocation = new JMenu();
        this.jRadioButtonMenuItemHelpWeb = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemHelpLocalIE = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemHelpLocalFF = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemHelpLocalFolder = new JRadioButtonMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuItemDBInfo = new JMenuItem();
        this.jMenuItemHelpAbout = new JMenuItem();
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(0);
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrameJsbugs.this.formWindowClosing(evt);
            }
        });
        this.jButtonTaxaDB.setFont(new Font("Tahoma", 1, 12));
        this.jButtonTaxaDB.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameJsbugs_jButtonTaxaDB.png")));
        this.jButtonTaxaDB.setHorizontalTextPosition(0);
        this.jButtonTaxaDB.setIconTextGap(8);
        this.jButtonTaxaDB.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonTaxaDB.setMultiClickThreshhold(1000L);
        this.jButtonTaxaDB.setPreferredSize(new Dimension(73, 107));
        this.jButtonTaxaDB.setRequestFocusEnabled(false);
        this.jButtonTaxaDB.setVerticalTextPosition(3);
        this.jButtonTaxaDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jButtonTaxaDBActionPerformed(evt);
            }
        });
        this.jButtonCharts.setFont(new Font("Tahoma", 1, 12));
        this.jButtonCharts.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameJsbugs_jButtonCharts.png")));
        this.jButtonCharts.setHorizontalAlignment(2);
        this.jButtonCharts.setHorizontalTextPosition(4);
        this.jButtonCharts.setIconTextGap(8);
        this.jButtonCharts.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonCharts.setMultiClickThreshhold(1000L);
        this.jButtonCharts.setPreferredSize(new Dimension(149, 61));
        this.jButtonCharts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jButtonChartsActionPerformed(evt);
            }
        });
        this.jButtonSamples.setFont(new Font("Tahoma", 1, 12));
        this.jButtonSamples.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameJsbugs_jButtonSamples.png")));
        this.jButtonSamples.setHorizontalTextPosition(0);
        this.jButtonSamples.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonSamples.setMultiClickThreshhold(1000L);
        this.jButtonSamples.setPreferredSize(new Dimension(73, 107));
        this.jButtonSamples.setVerticalTextPosition(3);
        this.jButtonSamples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jButtonSamplesActionPerformed(evt);
            }
        });
        this.jButtonWells.setFont(new Font("Tahoma", 1, 12));
        this.jButtonWells.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameJsbugs_jButtonWells.png")));
        this.jButtonWells.setHorizontalTextPosition(0);
        this.jButtonWells.setInheritsPopupMenu(true);
        this.jButtonWells.setMargin(new Insets(4, 4, 4, 4));
        this.jButtonWells.setMultiClickThreshhold(1000L);
        this.jButtonWells.setPreferredSize(new Dimension(73, 107));
        this.jButtonWells.setVerticalTextPosition(3);
        this.jButtonWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jButtonWellsActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setText("Charts");
        this.jButtonInt.setFont(new Font("Tahoma", 1, 12));
        this.jButtonInt.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameJsbugs_jButtonInt.png")));
        this.jButtonInt.setHorizontalTextPosition(4);
        this.jButtonInt.setIconTextGap(8);
        this.jButtonInt.setMargin(new Insets(4, 2, 4, 2));
        this.jButtonInt.setMultiClickThreshhold(1000L);
        this.jButtonInt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jButtonIntActionPerformed(evt);
            }
        });
        this.jButtonOrganiser.setFont(new Font("Tahoma", 1, 12));
        this.jButtonOrganiser.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameJsbugs_jButtonOrganiser.png")));
        this.jButtonOrganiser.setHorizontalAlignment(2);
        this.jButtonOrganiser.setIconTextGap(8);
        this.jButtonOrganiser.setMargin(new Insets(2, 2, 2, 14));
        this.jButtonOrganiser.setMultiClickThreshhold(1000L);
        this.jButtonOrganiser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jButtonOrganiserActionPerformed(evt);
            }
        });
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 1, this.jLabel5.getFont().getSize() + 2));
        this.jLabel5.setText("Organiser");
        this.jLabelRefresh.setFont(this.jLabelRefresh.getFont());
        this.jLabelRefresh.setText("refresh time");
        this.jPanelInfo.setBackground(new Color(244, 245, 243));
        this.jPanelInfo.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelInfo.setOpaque(false);
        this.jLabelLicencee.setHorizontalAlignment(0);
        this.jLabelLicencee.setText("licencee");
        this.jLabelUser.setFont(this.jLabelUser.getFont().deriveFont(this.jLabelUser.getFont().getStyle() | 1, this.jLabelUser.getFont().getSize() + 1));
        this.jLabelUser.setHorizontalAlignment(0);
        this.jLabelUser.setText("user");
        this.jLabelLocation.setHorizontalAlignment(0);
        this.jLabelLocation.setText("location");
        this.jLabelDB.setHorizontalAlignment(0);
        this.jLabelDB.setText("database");
        GroupLayout jPanelInfoLayout = new GroupLayout((Container)this.jPanelInfo);
        this.jPanelInfo.setLayout((LayoutManager)jPanelInfoLayout);
        jPanelInfoLayout.setHorizontalGroup((GroupLayout.Group)jPanelInfoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInfoLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelInfoLayout.createParallelGroup(1).add((Component)this.jLabelLocation, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelUser, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jLabelDB, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelLicencee, -1, -1, Short.MAX_VALUE)).add(11, 11, 11)));
        jPanelInfoLayout.setVerticalGroup((GroupLayout.Group)jPanelInfoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelInfoLayout.createSequentialGroup().add(8, 8, 8).add((Component)this.jLabelUser).addPreferredGap(0).add((Component)this.jLabelDB).addPreferredGap(0).add((Component)this.jLabelLicencee, -2, 14, -2).addPreferredGap(0).add((Component)this.jLabelLocation).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelInfoLayout.linkSize(new Component[]{this.jLabelDB, this.jLabelLicencee, this.jLabelLocation, this.jLabelUser}, 2);
        this.jLabelUpdates.setFont(this.jLabelUpdates.getFont().deriveFont(this.jLabelUpdates.getFont().getStyle() | 1));
        this.jLabelUpdates.setHorizontalAlignment(11);
        this.jLabelUpdates.setText("No update available");
        this.jPanelTaxaDB.setOpaque(false);
        this.jPanelTaxaDB.setLayout(new BorderLayout());
        this.jLabel6.setFont(this.jLabel6.getFont().deriveFont(this.jLabel6.getFont().getStyle() | 1, this.jLabel6.getFont().getSize() + 2));
        this.jLabel6.setText("<html>Taxonomic<br>Database</html>");
        this.jPanelTaxaDB.add((Component)this.jLabel6, "Center");
        this.jPanelInt.setOpaque(false);
        this.jPanelInt.setLayout(new BorderLayout());
        this.jLabel7.setFont(this.jLabel7.getFont().deriveFont(this.jLabel7.getFont().getStyle() | 1, this.jLabel7.getFont().getSize() + 2));
        this.jLabel7.setText("<html>Schemes<br>& Interpretations</html>");
        this.jPanelInt.add((Component)this.jLabel7, "Center");
        this.jPanelWells.setOpaque(false);
        this.jPanelWells.setLayout(new BorderLayout());
        this.jLabel4.setFont(this.jLabel4.getFont().deriveFont(this.jLabel4.getFont().getStyle() | 1, this.jLabel4.getFont().getSize() + 2));
        this.jLabel4.setText("<html> Wells <br> & Outcrops </html>");
        this.jPanelWells.add((Component)this.jLabel4, "Center");
        this.jPanelSamples.setOpaque(false);
        this.jPanelSamples.setLayout(new BorderLayout());
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("<html> Samples <br> & Interpretations </html>");
        this.jPanelSamples.add((Component)this.jLabel2, "Center");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2, false).add(1, (Component)this.jButtonCharts, 0, 0, Short.MAX_VALUE).add(1, (Component)this.jButtonOrganiser, 0, 0, Short.MAX_VALUE).add(1, (Component)this.jButtonTaxaDB, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonInt, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSamples, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonWells, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jLabel5).add((Component)this.jLabel1).add((Component)this.jPanelTaxaDB, -1, -1, Short.MAX_VALUE).add((Component)this.jPanelInt, -1, -1, Short.MAX_VALUE).add((Component)this.jPanelWells, -1, -1, Short.MAX_VALUE)).add(2, (Component)this.jPanelSamples, -2, -1, -2))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabelRefresh).addPreferredGap(0).add((Component)this.jLabelUpdates, -1, -1, Short.MAX_VALUE)).add(2, (Component)this.jPanelInfo, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonWells, -2, 70, -2).add((Component)this.jPanelWells, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonSamples, -2, 70, -2).add((Component)this.jPanelSamples, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonInt, -2, 70, -2).add((Component)this.jPanelInt, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonTaxaDB, -2, 70, -2).add((Component)this.jPanelTaxaDB, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonOrganiser, -1, 70, Short.MAX_VALUE).add((Component)this.jLabel5, -1, -1, Short.MAX_VALUE)).add(5, 5, 5).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jButtonCharts, -1, 70, Short.MAX_VALUE).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jPanelInfo, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelUpdates).add((Component)this.jLabelRefresh)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jMenuFile.setText("File");
        this.jMenuItemConnect.setText("Change database...");
        this.jMenuItemConnect.setToolTipText("Connect to a different StrataBugs database");
        this.jMenuItemConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemConnectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemConnect);
        this.jMenuItemManageConnections.setText("Manage connections...");
        this.jMenuItemManageConnections.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemManageConnectionsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemManageConnections);
        this.jMenuItemLoad.setText("Load entire database into memory");
        this.jMenuItemLoad.setToolTipText("Load the entire database into application (can take a long time)");
        this.jMenuItemLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemLoadActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemLoad);
        this.jMenuFile.add(this.jSeparator4);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.setToolTipText("Close ALL StrataBugs windows and exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuConfig.setText("Config");
        this.jMenuItemRefresh.setText("Set data refresh rate...");
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemRefresh);
        this.jMenuConfig.add(this.jSeparator8);
        this.jMenuItemConfigAbn.setText("Abundance Schemes...");
        this.jMenuItemConfigAbn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemConfigAbnActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemConfigAbn);
        this.jMenuItemConfigPersonnel.setText("Personnel...");
        this.jMenuItemConfigPersonnel.setToolTipText("");
        this.jMenuItemConfigPersonnel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemConfigPersonnelActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemConfigPersonnel);
        this.jMenuItemLogDef.setText("Wireline log header defaults...");
        this.jMenuItemLogDef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemLogDefActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemLogDef);
        this.jMenuItemMiscColours.setText("Misc colours...");
        this.jMenuItemMiscColours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemMiscColoursActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemMiscColours);
        this.jMenuItemChartScales.setText("Depth scales...");
        this.jMenuItemChartScales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemChartScalesActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemChartScales);
        this.jMenuConfig.add(this.jSeparator1);
        this.jMenuSampleDepths.setText("Default Sample depths");
        this.buttonGroupSampleDepths.add(this.jRadioButtonMenuItemDepthsTop);
        this.jRadioButtonMenuItemDepthsTop.setSelected(true);
        this.jRadioButtonMenuItemDepthsTop.setText("Top of range");
        this.jRadioButtonMenuItemDepthsTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemDepthsTopActionPerformed(evt);
            }
        });
        this.jMenuSampleDepths.add(this.jRadioButtonMenuItemDepthsTop);
        this.buttonGroupSampleDepths.add(this.jRadioButtonMenuItemDepthsBase);
        this.jRadioButtonMenuItemDepthsBase.setText("Base of range");
        this.jRadioButtonMenuItemDepthsBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemDepthsBaseActionPerformed(evt);
            }
        });
        this.jMenuSampleDepths.add(this.jRadioButtonMenuItemDepthsBase);
        this.jMenu3.setText("LOG Sample display precision");
        this.buttonGroupLGSSamplePrec.add(this.jRadioButtonMenuItemLOG1);
        this.jRadioButtonMenuItemLOG1.setSelected(true);
        this.jRadioButtonMenuItemLOG1.setText("1 decimal place");
        this.jRadioButtonMenuItemLOG1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemLOG1ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemLOG1);
        this.buttonGroupLGSSamplePrec.add(this.jRadioButtonMenuItemLOG2);
        this.jRadioButtonMenuItemLOG2.setText("2 decimal places");
        this.jRadioButtonMenuItemLOG2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemLOG2ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemLOG2);
        this.buttonGroupLGSSamplePrec.add(this.jRadioButtonMenuItemLOG3);
        this.jRadioButtonMenuItemLOG3.setText("3 decimal places");
        this.jRadioButtonMenuItemLOG3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemLOG3ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jRadioButtonMenuItemLOG3);
        this.jMenuSampleDepths.add(this.jMenu3);
        this.jMenuConfig.add(this.jMenuSampleDepths);
        this.jMenuItemImageStorage.setText("Image storage...");
        this.jMenuItemImageStorage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemImageStorageActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemImageStorage);
        this.jMenuExport.setText("Data export");
        this.jCheckBoxMenuItemExportSingleUser.setSelected(true);
        this.jCheckBoxMenuItemExportSingleUser.setText("Export data as single user");
        this.jCheckBoxMenuItemExportSingleUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jCheckBoxMenuItemExportSingleUserActionPerformed(evt);
            }
        });
        this.jMenuExport.add(this.jCheckBoxMenuItemExportSingleUser);
        this.jMenuItemExportABR.setText("Use abbreviation: ");
        this.jMenuItemExportABR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemExportABRActionPerformed(evt);
            }
        });
        this.jMenuExport.add(this.jMenuItemExportABR);
        this.jMenuConfig.add(this.jMenuExport);
        this.jMenuItemEventPrefix.setText("Event prefixes...");
        this.jMenuItemEventPrefix.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemEventPrefixActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemEventPrefix);
        this.jMenuEnvEntry.setText("Palaeoenvironment entry...");
        this.buttonGroupEnvPref.add(this.jRadioButtonMenuItemSingle);
        this.jRadioButtonMenuItemSingle.setSelected(true);
        this.jRadioButtonMenuItemSingle.setText("Allow only ONE environment scheme per version per well");
        this.jRadioButtonMenuItemSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemSingleActionPerformed(evt);
            }
        });
        this.jMenuEnvEntry.add(this.jRadioButtonMenuItemSingle);
        this.buttonGroupEnvPref.add(this.jRadioButtonMenuItemMultiple);
        this.jRadioButtonMenuItemMultiple.setText("Allow multiple environment schemes per version per well");
        this.jRadioButtonMenuItemMultiple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemMultipleActionPerformed(evt);
            }
        });
        this.jMenuEnvEntry.add(this.jRadioButtonMenuItemMultiple);
        this.jMenuConfig.add(this.jMenuEnvEntry);
        this.jMenu4.setText("Text sizes");
        this.buttonGroupSizes.add(this.jRadioButtonMenuItemGuiSizes100);
        this.jRadioButtonMenuItemGuiSizes100.setSelected(true);
        this.jRadioButtonMenuItemGuiSizes100.setText("Maintain 100%");
        this.jRadioButtonMenuItemGuiSizes100.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemGuiSizes100ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItemGuiSizes100);
        this.buttonGroupSizes.add(this.jRadioButtonMenuItemGuiSystem);
        this.jRadioButtonMenuItemGuiSystem.setText("Use system sizes");
        this.jRadioButtonMenuItemGuiSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemGuiSystemActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jRadioButtonMenuItemGuiSystem);
        this.jMenuConfig.add(this.jMenu4);
        this.jMenuConfig.add(this.jSeparator2);
        this.jMenuItemRLMRoam.setText("License roaming check in/out from server...");
        this.jMenuItemRLMRoam.setToolTipText("Allows licence to be tempoarily checked out of the server (if available)");
        this.jMenuItemRLMRoam.setEnabled(false);
        this.jMenuItemRLMRoam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemRLMRoamActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemRLMRoam);
        this.jMenuItemSpro.setText("Sentinel (dongle) tester...");
        this.jMenuItemSpro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemSproActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemSpro);
        this.jMenuItemScreen.setText("Show screen configuration...");
        this.jMenuItemScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemScreenActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemScreen);
        this.jMenuConfig.add(this.jSeparator3);
        this.jMenuItemSBUpdate.setText("Look for updates...");
        this.jMenuItemSBUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemSBUpdateActionPerformed(evt);
            }
        });
        this.jMenuConfig.add(this.jMenuItemSBUpdate);
        this.jMenuBar1.add(this.jMenuConfig);
        this.jMenuTools.setText("Tools");
        this.jMenuItemQuery.setText("Database query...");
        this.jMenuItemQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemQueryActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemQuery);
        this.jMenuTools.add(this.jSeparator6);
        this.jMenuItemCopyDatabase.setText("Copy Database...");
        this.jMenuItemCopyDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemCopyDatabaseActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemCopyDatabase);
        this.jMenuItemGrants.setText("Add Oracle grants for user...");
        this.jMenuItemGrants.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemGrantsActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemGrants);
        this.jMenu1.setText("Show SQL...");
        this.jCheckBoxMenuItemSQLtoCmd.setText("To Command Window");
        this.jCheckBoxMenuItemSQLtoCmd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jCheckBoxMenuItemSQLtoCmdActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jCheckBoxMenuItemSQLtoCmd);
        this.jMenuTools.add(this.jMenu1);
        this.jMenu2.setText("Set ALL single depth samples to null");
        this.jMenuItemNullTopDepths.setText("top depth");
        this.jMenuItemNullTopDepths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemNullTopDepthsActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemNullTopDepths);
        this.jMenuItemNullBaseDepths.setText("base depth");
        this.jMenuItemNullBaseDepths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemNullBaseDepthsActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemNullBaseDepths);
        this.jMenuTools.add(this.jMenu2);
        this.jMenuItemautoMergeTaxa.setText("Auto merge taxa...");
        this.jMenuItemautoMergeTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemautoMergeTaxaActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemautoMergeTaxa);
        this.jMenuItemMergeDuplicateEvents.setText("Merge duplicate events...");
        this.jMenuItemMergeDuplicateEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemMergeDuplicateEventsActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemMergeDuplicateEvents);
        this.jMenuTools.add(this.jSeparator7);
        this.jMenuItemEditWirelineLogPaths.setText("Change chart external wireline log paths...");
        this.jMenuItemEditWirelineLogPaths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemEditWirelineLogPathsActionPerformed(evt);
            }
        });
        this.jMenuTools.add(this.jMenuItemEditWirelineLogPaths);
        this.jMenuBar1.add(this.jMenuTools);
        this.jMenuHelp.setText("Help");
        this.jMenuItemContents.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jMenuItemContents.setText("Contents...");
        this.jMenuItemContents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemContentsActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemContents);
        this.jMenuItemHelpCP.setText("Control Panel help...");
        this.jMenuItemHelpCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemHelpCPActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpCP);
        this.jMenuSetHelpLocation.setText("Set help location");
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpWeb);
        this.jRadioButtonMenuItemHelpWeb.setSelected(true);
        this.jRadioButtonMenuItemHelpWeb.setText("Web based (requires Internet connection)");
        this.jRadioButtonMenuItemHelpWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemHelpWebActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpWeb);
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpLocalIE);
        this.jRadioButtonMenuItemHelpLocalIE.setText("Local (default browser Internet Explorer etc.)");
        this.jRadioButtonMenuItemHelpLocalIE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemHelpLocalIEActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpLocalIE);
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFF);
        this.jRadioButtonMenuItemHelpLocalFF.setText("Local (default browser Firefox)");
        this.jRadioButtonMenuItemHelpLocalFF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemHelpLocalFFActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFF);
        this.buttonGroupHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFolder);
        this.jRadioButtonMenuItemHelpLocalFolder.setText("Local help folder...");
        this.jRadioButtonMenuItemHelpLocalFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jRadioButtonMenuItemHelpLocalFolderActionPerformed(evt);
            }
        });
        this.jMenuSetHelpLocation.add(this.jRadioButtonMenuItemHelpLocalFolder);
        this.jMenuHelp.add(this.jMenuSetHelpLocation);
        this.jMenuHelp.add(this.jSeparator5);
        this.jMenuItemDBInfo.setText("Describe database...");
        this.jMenuItemDBInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemDBInfoActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemDBInfo);
        this.jMenuItemHelpAbout.setText("About...");
        this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameJsbugs.this.jMenuItemHelpAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpAbout);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -2, -1, -2));
        this.pack();
    }

    private void createImageList() {
        String[] pngs = new String[]{"48Sbugs.png", "32Sbugs.png", "24Sbugs.png", "16Sbugs.png"};
        for (int i = 0; i < pngs.length; ++i) {
            this.imageList.add(Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/FrameIcon_Jsbugs/" + pngs[i])));
        }
    }

    private void jMenuItemHelpAboutActionPerformed(ActionEvent evt) {
        new DialogHelpAbout((Frame)this, true, this.sbdb, this.license != null ? this.license.getExpiration() : "<no licence found>").setVisible(true);
    }

    private void jMenuItemConfigPersonnelActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((Frame)this, true, this.sbdb, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(this, sqle.getMessage() + "\n" + SB.sql, this.getTitle(), 2);
            sqle.printStackTrace();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jMenuItemExitActionPerformed(null);
    }

    private void jButtonIntActionPerformed(ActionEvent evt) {
        try {
            if (!this.checkRLMlicence()) {
                JOptionPane.showMessageDialog(this, LIC_FAIL_STRING, "StrataBugs", 0);
                return;
            }
            if (this.interpretationsFrame == null) {
                this.interpretationsFrame = new FrameInterpretations(this, this.sbdb, this.project);
                SB.centreWindow((Frame)this.interpretationsFrame);
            } else if (this.interpretationsFrame.getState() == 1) {
                this.interpretationsFrame.setState(0);
            }
            this.interpretationsFrame.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 2);
            ex.printStackTrace();
        }
    }

    private void jButtonTaxaDBActionPerformed(ActionEvent evt) {
        try {
            if (!this.checkRLMlicence()) {
                JOptionPane.showMessageDialog(this, LIC_FAIL_STRING, "StrataBugs", 0);
                return;
            }
            if (this.taxadbFrame == null) {
                this.taxadbFrame = new FrameTaxaDB(this, this.sbdb);
                SB.centreWindow((Frame)this.taxadbFrame);
                this.taxadbFrame.setExtendedState(6);
            } else if (this.taxadbFrame.getState() == 1) {
                this.taxadbFrame.setState(0);
            }
            this.taxadbFrame.setVisible(true);
        }
        catch (Exception ex) {
            SB.showStackError((String)("Error opening TaxaDB Frame: " + ex.getMessage()), (Exception)ex);
            ex.printStackTrace();
        }
    }

    void createWellsFrame() {
        try {
            if (!this.checkRLMlicence()) {
                JOptionPane.showMessageDialog(this, LIC_FAIL_STRING, "StrataBugs", 0);
                return;
            }
            if (this.wellsFrame == null) {
                this.wellsFrame = new FrameWells(this, this.sbdb);
                SB.centreWindow((Frame)this.wellsFrame);
            }
            this.wellsFrame.setState(0);
            this.wellsFrame.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception starting wells frame: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonWellsActionPerformed(ActionEvent evt) {
        this.createWellsFrame();
    }

    private void jButtonChartsActionPerformed(ActionEvent evt) {
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            if (!new File("sbchart.exe").exists()) {
                JOptionPane.showMessageDialog(this, "SBChart module not found in StrataBugs folder: " + System.getProperty("user.dir"), this.getTitle(), 0);
                return;
            }
            try {
                String cmd = "sbchart.exe " + SBdb.getHostName((String)(FrameJsbugs.parms.sbchartODBC == null || FrameJsbugs.parms.sbchartODBC.isEmpty() ? FrameJsbugs.parms.hostName : FrameJsbugs.parms.sbchartODBC));
                cmd = cmd + " UID=";
                if (FrameJsbugs.parms.UID != null) {
                    cmd = cmd + FrameJsbugs.parms.UID;
                }
                cmd = cmd + " PWD=";
                if (FrameJsbugs.parms.pwd != null) {
                    cmd = cmd + FrameJsbugs.parms.pwd;
                }
                cmd = cmd + " PFX=";
                if (FrameJsbugs.parms.instanceName != null && FrameJsbugs.parms.instanceName.length() > 0) {
                    if (FrameJsbugs.parms.instanceName.contains(".")) {
                        cmd = cmd + FrameJsbugs.parms.instanceName.substring(FrameJsbugs.parms.instanceName.indexOf(46) + 1);
                    } else if (!FrameJsbugs.parms.driverName.equalsIgnoreCase("sqlserver")) {
                        cmd = cmd + FrameJsbugs.parms.instanceName;
                    }
                }
                cmd = cmd + " SID=" + FrameJsbugs.parms.sbUID;
                cmd = cmd + " SPD=" + FrameJsbugs.parms.sbPwd;
                System.out.println("Command is: " + cmd);
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error running command:" + ex.getMessage(), this.getTitle(), 0);
                ex.printStackTrace();
            }
        } else {
            if (this.chartFrame == null) {
                this.chartFrame = new FrameChart(this.sbdb);
            }
            this.chartFrame.setState(0);
            this.chartFrame.setVisible(true);
        }
    }

    private void jMenuItemGrantsActionPerformed(ActionEvent evt) {
        String grantee = JOptionPane.showInputDialog(this, "Enter user/role or PUBLIC", "PUBLIC");
        if (grantee != null) {
            try {
                this.sbdb.setGrants(grantee);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Exception : " + e.getMessage(), this.getTitle(), 1);
            }
        }
    }

    private void jMenuItemCopyDatabaseActionPerformed(ActionEvent evt) {
        DialogConnect dialog = new DialogConnect((Frame)this, true);
        SB.centreDialog((Dialog)dialog);
        dialog.setVisible(true);
        if (dialog.parms == null) {
            return;
        }
        ConnectionParameters newParms = dialog.parms;
        try {
            SBdb newDB = new SBdb();
            newDB.connect(newParms.driverName, newParms.hostName, newParms.instanceName == null ? null : newParms.instanceName + (newParms.SQLServerIntegratedSecurity ? ";integratedSecurity=true" : ""), newParms.UID, newParms.pwd);
            if (JOptionPane.showConfirmDialog(this, "Create new Schema?", this.getTitle(), 0, 1) == 0) {
                String schemaFile = Lastval.getString((SBdb)this.sbdb, (String)"TABLESTXT");
                JFileChooser chooser = new JFileChooser();
                chooser.setLocation(this.getLocation().x + 20, this.getLocation().y + 20);
                chooser.setToolTipText("Select file for new Schema, or Cancel to skip");
                chooser.setCurrentDirectory(new File(schemaFile));
                int returnVal = chooser.showOpenDialog(this);
                if (returnVal == 0) {
                    File tablesTxt = chooser.getSelectedFile();
                    Lastval.putString((SBdb)this.sbdb, (String)"TABLESTXT", (String)tablesTxt.getAbsolutePath());
                    this.sbdb.commit();
                    newDB.createTables(tablesTxt);
                } else {
                    return;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.sbdb.copyTables(newDB);
            newDB.close();
            JOptionPane.showMessageDialog(this, "Copy complete", this.getTitle(), 1);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception : " + e.getMessage(), this.getTitle(), 1);
            e.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void setFrameOverlay(FrameOverlay frameOverlay) throws SBException {
        if (this.frameOverlay != null && this.frameOverlay.isVisible()) {
            throw new SBException("Overlay frame already exists!");
        }
        this.frameOverlay = frameOverlay;
        frameOverlay.setVisible(true);
    }

    FrameOverlay getFrameOverlay() {
        if (this.frameOverlay != null && !this.frameOverlay.isVisible()) {
            return null;
        }
        return this.frameOverlay;
    }

    private void setCurrent() throws SQLException, SBException {
        if (this.wellsFrame != null) {
            this.wellsFrame.dispose();
            this.wellsFrame = null;
        }
        if (this.samplesFrame != null) {
            this.samplesFrame.dispose();
        }
        if (this.interpretationsFrame != null) {
            this.interpretationsFrame.dispose();
            this.interpretationsFrame = null;
        }
        if (this.taxadbFrame != null) {
            this.taxadbFrame.dispose();
            this.taxadbFrame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSamplesActionPerformed(ActionEvent evt) {
        block33: {
            try {
                Class.forName("org.apache.batik.svggen.SVGGeneratorContext");
            }
            catch (ClassNotFoundException e) {
                SB.showStackError((String)"Batik library is missing", (Exception)e);
                return;
            }
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (!this.checkRLMlicence()) {
                    JOptionPane.showMessageDialog(this, LIC_FAIL_STRING, "StrataBugs", 0);
                    return;
                }
                if (this.samplesFrame == null) {
                    Well well = this.sbdb.getCurrentWell();
                    if (well != null) {
                        this.samplesFrame = new FrameSamples(this, this.sbdb, well, false);
                        this.samplesFrame.setVisible(true);
                        break block33;
                    }
                    boolean hasPrevious = false;
                    try {
                        String session = Lastval.getString((SBdb)this.sbdb, (String)"SMPSESSION");
                        if (session != null && !session.isEmpty()) {
                            hasPrevious = true;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int opt = 1;
                    if (hasPrevious) {
                        Object[] buttons = new String[]{"Yes", "Open Well", "Open Project"};
                        opt = JOptionPane.showOptionDialog(this, "Restore previous session?", this.getTitle(), 1, 3, null, buttons, null);
                    }
                    if (opt == 0) {
                        this.samplesFrame = new FrameSamples(this, this.sbdb, null, true);
                    } else {
                        JDialog dialog;
                        Iterator wellIt = null;
                        if (opt == 1) {
                            dialog = new DialogSelectWell((Frame)this, true, this.sbdb, true);
                            dialog.setVisible(true);
                            if (((DialogSelectWell)dialog).selection != null) {
                                wellIt = ((DialogSelectWell)dialog).selection.iterator();
                            }
                        } else if (opt == 2) {
                            dialog = new DialogSelectProject((Frame)this, true, this.sbdb, false);
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            if (((DialogSelectProject)dialog).selection != null) {
                                ((DialogSelectProject)dialog).selection.loadWells(this.sbdb, null);
                                wellIt = ((DialogSelectProject)dialog).selection.getWellIterator();
                            }
                        }
                        if (wellIt == null) {
                            return;
                        }
                        while (wellIt.hasNext()) {
                            well = (Well)wellIt.next();
                            this.addSamplesWell(well, false);
                        }
                    }
                    this.samplesFrame.setVisible(true);
                    break block33;
                }
                DialogSelectWell dialog = new DialogSelectWell((Frame)this, true, this.sbdb, true);
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                List<Well> wells = dialog.selection;
                Iterator<Well> itw = wells.iterator();
                Object p = null;
                while (itw.hasNext()) {
                    Well well = itw.next();
                    this.samplesFrame.addWellTab(well);
                }
                if (this.samplesFrame.getState() == 1) {
                    this.samplesFrame.setState(0);
                }
                this.samplesFrame.setVisible(true);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemLoadActionPerformed(ActionEvent evt) {
        int opt = JOptionPane.showConfirmDialog(this, "Warning: this is not usually necessary, and can take a long time to execute for large databases.\nDo you want to continue?", this.getTitle(), 0, 3);
        if (opt != 0) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.sbdb.load();
            JOptionPane.showMessageDialog(this, "Data loaded.", this.getTitle(), 1);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error loading database", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error loading database", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemConnectActionPerformed(ActionEvent evt) {
        try {
            this.connect(false, true);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "SQL Error: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        if (this.checkExit()) {
            System.out.print("Max Memory       : ");
            System.out.format("%,d%n", Runtime.getRuntime().maxMemory());
            System.out.print("Total Memory     : ");
            System.out.format("%,d%n", Runtime.getRuntime().totalMemory());
            System.out.print("Memory free      : ");
            System.out.format("%,d%n", Runtime.getRuntime().freeMemory());
            System.out.print("Total memory used: ");
            System.out.format("%,d%n", Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            System.exit(0);
        }
    }

    RlmLicense getLicense() {
        return this.license;
    }

    private boolean checkExit() {
        boolean checkClose = false;
        boolean isShowing = false;
        if (this.samplesFrame != null) {
            checkClose = true;
            if (this.samplesFrame.isShowing()) {
                isShowing = true;
            }
        }
        if (this.interpretationsFrame != null) {
            checkClose = true;
            if (this.interpretationsFrame.isShowing()) {
                isShowing = true;
            }
        }
        if (this.taxadbFrame != null) {
            checkClose = true;
            if (this.taxadbFrame.isShowing()) {
                isShowing = true;
            }
        }
        if (this.wellsFrame != null) {
            checkClose = true;
            if (this.wellsFrame.isShowing()) {
                isShowing = true;
            }
        }
        for (FrameOrganiser f : this.organiserFrames) {
            if (!f.isShowing()) continue;
            isShowing = true;
            break;
        }
        if (checkClose && JOptionPane.showConfirmDialog(this, (isShowing ? "Close all Windows and " : "") + "Exit StrataBugs?", this.getTitle(), 0, 2) != 0) {
            return false;
        }
        System.out.println("Exiting from StrataBugs");
        try {
            if (this.dataRefreshTask != null) {
                this.dataRefreshTask.cancel(true);
            }
            this.sbdb.commit();
            this.sbdb.close();
        }
        catch (Exception ex) {
            System.out.println("Error closing database: " + ex.getMessage());
            ex.printStackTrace();
        }
        if (this.license != null) {
            this.license.checkin();
            this.handle.close();
        }
        return true;
    }

    private void jMenuItemConfigAbnActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemes dialog = new DialogAbnSchemes((Frame)this, true, this.sbdb);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Exception loading schemes: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        DialogRefresh dialog = new DialogRefresh((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            if (this.dataRefreshTask != null) {
                this.dataRefreshTask.cancel(true);
            }
            this.startRefresh();
        }
    }

    private void jButtonOrganiserActionPerformed(ActionEvent evt) {
        try {
            if (!this.checkRLMlicence()) {
                JOptionPane.showMessageDialog(this, LIC_FAIL_STRING, "StrataBugs", 0);
                return;
            }
            String frameTitle = null;
            if (this.organiserFrames.size() > 0) {
                if (JOptionPane.showConfirmDialog(this, "There is an Organiser window already open.\nOpen a new instance?", "Organiser", 0, 3) != 0) {
                    for (FrameOrganiser frame : this.organiserFrames) {
                        if (frame.getState() != 1) continue;
                        frame.setState(0);
                    }
                    return;
                }
                frameTitle = "StrataBugs: " + (this.organiserFrames.size() + 1) + " Organiser";
            }
            FrameOrganiser frame = new FrameOrganiser(this, this.sbdb);
            frame.setLocationRelativeTo(this);
            frame.setVisible(true);
            if (frameTitle != null) {
                frame.setTitle(frameTitle);
            }
            this.organiserFrames.add(frame);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception opening Organiser frame: " + e.getMessage(), this.getTitle(), 1);
            SB.showStackError((String)e.getMessage(), (Exception)e);
            e.printStackTrace();
        }
    }

    GraphicsConfiguration getAltGC() {
        GraphicsConfiguration defgc = this.getGraphicsConfiguration();
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (gds.length == 1) {
            return defgc;
        }
        for (GraphicsDevice dev : gds) {
            if (dev == defgc.getDevice()) continue;
            return dev.getDefaultConfiguration();
        }
        return defgc;
    }

    private void jMenuItemScreenActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        String strg = "You have screens: \n";
        System.out.println("GraphicsDevice length: " + gds.length);
        for (GraphicsDevice dev : gds) {
            GraphicsConfiguration[] gc = dev.getConfigurations();
            System.out.println("GraphicsConfiguration length: " + gc.length);
            for (GraphicsConfiguration fig : gc) {
                strg = strg + dev.getIDstring() + " [of " + gds.length + "]" + ", bounds: " + fig.getBounds() + "\n";
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        JOptionPane.showMessageDialog(this, strg, "Screen Configuration", 1);
    }

    private void jMenuItemImageStorageActionPerformed(ActionEvent evt) {
        try {
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogManageImages dialog = new DialogManageImages((Frame)this, false, this.sbdb);
            dialog.setLocationRelativeTo(this);
            this.setCursor(cursor);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jCheckBoxMenuItemSQLtoCmdActionPerformed(ActionEvent evt) {
        SB.showSql = !SB.showSql;
        this.jCheckBoxMenuItemSQLtoCmd.setSelected(SB.showSql);
    }

    private void jMenuItemContentsActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("index.html");
    }

    private void jMenuItemMiscColoursActionPerformed(ActionEvent evt) {
        try {
            DialogMiscColours dialog = new DialogMiscColours((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jMenuItemSproActionPerformed(ActionEvent evt) {
        FrameJsbugs.testDongle(this, this.getTitle());
    }

    private void jMenuItemLogDefActionPerformed(ActionEvent evt) {
        try {
            DialogLogDefs dialog = new DialogLogDefs((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jMenuItemSBUpdateActionPerformed(ActionEvent evt) {
        try {
            int opt = JOptionPane.showConfirmDialog(this, "You will need to close the control panel and applications before updating.\nClose now?", this.getTitle(), 1, 3);
            if (opt == 2) {
                return;
            }
            boolean exit = false;
            if (opt == 0) {
                exit = this.checkExit();
            }
            BareBonesBrowserLaunch.openURL((String)"http://www.stratadata.co.uk/sbugs_updatesv2-0.shtml?res=true");
            if (exit) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jMenuItemHelpCPActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("control_panel.html");
    }

    private void jRadioButtonMenuItemHelpLocalIEActionPerformed(ActionEvent evt) {
        File file = new File("").getAbsoluteFile();
        helpRoot = "http://127.0.0.1:8082/resource/jar:file:/" + file.getPath().replace(File.separatorChar, '/') + "/jsbugs_help.zip!/help/";
        System.out.println("Help location URL set to: " + helpRoot);
        Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").put(HELP_PREF, helpRoot);
    }

    private void jRadioButtonMenuItemHelpLocalFFActionPerformed(ActionEvent evt) {
        File file = new File("").getAbsoluteFile();
        helpRoot = "jar:file:///" + file.getPath().replace(File.separatorChar, '/') + "/jsbugs_help.zip!/help/";
        System.out.println("Help location URL set to: " + helpRoot);
        Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").put(HELP_PREF, helpRoot);
    }

    private void jRadioButtonMenuItemHelpWebActionPerformed(ActionEvent evt) {
        helpRoot = WWW_HELP_PATH;
        System.out.println("Help location URL set to: " + helpRoot);
        Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").remove(HELP_PREF);
    }

    private void jRadioButtonMenuItemHelpLocalFolderActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        File file = new File(".");
        fc.setCurrentDirectory(file);
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Select folder containing html help files");
        fc.setApproveButtonText("Select");
        if (fc.showOpenDialog(this) == 0) {
            helpRoot = "file:///" + fc.getSelectedFile().getPath() + File.separatorChar;
            System.out.println("Help location URL set to: " + helpRoot);
            Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").put(HELP_PREF, helpRoot);
        }
    }

    private void jRadioButtonMenuItemDepthsTopActionPerformed(ActionEvent evt) {
        if (!this.setDepthPref(true)) {
            this.jRadioButtonMenuItemDepthsTop.setSelected(false);
            this.jRadioButtonMenuItemDepthsBase.setSelected(true);
        }
    }

    private void jRadioButtonMenuItemDepthsBaseActionPerformed(ActionEvent evt) {
        if (!this.setDepthPref(false)) {
            this.jRadioButtonMenuItemDepthsTop.setSelected(true);
            this.jRadioButtonMenuItemDepthsBase.setSelected(false);
        }
    }

    private void jMenuItemManageConnectionsActionPerformed(ActionEvent evt) {
        DialogConnectionManager dialog = new DialogConnectionManager((Frame)this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemNullTopDepthsActionPerformed(ActionEvent evt) {
        try {
            int opt;
            String warning = "Set all TOP depths to NULL?";
            if (this.sbdb.useSampleTops()) {
                warning = warning + "\nThis is the OPPOSITE of your sytem preference for using sample top depths!";
            }
            if ((opt = JOptionPane.showConfirmDialog(this, warning, this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nRows = this.sbdb.setNullSampleDepths(true);
            this.sbdb.commit();
            JOptionPane.showMessageDialog(this, "Number of rows updated: " + nRows + "\nExit from the control panel and restart.", this.getTitle(), 2);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemNullBaseDepthsActionPerformed(ActionEvent evt) {
        try {
            int opt;
            String warning = "Set all BASE depths to NULL?";
            if (!this.sbdb.useSampleTops()) {
                warning = warning + "\nThis is the OPPOSITE of your ssytem preference for using sample base depths!";
            }
            if ((opt = JOptionPane.showConfirmDialog(this, warning, this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nRows = this.sbdb.setNullSampleDepths(false);
            this.sbdb.commit();
            JOptionPane.showMessageDialog(this, "Number of rows updated: " + nRows + "\nExit from the control panel and restart.", this.getTitle(), 2);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemDBInfoActionPerformed(ActionEvent evt) {
        DialogDBInfo dialog = new DialogDBInfo((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jRadioButtonMenuItemLOG1ActionPerformed(ActionEvent evt) {
        this.setLogPrec(1);
    }

    private void jRadioButtonMenuItemLOG2ActionPerformed(ActionEvent evt) {
        this.setLogPrec(2);
    }

    private void jRadioButtonMenuItemLOG3ActionPerformed(ActionEvent evt) {
        this.setLogPrec(3);
    }

    private void jMenuItemautoMergeTaxaActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Auto-merge", 2);
            return;
        }
        DialogAutoMergeTaxa dialog = new DialogAutoMergeTaxa((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jCheckBoxMenuItemExportSingleUserActionPerformed(ActionEvent evt) {
        try {
            if (this.jCheckBoxMenuItemExportSingleUser.isSelected() && this.sbdb.getExportSingleUserAbr(false).isEmpty()) {
                JOptionPane.showMessageDialog(this, "You must set the single user abbreviation before you export data.", this.getTitle(), 1);
            }
            this.sbdb.setExportSingleUser(this.jCheckBoxMenuItemExportSingleUser.isSelected());
            this.sbdb.commit();
        }
        catch (SQLException e) {
            SB.showStackError((String)"Error setting export preference", (SQLException)e);
        }
    }

    private void jMenuItemExportABRActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return;
        }
        try {
            String abr = null;
            boolean allowed = false;
            do {
                String msg = "Export all data with user ID: ";
                if (abr != null) {
                    msg = "That ID is not valid - must be less than 5 letters";
                }
                if ((abr = JOptionPane.showInputDialog(this, msg, this.getTitle(), 2)) == null) {
                    return;
                }
                if ((abr = abr.trim()).length() > 5) continue;
                allowed = true;
            } while (!allowed);
            this.sbdb.setExportSingleUserAbr(abr);
            this.sbdb.commit();
            this.setExportDataMenu();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jMenuItemEventPrefixActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return;
        }
        DialogEventPrefix dialog = new DialogEventPrefix((Frame)this, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemChartScalesActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return;
        }
        try {
            DialogChartScales dialog = new DialogChartScales((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jMenuItemQueryActionPerformed(ActionEvent evt) {
        DialogSQLQuery dialog = new DialogSQLQuery((Frame)this, false, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemEditWirelineLogPathsActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogSBChartLogPath dialog = new DialogSBChartLogPath((Frame)this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemRLMRoamActionPerformed(ActionEvent evt) {
        try {
            DialogRLMRoam dialog = new DialogRLMRoam(this, true, this.handle, this.license, product, ver);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemMergeDuplicateEventsActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to run this", "Merge events", 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "This process merges duplicate events created by a bug in the event generation process.\nYou will need to close the control panel and reopen afterwards. OK to continue?", "Merge events", 0, 3) == 1) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int nUpdated = SBEvent.autoMerge((SBdb)this.sbdb);
            this.sbdb.commit();
            JOptionPane.showMessageDialog(this, "Process complete: number updated: " + nUpdated + "\nClose the control panel and reopen.", "Merge events", 2);
        }
        catch (Exception ex) {
            this.sbdb.doRollback();
            SB.showStackError((String)ex.toString(), (Exception)ex);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jRadioButtonMenuItemSingleActionPerformed(ActionEvent evt) {
        if (!this.setEnvPref(false)) {
            this.jRadioButtonMenuItemMultiple.setSelected(false);
            this.jRadioButtonMenuItemSingle.setSelected(true);
        }
    }

    private void jRadioButtonMenuItemMultipleActionPerformed(ActionEvent evt) {
        if (!this.setEnvPref(true)) {
            this.jRadioButtonMenuItemMultiple.setSelected(true);
            this.jRadioButtonMenuItemSingle.setSelected(false);
        }
    }

    private void jRadioButtonMenuItemGuiSystemActionPerformed(ActionEvent evt) {
        this.setGuiResize(false);
    }

    private void jRadioButtonMenuItemGuiSizes100ActionPerformed(ActionEvent evt) {
        this.setGuiResize(true);
    }

    private void setGuiResize(boolean resizegui) {
        boolean current = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").getBoolean("resizegui", false);
        if (current != resizegui) {
            Preferences.userNodeForPackage(Jsbugs.class).node("v2.0").putBoolean("resizegui", resizegui);
            JOptionPane.showMessageDialog(this, "Restart StrataBugs to see changes.", this.getTitle(), 1);
        }
    }

    void setLogPrec(int dp) {
        try {
            Sample.setLogDp((SBdb)this.sbdb, (int)dp);
            this.sbdb.commit();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    boolean setDepthPref(boolean topDepths) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return false;
        }
        try {
            if (topDepths && !this.sbdb.useSampleTops()) {
                this.sbdb.setSampleTops(true);
            } else if (!topDepths && this.sbdb.useSampleTops()) {
                this.sbdb.setSampleTops(false);
            }
            this.sbdb.commit();
            return true;
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            return false;
        }
    }

    boolean setEnvPref(boolean allowMultipleEnvSchemes) {
        if ((this.sbdb.getUser().getPriv() & 0x40) == 0) {
            JOptionPane.showMessageDialog(this, "You need to be a super-user to change this setting", "Depth Preferences", 2);
            return false;
        }
        try {
            if (allowMultipleEnvSchemes && !this.sbdb.allowMultipleEnvSchemes()) {
                this.sbdb.setAllowMultipleEnvSchemes(true);
            } else if (!allowMultipleEnvSchemes && this.sbdb.allowMultipleEnvSchemes()) {
                this.sbdb.setAllowMultipleEnvSchemes(false);
            }
            this.sbdb.commit();
            return true;
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            return false;
        }
    }

    static void testDongle(Component parent, String title) {
        if (!new File("spro.exe").exists()) {
            System.out.println("Showing msg:");
            JOptionPane.showMessageDialog(parent, "Sentinel tester not found in StrataBugs folder: " + System.getProperty("user.dir"), title, 0);
            return;
        }
        try {
            Runtime.getRuntime().exec("spro.exe");
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(parent, "Error running command:" + ex.getMessage(), title, 0);
            ex.printStackTrace();
        }
    }

    static File chooseFile(SBdb db, Component parent, String lastValWin, String lastValUnx, String[] extensions, String[] descriptions, String defaultFileName) {
        JFileChooser jFileChooser = new JFileChooser();
        SbugsFileFilter useThis = null;
        for (int i = 0; i < extensions.length; ++i) {
            SbugsFileFilter sbugsFileFilter = new SbugsFileFilter(extensions[i], descriptions[i]);
            jFileChooser.addChoosableFileFilter((FileFilter)sbugsFileFilter);
            if (i != 0) continue;
            useThis = sbugsFileFilter;
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter((FileFilter)useThis);
        File file = null;
        try {
            file = new File(Lastval.getString((SBdb)db, (String)lastValWin, (String)lastValUnx));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (file == null || file.getParent() == null || !file.getParentFile().exists()) {
            file = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(file);
            if (defaultFileName != null) {
                jFileChooser.setSelectedFile(new File(defaultFileName));
            }
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (0 == jFileChooser.showSaveDialog(parent)) {
            String extension;
            file = jFileChooser.getSelectedFile();
            SbugsFileFilter filter = (SbugsFileFilter)jFileChooser.getFileFilter();
            if (filter != null) {
                extension = filter.getExtension();
            } else if (file.exists()) {
                String path = file.getPath();
                extension = path.substring(path.indexOf(".") + 1);
            } else {
                extension = extensions[0];
            }
            if (!file.getName().endsWith("." + extension)) {
                file = new File(file.getPath() + "." + extension);
            }
            if (file.exists() && JOptionPane.showConfirmDialog(parent, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                return null;
            }
            try {
                Lastval.putString((SBdb)db, (String)lastValWin, (String)lastValUnx, (String)file.getPath());
                db.commit();
            }
            catch (Exception e) {}
        } else {
            return null;
        }
        return file;
    }

    private void setExportDataMenu() {
        try {
            String s = "Use abbreviation: ";
            String abr = this.sbdb.getExportSingleUserAbr(true);
            if (abr != null) {
                this.jMenuItemExportABR.setText(s + abr);
            } else {
                this.jMenuItemExportABR.setText(s + "(none set)");
            }
            this.jCheckBoxMenuItemExportSingleUser.setSelected(this.sbdb.getExportSingleUser(true));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error setting data export preferences", (SQLException)sql);
        }
    }

    static void showStackError(String msg, Exception ex, SBdb sbdb) {
        if (ex instanceof SQLException && sbdb.isNetworkError((SQLException)ex)) {
            FrameJsbugs.handleNetworkError(ex, sbdb);
            return;
        }
        SB.showStackError((String)msg, (Exception)ex);
    }

    private static void handleNetworkError(Exception e, SBdb sbdb) {
        e.printStackTrace();
        int option = JOptionPane.showConfirmDialog(null, e.getMessage() + "\nPlease check your network connection before continuing." + "\n\nPress 'OK' to attempt StrataBugs reconnection, or 'Cancel' to exit from StrataBugs.", "Database Connection Error", 2, 0);
        if (option == 0) {
            System.out.println("Attempting to reconnect database...");
            try {
                if (sbdb.connect(FrameJsbugs.parms.driverName, FrameJsbugs.parms.hostName, FrameJsbugs.parms.instanceName == null ? null : FrameJsbugs.parms.instanceName + (FrameJsbugs.parms.SQLServerIntegratedSecurity ? ";integratedSecurity=true" : ""), FrameJsbugs.parms.UID, FrameJsbugs.parms.pwd)) {
                    JOptionPane.showMessageDialog(null, "Connection re-established.", "Connection", 2);
                }
            }
            catch (Exception ex) {
                FrameJsbugs.showStackError("Error reconnecting database\nAfter error: " + e.getMessage(), ex, sbdb);
            }
        } else {
            System.exit(0);
        }
    }
}

