/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbugs.DialogBugWareReader;
import jsbugs.DialogCSVImport;
import jsbugs.DialogChecklistReader;
import jsbugs.DialogDataTypes;
import jsbugs.DialogExportText;
import jsbugs.DialogImportAnalyses;
import jsbugs.DialogList;
import jsbugs.DialogMatchAbundance;
import jsbugs.DialogMatchAnalysts;
import jsbugs.DialogMatchCmpStd;
import jsbugs.DialogMatchEnvScheme;
import jsbugs.DialogMatchEvents;
import jsbugs.DialogMatchIGD;
import jsbugs.DialogMatchIGDScheme;
import jsbugs.DialogMatchInterp;
import jsbugs.DialogMatchSampleTypes;
import jsbugs.DialogMatchTaxa;
import jsbugs.DialogMatchWellHeader;
import jsbugs.DialogMatchWells;
import jsbugs.DialogODM;
import jsbugs.DialogOWXLSReader;
import jsbugs.DialogSelectAbnScheme;
import jsbugs.DialogSelectEnvScheme;
import jsbugs.DialogSelectIGDScheme;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectVersion;
import jsbugs.DialogSelectWell;
import jsbugs.DialogTSCreator;
import jsbugs.DialogWellProjectSelection;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelOrganiser;
import jsbugs.SbugsMLdocument;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.BugWareReader;
import model2.CSVReader;
import model2.ChecklistReader;
import model2.CompositeStandard;
import model2.DEXFile;
import model2.Discipline;
import model2.EnvScheme;
import model2.GenericReaderXLS;
import model2.IGDIntervalEnv;
import model2.IGDScheme;
import model2.IGDXLSReader;
import model2.InterpHdr;
import model2.Lastval;
import model2.Project;
import model2.RGReader;
import model2.SBEvent;
import model2.SBdb;
import model2.SISSbugsReader;
import model2.SQPick;
import model2.Sample;
import model2.SampleOccReaderXLS;
import model2.SampleReaderXLS;
import model2.SbugsReader;
import model2.Smpdtl;
import model2.TSCreatorReader;
import model2.TaxonOcc;
import model2.Userdef;
import model2.Well;
import model2.WellInterp;
import model2.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.jdesktop.layout.GroupLayout;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.SbugsStatus;
import util.StringStatus;

public class FrameOrganiser
extends JFrame
implements PropertyChangeListener {
    FrameJsbugs parent;
    SBdb ws;
    SBdb db;
    Project project;
    char units = (char)68;
    List<Integer> dataTypes = new LinkedList<Integer>();
    private boolean inWizard;
    private boolean autoResize = true;
    private JFileChooser jFileChooserCommonOpen;
    private JFileChooser jFileChooserDEX;
    private JFileChooser jFileChooserCSV;
    private JFileChooser jFileChooserXML;
    private JFileChooser jFileChooserXLS;
    private JFileChooser jFileChooserZIP;
    private JFileChooser jFileChooserBugWare;
    private JFileChooser jFileChooserChecklist;
    private JFileChooser jFileChooserRG;
    private JFileChooser jFileChooserSbugs;
    private JFileChooser jFileChooserSISSbugs;
    List<Image> imageList = new LinkedList<Image>();
    ProgressMonitor pm;
    boolean isSavingData = false;
    private ButtonGroup buttonGroupMenuUnits;
    private JButton jButtonDataTypes;
    private JButton jButtonExport;
    private JButton jButtonImport;
    private JButton jButtonOpenFile;
    private JButton jButtonOpenProject;
    private JButton jButtonOpenWells;
    private JButton jButtonSaveToDatabase;
    private JButton jButtonSaveToFile;
    private JCheckBoxMenuItem jCheckBoxMenuItemAutoScroll;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItemDataTypes;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemGuidedExport;
    private JMenuItem jMenuItemGuidedImport;
    private JMenuItem jMenuItemHelpMatch;
    private JMenuItem jMenuItemHelpMenu;
    private JMenuItem jMenuItemLoadWorkspace;
    private JMenuItem jMenuItemMatchAbundance;
    private JMenuItem jMenuItemMatchAnalysts;
    private JMenuItem jMenuItemMatchEnvSchemes;
    private JMenuItem jMenuItemMatchEvents;
    private JMenuItem jMenuItemMatchIGDIntervals;
    private JMenuItem jMenuItemMatchIGDSchemes;
    private JMenuItem jMenuItemMatchInterp;
    private JMenuItem jMenuItemMatchTaxa;
    private JMenuItem jMenuItemMatchWells;
    private JMenuItem jMenuItemODM;
    private JMenuItem jMenuItemOpenBugWare;
    private JMenuItem jMenuItemOpenCSV;
    private JMenuItem jMenuItemOpenChecklist;
    private JMenuItem jMenuItemOpenCommon;
    private JMenuItem jMenuItemOpenDEX;
    private JMenuItem jMenuItemOpenIGDXLS;
    private JMenuItem jMenuItemOpenOWXLS;
    private JMenuItem jMenuItemOpenProject;
    private JMenuItem jMenuItemOpenRG;
    private JMenuItem jMenuItemOpenSISSbugs;
    private JMenuItem jMenuItemOpenSampleOccXLS;
    private JMenuItem jMenuItemOpenSampleXLS;
    private JMenuItem jMenuItemOpenSbugs;
    private JMenuItem jMenuItemOpenTSCreator;
    private JMenuItem jMenuItemOpenWells;
    private JMenuItem jMenuItemOpenXML;
    private JMenuItem jMenuItemOpenZip;
    private JMenuItem jMenuItemOrganiserHelp;
    private JMenuItem jMenuItemRemoveVersion;
    private JMenuItem jMenuItemReplaceAll;
    private JMenuItem jMenuItemSaveDEX;
    private JMenuItem jMenuItemSaveInDatabase;
    private JMenuItem jMenuItemSaveText;
    private JMenuItem jMenuItemSaveXML;
    private JMenuItem jMenuItemSaveZipFile;
    private JMenuItem jMenuItemViewExclude;
    private JMenuItem jMenuItemViewVersion;
    private JMenu jMenuMatch;
    private JMenu jMenuOpenFile;
    private JMenu jMenuSaveToFile;
    private JMenu jMenuView;
    private JRadioButtonMenuItem jRadioButtonMenuItemDrilled;
    private JRadioButtonMenuItem jRadioButtonMenuItemFeet;
    private JRadioButtonMenuItem jRadioButtonMenuItemMetres;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;

    public FrameOrganiser(FrameJsbugs parent, SBdb db) throws SQLException, SBException {
        this.parent = parent;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Organiser - StrataBugs");
        this.createImageList();
        this.setIconImages(this.imageList);
        this.setWorkspace(new SBdb(this.db));
        this.loadUserDefults();
    }

    private void createImageList() {
        String[] pngs = new String[]{"48Org.png", "32Org.png", "24Org.png", "16Org.png"};
        for (int i = 0; i < pngs.length; ++i) {
            Image img = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/FrameIcon_Org/" + pngs[i]));
            this.imageList.add(img);
        }
    }

    static void loadPOIClasses(ClassLoader loader) throws ClassNotFoundException {
        Class.forName("org.apache.poi.poifs.filesystem.POIFSFileSystem");
        Class.forName("org.apache.poi.hssf.usermodel.HSSFWorkbook");
        Class.forName("org.apache.poi.hssf.record.DrawingSelectionRecord", false, loader);
    }

    private void openGeneric() {
        try {
            FrameOrganiser.loadPOIClasses(this.getClass().getClassLoader());
            GenericReaderXLS reader = new GenericReaderXLS(this.ws, "D:\\sbugs\\Clients\\Data\\Nexen\\2011_Nov14_Nexen_standard_naming_convention.xls", this.dataTypes);
            this.db.commit();
            this.refreshView();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error: ", (SQLException)sql);
            sql.printStackTrace();
        }
        catch (IOException ioe) {
            SB.showStackError((String)"Error", (Exception)ioe);
            ioe.printStackTrace();
        }
        catch (ClassNotFoundException clex) {
            SB.showStackError((String)clex.toString(), (Exception)clex);
            clex.printStackTrace();
        }
        this.db.doRollback();
    }

    void importFile() {
        if (!this.parent.checkRLMlicence()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        this.openCommon();
        if (this.inWizard) {
            if (this.dataTypes.size() > 2) {
                this.jMenuItemDataTypesActionPerformed(null);
            }
            if (this.hasFssDataTypes()) {
                try {
                    this.ws.checkDefaultAbnScheme();
                    for (AbnScheme scheme : this.ws.getAbnSchemes()) {
                        if (scheme.getLink() == null && this.ws.hasAbnSchemeOccs(scheme)) {
                            this.matchAbnScheme(scheme);
                        }
                        if (this.inWizard) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    SB.showStackError((String)"Error during import", (Exception)e);
                    this.inWizard = false;
                }
            }
        }
        if (this.inWizard) {
            this.jMenuItemMatchAnalystsActionPerformed(null);
        }
        if (this.inWizard && (this.hasFssDataTypes() || this.hasEventDataTypes())) {
            this.jMenuItemMatchTaxaActionPerformed(null);
        }
        if (this.inWizard && this.hasEventDataTypes()) {
            this.jMenuItemMatchEventsActionPerformed(null);
        }
        if (this.inWizard && this.hasIGDDataTypes()) {
            this.jMenuItemMatchInterpActionPerformed(null);
        }
        if (this.inWizard && (this.hasIGDZoneDataTypes() || this.hasSQPickDataTypes())) {
            this.jMenuItemMatchIGDIntervalsActionPerformed(null);
        }
        if (this.inWizard && this.hasEnvDataType()) {
            try {
                for (AbnScheme scheme : this.ws.getEnvSchemes()) {
                    if (scheme.getLink() != null || !this.ws.hasEnvSchemeOccs((EnvScheme)scheme)) continue;
                    this.matchEnvScheme((EnvScheme)scheme);
                }
            }
            catch (Exception e) {
                SB.showStackError((String)e.getMessage(), (Exception)e);
                this.inWizard = false;
            }
        }
        if (this.inWizard) {
            this.jMenuItemMatchWellsActionPerformed(null);
        }
        if (this.inWizard && JOptionPane.showConfirmDialog(this, "Save all data in database?", this.getTitle(), 0, 3) == 0) {
            this.saveInDatabase(false);
        }
    }

    private void refreshView() throws SQLException, SBException {
        Collections.sort(this.dataTypes);
        for (Component comp : this.jTabbedPane1.getComponents()) {
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            panel.refreshView(true);
        }
    }

    void saveUserDefaults() {
        try {
            String dTypes = "";
            for (int i = 0; i < this.dataTypes.size(); ++i) {
                dTypes = dTypes + this.dataTypes.get(i).toString() + " ";
            }
            if (dTypes.length() > 0) {
                Lastval.putString((SBdb)this.db, (String)"JSDT", (String)dTypes);
            }
            this.db.commit();
        }
        catch (SQLException e) {
            this.db.doRollback();
            e.printStackTrace();
        }
    }

    void loadUserDefults() {
        try {
            String dTypes;
            char newUnits = Lastval.getChar((SBdb)this.db, (String)"INDXUNT");
            if (newUnits != '\u0000' && newUnits != this.units) {
                this.jRadioButtonMenuItemFeet.setSelected(this.units == 'F');
                this.jRadioButtonMenuItemMetres.setSelected(this.units == 'M');
                this.jRadioButtonMenuItemDrilled.setSelected(this.units == 'D');
            }
            if ((dTypes = Lastval.getString((SBdb)this.db, (String)"JSDT")).length() > 0) {
                StringTokenizer st = new StringTokenizer(dTypes);
                while (st.hasMoreTokens()) {
                    this.dataTypes.add(new Integer(st.nextToken()));
                }
                this.refreshView();
            }
        }
        catch (SBException e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "Error", 0);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
    }

    private void initComponents() {
        this.buttonGroupMenuUnits = new ButtonGroup();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonOpenFile = new JButton();
        this.jButtonOpenWells = new JButton();
        this.jButtonOpenProject = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButtonSaveToDatabase = new JButton();
        this.jButtonSaveToFile = new JButton();
        this.jSeparator7 = new JToolBar.Separator();
        this.jButtonDataTypes = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemGuidedImport = new JMenuItem();
        this.jMenuItemGuidedExport = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuOpenFile = new JMenu();
        this.jMenuItemOpenCommon = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jMenuItemOpenDEX = new JMenuItem();
        this.jMenuItemOpenXML = new JMenuItem();
        this.jMenuItemOpenCSV = new JMenuItem();
        this.jMenuItemOpenZip = new JMenuItem();
        this.jMenuItemOpenBugWare = new JMenuItem();
        this.jMenuItemOpenChecklist = new JMenuItem();
        this.jMenuItemOpenRG = new JMenuItem();
        this.jMenuItemOpenSbugs = new JMenuItem();
        this.jMenuItemOpenSISSbugs = new JMenuItem();
        this.jMenuItemOpenIGDXLS = new JMenuItem();
        this.jMenuItemOpenOWXLS = new JMenuItem();
        this.jMenuItemOpenSampleXLS = new JMenuItem();
        this.jMenuItemOpenSampleOccXLS = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.jMenuItemOpenTSCreator = new JMenuItem();
        this.jMenuItemODM = new JMenuItem();
        this.jMenuItemOpenWells = new JMenuItem();
        this.jMenuItemOpenProject = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemSaveInDatabase = new JMenuItem();
        this.jMenuSaveToFile = new JMenu();
        this.jMenuItemSaveZipFile = new JMenuItem();
        this.jMenuItemSaveXML = new JMenuItem();
        this.jMenuItemSaveDEX = new JMenuItem();
        this.jMenuItemSaveText = new JMenuItem();
        this.jMenuItemReplaceAll = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuView = new JMenu();
        this.jMenuItemDataTypes = new JMenuItem();
        this.jMenuItemViewVersion = new JMenuItem();
        this.jMenuItemRemoveVersion = new JMenuItem();
        this.jMenuItemViewExclude = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jMenuItemLoadWorkspace = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemAutoScroll = new JCheckBoxMenuItem();
        this.jMenu1 = new JMenu();
        this.jRadioButtonMenuItemMetres = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemFeet = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemDrilled = new JRadioButtonMenuItem();
        this.jMenuMatch = new JMenu();
        this.jMenuItemMatchInterp = new JMenuItem();
        this.jMenuItemMatchAbundance = new JMenuItem();
        this.jMenuItemMatchAnalysts = new JMenuItem();
        this.jMenuItemMatchTaxa = new JMenuItem();
        this.jMenuItemMatchEvents = new JMenuItem();
        this.jMenuItemMatchIGDIntervals = new JMenuItem();
        this.jMenuItemMatchEnvSchemes = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.jMenuItemMatchWells = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemMatchIGDSchemes = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemOrganiserHelp = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemHelpMenu = new JMenuItem();
        this.jMenuItemHelpMatch = new JMenuItem();
        this.jMenuItem1.setText("jMenuItem1");
        this.jMenuItem2.setText("jMenuItem2");
        this.jMenuItem3.setText("jMenuItem3");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                FrameOrganiser.this.formWindowClosed(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonImport.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameOrganiser_GuidedImport.png")));
        this.jButtonImport.setToolTipText("Guided import");
        this.jButtonImport.setFocusable(false);
        this.jButtonImport.setHorizontalTextPosition(0);
        this.jButtonImport.setVerticalTextPosition(3);
        this.jButtonImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonImportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonImport);
        this.jButtonImport.getAccessibleContext().setAccessibleDescription("");
        this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameOrganiser_GuidedExport.png")));
        this.jButtonExport.setToolTipText("Guided export");
        this.jButtonExport.setFocusable(false);
        this.jButtonExport.setHorizontalTextPosition(0);
        this.jButtonExport.setVerticalTextPosition(3);
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonExportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonExport);
        this.jButtonExport.getAccessibleContext().setAccessibleDescription("");
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonOpenFile.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameOrganiser_OpenFile.png")));
        this.jButtonOpenFile.setToolTipText("Open common file type");
        this.jButtonOpenFile.setFocusable(false);
        this.jButtonOpenFile.setHorizontalTextPosition(0);
        this.jButtonOpenFile.setVerticalTextPosition(3);
        this.jButtonOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonOpenFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenFile);
        this.jButtonOpenWells.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameIcon_Wells/24Wells.png")));
        this.jButtonOpenWells.setToolTipText("Open wells");
        this.jButtonOpenWells.setFocusable(false);
        this.jButtonOpenWells.setHorizontalTextPosition(0);
        this.jButtonOpenWells.setVerticalTextPosition(3);
        this.jButtonOpenWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonOpenWellsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenWells);
        this.jButtonOpenProject.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameOrganiser_OpenProject.png")));
        this.jButtonOpenProject.setToolTipText("Open project");
        this.jButtonOpenProject.setFocusable(false);
        this.jButtonOpenProject.setHorizontalTextPosition(0);
        this.jButtonOpenProject.setVerticalTextPosition(3);
        this.jButtonOpenProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonOpenProjectActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonOpenProject);
        this.jToolBar1.add(this.jSeparator4);
        this.jButtonSaveToDatabase.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameOrganiser_SaveToDB.png")));
        this.jButtonSaveToDatabase.setToolTipText("Save workspace to database");
        this.jButtonSaveToDatabase.setFocusable(false);
        this.jButtonSaveToDatabase.setHorizontalTextPosition(0);
        this.jButtonSaveToDatabase.setVerticalTextPosition(3);
        this.jButtonSaveToDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonSaveToDatabaseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSaveToDatabase);
        this.jButtonSaveToFile.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameOrganiser_SaveToFile.png")));
        this.jButtonSaveToFile.setToolTipText("Save workspace to a file");
        this.jButtonSaveToFile.setFocusable(false);
        this.jButtonSaveToFile.setHorizontalTextPosition(0);
        this.jButtonSaveToFile.setVerticalTextPosition(3);
        this.jButtonSaveToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonSaveToFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSaveToFile);
        this.jToolBar1.add(this.jSeparator7);
        this.jButtonDataTypes.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameOrganiser_ViewDataTypes.png")));
        this.jButtonDataTypes.setToolTipText("Data types");
        this.jButtonDataTypes.setFocusable(false);
        this.jButtonDataTypes.setHorizontalTextPosition(0);
        this.jButtonDataTypes.setVerticalTextPosition(3);
        this.jButtonDataTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jButtonDataTypesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDataTypes);
        this.jMenuFile.setText("File");
        this.jMenuItemGuidedImport.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.jMenuItemGuidedImport.setText("Guided import...");
        this.jMenuItemGuidedImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemGuidedImportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemGuidedImport);
        this.jMenuItemGuidedExport.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMenuItemGuidedExport.setText("Guided export...");
        this.jMenuItemGuidedExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemGuidedExportActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemGuidedExport);
        this.jMenuFile.add(this.jSeparator1);
        this.jMenuOpenFile.setText("Open file...");
        this.jMenuItemOpenCommon.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemOpenCommon.setFont(new Font("Segoe UI", 1, 12));
        this.jMenuItemOpenCommon.setText("Common types...");
        this.jMenuItemOpenCommon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenCommonActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenCommon);
        this.jMenuOpenFile.add(this.jSeparator10);
        this.jMenuItemOpenDEX.setText("DEX...");
        this.jMenuItemOpenDEX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenDEXActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenDEX);
        this.jMenuItemOpenXML.setText("XML...");
        this.jMenuItemOpenXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenXMLActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenXML);
        this.jMenuItemOpenCSV.setText("CSV...");
        this.jMenuItemOpenCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenCSVActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenCSV);
        this.jMenuItemOpenZip.setText("SBG,Zip...");
        this.jMenuItemOpenZip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenZipActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenZip);
        this.jMenuItemOpenBugWare.setText("BugWare...");
        this.jMenuItemOpenBugWare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenBugWareActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenBugWare);
        this.jMenuItemOpenChecklist.setText("Checklist data set...");
        this.jMenuItemOpenChecklist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenChecklistActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenChecklist);
        this.jMenuItemOpenRG.setText("RG...");
        this.jMenuItemOpenRG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenRGActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenRG);
        this.jMenuItemOpenSbugs.setText("(old) StrataBugs...");
        this.jMenuItemOpenSbugs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenSbugsActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSbugs);
        this.jMenuItemOpenSISSbugs.setText("SIS \"StrataBugs\" files ...");
        this.jMenuItemOpenSISSbugs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenSISSbugsActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSISSbugs);
        this.jMenuItemOpenIGDXLS.setText("XLS interpreted data workbook...");
        this.jMenuItemOpenIGDXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenIGDXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenIGDXLS);
        this.jMenuItemOpenOWXLS.setText("OpenWorks XLS picks...");
        this.jMenuItemOpenOWXLS.setActionCommand("");
        this.jMenuItemOpenOWXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenOWXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenOWXLS);
        this.jMenuItemOpenSampleXLS.setText("XLS Sample list...");
        this.jMenuItemOpenSampleXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenSampleXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSampleXLS);
        this.jMenuItemOpenSampleOccXLS.setText("XLS Sample Occurrence list...");
        this.jMenuItemOpenSampleOccXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenSampleOccXLSActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenSampleOccXLS);
        this.jMenuOpenFile.add(this.jSeparator12);
        this.jMenuItemOpenTSCreator.setText("TSCreator file...");
        this.jMenuItemOpenTSCreator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenTSCreatorActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemOpenTSCreator);
        this.jMenuItemODM.setText("ODM Database ...");
        this.jMenuItemODM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemODMActionPerformed(evt);
            }
        });
        this.jMenuOpenFile.add(this.jMenuItemODM);
        this.jMenuFile.add(this.jMenuOpenFile);
        this.jMenuItemOpenWells.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.jMenuItemOpenWells.setText("Open wells...");
        this.jMenuItemOpenWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenWellsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenWells);
        this.jMenuItemOpenProject.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        this.jMenuItemOpenProject.setText("Open project...");
        this.jMenuItemOpenProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOpenProjectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenProject);
        this.jMenuFile.add(this.jSeparator2);
        this.jMenuItemSaveInDatabase.setText("Save  to database");
        this.jMenuItemSaveInDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemSaveInDatabaseActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveInDatabase);
        this.jMenuSaveToFile.setText("Save to file");
        this.jMenuItemSaveZipFile.setFont(new Font("Tahoma", 1, 11));
        this.jMenuItemSaveZipFile.setText("as StrataBugs SBG file...");
        this.jMenuItemSaveZipFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemSaveZipFileActionPerformed(evt);
            }
        });
        this.jMenuSaveToFile.add(this.jMenuItemSaveZipFile);
        this.jMenuItemSaveXML.setText("as XML...");
        this.jMenuItemSaveXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemSaveXMLActionPerformed(evt);
            }
        });
        this.jMenuSaveToFile.add(this.jMenuItemSaveXML);
        this.jMenuItemSaveDEX.setText("as DEX...");
        this.jMenuItemSaveDEX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemSaveDEXActionPerformed(evt);
            }
        });
        this.jMenuSaveToFile.add(this.jMenuItemSaveDEX);
        this.jMenuItemSaveText.setText("as text...");
        this.jMenuItemSaveText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemSaveTextActionPerformed(evt);
            }
        });
        this.jMenuSaveToFile.add(this.jMenuItemSaveText);
        this.jMenuFile.add(this.jMenuSaveToFile);
        this.jMenuItemReplaceAll.setText("Replace all in database...");
        this.jMenuItemReplaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemReplaceAllActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemReplaceAll);
        this.jMenuFile.add(this.jSeparator6);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuView.setText("View");
        this.jMenuItemDataTypes.setText("Data types...");
        this.jMenuItemDataTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemDataTypesActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemDataTypes);
        this.jMenuItemViewVersion.setText("Version....");
        this.jMenuItemViewVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemViewVersionActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemViewVersion);
        this.jMenuItemRemoveVersion.setText("Remove selected version tab");
        this.jMenuItemRemoveVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemRemoveVersionActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemRemoveVersion);
        this.jMenuItemViewExclude.setText("Exclude selected wells");
        this.jMenuItemViewExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemViewExcludeActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemViewExclude);
        this.jMenuView.add(this.jSeparator11);
        this.jMenuItemLoadWorkspace.setText("Load data from database into workspace");
        this.jMenuItemLoadWorkspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemLoadWorkspaceActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemLoadWorkspace);
        this.jMenuView.add(this.jSeparator5);
        this.jCheckBoxMenuItemAutoScroll.setSelected(true);
        this.jCheckBoxMenuItemAutoScroll.setText("Fit main table within frame");
        this.jCheckBoxMenuItemAutoScroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jCheckBoxMenuItemAutoScrollActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jCheckBoxMenuItemAutoScroll);
        this.jMenu1.setText("Units");
        this.buttonGroupMenuUnits.add(this.jRadioButtonMenuItemMetres);
        this.jRadioButtonMenuItemMetres.setText("Metres");
        this.jRadioButtonMenuItemMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jRadioButtonMenuItemMetresActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemMetres);
        this.buttonGroupMenuUnits.add(this.jRadioButtonMenuItemFeet);
        this.jRadioButtonMenuItemFeet.setText("Feet");
        this.jRadioButtonMenuItemFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jRadioButtonMenuItemFeetActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemFeet);
        this.buttonGroupMenuUnits.add(this.jRadioButtonMenuItemDrilled);
        this.jRadioButtonMenuItemDrilled.setSelected(true);
        this.jRadioButtonMenuItemDrilled.setText("As drilled");
        this.jRadioButtonMenuItemDrilled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jRadioButtonMenuItemDrilledActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jRadioButtonMenuItemDrilled);
        this.jMenuView.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuMatch.setText("Match");
        this.jMenuMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuMatchActionPerformed(evt);
            }
        });
        this.jMenuItemMatchInterp.setText("Versions...");
        this.jMenuItemMatchInterp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchInterpActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchInterp);
        this.jMenuItemMatchAbundance.setText("Abundance...");
        this.jMenuItemMatchAbundance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchAbundanceActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchAbundance);
        this.jMenuItemMatchAnalysts.setText("Analysts...");
        this.jMenuItemMatchAnalysts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchAnalystsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchAnalysts);
        this.jMenuItemMatchTaxa.setText("Taxa...");
        this.jMenuItemMatchTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchTaxaActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchTaxa);
        this.jMenuItemMatchEvents.setText("Events...");
        this.jMenuItemMatchEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchEventsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchEvents);
        this.jMenuItemMatchIGDIntervals.setText("Stratigraphic interval units and picked surfaces...");
        this.jMenuItemMatchIGDIntervals.setToolTipText("Match occurring units and surfaces");
        this.jMenuItemMatchIGDIntervals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchIGDIntervalsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchIGDIntervals);
        this.jMenuItemMatchEnvSchemes.setText("Palaeoenvironment schemes...");
        this.jMenuItemMatchEnvSchemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchEnvSchemesActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchEnvSchemes);
        this.jMenuMatch.add(this.jSeparator13);
        this.jMenuItemMatchWells.setText("Wells...");
        this.jMenuItemMatchWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchWellsActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchWells);
        this.jMenuMatch.add(this.jSeparator9);
        this.jMenuItemMatchIGDSchemes.setText("Stratigraphic schemes...");
        this.jMenuItemMatchIGDSchemes.setToolTipText("Import or compare entire schemes (not necessary for well data import)");
        this.jMenuItemMatchIGDSchemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemMatchIGDSchemesActionPerformed(evt);
            }
        });
        this.jMenuMatch.add(this.jMenuItemMatchIGDSchemes);
        this.jMenuBar1.add(this.jMenuMatch);
        this.jMenuHelp.setText("Help");
        this.jMenuItemOrganiserHelp.setText("Organiser help...");
        this.jMenuItemOrganiserHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemOrganiserHelpActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemOrganiserHelp);
        this.jMenuHelp.add(this.jSeparator8);
        this.jMenuItemHelpMenu.setText("Menus...");
        this.jMenuItemHelpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemHelpMenuActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpMenu);
        this.jMenuItemHelpMatch.setText("Matching data...");
        this.jMenuItemHelpMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameOrganiser.this.jMenuItemHelpMatchActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpMatch);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jToolBar1, -1, 841, Short.MAX_VALUE).add((Component)this.jTabbedPane1, -1, 841, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 33, -2).addPreferredGap(0).add((Component)this.jTabbedPane1, -1, 462, Short.MAX_VALUE)));
        this.pack();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.parent.organiserFrames.remove(this);
        this.saveUserDefaults();
        this.dispose();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.parent.organiserFrames.remove(this);
        this.saveUserDefaults();
    }

    private void jMenuItemOpenDEXActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupDEXFileChooser();
        if (0 == this.jFileChooserDEX.showOpenDialog(this)) {
            this.openDEXfile(this.jFileChooserDEX.getSelectedFile());
        }
    }

    private void setupDEXFileChooser() {
        this.jFileChooserDEX = this.setupFileChooser(this.jFileChooserDEX, "WINDEXFILE", "UNXDEXFILE", "DEX files", "dex");
    }

    private void setupZIPFileChooser() {
        this.jFileChooserZIP = this.setupFileChooser(this.jFileChooserZIP, "WINZIPFILE", "UNXZIPFILE", "StrataBugs Biostratigraphy files", "sbg", "zip");
    }

    private void setupChecklistFileChooser() {
        this.jFileChooserChecklist = this.setupFileChooser(this.jFileChooserChecklist, "WINCHECFIL", "UNXCHECFIL", "Checklist files", "chk");
    }

    private void setupRGFileChooser() {
        this.jFileChooserRG = this.setupFileChooser(this.jFileChooserRG, "WINRGFILE", "UNXRGFILE", "RG files", "rg", "dat");
    }

    private void setupBugWareFileChooser() {
        this.jFileChooserBugWare = this.setupFileChooser(this.jFileChooserBugWare, "WINBUGWFIL", "UNXBUGWFIL", "BugWare files", "def", "den");
    }

    private void setupCSVFileChooser() {
        this.jFileChooserCSV = this.setupFileChooser(this.jFileChooserCSV, "WINCSVFILE", "UNXCSVFILE", "CSV/Excel taxa matrix", "csv", "xls", "xlsx");
    }

    private void setupSbugsFileChooser() {
        this.jFileChooserSbugs = this.setupFileChooser(this.jFileChooserSbugs, "WINSBUGFIL", "UNXSBUGFIL", "Old StrataBugs files", "txt", "dat");
    }

    private void setupXMLFileChooser() {
        this.jFileChooserXML = this.setupFileChooser(this.jFileChooserXML, "JXMLFILE", "UNXXMLFILE", "XML files", "xml");
    }

    private void setupXLSFileChooser() {
        this.jFileChooserXLS = this.setupFileChooser(this.jFileChooserXLS, "JXLSFILE", "UNXXLSFILE", "XLS files", "xls", "xlsx");
    }

    private JFileChooser setupFileChooser(JFileChooser jFileChooser, String winKey, String unxKey, String description, String ... extensions) {
        if (jFileChooser == null) {
            jFileChooser = new JFileChooser();
            File setDir = null;
            try {
                setDir = new File(Lastval.getString((SBdb)this.db, (String)winKey, (String)unxKey));
            }
            catch (SQLException sql) {
                // empty catch block
            }
            if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
                setDir = new File(".");
            }
            try {
                jFileChooser.setCurrentDirectory(setDir);
            }
            catch (Exception ex1) {
                // empty catch block
            }
            if (description != null) {
                SbugsFileFilter filter = new SbugsFileFilter();
                for (String ext : extensions) {
                    filter.addExtension(ext);
                }
                filter.setDescription(description);
                jFileChooser.setFileFilter((FileFilter)filter);
            }
        }
        return jFileChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openXMLfile(File xmlFile, ZipFile zipFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Document xmlDocument = SbugsMLdocument.getXmlDocument(xmlFile);
            this.dataTypes.clear();
            String fileName = "";
            if (zipFile != null) {
                String temp = zipFile.getName().substring(zipFile.getName().lastIndexOf(92));
                fileName = temp.length() > 0 ? "..." + temp : zipFile.getName();
            } else if (xmlFile != null) {
                fileName = xmlFile.getName();
            }
            this.ws.parseXMLDocument(xmlDocument, this.dataTypes, zipFile, fileName);
            System.out.println(xmlFile + " is well-formed and valid. Contains: " + xmlDocument.getContentSize() + " elements.");
            this.checkVersionPanels();
            this.refreshView();
            Lastval.putString((SBdb)this.db, (String)"WINXMLFILE", (String)"UNXXMLFILE", (String)xmlFile.getPath());
            this.db.getDatabase().commit();
            this.inWizard = true;
        }
        catch (JDOMException e) {
            JOptionPane.showMessageDialog(this, xmlFile + " is not well-formed or invalid.\n" + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Could not check " + xmlFile + ".\n" + e.getMessage());
        }
        catch (OutOfMemoryError bounded) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "Cannot read file: Memory limit for application exceeded. Total available: " + Runtime.getRuntime().maxMemory() / 1024000L + "MB" + '\n' + "Contact StrataData for workaround or reduce size of import file");
        }
        catch (SAXParseException ex) {
            JOptionPane.showMessageDialog(this, "Error during XML parsing: " + ex.getMessage() + "\nCheck that file is a Stratabugs XML file, or send to StrataData for advice.", this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read.", (Exception)ex);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void checkVersionPanels() throws SQLException {
        for (InterpHdr interpHdr : this.ws.getInterps()) {
            boolean found = false;
            for (Component comp : this.jTabbedPane1.getComponents()) {
                JPanelOrganiser panel = (JPanelOrganiser)comp;
                if (panel.hdr == null || panel.hdr.getInterpID() != interpHdr.getInterpID()) continue;
                found = true;
                break;
            }
            if (found) continue;
            JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, interpHdr, this.dataTypes);
            this.jTabbedPane1.add(panel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openDEXfile(File dexFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
            int interpID = 0;
            if (panel.hdr != null) {
                interpID = panel.hdr.getInterpID();
            }
            new DEXFile(this.ws, this.db.getUser(), dexFile.getPath(), this.dataTypes, this.db.getLithdesc(), interpID);
            this.refreshView();
            Lastval.putString((SBdb)this.db, (String)"WINDEXFILE", (String)"UNXDEXFILE", (String)dexFile.getPath());
            this.db.getDatabase().commit();
            this.inWizard = true;
        }
        catch (OutOfMemoryError bounded) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "Cannot read file: Memory limit for application exceeded. Total available: " + Runtime.getRuntime().maxMemory() / 1024000L + "MB" + '\n' + "Contact StrataData for workaround or reduce size of import file");
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Can't find file: " + dexFile.getPath(), "DEX Reader", 2);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read.", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openBugWarefile(File bugFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            Lastval.putString((SBdb)this.db, (String)"WINBUGWFIL", (String)"UNXBUGWFIL", (String)bugFile.getPath());
            this.db.getDatabase().commit();
            JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
            DialogBugWareReader dialogParam = new DialogBugWareReader((Frame)this, true, this.db, bugFile.getPath());
            dialogParam.setLocationRelativeTo(this);
            dialogParam.setVisible(true);
            if (!dialogParam.isOK) {
                this.inWizard = false;
                return;
            }
            BugWareReader reader = new BugWareReader(this.ws, bugFile.getPath(), this.dataTypes, dialogParam.discID, dialogParam.units, dialogParam.analyst, dialogParam.useBioStratComments, dialogParam.ignoreSemiQuant, dialogParam.useSampleTops);
            this.refreshView();
            this.inWizard = true;
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read.", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openRGFile(File rgFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            Lastval.putString((SBdb)this.db, (String)"WINRGFILE", (String)"UNXRGFILE", (String)rgFile.getPath());
            this.db.getDatabase().commit();
            JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
            RGReader reader = new RGReader(rgFile.getPath(), this.dataTypes, this.ws);
            this.refreshView();
            this.inWizard = true;
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read.", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openXLSFile(File xlsFile, int type) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            Lastval.putString((SBdb)this.db, (String)"JXLSFILE", (String)"UNXSLXFILE", (String)xlsFile.getPath());
            this.db.getDatabase().commit();
            JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
            if (type == 1) {
                IGDXLSReader reader = new IGDXLSReader(this.ws, xlsFile, this.dataTypes);
            } else if (type == 2) {
                DialogOWXLSReader dialog = new DialogOWXLSReader(this, true, this.db, this.ws, xlsFile, this.dataTypes);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                this.checkVersionPanels();
            } else if (type == 3) {
                SampleReaderXLS reader = new SampleReaderXLS(this.ws, xlsFile, this.dataTypes);
            } else if (type == 4) {
                DialogImportAnalyses dialogImport = new DialogImportAnalyses((Frame)this, true, this.db, this.ws);
                dialogImport.setLocationRelativeTo(this);
                dialogImport.setVisible(true);
                if (!dialogImport.isOK) {
                    this.inWizard = false;
                    return;
                }
                SampleOccReaderXLS reader = new SampleOccReaderXLS(this.ws, xlsFile, this.dataTypes, dialogImport.analyst, dialogImport.discID, dialogImport.units);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (InvalidFormatException iof) {
            JOptionPane.showMessageDialog(this, "invalid format Exception reading file: " + iof.getMessage(), this.getTitle(), 2);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error reading file: " + e.getMessage(), this.getTitle(), 2);
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read", (Exception)ex);
            ex.printStackTrace();
        }
        finally {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error", (Exception)e);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.inWizard = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSbugsFile(File sbugsFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            Lastval.putString((SBdb)this.db, (String)"WINSBUGFIL", (String)"UNXSBUGFIL", (String)sbugsFile.getPath());
            this.db.getDatabase().commit();
            SbugsReader reader = new SbugsReader(sbugsFile.getPath(), this.ws, this.dataTypes, "SBUGSANALYST");
            this.refreshView();
            this.inWizard = true;
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read.", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSISSbugsFile(File SISsbugsFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            Lastval.putString((SBdb)this.db, (String)"WINSISSB", (String)"UNXSISSB", (String)SISsbugsFile.getPath());
            this.db.getDatabase().commit();
            SISSbugsReader reader = new SISSbugsReader(SISsbugsFile.getPath(), this.ws, this.dataTypes, "SIS");
            this.refreshView();
            this.inWizard = true;
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read.", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChecklistfile(File checkFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.dataTypes.clear();
        try {
            Lastval.putString((SBdb)this.db, (String)"WINCHECFIL", (String)"UNXCHECFIL", (String)checkFile.getPath());
            this.db.getDatabase().commit();
            DialogChecklistReader dialogParam = new DialogChecklistReader((Frame)this, true, this.db, checkFile.getPath());
            dialogParam.setLocationRelativeTo(this);
            dialogParam.setVisible(true);
            if (!dialogParam.isOK) {
                this.inWizard = false;
                return;
            }
            ChecklistReader reader = new ChecklistReader(this.ws, checkFile.getPath(), this.dataTypes, dialogParam.discID, dialogParam.units, dialogParam.analyst, dialogParam.sampleType, dialogParam.useSampleTops);
            this.showReaderRejectsMessage(reader.rejects);
            this.refreshView();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read.", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openCSVfile(File csvFile) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            HashSet donorSampleTypes;
            JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
            DialogCSVImport dialogParam = new DialogCSVImport(this, true, this.db, csvFile.getPath(), false);
            dialogParam.setLocationRelativeTo(this);
            dialogParam.setVisible(true);
            if (!dialogParam.isOK()) {
                this.inWizard = false;
                return;
            }
            DialogImportAnalyses dialogImport = new DialogImportAnalyses((Frame)this, true, this.db, this.ws);
            dialogImport.setLocationRelativeTo(this);
            dialogImport.setVisible(true);
            if (!dialogImport.isOK) {
                this.inWizard = false;
                return;
            }
            CSVReader reader = new CSVReader(this.ws, SB.getGridReader((String)csvFile.getPath()), this.dataTypes, dialogImport.discID, dialogImport.units, dialogImport.analyst.getAbr(), dialogParam.titleRow - 1, dialogParam.catRow - 1, dialogParam.startRow - 1, dialogParam.colStart[0], dialogParam.colStart[1], dialogParam.colStart[2], dialogParam.colStart[3], dialogParam.colStart[5], dialogParam.colStart[4], dialogParam.colStart[6], dialogParam.colTaxaEnd, dialogParam.isBiocom, dialogImport.isWell, dialogImport.setEmptyAsBarren, dialogImport.sampleType);
            this.showReaderRejectsMessage(reader.rejects);
            if (this.hasFssDataTypes()) {
                try {
                    this.ws.checkDefaultAbnScheme();
                }
                catch (SBException sbe) {
                    SB.showStackError((String)"Error during file read", (Exception)((Object)sbe));
                }
            }
            if ((donorSampleTypes = this.ws.getDonorSampleTypes()) != null) {
                DialogMatchSampleTypes dialogTypes = new DialogMatchSampleTypes(this, true, this.ws, this.db, donorSampleTypes);
                dialogTypes.setLocationRelativeTo(this);
                dialogTypes.setVisible(true);
                if (!dialogTypes.isOK()) {
                    this.inWizard = false;
                    return;
                }
            }
            this.refreshView();
            Lastval.putString((SBdb)this.db, (String)"WINCSVFILE", (String)"UNXCSVFILE", (String)csvFile.getPath());
            this.db.getDatabase().commit();
            this.inWizard = true;
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error during file read", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void showReaderRejectsMessage(HashSet readerRejects) {
        if (!readerRejects.isEmpty()) {
            String rejects = "";
            Iterator it = readerRejects.iterator();
            while (it.hasNext()) {
                if (!rejects.isEmpty()) {
                    rejects = rejects + ", ";
                }
                rejects = rejects + it.next();
            }
            String message = "Warning:\nSome possible semi-quantitative or qualifier tags have been\nignored in favour of numerical data:\n\n" + rejects;
            JOptionPane.showMessageDialog(this, message, this.getTitle(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemMatchWellsActionPerformed(ActionEvent evt) {
        try {
            DialogMatchWells dialog = new DialogMatchWells((Frame)this, true, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                this.inWizard = false;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.refreshView();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error matching wells", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void jCheckBoxMenuItemAutoScrollActionPerformed(ActionEvent evt) {
        for (Component comp : this.jTabbedPane1.getComponents()) {
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            if (this.autoResize) {
                panel.getJtableOrg().setAutoResizeMode(0);
                this.autoResize = false;
                continue;
            }
            panel.getJtableOrg().setAutoResizeMode(2);
            this.autoResize = true;
        }
    }

    private void jMenuItemMatchAnalystsActionPerformed(ActionEvent evt) {
        try {
            if (!this.inWizard && (this.ws.getUsers() == null || this.ws.getUsers().isEmpty())) {
                JOptionPane.showMessageDialog(this, "There are no analysts in the workspace", "Match Analysts", 1);
                return;
            }
            DialogMatchAnalysts dialog = new DialogMatchAnalysts((Frame)this, true, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening Match personnel dialog.", (Exception)e);
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error matching analaysts", (Exception)e);
            }
        }
    }

    private void jMenuItemMatchTaxaActionPerformed(ActionEvent evt) {
        if (!this.inWizard && !this.ws.hasTaxa()) {
            JOptionPane.showMessageDialog(this, "There are no taxa in the workspace", "Match Taxa", 1);
            return;
        }
        try {
            DialogMatchTaxa dialog = new DialogMatchTaxa(this, true, this.ws, this.db, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
            if (evt != null) {
                Iterator it = this.ws.getProject(0).getWellIterator();
                while (it.hasNext()) {
                    WsWell w = (WsWell)it.next();
                    w.updateSampleStatus(true);
                }
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening Match taxa dialog.", (Exception)e);
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error matching taxa", (Exception)e);
            }
        }
    }

    private void jMenuItemMatchAbundanceActionPerformed(ActionEvent evt) {
        try {
            AbnScheme scheme;
            if (this.ws.getAbnSchemes().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no abundance schemes in the workspace", "Match Abundance", 2);
                return;
            }
            if (this.ws.getAbnSchemes().size() > 1) {
                DialogSelectAbnScheme dialogSel = new DialogSelectAbnScheme((Frame)this, true, this.ws);
                dialogSel.setLocationRelativeTo(this);
                dialogSel.setVisible(true);
                if (dialogSel.scheme == null) {
                    return;
                }
                scheme = dialogSel.scheme;
            } else {
                scheme = (AbnScheme)this.ws.getAbnSchemes().get(0);
            }
            this.matchAbnScheme(scheme);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening Match abundance dialog.", (Exception)e);
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error matching abundance", (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInDatabase(final boolean replace) {
        try {
            this.isSavingData = false;
            for (Userdef user : this.ws.getUsers()) {
                if (user.getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "Analysts not matched. Use Match | Analysts", this.getTitle(), 2);
                return;
            }
            boolean isConflict = false;
            Iterator it = this.ws.getProject(0).getWellIterator();
            if (!it.hasNext()) {
                JOptionPane.showMessageDialog(this, "No data to save! Open a file.", this.getTitle(), 1);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            block21: while (it.hasNext()) {
                WellInterp wellInterp;
                Iterator wit;
                WsWell well = (WsWell)it.next();
                if (well.getLink() == null) continue;
                if (well.getStatus() == WsWell.CONFLICT) {
                    if (well.getWellUnits() != well.getLink().getWellUnits()) {
                        isConflict = true;
                        JOptionPane.showMessageDialog(this.isVisible() ? this : null, "Cannot save: conflicting well header data/depth units in workspace", this.getTitle(), 2);
                        break;
                    }
                    if (JOptionPane.showConfirmDialog(this, "Do you want to ignore conflicting well header details for '" + well.getWellName() + "'?\n(Non-conflicting new values will be saved)", this.getTitle(), 0) != 0) {
                        isConflict = true;
                        break;
                    }
                    DialogMatchWellHeader dialog = new DialogMatchWellHeader(this, true, this.ws, this.db, well);
                    LinkedList<Integer> excludes = new LinkedList<Integer>();
                    for (int i = 0; i < dialog.model.getRowCount(); ++i) {
                        if (((StringStatus)dialog.model.getValueAt(i, 1)).getStatus() != StringStatus.CONFLICT) continue;
                        excludes.add(i);
                    }
                    int[] ints = new int[excludes.size()];
                    for (int j = 0; j < excludes.size(); ++j) {
                        ints[j] = (Integer)excludes.get(j);
                    }
                    dialog.model.exclude(ints);
                    well.updateHeaderStatus();
                }
                for (int dType : this.dataTypes) {
                    for (Component comp : this.jTabbedPane1.getComponents()) {
                        JPanelOrganiser panel = (JPanelOrganiser)comp;
                        if (SBdb.isInterpDataType((int)dType) && panel.hdr != null && panel.hdr.getLink() == null) {
                            JOptionPane.showMessageDialog(this, "Versions not matched. Use Match | Version", this.getTitle(), 2);
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        if (SBdb.isInterpDataType((int)dType) && panel.hdr == null || replace && dType != 1 || well.getDataMonitor(dType, 'M', panel.getInterpID()).getStatus() != SbugsStatus.CONFLICT) continue;
                        isConflict = true;
                        JOptionPane.showMessageDialog(this.isVisible() ? this : null, "Cannot save: conflicting data in workspace", this.getTitle(), 2);
                        this.setCursor(Cursor.getDefaultCursor());
                        break block21;
                    }
                }
                if (this.dataTypes.contains(8) || this.dataTypes.contains(2) || this.dataTypes.contains(4) || this.dataTypes.contains(6)) {
                    for (AnalystHeader hdr : well.getAnalystHeaders()) {
                        if (!(hdr.getDiscipline() == Discipline.MICRO && this.dataTypes.contains(2) || hdr.getDiscipline() == Discipline.MACRO && this.dataTypes.contains(8) || hdr.getDiscipline() == Discipline.PALY && this.dataTypes.contains(6)) && (hdr.getDiscipline() != Discipline.NANNO || !this.dataTypes.contains(4)) || hdr.getStatus() != SbugsStatus.CONFLICT) continue;
                        String msg = "Cannot save: conflict in analyst suite header (" + SBdb.getDiscAbr((char)hdr.getDiscID()) + ") - match suites from Match Analyses dialog";
                        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    for (Sample sample : well.getSamples()) {
                        for (Smpdtl smpdtl : sample.getAnalyses()) {
                            AbnScheme abnScheme;
                            for (TaxonOcc occ : smpdtl.getOccur()) {
                                if (occ.getTaxon() == null) {
                                    JOptionPane.showMessageDialog(this, "Cannot save: unreferenced taxa in workspace, remove '" + smpdtl.getDiscID() + "' analyses before attempting to save data.", this.getTitle(), 2);
                                    this.setCursor(Cursor.getDefaultCursor());
                                    return;
                                }
                                if (occ.getTaxon().getLink() != null) continue;
                                JOptionPane.showMessageDialog(this, "Cannot save: unmatched taxa in workspace, use Match | Taxa", this.getTitle(), 2);
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (smpdtl.getProximal() > 0 && this.ws.getEnvScheme(well.getAnalystHeader(smpdtl.getAnalyst(), smpdtl.getDiscID(), smpdtl.getAnalyNo(), false).getEnvSchID()).getLink() == null) {
                                JOptionPane.showMessageDialog(this, "Cannot save: unmatched environment schemes in workspace, use Match | Palaeoenvironment schemes", this.getTitle(), 2);
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (smpdtl.getHeader().getAbnSchID() <= 0 || (abnScheme = this.ws.getAbnScheme(smpdtl.getHeader().getAbnSchID(), false)) != null && abnScheme.getLink() != null) continue;
                            JOptionPane.showMessageDialog(this, "Cannot save: unmatched abundance schemes in workspace, use Match | Abundance", this.getTitle(), 2);
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                    }
                }
                if (this.dataTypes.contains(14)) {
                    wit = well.getInterpIterator();
                    while (wit.hasNext()) {
                        wellInterp = (WellInterp)wit.next();
                        for (SQPick pick : wellInterp.getSQPicks()) {
                            if (pick.getSurface().getLink() != null) continue;
                            JOptionPane.showMessageDialog(this, "Sequence picks not matched. Use Match | Stratigrahpic intervals and surfaces", this.getTitle(), 2);
                            this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                    }
                }
                if (!this.dataTypes.contains(15)) continue;
                wit = well.getInterpIterator();
                while (wit.hasNext()) {
                    wellInterp = (WellInterp)wit.next();
                    for (IGDIntervalEnv env : wellInterp.getEnvs()) {
                        EnvScheme scheme = this.ws.getEnvScheme(env.getSchID());
                        if (scheme != null && scheme.getLink() != null) continue;
                        System.out.println("Return from getEnvScheme, schemeID=" + env.getSchID() + ", scheme=" + scheme);
                        JOptionPane.showMessageDialog(this, "Palaeoenvironment scheme(s) not matched. Use Match | Palaeoenvironment schemes", this.getTitle(), 2);
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                }
            }
            if (!isConflict) {
                String msg;
                if (replace && JOptionPane.showConfirmDialog(this, msg = "ALL database data for selected data types will be deleted before saving new data.\nNote: no samples will be deleted.\nAre you sure you want to continue?", this.getTitle(), 0) != 0) {
                    return;
                }
                this.pm = new ProgressMonitor(this, "Saving well data:", "", 0, 100);
                this.pm.setProgress(0);
                this.pm.setMillisToDecideToPopup(1);
                this.pm.setMillisToPopup(1);
                this.isSavingData = true;
                SwingWorker task = new SwingWorker(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Object doInBackground() throws Exception {
                        Boolean wellSaved = false;
                        int nWells = 0;
                        int totalWells = FrameOrganiser.this.ws.getProject(0).getSize();
                        Iterator it = FrameOrganiser.this.ws.getProject(0).getWellIterator();
                        WsWell well = null;
                        try {
                            while (it.hasNext()) {
                                if (this.isCancelled()) {
                                    break;
                                }
                                well = (WsWell)it.next();
                                if (well.getLink() != null) {
                                    this.setProgress(nWells * 100 / totalWells);
                                    if (replace) {
                                        try {
                                            well.deleteLinkData(FrameOrganiser.this.dataTypes);
                                        }
                                        catch (Exception e) {
                                            System.out.println("Error deleting data for well: " + well.getWellName() + " : " + e.getMessage());
                                            e.printStackTrace();
                                            continue;
                                        }
                                    }
                                    well.store(FrameOrganiser.this.dataTypes);
                                    System.out.println("**************** Finished storing well: " + well);
                                    FrameOrganiser.this.db.commit();
                                    wellSaved = true;
                                }
                                this.setProgress(++nWells * 100 / totalWells);
                            }
                        }
                        catch (SQLException e) {
                            FrameOrganiser.this.inWizard = false;
                            FrameOrganiser.this.db.doRollback();
                            SB.showStackError((String)"SQL Error saving data", (SQLException)e);
                            this.relinkWell(well);
                        }
                        catch (Exception e) {
                            FrameOrganiser.this.inWizard = false;
                            FrameOrganiser.this.db.doRollback();
                            SB.showStackError((String)"Error saving data", (Exception)e);
                            this.relinkWell(well);
                        }
                        finally {
                            FrameOrganiser.this.setCursor(Cursor.getDefaultCursor());
                            FrameOrganiser.this.isSavingData = false;
                            for (Component comp : FrameOrganiser.this.jTabbedPane1.getComponents()) {
                                JPanelOrganiser panel = (JPanelOrganiser)comp;
                                panel.getSorter().fireTableDataChanged();
                            }
                        }
                        return wellSaved;
                    }

                    @Override
                    protected void done() {
                        FrameOrganiser.this.pm.close();
                        try {
                            if (this.isCancelled()) {
                                FrameOrganiser.this.db.doRollback();
                                JOptionPane.showMessageDialog(null, "Data saving cancelled: wells saved before cancelling will need to be deleted.", FrameOrganiser.this.getTitle(), 1);
                            } else {
                                FrameOrganiser.this.db.commit();
                                if (!((Boolean)this.get()).booleanValue()) {
                                    JOptionPane.showMessageDialog(null, "No data saved: check wells and data have been Matched to database", FrameOrganiser.this.getTitle(), 1);
                                } else {
                                    JOptionPane.showMessageDialog(null, "Data Saved", FrameOrganiser.this.getTitle(), 1);
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (!FrameOrganiser.this.inWizard) {
                            try {
                                FrameOrganiser.this.refreshView();
                            }
                            catch (Exception e) {
                                SB.showStackError((String)"Error: ", (Exception)e);
                            }
                        }
                        FrameOrganiser.this.isSavingData = false;
                    }

                    void relinkWell(WsWell well) {
                        System.out.println("Reloading and linking well data for well: " + well);
                        if (well.getLink() != null) {
                            try {
                                Statement stmt = FrameOrganiser.this.db.getDatabase().createStatement();
                                well.getLink().refresh(stmt);
                                stmt.close();
                            }
                            catch (Exception ex) {
                                FrameJsbugs.showStackError("Error in data refresh of StoreData", ex, FrameOrganiser.this.db);
                            }
                        }
                    }
                };
                task.addPropertyChangeListener(this);
                task.execute();
            }
        }
        catch (SQLException e) {
            this.inWizard = false;
            this.setCursor(Cursor.getDefaultCursor());
            SB.showStackError((String)"SQL Error saving data", (SQLException)e);
            this.db.doRollback();
        }
        catch (Exception e) {
            this.inWizard = false;
            this.setCursor(Cursor.getDefaultCursor());
            SB.showStackError((String)"Error saving data:", (Exception)e);
            this.db.doRollback();
        }
        finally {
            System.out.println("In finally of main method");
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error: ", (Exception)e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            try {
                SwingWorker task = (SwingWorker)evt.getSource();
                if (!task.isDone()) {
                    if (this.pm.isCanceled()) {
                        task.cancel(true);
                    } else {
                        int nWellPercent = (Integer)evt.getNewValue();
                        int nWell = this.ws.getProject(0).getSize() * nWellPercent / 100;
                        System.out.println("Setting pm note to: " + this.ws.getProject(0).getWellAt(nWell).getWellName() + ", Progress size=" + nWellPercent);
                        this.pm.setNote(this.ws.getProject(0).getWellAt(nWell).getWellName());
                        this.pm.setProgress(nWellPercent);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jMenuItemSaveInDatabaseActionPerformed(ActionEvent evt) {
        this.saveInDatabase(false);
    }

    private void jMenuItemViewVersionActionPerformed(ActionEvent evt) {
        try {
            DialogSelectVersion dialog = new DialogSelectVersion(this, true, this.db, false, this.ws.getProject(0));
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                for (InterpHdr hdr : dialog.selection) {
                    boolean toAdd = true;
                    for (Component comp : this.jTabbedPane1.getComponents()) {
                        JPanelOrganiser panel = (JPanelOrganiser)comp;
                        if (panel.hdr == null || panel.hdr.getLink() != hdr) continue;
                        JOptionPane.showMessageDialog(this, "Selected version: " + hdr + " is already displayed", this.getTitle(), 2);
                        this.jTabbedPane1.setSelectedComponent(comp);
                        toAdd = false;
                        break;
                    }
                    if (!toAdd) continue;
                    hdr = this.ws.addInterp(hdr);
                    JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, hdr, this.dataTypes);
                    this.jTabbedPane1.add(panel);
                    panel.refreshView(true);
                    this.jTabbedPane1.setSelectedComponent(panel);
                }
            }
        }
        catch (Exception e) {
            this.inWizard = false;
            SB.showStackError((String)"Error showing version selector: ", (Exception)e);
        }
    }

    private void jMenuItemMatchIGDIntervalsActionPerformed(ActionEvent evt) {
        try {
            DialogMatchIGD dialog = new DialogMatchIGD((Frame)this, true, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                this.inWizard = false;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening Match Interpreted Geological Intervals dialog.", (Exception)e);
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error matching IGD: ", (Exception)e);
            }
        }
        try {
            Iterator it = this.ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                for (InterpHdr hdr : this.ws.getInterps()) {
                    well.updateAllZonesStatus(well.getAddInterp(hdr), hdr.getLink(), this.units, false);
                }
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemMatchEnvSchemesActionPerformed(ActionEvent evt) {
        try {
            EnvScheme scheme;
            if (this.ws.getEnvSchemes().isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no palaeoenvironment schemes in the workspace", "Match Palaeoenvironments", 2);
                return;
            }
            if (this.ws.getEnvSchemes().size() > 1) {
                DialogSelectEnvScheme dialogSel = new DialogSelectEnvScheme((Frame)this, true, this.ws);
                dialogSel.setLocationRelativeTo(this);
                dialogSel.setVisible(true);
                if (dialogSel.scheme == null) {
                    return;
                }
                scheme = dialogSel.scheme;
            } else {
                scheme = (EnvScheme)this.ws.getEnvSchemes().get(0);
            }
            this.matchEnvScheme(scheme);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening dialog.", (Exception)e);
            e.printStackTrace();
        }
        finally {
            if (!this.inWizard) {
                try {
                    this.refreshView();
                }
                catch (Exception e) {
                    SB.showStackError((String)"Error refreshing: ", (Exception)e);
                }
            }
        }
    }

    private void matchAbnScheme(AbnScheme scheme) {
        try {
            DialogMatchAbundance dialog = new DialogMatchAbundance(this, true, this.ws, this.db, scheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
                return;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening Match dialog.", (Exception)e);
            e.printStackTrace();
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error refreshing: ", (Exception)e);
            }
        }
    }

    private void matchEnvScheme(EnvScheme scheme) {
        try {
            DialogMatchEnvScheme dialog = new DialogMatchEnvScheme(this, true, scheme, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                this.inWizard = false;
                return;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening Match dialog.", (Exception)e);
            e.printStackTrace();
        }
        if (!this.inWizard) {
            try {
                this.refreshView();
            }
            catch (Exception e) {
                SB.showStackError((String)"Error matching IGD: ", (Exception)e);
            }
        }
    }

    private void jMenuItemMatchIGDSchemesActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDScheme dialog = new DialogSelectIGDScheme((Frame)this, true, this.ws);
            if (dialog.model.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no schemes in the workspace", "Match Units", 1);
                return;
            }
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.scheme != null) {
                DialogMatchIGDScheme schemeDialog = new DialogMatchIGDScheme((Frame)this, true, dialog.scheme, this.db);
                schemeDialog.setLocationRelativeTo(this);
                schemeDialog.setVisible(true);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error matching IGD: ", (Exception)e);
        }
    }

    private void jMenuItemDataTypesActionPerformed(ActionEvent evt) {
        block8: {
            DialogDataTypes dialog = new DialogDataTypes((Frame)this, true, this.dataTypes);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            try {
                if (dialog.isOK) {
                    this.dataTypes.removeAll(dialog.dataTypes);
                    Iterator it = this.ws.getProject(0).getWellIterator();
                    while (it.hasNext()) {
                        WsWell wsWell = (WsWell)it.next();
                        for (int dType : this.dataTypes) {
                            if (SBdb.isInterpDataType((int)dType)) {
                                for (Component comp : this.jTabbedPane1.getComponents()) {
                                    JPanelOrganiser panel = (JPanelOrganiser)comp;
                                    wsWell.unloadData(dType, panel.getInterpID());
                                }
                                continue;
                            }
                            wsWell.unloadData(dType, 0);
                        }
                    }
                    this.dataTypes.clear();
                    this.dataTypes.addAll(dialog.newDTypes);
                    for (Component comp : this.jTabbedPane1.getComponents()) {
                        JPanelOrganiser panel = (JPanelOrganiser)comp;
                        panel.refreshView(true);
                    }
                    break block8;
                }
                this.inWizard = false;
            }
            catch (Exception e) {
                SB.showStackError((String)e.getMessage(), (Exception)e);
                e.printStackTrace();
            }
        }
    }

    private void jMenuItemOpenWellsActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        try {
            DialogSelectWell dialog = new DialogSelectWell((Frame)this, true, this.db, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                for (Well well : dialog.selection) {
                    this.db = dialog.dataModel;
                    this.addWsWell(well);
                }
                this.refreshView();
            } else {
                this.inWizard = false;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"SQL Error: ", (Exception)e);
        }
    }

    void addWsWell(Well well) throws SQLException, SBException {
        WsWell wsWell;
        well.loadInterps();
        Iterator itw = this.ws.getProject(0).getWellIterator();
        boolean found = false;
        while (itw.hasNext()) {
            wsWell = (WsWell)itw.next();
            if (well != wsWell.getLink()) continue;
            found = true;
            break;
        }
        if (!found) {
            wsWell = new WsWell(this.ws, well);
            this.ws.getProject(0).addWell(this.ws, (Well)wsWell);
        }
    }

    private void jMenuItemOpenProjectActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        try {
            DialogSelectProject dialog = new DialogSelectProject((Frame)this, true, this.db, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.project = dialog.selection;
                this.project.loadWells(this.db, null);
                Iterator itw = this.project.getWellIterator();
                while (itw.hasNext()) {
                    this.addWsWell((Well)itw.next());
                }
                this.refreshView();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"SQL Error: ", (Exception)e);
        }
    }

    private void jMenuItemOpenXMLActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXMLFileChooser();
        Object file = null;
        if (0 == this.jFileChooserXML.showOpenDialog(this)) {
            this.openXMLfile(this.jFileChooserXML.getSelectedFile(), null);
        }
    }

    private void jMenuItemOpenCSVActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupCSVFileChooser();
        if (0 == this.jFileChooserCSV.showOpenDialog(this)) {
            this.openCSVfile(this.jFileChooserCSV.getSelectedFile());
        }
    }

    private void saveCommon() {
        String defaultFileName = null;
        if (this.project != null) {
            defaultFileName = this.project.getName();
        } else {
            try {
                if (this.ws.getProject(0).getSize() == 1) {
                    Well well = this.ws.getProject(0).getWellAt(0);
                    defaultFileName = well.getWellCode();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception from getting default well in saveCommon: " + ex.toString());
                ex.printStackTrace();
            }
        }
        String[] extensions = new String[]{"sbg", "zip", "dex"};
        String[] descriptions = new String[]{"StrataBugs XML/SBG", "StrataBugs XML/ZIP files", "DEX"};
        File file = FrameJsbugs.chooseFile(this.db, this, "WINFILE", "UNXFILE", extensions, descriptions, defaultFileName);
        if (file == null) {
            return;
        }
        String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        if (extension.equalsIgnoreCase("zip") || extension.equalsIgnoreCase("sbg")) {
            this.saveZipFile(file);
        } else {
            this.exportDEX(file);
        }
    }

    private void jMenuItemSaveXMLActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        this.setupXMLFileChooser();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == this.jFileChooserXML.showSaveDialog(this)) {
            if (this.jFileChooserXML.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            try {
                this.exportXML(this.jFileChooserXML.getSelectedFile(), null);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
            catch (SBException ex) {
                JOptionPane.showMessageDialog(this, "SB Error : " + ex.getMessage(), "SB Error", 0);
            }
            catch (SQLException ex) {
                JOptionPane.showMessageDialog(this, "SQL Error : " + ex.getMessage(), "SQL Error", 0);
            }
            catch (JDOMException ex) {
                JOptionPane.showMessageDialog(this, "File exported but XML is invalid: " + ex.getMessage() + "\nPlease report to StrataData for more information");
            }
            catch (SAXException ex) {
                JOptionPane.showMessageDialog(this, "File exported but XML is invalid: " + ex.getMessage() + "\nPlease report to StrataData for more information");
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jMenuItemSaveDEXActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        this.setupDEXFileChooser();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == this.jFileChooserDEX.showSaveDialog(this)) {
            if (this.jFileChooserDEX.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.exportDEX(this.jFileChooserDEX.getSelectedFile());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean allowExport() {
        if ((this.db.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.\n(See config | Personnel for privilege options)", this.getTitle(), 2);
            return false;
        }
        return true;
    }

    private void jMenuItemSaveTextActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        try {
            if (this.ws.getUsers().isEmpty()) {
                this.jMenuItemLoadWorkspaceActionPerformed(null);
            }
            if (!this.checkCSVexport()) {
                return;
            }
            Component comp = this.jTabbedPane1.getSelectedComponent();
            JPanelOrganiser panel = (JPanelOrganiser)comp;
            DialogExportText dialog = new DialogExportText(this, true, this.db, this.dataTypes, this.ws.getProject(0), panel.hdr == null ? this.db.getInterp(0) : panel.hdr, this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            SB.showStackError((String)"SQL Error: ", (Exception)e);
        }
    }

    private void jMenuItemOpenCommonActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openCommon();
    }

    private void openCommon() {
        if (this.jFileChooserCommonOpen == null) {
            this.jFileChooserCommonOpen = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Biostratigraphy files (sbg,dat,txt,csv,xls,dex,xml,zip)", "sbg", "dat", "txt", "csv", "xls", "xlsx", "dex", "xml", "zip");
            this.jFileChooserCommonOpen.setFileFilter(filter);
            this.jFileChooserCommonOpen.setAcceptAllFileFilterUsed(false);
            File setDir = null;
            try {
                setDir = new File(Lastval.getString((SBdb)this.db, (String)"WINFILE", (String)"UNXFILE"));
            }
            catch (SQLException ex) {
                // empty catch block
            }
            if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
                setDir = new File(".");
            }
            try {
                this.jFileChooserCommonOpen.setCurrentDirectory(setDir);
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
        if (0 == this.jFileChooserCommonOpen.showOpenDialog(this)) {
            File file = this.jFileChooserCommonOpen.getSelectedFile();
            try {
                Lastval.putString((SBdb)this.db, (String)"WINFILE", (String)"UNXFILE", (String)file.getPath());
                this.db.commit();
                String fileName = file.getPath();
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim();
                if (fileType.equals("dex")) {
                    this.openDEXfile(file);
                } else if (fileType.equals("xml")) {
                    this.openXMLfile(file, null);
                } else if (fileType.equals("zip") || fileType.equals("sbg")) {
                    this.openZipArchive(file);
                } else if (fileType.equals("csv") || fileType.equals("xls") || fileType.equals("xlsx")) {
                    this.openCSVfile(file);
                } else if (fileType.equals("txt")) {
                    this.openSbugsFile(file);
                } else if (fileType.equals("dat")) {
                    this.openSbugsFile(file);
                } else {
                    JOptionPane.showMessageDialog(this, "File type not supported for file: " + file, this.getTitle(), 1);
                }
            }
            catch (Exception ex) {
                SB.showStackError((String)ex.getMessage(), (Exception)ex);
                ex.printStackTrace();
            }
        }
    }

    private void jButtonOpenFileActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.openCommon();
    }

    private void jButtonOpenWellsActionPerformed(ActionEvent evt) {
        this.jMenuItemOpenWellsActionPerformed(evt);
    }

    private void jButtonOpenProjectActionPerformed(ActionEvent evt) {
        this.jMenuItemOpenProjectActionPerformed(evt);
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void jMenuItemGuidedImportActionPerformed(ActionEvent evt) {
        this.importFile();
    }

    private void jMenuItemGuidedExportActionPerformed(ActionEvent evt) {
        this.export();
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        this.importFile();
    }

    private void jButtonSaveToFileActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        this.saveCommon();
    }

    private void jMenuItemSaveZipFileActionPerformed(ActionEvent evt) {
        if (!this.allowExport()) {
            return;
        }
        if (this.jFileChooserZIP == null) {
            this.setupZIPFileChooser();
        }
        if (0 == this.jFileChooserZIP.showSaveDialog(this)) {
            File file = this.jFileChooserZIP.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.saveZipFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveZipFile(File file) {
        try {
            String rootName;
            if (!file.getName().toLowerCase().endsWith(".zip") && !file.getName().toLowerCase().endsWith(".sbg")) {
                rootName = file.getName();
                file = new File(file.getPath() + ".sbg");
            } else {
                rootName = file.getName().substring(0, file.getName().length() - 4);
            }
            Lastval.putString((SBdb)this.db, (String)"WINZIPFILE", (String)"UNXZIPFILE", (String)file.getPath());
            this.db.commit();
            String fileName = file.getPath();
            String fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim();
            File tempXML = new File(fileName.substring(0, fileName.lastIndexOf(46)) + ".xml");
            if (tempXML.exists() && JOptionPane.showConfirmDialog(this, "'" + tempXML + "' will be overwritten.\nContinue?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList<File> files = new LinkedList<File>();
            this.exportXML(tempXML, files);
            files.add(tempXML);
            FrameOrganiser.writeZipFile(file, files);
            JOptionPane.showMessageDialog(this, "Created sbg/zip file, name: " + fileName, "Export", 1);
            System.out.println("Created sbg/zip file, name: " + fileName);
            tempXML.delete();
        }
        catch (JDOMException ex) {
            JOptionPane.showMessageDialog(this, "File exported but XML is invalid.\nError is: " + ex.getMessage() + "\nPlease report, and send a copy of the file to StrataData for more information");
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(this, "File exported but XML is invalid.\nError is: " + ex.getMessage() + "\nPlease report, and send a copy of the file to StrataData for more information");
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error creating file", (Exception)ex);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void writeZipFile(File file, List<File> files) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ZipOutputStream zos = new ZipOutputStream(fos);
        byte[] buffer = new byte[1024];
        CRC32 crc = new CRC32();
        if (files != null) {
            for (File entryFile : files) {
                int bytesRead;
                if (entryFile.getName().toLowerCase().endsWith("zip")) continue;
                if (entryFile.isDirectory() || !entryFile.canRead()) {
                    System.err.println("Skipping: " + entryFile.getName());
                    continue;
                }
                System.out.println("Buffering: " + entryFile.getName());
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(entryFile));
                crc.reset();
                while ((bytesRead = bis.read(buffer)) != -1) {
                    crc.update(buffer, 0, bytesRead);
                }
                bis.close();
                bis = new BufferedInputStream(new FileInputStream(entryFile));
                ZipEntry entry = new ZipEntry(entryFile.getName());
                if (entryFile.getName().toLowerCase().endsWith("jpg")) {
                    entry.setMethod(0);
                    entry.setCompressedSize(entryFile.length());
                } else {
                    entry.setMethod(8);
                }
                entry.setSize(entryFile.length());
                entry.setCrc(crc.getValue());
                zos.putNextEntry(entry);
                while ((bytesRead = bis.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytesRead);
                }
                bis.close();
            }
        }
        System.out.println("Finished with zip file");
        zos.close();
    }

    private void jMenuItemViewExcludeActionPerformed(ActionEvent evt) {
        JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
        if (panel.getJtableOrg().getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No wells selected", this.getTitle(), 1);
            return;
        }
        try {
            int[] selection = panel.getJtableOrg().getSelectedRows();
            LinkedList<Well> toExclude = new LinkedList<Well>();
            for (int i = 0; i < selection.length; ++i) {
                Well well = this.ws.getProject(0).getWellAt(panel.getSorter().getIndexOf(selection[i]));
                toExclude.add(well);
            }
            for (Well well : toExclude) {
                System.out.println("Excluding well: " + well);
                this.ws.getProject(0).remove(this.ws, well);
                if (((WsWell)well).getLink() == null) continue;
                ((WsWell)well).getLink().deleteObserver((Observer)panel);
            }
            this.refreshView();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jRadioButtonMenuItemMetresActionPerformed(ActionEvent evt) {
        try {
            this.setUnits();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error setting units", (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jRadioButtonMenuItemFeetActionPerformed(ActionEvent evt) {
        try {
            this.setUnits();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error setting units", (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jRadioButtonMenuItemDrilledActionPerformed(ActionEvent evt) {
        try {
            this.setUnits();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error setting units", (Exception)ex);
            ex.printStackTrace();
        }
    }

    private boolean checkWsEmpty() {
        try {
            if (this.ws.getUsers().size() > 0) {
                JOptionPane.showMessageDialog(this, "You cannot load from database into a non-empty workspace.\nOpen a new Organiser window.", this.getTitle(), 1);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemLoadWorkspaceActionPerformed(ActionEvent evt) {
        if (!this.checkWsEmpty()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Iterator it = this.ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                WsWell wsWell = (WsWell)it.next();
                if (wsWell.getLink() == null) continue;
                System.out.print("Filling well: " + wsWell + "...");
                wsWell.fillData(this.dataTypes);
                System.out.println("Filled well: " + wsWell);
                for (Component comp : this.jTabbedPane1.getComponents()) {
                    JPanelOrganiser panel = (JPanelOrganiser)comp;
                    if (panel.hdr != null) {
                        if (panel.hdr.getLink() == null) {
                            System.out.println("Auto-assigning default version to default version in workspace");
                            panel.hdr.setLink(this.db.getInterp(0));
                        }
                        System.out.println("Filling interp: " + panel.hdr.getDescription() + " for well: " + wsWell);
                        wsWell.fillData(this.dataTypes, panel.hdr);
                        System.out.println("Filled interp: " + panel.hdr.getDescription() + " for well: " + wsWell);
                    }
                    panel.refreshView(false);
                }
            }
        }
        catch (SQLException sql) {
            this.inWizard = false;
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.inWizard = false;
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            this.inWizard = false;
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jMenuItemMatchInterpActionPerformed(ActionEvent evt) {
        try {
            DialogMatchInterp dialog = new DialogMatchInterp(this, true, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                this.inWizard = false;
            }
            int tabIndex = 0;
            for (Component comp : this.jTabbedPane1.getComponents()) {
                JPanelOrganiser panel = (JPanelOrganiser)comp;
                panel.setName();
                this.jTabbedPane1.setTitleAt(tabIndex++, panel.getName());
            }
            this.refreshView();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jMenuItemMatchEventsActionPerformed(ActionEvent evt) {
        try {
            if (!this.inWizard && !this.ws.hasEvents()) {
                JOptionPane.showMessageDialog(this, "There are no events in the workspace", "Match Events", 1);
                return;
            }
            for (SBEvent e : this.ws.getSBEvents(false)) {
                if (e.getTaxon() == null || e.getTaxon().getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "You must match taxa first", this.getTitle(), 2);
                return;
            }
            DialogMatchEvents dialog = new DialogMatchEvents((Frame)this, true, this.ws, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                this.inWizard = false;
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jMenuItemRemoveVersionActionPerformed(ActionEvent evt) {
        JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
        if (panel.hdr == null) {
            JOptionPane.showMessageDialog(this, "You cannot remove non-version data tab", this.getTitle(), 2);
            return;
        }
        if (this.jTabbedPane1.getComponents().length <= 2) {
            JOptionPane.showMessageDialog(this, "You cannot remove the only version tab", this.getTitle(), 2);
            return;
        }
        try {
            this.ws.removeInterp(panel.hdr);
            this.jTabbedPane1.remove(panel);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jButtonDataTypesActionPerformed(ActionEvent evt) {
        this.jMenuItemDataTypesActionPerformed(evt);
    }

    private void jButtonSaveToDatabaseActionPerformed(ActionEvent evt) {
        this.saveInDatabase(false);
    }

    private void jMenuItemOpenZipActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupZIPFileChooser();
        if (0 == this.jFileChooserZIP.showOpenDialog(this)) {
            this.openZipArchive(this.jFileChooserZIP.getSelectedFile());
        }
    }

    private void jMenuItemOrganiserHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("organiser.html");
    }

    private void jMenuItemHelpMenuActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("organiser_menu.html");
    }

    private void jMenuItemHelpMatchActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("matchdialogs.html");
    }

    private void jMenuItemOpenBugWareActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupBugWareFileChooser();
        if (0 == this.jFileChooserBugWare.showOpenDialog(this)) {
            File file = this.jFileChooserBugWare.getSelectedFile();
            this.openBugWarefile(file);
        }
    }

    private void jMenuItemOpenChecklistActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupChecklistFileChooser();
        if (0 == this.jFileChooserChecklist.showOpenDialog(this)) {
            this.openChecklistfile(this.jFileChooserChecklist.getSelectedFile());
        }
    }

    private void jMenuItemOpenRGActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupRGFileChooser();
        if (0 == this.jFileChooserRG.showOpenDialog(this)) {
            File file = this.jFileChooserRG.getSelectedFile();
            this.openRGFile(file);
        }
    }

    private void jMenuItemOpenSbugsActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupSbugsFileChooser();
        if (0 == this.jFileChooserSbugs.showOpenDialog(this)) {
            this.openSbugsFile(this.jFileChooserSbugs.getSelectedFile());
        }
    }

    private void jMenuItemReplaceAllActionPerformed(ActionEvent evt) {
        this.saveInDatabase(true);
    }

    private void jMenuMatchActionPerformed(ActionEvent evt) {
        this.jMenuItemMatchAnalysts.setForeground(Color.YELLOW);
    }

    private void jMenuItemOpenTSCreatorActionPerformed(ActionEvent evt) {
        if (!this.checkClear(false)) {
            return;
        }
        JFileChooser jFileChooserTSC = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("jar");
        filter.addExtension("txt");
        filter.setDescription("TSCreator data files");
        jFileChooserTSC.setFileFilter((FileFilter)filter);
        jFileChooserTSC.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"WINTSCFIL", (String)"UNXTSCFIL"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooserTSC.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (0 == jFileChooserTSC.showOpenDialog(this)) {
            try {
                Lastval.putString((SBdb)this.db, (String)"WINTSCFIL", (String)"UNXTSCFIL", (String)jFileChooserTSC.getSelectedFile().getPath());
                this.db.commit();
                TSCreatorReader reader = new TSCreatorReader(this.ws, jFileChooserTSC.getSelectedFile().getPath());
                if (reader.getLists().isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Unable to read any schemes from file", this.getTitle(), 1);
                    return;
                }
                DialogTSCreator dialog = new DialogTSCreator(this, true, this.db, this.ws, reader);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    TSCreatorReader.TSCScheme scheme = dialog.getScheme();
                    if (dialog.getEventList() != null) {
                        int opt;
                        TSCreatorReader.TSCEventList events = dialog.getEventList();
                        if (events.needsFilter() && (opt = JOptionPane.showConfirmDialog(this, "Do you want to filter the * * and [ ] contents from the TSC events?", this.getTitle(), 0, 3)) == 0) {
                            events.filterNames();
                        }
                        events.removeBlankEvents();
                        events.getEvents(this.ws);
                        DialogMatchEvents dialogMatchEvents = new DialogMatchEvents((Frame)this, true, this.ws, this.db);
                        dialogMatchEvents.setLocationRelativeTo(this);
                        dialogMatchEvents.setVisible(true);
                        if (dialogMatchEvents.isOK()) {
                            LinkedList exceptions = new LinkedList();
                            CompositeStandard std = events.getCompositeStandard(exceptions);
                            if (exceptions.size() > 0) {
                                DialogList dialogl = new DialogList(this, true, "Events not added to composite", this.db, exceptions, false, false);
                                dialogl.setLocationRelativeTo(this);
                                dialogl.setVisible(true);
                            }
                            DialogMatchCmpStd matchdialog = new DialogMatchCmpStd((Frame)this, true, std, this.db);
                            matchdialog.setLocationRelativeTo(this);
                            matchdialog.setVisible(true);
                        }
                    }
                    if (dialog.useScheme()) {
                        IGDScheme igdScheme = scheme.getScheme(this.ws);
                        if (igdScheme.getIGDType() > 0) {
                            this.ws.addIGDScheme(igdScheme);
                            DialogMatchIGDScheme dialogMatchScheme = new DialogMatchIGDScheme((Frame)this, true, igdScheme, this.db);
                            dialogMatchScheme.setLocationRelativeTo(this);
                            dialogMatchScheme.setVisible(true);
                        } else {
                            JOptionPane.showMessageDialog(this, "Cannot determine scheme type - scheme not stored.", this.getTitle(), 1);
                        }
                    }
                }
            }
            catch (SBException ex) {
                JOptionPane.showMessageDialog(this, ex.toString(), this.getTitle(), 0);
                ex.printStackTrace();
            }
            catch (Exception ex) {
                SB.showStackError((String)("Error reading file: " + ex.toString()), (Exception)ex);
            }
        }
    }

    private void jMenuItemOpenIGDXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 1);
        }
    }

    private void jMenuItemOpenOWXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 2);
        }
    }

    private void jMenuItemODMActionPerformed(ActionEvent evt) {
        try {
            if (this.ws.getProject(0).getSize() == 0) {
                int opt = JOptionPane.showConfirmDialog(this, "Do you want to pre-select StrataBugs wells to enable sample matching?", "ODM Import", 1, 3);
                if (opt == 2 || opt == -1) {
                    return;
                }
                if (opt == 0) {
                    this.jMenuItemOpenWellsActionPerformed(null);
                }
            }
            DialogODM dialog = new DialogODM(this, true, this.ws, this.db, this.dataTypes);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.refreshView();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jMenuItemOpenSampleXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 3);
        }
    }

    private void jMenuItemOpenSISSbugsActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.jFileChooserSISSbugs = this.setupFileChooser(this.jFileChooserSISSbugs, "WINSISSB", "UNXSISSB", null, new String[]{null});
        if (0 == this.jFileChooserSISSbugs.showOpenDialog(this)) {
            this.openSISSbugsFile(this.jFileChooserSISSbugs.getSelectedFile());
        }
    }

    private void jMenuItemOpenSampleOccXLSActionPerformed(ActionEvent evt) {
        if (!this.checkClear(true)) {
            return;
        }
        this.setupXLSFileChooser();
        if (0 == this.jFileChooserXLS.showOpenDialog(this)) {
            this.openXLSFile(this.jFileChooserXLS.getSelectedFile(), 4);
        }
    }

    void setUnits() throws SQLException, SBException {
        char newUnits = this.jRadioButtonMenuItemMetres.isSelected() ? (char)'M' : (this.jRadioButtonMenuItemFeet.isSelected() ? (char)'F' : 'D');
        if (newUnits != this.units) {
            for (Component comp : this.jTabbedPane1.getComponents()) {
                JPanelOrganiser panel = (JPanelOrganiser)comp;
                panel.setUnits(newUnits);
            }
            this.units = newUnits;
            this.refreshView();
        }
    }

    boolean checkClear(boolean queryMoreSources) {
        try {
            if (this.isSavingData) {
                JOptionPane.showMessageDialog(this, "Please wait until data saving operation has completed", this.getTitle(), 2);
                return false;
            }
            if (this.ws.getProject(0).getSize() > 0) {
                int option2;
                int option = JOptionPane.showConfirmDialog(this, "Clear data from workspace?", this.getTitle(), 1, 3);
                if (option == 2 || option == -1 || option == 1 && !queryMoreSources) {
                    return false;
                }
                if (queryMoreSources && option == 1 && (option2 = JOptionPane.showConfirmDialog(this, "You must ONLY add data from the same data source, or the results will be unpredictable.\nAre you sure you want to continue?", this.getTitle(), 0, 3)) != 0) {
                    return false;
                }
                if (option == 0) {
                    Iterator it = this.ws.getProject(0).getWellIterator();
                    while (it.hasNext()) {
                        WsWell well = (WsWell)it.next();
                        if (well.getLink() == null) continue;
                        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
                            JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getComponentAt(i);
                            well.getLink().deleteObserver((Observer)panel);
                            if (panel.hdr == null) continue;
                            well.getAddInterp(panel.hdr).deleteObserver((Observer)panel);
                        }
                    }
                    this.setWorkspace(new SBdb(this.db));
                    this.refreshView();
                }
            } else {
                this.setWorkspace(new SBdb(this.db));
            }
            this.project = null;
            return true;
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
            return false;
        }
    }

    boolean hasFssDataTypes() {
        for (int columnType : this.dataTypes) {
            switch (columnType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasEventDataTypes() {
        for (int columnType : this.dataTypes) {
            switch (columnType) {
                case 16: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasIGDZoneDataTypes() {
        for (int columnType : this.dataTypes) {
            switch (columnType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasSQPickDataTypes() {
        for (int columnType : this.dataTypes) {
            switch (columnType) {
                case 14: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasEnvDataType() {
        for (int columnType : this.dataTypes) {
            switch (columnType) {
                case 15: {
                    return true;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasCommentDataTypes() {
        for (int columnType : this.dataTypes) {
            switch (columnType) {
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasIGDDataTypes() {
        try {
            for (int columnType : this.dataTypes) {
                if (!SBdb.isInterpDataType((int)columnType)) continue;
                return true;
            }
        }
        catch (SBException e) {
            System.out.println("Exception from hasIGDdataTypes: " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    void export() {
        if (!this.parent.checkRLMlicence()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jMenuItemExitActionPerformed(null);
            return;
        }
        if (!this.checkClear(false)) {
            return;
        }
        if (!this.allowExport()) {
            return;
        }
        this.inWizard = true;
        boolean selectByProject = false;
        try {
            if (this.db.getProjects().size() > 1) {
                DialogWellProjectSelection dialog = new DialogWellProjectSelection((Frame)this, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    this.inWizard = false;
                    return;
                }
                selectByProject = dialog.selectByProject;
            }
        }
        catch (Exception se) {
            SB.showStackError((String)se.toString(), (Exception)se);
            this.inWizard = false;
            return;
        }
        if (selectByProject) {
            this.jButtonOpenProjectActionPerformed(null);
        } else {
            this.jButtonOpenWellsActionPerformed(null);
        }
        if (!this.inWizard) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jMenuItemDataTypesActionPerformed(null);
        if (!this.inWizard) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.hasIGDDataTypes()) {
            boolean found = false;
            block7: for (Component comp : this.jTabbedPane1.getComponents()) {
                JPanelOrganiser panel = (JPanelOrganiser)comp;
                for (WsWell well : panel.model.wsWells) {
                    Iterator it;
                    if (well.getLink() != null) {
                        try {
                            well.getLink().loadInterps();
                        }
                        catch (SQLException sql) {
                            SB.showStackError((String)"SQL Error loading interps:", (SQLException)sql);
                        }
                        catch (SBException sbe) {
                            SB.showStackError((String)"Error loading interps:", (Exception)((Object)sbe));
                        }
                    }
                    if (!(it = well.getLink().getInterpIterator()).hasNext()) continue;
                    it.next();
                    if (!it.hasNext()) continue;
                    found = true;
                    break block7;
                }
            }
            if (found) {
                try {
                    DialogSelectVersion dialog = new DialogSelectVersion(this, true, this.db, false, this.ws.getProject(0));
                    dialog.setLocationRelativeTo(this);
                    dialog.setTitle("Select Version(s) to Export");
                    dialog.setVisible(true);
                    if (dialog.selection != null) {
                        this.jTabbedPane1.removeAll();
                        for (InterpHdr hdr : dialog.selection) {
                            hdr = this.ws.addInterp(hdr);
                            JPanelOrganiser panel = new JPanelOrganiser(this, this.ws, this.db, hdr, this.dataTypes);
                            this.jTabbedPane1.add(panel);
                            panel.refreshView(true);
                        }
                    } else {
                        this.inWizard = false;
                    }
                }
                catch (Exception e) {
                    this.inWizard = false;
                    SB.showStackError((String)"Error showing version selector: ", (Exception)e);
                }
                if (!this.inWizard) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
        }
        this.jMenuItemLoadWorkspaceActionPerformed(null);
        if (!this.inWizard) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.jButtonSaveToFileActionPerformed(null);
        this.setCursor(Cursor.getDefaultCursor());
        this.inWizard = false;
    }

    private void setWorkspace(SBdb ws) {
        this.ws = ws;
        this.jTabbedPane1.removeAll();
        try {
            JPanelOrganiser panel = new JPanelOrganiser(this, ws, this.db, null, this.dataTypes);
            this.jTabbedPane1.add(panel);
            InterpHdr wsHdr = ws.getInterp(0);
            panel = new JPanelOrganiser(this, ws, this.db, wsHdr, this.dataTypes);
            this.jTabbedPane1.add(panel);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error setting new workspace: ", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openZipArchive(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            try {
                int nBytes;
                String rootName = file.getName();
                rootName = rootName.substring(0, rootName.lastIndexOf(46));
                System.out.println("File root name: " + rootName);
                String entryName = rootName + ".xml";
                ZipEntry entry = null;
                ZipEntry anXMLentry = null;
                Enumeration<? extends ZipEntry> en = zipFile.entries();
                while (en.hasMoreElements()) {
                    ZipEntry e = en.nextElement();
                    if (e.getName().equalsIgnoreCase(entryName)) {
                        entry = e;
                        break;
                    }
                    if (!e.getName().endsWith(".xml")) continue;
                    if (anXMLentry == null) {
                        anXMLentry = e;
                        continue;
                    }
                    anXMLentry = null;
                    break;
                }
                if (entry == null && anXMLentry != null) {
                    entry = anXMLentry;
                }
                if (entry == null) {
                    String msg = "Zip/sbg file does not contain an XML file of the same name, or contains multiple files.\n\nExpected: " + entryName + "\nContents: ";
                    Enumeration<? extends ZipEntry> z = zipFile.entries();
                    while (z.hasMoreElements()) {
                        msg = msg + z.nextElement().getName() + "\n";
                    }
                    JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                    return;
                }
                File tempXML = File.createTempFile("SBUGS" + rootName, ".xml");
                FileOutputStream fos = new FileOutputStream(tempXML);
                InputStream fis = zipFile.getInputStream(entry);
                byte[] bytes = new byte[Short.MAX_VALUE];
                while ((nBytes = fis.read(bytes, 0, bytes.length)) > 0) {
                    fos.write(bytes, 0, nBytes);
                }
                fis.close();
                fos.close();
                System.out.println("Opening file: " + tempXML);
                this.openXMLfile(tempXML, zipFile);
            }
            catch (Exception ex) {
                SB.showStackError((String)ex.getMessage(), (Exception)ex);
            }
            finally {
                zipFile.close();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void exportXML(File file, List<File> files) throws SBException, SQLException, UnsupportedEncodingException, IOException, JDOMException, SAXException {
        if (!file.getName().toLowerCase().endsWith("xml")) {
            file = new File(file.getPath() + ".xml");
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        this.ws.writeXML(out, this.dataTypes, this.db, files);
        out.close();
        Lastval.putString((SBdb)this.db, (String)"JXMLFILE", (String)file.getPath());
        this.db.commit();
        Document xmlDocument = SbugsMLdocument.getXmlDocument(file);
    }

    private void exportDEX(File file) {
        String msg = "";
        if (this.dataTypes.contains(14)) {
            msg = msg + "Sequence picks";
        }
        if (this.dataTypes.contains(16)) {
            if (!msg.isEmpty()) {
                msg = msg + " and ";
            }
            msg = msg + "Events";
        }
        if (!msg.isEmpty()) {
            msg = msg + " cannot be exported to DEX and will be ignored.";
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
        }
        try {
            if (!file.getName().toLowerCase().endsWith("dex")) {
                file = new File(file.getPath() + ".dex");
            }
            FileWriter out = new FileWriter(file);
            JPanelOrganiser panel = (JPanelOrganiser)this.jTabbedPane1.getSelectedComponent();
            new DEXFile(out, this.ws, this.db, this.dataTypes, this.units, panel.getInterpID(), false, 0);
            out.flush();
            out.close();
            Lastval.putString((SBdb)this.db, (String)"WINDEXFILE", (String)"UNXDEXFILE", (String)file.getPath());
            JOptionPane.showMessageDialog(this, "File : '" + file.getPath() + "' written", "Write DEX", 1);
            this.db.commit();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "SB Error : " + ex.getMessage(), "SB Error", 0);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "SQL Error : " + ex.getMessage(), "SQL Error", 0);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private boolean checkCSVexport() {
        for (int dType : this.dataTypes) {
            switch (dType) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    String suppMsg = "\n(Use Save As... from the Analyses tab in Samples & Interpretations for CSV file options)";
                    String msg = "Sorry, data type " + SBdb.dTypeNames[dType] + " is not currently supported";
                    JOptionPane.showMessageDialog(this, msg + suppMsg, "Data type not supported", 2);
                    return false;
                }
            }
        }
        return true;
    }
}

