/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.FrameJsbugs;
import jsbugs.FrameSamples;
import jsbugs.OverlayJPanel;
import model2.Overlay;
import model2.SBdb;
import model2.Smpdtl;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class FrameOverlay
extends JFrame {
    OverlayJPanel jPanelOverlay;
    List<Image> imageList = new LinkedList<Image>();

    public FrameOverlay(GraphicsConfiguration gc, Frame parent, SBdb db, Well well, Smpdtl smpdtl, Overlay overlay, boolean showCMF, FrameSamples frameSamples) {
        super(gc);
        this.initComponents();
        this.init(db, well, smpdtl, overlay, showCMF, frameSamples);
    }

    public FrameOverlay(GraphicsConfiguration gc, Frame parent, SBdb db, Overlay overlay, boolean showCMF, FrameSamples frameSamples) {
        this.initComponents();
        this.init(db, null, null, overlay, showCMF, frameSamples);
    }

    public void setSmpdtl(Well well, Smpdtl smpdtl) {
        this.jPanelOverlay.setSmpdtl(well, smpdtl);
        this.setTitle(well, smpdtl);
    }

    private void setTitle(Well well, Smpdtl smpdtl) {
        if (well != null) {
            String title = "Overlay : ";
            if (this.jPanelOverlay.getOverlay() != null) {
                title = title + this.jPanelOverlay.getOverlay().getName();
            }
            title = title + " : " + well.getWellName();
            if (smpdtl != null) {
                try {
                    title = title + " : " + smpdtl.getSample().toString() + " : " + smpdtl.getAnalyst().toString() + (smpdtl.getHeader().getAnalyNumber() > 1 ? "/" + smpdtl.getHeader().getAnalyNumber() : "");
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                catch (SBException ex) {
                    ex.printStackTrace();
                }
            }
            this.setTitle(title);
        } else if (this.jPanelOverlay.getOverlay() != null) {
            this.setTitle("StrataBugs Overlay Designer: " + this.jPanelOverlay.getOverlay().getName());
        } else {
            this.setTitle("StrataBugs Overlay Designer");
        }
    }

    private void createImageList() {
        String[] pngs = new String[]{"32Overlay.png", "24Overlay.png", "16Overlay.png"};
        Image img = null;
        for (int i = 0; i < pngs.length; ++i) {
            img = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/FrameIcon_Overlay/" + pngs[i]));
            this.imageList.add(img);
        }
    }

    private void init(SBdb db, Well well, Smpdtl smpdtl, Overlay overlay, boolean showCMF, FrameSamples frameSamples) {
        this.jPanelOverlay = new OverlayJPanel(db, overlay, well, smpdtl, showCMF, frameSamples);
        this.setAlwaysOnTop(true);
        GroupLayout jPanelOverlayLayout = new GroupLayout((Container)this.jPanelOverlay);
        this.jPanelOverlay.setLayout((LayoutManager)jPanelOverlayLayout);
        jPanelOverlayLayout.setHorizontalGroup((GroupLayout.Group)jPanelOverlayLayout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        jPanelOverlayLayout.setVerticalGroup((GroupLayout.Group)jPanelOverlayLayout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelOverlay, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelOverlay, -1, -1, Short.MAX_VALUE));
        this.setTitle(well, smpdtl);
        this.createImageList();
        this.setIconImages(this.imageList);
        this.jPanelOverlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (!FrameOverlay.this.jPanelOverlay.MouseClicked(evt)) {
                    FrameOverlay.this.dispose();
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                FrameOverlay.this.jPanelOverlay.MousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                FrameOverlay.this.jPanelOverlay.MouseReleased(evt);
            }
        });
        this.jPanelOverlay.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                FrameOverlay.this.jPanelOverlay.MouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                FrameOverlay.this.jPanelOverlay.MouseDragged(evt);
            }
        });
        this.jPanelOverlay.setFocusable(true);
        this.jPanelOverlay.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FrameOverlay.this.jPanelOverlay.keyPressed(evt);
            }
        });
    }

    Overlay getOverlay() {
        if (this.jPanelOverlay == null) {
            return null;
        }
        return this.jPanelOverlay.getOverlay();
    }

    UndoableEditSupport getUndoSupport() {
        if (this.jPanelOverlay == null) {
            return null;
        }
        return this.jPanelOverlay.getUndoSupport();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                FrameOverlay.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                FrameOverlay.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FrameOverlay.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 852, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 636, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.jPanelOverlay.close();
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            if (this.jPanelOverlay.getOverlay().mapChanged()) {
                if (JOptionPane.showConfirmDialog(this, "Save changes to overlay?", this.getTitle(), 0, 3) == 0) {
                    this.jPanelOverlay.getOverlay().storeMap();
                    this.jPanelOverlay.db.commit();
                } else {
                    this.jPanelOverlay.getOverlay().reload();
                }
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.jPanelOverlay != null) {
            this.jPanelOverlay.taxonTextSize = 0;
            this.jPanelOverlay.repaint();
        }
    }
}

