/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.Chart;
import jsbugs.ChartJPanel;
import jsbugs.ChartPanel;
import jsbugs.DialogAbnSchemes;
import jsbugs.DialogList;
import jsbugs.DialogLithPalette;
import jsbugs.DialogOverlay;
import jsbugs.DialogPanelEvents;
import jsbugs.DialogPanelIGDScheme;
import jsbugs.DialogPanelSurfaces;
import jsbugs.DialogParseSample;
import jsbugs.DialogPrintPreview;
import jsbugs.DialogPrintPreviewChart;
import jsbugs.DialogSchemeBlock;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectScheme;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogSelectWell;
import jsbugs.DialogTableOptions;
import jsbugs.DialogTaxonCodeInput;
import jsbugs.DialogTaxonWellOccFiltered;
import jsbugs.DialogWellDisc;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOverlay;
import jsbugs.FrameWellChartsDetached;
import jsbugs.FrameWellDetached;
import jsbugs.ImageGallery;
import jsbugs.JPanelCharts;
import jsbugs.JPanelPicklist;
import jsbugs.JPanelWell;
import jsbugs.LoggingSheet;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelEventsBase;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelSurfaces;
import jsbugs.PrintJPanel;
import jsbugs.SBDialog;
import jsbugs.SchemeBlock;
import jsbugs.TableModelOccurence;
import jsbugs.TableModelSB;
import jsbugs.TablePair;
import model2.AbnScheme;
import model2.AgeCurve;
import model2.Biocom;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.InterpHdr;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.Smpdtl;
import model2.Surface;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class FrameSamples
extends JFrame
implements Observer {
    SBdb sbdb;
    FrameJsbugs parent;
    private ChartJPanel schemeChartJPanel = new ChartJPanel(null);
    float schemeZoom = 1.0f;
    float chartZoom = 1.0f;
    private List<JPanelPicklist> picklists = new LinkedList<JPanelPicklist>();
    static final int PICKLIST_LIMIT = 10;
    List<FrameWellDetached> wellFrames = new LinkedList<FrameWellDetached>();
    HashSet<FrameWellChartsDetached> chartsFrames = new HashSet();
    List<Image> imageList = new LinkedList<Image>();
    DialogTaxonCodeInput dialogTaxonCodeInput = null;
    private int picklistTotaliser = 0;
    Point popupPoint = null;
    private static PageFormat printFormat = null;
    private Clip soundClip;
    private AudioInputStream audioStream = null;
    private ButtonGroup buttonGroupBiocommTaxaOptions;
    private ButtonGroup buttonGroupMode;
    private ButtonGroup buttonGroupMultiClick;
    private ButtonGroup buttonGroupPickMode;
    private ButtonGroup buttonGroupPicklist;
    private ButtonGroup buttonGroupWellTabTitles;
    private JButton jButtonSchemePanelProperites;
    private JButton jButtonSchemeZoomIn;
    private JButton jButtonSchemeZoomOut;
    private JButton jButtonSelectSchemePanel;
    private JCheckBoxMenuItem jCheckBoxMenuItemExcludeRwCvTotals;
    private JCheckBoxMenuItem jCheckBoxMenuItemGrainSize;
    private JCheckBoxMenuItem jCheckBoxMenuItemOccSound;
    private JCheckBoxMenuItem jCheckBoxMenuItemPickAuthor;
    private JCheckBoxMenuItem jCheckBoxMenuItemPickCat;
    private JCheckBoxMenuItem jCheckBoxMenuItemPickCode;
    private JCheckBoxMenuItem jCheckBoxMenuItemTotaliser;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemAbnSchemes;
    private JMenuItem jMenuItemAnalysesWeight;
    private JMenuItem jMenuItemAnlysesMerge;
    private JMenuItem jMenuItemClear;
    private JMenuItem jMenuItemClearSelection;
    private JMenuItem jMenuItemCreateVoiceRecognitionFile;
    private JMenuItem jMenuItemDetachChart;
    private JMenuItem jMenuItemDetachWell;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemExportChartHelp;
    private JMenuItem jMenuItemExportHTML;
    private JMenuItem jMenuItemExportRastor;
    private JMenuItem jMenuItemExportVector;
    private JMenuItem jMenuItemHelpAnalyses;
    private JMenuItem jMenuItemHelpHome;
    private JMenuItem jMenuItemHelpInterp;
    private JMenuItem jMenuItemHelpMenu;
    private JMenuItem jMenuItemHelpOccurrences;
    private JMenuItem jMenuItemHelpOverlays;
    private JMenuItem jMenuItemHelpPicklist;
    private JMenuItem jMenuItemHelpSamples;
    private JMenuItem jMenuItemHelpSchemes;
    private JMenuItem jMenuItemHelpchart;
    private JMenuItem jMenuItemInsertGroup;
    private JMenuItem jMenuItemInsertTaxa;
    private JMenuItem jMenuItemInsertWellOutcrop;
    private JMenuItem jMenuItemMultiplier;
    private JMenuItem jMenuItemNewOverlay;
    private JMenuItem jMenuItemNumericCode;
    private JMenuItem jMenuItemOpenOverlay;
    private JMenuItem jMenuItemOpenProject;
    private JMenuItem jMenuItemOverlayEdit;
    private JMenuItem jMenuItemOverlayWeb;
    private JMenuItem jMenuItemPanelProperties;
    private JMenuItem jMenuItemParseSample;
    private JMenuItem jMenuItemPicklistEdit;
    private JMenuItem jMenuItemPicklistNew;
    private JMenuItem jMenuItemPicklistRemove;
    private JMenuItem jMenuItemPrintAnalyses;
    private JMenuItem jMenuItemPrintChart;
    private JMenuItem jMenuItemPrintImgGal;
    private JMenuItem jMenuItemPrintScheme;
    private JMenuItem jMenuItemRemoveWell;
    private JMenuItem jMenuItemSampleAge;
    private JMenuItem jMenuItemSampleCopy;
    private JMenuItem jMenuItemSampleGenerate;
    private JMenuItem jMenuItemSampleMerge;
    private JMenuItem jMenuItemSampleMove;
    private JMenuItem jMenuItemSaveAsGroup;
    private JMenuItem jMenuItemSaveAsProject;
    private JMenuItem jMenuItemSelectWell;
    private JMenuItem jMenuItemTableDefaults;
    private JMenuItem jMenuItemTableOptions;
    private JMenuItem jMenuItemTaxonReassign;
    private JMenuItem jMenuItemViewFilteredOccs;
    private JMenu jMenuMultiClick;
    private JMenu jMenuOccurrences;
    private JMenu jMenuOverlay;
    private JMenu jMenuPicklist;
    private JMenu jMenuPicklistView;
    private JMenu jMenuPrint;
    private JMenu jMenuSample;
    private JMenu jMenuView;
    private JPanel jPanelScheme;
    private JPopupMenu jPopupMenuScheme;
    private JRadioButtonMenuItem jRadioButtonMenuItemBiocomAbrGenus;
    private JRadioButtonMenuItem jRadioButtonMenuItemBiocomFullName;
    private JRadioButtonMenuItem jRadioButtonMenuItemBrowsing;
    private JRadioButtonMenuItem jRadioButtonMenuItemContinuousClick;
    private JRadioButtonMenuItem jRadioButtonMenuItemDoubleClick;
    private JRadioButtonMenuItem jRadioButtonMenuItemLogging;
    private JRadioButtonMenuItem jRadioButtonMenuItemPickHoriz;
    private JRadioButtonMenuItem jRadioButtonMenuItemPickVert;
    private JRadioButtonMenuItem jRadioButtonMenuItemQuant;
    private JRadioButtonMenuItem jRadioButtonMenuItemSemiQuant;
    private JRadioButtonMenuItem jRadioButtonMenuItemWellCodes;
    private JRadioButtonMenuItem jRadioButtonMenuItemWellNames;
    private JScrollPane jScrollPaneSchemeChart;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JToolBar.Separator jSeparator19;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator21;
    private JPopupMenu.Separator jSeparator22;
    private JPopupMenu.Separator jSeparator23;
    private JPopupMenu.Separator jSeparator24;
    private JPopupMenu.Separator jSeparator25;
    private JPopupMenu.Separator jSeparator26;
    private JPopupMenu.Separator jSeparator27;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPaneSchemes;
    private JTabbedPane jTabbedPaneWell;
    private JToolBar jToolBar1;
    private DialogLithPalette lithPalette;

    public FrameSamples(FrameJsbugs parent, SBdb sbdb, Well well, boolean restore) throws SQLException, SBException {
        this.parent = parent;
        this.sbdb = sbdb;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.initComponents();
        this.init(well, restore);
        SB.centreWindow((Frame)this);
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs.getClass() == Well.class) {
            for (Component c : this.jTabbedPaneWell.getComponents()) {
                JPanelWell wellPanel = (JPanelWell)c;
                if (wellPanel.getWell() != obs) continue;
                wellPanel.update(obs, arg);
                break;
            }
        }
    }

    @Override
    public FrameJsbugs getParent() {
        return this.parent;
    }

    JPanelPicklist getSelectedPicklist() {
        Component component = this.jTabbedPaneSchemes.getSelectedComponent();
        if (component instanceof JPanelPicklist) {
            return (JPanelPicklist)component;
        }
        return null;
    }

    JPanelPicklist getSelectedPicklist(JPanelPicklist list) {
        if (list != null) {
            return list;
        }
        if (this.getSelectedPicklist() != null) {
            return this.getSelectedPicklist();
        }
        if (this.picklists.size() == 1) {
            return this.picklists.get(0);
        }
        return null;
    }

    List<JPanelPicklist> getPicklists() {
        return this.picklists;
    }

    private void createImageList() {
        String[] pngs = new String[]{"48Samples.png", "32Samples.png", "24Samples.png", "16Samples.png"};
        Image img = null;
        for (int i = 0; i < pngs.length; ++i) {
            img = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/FrameIcon_Samples/" + pngs[i]));
            this.imageList.add(img);
        }
    }

    void attachTab(FrameWellDetached frame) {
        JPanelWell panel = frame.getPanel();
        this.wellFrames.remove(frame);
        this.insertTab(panel);
    }

    void insertTab(JPanelWell wellPanel) {
        int index = 0;
        for (int i = 0; i < this.jTabbedPaneWell.getComponentCount(); ++i) {
            JPanelWell comp = (JPanelWell)this.jTabbedPaneWell.getComponentAt(i);
            if (wellPanel.getWell().getWellName().compareTo(comp.getWell().getWellName()) < 0 || wellPanel.getWell().getWellName().compareTo(comp.getWell().getWellName()) == 0 && wellPanel.getWell().getWellCode().compareTo(comp.getWell().getWellCode()) < 0) break;
            ++index;
        }
        this.jTabbedPaneWell.insertTab(wellPanel.getTabTitle(), null, wellPanel, "<html>" + wellPanel.getWell().getWellName() + "<br>(" + wellPanel.getWell().getWellCode() + ")</html>", index);
        this.jTabbedPaneWell.setSelectedComponent(wellPanel);
        wellPanel.tableModelOcc.setLogging(this.jRadioButtonMenuItemLogging.isSelected(), wellPanel.getOccTable());
    }

    void setSelectedWellTab(JPanelWell wellPanel) {
        this.jTabbedPaneWell.setSelectedComponent(wellPanel);
    }

    JPanelWell addWellTab(Well well) throws SQLException, SBException {
        boolean found = false;
        JPanelWell wellPanel = null;
        for (Component c : this.jTabbedPaneWell.getComponents()) {
            if (((JPanelWell)c).getWell().getWellID() != well.getWellID()) continue;
            wellPanel = (JPanelWell)c;
            found = true;
            break;
        }
        if (!found) {
            for (FrameWellDetached frame : this.wellFrames) {
                if (frame.getPanel().getWell().getWellID() != well.getWellID()) continue;
                wellPanel = frame.getPanel();
                found = true;
                break;
            }
        }
        if (!found) {
            wellPanel = new JPanelWell(this, this.sbdb, well);
            this.insertTab(wellPanel);
        }
        return wellPanel;
    }

    void setWellTabTitle(Well well) {
        boolean set = false;
        for (int i = 0; i < this.jTabbedPaneWell.getComponents().length; ++i) {
            JPanelWell wellPanel = (JPanelWell)this.jTabbedPaneWell.getComponentAt(i);
            if (wellPanel.well.getWellID() != well.getWellID()) continue;
            this.jTabbedPaneWell.setTitleAt(i, JPanelWell.tabIsName ? wellPanel.well.getWellName() : wellPanel.getWell().getWellCode());
            set = true;
            break;
        }
        if (!set) {
            for (FrameWellDetached wellFrame : this.wellFrames) {
                if (wellFrame.getPanel().well.getWellID() != well.getWellID()) continue;
                wellFrame.setTitle();
                break;
            }
        }
        for (FrameWellChartsDetached chartFrame : this.chartsFrames) {
            if (chartFrame.getPanel().well.getWellID() != well.getWellID()) continue;
            chartFrame.setTitle();
            break;
        }
    }

    AbnScheme getAbnScheme() throws SBException, SQLException {
        Smpdtl smpdtl;
        if (this.getWellPanel() != null) {
            smpdtl = this.getTableModelOcc().smpdtl;
            if (smpdtl == null) {
                smpdtl = this.getWellPanel().getSmpdtl();
            }
        } else {
            return null;
        }
        AbnScheme abnScheme = smpdtl != null ? this.sbdb.getAbnScheme(this.getWellPanel().getWell(), smpdtl.getAnalyID(), true) : this.sbdb.getDefaultAbnScheme();
        return abnScheme;
    }

    CompositeStandard getCompositeStandard() {
        if (this.schemeChartJPanel.chart != null && this.schemeChartJPanel.chart.getSchemeBlock() != null) {
            return this.schemeChartJPanel.chart.getSchemeBlock().getCompositeStandard();
        }
        return null;
    }

    IGDScheme getIGDScheme() {
        if (this.schemeChartJPanel.chart != null && this.schemeChartJPanel.chart.getSchemeBlock() != null) {
            return this.schemeChartJPanel.chart.getSchemeBlock().getScheme();
        }
        return null;
    }

    boolean isNumeric() {
        return this.jRadioButtonMenuItemQuant.isSelected();
    }

    boolean getLogging() {
        return this.jRadioButtonMenuItemLogging.isSelected();
    }

    boolean isCMF() {
        return this.jCheckBoxMenuItemGrainSize.isSelected();
    }

    boolean isMultiClick() {
        return this.jRadioButtonMenuItemContinuousClick.isSelected();
    }

    int getPicklistTotaliser() {
        return this.picklistTotaliser;
    }

    TableModelOccurence getTableModelOcc() {
        if (this.getWellPanel() != null) {
            return this.getWellPanel().tableModelOcc;
        }
        return null;
    }

    boolean occurrencesTabSelected() {
        return this.getWellPanel().occurrencesTabSelected();
    }

    private void init(Well well, boolean restore) throws SQLException, SBException {
        int totExRwCv;
        this.setTitle("Samples & Interpretations - StrataBugs");
        this.createImageList();
        this.setIconImages(this.imageList);
        this.sbdb.commit();
        if (well != null) {
            JPanelWell wellPanel = new JPanelWell(this, this.sbdb, well);
            this.insertTab(wellPanel);
        }
        this.schemeChartJPanel.chart = new Chart();
        this.schemeChartJPanel.chart.chartProperties.setPanelHeaderHeight(50.0f);
        this.jScrollPaneSchemeChart.getVerticalScrollBar().setUnitIncrement(20);
        this.jScrollPaneSchemeChart.getViewport().add((Component)this.schemeChartJPanel, null);
        this.jScrollPaneSchemeChart.getViewport().setScrollMode(0);
        this.sbdb.addObserver((Observer)this.schemeChartJPanel);
        this.schemeChartJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrameSamples.this.schemeChartPanelMouseClicked(evt);
            }
        });
        this.schemeChartJPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                FrameSamples.this.schemeChartPanelMouseMoved(evt);
            }
        });
        this.schemeChartJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FrameSamples.this.schemeChartPanelMouseReleased(evt);
            }
        });
        boolean isSemiQuant = Lastval.getInt((SBdb)this.sbdb, (String)"SEMIQUANT") > 0;
        this.jRadioButtonMenuItemQuant.setSelected(!isSemiQuant);
        this.jRadioButtonMenuItemSemiQuant.setSelected(isSemiQuant);
        boolean occSound = Lastval.getInt((SBdb)this.sbdb, (String)"OCCSOUND") > 0;
        this.jCheckBoxMenuItemOccSound.setSelected(occSound);
        int total = Lastval.getInt((SBdb)this.sbdb, (String)"PICKTOTAL");
        if (total > 0) {
            this.picklistTotaliser = total;
            this.jCheckBoxMenuItemTotaliser.setText("Count limit set to: " + total);
            this.jCheckBoxMenuItemTotaliser.setSelected(true);
        }
        this.jCheckBoxMenuItemPickAuthor.setSelected(Taxon.includeAuthorInString);
        this.jCheckBoxMenuItemPickCat.setSelected(Taxon.includeCategoryInString);
        this.jCheckBoxMenuItemPickCode.setSelected(Taxon.includeAlphaInString);
        int orientation = Lastval.getInt((SBdb)this.sbdb, (String)"PICKCOL");
        if (orientation > 0) {
            if (orientation == 1) {
                this.jRadioButtonMenuItemPickHoriz.setSelected(true);
            } else {
                this.jRadioButtonMenuItemPickVert.setSelected(true);
            }
        }
        if (!restore || !this.restoreSession()) {
            this.addPicklist(null, 0);
        }
        this.jRadioButtonMenuItemBiocomFullName.setSelected(true);
        int tabTitles = Lastval.getInt((SBdb)this.sbdb, (String)"TABTITLES");
        if (tabTitles > 0) {
            JPanelWell.tabIsName = false;
            this.jRadioButtonMenuItemWellCodes.setSelected(true);
        } else {
            this.jRadioButtonMenuItemWellNames.setSelected(true);
        }
        int multiClick = Lastval.getInt((SBdb)this.sbdb, (String)"MULTICLICK");
        if (multiClick > 0) {
            this.jRadioButtonMenuItemContinuousClick.setSelected(true);
        }
        if ((totExRwCv = Lastval.getInt((SBdb)this.sbdb, (String)"TOTEXRWCV")) > 0) {
            this.jCheckBoxMenuItemExcludeRwCvTotals.setSelected(true);
        }
    }

    public ChartJPanel getSchemeChart() {
        return this.schemeChartJPanel;
    }

    boolean isAbrBiocom() {
        return this.jRadioButtonMenuItemBiocomAbrGenus.isSelected();
    }

    JPanelWell getWellPanel() {
        return (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
    }

    private void schemeChartPanelMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            try {
                Object obj = this.schemeChartJPanel.getObject(evt);
                if (obj == null) {
                    JOptionPane.showMessageDialog(this, "No unit or event found.", this.getTitle(), 1);
                } else if (obj instanceof IGDUnit) {
                    IGDUnit unit = (IGDUnit)obj;
                    WellInterp wellInterp = this.getWellPanel().getInterp();
                    if (wellInterp == null) {
                        JOptionPane.showMessageDialog(this, "No version selected.", this.getTitle(), 1);
                        return;
                    }
                    IGDScheme scheme = this.sbdb.getIGDScheme(unit.getSchID());
                    int igdType = scheme.getIGDType();
                    if (igdType == 10) {
                        JOptionPane.showMessageDialog(this, "Double-click a surface to add sequence picks.", this.getTitle(), 1);
                        return;
                    }
                    this.getWellPanel().addZone(igdType, unit, scheme);
                } else if (obj instanceof CompositeStandardEvent) {
                    CompositeStandardEvent event = (CompositeStandardEvent)obj;
                    WellInterp wellInterp = this.getWellPanel().getInterp();
                    if (wellInterp == null) {
                        JOptionPane.showMessageDialog(this, "No version selected.", this.getTitle(), 1);
                        return;
                    }
                    this.getWellPanel().addEvent(event.getEvent(), event.getType());
                } else if (obj instanceof Surface) {
                    Surface surface = (Surface)obj;
                    WellInterp wellInterp = this.getWellPanel().getInterp();
                    if (wellInterp == null) {
                        JOptionPane.showMessageDialog(this, "No version selected.", this.getTitle(), 1);
                        return;
                    }
                    this.getWellPanel().addSQPick(surface);
                } else {
                    System.out.println("Some other object!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void schemeChartPanelMouseMoved(MouseEvent evt) {
        try {
            this.schemeChartJPanel.setToolTipText(this.schemeChartJPanel.getTooltip(evt));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void schemeChartPanelMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupPoint = evt.getPoint();
            Point2D pTemp = this.schemeChartJPanel.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.schemeChartJPanel.chart.getSelectedPanel(mmPoint);
            this.jPopupMenuScheme.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void initComponents() {
        this.buttonGroupPicklist = new ButtonGroup();
        this.buttonGroupBiocommTaxaOptions = new ButtonGroup();
        this.buttonGroupMode = new ButtonGroup();
        this.buttonGroupPickMode = new ButtonGroup();
        this.buttonGroupWellTabTitles = new ButtonGroup();
        this.jPopupMenuScheme = new JPopupMenu();
        this.jMenuItemPanelProperties = new JMenuItem();
        this.buttonGroupMultiClick = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jTabbedPaneWell = new JTabbedPane();
        this.jTabbedPaneSchemes = new JTabbedPane();
        this.jPanelScheme = new JPanel();
        this.jScrollPaneSchemeChart = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.jButtonSchemeZoomIn = new JButton();
        this.jButtonSchemeZoomOut = new JButton();
        this.jSeparator19 = new JToolBar.Separator();
        this.jButtonSchemePanelProperites = new JButton();
        this.jSeparator20 = new JToolBar.Separator();
        this.jButtonSelectSchemePanel = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemSelectWell = new JMenuItem();
        this.jMenuItemOpenProject = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemDetachWell = new JMenuItem();
        this.jMenuItemDetachChart = new JMenuItem();
        this.jMenuItemRemoveWell = new JMenuItem();
        this.jSeparator27 = new JPopupMenu.Separator();
        this.jMenuItemSaveAsProject = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenuPrint = new JMenu();
        this.jMenuItemPrintChart = new JMenuItem();
        this.jMenuItemPrintScheme = new JMenuItem();
        this.jMenuItemPrintAnalyses = new JMenuItem();
        this.jMenuItemPrintImgGal = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.jMenuItemExportVector = new JMenuItem();
        this.jMenuItemExportRastor = new JMenuItem();
        this.jSeparator26 = new JPopupMenu.Separator();
        this.jMenuItemExportHTML = new JMenuItem();
        this.jSeparator21 = new JPopupMenu.Separator();
        this.jMenuItemExportChartHelp = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.jMenuOverlay = new JMenu();
        this.jMenuItemOpenOverlay = new JMenuItem();
        this.jMenuItemOverlayWeb = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemNewOverlay = new JMenuItem();
        this.jMenuItemOverlayEdit = new JMenuItem();
        this.jMenuItemAbnSchemes = new JMenuItem();
        this.jMenuItemCreateVoiceRecognitionFile = new JMenuItem();
        this.jMenuItemParseSample = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuSample = new JMenu();
        this.jMenu2 = new JMenu();
        this.jMenuItemSampleCopy = new JMenuItem();
        this.jMenuItemSampleMove = new JMenuItem();
        this.jMenuItemAnlysesMerge = new JMenuItem();
        this.jMenuItemAnalysesWeight = new JMenuItem();
        this.jMenuItemTaxonReassign = new JMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.jMenuItemSampleGenerate = new JMenuItem();
        this.jMenuItemSampleAge = new JMenuItem();
        this.jMenuItemSampleMerge = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.jMenu3 = new JMenu();
        this.jRadioButtonMenuItemBiocomAbrGenus = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemBiocomFullName = new JRadioButtonMenuItem();
        this.jMenuOccurrences = new JMenu();
        this.jRadioButtonMenuItemLogging = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemBrowsing = new JRadioButtonMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.jRadioButtonMenuItemQuant = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemSemiQuant = new JRadioButtonMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemGrainSize = new JCheckBoxMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemTotaliser = new JCheckBoxMenuItem();
        this.jMenuItemMultiplier = new JMenuItem();
        this.jCheckBoxMenuItemOccSound = new JCheckBoxMenuItem();
        this.jMenuMultiClick = new JMenu();
        this.jRadioButtonMenuItemDoubleClick = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemContinuousClick = new JRadioButtonMenuItem();
        this.jCheckBoxMenuItemExcludeRwCvTotals = new JCheckBoxMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.jMenuItemNumericCode = new JMenuItem();
        this.jSeparator22 = new JPopupMenu.Separator();
        this.jMenuPicklist = new JMenu();
        this.jMenuPicklistView = new JMenu();
        this.jRadioButtonMenuItemPickHoriz = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemPickVert = new JRadioButtonMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.jCheckBoxMenuItemPickAuthor = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemPickCat = new JCheckBoxMenuItem();
        this.jCheckBoxMenuItemPickCode = new JCheckBoxMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.jMenuItemInsertTaxa = new JMenuItem();
        this.jMenuItemInsertGroup = new JMenuItem();
        this.jMenuItemInsertWellOutcrop = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.jMenuItemPicklistNew = new JMenuItem();
        this.jMenuItemPicklistEdit = new JMenuItem();
        this.jMenuItemPicklistRemove = new JMenuItem();
        this.jSeparator23 = new JPopupMenu.Separator();
        this.jMenuItemSaveAsGroup = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.jMenuItemClearSelection = new JMenuItem();
        this.jMenuItemClear = new JMenuItem();
        this.jMenuView = new JMenu();
        this.jMenuItemTableOptions = new JMenuItem();
        this.jMenuItemTableDefaults = new JMenuItem();
        this.jSeparator24 = new JPopupMenu.Separator();
        this.jMenu5 = new JMenu();
        this.jRadioButtonMenuItemWellNames = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItemWellCodes = new JRadioButtonMenuItem();
        this.jSeparator25 = new JPopupMenu.Separator();
        this.jMenuItemViewFilteredOccs = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemHelpHome = new JMenuItem();
        this.jMenuItemHelpMenu = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItemHelpSamples = new JMenuItem();
        this.jMenuItemHelpAnalyses = new JMenuItem();
        this.jMenuItemHelpOccurrences = new JMenuItem();
        this.jMenuItemHelpInterp = new JMenuItem();
        this.jMenuItemHelpchart = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemHelpSchemes = new JMenuItem();
        this.jMenuItemHelpPicklist = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.jMenuItemHelpOverlays = new JMenuItem();
        this.jMenuItemPanelProperties.setText("Panel properties...");
        this.jMenuItemPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuScheme.add(this.jMenuItemPanelProperties);
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(900, 720));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                FrameSamples.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                FrameSamples.this.formWindowLostFocus(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrameSamples.this.formWindowClosing(evt);
            }
        });
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(15);
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jTabbedPaneWell.setMinimumSize(new Dimension(350, 600));
        this.jTabbedPaneWell.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrameSamples.this.jTabbedPaneWellStateChanged(evt);
            }
        });
        this.jSplitPane1.setLeftComponent(this.jTabbedPaneWell);
        this.jTabbedPaneWell.getAccessibleContext().setAccessibleName("well");
        this.jTabbedPaneSchemes.setMinimumSize(new Dimension(385, 600));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonSchemeZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomIn16.png")));
        this.jButtonSchemeZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jButtonSchemeZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSchemeZoomIn);
        this.jButtonSchemeZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomOut16.png")));
        this.jButtonSchemeZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jButtonSchemeZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSchemeZoomOut);
        this.jToolBar1.add(this.jSeparator19);
        this.jButtonSchemePanelProperites.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ChartProperties16.png")));
        this.jButtonSchemePanelProperites.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jButtonSchemePanelProperitesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSchemePanelProperites);
        this.jToolBar1.add(this.jSeparator20);
        this.jButtonSelectSchemePanel.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_SchemeTab.png")));
        this.jButtonSelectSchemePanel.setToolTipText("Select scheme...");
        this.jButtonSelectSchemePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jButtonSelectSchemePanelActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSelectSchemePanel);
        GroupLayout jPanelSchemeLayout = new GroupLayout((Container)this.jPanelScheme);
        this.jPanelScheme.setLayout((LayoutManager)jPanelSchemeLayout);
        jPanelSchemeLayout.setHorizontalGroup((GroupLayout.Group)jPanelSchemeLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSchemeLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSchemeLayout.createParallelGroup(1).add((Component)this.jToolBar1, -2, 253, -2).add((Component)this.jScrollPaneSchemeChart, -1, 621, Short.MAX_VALUE)).addContainerGap()));
        jPanelSchemeLayout.setVerticalGroup((GroupLayout.Group)jPanelSchemeLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSchemeLayout.createSequentialGroup().add((Component)this.jToolBar1, -2, 34, -2).addPreferredGap(0).add((Component)this.jScrollPaneSchemeChart, -1, 618, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPaneSchemes.addTab("Stratigraphic Schemes", new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_SchemeTab.png")), this.jPanelScheme);
        this.jSplitPane1.setRightComponent(this.jTabbedPaneSchemes);
        this.jTabbedPaneSchemes.getAccessibleContext().setAccessibleName("Stratigraphic Schemes");
        this.jMenuFile.setText("File");
        this.jMenuItemSelectWell.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItemSelectWell.setText("Open well...");
        this.jMenuItemSelectWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSelectWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSelectWell);
        this.jMenuItemOpenProject.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.jMenuItemOpenProject.setText("Open Project...");
        this.jMenuItemOpenProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemOpenProjectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemOpenProject);
        this.jMenuFile.add(this.jSeparator4);
        this.jMenuItemDetachWell.setText("Detach selected well tab");
        this.jMenuItemDetachWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemDetachWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemDetachWell);
        this.jMenuItemDetachChart.setText("Detach selected well chart tab");
        this.jMenuItemDetachChart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemDetachChartActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemDetachChart);
        this.jMenuItemRemoveWell.setText("Remove selected well tab");
        this.jMenuItemRemoveWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemRemoveWellActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemRemoveWell);
        this.jMenuFile.add(this.jSeparator27);
        this.jMenuItemSaveAsProject.setText("Save open wells as project...");
        this.jMenuItemSaveAsProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSaveAsProjectActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveAsProject);
        this.jMenuFile.add(this.jSeparator5);
        this.jMenuPrint.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Print16.png")));
        this.jMenuPrint.setText("Print");
        this.jMenuItemPrintChart.setText("Chart...");
        this.jMenuItemPrintChart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPrintChartActionPerformed(evt);
            }
        });
        this.jMenuPrint.add(this.jMenuItemPrintChart);
        this.jMenuItemPrintScheme.setText("Schemes chart...");
        this.jMenuItemPrintScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPrintSchemeActionPerformed(evt);
            }
        });
        this.jMenuPrint.add(this.jMenuItemPrintScheme);
        this.jMenuItemPrintAnalyses.setText("Analyses...");
        this.jMenuItemPrintAnalyses.setToolTipText("Print sample logging sheets for selected analyses");
        this.jMenuItemPrintAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPrintAnalysesActionPerformed(evt);
            }
        });
        this.jMenuPrint.add(this.jMenuItemPrintAnalyses);
        this.jMenuItemPrintImgGal.setText("Image gallery...");
        this.jMenuItemPrintImgGal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPrintImgGalActionPerformed(evt);
            }
        });
        this.jMenuPrint.add(this.jMenuItemPrintImgGal);
        this.jMenuFile.add(this.jMenuPrint);
        this.jMenu6.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Export16.png")));
        this.jMenu6.setText("Export chart");
        this.jMenuItemExportVector.setText("As PDF/vector image...");
        this.jMenuItemExportVector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemExportVectorActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportVector);
        this.jMenuItemExportRastor.setText("As bitmap...");
        this.jMenuItemExportRastor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemExportRastorActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportRastor);
        this.jMenu6.add(this.jSeparator26);
        this.jMenuItemExportHTML.setText("As HTML...");
        this.jMenuItemExportHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemExportHTMLActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportHTML);
        this.jMenu6.add(this.jSeparator21);
        this.jMenuItemExportChartHelp.setText("Help...");
        this.jMenuItemExportChartHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemExportChartHelpActionPerformed(evt);
            }
        });
        this.jMenu6.add(this.jMenuItemExportChartHelp);
        this.jMenuFile.add(this.jMenu6);
        this.jMenuFile.add(this.jSeparator6);
        this.jMenuOverlay.setText("Overlay");
        this.jMenuItemOpenOverlay.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItemOpenOverlay.setText("Select...");
        this.jMenuItemOpenOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemOpenOverlayActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemOpenOverlay);
        this.jMenuItemOverlayWeb.setText("Select for tablet...");
        this.jMenuItemOverlayWeb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemOverlayWebActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemOverlayWeb);
        this.jMenuOverlay.add(this.jSeparator2);
        this.jMenuItemNewOverlay.setText("Add...");
        this.jMenuItemNewOverlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemNewOverlayActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemNewOverlay);
        this.jMenuItemOverlayEdit.setText("Edit...");
        this.jMenuItemOverlayEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemOverlayEditActionPerformed(evt);
            }
        });
        this.jMenuOverlay.add(this.jMenuItemOverlayEdit);
        this.jMenuFile.add(this.jMenuOverlay);
        this.jMenuItemAbnSchemes.setText("Abundance Schemes...");
        this.jMenuItemAbnSchemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemAbnSchemesActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemAbnSchemes);
        this.jMenuItemCreateVoiceRecognitionFile.setText("Create Voice Recognition File...");
        this.jMenuItemCreateVoiceRecognitionFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemCreateVoiceRecognitionFileActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemCreateVoiceRecognitionFile);
        this.jMenuItemParseSample.setText("Parse Sample");
        this.jMenuItemParseSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemParseSampleActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemParseSample);
        this.jMenuFile.add(this.jSeparator7);
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuSample.setText("Samples");
        this.jMenu2.setText("Analyses");
        this.jMenuItemSampleCopy.setText("Copy occurrences from...");
        this.jMenuItemSampleCopy.setToolTipText("");
        this.jMenuItemSampleCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSampleCopyActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSampleCopy);
        this.jMenuItemSampleMove.setText("Move selected analyses to suite...");
        this.jMenuItemSampleMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSampleMoveActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemSampleMove);
        this.jMenuItemAnlysesMerge.setText("Merge selected analyses with suite...");
        this.jMenuItemAnlysesMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemAnlysesMergeActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemAnlysesMerge);
        this.jMenuItemAnalysesWeight.setText("Set sample weight for selection...");
        this.jMenuItemAnalysesWeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemAnalysesWeightActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemAnalysesWeight);
        this.jMenuItemTaxonReassign.setText("Reassign taxon/merge occurrences...");
        this.jMenuItemTaxonReassign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemTaxonReassignActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemTaxonReassign);
        this.jMenuSample.add(this.jMenu2);
        this.jMenuSample.add(this.jSeparator18);
        this.jMenuItemSampleGenerate.setText("Generate sample list...");
        this.jMenuItemSampleGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSampleGenerateActionPerformed(evt);
            }
        });
        this.jMenuSample.add(this.jMenuItemSampleGenerate);
        this.jMenuItemSampleAge.setText("Age and isotope ratio...");
        this.jMenuItemSampleAge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSampleAgeActionPerformed(evt);
            }
        });
        this.jMenuSample.add(this.jMenuItemSampleAge);
        this.jMenuItemSampleMerge.setText("Merge selected sample pair...");
        this.jMenuItemSampleMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSampleMergeActionPerformed(evt);
            }
        });
        this.jMenuSample.add(this.jMenuItemSampleMerge);
        this.jMenuSample.add(this.jSeparator17);
        this.jMenu3.setText("Biocomm. taxon name options");
        this.buttonGroupBiocommTaxaOptions.add(this.jRadioButtonMenuItemBiocomAbrGenus);
        this.jRadioButtonMenuItemBiocomAbrGenus.setSelected(true);
        this.jRadioButtonMenuItemBiocomAbrGenus.setText("Abbreviate genus");
        this.jMenu3.add(this.jRadioButtonMenuItemBiocomAbrGenus);
        this.buttonGroupBiocommTaxaOptions.add(this.jRadioButtonMenuItemBiocomFullName);
        this.jRadioButtonMenuItemBiocomFullName.setText("Use full name");
        this.jMenu3.add(this.jRadioButtonMenuItemBiocomFullName);
        this.jMenuSample.add(this.jMenu3);
        this.jMenuBar1.add(this.jMenuSample);
        this.jMenuOccurrences.setText("Occurrences");
        this.jRadioButtonMenuItemLogging.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.buttonGroupMode.add(this.jRadioButtonMenuItemLogging);
        this.jRadioButtonMenuItemLogging.setText("Click-to-count mode");
        this.jRadioButtonMenuItemLogging.setToolTipText("Click to increment occurrences");
        this.jRadioButtonMenuItemLogging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemLoggingActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemLogging);
        this.jRadioButtonMenuItemBrowsing.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        this.buttonGroupMode.add(this.jRadioButtonMenuItemBrowsing);
        this.jRadioButtonMenuItemBrowsing.setSelected(true);
        this.jRadioButtonMenuItemBrowsing.setText("Click-to-edit mode");
        this.jRadioButtonMenuItemBrowsing.setToolTipText("Click for Occurrence dialog");
        this.jRadioButtonMenuItemBrowsing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemBrowsingActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemBrowsing);
        this.jMenuOccurrences.add(this.jSeparator13);
        this.jRadioButtonMenuItemQuant.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.buttonGroupPicklist.add(this.jRadioButtonMenuItemQuant);
        this.jRadioButtonMenuItemQuant.setSelected(true);
        this.jRadioButtonMenuItemQuant.setText("Quantitative");
        this.jRadioButtonMenuItemQuant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemQuantActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemQuant);
        this.jRadioButtonMenuItemSemiQuant.setAccelerator(KeyStroke.getKeyStroke(81, 3));
        this.buttonGroupPicklist.add(this.jRadioButtonMenuItemSemiQuant);
        this.jRadioButtonMenuItemSemiQuant.setText("Semi-quantitative");
        this.jRadioButtonMenuItemSemiQuant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemSemiQuantActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jRadioButtonMenuItemSemiQuant);
        this.jMenuOccurrences.add(this.jSeparator11);
        this.jCheckBoxMenuItemGrainSize.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        this.jCheckBoxMenuItemGrainSize.setText("Separate size fractions");
        this.jCheckBoxMenuItemGrainSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jCheckBoxMenuItemGrainSizeActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemGrainSize);
        this.jMenuOccurrences.add(this.jSeparator12);
        this.jCheckBoxMenuItemTotaliser.setText("Set count limit");
        this.jCheckBoxMenuItemTotaliser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jCheckBoxMenuItemTotaliserActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemTotaliser);
        this.jMenuItemMultiplier.setText("Set count multiplier button");
        this.jMenuItemMultiplier.setEnabled(false);
        this.jMenuItemMultiplier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemMultiplierActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jMenuItemMultiplier);
        this.jCheckBoxMenuItemOccSound.setText("Play confirmation sounds");
        this.jCheckBoxMenuItemOccSound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jCheckBoxMenuItemOccSoundActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemOccSound);
        this.jMenuMultiClick.setText("Multi-click behaviour");
        this.buttonGroupMultiClick.add(this.jRadioButtonMenuItemDoubleClick);
        this.jRadioButtonMenuItemDoubleClick.setSelected(true);
        this.jRadioButtonMenuItemDoubleClick.setText("Separate double-clicks");
        this.jRadioButtonMenuItemDoubleClick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemDoubleClickActionPerformed(evt);
            }
        });
        this.jMenuMultiClick.add(this.jRadioButtonMenuItemDoubleClick);
        this.buttonGroupMultiClick.add(this.jRadioButtonMenuItemContinuousClick);
        this.jRadioButtonMenuItemContinuousClick.setText("Continuous click increments");
        this.jRadioButtonMenuItemContinuousClick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemContinuousClickActionPerformed(evt);
            }
        });
        this.jMenuMultiClick.add(this.jRadioButtonMenuItemContinuousClick);
        this.jMenuOccurrences.add(this.jMenuMultiClick);
        this.jCheckBoxMenuItemExcludeRwCvTotals.setText("Exclude Rw/Cv from displayed totals");
        this.jCheckBoxMenuItemExcludeRwCvTotals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jCheckBoxMenuItemExcludeRwCvTotalsActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jCheckBoxMenuItemExcludeRwCvTotals);
        this.jMenuOccurrences.add(this.jSeparator15);
        this.jMenuItemNumericCode.setText("Input logging sheet...");
        this.jMenuItemNumericCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemNumericCodeActionPerformed(evt);
            }
        });
        this.jMenuOccurrences.add(this.jMenuItemNumericCode);
        this.jMenuOccurrences.add(this.jSeparator22);
        this.jMenuPicklist.setText("Picklist");
        this.jMenuPicklistView.setText("View");
        this.buttonGroupPickMode.add(this.jRadioButtonMenuItemPickHoriz);
        this.jRadioButtonMenuItemPickHoriz.setText("Multiple columns");
        this.jRadioButtonMenuItemPickHoriz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemPickHorizActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jRadioButtonMenuItemPickHoriz);
        this.buttonGroupPickMode.add(this.jRadioButtonMenuItemPickVert);
        this.jRadioButtonMenuItemPickVert.setSelected(true);
        this.jRadioButtonMenuItemPickVert.setText("Single column");
        this.jRadioButtonMenuItemPickVert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemPickVertActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jRadioButtonMenuItemPickVert);
        this.jMenuPicklistView.add(this.jSeparator16);
        this.jCheckBoxMenuItemPickAuthor.setSelected(true);
        this.jCheckBoxMenuItemPickAuthor.setText("Include author in taxon names");
        this.jCheckBoxMenuItemPickAuthor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jCheckBoxMenuItemPickAuthorActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jCheckBoxMenuItemPickAuthor);
        this.jCheckBoxMenuItemPickCat.setSelected(true);
        this.jCheckBoxMenuItemPickCat.setText("Include category in taxon names");
        this.jCheckBoxMenuItemPickCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jCheckBoxMenuItemPickCatActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jCheckBoxMenuItemPickCat);
        this.jCheckBoxMenuItemPickCode.setSelected(true);
        this.jCheckBoxMenuItemPickCode.setText("Include code in taxon names");
        this.jCheckBoxMenuItemPickCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jCheckBoxMenuItemPickCodeActionPerformed(evt);
            }
        });
        this.jMenuPicklistView.add(this.jCheckBoxMenuItemPickCode);
        this.jMenuPicklist.add(this.jMenuPicklistView);
        this.jMenuPicklist.add(this.jSeparator10);
        this.jMenuItemInsertTaxa.setText("Insert taxa...");
        this.jMenuItemInsertTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemInsertTaxaActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemInsertTaxa);
        this.jMenuItemInsertGroup.setText("Insert group...");
        this.jMenuItemInsertGroup.setToolTipText("Save this list as a text file");
        this.jMenuItemInsertGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemInsertGroupActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemInsertGroup);
        this.jMenuItemInsertWellOutcrop.setText("Insert well/outcrop...");
        this.jMenuItemInsertWellOutcrop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemInsertWellOutcropActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemInsertWellOutcrop);
        this.jMenuPicklist.add(this.jSeparator8);
        this.jMenuItemPicklistNew.setText("Add new...");
        this.jMenuItemPicklistNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPicklistNewActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemPicklistNew);
        this.jMenuItemPicklistEdit.setText("Edit title...");
        this.jMenuItemPicklistEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPicklistEditActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemPicklistEdit);
        this.jMenuItemPicklistRemove.setText("Remove selected");
        this.jMenuItemPicklistRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemPicklistRemoveActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemPicklistRemove);
        this.jMenuPicklist.add(this.jSeparator23);
        this.jMenuItemSaveAsGroup.setText("Save as group...");
        this.jMenuItemSaveAsGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemSaveAsGroupActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemSaveAsGroup);
        this.jMenuPicklist.add(this.jSeparator14);
        this.jMenuItemClearSelection.setText("Clear selection");
        this.jMenuItemClearSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemClearSelectionActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemClearSelection);
        this.jMenuItemClear.setText("Clear");
        this.jMenuItemClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemClearActionPerformed(evt);
            }
        });
        this.jMenuPicklist.add(this.jMenuItemClear);
        this.jMenuOccurrences.add(this.jMenuPicklist);
        this.jMenuBar1.add(this.jMenuOccurrences);
        this.jMenuView.setText("View");
        this.jMenuItemTableOptions.setText("Table options...");
        this.jMenuItemTableOptions.setToolTipText("Options for all instances of selected table");
        this.jMenuItemTableOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemTableOptionsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemTableOptions);
        this.jMenuItemTableDefaults.setText("Restore table defaults");
        this.jMenuItemTableDefaults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemTableDefaultsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemTableDefaults);
        this.jMenuView.add(this.jSeparator24);
        this.jMenu5.setText("Well tab titles");
        this.buttonGroupWellTabTitles.add(this.jRadioButtonMenuItemWellNames);
        this.jRadioButtonMenuItemWellNames.setSelected(true);
        this.jRadioButtonMenuItemWellNames.setText("Well names");
        this.jRadioButtonMenuItemWellNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemWellNamesActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jRadioButtonMenuItemWellNames);
        this.buttonGroupWellTabTitles.add(this.jRadioButtonMenuItemWellCodes);
        this.jRadioButtonMenuItemWellCodes.setText("Well codes");
        this.jRadioButtonMenuItemWellCodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jRadioButtonMenuItemWellCodesActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jRadioButtonMenuItemWellCodes);
        this.jMenuView.add(this.jMenu5);
        this.jMenuView.add(this.jSeparator25);
        this.jMenuItemViewFilteredOccs.setText("Filtered occurrences...");
        this.jMenuItemViewFilteredOccs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemViewFilteredOccsActionPerformed(evt);
            }
        });
        this.jMenuView.add(this.jMenuItemViewFilteredOccs);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuHelp.setText("Help");
        this.jMenuItemHelpHome.setText("Samples & Interpretations help...");
        this.jMenuItemHelpHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpHomeActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpHome);
        this.jMenuItemHelpMenu.setText("Menus...");
        this.jMenuItemHelpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpMenuActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpMenu);
        this.jMenuHelp.add(this.jSeparator3);
        this.jMenuItemHelpSamples.setText("Samples tab...");
        this.jMenuItemHelpSamples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpSamplesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpSamples);
        this.jMenuItemHelpAnalyses.setText("Analyses tab...");
        this.jMenuItemHelpAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpAnalysesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpAnalyses);
        this.jMenuItemHelpOccurrences.setText("Occurrences tab...");
        this.jMenuItemHelpOccurrences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpOccurrencesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpOccurrences);
        this.jMenuItemHelpInterp.setText("Interpretations tab...");
        this.jMenuItemHelpInterp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpInterpActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpInterp);
        this.jMenuItemHelpchart.setText("Charts tab...");
        this.jMenuItemHelpchart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpchartActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpchart);
        this.jMenuHelp.add(this.jSeparator1);
        this.jMenuItemHelpSchemes.setText("Stratigraphic schemes...");
        this.jMenuItemHelpSchemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpSchemesActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpSchemes);
        this.jMenuItemHelpPicklist.setText("Picklist...");
        this.jMenuItemHelpPicklist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpPicklistActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpPicklist);
        this.jMenuHelp.add(this.jSeparator9);
        this.jMenuItemHelpOverlays.setText("Overlays...");
        this.jMenuItemHelpOverlays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameSamples.this.jMenuItemHelpOverlaysActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpOverlays);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1, -1, 1011, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jSplitPane1));
        this.jSplitPane1.setRightComponent(this.jTabbedPaneSchemes);
        this.jSplitPane1.setLeftComponent(this.jTabbedPaneWell);
        this.pack();
    }

    private void jButtonSchemeZoomOutActionPerformed(ActionEvent evt) {
        this.schemeZoom = (float)((double)this.schemeZoom / 1.5);
        this.setSchemeScrollPaneSize();
    }

    private void jButtonSchemeZoomInActionPerformed(ActionEvent evt) {
        this.schemeZoom = (float)((double)this.schemeZoom * 1.5);
        this.setSchemeScrollPaneSize();
    }

    private void jButtonSchemePanelProperitesActionPerformed(ActionEvent evt) {
        SchemeBlock block = this.schemeChartJPanel.chart.getAddSchemeBlock();
        if (block != null) {
            DialogSchemeBlock dialog = new DialogSchemeBlock(this, true, block, this.sbdb, this.schemeChartJPanel.chart.chartProperties);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.schemeChartJPanel.chart.calcChartSize();
                this.setSchemeScrollPaneSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectSchemePanelActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDType typeDialog = new DialogSelectIGDType((Frame)this, true, false);
            typeDialog.setLocationRelativeTo(this);
            typeDialog.setVisible(true);
            if (!typeDialog.isOK()) {
                return;
            }
            int igdType = typeDialog.igdType;
            if (igdType == 20) {
                DialogSelectCmpStd dialog = new DialogSelectCmpStd((Frame)this, true, this.sbdb, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.schemeChartJPanel.chart.getAddSchemeBlock().addCompositeStandard(dialog.selection, this.sbdb);
                    dialog.selection.addObserver((Observer)this.schemeChartJPanel);
                    this.setSchemeChartMargin();
                    this.schemeChartJPanel.chart.calcChartSize();
                    this.setSchemeScrollPaneSize();
                    Point2D p = this.schemeChartJPanel.chart.getCmpStdOrigin(dialog.selection);
                    Point p2 = this.schemeChartJPanel.getPosition(p);
                    Rectangle visible = this.schemeChartJPanel.getVisibleRect();
                    Rectangle r = new Rectangle(p2.x, p2.y, visible.width, visible.height);
                    this.schemeChartJPanel.scrollRectToVisible(r);
                }
            } else if (igdType == 25) {
                List ageCurves = this.sbdb.getAgeCurves();
                DialogList dialog = new DialogList(this, true, "Select Age Curve", this.sbdb, ageCurves, true, false);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    AgeCurve curve = (AgeCurve)dialog.selection;
                    this.schemeChartJPanel.chart.getAddSchemeBlock().addAgeCurve(curve);
                    this.setSchemeChartMargin();
                    this.schemeChartJPanel.chart.calcChartSize();
                    this.setSchemeScrollPaneSize();
                    Point2D p = this.schemeChartJPanel.chart.getAgeCurveOrigin(curve);
                    Point p2 = this.schemeChartJPanel.getPosition(p);
                    Rectangle visible = this.schemeChartJPanel.getVisibleRect();
                    Rectangle r = new Rectangle(p2.x, p2.y, visible.width, visible.height);
                    this.schemeChartJPanel.scrollRectToVisible(r);
                }
            } else if (igdType < 0) {
                if (!this.schemeChartJPanel.chart.getAddSchemeBlock().addAgeScale()) {
                    JOptionPane.showMessageDialog(this, "Block already has an age scale panel", "Add scale", 1);
                } else {
                    this.schemeChartJPanel.chart.calcChartSize();
                    this.schemeChartJPanel.repaint();
                }
            } else {
                DialogSelectScheme dialog = new DialogSelectScheme((Frame)this, true, this.sbdb, igdType);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.addChartScheme(dialog.selection);
                    dialog.selection.addObserver((Observer)this.schemeChartJPanel);
                }
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error creating scheme chart", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void addChartScheme(IGDScheme scheme) throws SQLException, SBException {
        this.schemeChartJPanel.chart.getAddSchemeBlock().addScheme(scheme);
        this.setSchemeChartMargin();
        this.schemeChartJPanel.chart.calcChartSize();
        this.schemeChartJPanel.chart.getSchemeBlock().setWellInterp(this.getWellPanel().getInterp());
        scheme.addObserver((Observer)this.schemeChartJPanel);
        this.setSchemeScrollPaneSize();
        Point2D p = this.schemeChartJPanel.chart.getSchemeOrigin(scheme);
        Point p2 = this.schemeChartJPanel.getPosition(p);
        Rectangle visible = this.schemeChartJPanel.getVisibleRect();
        Rectangle r = new Rectangle(p2.x, p2.y, visible.width, visible.height);
        this.schemeChartJPanel.scrollRectToVisible(r);
        this.jTabbedPaneSchemes.setSelectedComponent(this.jPanelScheme);
    }

    private void setSchemeChartMargin() {
        this.schemeChartJPanel.chart.chartProperties.margin = 3.0f;
    }

    private void setSchemeScrollPaneSize() {
        this.schemeChartJPanel.setSize(this.schemeZoom);
        this.schemeChartJPanel.revalidate();
        this.schemeChartJPanel.repaint();
    }

    private void jMenuItemTableOptionsActionPerformed(ActionEvent evt) {
        TableModelSB model = this.getWellPanel().getSelectedTable();
        LinkedList<TablePair> tables = new LinkedList<TablePair>();
        if (model != null) {
            for (JPanelWell wellPanel : this.getWellPanels()) {
                LinkedList<TablePair> tablePairs = wellPanel.getTablePair(model);
                if (tablePairs == null || tablePairs.isEmpty()) continue;
                tables.addAll(tablePairs);
            }
        }
        if (tables.isEmpty()) {
            return;
        }
        DialogTableOptions dialog = new DialogTableOptions((Frame)this, true, tables);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    void insertWell(JPanelPicklist list) {
        final JPanelPicklist picklist = this.getSelectedPicklist(list);
        Well well = null;
        JPanelWell wellPanel = this.getWellPanel();
        if (wellPanel != null) {
            well = wellPanel.getWell();
        }
        final DialogWellDisc dialog = new DialogWellDisc((Frame)this, true, this.sbdb, well);
        dialog.setLocationRelativeTo(this);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TxGroup group;
                        LinkedList<Taxon> wellTaxa = new LinkedList<Taxon>();
                        for (Well well : dialog.wells) {
                            wellTaxa.addAll(FrameSamples.this.sbdb.getWellTaxa(well, dialog.discID, dialog.analyst));
                        }
                        picklist.setTaxa(wellTaxa);
                        if (picklist.getGroupID() > 0 && (group = FrameSamples.this.sbdb.getTxGroup(picklist.getGroupID())) != null && FrameSamples.this.jTabbedPaneSchemes.getTitleAt(FrameSamples.this.jTabbedPaneSchemes.getSelectedIndex()).equals(group.getName())) {
                            FrameSamples.this.jTabbedPaneSchemes.setTitleAt(FrameSamples.this.jTabbedPaneSchemes.getSelectedIndex(), "Picklist");
                        }
                    }
                    catch (Exception e) {
                        SB.showStackError((String)"Error inserting into picklist", (Exception)e);
                    }
                    finally {
                        FrameSamples.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
        }
        this.setAlwaysOnTop(true);
        this.setAlwaysOnTop(false);
    }

    private void jMenuItemInsertWellOutcropActionPerformed(ActionEvent evt) {
        this.insertWell(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertGroup(JPanelPicklist list) {
        JPanelPicklist picklist = this.getSelectedPicklist(list);
        try {
            ArrayList groups = new ArrayList(this.sbdb.getTxGroups());
            Collections.sort(groups);
            DialogList dialog = new DialogList(this, true, "Select Group", this.sbdb, groups, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                TxGroup group = (TxGroup)dialog.selection;
                if (picklist.isEmpty() && !picklist.isChanged()) {
                    this.jTabbedPaneSchemes.setTitleAt(this.jTabbedPaneSchemes.getSelectedIndex(), group.getName());
                } else {
                    this.jTabbedPaneSchemes.setTitleAt(this.jTabbedPaneSchemes.getSelectedIndex(), "Picklist");
                }
                picklist.setTaxa(this.sbdb.getTxGroupTaxa(group));
                picklist.setGroup(group);
            }
            this.setAlwaysOnTop(true);
            this.setAlwaysOnTop(false);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening dialog", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void setPicklistGroupTitle(TxGroup group) {
        Component[] component = this.jTabbedPaneSchemes.getComponents();
        for (int i = 0; i < component.length; ++i) {
            JPanelPicklist pl;
            if (!(component[i] instanceof JPanelPicklist) || (pl = (JPanelPicklist)component[i]).getGroupID() != group.getID()) continue;
            this.jTabbedPaneSchemes.setTitleAt(i, group.getName());
        }
    }

    private void jMenuItemInsertGroupActionPerformed(ActionEvent evt) {
        this.insertGroup(null);
    }

    private void jMenuItemInsertTaxaActionPerformed(ActionEvent evt) {
        this.insertTaxon(null);
    }

    void insertTaxon(JPanelPicklist list) {
        JPanelPicklist picklist = this.getSelectedPicklist(list);
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa(this.parent, true, this.sbdb, false, picklist.getSelectedTaxon());
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                picklist.setTaxa(dialog.selection);
                if (picklist.getGroupAutoSave()) {
                    picklist.saveGroup();
                }
            }
            this.parent.setAlwaysOnTop(true);
            this.parent.setAlwaysOnTop(false);
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error opening dialog", (Exception)ex);
        }
    }

    void exit(boolean force) {
        String msg;
        int nUnsaved = 0;
        for (JPanelPicklist picklist : this.picklists) {
            if (!picklist.isUnsaved()) continue;
            ++nUnsaved;
        }
        if (!force && nUnsaved > 0 && JOptionPane.showConfirmDialog(this, msg = nUnsaved + (nUnsaved > 1 ? nUnsaved + " picklists are" : " picklist is") + " unsaved. Exit without saving?", "Exit", 0) != 0) {
            return;
        }
        for (FrameWellChartsDetached chartsFrame : this.chartsFrames) {
            chartsFrame.exit();
        }
        for (FrameWellDetached frame : this.wellFrames) {
            frame.dispose();
        }
        if (this.getWellPanel() != null) {
            this.getWellPanel().putTableColumnWidths();
        }
        this.encodeSession();
        this.dispose();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.exit(false);
    }

    private LinkedList<JPanelWell> getWellPanels() {
        LinkedList<JPanelWell> wellPanels = new LinkedList<JPanelWell>();
        for (Component c : this.jTabbedPaneWell.getComponents()) {
            if (!(c instanceof JPanelWell)) continue;
            wellPanels.add((JPanelWell)c);
        }
        return wellPanels;
    }

    private void jMenuItemParseSampleActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemented - dialog for illustration only.\nWe have work in progress that can be completed if it will be of use, contact StrataData for details.", this.getTitle(), 2);
        DialogParseSample dialog = new DialogParseSample((Frame)this, true);
        dialog.setVisible(true);
    }

    private void jMenuItemSampleGenerateActionPerformed(ActionEvent evt) {
        this.getWellPanel().sampleGenerate();
    }

    private void jMenuItemClearActionPerformed(ActionEvent evt) {
        if (this.getSelectedPicklist() != null) {
            this.getSelectedPicklist().clear();
        }
    }

    private void jMenuItemClearSelectionActionPerformed(ActionEvent evt) {
        if (this.getSelectedPicklist() != null) {
            this.getSelectedPicklist().clearSelection();
        }
    }

    private void jMenuItemSaveAsGroupActionPerformed(ActionEvent evt) {
        if (this.getSelectedPicklist() == null) {
            JOptionPane.showMessageDialog(this, "Select a picklist", "Save as group", 2);
            return;
        }
        this.getSelectedPicklist().saveAsGroup();
    }

    private void jMenuItemSampleCopyActionPerformed(ActionEvent evt) {
        this.getWellPanel().sampleCopy();
    }

    private void jMenuItemPrintChartActionPerformed(ActionEvent evt) {
        this.getWellPanel().printChart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemSelectWellActionPerformed(ActionEvent evt) {
        try {
            if (!this.parent.checkRLMlicence()) {
                JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                this.dispose();
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Clear existing wells?", "Open Well", 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            DialogSelectWell dialog = new DialogSelectWell((Frame)this, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (opt == 0) {
                    for (JPanelWell wellPanel : this.getWellPanels()) {
                        wellPanel.removeChart();
                        wellPanel.closeOverlayServer();
                    }
                    this.jTabbedPaneWell.removeAll();
                }
                for (Well well : dialog.selection) {
                    this.addWellTab(well);
                }
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening well tab", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
    }

    private void formWindowLostFocus(WindowEvent evt) {
    }

    private void jMenuItemRemoveWellActionPerformed(ActionEvent evt) {
        if (this.getWellPanels().size() == 1) {
            JOptionPane.showMessageDialog(this, "Cannot remove - there is only one well tab.", this.getTitle(), 2);
            return;
        }
        JPanelWell wellPanel = this.getWellPanel();
        wellPanel.removeChart();
        wellPanel.closeOverlayServer();
        this.jTabbedPaneWell.remove(wellPanel);
    }

    public void removeWell(Well well) {
        boolean removed = false;
        for (JPanelWell wellPanel : this.getWellPanels()) {
            if (wellPanel.well.getWellID() != well.getWellID()) continue;
            wellPanel.removeChart();
            wellPanel.closeOverlayServer();
            this.jTabbedPaneWell.remove(wellPanel);
            removed = true;
            break;
        }
        if (!removed) {
            for (FrameWellDetached wellFrame : this.wellFrames) {
                if (wellFrame.getPanel().well.getWellID() != well.getWellID()) continue;
                JPanelWell panel = wellFrame.getPanel();
                panel.removeChart();
                panel.closeOverlayServer();
                wellFrame.exit();
                this.jTabbedPaneWell.remove(panel);
                removed = true;
                break;
            }
        }
        if (removed && this.jTabbedPaneWell.getTabCount() == 0) {
            this.dispose();
        }
    }

    private void jMenuItemDetachWellActionPerformed(ActionEvent evt) {
        if (this.getWellPanels().size() == 1) {
            JOptionPane.showMessageDialog(this, "Cannot detach - there is only one well tab.", this.getTitle(), 2);
            return;
        }
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        this.jTabbedPaneWell.remove(panel);
        FrameWellDetached frame = new FrameWellDetached(this, panel);
        frame.setVisible(true);
        this.wellFrames.add(frame);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exit(false);
    }

    private void jRadioButtonMenuItemQuantActionPerformed(ActionEvent evt) {
        this.setNumeric();
    }

    private void jRadioButtonMenuItemSemiQuantActionPerformed(ActionEvent evt) {
        this.setNumeric();
    }

    private void setNumeric() {
        for (JPanelPicklist picklist : this.picklists) {
            picklist.setControls(this.isCMF(), this.isNumeric());
        }
        if (this.dialogTaxonCodeInput != null) {
            this.dialogTaxonCodeInput.setNumeric();
        }
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"SEMIQUANT", (int)(this.isNumeric() ? 0 : 1));
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jCheckBoxMenuItemGrainSizeActionPerformed(ActionEvent evt) {
        if (this.parent.getFrameOverlay() != null) {
            this.parent.getFrameOverlay().jPanelOverlay.setCMF(this.isCMF());
        }
        for (JPanelPicklist picklist : this.picklists) {
            picklist.setControls(this.isCMF(), this.isNumeric());
        }
        for (JPanelWell wellPanel : this.getWellPanels()) {
            wellPanel.setCMF(this.isCMF());
        }
    }

    private void jMenuItemOpenOverlayActionPerformed(ActionEvent evt) {
        this.getWellPanel().openOverlay();
    }

    void setOverlayTotaliser() {
        if (this.parent.getFrameOverlay() != null) {
            this.parent.getFrameOverlay().jPanelOverlay.setTotaliser(this.picklistTotaliser);
        }
    }

    private void jMenuItemNewOverlayActionPerformed(ActionEvent evt) {
        if (this.parent.getFrameOverlay() != null) {
            JOptionPane.showMessageDialog(this, "An overlay is currently in use.", this.getTitle(), 2);
            return;
        }
        try {
            DialogOverlay dialog = new DialogOverlay((Frame)this, true, this.sbdb, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.overlay != null) {
                FrameOverlay frameOverlay = new FrameOverlay(this.parent.getAltGC(), this.parent, this.sbdb, this.getWellPanel().well, this.getWellPanel().getSmpdtl(), dialog.overlay, this.isCMF(), this);
                this.parent.setFrameOverlay(frameOverlay);
                frameOverlay.getUndoSupport().addUndoableEditListener(this.getWellPanel().undoManagerOccs);
                this.setOverlayTotaliser();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error creating overlay frame: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            return;
        }
    }

    private void jTabbedPaneWellStateChanged(ChangeEvent evt) {
        if (this.getWellPanel() != null) {
            this.setSchemeChartVersion(this.getWellPanel().getInterp());
        }
    }

    private void jMenuItemOverlayEditActionPerformed(ActionEvent evt) {
        if (this.parent.getFrameOverlay() == null) {
            JOptionPane.showMessageDialog(this, "No overlay currently selected.", this.getTitle(), 2);
            return;
        }
        try {
            DialogOverlay dialog = new DialogOverlay((Frame)this, true, this.sbdb, this.parent.getFrameOverlay().getOverlay());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.overlay != null) {
                this.parent.getFrameOverlay().setVisible(true);
                this.parent.getFrameOverlay().repaint();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            return;
        }
    }

    private void jMenuItemHelpMenuActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_menu.html");
    }

    private void jMenuItemHelpSamplesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_samplestab.html");
    }

    private void jMenuItemHelpAnalysesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_analysestab.html");
    }

    private void jMenuItemHelpOccurrencesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_occurrencestab.html");
    }

    private void jMenuItemHelpInterpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_interpretationstab.html");
    }

    private void jMenuItemHelpchartActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_chartstab.html");
    }

    private void jMenuItemHelpSchemesActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_schemestab.html");
    }

    private void jMenuItemHelpPicklistActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_picklisttab.html");
    }

    private void jCheckBoxMenuItemTotaliserActionPerformed(ActionEvent evt) {
        if (this.picklistTotaliser == 0) {
            String strg = JOptionPane.showInputDialog(this, "Enter analysis total", 100);
            if (strg != null) {
                try {
                    int total;
                    this.picklistTotaliser = total = Integer.parseInt(strg);
                    this.jCheckBoxMenuItemTotaliser.setText("Count limit set to: " + total);
                    if (this.parent.getFrameOverlay() != null) {
                        this.parent.getFrameOverlay().jPanelOverlay.setTotaliser(total);
                    }
                    Lastval.putInt((SBdb)this.sbdb, (String)"PICKTOTAL", (int)total);
                    this.sbdb.commit();
                }
                catch (Exception ex) {
                    this.jCheckBoxMenuItemTotaliser.setSelected(false);
                    this.jCheckBoxMenuItemTotaliser.setText("Set count limit");
                    return;
                }
            } else {
                this.jCheckBoxMenuItemTotaliser.setSelected(false);
            }
            this.getWellPanel().setNTaxaText();
        } else {
            this.picklistTotaliser = 0;
            this.jCheckBoxMenuItemTotaliser.setSelected(false);
            this.jCheckBoxMenuItemTotaliser.setText("Set count limit");
            if (this.parent.getFrameOverlay() != null) {
                this.parent.getFrameOverlay().jPanelOverlay.setTotaliser(0);
            }
            ((JPanelWell)this.jTabbedPaneWell.getSelectedComponent()).setNTaxaText();
            try {
                Lastval.putInt((SBdb)this.sbdb, (String)"PICKTOTAL", (int)0);
                this.sbdb.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jMenuItemOpenProjectActionPerformed(ActionEvent evt) {
        try {
            int opt = JOptionPane.showConfirmDialog(this, "Clear existing wells?", "Open project", 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            DialogSelectProject dialog = new DialogSelectProject((Frame)this, true, this.sbdb, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                if (opt == 0) {
                    this.jTabbedPaneWell.removeAll();
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                dialog.selection.loadWells(this.sbdb, this.sbdb.getDatabase().createStatement());
                for (int i = 0; i < dialog.selection.getSize(); ++i) {
                    Well well = dialog.selection.getWellAt(i);
                    this.addWellTab(well);
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error opening well tab: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jMenuItemAbnSchemesActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemes dialog = new DialogAbnSchemes((Frame)this, true, this.sbdb);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Exception loading schemes: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jMenuItemCreateVoiceRecognitionFileActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemented.\nWe have work in progress that can be completed if it will be of use, contact StrataData for details.", this.getTitle(), 1);
    }

    private void jMenuItemMultiplierActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemented.", this.getTitle(), 1);
    }

    private void jMenuItemHelpHomeActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples.html");
    }

    private void jMenuItemPrintAnalysesActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        List<Smpdtl> smpdtls = panel.getSelectedSmpdtls();
        if (smpdtls == null || smpdtls.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Select one or more analyses", this.getTitle(), 1);
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!job.printDialog()) {
            return;
        }
        PageFormat pf = job.defaultPage();
        LinkedList<LoggingSheet> logSheets = new LinkedList<LoggingSheet>();
        try {
            block5: for (Smpdtl smpdtl : smpdtls) {
                LoggingSheet logSheet = new LoggingSheet(panel.getWell(), smpdtl, this.sbdb.getUser(), panel.units);
                logSheets.add(logSheet);
                if (panel.getInterp() == null) continue;
                for (Biocom comment : panel.getInterp().getComments()) {
                    if (comment.getDiscID() != smpdtl.getDiscID() || comment.getTopID() != smpdtl.getSample().getSampID() || !comment.getAnalystString().equals(smpdtl.getAnalyst())) continue;
                    logSheet.setBSComment(comment.getText());
                    continue block5;
                }
            }
            this.decodeLogSheetPrefs(logSheets);
            PrintJPanel printPanel = new PrintJPanel(logSheets, pf);
            DialogPrintPreview dialog = new DialogPrintPreview(this, true, logSheets, printPanel, job, pf, this.sbdb);
            dialog.setVisible(true);
            if (dialog.isPrint) {
                job.setPrintable(printPanel, dialog.pf);
            }
            try {
                job.print();
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(this, "Problem printing");
                exp.printStackTrace();
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
    }

    private void jMenuItemViewFilteredOccsActionPerformed(ActionEvent evt) {
        DialogTaxonWellOccFiltered dialog = new DialogTaxonWellOccFiltered((Frame)this, true, this.getWellPanel().getWell(), this.getWellPanel().units);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jMenuItemSampleMoveActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.moveAnalyses();
    }

    private void jMenuItemSampleMergeActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.mergeSamples();
    }

    private void jMenuItemAnlysesMergeActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.mergeAnalyses();
    }

    private void jMenuItemSampleAgeActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.sampleAge();
    }

    private void jMenuItemAnalysesWeightActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.sampleWeight();
    }

    private void jMenuItemDetachChartActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        if (panel == null || !(panel instanceof JPanelWell)) {
            JOptionPane.showMessageDialog(this, "No well panel selected.", this.getTitle(), 1);
        }
        if (!panel.detachChartTab()) {
            JOptionPane.showMessageDialog(this, "Chart tab already detached for this well", this.getTitle(), 1);
        } else {
            this.chartsFrames.add(panel.chartsFrameDetached);
        }
    }

    private void jMenuItemTaxonReassignActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        if (panel == null || !(panel instanceof JPanelWell)) {
            JOptionPane.showMessageDialog(this, "No well panel selected.", this.getTitle(), 1);
        }
        panel.reassignTaxon();
    }

    private void jMenuItemHelpOverlaysActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtouseoverlays.html");
    }

    private void jCheckBoxMenuItemPickAuthorActionPerformed(ActionEvent evt) {
        Taxon.includeAuthorInString = this.jCheckBoxMenuItemPickAuthor.isSelected();
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"TAXONAUTH", (int)(Taxon.includeAuthorInString ? 1 : 0));
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (JPanelPicklist list : this.picklists) {
            list.repaintList();
        }
    }

    private void jCheckBoxMenuItemPickCatActionPerformed(ActionEvent evt) {
        Taxon.includeCategoryInString = this.jCheckBoxMenuItemPickCat.isSelected();
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"TAXONCAT", (int)(Taxon.includeCategoryInString ? 1 : 0));
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (JPanelPicklist list : this.picklists) {
            list.repaintList();
        }
    }

    private void jRadioButtonMenuItemLoggingActionPerformed(ActionEvent evt) {
        this.setLogging(true);
    }

    private void jRadioButtonMenuItemBrowsingActionPerformed(ActionEvent evt) {
        this.setLogging(false);
    }

    private void jRadioButtonMenuItemPickHorizActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist(null);
        if (picklist != null) {
            picklist.setListLayout(1);
        }
    }

    private void jRadioButtonMenuItemPickVertActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist(null);
        if (picklist != null) {
            picklist.setListLayout(0);
        }
    }

    private void jRadioButtonMenuItemWellNamesActionPerformed(ActionEvent evt) {
        this.setWellTabTitles(true);
    }

    private void jRadioButtonMenuItemWellCodesActionPerformed(ActionEvent evt) {
        this.setWellTabTitles(false);
    }

    private void jMenuItemPrintImgGalActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        List<Smpdtl> smpdtls = panel.getSelectedSmpdtls();
        if (smpdtls == null || smpdtls.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Select one or more analyses", this.getTitle(), 1);
            return;
        }
        LinkedList<Smpdtl> toRemove = new LinkedList<Smpdtl>();
        for (Smpdtl dtl : smpdtls) {
            boolean imgfound = false;
            for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                try {
                    if (!occ.hasImageSet()) continue;
                    imgfound = true;
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (imgfound) continue;
            toRemove.add(dtl);
        }
        for (Smpdtl dtl : toRemove) {
            smpdtls.remove(dtl);
        }
        if (smpdtls.isEmpty()) {
            JOptionPane.showMessageDialog(this, "There are no images in the selected analyses.", this.getTitle(), 1);
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!job.printDialog()) {
            return;
        }
        PageFormat pf = job.defaultPage();
        ImageGallery gallery = new ImageGallery(smpdtls, panel.getWell());
        this.decodeImgGalleryPrefs(gallery);
        LinkedList<ImageGallery> prints = new LinkedList<ImageGallery>();
        prints.add(gallery);
        PrintJPanel printPanel = new PrintJPanel(prints, pf);
        DialogPrintPreview dialog = new DialogPrintPreview(this, true, prints, printPanel, job, pf, this.sbdb);
        dialog.setVisible(true);
        if (dialog.isPrint) {
            job.setPrintable(printPanel, dialog.pf);
        }
        try {
            job.print();
        }
        catch (Exception exp) {
            JOptionPane.showMessageDialog(this, "Problem printing");
            exp.printStackTrace();
        }
    }

    private void jMenuItemPanelPropertiesActionPerformed(ActionEvent evt) {
        try {
            Point2D pTemp = this.schemeChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.schemeChartJPanel.chart.getSelectedPanel(mmPoint);
            SBDialog dialog = null;
            if (panel instanceof PanelIGDScheme) {
                dialog = new DialogPanelIGDScheme(this, true, (PanelIGDScheme)panel);
            } else if (panel instanceof PanelCompositeStandard) {
                dialog = new DialogPanelEvents((Frame)this, true, (PanelEventsBase)((PanelCompositeStandard)panel), this.sbdb);
            } else if (panel instanceof PanelSurfaces) {
                dialog = new DialogPanelSurfaces((Frame)this, true, (PanelSurfaces)panel);
            }
            if (dialog != null) {
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemExportVectorActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.saveChart(true);
    }

    private void jMenuItemExportRastorActionPerformed(ActionEvent evt) {
        JPanelWell panel = (JPanelWell)this.jTabbedPaneWell.getSelectedComponent();
        panel.saveChart(false);
    }

    private void jMenuItemExportChartHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("charts_export.html");
    }

    private void jMenuItemPrintSchemeActionPerformed(ActionEvent evt) {
        Chart chart = this.schemeChartJPanel.chart;
        if (chart == null) {
            JOptionPane.showMessageDialog(this, "Scheme chart not created", this.getTitle(), 2);
            return;
        }
        FrameSamples.printChart(chart, this, this.sbdb, this.parent.isDemoLicense());
    }

    private void jCheckBoxMenuItemPickCodeActionPerformed(ActionEvent evt) {
        Taxon.includeAlphaInString = this.jCheckBoxMenuItemPickCode.isSelected();
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"TAXONALPHA", (int)(Taxon.includeAlphaInString ? 1 : 0));
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (JPanelPicklist list : this.picklists) {
            list.repaintList();
        }
    }

    private void jMenuItemNumericCodeActionPerformed(ActionEvent evt) {
        if (this.dialogTaxonCodeInput == null) {
            this.dialogTaxonCodeInput = new DialogTaxonCodeInput(this, false, this.sbdb);
            this.dialogTaxonCodeInput.setLocationRelativeTo(this.jTabbedPaneSchemes);
            this.dialogTaxonCodeInput.setVisible(true);
        } else if (!this.dialogTaxonCodeInput.isVisible()) {
            this.dialogTaxonCodeInput.setVisible(true);
        }
    }

    private void jMenuItemPicklistNewActionPerformed(ActionEvent evt) {
        if (this.picklists.size() == 10) {
            JOptionPane.showMessageDialog(this, "You cannot open any more picklists.", this.getTitle(), 2);
            return;
        }
        String picklistName = null;
        do {
            String input;
            if ((input = JOptionPane.showInputDialog(this, "Enter picklist title: ", "New picklist", 1)) == null) {
                return;
            }
            if (input.isEmpty()) continue;
            if (input.length() > 25) {
                input = input.substring(0, 24);
            }
            boolean found = false;
            for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
                if (!input.equals(this.jTabbedPaneSchemes.getTitleAt(i))) continue;
                JOptionPane.showMessageDialog(this, "That title is in use.", "New picklist", 2);
                found = true;
            }
            if (found) continue;
            picklistName = input;
        } while (picklistName == null);
        this.addPicklist(picklistName, 0);
    }

    private void jMenuItemPicklistRemoveActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist();
        if (picklist == null) {
            JOptionPane.showMessageDialog(this, "Select a picklist", "Remove picklist", 2);
            return;
        }
        if (this.picklists.size() == 1) {
            JOptionPane.showMessageDialog(this, "You cannot remove the last picklist", "Remove picklist", 2);
            return;
        }
        this.jTabbedPaneSchemes.remove(picklist);
        this.picklists.remove(picklist);
    }

    private void jMenuItemPicklistEditActionPerformed(ActionEvent evt) {
        JPanelPicklist picklist = this.getSelectedPicklist();
        if (picklist == null) {
            JOptionPane.showMessageDialog(this, "Select a picklist", "Edit picklist", 2);
            return;
        }
        String picklistName = null;
        do {
            String input;
            if ((input = JOptionPane.showInputDialog(this, "Enter new picklist title: ", "Edit title", 1)) == null) {
                return;
            }
            if (input.isEmpty()) continue;
            if (input.length() > 25) {
                input = input.substring(0, 24);
            }
            boolean found = false;
            for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
                if (!input.equals(this.jTabbedPaneSchemes.getTitleAt(i))) continue;
                JOptionPane.showMessageDialog(this, "That title is in use.", "Edit title", 2);
                found = true;
            }
            if (found) continue;
            picklistName = input;
        } while (picklistName == null);
        int index = 0;
        for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
            if (this.jTabbedPaneSchemes.getComponentAt(i) != picklist) continue;
            index = i;
            break;
        }
        this.jTabbedPaneSchemes.setTitleAt(index, picklistName);
    }

    private void jMenuItemTableDefaultsActionPerformed(ActionEvent evt) {
        LinkedList<TablePair> tablePairs = this.getWellPanel().getTablePair(this.getWellPanel().getSelectedTable());
        for (TablePair pair : tablePairs) {
            pair.model.setDefaultColumnWidths();
            pair.model.setupColumns(pair.table);
        }
    }

    private void jMenuItemOverlayWebActionPerformed(ActionEvent evt) {
        this.getWellPanel().openOverlayBrowser();
    }

    private void jMenuItemExportHTMLActionPerformed(ActionEvent evt) {
        this.getWellPanel().exportChartHTML();
    }

    private void jCheckBoxMenuItemOccSoundActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"OCCSOUND", (int)(this.jCheckBoxMenuItemOccSound.isSelected() ? 1 : 0));
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jMenuItemSaveAsProjectActionPerformed(ActionEvent evt) {
        block16: {
            try {
                DialogSelectProject dialog = new DialogSelectProject((Frame)this, true, this.sbdb, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) break block16;
                Project project = dialog.selection;
                project.loadWells(this.sbdb, null);
                LinkedList<Well> wells = new LinkedList<Well>();
                for (JPanelWell jPanelWell : this.getWellPanels()) {
                    wells.add(jPanelWell.well);
                }
                if (project.getSize() > 0) {
                    boolean exactMatch = false;
                    if (project.getSize() == wells.size()) {
                        Well well;
                        Iterator i$ = wells.iterator();
                        while (i$.hasNext() && project.contains(well = (Well)i$.next())) {
                        }
                        exactMatch = true;
                    }
                    if (exactMatch) {
                        JOptionPane.showMessageDialog(this, "The project's wells list is the same as the open wells", this.getTitle(), 1);
                        return;
                    }
                    LinkedList<Well> projectWells = new LinkedList<Well>();
                    Iterator wellIterator = project.getWellIterator();
                    while (wellIterator.hasNext()) {
                        Well well = (Well)wellIterator.next();
                        if (wells.contains(well)) continue;
                        projectWells.add(well);
                    }
                    if (!projectWells.isEmpty()) {
                        String msg = "Project '" + project.getName() + "' also contains wells: ";
                        for (Well w : projectWells) {
                            msg = msg + "\n" + w;
                        }
                        int opt = JOptionPane.showConfirmDialog(this, msg = msg + "\n\nDo you want to remove these wells from the project?", this.getTitle(), 1);
                        if (opt == 2 || opt == -1) {
                            return;
                        }
                        if (opt == 0) {
                            try {
                                for (Well w : projectWells) {
                                    project.remove(this.sbdb, w);
                                }
                                this.sbdb.commit();
                            }
                            catch (SQLException sql) {
                                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                                return;
                            }
                        }
                    }
                }
                project.addWells(this.sbdb, wells);
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
        }
    }

    private void jRadioButtonMenuItemContinuousClickActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"MULTICLICK", (int)1);
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error", ex, this.sbdb);
        }
    }

    private void jRadioButtonMenuItemDoubleClickActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"MULTICLICK", (int)0);
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error", ex, this.sbdb);
        }
    }

    private void jCheckBoxMenuItemExcludeRwCvTotalsActionPerformed(ActionEvent evt) {
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"TOTEXRWCV", (int)(this.jCheckBoxMenuItemExcludeRwCvTotals.isSelected() ? 1 : 0));
            this.sbdb.commit();
            for (JPanelWell wellPanel : this.getWellPanels()) {
                wellPanel.setNTaxaText();
                wellPanel.updateTotals();
            }
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error", ex, this.sbdb);
        }
    }

    boolean getTotExRwCv() {
        return this.jCheckBoxMenuItemExcludeRwCvTotals.isSelected();
    }

    private void addPicklist(String tabTitle, int groupID) {
        if (tabTitle == null) {
            tabTitle = "Picklist";
        }
        JPanelPicklist picklist = new JPanelPicklist(this, this.sbdb);
        picklist.setControls(this.isCMF(), this.isNumeric());
        if (groupID > 0) {
            try {
                TxGroup group = this.sbdb.getTxGroup(groupID);
                picklist.setTaxa(this.sbdb.getTxGroupTaxa(group));
                picklist.setGroup(group);
            }
            catch (Exception e) {
                SB.showStackError((String)"Error setting group for picklist", (Exception)e);
            }
        }
        this.jTabbedPaneSchemes.addTab(tabTitle, new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_PicklistTab.png")), picklist);
        this.jTabbedPaneSchemes.setSelectedComponent(picklist);
        this.picklists.add(picklist);
    }

    private void setWellTabTitles(boolean toName) {
        if (toName == JPanelWell.tabIsName) {
            return;
        }
        JPanelWell.tabIsName = toName;
        for (int i = 0; i < this.jTabbedPaneWell.getComponentCount(); ++i) {
            Component c = this.jTabbedPaneWell.getComponentAt(i);
            JPanelWell wellPanel = (JPanelWell)c;
            this.jTabbedPaneWell.setTitleAt(i, wellPanel.getTabTitle());
        }
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"TABTITLES", (int)(toName ? 0 : 1));
            this.sbdb.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void printChart(Chart chart, Frame parent, SBdb db, boolean demoLicense) {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!job.printDialog()) {
            return;
        }
        ChartJPanel printPanel = new ChartJPanel(chart, printFormat != null ? printFormat : job.defaultPage(), db.decodeChartPrintPrefs());
        if (demoLicense) {
            printPanel.watermark = true;
        }
        DialogPrintPreviewChart dialog = new DialogPrintPreviewChart(parent, true, printPanel, job, db);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        job.setPrintable(printPanel, printPanel.getPf());
        try {
            job.print();
        }
        catch (Exception exp) {
            SB.showStackError((String)"Problem printing", (Exception)exp);
        }
        printFormat = printPanel.getPf();
    }

    void setLogging(boolean logging) {
        for (JPanelWell wellPanel : this.getWellPanels()) {
            wellPanel.tableModelOcc.setLogging(logging, wellPanel.getOccTable());
            wellPanel.tableModelOcc.fireTableDataChanged();
            wellPanel.tableSorterOcc.sort((Object)this);
        }
    }

    private void decodeLogSheetPrefs(List<LoggingSheet> logSheets) {
        System.out.println("Decoding Logging sheet properties...");
        try {
            String token;
            int token2;
            String params = Lastval.getString((SBdb)this.sbdb, (String)"LOGSHTPREF");
            if (params.isEmpty()) {
                System.out.println("No LoggingSheet parameters to decode");
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            boolean wellCode = false;
            boolean images = false;
            boolean comments = true;
            boolean italics = true;
            boolean smallFont = true;
            boolean useCodes = false;
            boolean bsComments = false;
            boolean semiQuant = false;
            boolean specType = true;
            int sort = 3;
            if (tok.hasMoreTokens()) {
                token2 = Integer.parseInt(tok.nextToken());
                boolean bl = useCodes = token2 == 1;
            }
            if (tok.hasMoreTokens()) {
                token2 = Integer.parseInt(tok.nextToken());
                boolean bl = smallFont = token2 == 1;
            }
            if (tok.hasMoreTokens()) {
                token2 = Integer.parseInt(tok.nextToken());
                boolean bl = comments = token2 == 1;
            }
            if (tok.hasMoreTokens()) {
                token2 = Integer.parseInt(tok.nextToken());
                boolean bl = images = token2 == 1;
            }
            if (tok.hasMoreTokens()) {
                token2 = Integer.parseInt(tok.nextToken());
                boolean bl = wellCode = token2 == 1;
            }
            if (tok.hasMoreTokens()) {
                token2 = Integer.parseInt(tok.nextToken());
                boolean bl = italics = token2 == 1;
            }
            if (tok.hasMoreTokens()) {
                sort = token2 = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                token2 = Integer.parseInt(tok.nextToken());
                boolean bl = bsComments = token2 == 1;
            }
            if (tok.hasMoreTokens() && (token = tok.nextToken()) != null && !token.equals("null")) {
                int t = Integer.parseInt(token);
                boolean bl = semiQuant = t == 1;
            }
            if (tok.hasMoreTokens()) {
                int token3 = Integer.parseInt(tok.nextToken());
                specType = token3 == 1;
            }
            for (LoggingSheet logSheet : logSheets) {
                logSheet.setProperties(wellCode, comments, images, italics, smallFont, useCodes, sort, bsComments, semiQuant, specType);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.getMessage(), this.parent.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void decodeImgGalleryPrefs(ImageGallery gallery) {
        System.out.println("Decoding Image Gallery properties...");
        try {
            int token;
            String params = Lastval.getString((SBdb)this.sbdb, (String)"IMGGALPREF");
            if (params.isEmpty()) {
                System.out.println("No Image Gallery parameters to decode");
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            char size = 'M';
            boolean wholeSet = false;
            boolean occComments = false;
            boolean suite = true;
            boolean cat = false;
            if (tok.hasMoreTokens()) {
                size = tok.nextToken().charAt(0);
            }
            if (tok.hasMoreTokens()) {
                token = Integer.parseInt(tok.nextToken());
                boolean bl = wholeSet = token == 1;
            }
            if (tok.hasMoreTokens()) {
                token = Integer.parseInt(tok.nextToken());
                boolean bl = occComments = token == 1;
            }
            if (tok.hasMoreTokens()) {
                token = Integer.parseInt(tok.nextToken());
                boolean bl = suite = token == 1;
            }
            if (tok.hasMoreTokens()) {
                token = Integer.parseInt(tok.nextToken());
                cat = token == 1;
            }
            gallery.setProperties(size, wholeSet, occComments, suite, cat);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.getMessage(), this.parent.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void encodeSession() {
        String pLists = "";
        for (int i = 0; i < this.jTabbedPaneSchemes.getComponentCount(); ++i) {
            Component c = this.jTabbedPaneSchemes.getComponent(i);
            if (!(c instanceof JPanelPicklist)) continue;
            JPanelPicklist picklist = (JPanelPicklist)c;
            pLists = pLists + this.jTabbedPaneSchemes.getTitleAt(i) + " " + (!picklist.isUnsaved() ? picklist.getGroupID() : 0) + ",";
        }
        String schemes = "";
        SchemeBlock block = this.schemeChartJPanel.chart.getSchemeBlock();
        if (block != null) {
            schemes = block.getPanelsString();
        }
        if (schemes.isEmpty()) {
            schemes = ",";
        }
        String wells = "";
        for (JPanelWell wellPanel : this.getWellPanels()) {
            wells = wells + wellPanel.getWell().getWellID() + ",";
        }
        String gui = "";
        if (this.getExtendedState() == 6) {
            gui = gui + 1;
        } else {
            Dimension size = this.getSize();
            gui = gui + size.width + " " + size.height;
        }
        gui = gui + "," + SB.round((double)(((double)this.jSplitPane1.getDividerLocation() + (double)this.jSplitPane1.getDividerSize()) / (double)this.jSplitPane1.getWidth()), (int)3);
        String params = pLists + "|" + schemes + "|" + wells + "|" + gui;
        try {
            Lastval.putString((SBdb)this.sbdb, (String)"SMPSESSION", (String)params);
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }

    private boolean restoreSession() {
        try {
            String params = Lastval.getString((SBdb)this.sbdb, (String)"SMPSESSION");
            if (params.isEmpty()) {
                return false;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                String pLists = tok.nextToken();
                StringTokenizer pListsTok = new StringTokenizer(pLists, ",");
                while (pListsTok.hasMoreTokens()) {
                    StringTokenizer listTok = new StringTokenizer(pListsTok.nextToken());
                    String title = "Picklist";
                    int groupID = 0;
                    if (listTok.hasMoreTokens()) {
                        title = listTok.nextToken();
                    }
                    if (listTok.hasMoreTokens()) {
                        try {
                            groupID = Integer.parseInt(listTok.nextToken());
                        }
                        catch (NumberFormatException nfe) {
                            nfe.printStackTrace();
                        }
                    }
                    this.addPicklist(title, groupID);
                }
            }
            if (tok.hasMoreTokens()) {
                String schemeString = tok.nextToken();
                StringTokenizer schemesTok = new StringTokenizer(schemeString, ",");
                SchemeBlock block = this.schemeChartJPanel.chart.getAddSchemeBlock();
                while (schemesTok.hasMoreTokens()) {
                    block.addTokPanel(schemesTok.nextToken(), this.sbdb);
                }
                this.setSchemeChartMargin();
                this.schemeChartJPanel.chart.calcChartSize();
                this.setSchemeScrollPaneSize();
            }
            if (tok.hasMoreTokens()) {
                String wells = tok.nextToken();
                StringTokenizer wellsTok = new StringTokenizer(wells, ",");
                while (wellsTok.hasMoreTokens()) {
                    Well well = this.sbdb.getAddWell(Integer.parseInt(wellsTok.nextToken()));
                    this.insertTab(new JPanelWell(this, this.sbdb, well));
                }
            }
            if (tok.hasMoreTokens()) {
                StringTokenizer GUITok = new StringTokenizer(tok.nextToken(), ",");
                if (GUITok.hasMoreTokens()) {
                    String size = GUITok.nextToken();
                    if (size.equals("1")) {
                        this.setExtendedState(6);
                    } else {
                        StringTokenizer sizeTok = new StringTokenizer(size);
                        int width = Integer.parseInt(sizeTok.nextToken());
                        int height = Integer.parseInt(sizeTok.nextToken());
                        this.setSize(width, height);
                    }
                }
                if (GUITok.hasMoreTokens()) {
                    final double dividerLocation = Double.parseDouble(GUITok.nextToken());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FrameSamples.this.jSplitPane1.setDividerLocation(dividerLocation);
                            FrameSamples.this.jSplitPane1.revalidate();
                        }
                    });
                }
            }
            return true;
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this.parent, "Error restoring session:\n" + sbe.getMessage(), this.parent.getTitle(), 0);
            sbe.printStackTrace();
            return false;
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent, "Error restoring session:\n" + ex.getMessage(), this.parent.getTitle(), 0);
            ex.printStackTrace();
            return false;
        }
    }

    boolean playOccSounds() {
        return this.jCheckBoxMenuItemOccSound.isSelected();
    }

    void playOccSound() {
        try {
            if (this.soundClip == null) {
                this.audioStream = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream("/jsbugs/wav/Swat.wav"));
                this.soundClip = AudioSystem.getClip();
                this.soundClip.open(this.audioStream);
            }
            this.soundClip.setFramePosition(1);
            this.soundClip.loop(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setSchemeChartVersion(WellInterp wellInterp) {
        if (this.schemeChartJPanel != null && this.schemeChartJPanel.chart != null) {
            SchemeBlock block = this.schemeChartJPanel.chart.getSchemeBlock();
            if (block != null && wellInterp != null) {
                block.setWellInterp(wellInterp);
                wellInterp.addObserver((Observer)this.schemeChartJPanel);
            }
            this.schemeChartJPanel.repaint();
        }
    }

    void setTabVersion(JPanelWell sender, InterpHdr header) throws SQLException, SBException {
        for (Component c : this.jTabbedPaneWell.getComponents()) {
            if (c == sender) continue;
            ((JPanelWell)c).setVersion(header);
        }
    }

    JFrame getParentFrame(JPanelCharts jPanelCharts) {
        for (FrameWellChartsDetached frameChart : this.chartsFrames) {
            if (frameChart.getPanel() != jPanelCharts) continue;
            return frameChart;
        }
        for (FrameWellDetached frameWell : this.wellFrames) {
            if (frameWell.getPanel() != jPanelCharts.parentPanel) continue;
            return frameWell;
        }
        return this;
    }

    void showLithPalette(JPanelCharts origin) {
        if (this.lithPalette == null) {
            try {
                this.lithPalette = new DialogLithPalette((Frame)this, false, this.sbdb);
                this.lithPalette.setLocationRelativeTo(origin);
                this.lithPalette.setVisible(true);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQL Error", (SQLException)sql);
            }
        } else {
            this.lithPalette.setLocationRelativeTo(origin);
            this.lithPalette.setVisible(true);
        }
    }

    DialogLithPalette getLithPalette() {
        if (this.lithPalette != null && this.lithPalette.isVisible()) {
            return this.lithPalette;
        }
        return null;
    }

    private class SbugsLineListener
    implements LineListener {
        private SbugsLineListener() {
        }

        @Override
        public void update(LineEvent event) {
            if (event.getType() == LineEvent.Type.START) {
                while (FrameSamples.this.soundClip.isRunning()) {
                }
                FrameSamples.this.soundClip.loop(0);
            }
        }
    }
}

