/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import jsbugs.DialogCasing;
import jsbugs.DialogCores;
import jsbugs.DialogCreateDatabase;
import jsbugs.DialogCurves;
import jsbugs.DialogIntLith;
import jsbugs.DialogMarkers;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectWell;
import jsbugs.DialogTVD;
import jsbugs.DialogTWT;
import jsbugs.DialogWell;
import jsbugs.FrameJsbugs;
import jsbugs.FrameProjectLocation;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WellHeader;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class FrameWells
extends JFrame
implements Observer {
    boolean wellsMatched = false;
    boolean taxaTranslated = false;
    SBdb sbdb;
    SB SB;
    FrameJsbugs parent;
    DefaultListModel listModelWells = new DefaultListModel();
    DefaultComboBoxModel comboBoxModelProjects = new DefaultComboBoxModel();
    List<DialogCores> coreDialogs = new LinkedList<DialogCores>();
    List<DialogCasing> casingDialogs = new LinkedList<DialogCasing>();
    List<DialogMarkers> markersDialogs = new LinkedList<DialogMarkers>();
    List<DialogTVD> tvdDialogs = new LinkedList<DialogTVD>();
    List<DialogTWT> twtDialogs = new LinkedList<DialogTWT>();
    List<DialogIntLith> lithologyDialogs = new LinkedList<DialogIntLith>();
    List<DialogCurves> curvesDialogs = new LinkedList<DialogCurves>();
    DialogSelectProject dialogProjects = null;
    List<Image> imageList = new LinkedList<Image>();
    FrameProjectLocation frameProjectLocation = null;
    private JButton jButton2;
    private JButton jButtonAdd;
    private JButton jButtonCasing;
    private JButton jButtonClose;
    private JButton jButtonCores;
    private JButton jButtonCreateDatabase;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonLithology;
    private JButton jButtonMap;
    private JButton jButtonMarkers;
    private JButton jButtonProjectLocation;
    private JButton jButtonProjects;
    private JButton jButtonRemove;
    private JButton jButtonSamples;
    private JButton jButtonSelect;
    private JButton jButtonTVD;
    private JButton jButtonTWT;
    private JButton jButtonWireline;
    private JComboBox jComboBoxProject;
    private JLabel jLabel1;
    private JList jListWells;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;

    public FrameWells(FrameJsbugs parent, SBdb sbdb) throws SQLException, SBException {
        this.sbdb = sbdb;
        this.parent = parent;
        this.initComponents();
        this.init();
        this.setTitle("Wells & Outcrops - StrataBugs");
    }

    final void init() throws SQLException, SBException {
        this.createImageList();
        this.setIconImages(this.imageList);
        this.loadList();
        this.jListWells.setModel(this.listModelWells);
        this.jListWells.repaint();
        this.loadProjects();
        this.jComboBoxProject.setModel(this.comboBoxModelProjects);
        this.jComboBoxProject.repaint();
    }

    private void createImageList() {
        String[] pngs = new String[]{"48Wells.png", "32Wells.png", "24Wells.png", "16Wells.png"};
        for (int i = 0; i < pngs.length; ++i) {
            Image img = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/FrameIcon_Wells/" + pngs[i]));
            this.imageList.add(img);
        }
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs.getClass() == Project.class) {
                if (obs == this.jComboBoxProject.getSelectedItem()) {
                    if (((Project)obs).getID() == 0) {
                        System.out.println("Project ID is 0");
                    } else {
                        this.loadList();
                    }
                    this.jListWells.repaint();
                }
            } else if (obs == this.sbdb.getProjects()) {
                Object selection = this.jComboBoxProject.getSelectedItem();
                this.comboBoxModelProjects.removeAllElements();
                this.sbdb.getProjects().loadCombo(this.comboBoxModelProjects, true);
                this.jComboBoxProject.setSelectedItem(selection);
            } else if (obs instanceof Well && obj instanceof WellHeader) {
                this.loadList();
                this.jListWells.repaint();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            util.SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    void loadList() throws SQLException, SBException {
        this.listModelWells.clear();
        Project project = (Project)this.jComboBoxProject.getSelectedItem();
        if (project != null && project.getID() > 0) {
            project.addObserver((Observer)this);
            Iterator it = project.getWellIterator();
            while (it.hasNext()) {
                Well w = (Well)it.next();
                this.listModelWells.addElement(w);
                w.addObserver((Observer)this);
            }
            if (this.listModelWells.getSize() == 1) {
                this.jListWells.setSelectedIndex(0);
            }
        }
    }

    private void loadList(List<Well> selection) {
        this.listModelWells.clear();
        for (Well well : selection) {
            this.listModelWells.addElement(well);
            well.addObserver((Observer)this);
        }
        if (this.listModelWells.getSize() == 1) {
            this.jListWells.setSelectedIndex(0);
        }
    }

    void loadProjects() throws SQLException, SBException {
        this.comboBoxModelProjects.removeAllElements();
        this.sbdb.getProjects().loadCombo(this.comboBoxModelProjects, true);
        Project def = this.sbdb.getProject(0);
        def.addObserver((Observer)this);
        this.sbdb.getProjects().addObserver((Observer)this);
        this.comboBoxModelProjects.setSelectedItem(def);
    }

    private boolean checkSelection() {
        if (this.jListWells.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select well/outcrop(s)", this.getTitle(), 2);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListWells = new JList();
        this.jComboBoxProject = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jButtonProjects = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jButtonMarkers = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonMap = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSelect = new JButton();
        this.jButtonTVD = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonCores = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonSamples = new JButton();
        this.jButtonTWT = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCasing = new JButton();
        this.jButtonLithology = new JButton();
        this.jButtonWireline = new JButton();
        this.jButtonProjectLocation = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jButtonCreateDatabase = new JButton();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 630));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrameWells.this.formWindowClosing(evt);
            }
        });
        this.jListWells.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListWells.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrameWells.this.jListWellsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWells);
        this.jComboBoxProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jComboBoxProjectActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Project :");
        this.jButtonProjects.setText("...");
        this.jButtonProjects.setToolTipText("Open project selector");
        this.jButtonProjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonProjectsActionPerformed(evt);
            }
        });
        this.jButtonMarkers.setText("Markers...");
        this.jButtonMarkers.setToolTipText("Edit seismic markers for selected well");
        this.jButtonMarkers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonMarkersActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help...");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonMap.setText("Map...");
        this.jButtonMap.setToolTipText("Export well/outcrop positions to map file");
        this.jButtonMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonMapActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit..");
        this.jButtonEdit.setToolTipText("Edit selected well/outcrop");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setToolTipText("Add a new well or outcrop to database");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSelect.setText("Select...");
        this.jButtonSelect.setToolTipText("Select well/outcrop");
        this.jButtonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonSelectActionPerformed(evt);
            }
        });
        this.jButtonTVD.setText("Dev.Surv...");
        this.jButtonTVD.setToolTipText("Edit deviation surveys for selected well");
        this.jButtonTVD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonTVDActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.setToolTipText("Remove selected well/outcrop(s) from project");
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonCores.setText("Cores...");
        this.jButtonCores.setToolTipText("Edit cored intervals for selected well");
        this.jButtonCores.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonCoresActionPerformed(evt);
            }
        });
        this.jButtonSamples.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameIcon_Samples/16Samples.png")));
        this.jButtonSamples.setText("Samples...");
        this.jButtonSamples.setToolTipText("Open selected well in Samples module");
        this.jButtonSamples.setIconTextGap(3);
        this.jButtonSamples.setMargin(new Insets(2, 7, 2, 7));
        this.jButtonSamples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonSamplesActionPerformed(evt);
            }
        });
        this.jButtonTWT.setText("TWT...");
        this.jButtonTWT.setToolTipText("Edit two way times for selected well");
        this.jButtonTWT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonTWTActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected well/outcrop");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCasing.setText("Casing...");
        this.jButtonCasing.setToolTipText("Edit casing points for selected well");
        this.jButtonCasing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonCasingActionPerformed(evt);
            }
        });
        this.jButtonLithology.setText("Lithology...");
        this.jButtonLithology.setToolTipText("Edit interval lithology for selected well");
        this.jButtonLithology.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonLithologyActionPerformed(evt);
            }
        });
        this.jButtonWireline.setText("Wirelines...");
        this.jButtonWireline.setToolTipText("Edit wireline log data for selected well");
        this.jButtonWireline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonWirelineActionPerformed(evt);
            }
        });
        this.jButtonProjectLocation.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameIcon_Map/16Map.png")));
        this.jButtonProjectLocation.setText("Project Map");
        this.jButtonProjectLocation.setToolTipText("<html>Plot a plan view of this project<br>\n(requires deviation surveys)</html>");
        this.jButtonProjectLocation.setIconTextGap(2);
        this.jButtonProjectLocation.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonProjectLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonProjectLocationActionPerformed(evt);
            }
        });
        this.jButtonCreateDatabase.setText("Create DB...");
        this.jButtonCreateDatabase.setToolTipText("New sub-set database from selected wells");
        this.jButtonCreateDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameWells.this.jButtonCreateDatabaseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxProject, 0, 201, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonProjects, -2, 29, -2)).add((Component)this.jScrollPane1, -1, 281, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonHelp, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonProjectLocation, -1, 93, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, 89, Short.MAX_VALUE).add((Component)this.jSeparator4, -1, 93, Short.MAX_VALUE).add((Component)this.jButtonMarkers, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonLithology, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonWireline, -1, 89, Short.MAX_VALUE).add((Component)this.jSeparator3, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonCreateDatabase).add((Component)this.jButtonEdit, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonMap, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonClose, -2, 89, -2).add((Component)this.jButtonSelect, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonTVD, 0, 0, Short.MAX_VALUE).add((Component)this.jButtonRemove, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonCores, -1, 89, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonSamples, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonTWT, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonCasing, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 89, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCasing, this.jButtonClose, this.jButtonCores, this.jButtonCreateDatabase, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonLithology, this.jButtonMap, this.jButtonMarkers, this.jButtonProjectLocation, this.jButtonRemove, this.jButtonSamples, this.jButtonSelect, this.jButtonTVD, this.jButtonTWT, this.jButtonWireline, this.jSeparator1, this.jSeparator2, this.jSeparator3, this.jSeparator4}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jButtonProjects)).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSelect).addPreferredGap(0).add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonRemove).addPreferredGap(0).add((Component)this.jSeparator1, -2, 12, -2).addPreferredGap(0).add((Component)this.jButtonCores).addPreferredGap(0).add((Component)this.jButtonCasing).addPreferredGap(0).add((Component)this.jButtonTVD).addPreferredGap(0).add((Component)this.jButtonTWT).addPreferredGap(0).add((Component)this.jButtonMarkers).addPreferredGap(0).add((Component)this.jButtonLithology).addPreferredGap(0).add((Component)this.jButtonWireline).add(3, 3, 3).add((Component)this.jSeparator3, -2, 9, -2).add(1, 1, 1).add((Component)this.jButtonSamples).addPreferredGap(0).add((Component)this.jSeparator2, -2, 6, -2).add(1, 1, 1).add((Component)this.jButtonProjectLocation).addPreferredGap(0).add((Component)this.jButtonMap).addPreferredGap(0).add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonCreateDatabase).addPreferredGap(0, 50, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 612, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCasing, this.jButtonCores, this.jButtonLithology, this.jButtonMarkers, this.jButtonTVD, this.jButtonTWT, this.jButtonWireline}, 2);
        this.pack();
    }

    private void jButtonProjectsActionPerformed(ActionEvent evt) {
        try {
            if (this.dialogProjects == null) {
                this.dialogProjects = new DialogSelectProject((Frame)this, true, this.sbdb, true);
            }
            Point p = this.getLocation();
            this.dialogProjects.setLocation(p.x + 25, p.y + 25);
            this.dialogProjects.setVisible(true);
            this.sbdb.getProjects().notifyObservers();
            if (this.dialogProjects.selection != null) {
                this.jComboBoxProject.setSelectedItem(this.dialogProjects.selection);
                this.parent.setProject(this.dialogProjects.selection);
            }
            this.dialogProjects = null;
        }
        catch (SBException sbe) {
            util.SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonSamplesActionPerformed(ActionEvent evt) {
        if (!this.checkSelection()) {
            return;
        }
        Object p = null;
        for (Object obj : this.jListWells.getSelectedValues()) {
            Well well = (Well)obj;
            try {
                this.parent.addSamplesWell(well, true);
            }
            catch (SBException sbe) {
                util.SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonMarkersActionPerformed(ActionEvent evt) {
        if (!this.checkSelection()) {
            return;
        }
        int x = this.getLocation().x + 130;
        int y = this.getLocation().y;
        for (Object obj : this.jListWells.getSelectedValues()) {
            Well well = (Well)obj;
            boolean createDialog = true;
            for (DialogMarkers d : this.markersDialogs) {
                if (d.getWell() != well) continue;
                createDialog = false;
                d.setVisible(true);
                break;
            }
            if (!createDialog) continue;
            try {
                DialogMarkers dialogMarkers = new DialogMarkers((Frame)this, false, well);
                dialogMarkers.setLocation(x += 25, y += 25);
                dialogMarkers.setVisible(true);
                this.markersDialogs.add(dialogMarkers);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonTWTActionPerformed(ActionEvent evt) {
        if (this.jListWells.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select well", this.getTitle(), 2);
            return;
        }
        if (this.jListWells.getSelectedValues().length > 1) {
            JOptionPane.showMessageDialog(this, "Select one well only", this.getTitle(), 2);
            return;
        }
        Well well = (Well)this.jListWells.getSelectedValue();
        try {
            DialogTWT dialog = new DialogTWT((Frame)this, true, well, well.getWellUnits());
            util.SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonTVDActionPerformed(ActionEvent evt) {
        if (this.jListWells.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select well", this.getTitle(), 2);
            return;
        }
        if (this.jListWells.getSelectedValues().length > 1) {
            JOptionPane.showMessageDialog(this, "Select one well only", this.getTitle(), 2);
            return;
        }
        Well well = (Well)this.jListWells.getSelectedValue();
        try {
            DialogTVD dialog = new DialogTVD((Frame)this, true, well, well.getWellUnits());
            util.SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonCasingActionPerformed(ActionEvent evt) {
        if (!this.checkSelection()) {
            return;
        }
        int x = this.getLocation().x + 130;
        int y = this.getLocation().y;
        for (Object obj : this.jListWells.getSelectedValues()) {
            Well well = (Well)obj;
            boolean createDialog = true;
            try {
                for (DialogCasing d : this.casingDialogs) {
                    if (d.getWell() != well) continue;
                    createDialog = false;
                    well.getCasing(true);
                    d.setObserver();
                    d.setVisible(true);
                    break;
                }
                if (!createDialog) continue;
                DialogCasing dialogCasing = new DialogCasing((Frame)this, false, well);
                dialogCasing.setLocation(x += 25, y += 25);
                dialogCasing.setVisible(true);
                this.casingDialogs.add(dialogCasing);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonCoresActionPerformed(ActionEvent evt) {
        if (!this.checkSelection()) {
            return;
        }
        for (Object obj : this.jListWells.getSelectedValues()) {
            Well well = (Well)obj;
            boolean createDialog = true;
            for (DialogCores d : this.coreDialogs) {
                if (d.getWell() != well) continue;
                createDialog = false;
                d.setVisible(true);
                break;
            }
            if (!createDialog) continue;
            try {
                DialogCores dialogCores = new DialogCores((Frame)this, false, well);
                dialogCores.setLocationRelativeTo(this);
                dialogCores.setVisible(true);
                this.coreDialogs.add(dialogCores);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 0);
                System.out.println("Exception in dialog creation: " + e);
                e.printStackTrace();
            }
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        try {
            if (this.jComboBoxProject.getSelectedIndex() > 0) {
                if (this.jListWells.getSelectedValue() == null) {
                    JOptionPane.showMessageDialog(this, "Select well/outcrop(s) to remove from project", this.getTitle(), 2);
                    return;
                }
                Project project = (Project)this.jComboBoxProject.getSelectedItem();
                for (Object obj : this.jListWells.getSelectedValues()) {
                    Well well = (Well)obj;
                    project.remove(this.sbdb, well);
                }
                this.sbdb.commit();
            } else {
                JOptionPane.showMessageDialog(this, "No project selected. (default list refreshed when StrataBugs restarted)", this.getTitle(), 1);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jListWellsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonSamplesActionPerformed(null);
        }
    }

    private void jComboBoxProjectActionPerformed(ActionEvent evt) {
        try {
            Project project = (Project)this.jComboBoxProject.getSelectedItem();
            if (project != null) {
                project.loadWells(this.sbdb, null);
                this.loadList();
                this.parent.setProject(project);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            util.SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        if (!this.parent.checkRLMlicence()) {
            JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.jButtonCloseActionPerformed(evt);
            return;
        }
        DialogSelectWell dialog = new DialogSelectWell((Frame)this, true, this.sbdb, true);
        dialog.setVisible(true);
        try {
            if (dialog.selection != null) {
                if (this.jComboBoxProject.getSelectedIndex() > 0) {
                    Project project = (Project)this.jComboBoxProject.getSelectedItem();
                    boolean ask = false;
                    for (Well well : dialog.selection) {
                        if (project.contains(well)) continue;
                        ask = true;
                        break;
                    }
                    if (ask) {
                        if (JOptionPane.showConfirmDialog(this, "Add selected wells to project?", this.getTitle(), 0, 3) == 0) {
                            project.addWells(this.sbdb, dialog.selection);
                            this.sbdb.commit();
                        } else {
                            this.jComboBoxProject.setSelectedIndex(0);
                            this.loadList(dialog.selection);
                        }
                    }
                } else {
                    this.loadList(dialog.selection);
                }
            }
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListWells.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select well/outcrop(s) to delete", this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Object obj : this.jListWells.getSelectedValues()) {
                Well well = (Well)obj;
                int opt = JOptionPane.showConfirmDialog(this, "Permanently delete well: " + well.getWellName() + "?", this.getTitle(), 1, 3);
                if (opt != 0) continue;
                if (this.parent.samplesFrame != null) {
                    this.parent.samplesFrame.removeWell(well);
                }
                try {
                    this.sbdb.deleteWell(well);
                    this.sbdb.commit();
                    this.listModelWells.removeElement(well);
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
                catch (SBException sbe) {
                    util.SB.showStackError((String)"Error", (Exception)((Object)sbe));
                }
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        Well well = (Well)this.jListWells.getSelectedValue();
        if (well == null) {
            JOptionPane.showMessageDialog(this, "Select a well to edit", this.getTitle(), 2);
            return;
        }
        try {
            DialogWell dialog = new DialogWell((Frame)this, true, this.sbdb, well);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        block8: {
            if (!this.parent.checkRLMlicence()) {
                JOptionPane.showMessageDialog(this, "StrataBugs licence no longer available.", "StrataBugs", 0);
                this.jButtonCloseActionPerformed(evt);
                return;
            }
            try {
                DialogWell dialog = new DialogWell((Frame)this, true, this.sbdb, null);
                dialog.setVisible(true);
                if (!dialog.isOK) break block8;
                if (this.jComboBoxProject.getSelectedIndex() > 0) {
                    if (JOptionPane.showConfirmDialog(this, "Add well to project?", this.getTitle(), 0, 3) == 0) {
                        Project project = (Project)this.jComboBoxProject.getSelectedItem();
                        try {
                            project.addWell(this.sbdb, dialog.well);
                            this.sbdb.commit();
                            project.notifyObservers();
                            if (project.getID() == 0) {
                                this.listModelWells.addElement(dialog.well);
                            }
                            break block8;
                        }
                        catch (SQLException sql) {
                            this.sbdb.doRollback();
                            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                        }
                        break block8;
                    }
                    this.jComboBoxProject.setSelectedIndex(0);
                    break block8;
                }
                this.listModelWells.addElement(dialog.well);
                this.jListWells.setSelectedValue(dialog.well, true);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonMapActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser1 = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("kml");
        filter.setDescription("KML files");
        jFileChooser1.setFileFilter((FileFilter)filter);
        jFileChooser1.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.sbdb, (String)"WINKMLFILE", (String)"UNXKMLFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser1.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (0 == jFileChooser1.showSaveDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String fileName = jFileChooser1.getSelectedFile().getName();
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim();
                String filePath = jFileChooser1.getSelectedFile().getPath();
                if (!fileType.toLowerCase().equals("kml")) {
                    filePath = filePath + ".kml";
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(filePath, false));
                String eol = "\r\n";
                out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + eol + "<kml xmlns=\"http://www.opengis.net/kml/2.2\">" + eol + "<Document>" + eol);
                Project project = (Project)this.jComboBoxProject.getSelectedItem();
                project.writeWellLocations(out, eol);
                out.write("</Document>" + eol + "</kml>" + eol);
                out.close();
                Lastval.putString((SBdb)this.sbdb, (String)"WINKMLFILE", (String)"UNXKMLFILE", (String)filePath);
                this.sbdb.commit();
                String geExe = "C:\\Program Files\\Google\\Google Earth\\client\\googleearth.exe";
                if (new File(geExe).exists()) {
                    Runtime.getRuntime().exec("\"" + geExe + "\" \"" + filePath + "\"");
                } else {
                    JOptionPane.showMessageDialog(this, "File created but Google Earth not found.\nAlternatively, you can import the file into Google Maps, after creating a new map.", this.getTitle(), 1);
                }
            }
            catch (Exception ex) {
                util.SB.showStackError((String)"Error during file write: ", (Exception)ex);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("framewells.html");
    }

    private void jButtonLithologyActionPerformed(ActionEvent evt) {
        if (!this.checkSelection()) {
            return;
        }
        int x = this.getLocation().x + 180;
        int y = this.getLocation().y;
        for (Object obj : this.jListWells.getSelectedValues()) {
            Well well = (Well)obj;
            boolean createDialog = true;
            try {
                for (DialogIntLith d : this.lithologyDialogs) {
                    if (d.getWell() != well) continue;
                    createDialog = false;
                    d.initList(true);
                    d.setVisible(true);
                    break;
                }
                if (!createDialog) continue;
                DialogIntLith dialog = new DialogIntLith((Frame)this, false, this.sbdb, well);
                dialog.setLocation(x += 25, y += 25);
                dialog.setVisible(true);
                this.lithologyDialogs.add(dialog);
            }
            catch (SBException sbe) {
                util.SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonWirelineActionPerformed(ActionEvent evt) {
        if (!this.checkSelection()) {
            return;
        }
        for (Object obj : this.jListWells.getSelectedValues()) {
            Well well = (Well)obj;
            boolean createDialog = true;
            try {
                for (DialogCurves d : this.curvesDialogs) {
                    if (d.getWell() != well) continue;
                    createDialog = false;
                    d.setVisible(true);
                    break;
                }
                if (!createDialog) continue;
                DialogCurves dialog = new DialogCurves((Frame)this, false, well);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                this.curvesDialogs.add(dialog);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
        }
    }

    private void jButtonProjectLocationActionPerformed(ActionEvent evt) {
        Project project = (Project)this.jComboBoxProject.getSelectedItem();
        if (this.jComboBoxProject.getSelectedIndex() < 1) {
            JOptionPane.showMessageDialog(this, "Select a project", this.getTitle(), 1);
            return;
        }
        try {
            boolean hastvd = false;
            Iterator it = project.getWellIterator();
            while (it.hasNext()) {
                Well well = (Well)it.next();
                if (well.getTVDlist(false) == null || well.getTVDlist(false).getList().isEmpty()) continue;
                hastvd = true;
                break;
            }
            if (!hastvd) {
                JOptionPane.showMessageDialog(this, "There are no deviation surveys in this project.", this.getTitle(), 1);
                return;
            }
            if (this.frameProjectLocation != null) {
                this.frameProjectLocation.setProject(project);
                this.frameProjectLocation.setTitle("Project Map : " + project.getName());
                this.frameProjectLocation.setVisible(true);
                this.frameProjectLocation.setExtendedState(0);
            } else {
                this.frameProjectLocation = new FrameProjectLocation(this.parent, this.sbdb, project);
                this.frameProjectLocation.setVisible(true);
                this.frameProjectLocation.setLocationRelativeTo(this);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonCreateDatabaseActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", this.getTitle(), 2);
            return;
        }
        Project project = (Project)this.jComboBoxProject.getSelectedItem();
        if (this.jComboBoxProject.getSelectedIndex() < 1) {
            JOptionPane.showMessageDialog(this, "Select a project", this.getTitle(), 1);
            return;
        }
        DialogCreateDatabase dialog = new DialogCreateDatabase((Frame)this, true, this.sbdb, project);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }
}

