/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import model2.TxGroup;
import util.SB;

class GroupsTableModel
extends AbstractTableModel {
    List<TxGroup> groups = new LinkedList<TxGroup>();
    static final int COL_NAME = 0;
    static final int COL_COLOUR = 1;
    static String[] columnTitles = new String[]{"Name", "Colour"};
    static int[] columnWidths = new int[]{100, 5};

    GroupsTableModel() {
    }

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        TxGroup group = this.groups.get(row);
        if (group == null) {
            return null;
        }
        switch (col) {
            case 0: {
                return group.getName();
            }
            case 1: {
                return group.getColour();
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return TxGroup.class;
            }
            case 1: {
                return Color.class;
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.groups.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        TxGroup group = this.groups.get(row);
        if (group == null) {
            return;
        }
        switch (col) {
            case 1: {
                try {
                    group.setColour((Color)obj);
                    group.getDatabase().commit();
                    break;
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error saving colour: " + e.getMessage() + "\n" + SB.sql, "Colour", 0);
                    e.printStackTrace();
                }
            }
        }
    }
}

