/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import model2.IGDColMap;
import model2.IGDIntervalZone;

class IGDColmapJPanel
extends JPanel {
    IGDColMap colmap;
    int igdType;
    static final int MARGIN = 20;
    static final int INNERMARGIN = 20;

    IGDColmapJPanel(IGDColMap colmap, int igdType) {
        this.colmap = colmap;
        this.igdType = igdType;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.colmap != null) {
            int i;
            Rectangle bounds = this.getBounds(null);
            Rectangle2D.Double backG = new Rectangle2D.Double(20.0, 20.0, ((RectangularShape)bounds).getWidth() - 20.0, ((RectangularShape)bounds).getHeight() - 20.0);
            g.setColor(Color.white);
            g.fillRect((int)backG.getX(), (int)backG.getY(), (int)backG.getWidth(), (int)backG.getHeight());
            Rectangle2D.Double frame = new Rectangle2D.Double(backG.getX() + 20.0, backG.getY() + 20.0, backG.getWidth() - 40.0, backG.getHeight() - 40.0);
            g.setColor(Color.gray);
            g.drawLine((int)frame.getX(), (int)frame.getY(), (int)(frame.getX() + frame.getWidth()), (int)frame.getY());
            g.drawLine((int)frame.getX(), (int)frame.getY(), (int)frame.getX(), (int)(frame.getY() + frame.getHeight()));
            g.drawLine((int)(frame.getX() + frame.getWidth()), (int)frame.getY(), (int)(frame.getX() + frame.getWidth()), (int)(frame.getY() + frame.getHeight()));
            double headerHeight = frame.getHeight() / 3.0;
            g.drawLine((int)frame.getX(), (int)(frame.getY() + headerHeight), (int)(frame.getX() + frame.getWidth()), (int)(frame.getY() + headerHeight));
            int nHier = IGDIntervalZone.getNHier((int)this.igdType, (boolean)true);
            double levelWidth = frame.getWidth() / (double)nHier;
            for (i = 0; i < nHier; ++i) {
                int x = (int)(frame.getX() + (double)i * levelWidth);
                g.drawLine(x, (int)(frame.getY() + headerHeight), x, (int)(frame.getY() + frame.getHeight()));
                String label = IGDIntervalZone.getHierName((int)this.igdType, (int)(i + 1), (boolean)true);
                int w = g.getFontMetrics().stringWidth(label);
                int h = g.getFontMetrics().getHeight();
                double yLabel = frame.getY() + 2.0 * headerHeight - (double)h / 2.0;
                double xLabel = (double)x + levelWidth / 2.0 - (double)w / 2.0;
                g.drawString(label, (int)xLabel, (int)yLabel);
            }
            g.setColor(Color.red);
            try {
                for (i = 0; i < this.colmap.getSize(); ++i) {
                    String label = this.colmap.getColTitle(i + 1);
                    int x1 = (int)(frame.getX() + (double)(this.colmap.getMinhier(i + 1) - 1) * levelWidth);
                    int x2 = (int)(frame.getX() + (double)this.colmap.getMaxhier(i + 1) * levelWidth);
                    g.drawLine(x1, (int)frame.getY(), x2, (int)frame.getY());
                    g.drawLine(x1, (int)frame.getY(), x1, (int)(frame.getY() + frame.getHeight()));
                    g.drawLine(x2, (int)frame.getY(), x2, (int)(frame.getY() + frame.getHeight()));
                    int w = g.getFontMetrics().stringWidth(label);
                    int h = g.getFontMetrics().getHeight();
                    double yLabel = frame.getY() + headerHeight / 2.0 - (double)h / 2.0;
                    double xLabel = (double)x1 + (double)(x2 - x1) / 2.0 - (double)w / 2.0;
                    g.drawString(label, (int)xLabel, (int)yLabel);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

