/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.ComboCellRenderer;
import model2.IGDIntervalZone;
import model2.IGDUnit;
import util.ColorEditor;
import util.ColorRenderer;
import util.ColouredRenderer;
import util.SB;

class IGDSchTableModel
extends AbstractTableModel {
    LinkedList<IGDUnit.Builder> scheme = new LinkedList();
    final int igdType;
    static String[] colTitles = new String[]{"Unit name", "Abr.", "Type", "Youngest", "Oldest", "Colour", "Occs", "Surfaces"};
    static int[] colWidths = new int[]{90, 30, 30, 30, 30, 20, 20, 20};
    static final int COL_NAME = 0;
    static final int COL_ABR = 1;
    static final int COL_TYPE = 2;
    static final int COL_YOUNGEST = 3;
    static final int COL_OLDEST = 4;
    static final int COL_COLOUR = 5;
    static final int COL_OCCS = 6;
    static final int COL_SURFACE = 7;

    public IGDSchTableModel(int igdType) {
        this.igdType = igdType;
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        return this.scheme.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        IGDUnit.Builder unit = this.scheme.get(row);
        switch (col) {
            case 0: {
                return unit.getName();
            }
            case 2: {
                return IGDIntervalZone.getHierName((int)this.igdType, (int)unit.getHier(), (boolean)true);
            }
            case 1: {
                return unit.getAbr();
            }
            case 3: {
                return unit.getUage();
            }
            case 4: {
                return unit.getLage();
            }
            case 5: {
                return unit.getColour();
            }
            case 6: {
                return unit.getNOccs();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        IGDUnit.Builder unit = this.scheme.get(row);
        switch (col) {
            case 0: {
                unit.name((String)obj);
                break;
            }
            case 2: {
                unit.hier(IGDIntervalZone.getHierNumber((int)this.igdType, (String)((String)obj), (boolean)true));
                break;
            }
            case 1: {
                unit.abr((String)obj);
                break;
            }
            case 3: {
                unit.uAge(((Double)obj).doubleValue());
                break;
            }
            case 4: {
                unit.lAge(((Double)obj).doubleValue());
                break;
            }
            case 5: {
                unit.colour((Color)obj);
                break;
            }
            case 7: {
                break;
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: 
            case 2: 
            case 7: {
                return String.class;
            }
            case 3: 
            case 4: {
                return Double.class;
            }
            case 5: {
                return Color.class;
            }
            case 6: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    void setupTable(JTable jTableScheme, JComboBox hierComboBox) {
        SB.setTableHeaderBold((JTable)jTableScheme);
        if (hierComboBox.getItemCount() == 0) {
            for (int i = 1; i <= IGDIntervalZone.getNHier((int)this.igdType, (boolean)true); ++i) {
                hierComboBox.addItem(IGDIntervalZone.getHierName((int)this.igdType, (int)i, (boolean)true));
            }
        }
        TableColumnModel columnModel = jTableScheme.getColumnModel();
        for (int i = 0; i < colTitles.length; ++i) {
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
        }
        columnModel.getColumn(2).setCellEditor(new DefaultCellEditor(hierComboBox));
        columnModel.getColumn(6).setCellRenderer((TableCellRenderer)new ColouredRenderer(false, new Color(220, 220, 220), 4));
        columnModel.getColumn(7).setCellRenderer((TableCellRenderer)new ColouredRenderer(false, new Color(220, 220, 220), 4));
        columnModel.getColumn(2).setCellRenderer(new ComboCellRenderer());
        jTableScheme.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        ColorEditor.setUpColorEditor((JTable)jTableScheme);
    }
}

