/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import jsbugs.SBPrint;
import model2.SBImage;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.Well;
import util.SB;
import util.SBException;

public class ImageGallery
extends SBPrint {
    private List<Smpdtl> smpdtls;
    Well well;
    private boolean wholeSet = false;
    private boolean occComments = false;
    private boolean suite = true;
    private boolean excludeCats = false;
    private char size = (char)77;
    int pad = 8;
    Font fontBoldHdr = new Font("Arial", 1, 22);
    Font fontCaption = new Font("Arial", 0, 14);
    private static int tinySize = 8;
    Font fontTiny = new Font("Arial", 0, tinySize);
    int imagesPerPage = 0;
    int pages = 1;
    double scale = 0.5;

    public ImageGallery(List<Smpdtl> smpdtls, Well well) {
        this.smpdtls = smpdtls;
        this.well = well;
    }

    @Override
    int getnPages(int height, int width) {
        int gridSize;
        int nPages = 0;
        if (this.smpdtls == null || this.smpdtls.isEmpty()) {
            return nPages;
        }
        switch (this.size) {
            case 'S': {
                gridSize = 4;
                break;
            }
            default: {
                gridSize = 3;
                break;
            }
            case 'L': {
                gridSize = 2;
            }
        }
        this.imagesPerPage = (int)Math.pow(gridSize, 2.0);
        int nImages = 0;
        try {
            for (Smpdtl dtl : this.smpdtls) {
                for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                    if (!occ.hasImageSet()) continue;
                    if (this.wholeSet) {
                        nImages += occ.getImageSet().getSize();
                        continue;
                    }
                    ++nImages;
                }
            }
            int done = 0;
            while (done < nImages) {
                done += this.imagesPerPage;
                ++nPages;
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error calculating number of pages: ", (SQLException)sql);
            sql.printStackTrace();
        }
        this.pages = nPages;
        return this.pages;
    }

    @Override
    void draw(Graphics graphics, int x, int y, int unscaledWidth, int unscaledHeight, int pageIndex) {
        int gridSize;
        Graphics2D g = (Graphics2D)graphics;
        g.scale(this.scale, this.scale);
        int width = (int)((double)unscaledWidth / this.scale);
        int height = (int)((double)unscaledHeight / this.scale);
        int yPos = this.drawHeader(g, x, y, width, height, pageIndex);
        switch (this.size) {
            case 'S': {
                gridSize = 4;
                break;
            }
            default: {
                gridSize = 3;
                break;
            }
            case 'L': {
                gridSize = 2;
            }
        }
        int boxWidth = width / gridSize;
        int boxHeight = (height - (yPos - y)) / gridSize;
        int xref = 0;
        int yref = 0;
        int n = -1;
        int startIndex = pageIndex * this.imagesPerPage;
        int endIndex = startIndex + this.imagesPerPage;
        g.setFont(this.fontCaption);
        FontMetrics fm = g.getFontMetrics();
        int captionLines = 0;
        try {
            for (int iterations = 0; iterations < 2; ++iterations) {
                xref = 0;
                yref = 0;
                n = -1;
                int captionHeight = fm.getHeight() * captionLines + this.pad;
                for (Smpdtl dtl : this.smpdtls) {
                    for (TaxonOcc occ : dtl.getOccur()) {
                        if (!occ.hasImageSet()) continue;
                        for (int i = 0; i < (this.wholeSet ? occ.getImageSet().getSize() : 1); ++i) {
                            SBImage image = occ.getImageSet().getImage(i);
                            if (image == null || ++n < startIndex || n >= endIndex) continue;
                            if (iterations == 0) {
                                int thisCaptionLines = 1;
                                String occString = this.excludeCats ? occ.toStringNoCat() : occ.toString();
                                thisCaptionLines += this.drawText(g, x + xref * boxWidth, y, boxWidth, occString, false);
                                if (this.occComments && !occ.getComment().trim().isEmpty()) {
                                    thisCaptionLines += this.drawText(g, x + xref * boxWidth, y, boxWidth, occ.getComment(), false);
                                }
                                if (image.getCaption() != null && !image.getCaption().isEmpty()) {
                                    thisCaptionLines += this.drawText(g, x + xref * boxWidth, y, boxWidth, image.getCaption(), false);
                                }
                                if (thisCaptionLines <= captionLines) continue;
                                captionLines = thisCaptionLines;
                                continue;
                            }
                            int ycap = yPos + yref * boxHeight + (boxHeight - captionHeight);
                            g.setColor(Color.LIGHT_GRAY);
                            g.drawLine(x + xref * boxWidth, ycap, x + (xref + 1) * boxWidth, ycap);
                            g.setColor(Color.BLACK);
                            int xcap = x + (xref + 1) * boxWidth - boxWidth / 2;
                            if (this.wholeSet && occ.getImageSet().getSize() > 1) {
                                g.setFont(this.fontTiny);
                                String no = i + 1 + " of " + occ.getImageSet().getSize();
                                g.drawString(no, x + (xref + 1) * boxWidth - g.getFontMetrics().stringWidth(no) - this.pad / 3, ycap - fm.getDescent());
                                g.setFont(this.fontCaption);
                            }
                            String analyref = dtl.getSample().toString() + (this.suite ? " " + dtl.getHeader().toString() : "");
                            g.drawString(analyref, xcap - fm.stringWidth(analyref) / 2, ycap += fm.getHeight());
                            ycap += fm.getHeight();
                            String occString = this.excludeCats ? occ.toStringNoCat() : occ.toString();
                            ycap += fm.getHeight() * this.drawText(g, x + xref * boxWidth, ycap, boxWidth, occString, true);
                            if (this.occComments && !occ.getComment().trim().isEmpty()) {
                                ycap += fm.getHeight() * this.drawText(g, x + xref * boxWidth, ycap, boxWidth, occ.getComment(), true);
                            }
                            if (image.getCaption() != null && !image.getCaption().isEmpty()) {
                                ycap += fm.getHeight() * this.drawText(g, x + xref * boxWidth, ycap, boxWidth, image.getCaption(), true);
                            }
                            ImageIcon icon = image.getImage(boxWidth - this.pad * 2, boxHeight - this.pad * 2 - captionHeight - tinySize, true);
                            int yimg = yPos + (yref + 1) * boxHeight - icon.getIconHeight() - captionHeight - this.pad - tinySize;
                            g.drawImage(icon.getImage(), x + xref * boxWidth + boxWidth / 2 - icon.getIconWidth() / 2, yimg, null);
                            if (xref < gridSize - 1) {
                                g.drawLine(x + ++xref * boxWidth, yPos + yref * boxHeight, x + xref * boxWidth, yPos + (yref + 1) * boxHeight + 1);
                                continue;
                            }
                            xref = 0;
                            if (++yref >= gridSize) continue;
                            g.drawLine(x, yPos + yref * boxHeight, x + width, yPos + yref * boxHeight);
                        }
                    }
                }
            }
            if (yref < gridSize - 1) {
                g.drawLine(x, yPos + (yref + 1) * boxHeight, x + xref * boxWidth, yPos + (yref + 1) * boxHeight);
            }
            g.drawRect(x, y, width, height);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error drawing gallery: ", (SQLException)sql);
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error drawing gallery: ", (Exception)((Object)sbe));
            sbe.printStackTrace();
        }
        catch (IOException e) {
            SB.showStackError((String)"IO Error drawing gallery: ", (Exception)e);
            e.printStackTrace();
        }
    }

    private int drawText(Graphics g, int x, int y, int width, String text, boolean draw) {
        FontMetrics fm = g.getFontMetrics();
        if (fm.stringWidth(text) > width) {
            String line = "";
            int yPos = y;
            int lines = 1;
            StringTokenizer tokeniser = new StringTokenizer(text, " ");
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                if (fm.stringWidth(line + tok) < width) {
                    line = line + tok + " ";
                    continue;
                }
                if (draw) {
                    g.drawString(line, x + width / 2 - fm.stringWidth(line) / 2, yPos);
                }
                yPos += fm.getHeight();
                ++lines;
                line = tok + " ";
            }
            if (draw) {
                g.drawString(line, x + width / 2 - fm.stringWidth(line) / 2, yPos);
            }
            return lines++;
        }
        if (draw) {
            g.drawString(text, x + width / 2 - fm.stringWidth(text) / 2, y);
        }
        return 1;
    }

    private int drawHeader(Graphics2D g, int x, int y, int width, int height, int pageNo) {
        g.setStroke(new BasicStroke(1.0f, 0, 0));
        g.setFont(this.fontBoldHdr);
        int yPos = y + this.pad + g.getFontMetrics().getAscent();
        g.drawString("Images: " + this.well.toString(), x + this.pad, yPos);
        if (this.pages > 1) {
            String pageString = pageNo + 1 + " of " + this.pages;
            g.drawString(pageString, x + width - g.getFontMetrics().stringWidth(pageString) - this.pad / 2, yPos);
        }
        g.drawLine(x, yPos += g.getFontMetrics().getDescent() + this.pad, x + width, yPos);
        return yPos;
    }

    public char getSize() {
        return this.size;
    }

    public boolean getWholeSet() {
        return this.wholeSet;
    }

    public boolean getOccComments() {
        return this.occComments;
    }

    public boolean getSuite() {
        return this.suite;
    }

    public boolean getCats() {
        return this.excludeCats;
    }

    public void setProperties(char size, boolean wholeSet, boolean occComments, boolean suite, boolean cats) {
        this.size = size;
        this.wholeSet = wholeSet;
        this.occComments = occComments;
        this.suite = suite;
        this.excludeCats = cats;
    }
}

