/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import jsbugs.Chart;
import jsbugs.ChartActions;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.ChartPanel;
import jsbugs.ChartPropertiesAction;
import jsbugs.DialogPanelEvents;
import jsbugs.DialogPanelIGDScheme;
import jsbugs.DialogPanelSurfaces;
import jsbugs.DialogPrintPreviewChart;
import jsbugs.DialogProcessing;
import jsbugs.DialogRangeChart;
import jsbugs.FrameJsbugs;
import jsbugs.GUI;
import jsbugs.JPanelCharts;
import jsbugs.JScrollPaneChart;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelEventsBase;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelRange;
import jsbugs.PanelSurfaces;
import jsbugs.PanelWellDepthAge;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.UndoRedoAction;
import jsbugs.ZoomAction;
import model2.Lastval;
import model2.SBdb;
import org.apache.batik.transcoder.TranscoderException;
import util.SB;
import util.SbugsFileFilter;

public abstract class InternalFrameChart
extends JInternalFrame
implements ChartActions {
    private JScrollPaneChart jScrollPaneChart;
    final ChartJPanel chartJPanel;
    private Point popupPoint;
    static final float zoomIncrement = 1.5f;
    private static PageFormat printFormat = null;

    InternalFrameChart(ChartJPanel chartJPanel) {
        this.chartJPanel = chartJPanel;
        this.initKeyBindings();
    }

    protected void init(JScrollPaneChart sp) {
        if (sp == null) {
            throw new NullPointerException("Attempt to set chart scroll pane to null");
        }
        this.jScrollPaneChart = sp;
        this.jScrollPaneChart.addJPanelMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                InternalFrameChart.this.mMoved(evt);
            }
        });
        this.jScrollPaneChart.addJPanelMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChartPanel panel;
                if (evt.isPopupTrigger() && (panel = InternalFrameChart.this.getPanel(evt.getPoint())) != null) {
                    InternalFrameChart.this.popupPoint = evt.getPoint();
                    InternalFrameChart.this.mReleasedPopup(evt);
                }
            }
        });
    }

    abstract SBDialog getPropertiesDialog();

    abstract String getFrameTitle();

    abstract void mReleasedPopup(MouseEvent var1);

    void initChart(ChartBlock block) {
        Chart chart = new Chart();
        chart.chartProperties.setPanelHeaderHeight(80.0f);
        chart.chartProperties.margin = 5.0f;
        chart.blocks.add(block);
        block.addObserver(this.chartJPanel);
        this.chartJPanel.chart = chart;
        this.chartJPanel.setSize(this.chartJPanel.zoom);
    }

    public void mMoved(MouseEvent evt) {
        this.chartJPanel.setToolTipText(this.chartJPanel.getTooltip(evt));
    }

    @Override
    public void undoRedo(boolean undo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void zoom(boolean in) {
        this.chartJPanel.zoom(this.chartJPanel.zoom, 1.5f, in);
    }

    @Override
    public void chartProperties() {
        SBDialog dialog = this.getPropertiesDialog();
        if (dialog != null) {
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.chartJPanel.chart.calcChartSize();
                GUI.setScrollPaneSize(this.chartJPanel, this.chartJPanel.zoom, 1.0f);
                this.setTitle(this.getFrameTitle());
            }
        }
    }

    private void initKeyBindings() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(61, 128), "zoomIn");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(45, 128), "zoomOut");
        this.getActionMap().put("zoomIn", new ZoomAction(true, this));
        this.getActionMap().put("zoomOut", new ZoomAction(false, this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, 128), "undo");
        this.getActionMap().put("undo", new UndoRedoAction(true, this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, 192), "redo");
        this.getActionMap().put("redo", new UndoRedoAction(false, this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(80, 128), "chartProperties");
        this.getActionMap().put("chartProperties", new ChartPropertiesAction(this));
    }

    ChartPanel getPanel(Point point) {
        Point2D pTemp = this.chartJPanel.getPoint(point);
        Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
        return this.chartJPanel.chart.getSelectedPanel(mmPoint);
    }

    Point getPopupPoint() {
        if (this.popupPoint != null) {
            return new Point(this.popupPoint.x, this.popupPoint.y);
        }
        return null;
    }

    boolean panelProperties(SBdb db, JFrame parentFrame, String key) {
        Point2D pTemp = this.chartJPanel.getPoint(this.popupPoint);
        Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
        ChartPanel panel = this.chartJPanel.chart.getSelectedPanel(mmPoint);
        SBDialog dialog = null;
        if (panel instanceof PanelIGDScheme) {
            dialog = new DialogPanelIGDScheme(parentFrame, true, (PanelIGDScheme)panel);
        } else if (panel instanceof PanelCompositeStandard) {
            dialog = new DialogPanelEvents((Frame)parentFrame, true, (PanelEventsBase)((PanelCompositeStandard)panel), db);
        } else if (panel instanceof PanelSurfaces) {
            dialog = new DialogPanelSurfaces((Frame)parentFrame, true, (PanelSurfaces)panel);
        } else if (panel instanceof PanelRange) {
            dialog = new DialogRangeChart((Frame)parentFrame, true, db, this.chartJPanel.chart);
        } else if (panel instanceof PanelWellDepthAge) {
            SBPanel panelHorz = ((PanelWellDepthAge)panel).getProperties().sBlock.getPanelHorz(mmPoint.y - this.chartJPanel.chart.chartProperties.margin - this.chartJPanel.chart.chartProperties.panelCaptionHeight);
            if (panelHorz instanceof PanelCompositeStandard) {
                dialog = new DialogPanelEvents((Frame)parentFrame, true, (PanelEventsBase)((PanelCompositeStandard)panelHorz), db);
            } else if (panelHorz instanceof PanelIGDScheme) {
                dialog = new DialogPanelIGDScheme(parentFrame, true, (PanelIGDScheme)panelHorz);
            } else if (panelHorz instanceof PanelSurfaces) {
                dialog = new DialogPanelSurfaces((Frame)parentFrame, true, (PanelSurfaces)panelHorz);
            }
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.chartJPanel.repaint();
                if (panel instanceof PanelWellDepthAge) {
                    this.chartJPanel.chart.chartProperties.setPanelSubHeaderHeight(((PanelWellDepthAge)panel).getHeaderHeight(this.chartJPanel.chart.chartProperties));
                }
                this.chartJPanel.chart.calcChartSize();
                if (key != null && panel instanceof SBPanel) {
                    try {
                        this.chartJPanel.chart.savePreference(db, key, (SBPanel)panel);
                        db.commit();
                    }
                    catch (SQLException sql) {
                        FrameJsbugs.showStackError("SQL Error saving panel properties", sql, db);
                    }
                }
                return true;
            }
        }
        return false;
    }

    void printChart(SBdb db, JFrame parentFrame) {
        Chart chart = this.chartJPanel.chart;
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!job.printDialog()) {
            return;
        }
        ChartJPanel printPanel = new ChartJPanel(chart, printFormat != null ? printFormat : job.defaultPage(), db.decodeChartPrintPrefs());
        DialogPrintPreviewChart dialog = new DialogPrintPreviewChart(parentFrame, true, printPanel, job, db);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        job.setPrintable(printPanel, printPanel.getPf());
        try {
            job.print();
        }
        catch (PrinterException exp) {
            JOptionPane.showMessageDialog(this, "Problem printing: " + exp.getMessage());
            exp.printStackTrace();
        }
        printFormat = printPanel.getPf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportChart(final SBdb db, final JFrame parentFrame) {
        if (!(parentFrame.getParent() instanceof FrameJsbugs)) {
            throw new IllegalArgumentException("Attempt to use wrong type of Frame");
        }
        boolean vector = true;
        Chart chart = this.chartJPanel.chart;
        if (chart == null) {
            JOptionPane.showMessageDialog(this, "No chart selected/created. Use the Chart tab and select chart", "Scheme Chart", 1);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        for (JPanelCharts.ImageFileType vtype : JPanelCharts.ImageFileType.values()) {
            if (vtype.isVector() != vector) continue;
            jFileChooser.addChoosableFileFilter((FileFilter)vtype.getFilter());
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = vector ? new File(Lastval.getString((SBdb)db, (String)"WINVECIMG", (String)"UNXVECIMG")) : new File(Lastval.getString((SBdb)db, (String)"WINRASIMG", (String)"UNXRASIMG"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (0 == jFileChooser.showSaveDialog(this)) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (jFileChooser.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                    return;
                }
                setDir = jFileChooser.getSelectedFile();
                SbugsFileFilter filter = (SbugsFileFilter)jFileChooser.getFileFilter();
                if (filter == null) {
                    JPanelCharts.ImageFileType type;
                    if (setDir.getName().lastIndexOf(".") > 0 && (type = JPanelCharts.ImageFileType.getType(setDir.getName().substring(setDir.getName().lastIndexOf(".") + 1))) != null) {
                        filter = type.getFilter();
                    }
                    if (filter == null) {
                        filter = JPanelCharts.ImageFileType.getDefaultFilter(vector);
                    }
                }
                if (!setDir.getName().endsWith("." + filter.getExtension())) {
                    setDir = new File(setDir.getPath() + "." + filter.getExtension());
                }
                if (vector) {
                    final File dir = setDir;
                    final JPanelCharts.ImageFileType type = JPanelCharts.ImageFileType.getType(filter.getExtension());
                    final InternalFrameChart messageParent = this;
                    final DialogProcessing dialog = new DialogProcessing((Frame)parentFrame, true);
                    dialog.setMessage("Writing image file...");
                    dialog.setLocationRelativeTo(this);
                    new SwingWorker(){
                        boolean done;

                        protected Object doInBackground() throws IOException, TranscoderException {
                            try {
                                JPanelCharts.saveVectorImage(dir, type, InternalFrameChart.this.chartJPanel.chart, db, ((FrameJsbugs)parentFrame.getParent()).isDemoLicense());
                                dialog.setComplete();
                            }
                            catch (FileNotFoundException fnf) {
                                JOptionPane.showMessageDialog(messageParent, fnf.getMessage(), "Error saving chart", 0);
                                dialog.setMessage(fnf.getMessage());
                            }
                            catch (IOException ioe) {
                                SB.showStackError((String)"IO Error creating file", (Exception)ioe);
                            }
                            catch (NoClassDefFoundError c) {
                                JOptionPane.showMessageDialog(messageParent, "A required library may be missing - please contct your system administrator\n" + c.getMessage(), "Error saving chart", 0);
                            }
                            catch (OutOfMemoryError e) {
                                JOptionPane.showMessageDialog(messageParent, "Error writing image - out of memory!\nNote that some chart panels are more memory-intensive than others:\ntry removing lithology and wireline log panels, or save to SVG.", "Memory error", 0);
                            }
                            catch (Exception e) {
                                SB.showStackError((String)"Error creating file", (Exception)e);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            dialog.dispose();
                        }
                    }.execute();
                    dialog.setVisible(true);
                    if (!dialog.isTaskComplete()) {
                        return;
                    }
                }
                try {
                    Lastval.putString((SBdb)db, (String)(vector ? "WINVECIMG" : "WINRASIMG"), (String)setDir.getPath());
                    db.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            JOptionPane.showMessageDialog(this, "Image written.", "Export image", 1);
        }
    }
}

