/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelCmpStdHeader;
import jsbugs.TableModelCmpStd;
import jsbugs.TaxonTransferHandler;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.SBEvent;
import model2.SBdb;
import model2.Taxon;
import util.InvalidFieldException;
import util.SbugsStatus;
import util.TableSorter;

public class InternalFrameCmpStd
extends JInternalFrame
implements PropertyChangeListener,
Observer {
    private final TableModelCmpStd model = new TableModelCmpStd();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final JPanelCmpStdHeader panelHdr = new JPanelCmpStdHeader(this.model);
    private final SBdb sbdb;
    private CompositeStandard std;
    private JButton jButtonSave;
    private JPanel jPanelHeader;
    private JScrollPane jScrollPane1;
    private JTable jTableCmpStd;
    private JTextField jTextFieldStatus;

    public InternalFrameCmpStd(CompositeStandard std, SBdb sbdb) throws SQLException {
        if (std != null && !std.getDatabase().isConnected()) {
            throw new IllegalArgumentException("Attempt edit workspace composite with internal frame");
        }
        this.sbdb = sbdb;
        this.std = std;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.jPanelHeader.setLayout(new BorderLayout());
        this.jPanelHeader.add(this.panelHdr);
        this.model.setupTable(this.jTableCmpStd);
        this.model.addPropertyChangeListener(this);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableCmpStd);
        this.jTableCmpStd.getTableHeader().addMouseMotionListener((MouseMotionListener)this.sorter.createColumnHeaderToolTips(TableModelCmpStd.tooltips, this.jTableCmpStd));
        if (this.std != null) {
            this.std.loadEvents();
            this.loadModelStd();
            this.std.addObserver((Observer)this);
        } else {
            this.setTitle("New Composite Standard");
        }
        this.refreshStatus();
        this.jTableCmpStd.setDragEnabled(true);
        this.jTableCmpStd.setTransferHandler(new TaxonTransferHandler(null));
        this.jTableCmpStd.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(null));
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void loadModelStd() {
        this.model.cmpStd.clear();
        for (CompositeStandardEvent event : this.std.getEvents()) {
            this.model.cmpStd.add(CompositeStandardEvent.Builder.copyOf((CompositeStandardEvent)event).event(event.getEvent()));
        }
        this.model.updateFields(this.std.getName(), this.std.getMinAge(), this.std.getMaxAge(), this.std.getTopCSU(), this.std.getBaseCSU(), this.std.isAgeScale());
        this.panelHdr.setFields();
        this.setTitle("Editing Composite Standard: " + this.std.getName());
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs == this.std && !this.std.equals(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.cmpStd)) {
            if (this.jTextFieldStatus.getText().equalsIgnoreCase("Saved")) {
                this.loadModelStd();
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            } else {
                JOptionPane.showMessageDialog(this.rootPane, "Warning: you have edited the Composite Standard that you have already modified in the underlying window.\nClose this window without saving, to discard your previous changes.");
            }
        }
    }

    private void refreshStatus() {
        System.out.println("Refreshing composite status...");
        if (this.std == null) {
            this.jTextFieldStatus.setText("Unsaved");
            this.jTextFieldStatus.setBackground(SbugsStatus.NOTSTORED);
            this.jButtonSave.setFont(new Font("Tahoma", 1, 11));
        } else if (this.std.equals(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.cmpStd)) {
            this.jTextFieldStatus.setText("Saved");
            this.jTextFieldStatus.setBackground(SbugsStatus.STORED);
            this.jButtonSave.setFont(new Font("Tahoma", 0, 11));
        } else {
            try {
                this.panelHdr.validateFields(this.sbdb, this.std);
                this.model.validateCSU();
                CompositeStandard.validateBuilders(this.model.cmpStd, (SBdb)this.sbdb);
            }
            catch (InvalidFieldException e) {
                this.jTextFieldStatus.setText("Invalid");
                this.jTextFieldStatus.setBackground(SbugsStatus.CONFLICT);
                this.jButtonSave.setFont(new Font("Tahoma", 0, 11));
                return;
            }
            this.jTextFieldStatus.setText("Modified");
            this.jTextFieldStatus.setBackground(SbugsStatus.PARTSTORED);
            this.jButtonSave.setFont(new Font("Tahoma", 1, 11));
        }
    }

    public CompositeStandard getCmpStd() {
        return this.std;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCmpStd = new JTable();
        this.jPanelHeader = new JPanel();
        this.jTextFieldStatus = new JTextField();
        this.jButtonSave = new JButton();
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/InternalFrameRangeChart.png")));
        this.setMinimumSize(new Dimension(560, 300));
        this.setPreferredSize(new Dimension(550, 443));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                InternalFrameCmpStd.this.internalFrameClosingEvent(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jTableCmpStd.setModel((TableModel)this.sorter);
        this.jTableCmpStd.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InternalFrameCmpStd.this.jTableCmpStdKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCmpStd);
        this.jPanelHeader.setPreferredSize(new Dimension(544, 102));
        GroupLayout jPanelHeaderLayout = new GroupLayout(this.jPanelHeader);
        this.jPanelHeader.setLayout(jPanelHeaderLayout);
        jPanelHeaderLayout.setHorizontalGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelHeaderLayout.setVerticalGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 102, Short.MAX_VALUE));
        this.jTextFieldStatus.setEditable(false);
        this.jTextFieldStatus.setHorizontalAlignment(0);
        this.jTextFieldStatus.setText("status");
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameCmpStd.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 534, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jTextFieldStatus, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave, -2, 70, -2).addContainerGap()).addComponent(this.jPanelHeader, -1, 534, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanelHeader, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 271, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldStatus, -2, -1, -2).addComponent(this.jButtonSave)).addGap(6, 6, 6)));
        this.pack();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.save();
        this.refreshStatus();
    }

    private void internalFrameClosingEvent(InternalFrameEvent evt) {
        this.close();
    }

    void close() {
        if (this.jTextFieldStatus.getBackground() != SbugsStatus.STORED) {
            int opt = JOptionPane.showConfirmDialog(this, "Do you want to save changes?", this.getTitle(), 1);
            if (opt == 0) {
                this.save();
                this.dispose();
            } else if (opt == 1) {
                this.dispose();
            } else {
                return;
            }
        }
        this.dispose();
    }

    private void jTableCmpStdKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.deleteEvents();
        }
    }

    private void save() {
        Color status = this.jTextFieldStatus.getBackground();
        if (status == SbugsStatus.STORED) {
            return;
        }
        try {
            this.panelHdr.validateFields(this.sbdb, this.std);
            this.model.validateCSU();
            CompositeStandard.validateBuilders(this.model.cmpStd, (SBdb)this.sbdb);
            if (this.std != null) {
                this.std.update(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.cmpStd);
            } else {
                this.panelHdr.setModelAge();
                this.std = this.sbdb.addCompositeStandard(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, this.model.isAgeScale, this.model.cmpStd, null);
                this.setTitle("Editing Composite: " + this.std.getName());
            }
            this.sbdb.commit();
            if (this.std != null) {
                this.std.notifyObservers();
            }
            this.panelHdr.setFields();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshStatus();
    }

    public boolean importList(List list) {
        if (list.isEmpty()) {
            return false;
        }
        Object o = list.get(0);
        if (o instanceof Taxon) {
            return this.importTaxa(list);
        }
        if (o instanceof SBEvent) {
            return this.importEvents(list);
        }
        return false;
    }

    private boolean importTaxa(List<Taxon> taxa) {
        try {
            int nBefore = this.sbdb.getSBEvents(false).size();
            int nAdded = this.model.importTaxa(taxa, this.sbdb);
            int nAfter = this.sbdb.getSBEvents(false).size();
            this.model.fireTableDataChanged();
            String msg = nAdded + (nAdded == 1 ? " event" : " events") + " added";
            if (nBefore != nAfter) {
                int nDict = nAfter - nBefore;
                msg = nDict + (nDict == 1 ? " event" : " events") + " added to dictionary\n" + msg + " to composite";
            }
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            this.refreshStatus();
            return true;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return false;
        }
    }

    private boolean importEvents(List<SBEvent> events) {
        int nAdded = 0;
        for (SBEvent event : events) {
            nAdded += this.model.importEvent(event);
        }
        this.model.fireTableDataChanged();
        String msg = nAdded + (nAdded == 1 ? " event" : " events") + " added";
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
        this.refreshStatus();
        return true;
    }

    private void deleteEvents() {
        int[] selection = this.jTableCmpStd.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No row(s) selected", this.getTitle(), 2);
            return;
        }
        LinkedList<CompositeStandardEvent.Builder> toRemove = new LinkedList<CompositeStandardEvent.Builder>();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.model.cmpStd.get(this.sorter.getIndexOf(selection[i])));
        }
        for (CompositeStandardEvent.Builder event : toRemove) {
            this.model.cmpStd.remove(event);
        }
        this.refreshStatus();
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    public Color getStatus() {
        return this.jTextFieldStatus.getBackground();
    }
}

