/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jsbugs.DialogEnvReassign;
import jsbugs.DialogEnvScheme;
import jsbugs.DialogList;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import model2.EnvScheme;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class InternalFrameEnvSchemes
extends JInternalFrame
implements Observer {
    SBdb db;
    DefaultListModel model = new DefaultListModel();
    JCheckBoxMenuItem menuCheckBox = null;
    FrameInterpretations parent;
    private JButton jButton3;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonReassign;
    private JButton jButtonWells;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public InternalFrameEnvSchemes(FrameInterpretations parent, SBdb db, JCheckBoxMenuItem menuCheckBox) throws Exception {
        this.db = db;
        this.menuCheckBox = menuCheckBox;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws Exception {
        this.setTitle("Palaeoenvironment Schemes");
        this.refreshList();
        this.db.addObserver((Observer)this);
    }

    private void refreshList() throws SQLException, SBException {
        this.model.removeAllElements();
        List list = this.db.getEnvSchemes();
        Collections.sort(list);
        for (EnvScheme scheme : list) {
            this.model.addElement(scheme);
        }
        this.jListSchemes.repaint();
    }

    @Override
    public void update(Observable obs, Object o) {
        if (o.getClass() == EnvScheme.class) {
            if (obs.getClass() == SBdb.class) {
                try {
                    this.refreshList();
                }
                catch (Exception e) {
                    System.out.println("From InternalFrameEnvScheme.update");
                    e.printStackTrace();
                }
            } else {
                this.jListSchemes.repaint();
            }
        }
    }

    private void initComponents() {
        this.jButton3 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonWells = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonReassign = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton3.setText("jButton3");
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/InternalFrameEnvScheme.png")));
        this.setMinimumSize(new Dimension(350, 250));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                InternalFrameEnvSchemes.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jListSchemes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSchemes.setModel(this.model);
        this.jListSchemes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameEnvSchemes.this.jListSchemesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEnvSchemes.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEnvSchemes.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEnvSchemes.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonWells.setText("Show wells...");
        this.jButtonWells.setToolTipText("Display wells where selected scheme is used");
        this.jButtonWells.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEnvSchemes.this.jButtonWellsActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEnvSchemes.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonReassign.setText("Reassign...");
        this.jButtonReassign.setToolTipText("Reassign the scheme well intervals to another scheme, and delete the scheme");
        this.jButtonReassign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEnvSchemes.this.jButtonReassignActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 271, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonWells, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonReassign, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 266, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonWells).add(13, 13, 13).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonReassign).addPreferredGap(0, 97, Short.MAX_VALUE).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.menuCheckBox.setSelected(false);
        this.setVisible(false);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogEnvScheme dialog = new DialogEnvScheme((Frame)this.parent, true, this.db, null);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            if (dialog.isOK) {
                EnvScheme envScheme;
                int index;
                for (index = 0; index < this.model.getSize() && (envScheme = (EnvScheme)this.model.get(index)).getName().compareToIgnoreCase(dialog.model.scheme.getName()) <= 0; ++index) {
                }
                this.model.insertElementAt(dialog.model.scheme, index);
                this.jListSchemes.setSelectedValue(dialog.model.scheme, true);
                dialog.model.scheme.addObserver((Observer)this);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading scheme: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        EnvScheme scheme = (EnvScheme)this.jListSchemes.getSelectedValue();
        try {
            DialogEnvScheme dialog = new DialogEnvScheme((Frame)this.parent, true, this.db, scheme);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            this.jListSchemes.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading scheme: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        EnvScheme scheme = (EnvScheme)this.jListSchemes.getSelectedValue();
        try {
            int occs = scheme.getNoccs();
            int nHdrOccs = scheme.getNAnalyHdrOccs();
            if (nHdrOccs > 0) {
                String msg = "This scheme is referenced by " + nHdrOccs + " analysis suite" + (nHdrOccs > 1 ? "s" : "") + ".\nYou must remove " + (nHdrOccs > 1 ? "these references" : "this reference") + " before you can delete the scheme.";
                JOptionPane.showMessageDialog(this.parent, msg, this.getTitle(), 2);
                return;
            }
            String msg = occs > 0 ? "This scheme is linked to " + occs + " intervals in the database. Deleting the scheme will delete these entries.\n" : "This scheme is not used in any wells.\n";
            if (JOptionPane.showConfirmDialog(this, (msg = msg + "This scheme is not referenced by any analysis suites.\n") + "Really delete scheme: " + scheme + "?", this.getTitle(), 0, 3) == 0) {
                this.db.deleteEnvScheme(scheme);
                this.db.commit();
                scheme.notifyObservers();
                scheme.deleteObservers();
                this.model.removeElement(scheme);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonWellsActionPerformed(ActionEvent evt) {
        Object object = this.jListSchemes.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.parent.getTitle(), 1);
            return;
        }
        try {
            EnvScheme scheme = (EnvScheme)object;
            List occs = scheme.getOccs(0);
            if (occs == null || occs.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Scheme does not occur in any wells or outcrops.", scheme.toString(), 1);
            } else {
                DialogList dialog = new DialogList(this.parent, true, scheme.toString(), this.db, occs, true, false);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonReassignActionPerformed(ActionEvent evt) {
        Object object = this.jListSchemes.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.parent.getTitle(), 1);
            return;
        }
        try {
            EnvScheme scheme = (EnvScheme)object;
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogEnvReassign dialog = new DialogEnvReassign((Frame)this.parent, true, this.db, scheme);
            dialog.setLocationRelativeTo(this);
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.refreshList();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }
}

