/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.DialogEvent;
import jsbugs.DialogEventOcc;
import jsbugs.DialogMergeEvents;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.SBEventsTableModel;
import jsbugs.TaxonTransferHandler;
import model2.SBEvent;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class InternalFrameEventDict
extends JInternalFrame
implements Observer {
    private final SBEventsTableModel model = new SBEventsTableModel();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final SBdb db;
    private final FrameTaxaDB parent;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemUsage;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JTable jTableSBEvents;

    public InternalFrameEventDict(FrameTaxaDB parent, SBdb db) throws SQLException, SBException {
        this.db = db;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Events");
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSBEvents);
        this.model.setupTable(this.jTableSBEvents);
        this.model.setEvents(new LinkedList<SBEvent>(this.db.getSBEvents(true)));
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.db.addObserver((Observer)this);
        this.jTableSBEvents.add(this.jPopupMenu1);
        this.jTableSBEvents.setDragEnabled(true);
        this.jTableSBEvents.setTransferHandler(new TaxonTransferHandler(null));
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof SBEvent) {
            System.out.println("Updating event list...");
            try {
                this.model.setEvents(new LinkedList<SBEvent>(this.db.getSBEvents(false)));
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemUsage = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSBEvents = new JTable();
        this.jMenuItemEdit.setText("Edit...");
        this.jMenuItemEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEventDict.this.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemEdit);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEventDict.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemDelete);
        this.jMenuItemUsage.setText("Usage...");
        this.jMenuItemUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameEventDict.this.jMenuItemUsageActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemUsage);
        this.setClosable(true);
        this.setDefaultCloseOperation(1);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/InternalFrameEvents.png")));
        this.jTableSBEvents.setModel((TableModel)this.sorter);
        this.jTableSBEvents.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameEventDict.this.jTableSBEventsMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                InternalFrameEventDict.this.jTableSBEventsMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableSBEvents);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 566, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 430, Short.MAX_VALUE));
        this.pack();
    }

    private void jTableSBEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editEvent();
        }
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
        }
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        this.editEvent();
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableSBEvents.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", "Delete Events", 1);
            return;
        }
        LinkedList<SBEvent> toDelete = new LinkedList<SBEvent>();
        int[] selection = this.jTableSBEvents.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            toDelete.add(this.model.getEvents().get(this.sorter.getIndexOf(selection[i])));
        }
        try {
            SBEvent lastEvent = null;
            for (SBEvent event : toDelete) {
                int nWells = event.getNoccs(true);
                int nComp = event.getNcmpStdOccs();
                if (nWells > 0 || nComp > 0) {
                    int opt = JOptionPane.showConfirmDialog(this, "event:" + event.toString() + " Occurs in: " + nWells + " well sections and " + nComp + " Composite Standards. Are you sure you want to delete it?", "Delete Event", 1, 3);
                    if (opt == 2 || opt == -1) break;
                    if (opt == 1) continue;
                }
                lastEvent = event;
                this.db.deleteSBEvent(event);
                this.db.commit();
            }
            if (lastEvent != null) {
                this.db.notifyObservers(lastEvent);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        this.jTableSBEvents.clearSelection();
    }

    private void jTableSBEventsMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
        }
    }

    private void jMenuItemUsageActionPerformed(ActionEvent evt) {
        this.eventUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eventUsage() {
        int selection = this.jTableSBEvents.getSelectedRow();
        if (selection < 0) {
            JOptionPane.showMessageDialog(this, "Select an event", this.parent.getTitle(), 1);
            return;
        }
        SBEvent event = this.model.getEvents().get(this.sorter.getIndexOf(selection));
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogEventOcc dialog = new DialogEventOcc((Frame)this.parent, true, event, this.db);
        dialog.setLocationRelativeTo(this.parent);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
        if (dialog.selectedWellResult != null) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.parent.parent.setSamplesWell(this.db.getAddWell(dialog.selectedWellResult.wellID));
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void editEvent() {
        int selection = this.jTableSBEvents.getSelectedRow();
        if (selection < 0) {
            JOptionPane.showMessageDialog(this, "Select an event to edit", this.parent.getTitle(), 1);
        }
        SBEvent event = this.model.getEvents().get(this.sorter.getIndexOf(selection));
        DialogEvent dialog = new DialogEvent(this.parent, true, this.db, event, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.jTableSBEvents.repaint();
        }
    }

    void merge() {
        if (this.jTableSBEvents.getSelectedRowCount() < 2) {
            JOptionPane.showMessageDialog(this, "You must select at least 2 events from the list to merge", this.getTitle(), 1);
            return;
        }
        LinkedList<SBEvent> events = new LinkedList<SBEvent>();
        int specID = 0;
        for (int row : this.jTableSBEvents.getSelectedRows()) {
            SBEvent event = this.model.getEvents().get(this.sorter.getIndexOf(row));
            if (specID == 0) {
                specID = event.getSpecID();
            }
            if (specID != event.getSpecID()) {
                JOptionPane.showMessageDialog(this, "You can only merge events linked to the same taxon", this.getTitle(), 1);
                return;
            }
            events.add(event);
        }
        DialogMergeEvents dialog = new DialogMergeEvents((Frame)this.parent, true, events, this.db);
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.jTableSBEvents.clearSelection();
        }
    }
}

