/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import jsbugs.DialogTaxon;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.JPanelGroups;
import jsbugs.TaxonListMember;
import jsbugs.TaxonTransferHandler;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class InternalFrameGroup
extends JInternalFrame
implements Observer {
    private final DefaultListModel taxaModel = new DefaultListModel();
    private Point popupPoint;
    private boolean duringRefresh = false;
    private final SBdb db;
    private final TxGroup group;
    private final JPanelGroups jPanelGroups;
    FrameTaxaDB frameTaxa;
    private ButtonGroup buttonGroupSort;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelModified;
    private JLabel jLabelNTaxa;
    private JList jListTaxa;
    private JMenuItem jMenuItemDeleteSelected;
    private JPanel jPanelColour;
    private JPopupMenu jPopupMenuGroup;
    private JRadioButton jRadioButtonCategory;
    private JRadioButton jRadioButtonGenus;
    private JRadioButton jRadioButtonSpecies;
    private JScrollPane jScrollPane1;

    public InternalFrameGroup(FrameTaxaDB frameTaxa, SBdb db, TxGroup group, JPanelGroups jPanelGroups) {
        this.initComponents();
        this.db = db;
        this.group = group;
        this.jPanelGroups = jPanelGroups;
        this.frameTaxa = frameTaxa;
        this.init();
    }

    TxGroup getGroup() {
        return this.group;
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs.getClass() == TxGroup.class && obs == this.group) {
            if (obj == null) {
                Taxon.SortOrder sort = this.jRadioButtonCategory.isSelected() ? Taxon.SortOrder.SORT_CATEGORY : (this.jRadioButtonGenus.isSelected() ? Taxon.SortOrder.SORT_GENUS : Taxon.SortOrder.SORT_SPECIES);
                this.refreshList(sort);
            } else if (obj.getClass() == Color.class) {
                this.jPanelColour.setBackground(this.group.getColour());
            } else if (obj.getClass() == String.class) {
                this.setTitle("Group: " + this.group.getName());
            }
        } else if (obs.getClass() == Taxon.class) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalFrameGroup.this.jListTaxa.updateUI();
                }
            });
        }
    }

    SBdb getDatabase() {
        return this.db;
    }

    private void init() {
        this.refreshList(Taxon.SortOrder.SORT_CATEGORY);
        this.jListTaxa.setDragEnabled(true);
        this.jListTaxa.setTransferHandler(new TaxonTransferHandler(this.group));
        this.jListTaxa.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(this.group));
        this.jPanelColour.setBackground(this.group.getColour());
        this.group.addObserver((Observer)this);
        this.setTitle("Group: " + this.group.getName());
        this.taxaModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (!InternalFrameGroup.this.duringRefresh) {
                    LinkedList<Taxon> remainder = new LinkedList<Taxon>();
                    Enumeration en = InternalFrameGroup.this.taxaModel.elements();
                    while (en.hasMoreElements()) {
                        TaxonListMember member = (TaxonListMember)en.nextElement();
                        remainder.add(member.taxon);
                    }
                    try {
                        Collection groupTaxa = InternalFrameGroup.this.db.getTxGroupTaxa(InternalFrameGroup.this.group);
                        groupTaxa.removeAll(remainder);
                        InternalFrameGroup.this.group.deleteTaxa(new LinkedList(groupTaxa));
                        InternalFrameGroup.this.jLabelNTaxa.setText("" + InternalFrameGroup.this.taxaModel.size());
                        InternalFrameGroup.this.db.commit();
                    }
                    catch (SQLException sql) {
                        InternalFrameGroup.this.db.doRollback();
                        FrameJsbugs.showStackError("SQL Error", sql, InternalFrameGroup.this.db);
                    }
                }
            }
        });
        this.setModifiedLabel();
    }

    private void setModifiedLabel() {
        this.jLabelModified.setText(this.group.getAudit().toString(this.db, false));
    }

    boolean importData(List<Taxon> taxa) {
        try {
            HashSet<Taxon> toAdd = new HashSet<Taxon>();
            for (Taxon taxon : taxa) {
                if (this.group.isMember(taxon.getSpecID())) continue;
                toAdd.add(taxon);
            }
            if (toAdd.isEmpty()) {
                return false;
            }
            this.group.addTaxa(new LinkedList(toAdd));
            this.db.commit();
            return true;
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("SQL Error saving items into group", e, this.db);
            this.db.doRollback();
            return false;
        }
    }

    void deleteTaxa(List<Taxon> taxa) {
        try {
            this.group.deleteTaxa(taxa);
            this.db.commit();
        }
        catch (Exception e) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error deleting taxa from group", e, this.db);
        }
    }

    boolean hasList(JComponent comp) {
        return this.jListTaxa == comp;
    }

    private void initComponents() {
        this.buttonGroupSort = new ButtonGroup();
        this.jPopupMenuGroup = new JPopupMenu();
        this.jMenuItemDeleteSelected = new JMenuItem();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListTaxa = new JList();
        this.jLabelNTaxa = new JLabel();
        this.jPanelColour = new JPanel();
        this.jLabel3 = new JLabel();
        this.jRadioButtonCategory = new JRadioButton();
        this.jRadioButtonSpecies = new JRadioButton();
        this.jRadioButtonGenus = new JRadioButton();
        this.jLabelModified = new JLabel();
        this.jMenuItemDeleteSelected.setText("jMenuItem1");
        this.jMenuItemDeleteSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroup.this.jMenuItemDeleteSelectedActionPerformed(evt);
            }
        });
        this.jPopupMenuGroup.add(this.jMenuItemDeleteSelected);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameIcon_TaxaDB/16Taxa.png")));
        this.setMinimumSize(new Dimension(280, 250));
        this.setPreferredSize(new Dimension(400, 150));
        this.setVisible(true);
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                InternalFrameGroup.this.formInternalFrameActivated(evt);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jLabel1.setText("Taxa:");
        this.jListTaxa.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255), 2));
        this.jListTaxa.setModel(this.taxaModel);
        this.jListTaxa.setToolTipText("Drag and drop taxa to edit groups, hold CTRL and drag to copy");
        this.jListTaxa.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameGroup.this.jListTaxaMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                InternalFrameGroup.this.jListTaxaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                InternalFrameGroup.this.jListTaxaMouseReleased(evt);
            }
        });
        this.jListTaxa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InternalFrameGroup.this.jListTaxaKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListTaxa);
        this.jLabelNTaxa.setFont(new Font("Tahoma", 1, 14));
        this.jLabelNTaxa.setText("jLabel3");
        GroupLayout jPanelColourLayout = new GroupLayout((Container)this.jPanelColour);
        this.jPanelColour.setLayout((LayoutManager)jPanelColourLayout);
        jPanelColourLayout.setHorizontalGroup((GroupLayout.Group)jPanelColourLayout.createParallelGroup(1).add(0, 264, Short.MAX_VALUE));
        jPanelColourLayout.setVerticalGroup((GroupLayout.Group)jPanelColourLayout.createParallelGroup(1).add(0, 16, Short.MAX_VALUE));
        this.jLabel3.setText("Sort by:");
        this.buttonGroupSort.add(this.jRadioButtonCategory);
        this.jRadioButtonCategory.setSelected(true);
        this.jRadioButtonCategory.setText("Category");
        this.jRadioButtonCategory.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCategory.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroup.this.jRadioButtonCategoryActionPerformed(evt);
            }
        });
        this.buttonGroupSort.add(this.jRadioButtonSpecies);
        this.jRadioButtonSpecies.setText("Species");
        this.jRadioButtonSpecies.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSpecies.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroup.this.jRadioButtonSpeciesActionPerformed(evt);
            }
        });
        this.buttonGroupSort.add(this.jRadioButtonGenus);
        this.jRadioButtonGenus.setText("Genus");
        this.jRadioButtonGenus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonGenus.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonGenus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroup.this.jRadioButtonGenusActionPerformed(evt);
            }
        });
        this.jLabelModified.setForeground(new Color(102, 102, 102));
        this.jLabelModified.setText("Modified by: On:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelColour, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 364, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(1).add((Component)this.jRadioButtonCategory).addPreferredGap(0).add((Component)this.jRadioButtonSpecies).addPreferredGap(0).add((Component)this.jRadioButtonGenus).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jLabelNTaxa).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabelModified))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanelColour, -2, -1, -2).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jRadioButtonCategory).add((Component)this.jRadioButtonSpecies).add((Component)this.jRadioButtonGenus)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 35, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelNTaxa).add((Component)this.jLabel1).add((Component)this.jLabelModified)).addContainerGap()));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList(Taxon.SortOrder sortOrder) {
        this.duringRefresh = true;
        try {
            final Collection c = this.db.getTxGroupTaxa(this.group);
            LinkedList list = new LinkedList(c);
            Taxon.sort(list, (Taxon.SortOrder)sortOrder);
            this.taxaModel.clear();
            for (Taxon taxon : list) {
                this.taxaModel.addElement(new TaxonListMember(taxon));
                taxon.addObserver((Observer)this);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalFrameGroup.this.jListTaxa.repaint();
                    InternalFrameGroup.this.jLabelNTaxa.setText("" + c.size());
                }
            });
            this.setModifiedLabel();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.duringRefresh = false;
        }
    }

    private void jRadioButtonCategoryActionPerformed(ActionEvent evt) {
        this.refreshList(Taxon.SortOrder.SORT_CATEGORY);
    }

    private void jRadioButtonSpeciesActionPerformed(ActionEvent evt) {
        this.refreshList(Taxon.SortOrder.SORT_SPECIES);
    }

    private void jRadioButtonGenusActionPerformed(ActionEvent evt) {
        this.refreshList(Taxon.SortOrder.SORT_GENUS);
    }

    private void jListTaxaMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            if (this.jListTaxa.getSelectedIndices().length > 1) {
                this.jMenuItemDeleteSelected.setText("Remove selected taxa");
            } else if (this.jListTaxa.getSelectedIndices().length == 1) {
                this.jMenuItemDeleteSelected.setText("Remove selected taxon");
            } else {
                this.jMenuItemDeleteSelected.setText("(No taxon selected - left-click required)");
            }
            this.jPopupMenuGroup.show(evt.getComponent(), (int)this.popupPoint.getX(), (int)this.popupPoint.getY());
        }
    }

    private void jListTaxaMousePressed(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.popupPoint = evt.getPoint();
        }
    }

    private void jMenuItemDeleteSelectedActionPerformed(ActionEvent evt) {
        int[] selection = this.jListTaxa.getSelectedIndices();
        String msg = "Really remove";
        msg = selection.length > 1 ? msg + " these " + selection.length + " taxa " : msg + " this taxon ";
        if (JOptionPane.showConfirmDialog(this, msg = msg + " from group?", this.getTitle(), 0, 2) != 0) {
            return;
        }
        LinkedList<TaxonListMember> toDelete = new LinkedList<TaxonListMember>();
        for (int i = selection.length - 1; i >= 0; --i) {
            TaxonListMember taxon = (TaxonListMember)this.taxaModel.get(selection[i]);
            toDelete.add(taxon);
        }
        LinkedList<Taxon> toDeleteTaxa = new LinkedList<Taxon>();
        for (TaxonListMember element : toDelete) {
            toDeleteTaxa.add(element.taxon);
        }
        this.deleteTaxa(toDeleteTaxa);
        for (TaxonListMember taxon : toDelete) {
            this.taxaModel.removeElement(taxon);
        }
        ListDataListener[] ldl = this.taxaModel.getListDataListeners();
        if (ldl.length > 0) {
            ldl[ldl.length - 1].contentsChanged(null);
        }
    }

    private void formInternalFrameActivated(InternalFrameEvent evt) {
        this.jPanelGroups.setSelectedGroup(this.group);
    }

    private void jListTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            Taxon taxon = ((TaxonListMember)this.taxaModel.get((int)this.jListTaxa.getSelectedIndex())).taxon;
            try {
                Container parent = this.getParent();
                while (!(parent instanceof FrameTaxaDB)) {
                    if ((parent = parent.getParent()) != null) continue;
                    throw new IllegalStateException("No TaxaDB container parent in InternalFrameGroup");
                }
                DialogTaxon dialog = new DialogTaxon((FrameTaxaDB)parent, true, this.db, taxon, false);
                dialog.setLocationRelativeTo(this.getParent());
                dialog.setVisible(true);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error opening Taxon dialog", sql, this.db);
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
    }

    private void jListTaxaKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jMenuItemDeleteSelectedActionPerformed(null);
        }
    }
}

