/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.GroupsTableModel;
import jsbugs.InternalFrameGroup;
import model2.SBChart;
import model2.SBdb;
import model2.TxGroup;
import org.jdesktop.layout.GroupLayout;
import util.ColorEditor;
import util.ColorRenderer;
import util.SB;
import util.SBException;
import util.TableSorter;

public class InternalFrameGroups
extends JInternalFrame
implements Observer {
    SBdb sbdb;
    FrameTaxaDB parent;
    GroupsTableModel modelGroup = new GroupsTableModel();
    TableSorter sorter = new TableSorter((TableModel)this.modelGroup);
    private JButton jButtonAddGroup;
    private JButton jButtonDeleteGroup;
    private JButton jButtonEdit;
    private JButton jButtonEditGroup;
    private JScrollPane jScrollPane1;
    private JTable jTableGroup;

    public InternalFrameGroups(FrameTaxaDB parent, SBdb db) throws SBException, SQLException {
        this.initComponents();
        this.parent = parent;
        this.sbdb = db;
        this.init();
    }

    @Override
    public void update(Observable obs, Object obj) {
        System.out.println("In update method for internal grame groups");
        if (obs.getClass() == TxGroup.class) {
            System.out.println("In update method for internal frame groups - 2");
            this.sorter.reallocateIndexes();
            this.sorter.sort((Object)this);
            this.jTableGroup.updateUI();
        } else if (obj.getClass() == TxGroup.class) {
            try {
                this.modelGroup.groups.clear();
                this.modelGroup.groups.addAll(this.sbdb.getTxGroups());
                Collections.sort(this.modelGroup.groups);
                for (TxGroup group : this.modelGroup.groups) {
                    group.addObserver((Observer)this);
                }
                this.sorter.reallocateIndexes();
                this.sorter.sort((Object)this);
                this.jTableGroup.updateUI();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void init() throws SBException, SQLException {
        for (int i = 0; i < this.modelGroup.getColumnCount(); ++i) {
            this.jTableGroup.getColumnModel().getColumn(i).setHeaderValue(GroupsTableModel.columnTitles[i]);
            this.jTableGroup.getColumnModel().getColumn(i).setPreferredWidth(GroupsTableModel.columnWidths[i]);
        }
        ColorEditor.setUpColorEditor((JTable)this.jTableGroup);
        SB.setTableHeaderBold((JTable)this.jTableGroup);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableGroup);
        this.jTableGroup.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
        this.modelGroup.groups.addAll(this.sbdb.getTxGroups());
        Collections.sort(this.modelGroup.groups);
        for (TxGroup group : this.modelGroup.groups) {
            group.addObserver((Observer)this);
        }
        this.sbdb.addObserver((Observer)this);
        this.sorter.reallocateIndexes();
        this.jTableGroup.updateUI();
    }

    private int getRowOf(Object o) {
        for (int i = 0; i < this.modelGroup.groups.size(); ++i) {
            if (this.modelGroup.groups.get(this.sorter.getIndexOf(i)) != o) continue;
            return i;
        }
        return -1;
    }

    TxGroup getSelectedGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            return null;
        }
        return this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
    }

    void editGroupColour() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            Color colour = JColorChooser.showDialog(this, "Select Group Colour", group.getColour());
            if (!colour.equals(group.getColour())) {
                group.setColour(colour);
                this.sbdb.commit();
                group.notifyObservers();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableGroup = new JTable();
        this.jButtonAddGroup = new JButton();
        this.jButtonEditGroup = new JButton();
        this.jButtonDeleteGroup = new JButton();
        this.jButtonEdit = new JButton();
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Groups");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon/TaxaInternalFrameIcon.gif")));
        this.setMinimumSize(new Dimension(323, 300));
        this.jTableGroup.setModel((TableModel)this.sorter);
        this.jTableGroup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameGroups.this.jTableGroupMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableGroup);
        this.jButtonAddGroup.setText("Add...");
        this.jButtonAddGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroups.this.jButtonAddGroupActionPerformed(evt);
            }
        });
        this.jButtonEditGroup.setText("Edit name...");
        this.jButtonEditGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroups.this.jButtonEditGroupActionPerformed(evt);
            }
        });
        this.jButtonDeleteGroup.setText("Delete");
        this.jButtonDeleteGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroups.this.jButtonDeleteGroupActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameGroups.this.jButtonEditActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAddGroup).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonEditGroup).addPreferredGap(0).add((Component)this.jButtonDeleteGroup)).add((Component)this.jScrollPane1, -1, 298, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 359, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonAddGroup).add((Component)this.jButtonEdit).add((Component)this.jButtonEditGroup).add((Component)this.jButtonDeleteGroup)).addContainerGap()));
        this.pack();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        this.editGroup();
    }

    private void jTableGroupMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteGroupActionPerformed(ActionEvent evt) {
        this.deleteGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to delete", this.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            if (JOptionPane.showConfirmDialog(this, "Really delete group: " + group.getName(), this.getTitle(), 0, 3) != 0) {
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Check charts for this group?", this.parent.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                LinkedList<SBChart> groupCharts = new LinkedList<SBChart>();
                LinkedList charts = new LinkedList();
                SBChart.load((SBdb)this.sbdb, charts, (String)"%");
                for (SBChart chart : charts) {
                    chart.loadData();
                    if (!chart.hasGroup(group.getID())) continue;
                    groupCharts.add(chart);
                }
                if (!groupCharts.isEmpty()) {
                    DialogList dialog = new DialogList((Frame)null, true, "Charts containing group: " + group.toString(), this.sbdb, groupCharts, false, false);
                    dialog.setVisible(true);
                    return;
                }
            }
            this.sbdb.deleteTxGroup(group);
            this.sbdb.commit();
            this.jTableGroup.clearSelection();
            this.modelGroup.groups.remove(group);
            this.sorter.reallocateIndexes();
            this.sorter.sort((Object)this);
            this.jTableGroup.updateUI();
            this.parent.removeInternalFrameGroup(group);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void addGroup() throws SQLException, SBException {
        String name = JOptionPane.showInputDialog(this, (Object)"Name");
        if (name == null) {
            return;
        }
        if (this.sbdb.getTxGroup(name) != null) {
            JOptionPane.showMessageDialog(this, "A group of that name already exists", this.getTitle(), 2);
            return;
        }
        TxGroup group = this.sbdb.addTxGroup(name, null, -1);
        this.sbdb.commit();
        this.modelGroup.groups.add(group);
        group.addObserver((Observer)this);
        this.jTableGroup.clearSelection();
        this.sorter.reallocateIndexes();
        this.sorter.sort((Object)this);
        this.jTableGroup.updateUI();
        int index = this.getRowOf(group);
        this.jTableGroup.setRowSelectionInterval(index, index);
        this.jTableGroup.scrollRectToVisible(this.jTableGroup.getCellRect(index, 0, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            InternalFrameGroup frame = this.parent.getGroupFrame(group);
            if (frame != null) {
                frame.setIcon(false);
                frame.setVisible(true);
                frame.setLocation(50, 50);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.parent.createInternalFrameGroup(group);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void editGroupName() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            String newName = JOptionPane.showInputDialog(this, "Name", group.getName());
            if (newName == null) {
                return;
            }
            if (!newName.equals(group.getName())) {
                group.setName(newName);
                this.sbdb.commit();
                this.jTableGroup.clearSelection();
                group.notifyObservers();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonAddGroupActionPerformed(ActionEvent evt) {
        try {
            this.addGroup();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonEditGroupActionPerformed(ActionEvent evt) {
        this.editGroupName();
    }
}

