/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.sql.SQLException;
import java.util.List;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.ChartPanel;
import jsbugs.DialogCmpStdEvent;
import jsbugs.DialogList;
import jsbugs.DialogSchemeBlock;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.DialogUnit;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.InternalFrameChart;
import jsbugs.JScrollPaneChart;
import jsbugs.PanelAgeScale;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelIGDScheme;
import jsbugs.SBDialog;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.AgeCurve;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class InternalFrameIGDSchemeChart
extends InternalFrameChart {
    private final SBdb db;
    private final FrameInterpretations parentFrame;
    private Color copiedColour;
    private final JLabel jLabelChartSize = new JLabel();
    private JButton jButtonPrint;
    private JButton jButtonProperties;
    private JButton jButtonSaveAs;
    private JButton jButtonSelectScheme;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JMenuItem jMenuItemCopyColour;
    private JMenuItem jMenuItemPanelProperties;
    private JMenuItem jMenuItemPasteColour;
    private JMenuItem jMenuItemRemovePanel;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPaneChart;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparatorPopup;
    private JToolBar jToolBar1;

    public InternalFrameIGDSchemeChart(FrameInterpretations parent, SBdb db, CompositeStandard[] std, IGDScheme[] schemes) throws SQLException {
        super(new ChartJPanel(null));
        this.initComponents();
        this.db = db;
        this.parentFrame = parent;
        super.init((JScrollPaneChart)this.jScrollPaneChart);
        this.init(schemes, std);
    }

    private void init(IGDScheme[] schemes, CompositeStandard[] std) throws SQLException {
        this.setTitle(this.getFrameTitle());
        Chart chart = new Chart();
        chart.chartProperties.setPanelHeaderHeight(80.0f);
        chart.chartProperties.margin = 5.0f;
        SchemeBlock block = new SchemeBlock();
        PanelAgeScale agePanel = new PanelAgeScale(block, false);
        block.addPanel(agePanel);
        if (std != null) {
            for (CompositeStandard compositeStandard : std) {
                block.addCompositeStandard(compositeStandard, this.db);
                compositeStandard.addObserver((Observer)this.chartJPanel);
            }
        }
        if (schemes != null) {
            for (CompositeStandard compositeStandard : schemes) {
                block.addScheme((IGDScheme)compositeStandard);
                compositeStandard.addObserver((Observer)this.chartJPanel);
            }
        }
        chart.blocks.add(block);
        this.chartJPanel.chart = chart;
        this.chartJPanel.setSize(this.chartJPanel.zoom);
        this.chartJPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameIGDSchemeChart.this.mClicked(evt);
            }
        });
        this.initChartSizeLabel();
    }

    private void initChartSizeLabel() {
        this.jToolBar1.add(Box.createHorizontalGlue());
        this.jToolBar1.add(this.jLabelChartSize);
        this.jToolBar1.add(Box.createHorizontalStrut(5));
        this.jLabelChartSize.setForeground(Color.LIGHT_GRAY);
        this.setChartSizeLabel();
    }

    void setChartSizeLabel() {
        this.jLabelChartSize.setText((int)Math.floor(this.chartJPanel.chart.getMMwidth()) + " x " + (int)Math.floor(this.chartJPanel.chart.getMMheight()) + " mm");
    }

    @Override
    String getFrameTitle() {
        return "Stratigraphic Schemes";
    }

    @Override
    void initChart(ChartBlock block) {
        super.initChart(block);
        this.setChartSizeLabel();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemCopyColour = new JMenuItem();
        this.jMenuItemPasteColour = new JMenuItem();
        this.jSeparatorPopup = new JPopupMenu.Separator();
        this.jMenuItemRemovePanel = new JMenuItem();
        this.jMenuItemPanelProperties = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonProperties = new JButton();
        this.jButtonSelectScheme = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonPrint = new JButton();
        this.jButtonSaveAs = new JButton();
        this.jScrollPaneChart = new JScrollPaneChart(this.chartJPanel);
        this.jMenuItemCopyColour.setText("Copy unit colour");
        this.jMenuItemCopyColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jMenuItemCopyColourActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemCopyColour);
        this.jMenuItemPasteColour.setText("Paste unit colour");
        this.jMenuItemPasteColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jMenuItemPasteColourActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemPasteColour);
        this.jPopupMenu1.add(this.jSeparatorPopup);
        this.jMenuItemRemovePanel.setText("Remove panel");
        this.jMenuItemRemovePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jMenuItemRemovePanelActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemRemovePanel);
        this.jMenuItemPanelProperties.setText("Panel properties...");
        this.jMenuItemPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jMenuItemPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemPanelProperties);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Stratigraphic Schemes");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_SchemeTab.png")));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                InternalFrameIGDSchemeChart.this.formInternalFrameClosed(evt);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMargin(new Insets(8, 2, 2, 2));
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomIn16.png")));
        this.jButtonZoomIn.setBorderPainted(false);
        this.jButtonZoomIn.setFocusable(false);
        this.jButtonZoomIn.setHorizontalTextPosition(0);
        this.jButtonZoomIn.setOpaque(false);
        this.jButtonZoomIn.setVerticalTextPosition(3);
        this.jButtonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomOut16.png")));
        this.jButtonZoomOut.setBorderPainted(false);
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.setHorizontalTextPosition(0);
        this.jButtonZoomOut.setVerticalTextPosition(3);
        this.jButtonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonProperties.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ChartProperties16.png")));
        this.jButtonProperties.setToolTipText("Chart properties");
        this.jButtonProperties.setFocusable(false);
        this.jButtonProperties.setHorizontalTextPosition(0);
        this.jButtonProperties.setMaximumSize(new Dimension(23, 25));
        this.jButtonProperties.setVerticalTextPosition(3);
        this.jButtonProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonProperties);
        this.jButtonSelectScheme.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_SchemeTab.png")));
        this.jButtonSelectScheme.setToolTipText("Select schemes...");
        this.jButtonSelectScheme.setFocusable(false);
        this.jButtonSelectScheme.setHorizontalTextPosition(0);
        this.jButtonSelectScheme.setVerticalTextPosition(3);
        this.jButtonSelectScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSelectScheme);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Print16.png")));
        this.jButtonPrint.setToolTipText("Print chart...");
        this.jButtonPrint.setBorderPainted(false);
        this.jButtonPrint.setFocusable(false);
        this.jButtonPrint.setHorizontalTextPosition(0);
        this.jButtonPrint.setMaximumSize(new Dimension(23, 27));
        this.jButtonPrint.setMinimumSize(new Dimension(23, 27));
        this.jButtonPrint.setVerticalTextPosition(3);
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrint);
        this.jButtonSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Export16.png")));
        this.jButtonSaveAs.setToolTipText("Export chart as PDF/vector image...");
        this.jButtonSaveAs.setBorder(null);
        this.jButtonSaveAs.setFocusable(false);
        this.jButtonSaveAs.setHorizontalTextPosition(0);
        this.jButtonSaveAs.setMaximumSize(new Dimension(23, 27));
        this.jButtonSaveAs.setMinimumSize(new Dimension(23, 27));
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemeChart.this.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSaveAs);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPaneChart).add((Component)this.jToolBar1, -1, 561, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPaneChart, -1, 610, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void formInternalFrameClosed(InternalFrameEvent evt) {
        this.parentFrame.frameSchemeChart = null;
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        this.chartProperties();
        this.setChartSizeLabel();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        try {
            this.printChart(this.db, this.parentFrame);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDType typeDialog = new DialogSelectIGDType((Frame)this.parentFrame, true, false);
            typeDialog.setLocationRelativeTo(this);
            typeDialog.setVisible(true);
            if (!typeDialog.isOK()) {
                return;
            }
            int igdType = typeDialog.igdType;
            IGDScheme igdScheme = null;
            CompositeStandard cmps = null;
            AgeCurve ageCurve = null;
            if (igdType < 0) {
                if (!this.chartJPanel.chart.getAddSchemeBlock().addAgeScale()) {
                    JOptionPane.showMessageDialog(this, "Block already has an age scale panel", "Add scale", 1);
                }
                this.chartJPanel.repaint();
                return;
            }
            if (igdType == 20) {
                DialogSelectCmpStd dialog = new DialogSelectCmpStd((Frame)this.parentFrame, true, this.db, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    cmps = dialog.selection;
                }
            } else if (igdType == 25) {
                List ageCurves = this.db.getAgeCurves();
                DialogList dialog = new DialogList(this.parentFrame, true, "Select Age Curve", this.db, ageCurves, true, false);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    ageCurve = (AgeCurve)dialog.selection;
                }
            } else {
                DialogSelectScheme dialog = new DialogSelectScheme((Frame)this.parentFrame, true, this.db, igdType);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    igdScheme = dialog.selection;
                }
            }
            this.parentFrame.drawScheme(new CompositeStandard[]{cmps}, new IGDScheme[]{igdScheme}, ageCurve);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        try {
            this.exportChart(this.db, this.parentFrame);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemPanelPropertiesActionPerformed(ActionEvent evt) {
        this.panelProperties(this.db, this.parentFrame, null);
        this.setChartSizeLabel();
    }

    private void jMenuItemRemovePanelActionPerformed(ActionEvent evt) {
        ChartPanel panel = this.getPanel(this.getPopupPoint());
        if (panel != null && panel instanceof SBPanel) {
            this.chartJPanel.chart.getAddSchemeBlock().removePanel(panel);
            this.chartJPanel.repaint();
        }
    }

    private void jMenuItemCopyColourActionPerformed(ActionEvent evt) {
        Object o = this.chartJPanel.getObject(this.getPopupPoint());
        if (o != null && o instanceof IGDUnit) {
            this.copiedColour = ((IGDUnit)o).getColour();
            int d = 10;
            BufferedImage bufferedImage = new BufferedImage(d, d, 1);
            Graphics2D g = bufferedImage.createGraphics();
            AffineTransform tnf = new AffineTransform();
            tnf.scale(0.01f, 0.01f);
            g.transform(tnf);
            SBGraphics sbg = new SBGraphics(g, null, true, true);
            sbg.setColor(this.copiedColour);
            sbg.fillRect(0.0f, 0.0f, d, d);
            ImageIcon icon = new ImageIcon(bufferedImage);
            this.jMenuItemPasteColour.setIcon(icon);
        }
    }

    private void jMenuItemPasteColourActionPerformed(ActionEvent evt) {
        if (this.copiedColour == null) {
            return;
        }
        Object o = this.chartJPanel.getObject(this.getPopupPoint());
        if (o != null && o instanceof IGDUnit) {
            IGDUnit unit = (IGDUnit)o;
            try {
                unit.setColour(this.copiedColour);
                this.db.commit();
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            this.chartJPanel.repaint();
        }
    }

    private void mClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            ChartPanel panel = this.getPanel(evt.getPoint());
            Object o = this.chartJPanel.getObject(evt);
            Window dialog = null;
            if (o != null) {
                if (o instanceof IGDUnit && panel instanceof PanelIGDScheme) {
                    dialog = new DialogUnit(this.parentFrame, true, ((PanelIGDScheme)panel).getScheme(), (IGDUnit)o);
                } else if (o instanceof CompositeStandardEvent && panel instanceof PanelCompositeStandard) {
                    dialog = new DialogCmpStdEvent(this.parentFrame, true, this.db, ((PanelCompositeStandard)panel).getStd(), (CompositeStandardEvent)o, null);
                }
                if (dialog != null) {
                    dialog.setLocationRelativeTo(this);
                    ((Dialog)dialog).setVisible(true);
                    this.chartJPanel.repaint();
                }
            }
        }
    }

    @Override
    void mReleasedPopup(MouseEvent evt) {
        Object o = this.chartJPanel.getObject(evt);
        if (o instanceof IGDUnit) {
            this.jMenuItemCopyColour.setVisible(true);
            this.jMenuItemPasteColour.setVisible(this.copiedColour != null);
            this.jSeparatorPopup.setVisible(true);
        } else {
            this.jMenuItemCopyColour.setVisible(false);
            this.jMenuItemPasteColour.setVisible(false);
            this.jSeparatorPopup.setVisible(false);
        }
        this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    @Override
    SBDialog getPropertiesDialog() {
        SchemeBlock block = this.chartJPanel.chart.getAddSchemeBlock();
        if (block != null) {
            return new DialogSchemeBlock(this.parentFrame, true, block, this.db, this.chartJPanel.chart.chartProperties);
        }
        return null;
    }
}

