/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbugs.DialogCmpStd;
import jsbugs.DialogEventXLSReader;
import jsbugs.DialogIGDHdrOccs;
import jsbugs.DialogIGDScheme;
import jsbugs.DialogList;
import jsbugs.DialogMatchAnalysts;
import jsbugs.DialogMatchCmpStd;
import jsbugs.DialogMatchEvents;
import jsbugs.DialogMatchIGDScheme;
import jsbugs.DialogMatchTaxa;
import jsbugs.DialogRecalibrate;
import jsbugs.DialogSchemeUsage;
import jsbugs.DialogSearchUnit;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.SbugsMLdocument;
import model2.CompositeStandard;
import model2.DEXFile;
import model2.EventXLSReader;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDSchemeXLSReader;
import model2.Lastval;
import model2.SBdb;
import model2.SequenceXLSReader;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.jdesktop.layout.GroupLayout;
import org.jdom.Document;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class InternalFrameIGDSchemes
extends JInternalFrame
implements Observer {
    SBdb db;
    DefaultListModel model = new DefaultListModel();
    DefaultComboBoxModel typeModel = new DefaultComboBoxModel();
    static String SELECT_TYPE = "<select>";
    static String ALL_TYPES = "All types";
    static String CMPSTD_TYPE = "Composite Standards";
    boolean inStartup = true;
    JCheckBoxMenuItem menuCheckBox = null;
    FrameInterpretations parent;
    private JButton jButton3;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonDraw;
    private JButton jButtonEdit;
    private JButton jButtonFindUnit;
    private JButton jButtonHelp;
    private JButton jButtonRead;
    private JButton jButtonRecalibrate;
    private JButton jButtonUsage;
    private JButton jButtonWrite;
    private JComboBox jComboBoxIGDType;
    private JLabel jLabel1;
    private JList jListSchemes;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;

    public InternalFrameIGDSchemes(FrameInterpretations parent, SBdb db, JCheckBoxMenuItem menuCheckBox) {
        this.db = db;
        this.menuCheckBox = menuCheckBox;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.db.addObserver((Observer)this);
        this.setTitle("Stratigraphic Schemes");
        this.model.removeAllElements();
        this.typeModel.removeAllElements();
        this.typeModel.addElement(SELECT_TYPE);
        this.typeModel.addElement(ALL_TYPES);
        this.typeModel.addElement(IGDInterval.getIGDName((int)3));
        this.typeModel.addElement(IGDInterval.getIGDName((int)2));
        this.typeModel.addElement(IGDInterval.getIGDName((int)4));
        this.typeModel.addElement(IGDInterval.getIGDName((int)10));
        this.typeModel.addElement(CMPSTD_TYPE);
        this.jComboBoxIGDType.repaint();
        this.inStartup = false;
    }

    @Override
    public void update(Observable obs, Object o) {
        if (obs.getClass() == SBdb.class && o != null && (o instanceof IGDScheme || o instanceof CompositeStandard)) {
            this.refreshList();
        } else if (obs instanceof IGDScheme || obs instanceof CompositeStandard) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalFrameIGDSchemes.this.jListSchemes.repaint();
                }
            });
        }
    }

    private void refreshList() {
        String type = this.jComboBoxIGDType.getSelectedItem().toString();
        try {
            Collection stds;
            Collection coll = null;
            LinkedList<Object> list = new LinkedList<Object>();
            if (type.equals(ALL_TYPES)) {
                coll = this.db.getIGDSchemes(3);
                if (coll != null) {
                    for (IGDScheme iGDScheme : coll) {
                        list.add(iGDScheme);
                        iGDScheme.addObserver((Observer)this);
                    }
                }
                if ((coll = this.db.getIGDSchemes(2)) != null) {
                    for (IGDScheme iGDScheme : coll) {
                        list.add(iGDScheme);
                        iGDScheme.addObserver((Observer)this);
                    }
                }
                if ((coll = this.db.getIGDSchemes(4)) != null) {
                    for (IGDScheme iGDScheme : coll) {
                        list.add(iGDScheme);
                        iGDScheme.addObserver((Observer)this);
                    }
                }
                coll = this.db.getIGDSchemes(10);
            } else if (type.equals(IGDInterval.getIGDName((int)3))) {
                coll = this.db.getIGDSchemes(3);
            } else if (type.equals(IGDInterval.getIGDName((int)2))) {
                coll = this.db.getIGDSchemes(2);
            } else if (type.equals(IGDInterval.getIGDName((int)4))) {
                coll = this.db.getIGDSchemes(4);
            } else if (type.equals(IGDInterval.getIGDName((int)10))) {
                coll = this.db.getIGDSchemes(10);
            }
            if (coll != null) {
                for (IGDScheme iGDScheme : coll) {
                    list.add(iGDScheme);
                    iGDScheme.addObserver((Observer)this);
                }
            }
            if ((type.equals(ALL_TYPES) || type.equals(CMPSTD_TYPE)) && (stds = this.db.getCompositeStandards()) != null) {
                for (CompositeStandard std : stds) {
                    list.add(std);
                }
            }
            Collections.sort(list);
            this.model.removeAllElements();
            for (Object e : list) {
                this.model.addElement(e);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalFrameIGDSchemes.this.jListSchemes.repaint();
                }
            });
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jButton3 = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxIGDType = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jListSchemes = new JList();
        this.jButtonClose = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonUsage = new JButton();
        this.jButtonDraw = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonWrite = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonRecalibrate = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.jSeparator6 = new JSeparator();
        this.jButtonFindUnit = new JButton();
        this.jButton3.setText("jButton3");
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_SchemeTab.png")));
        this.setMinimumSize(new Dimension(400, 400));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                InternalFrameIGDSchemes.this.formInternalFrameClosing(evt);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jLabel1.setText("Type: ");
        this.jComboBoxIGDType.setModel(this.typeModel);
        this.jComboBoxIGDType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jComboBoxIGDTypeActionPerformed(evt);
            }
        });
        this.jListSchemes.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSchemes.setModel(this.model);
        this.jListSchemes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameIGDSchemes.this.jListSchemesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListSchemes);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit ...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonUsage.setText("Show wells...");
        this.jButtonUsage.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonUsageActionPerformed(evt);
            }
        });
        this.jButtonDraw.setText("Plot...");
        this.jButtonDraw.setToolTipText("Draw selected schemes in separate window");
        this.jButtonDraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonDrawActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonWrite.setText("Write...");
        this.jButtonWrite.setToolTipText("Export selected scheme(s) to XML file");
        this.jButtonWrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonWriteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonRecalibrate.setText("Recalibrate...");
        this.jButtonRecalibrate.setToolTipText("change ages on scheme boundaries to new chronostratigraphic scheme");
        this.jButtonRecalibrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonRecalibrateActionPerformed(evt);
            }
        });
        this.jButtonFindUnit.setText("Find unit...");
        this.jButtonFindUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameIGDSchemes.this.jButtonFindUnitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxIGDType, 0, -1, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 288, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonAdd, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonUsage, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonDraw, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonRead, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonWrite, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonRecalibrate, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, 99, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, 99, Short.MAX_VALUE).add((Component)this.jSeparator4).add((Component)this.jSeparator5).add((Component)this.jSeparator6).add((Component)this.jButtonFindUnit, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonDelete, this.jButtonDraw, this.jButtonEdit, this.jButtonRead, this.jButtonRecalibrate, this.jButtonUsage, this.jButtonWrite}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxIGDType, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonUsage).addPreferredGap(0).add((Component)this.jButtonDraw).addPreferredGap(0).add((Component)this.jSeparator5, -2, 10, -2).addPreferredGap(1).add((Component)this.jButtonRead).addPreferredGap(0).add((Component)this.jButtonWrite).add(8, 8, 8).add((Component)this.jSeparator6, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonRecalibrate).addPreferredGap(1).add((Component)this.jButtonFindUnit).addPreferredGap(0, 161, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 524, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.menuCheckBox.setSelected(false);
        this.setVisible(false);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String type = this.jComboBoxIGDType.getSelectedItem().toString();
        if (type.equals(ALL_TYPES) || type.equals(SELECT_TYPE)) {
            JOptionPane.showMessageDialog(this, "Select the scheme type from the drop-down list", this.getTitle(), 2);
            return;
        }
        try {
            if (type.equals(CMPSTD_TYPE)) {
                DialogCmpStd dialog = new DialogCmpStd((Frame)this.parent, true, this.db, null);
                SB.centreDialog((Dialog)dialog);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.refreshList();
                    dialog.cmpStdAdded.addObserver((Observer)this);
                    this.jListSchemes.setSelectedValue(dialog.cmpStdAdded, true);
                }
            } else {
                int igdType = IGDIntervalZone.getIGDType((String)type);
                if (igdType > 0) {
                    DialogIGDScheme dialog = new DialogIGDScheme(this.parent, true, this.db, null, igdType);
                    SB.centreDialog((Dialog)dialog);
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        this.refreshList();
                        dialog.schemeAdded.addObserver((Observer)this);
                        this.jListSchemes.setSelectedValue(dialog.schemeAdded, true);
                    }
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading scheme: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jComboBoxIGDTypeActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        if (!this.parent.parent.checkRLMlicence()) {
            JOptionPane.showMessageDialog(this.parent, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.parent.dispose();
            return;
        }
        this.typeModel.removeElement(SELECT_TYPE);
        this.refreshList();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        Object scheme = this.jListSchemes.getSelectedValue();
        try {
            if (scheme instanceof IGDScheme) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                DialogIGDScheme dialog = new DialogIGDScheme(this.parent, true, this.db, (IGDScheme)scheme, 0);
                dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                SB.centreDialog((Dialog)dialog);
                dialog.setVisible(true);
                this.setCursor(Cursor.getDefaultCursor());
            } else {
                DialogCmpStd dialog = new DialogCmpStd((Frame)this.parent, true, this.db, (CompositeStandard)scheme);
                SB.centreDialog((Dialog)dialog);
                dialog.setVisible(true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error loading scheme: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
        this.refreshList();
    }

    private void formInternalFrameClosing(InternalFrameEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jListSchemesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValues().length == 0) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 2);
            return;
        }
        LinkedList<Object> objects = new LinkedList<Object>();
        objects.addAll(Arrays.asList(this.jListSchemes.getSelectedValues()));
        for (Object e : objects) {
            try {
                String msg;
                IGDScheme scheme;
                if (e instanceof IGDScheme) {
                    scheme = (IGDScheme)e;
                    String msg2 = "";
                    int occs = scheme.getNoccs();
                    if (occs > 0) {
                        JOptionPane.showMessageDialog(this, "You cannot delete '" + scheme + "' because it occurs " + occs + " times in wells.", this.getTitle(), 2);
                        return;
                    }
                    int nHdrs = scheme.getNHdrOccs();
                    if (nHdrs > 0) {
                        DialogIGDHdrOccs dialog = new DialogIGDHdrOccs((Frame)this.parent, true, this.db, scheme);
                        dialog.setLocationRelativeTo(this);
                        dialog.setVisible(true);
                        if (!dialog.isOK()) {
                            if (dialog.selectedWell != null) {
                                try {
                                    this.setCursor(Cursor.getPredefinedCursor(3));
                                    this.parent.parent.setSamplesWell(this.db.getAddWell(dialog.selectedWell.getWellID()));
                                }
                                catch (SBException sbe) {
                                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                                }
                                catch (SQLException sql) {
                                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                                }
                                catch (RuntimeException re) {
                                    SB.showStackError((String)"", (Exception)re);
                                }
                                finally {
                                    this.setCursor(Cursor.getDefaultCursor());
                                }
                            }
                            return;
                        }
                    }
                    if (JOptionPane.showConfirmDialog(this, msg2 + "Really delete scheme: " + scheme + "?", this.getTitle(), 0, 3) != 0) continue;
                    this.db.deleteIGDScheme(scheme);
                    this.db.commit();
                    scheme.notifyObservers();
                    scheme.deleteObservers();
                    this.model.removeElement(scheme);
                    continue;
                }
                scheme = (CompositeStandard)e;
                int nOcc = scheme.getNoccs();
                String string = nOcc > 0 ? "Warning: this composite is preferred for " + nOcc + " LOC" + (nOcc > 1 ? "s" : "") + ".\n" : (msg = "");
                if (JOptionPane.showConfirmDialog(this, msg = msg + "Really delete '" + scheme.getName() + "'?", this.getTitle(), 0, 2) != 0) continue;
                this.db.deleteCompositeStandard((CompositeStandard)scheme);
                this.db.commit();
                scheme.notifyObservers();
                scheme.deleteObservers();
                this.model.removeElement(scheme);
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonUsageActionPerformed(ActionEvent evt) {
        Object object = this.jListSchemes.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(this, "No scheme selected", this.getTitle(), 1);
            return;
        }
        Window dialog = null;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (object instanceof IGDScheme) {
                IGDScheme scheme = (IGDScheme)object;
                List occs = scheme.getOccs();
                if (occs == null || occs.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Scheme does not occur in any wells or outcrops.", scheme.toString(), 1);
                } else {
                    dialog = new DialogSchemeUsage((Frame)this.parent, true, scheme);
                }
            } else {
                CompositeStandard scheme = (CompositeStandard)object;
                List occs = scheme.getOccs();
                if (occs == null || occs.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "Composite does not occur in any wells or outcrops.", scheme.toString(), 1);
                } else {
                    dialog = new DialogList(this.parent, true, scheme.toString(), this.db, occs, false, false);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(this.parent);
            ((Dialog)dialog).setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDrawActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select scheme (s)", this.getTitle(), 2);
            return;
        }
        Object[] schemes = this.jListSchemes.getSelectedValues();
        try {
            int nIGDSchemes = 0;
            int nCmp = 0;
            for (Object o : schemes) {
                if (o instanceof IGDScheme) {
                    ++nIGDSchemes;
                    continue;
                }
                ++nCmp;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            IGDScheme[] igdSchemes = new IGDScheme[nIGDSchemes];
            CompositeStandard[] cmps = new CompositeStandard[nCmp];
            int ni = 0;
            int nc = 0;
            for (int i = 0; i < schemes.length; ++i) {
                if (schemes[i] instanceof IGDScheme) {
                    igdSchemes[ni++] = (IGDScheme)schemes[i];
                    continue;
                }
                cmps[nc++] = (CompositeStandard)schemes[i];
            }
            this.parent.drawScheme(cmps, igdSchemes, null);
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        this.read();
    }

    private void jButtonWriteActionPerformed(ActionEvent evt) {
        if ((this.db.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", this.getTitle(), 2);
            return;
        }
        this.writeXML();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("framestratigraphicschemes.html");
    }

    private void jButtonRecalibrateActionPerformed(ActionEvent evt) {
        if (this.jListSchemes.getSelectedValue() == null || this.jListSchemes.getSelectedIndices().length > 1) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        Object obj = this.jListSchemes.getSelectedValue();
        if (!(obj instanceof IGDScheme) && !(obj instanceof CompositeStandard)) {
            JOptionPane.showMessageDialog(this, "Only zonation schemes and composite standards supported.", this.getTitle(), 2);
            return;
        }
        try {
            IGDScheme scheme;
            if (obj instanceof IGDScheme && (scheme = (IGDScheme)obj).getIGDType() == 3) {
                JOptionPane.showMessageDialog(this, "You can't recalibrate a chronostratigraphy scheme.", this.getTitle(), 2);
                return;
            }
            DialogRecalibrate dialog = new DialogRecalibrate((Frame)this.parent, true, this.db, obj);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.refreshList();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonFindUnitActionPerformed(ActionEvent evt) {
        DialogSearchUnit dialog = new DialogSearchUnit((Frame)this.parent, true, this.db, null);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Scheme files (dex,xml,xls)", "dex", "xml", "xls", "xlsx");
        jFileChooser.setFileFilter(filter);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"JXMLFILE"));
        }
        catch (SQLException SQL) {
            // empty catch block
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                File file = jFileChooser.getSelectedFile();
                String fileName = file.getPath();
                try {
                    Lastval.putString((SBdb)this.db, (String)"JXMLFILE", (String)fileName);
                    this.db.commit();
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                String fileType = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase().trim();
                if (fileType.equals("dex")) {
                    this.readDEX(fileName);
                } else if (fileType.equals("xml")) {
                    this.readXML(file);
                } else if (fileType.equals("xls") || fileType.equals("xlsx")) {
                    this.readXLS(file);
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void readXLS(File file) {
        String type = (String)this.jComboBoxIGDType.getSelectedItem();
        if (type.equals(SELECT_TYPE) || type.equals(ALL_TYPES)) {
            JOptionPane.showMessageDialog(this, "Select a scheme type", "Read Scheme", 2);
        } else if (type.equals(CMPSTD_TYPE)) {
            this.readXLSEvents(file);
        } else if (type.equals(IGDInterval.getIGDName((int)10))) {
            this.readXLSSequence(file);
        } else {
            this.readXLSUnits(IGDInterval.getIGDType((String)type), file);
        }
    }

    private void readXLSUnits(int igdType, File file) {
        try {
            SBdb ws = new SBdb();
            IGDSchemeXLSReader.read((SBdb)ws, (File)file, (int)igdType, (boolean)true);
            for (IGDScheme scheme : ws.getIGDSchemes(igdType)) {
                DialogMatchIGDScheme dialog = new DialogMatchIGDScheme((Frame)this.parent, true, scheme, this.db);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (Exception re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void readXLSSequence(File file) {
        try {
            SBdb ws = new SBdb();
            SequenceXLSReader.read((SBdb)ws, (File)file);
            for (IGDScheme scheme : ws.getIGDSchemes(10)) {
                DialogMatchIGDScheme dialog = new DialogMatchIGDScheme((Frame)this.parent, true, scheme, this.db);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (Exception re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void readXLSEvents(File file) {
        String style = "Expecting 2 column format: 'top/base Event name', 'age' ";
        try {
            SBdb ws = new SBdb();
            DialogEventXLSReader dialog = new DialogEventXLSReader(this.parent, true, this.db, ws, file);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                EventXLSReader reader = dialog.getReader();
                reader.getEvents(ws);
                DialogMatchEvents dialogMatchEvents = new DialogMatchEvents((Frame)this.parent, true, ws, this.db);
                dialogMatchEvents.setLocationRelativeTo(this);
                dialogMatchEvents.setVisible(true);
                if (dialogMatchEvents.isOK()) {
                    LinkedList exceptions = new LinkedList();
                    CompositeStandard std = reader.getCompositeStandard(exceptions);
                    if (exceptions.size() > 0) {
                        DialogList dialogl = new DialogList(this.parent, true, "Events not added to composite", this.db, exceptions, false, false);
                        dialogl.setLocationRelativeTo(this);
                        dialogl.setVisible(true);
                    }
                    DialogMatchCmpStd matchdialog = new DialogMatchCmpStd((Frame)this.parent, true, std, this.db);
                    matchdialog.setLocationRelativeTo(this);
                    matchdialog.setVisible(true);
                    this.refreshList();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error reading file:\n" + ioe.getMessage(), "Read File", 0);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error processing file.\nExpecting 2 column format: 'top/base Event name', 'age' ", (Exception)((Object)sbe));
        }
        catch (InvalidFormatException ife) {
            JOptionPane.showMessageDialog(this, "Error reading file:\n" + ife.getMessage() + "\n" + "Expecting 2 column format: 'top/base Event name', 'age' ", "Read File", 0);
        }
        catch (IllegalStateException ise) {
            JOptionPane.showMessageDialog(this, "Error reading file:\n" + ise.getMessage() + "\n" + "Expecting 2 column format: 'top/base Event name', 'age' ", "Read File", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXML(File file) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        SBdb ws = null;
        try {
            ws = new SBdb();
            Document xmlDocument = SbugsMLdocument.getXmlDocument(file);
            LinkedList dTypes = new LinkedList();
            ws.parseXMLDocument(xmlDocument, dTypes, null, "");
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (Exception e) {
            SB.showStackError((String)"Error reading file", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        System.out.println("File read successful...");
        try {
            if (!ws.getUsers().isEmpty()) {
                DialogMatchAnalysts dialog = new DialogMatchAnalysts((Frame)this.parent, true, ws, this.db);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
            }
            int[] igdTypes = new int[]{3, 2, 4, 10};
            for (int i = 0; i < igdTypes.length; ++i) {
                for (IGDScheme scheme : ws.getIGDSchemes(igdTypes[i])) {
                    DialogMatchIGDScheme dialog = new DialogMatchIGDScheme((Frame)this.parent, true, scheme, this.db);
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                }
            }
            if (ws.hasTaxa()) {
                DialogMatchTaxa dialog = new DialogMatchTaxa(this.parent, true, ws, this.db, true);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    return;
                }
            }
            if (ws.hasEvents()) {
                DialogMatchEvents dialogMatchEvents = new DialogMatchEvents((Frame)this.parent, true, ws, this.db);
                dialogMatchEvents.setLocationRelativeTo(this.parent);
                dialogMatchEvents.setVisible(true);
                if (!dialogMatchEvents.isOK()) {
                    return;
                }
            }
            if (!ws.getCompositeStandards().isEmpty()) {
                for (CompositeStandard std : ws.getCompositeStandards()) {
                    std.excludeEvents(ws);
                    DialogMatchCmpStd dialog = new DialogMatchCmpStd((Frame)this.parent, true, std, this.db);
                    dialog.setLocationRelativeTo(this.parent);
                    dialog.setVisible(true);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void readDEX(String filePath) {
        try {
            int[] igdTypes;
            SBdb ws = new SBdb();
            LinkedList schemes = new LinkedList();
            LinkedList dTypes = new LinkedList();
            DEXFile reader = new DEXFile(ws, this.db.getUser(), filePath, dTypes, null, 0);
            for (int igdType : igdTypes = new int[]{3, 2, 4, 10}) {
                schemes.addAll(ws.getIGDSchemes(igdType));
            }
            if (schemes.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No schemes found in file", "IGD Scheme", 2);
                return;
            }
            IGDScheme selectedScheme = null;
            if (schemes.size() > 1) {
                DialogList dialog = new DialogList(this.parent, true, "Select Scheme", this.db, schemes, true, false);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                selectedScheme = (IGDScheme)dialog.selection;
            } else {
                selectedScheme = (IGDScheme)schemes.get(0);
            }
            IGDScheme duplicate = this.db.getIGDScheme(selectedScheme.toString(), selectedScheme.getIGDType());
            if (duplicate != null) {
                JOptionPane.showMessageDialog(this, "A scheme of that name already exists", "IGD Scheme", 2);
                return;
            }
            this.db.addIGDScheme(IGDScheme.copyToDatabase((SBdb)this.db, (IGDScheme)selectedScheme));
            this.db.notifyObservers((Object)selectedScheme);
            this.db.commit();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error reading DEC file", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXML() {
        if (this.jListSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select scheme(s)", this.getTitle(), 2);
            return;
        }
        Object[] schemes = this.jListSchemes.getSelectedValues();
        JFileChooser jFileChooserXML = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("xml");
        filter.setDescription("XML files");
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"JXMLFILE"));
        }
        catch (SQLException SQL) {
            // empty catch block
        }
        try {
            jFileChooserXML.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        jFileChooserXML.setFileFilter((FileFilter)filter);
        if (schemes.length == 1) {
            jFileChooserXML.setSelectedFile(new File(schemes[0].toString()));
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (0 == jFileChooserXML.showSaveDialog(this)) {
                if (jFileChooserXML.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                File file = jFileChooserXML.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith("xml")) {
                    file = new File(file.getPath() + ".xml");
                }
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
                SBdb ws = new SBdb();
                for (int i = 0; i < schemes.length; ++i) {
                    Object o = schemes[i];
                    if (o instanceof CompositeStandard) {
                        CompositeStandard cmpStd = (CompositeStandard)o;
                        ws.fillCompositeStandard(cmpStd);
                        continue;
                    }
                    if (!(o instanceof IGDScheme)) continue;
                    IGDScheme scheme = (IGDScheme)o;
                    ws.addIGDScheme(IGDScheme.copyToWorkspace((SBdb)ws, (IGDScheme)scheme));
                }
                LinkedList dTypes = new LinkedList();
                ws.writeXML(out, dTypes, this.db, null);
                Lastval.putString((SBdb)this.db, (String)"JXMLFILE", (String)file.getPath());
                this.db.commit();
            }
        }
        catch (IOException se) {
            JOptionPane.showMessageDialog(this.parent, se.getMessage(), "IGD Scheme", 2);
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parent, ex.getMessage(), "IGD Scheme", 0);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

