/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.ChartPanel;
import jsbugs.DialogCmpStdEvent;
import jsbugs.DialogRangeChart;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.InternalFrameChart;
import jsbugs.JScrollPaneChart;
import jsbugs.PanelAgeScale;
import jsbugs.PanelRange;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import jsbugs.TaxonTransferHandler;
import model2.CompositeStandardEvent;
import model2.SBEvent;
import model2.SBdb;
import model2.Taxon;
import util.SB;
import util.SBException;

public class InternalFrameRangeChart
extends InternalFrameChart
implements DragGestureListener {
    static final int TEMP_ID = 6;
    final FrameTaxaDB parent;
    private final SBdb sbdb;
    boolean cancel = false;
    private CompositeStandardEvent dragOriginEvent = null;
    private Point2D.Float lastDragPoint;
    private Taxon txDragOrigin = null;
    String lastAgeString = null;
    private JButton jButtonExport;
    private JButton jButtonPrint;
    private JButton jButtonProperties;
    private JButton jButtonRedo;
    private JButton jButtonSort;
    private JButton jButtonUndo;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JMenuItem jMenuItemPanelProperties;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPaneChart;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JToggleButton jToggleButtonFreezeHeader;
    private JToolBar jToolBar1;

    public InternalFrameRangeChart(FrameTaxaDB parent, SBdb sbdb) {
        super(new ChartJPanel(null));
        this.setTransferHandler(new TaxonTransferHandler(null));
        this.chartJPanel.undoManager = new UndoManager();
        this.chartJPanel.undoSupport = new UndoableEditSupport();
        this.initComponents();
        this.sbdb = sbdb;
        this.parent = parent;
        super.init((JScrollPaneChart)this.jScrollPaneChart);
        this.init();
    }

    private void init() {
        JScrollPaneChart jspc = (JScrollPaneChart)this.jScrollPaneChart;
        jspc.registerDragRecognizer(this);
        jspc.addJPanelMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                InternalFrameRangeChart.this.mDragged(evt);
            }
        });
        jspc.addJPanelMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameRangeChart.this.mClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                InternalFrameRangeChart.this.mReleased(evt);
            }
        });
        Chart chart = this.initChartSaved();
        if (chart == null) {
            SchemeBlock block = new SchemeBlock();
            block.addPanel(new PanelAgeScale(block, false));
            block.addPanel(new PanelRange(this.sbdb, block));
            this.initChart(block);
        } else {
            this.chartJPanel.chart = chart;
            chart.blocks.get(0).addObserver(this.chartJPanel);
            this.chartJPanel.setSize(this.chartJPanel.zoom);
        }
        DialogRangeChart dialog = new DialogRangeChart((Frame)this.parent, true, this.sbdb, this.chartJPanel.chart);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            this.cancel = true;
            return;
        }
        this.setTitle();
    }

    PanelRange getPanelRange() {
        for (SBPanel panel : this.getSchemeBlock().panels) {
            if (!(panel instanceof PanelRange)) continue;
            return (PanelRange)panel;
        }
        return null;
    }

    public SchemeBlock getSchemeBlock() {
        for (ChartBlock block : this.chartJPanel.chart.blocks) {
            if (!(block instanceof SchemeBlock)) continue;
            return (SchemeBlock)block;
        }
        return null;
    }

    @Override
    SBDialog getPropertiesDialog() {
        return new DialogRangeChart((Frame)this.parent, true, this.sbdb, this.chartJPanel.chart);
    }

    @Override
    public void undoRedo(boolean undo) {
        UndoManager undoManager = this.chartJPanel.undoManager;
        if (undoManager == null || undo && !undoManager.canUndo() || !undo && !undoManager.canRedo()) {
            this.getToolkit().beep();
            return;
        }
        if (undo) {
            undoManager.undo();
        } else {
            undoManager.redo();
        }
        this.chartJPanel.repaint();
        this.setUndoTooltips();
    }

    void setUndoTooltips() {
        this.jButtonUndo.setToolTipText(this.getUndoTooltip(true));
        this.jButtonRedo.setToolTipText(this.getUndoTooltip(false));
    }

    private String getUndoTooltip(boolean undo) {
        UndoManager manager = this.chartJPanel.getUndoManager();
        if (manager == null) {
            return null;
        }
        if (undo) {
            return manager.getUndoPresentationName() + " (Ctrl + Z)";
        }
        return manager.getRedoPresentationName() + " (Ctrl + Shift + Z)";
    }

    private void setTitle() {
        this.setTitle(this.getFrameTitle());
    }

    @Override
    String getFrameTitle() {
        return "Stratigraphic Range Chart : " + this.getPanelRange().getProperties().std;
    }

    @Override
    public void zoom(boolean in) {
        ((JScrollPaneChart)this.jScrollPaneChart).zoom(in);
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemPanelProperties = new JMenuItem();
        this.jScrollPaneChart = new JScrollPaneChart(this.chartJPanel);
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jToggleButtonFreezeHeader = new JToggleButton();
        this.jButtonProperties = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButtonPrint = new JButton();
        this.jButtonExport = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonUndo = new JButton();
        this.jButtonRedo = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonSort = new JButton();
        this.jMenuItemPanelProperties.setText("Panel properties...");
        this.jMenuItemPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jMenuItemPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemPanelProperties);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/InternalFrameRangeChart.png")));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomIn16.png")));
        this.jButtonZoomIn.setToolTipText("Zoom in");
        this.jButtonZoomIn.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jButtonZoomIn.setFocusable(false);
        this.jButtonZoomIn.setHorizontalTextPosition(0);
        this.jButtonZoomIn.setVerticalTextPosition(3);
        this.jButtonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomOut16.png")));
        this.jButtonZoomOut.setToolTipText("Zoom out");
        this.jButtonZoomOut.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.setHorizontalTextPosition(0);
        this.jButtonZoomOut.setVerticalTextPosition(3);
        this.jButtonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        this.jToolBar1.add(this.jSeparator1);
        this.jToggleButtonFreezeHeader.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_FreezePanes16.png")));
        this.jToggleButtonFreezeHeader.setToolTipText("Freeze header");
        this.jToggleButtonFreezeHeader.setFocusable(false);
        this.jToggleButtonFreezeHeader.setHorizontalTextPosition(0);
        this.jToggleButtonFreezeHeader.setVerticalTextPosition(3);
        this.jToggleButtonFreezeHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jToggleButtonFreezeHeaderActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonFreezeHeader);
        this.jButtonProperties.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ChartProperties16.png")));
        this.jButtonProperties.setToolTipText("Chart properties");
        this.jButtonProperties.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jButtonProperties.setFocusable(false);
        this.jButtonProperties.setHorizontalTextPosition(0);
        this.jButtonProperties.setVerticalTextPosition(3);
        this.jButtonProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonProperties);
        this.jToolBar1.add(this.jSeparator4);
        this.jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Print16.png")));
        this.jButtonPrint.setToolTipText("Print chart...");
        this.jButtonPrint.setFocusable(false);
        this.jButtonPrint.setHorizontalTextPosition(0);
        this.jButtonPrint.setVerticalTextPosition(3);
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrint);
        this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Export16.png")));
        this.jButtonExport.setToolTipText("Export chart as vector image...");
        this.jButtonExport.setFocusable(false);
        this.jButtonExport.setHorizontalTextPosition(0);
        this.jButtonExport.setVerticalTextPosition(3);
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonExportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonExport);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonUndo.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Undo16.png")));
        this.jButtonUndo.setFocusable(false);
        this.jButtonUndo.setHorizontalTextPosition(0);
        this.jButtonUndo.setVerticalTextPosition(3);
        this.jButtonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonUndoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonUndo);
        this.jButtonRedo.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/redo16.png")));
        this.jButtonRedo.setFocusable(false);
        this.jButtonRedo.setHorizontalTextPosition(0);
        this.jButtonRedo.setVerticalTextPosition(3);
        this.jButtonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonRedoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonRedo);
        this.jToolBar1.add(this.jSeparator3);
        this.jButtonSort.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Restore16.png")));
        this.jButtonSort.setToolTipText("Re-sort events");
        this.jButtonSort.setFocusable(false);
        this.jButtonSort.setHorizontalTextPosition(0);
        this.jButtonSort.setVerticalTextPosition(3);
        this.jButtonSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameRangeChart.this.jButtonSortActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonSort);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneChart, -1, 669, Short.MAX_VALUE).addComponent(this.jToolBar1, -1, 669, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneChart, -1, 626, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        this.chartProperties();
    }

    private void jButtonUndoActionPerformed(ActionEvent evt) {
        this.undoRedo(true);
    }

    private void jButtonRedoActionPerformed(ActionEvent evt) {
        this.undoRedo(false);
    }

    private void jButtonSortActionPerformed(ActionEvent evt) {
        this.getPanelRange().createEventList(this.getSchemeBlock().prop);
        this.chartJPanel.repaint();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        try {
            this.printChart(this.sbdb, this.parent);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        try {
            this.exportChart(this.sbdb, this.parent);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemPanelPropertiesActionPerformed(ActionEvent evt) {
        this.panelProperties(this.sbdb, this.parent, SchemeBlock.getPrefKey(6));
    }

    private void jToggleButtonFreezeHeaderActionPerformed(ActionEvent evt) {
        ((JScrollPaneChart)this.jScrollPaneChart).setHeader(this.jToggleButtonFreezeHeader.isSelected());
        this.chartJPanel.setSize();
    }

    @Override
    public void mMoved(MouseEvent evt) {
        if (this.dragOriginEvent == null) {
            Object obj = this.chartJPanel.getObject(evt);
            if (obj instanceof CompositeStandardEvent) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        ((JScrollPaneChart)this.jScrollPaneChart).setToolTipText(evt);
    }

    private void mDragged(MouseEvent evt) {
        try {
            if (((JScrollPaneChart)this.jScrollPaneChart).isHeaderEvent(evt.getComponent())) {
                return;
            }
            Point2D pTemp = this.chartJPanel.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.chartJPanel.chart.getSelectedPanel(mmPoint);
            if (panel != null && panel instanceof PanelRange) {
                PanelRange panelRange = (PanelRange)panel;
                Point2D.Float panelOrigin = this.chartJPanel.chart.getPanelOrigin(panelRange, true, this.chartJPanel.getMode(), 0.0f);
                if (this.dragOriginEvent == null) {
                    Object o = ((JScrollPaneChart)this.jScrollPaneChart).getObject(evt);
                    if (o instanceof CompositeStandardEvent) {
                        CompositeStandardEvent cse;
                        this.dragOriginEvent = cse = (CompositeStandardEvent)o;
                    }
                    if (this.dragOriginEvent != null) {
                        this.setCursor(SB.getDragMoveCursor());
                    }
                } else {
                    Graphics g = this.chartJPanel.getGraphics();
                    AffineTransform tf = this.chartJPanel.setRubberBandMode(g);
                    double age = SB.round((double)panelRange.getAge(mmPoint.y - panelOrigin.y, this.getSchemeBlock().prop), (int)this.getRounding());
                    String ageString = age + " Ma";
                    if (age < (double)this.getSchemeBlock().prop.max && age > (double)this.getSchemeBlock().prop.min) {
                        if (this.lastDragPoint != null && this.lastAgeString != null) {
                            this.chartJPanel.drawString(g, this.lastDragPoint, this.lastAgeString);
                        }
                        this.chartJPanel.drawString(g, mmPoint, ageString);
                        this.lastDragPoint = mmPoint;
                        this.lastAgeString = ageString;
                    }
                    this.chartJPanel.clearRubberBandMode(g, tf);
                }
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mClicked(MouseEvent evt) {
        if (((JScrollPaneChart)this.jScrollPaneChart).isHeaderEvent(evt.getComponent())) {
            return;
        }
        if (evt.getClickCount() > 1) {
            try {
                Point2D pTemp = this.chartJPanel.getPoint(evt.getPoint());
                Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
                Window dialog = null;
                Object obj = this.chartJPanel.getObject(evt);
                ChartPanel panel = this.chartJPanel.chart.getSelectedPanel(mmPoint);
                if (panel instanceof PanelRange) {
                    PanelRange rangePanel = (PanelRange)panel;
                    if (obj instanceof CompositeStandardEvent) {
                        CompositeStandardEvent event = (CompositeStandardEvent)obj;
                        dialog = new DialogCmpStdEvent(this.parent, true, this.sbdb, rangePanel.getComposite(), event, null);
                    } else if (obj instanceof PanelRange.EventRange) {
                        PanelRange.EventRange er = (PanelRange.EventRange)obj;
                        if (er.singleAge == null) {
                            boolean addBase = true;
                            if (er.minAge == null && er.maxAge != null || er.minAge != null && er.maxAge == null) {
                                if (er.minAge == null) {
                                    addBase = false;
                                }
                                double csu = rangePanel.getComposite().getCSU(rangePanel.getAge((float)mmPoint.getY() - this.chartJPanel.chart.chartProperties.getPanelHeaderHeight() - this.chartJPanel.chart.chartProperties.margin, this.getSchemeBlock().prop));
                                if (addBase && csu > er.minAge.getCSU() || !addBase && csu < er.maxAge.getCSU()) {
                                    dialog = new DialogCmpStdEvent(this.parent, true, this.sbdb, rangePanel.getComposite(), null, new CompositeStandardEvent.Builder().event(er.event).type(addBase ? SBEvent.EventType.BASE : SBEvent.EventType.TOP).csu(SB.round((double)csu, (int)this.getRounding())));
                                }
                            }
                        }
                    }
                }
                if (dialog != null) {
                    dialog.setLocationRelativeTo(this.parent);
                    ((Dialog)dialog).setVisible(true);
                    if (dialog instanceof DialogCmpStdEvent && ((DialogCmpStdEvent)dialog).isOK()) {
                        this.sbdb.commit();
                    }
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
            finally {
                this.getPanelRange().refreshEvents();
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mReleased(MouseEvent evt) {
        try {
            Point2D pTemp;
            Point2D.Float mmPoint;
            ChartPanel panel;
            if (this.dragOriginEvent != null && (panel = this.chartJPanel.chart.getSelectedPanel(mmPoint = new Point2D.Float((float)(pTemp = this.chartJPanel.getPoint(evt.getPoint())).getX(), (float)pTemp.getY()))) instanceof PanelRange) {
                Point2D.Float panelOrigin = this.chartJPanel.chart.getPanelOrigin((PanelRange)panel, true, this.chartJPanel.getMode(), 0.0f);
                if (mmPoint.getY() > ((Point2D)panelOrigin).getY() && mmPoint.getY() < ((Point2D)panelOrigin).getY() + (double)this.getSchemeBlock().getHeight()) {
                    PanelRange panelRange = (PanelRange)panel;
                    try {
                        this.doEdit(panelRange.updateEvent(this.dragOriginEvent, (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.getSchemeBlock().prop, this.getRounding()));
                    }
                    catch (SBException sbe) {
                        if (sbe.getMessage().startsWith("Can't update event: ")) {
                            JOptionPane.showMessageDialog(this.parent, sbe.getMessage(), "Update event", 2);
                        }
                        throw sbe;
                    }
                } else {
                    System.out.println("No longer in Range panel");
                }
                this.lastDragPoint = null;
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error updating event", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error updating event", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.dragOriginEvent = null;
            this.repaint();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Object o;
        Point pTemp;
        Point2D.Float mmPoint;
        ChartPanel panel;
        Cursor cursor = null;
        if (dge.getDragAction() == 2) {
            cursor = DragSource.DefaultCopyDrop;
        }
        if ((panel = this.chartJPanel.chart.getSelectedPanel(mmPoint = new Point2D.Float((float)(((Point2D)(pTemp = dge.getDragOrigin())).getX() / 2.8346457481384277 / (double)this.chartJPanel.zoom), (float)(((Point2D)pTemp).getY() / 2.8346457481384277 / (double)this.chartJPanel.zoom)))) != null && panel instanceof PanelRange && (o = ((JScrollPaneChart)this.jScrollPaneChart).getObject(dge)) instanceof PanelRange.EventRange) {
            PanelRange.EventRange er = (PanelRange.EventRange)o;
            if (er.event.getTaxon() != null) {
                this.txDragOrigin = er.event.getTaxon();
                TaxonTransferHandler h = (TaxonTransferHandler)this.getTransferHandler();
                dge.startDrag(cursor, h.createTransferable(this));
            }
        }
        this.txDragOrigin = null;
    }

    @Override
    void mReleasedPopup(MouseEvent evt) {
        this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    private int getRounding() {
        double ageRes = this.chartJPanel.zoom / 2.0f * 2.8346457f * this.chartJPanel.chart.blockProperties.scale * 10.0f;
        int round = (int)Math.log10(ageRes);
        return round;
    }

    private void doEdit(UndoableEdit edit) {
        if (edit != null) {
            this.chartJPanel.undoManager.addEdit(edit);
            this.chartJPanel.undoSupport.postEdit(edit);
            this.setUndoTooltips();
            this.repaint();
        }
    }

    public Taxon getTxDragOrigin() {
        return this.txDragOrigin;
    }

    Chart initChartSaved() {
        String sql = "SELECT pref_key, pref_value from " + this.sbdb.DBTableName("PREF_USER") + " where user_id=" + this.sbdb.getUser().getUsrID() + " AND pref_key like(" + SB.DBString((String)"C6%") + ")";
        try {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            LinkedList<Chart.ChartPref> keys = new LinkedList<Chart.ChartPref>();
            while (rs.next()) {
                String key = rs.getString("pref_key");
                String value = rs.getString("pref_value");
                keys.add(new Chart.ChartPref(key, value));
            }
            if (keys.isEmpty()) {
                return null;
            }
            Chart chart = new Chart(keys, this.sbdb, -1, null);
            if (chart.blocks.get(0) == null || !(chart.blocks.get(0) instanceof SchemeBlock)) {
                return null;
            }
            return chart;
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error loading saved depth/age chart", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        return null;
    }
}

