/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsbugs.DialogSet;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import model2.SBdb;
import model2.TxGroupSet;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class InternalFrameSets
extends JInternalFrame
implements Observer {
    FrameTaxaDB parent;
    SBdb sbdb;
    DefaultListModel setModel = new DefaultListModel();
    private JButton jButtonAddSet;
    private JButton jButtonDeleteSet;
    private JButton jButtonEditSet;
    private JList jListSets;
    private JPanel jPanelSets;
    private JScrollPane jScrollPane3;

    @Override
    public void update(Observable obs, Object obj) {
        if (obs.getClass() == TxGroupSet.class || obj != null && obj.getClass() == TxGroupSet.class) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalFrameSets.this.jListSets.updateUI();
                }
            });
        }
    }

    public InternalFrameSets(FrameTaxaDB parent, SBdb db) throws SBException, SQLException {
        this.parent = parent;
        this.sbdb = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        for (TxGroupSet set : this.sbdb.getTxGroupSets()) {
            this.setModel.addElement(set);
            set.addObserver((Observer)this);
        }
        this.sbdb.addObserver((Observer)this);
        this.jListSets.repaint();
    }

    private void initComponents() {
        this.jPanelSets = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jListSets = new JList();
        this.jButtonAddSet = new JButton();
        this.jButtonEditSet = new JButton();
        this.jButtonDeleteSet = new JButton();
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Sets");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon/InternalFrameSetsIcon.gif")));
        this.setMinimumSize(new Dimension(230, 200));
        this.jListSets.setModel(this.setModel);
        this.jListSets.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameSets.this.jListSetsMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListSets);
        this.jButtonAddSet.setText("Add...");
        this.jButtonAddSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSets.this.jButtonAddSetActionPerformed(evt);
            }
        });
        this.jButtonEditSet.setText("Edit...");
        this.jButtonEditSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSets.this.jButtonEditSetActionPerformed(evt);
            }
        });
        this.jButtonDeleteSet.setText("Delete");
        this.jButtonDeleteSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSets.this.jButtonDeleteSetActionPerformed(evt);
            }
        });
        GroupLayout jPanelSetsLayout = new GroupLayout((Container)this.jPanelSets);
        this.jPanelSets.setLayout((LayoutManager)jPanelSetsLayout);
        jPanelSetsLayout.setHorizontalGroup((GroupLayout.Group)jPanelSetsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSetsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSetsLayout.createParallelGroup(2, false).add(1, (Component)this.jScrollPane3, 0, 0, Short.MAX_VALUE).add(1, (GroupLayout.Group)jPanelSetsLayout.createSequentialGroup().add((Component)this.jButtonAddSet).addPreferredGap(0).add((Component)this.jButtonEditSet).addPreferredGap(0).add((Component)this.jButtonDeleteSet))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSetsLayout.setVerticalGroup((GroupLayout.Group)jPanelSetsLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelSetsLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -2, 345, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanelSetsLayout.createParallelGroup(3).add((Component)this.jButtonAddSet).add((Component)this.jButtonEditSet).add((Component)this.jButtonDeleteSet)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelSets, -2, -1, -2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelSets, -2, -1, -2));
        this.pack();
    }

    private TxGroupSet getSelected() {
        TxGroupSet set = (TxGroupSet)this.jListSets.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this, "No set selected", this.getTitle(), 2);
        }
        return set;
    }

    private void jButtonEditSetActionPerformed(ActionEvent evt) {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            DialogSet dialog = new DialogSet((Frame)this.parent, true, this.sbdb, set);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.jListSets.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
    }

    private void jButtonAddSetActionPerformed(ActionEvent evt) {
        try {
            DialogSet dialog = new DialogSet((Frame)this.parent, true, this.sbdb, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.set != null) {
                this.setModel.addElement(dialog.set);
                this.jListSets.repaint();
                this.jListSets.setSelectedValue(dialog.set, true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
    }

    private void jButtonDeleteSetActionPerformed(ActionEvent evt) {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete set: " + set + "?", this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            this.sbdb.deleteTxGroupSet(set);
            this.setModel.removeElement(set);
            this.jListSets.updateUI();
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jListSetsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditSetActionPerformed(null);
        }
    }
}

