/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartActions;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.DialogSubsidenceChart;
import jsbugs.FrameInterpretations;
import jsbugs.FrameJsbugs;
import jsbugs.InternalFrameChart;
import jsbugs.JScrollPaneChart;
import jsbugs.PanelDepth;
import jsbugs.PanelWellDepthAge;
import jsbugs.PanelWellDepthAgeProperties;
import jsbugs.ProjectBlock;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import model2.Project;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class InternalFrameSubsidence
extends InternalFrameChart
implements ChartActions {
    private final SBdb sbdb;
    private final FrameInterpretations parentFrame;
    static final int TEMP_ID = 5;
    boolean cancel = false;
    private JButton jButtonExport;
    private JButton jButtonPrint;
    private JButton jButtonProperties;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JMenuItem jMenuItemPanelProperties;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPaneChart;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToggleButton jToggleButtonFreezeHeader;
    private JToolBar jToolBar1;

    public InternalFrameSubsidence(FrameInterpretations parent, SBdb db) throws SQLException, SBException {
        super(new ChartJPanel(null));
        this.initComponents();
        this.sbdb = db;
        this.parentFrame = parent;
        super.init((JScrollPaneChart)this.jScrollPaneChart);
        this.init();
    }

    private void init() throws SQLException, SBException {
        Chart chart = this.initChartSaved();
        if (chart == null) {
            System.out.println("Didn't init saved chart");
            ProjectBlock block = new ProjectBlock(null, this.sbdb, null);
            block.prop.scaleType = BlockProperties.ScaleType.TVD;
            block.addPanel(new PanelDepth(this.sbdb, block));
            PanelWellDepthAgeProperties prop = new PanelWellDepthAgeProperties(this.sbdb, true);
            PanelWellDepthAge panelSubsidence = new PanelWellDepthAge(this.sbdb, block, prop);
            block.addPanel(panelSubsidence);
            this.initChart(block);
            chart = this.chartJPanel.chart;
        } else {
            this.chartJPanel.chart = chart;
            this.chartJPanel.setSize(this.chartJPanel.zoom);
        }
        DialogSubsidenceChart dialog = new DialogSubsidenceChart((Frame)this.parentFrame, true, this.sbdb, chart);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            this.cancel = true;
            return;
        }
        this.setTitle(this.getFrameTitle());
    }

    private PanelWellDepthAge getSubsidencePanel() {
        ProjectBlock pb = this.getProjectBlock();
        if (pb == null) {
            return null;
        }
        for (SBPanel panel : pb.panels) {
            if (!(panel instanceof PanelWellDepthAge)) continue;
            return (PanelWellDepthAge)panel;
        }
        return null;
    }

    private ProjectBlock getProjectBlock() {
        for (ChartBlock block : this.chartJPanel.chart.blocks) {
            if (!(block instanceof ProjectBlock)) continue;
            return (ProjectBlock)block;
        }
        return null;
    }

    private Chart initChartSaved() {
        String sql = "SELECT pref_key, pref_value from " + this.sbdb.DBTableName("PREF_USER") + " where user_id=" + this.sbdb.getUser().getUsrID() + " AND pref_key like(" + SB.DBString((String)"C5%") + ")";
        try {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            LinkedList<Chart.ChartPref> keys = new LinkedList<Chart.ChartPref>();
            while (rs.next()) {
                String key = rs.getString("pref_key");
                String value = rs.getString("pref_value");
                keys.add(new Chart.ChartPref(key, value));
            }
            if (keys.isEmpty()) {
                return null;
            }
            Collections.sort(keys);
            String IDstring = ((Chart.ChartPref)keys.getFirst()).key.substring(2, 6);
            int ID = Integer.parseInt(IDstring);
            if (ID == 0) {
                System.out.println("ID String: " + IDstring);
                return null;
            }
            Project project = this.sbdb.getProject(ID);
            if (project == null) {
                return null;
            }
            project.loadWells(this.sbdb, null);
            Chart chart = new Chart(keys, this.sbdb, project.getID(), null);
            if (chart.blocks.get(0) == null || !(chart.blocks.get(0) instanceof ProjectBlock)) {
                return null;
            }
            return chart;
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error loading saved depth/age chart", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        return null;
    }

    @Override
    String getFrameTitle() {
        return "Subsidence Curves : " + ((ProjectBlock)this.chartJPanel.chart.blocks.get(0)).getProject().toString();
    }

    @Override
    void mReleasedPopup(MouseEvent evt) {
        this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    @Override
    public void zoom(boolean in) {
        ((JScrollPaneChart)this.jScrollPaneChart).zoom(in);
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemPanelProperties = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonProperties = new JButton();
        this.jToggleButtonFreezeHeader = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonPrint = new JButton();
        this.jButtonExport = new JButton();
        this.jScrollPaneChart = new JScrollPaneChart(this.chartJPanel);
        this.jMenuItemPanelProperties.setText("Panel properties...");
        this.jMenuItemPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSubsidence.this.jMenuItemPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemPanelProperties);
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Subsidence Curves");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/InternalFrameSubsidence.png")));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                InternalFrameSubsidence.this.formInternalFrameClosed(evt);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomIn16.png")));
        this.jButtonZoomIn.setToolTipText("Zoom in");
        this.jButtonZoomIn.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jButtonZoomIn.setHorizontalTextPosition(0);
        this.jButtonZoomIn.setOpaque(false);
        this.jButtonZoomIn.setVerticalTextPosition(3);
        this.jButtonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSubsidence.this.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomOut16.png")));
        this.jButtonZoomOut.setToolTipText("Zoom out");
        this.jButtonZoomOut.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.setHorizontalTextPosition(0);
        this.jButtonZoomOut.setVerticalTextPosition(3);
        this.jButtonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSubsidence.this.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        this.jToolBar1.add(this.jSeparator1);
        this.jButtonProperties.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ChartProperties16.png")));
        this.jButtonProperties.setToolTipText("Chart properties");
        this.jButtonProperties.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jButtonProperties.setFocusable(false);
        this.jButtonProperties.setHorizontalTextPosition(0);
        this.jButtonProperties.setVerticalTextPosition(3);
        this.jButtonProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSubsidence.this.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonProperties);
        this.jToggleButtonFreezeHeader.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FreezePanes16.png")));
        this.jToggleButtonFreezeHeader.setToolTipText("Freeze header");
        this.jToggleButtonFreezeHeader.setFocusable(false);
        this.jToggleButtonFreezeHeader.setHorizontalTextPosition(0);
        this.jToggleButtonFreezeHeader.setVerticalTextPosition(3);
        this.jToggleButtonFreezeHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSubsidence.this.jToggleButtonFreezeHeaderActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonFreezeHeader);
        this.jToolBar1.add(this.jSeparator2);
        this.jButtonPrint.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Print16.png")));
        this.jButtonPrint.setToolTipText("Print chart");
        this.jButtonPrint.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jButtonPrint.setBorderPainted(false);
        this.jButtonPrint.setFocusable(false);
        this.jButtonPrint.setHorizontalTextPosition(0);
        this.jButtonPrint.setVerticalTextPosition(3);
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSubsidence.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonPrint);
        this.jButtonExport.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Export16.png")));
        this.jButtonExport.setToolTipText("Export chart as vector image");
        this.jButtonExport.setFocusable(false);
        this.jButtonExport.setHorizontalTextPosition(0);
        this.jButtonExport.setVerticalTextPosition(3);
        this.jButtonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameSubsidence.this.jButtonExportActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonExport);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jToolBar1, -1, 625, Short.MAX_VALUE).add((Component)this.jScrollPaneChart, -1, 625, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, -1, -2).addPreferredGap(0).add((Component)this.jScrollPaneChart, -1, 493, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void formInternalFrameClosed(InternalFrameEvent evt) {
        this.parentFrame.frameSubsidence = null;
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        this.chartProperties();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        try {
            this.printChart(this.sbdb, this.parentFrame);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        try {
            this.exportChart(this.sbdb, this.parentFrame);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemPanelPropertiesActionPerformed(ActionEvent evt) {
        boolean save = this.panelProperties(this.sbdb, this.parentFrame, null);
        if (save) {
            try {
                String prefKey = this.getProjectBlock().getPrefKey(5);
                this.chartJPanel.chart.savePreference(this.sbdb, prefKey);
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error saving chart", sql, this.sbdb);
            }
        }
    }

    private void jToggleButtonFreezeHeaderActionPerformed(ActionEvent evt) {
        ((JScrollPaneChart)this.jScrollPaneChart).setHeader(this.jToggleButtonFreezeHeader.isSelected());
        this.chartJPanel.setSize();
    }

    @Override
    SBDialog getPropertiesDialog() {
        try {
            return new DialogSubsidenceChart((Frame)this.parentFrame, true, this.sbdb, this.chartJPanel.chart);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        return null;
    }
}

