/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.DialogEditOccurrences;
import jsbugs.DialogList;
import jsbugs.DialogMergeTaxa;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogSelectTaxaAdv;
import jsbugs.DialogSelectTaxaAdvDict;
import jsbugs.DialogSelectTaxaCode;
import jsbugs.DialogSynonymy;
import jsbugs.DialogTaxon;
import jsbugs.DialogTaxonCode;
import jsbugs.DialogTaxonImages;
import jsbugs.DialogTaxonNotes;
import jsbugs.DialogTaxonWellOcc;
import jsbugs.DialogWellDisc;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.TaxonTableModel;
import jsbugs.TaxonTransferHandler;
import jsbugs.WebSearch;
import model2.SBdb;
import model2.SynonymScheme;
import model2.Taxon;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.BareBonesBrowserLaunch;
import util.SB;
import util.SBException;
import util.TableSorter;

public class InternalFrameTaxa
extends JInternalFrame
implements Observer {
    SBdb sbdb;
    TaxonTableModel modelTaxa = new TaxonTableModel(true);
    TableSorter sorterTaxa = new TableSorter((TableModel)this.modelTaxa);
    FrameTaxaDB parent;
    List<Taxon> cacheList = null;
    private ButtonGroup buttonGroupSelection;
    private JButton jButtonClear;
    private JButton jButtonSelectAll;
    private JComboBox jComboBoxSynonymScheme;
    private JLabel jLabel1;
    private JMenuItem jMenuItemCodes;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemEdit;
    private JMenuItem jMenuItemEditOccs;
    private JMenuItem jMenuItemGroupMembership;
    private JMenuItem jMenuItemImages;
    private JMenuItem jMenuItemRefNotes;
    private JMenuItem jMenuItemSearch;
    private JMenuItem jMenuItemSearchWell;
    private JMenuItem jMenuItemSynonymy;
    private JMenuItem jMenuItemWebLookup;
    private JPanel jPanelTaxa;
    private JPopupMenu jPopupMenuTaxon;
    private JScrollPane jScrollPane4;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JTable jTableTaxa;

    public InternalFrameTaxa(FrameTaxaDB parent, SBdb db) {
        this.parent = parent;
        this.sbdb = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.modelTaxa.setupTable(this.jTableTaxa, this.sorterTaxa, true, this.sbdb);
        this.sorterTaxa.reallocateIndexes();
        this.sbdb.addObserver((Observer)this);
        this.modelTaxa.taxa = new LinkedList<Taxon>();
        this.jComboBoxSynonymScheme.removeAllItems();
        try {
            for (SynonymScheme s : this.sbdb.getSynSchemes()) {
                this.jComboBoxSynonymScheme.addItem(s);
            }
        }
        catch (Exception e) {
            this.jComboBoxSynonymScheme.setEnabled(false);
            e.printStackTrace();
        }
        this.jTableTaxa.setDragEnabled(true);
        this.jTableTaxa.setTransferHandler(new TaxonTransferHandler(null));
        this.jTableTaxa.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(null));
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs == this.sbdb && obj == Taxon.class) {
            if (this.modelTaxa.taxa != null) {
                boolean removed = false;
                Iterator<Taxon> itT = this.modelTaxa.taxa.iterator();
                while (itT.hasNext()) {
                    Taxon t = itT.next();
                    if (this.sbdb.hasTaxon(t)) continue;
                    itT.remove();
                    removed = true;
                }
                if (removed) {
                    this.sorterTaxa.reallocateIndexes();
                    this.sorterTaxa.sort((Object)this);
                    this.sorterTaxa.fireTableDataChanged();
                }
            }
        } else if (obs.getClass() == Taxon.class) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalFrameTaxa.this.sorterTaxa.fireTableDataChanged();
                }
            });
        }
        this.jTableTaxa.getUI();
    }

    void webLookup() {
        if (this.jTableTaxa.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No taxa selected", this.getTitle(), 2);
            return;
        }
        try {
            WebSearch webSearch = new WebSearch();
            for (int i = 0; i < this.jTableTaxa.getSelectedRowCount(); ++i) {
                String name;
                Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRows()[i]));
                switch (this.jTableTaxa.getSelectedColumn()) {
                    default: {
                        name = taxon.toString(false, false);
                        break;
                    }
                    case 1: {
                        name = taxon.getGenusName();
                        break;
                    }
                    case 2: {
                        name = taxon.getSpecies();
                    }
                }
                BareBonesBrowserLaunch.openURL((String)webSearch.getURL(this.sbdb, name));
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        if (this.jTableTaxa.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No taxa selected", this.getTitle(), 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            for (int i = 0; i < this.jTableTaxa.getSelectedRowCount(); ++i) {
                Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRows()[i]));
                if (taxon.hasEvents()) {
                    JOptionPane.showMessageDialog(this, "Taxon is linked to Events and cannot be deleted.", "Taxa", 1);
                    continue;
                }
                if (this.sbdb.restrictedToDiscID(taxon.getDisc())) {
                    JOptionPane.showMessageDialog(this, "As a restricted user you can't delete taxon: " + taxon.toString(), "Taxa", 1);
                    continue;
                }
                int nOccs = taxon.checkOcc(false);
                int nGroups = taxon.checkGroupOcc();
                String msg = "Do you want to delete taxon '" + taxon + "' which ";
                if (nOccs == 0) {
                    msg = msg + "does not occur";
                } else {
                    msg = msg + "occurs ";
                    msg = nOccs > 1 ? msg + nOccs + " times" : msg + "once";
                }
                msg = msg + " in samples,\nand ";
                if (nGroups == 0) {
                    msg = msg + "does not occur";
                } else {
                    msg = msg + "occurs ";
                    msg = nGroups > 1 ? msg + nGroups + " times" : msg + "once";
                }
                msg = msg + " in groups?";
                if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3) != 0) continue;
                list.add(taxon.getSpecID());
            }
            this.sbdb.deleteSpecies(list, true, null);
            this.sbdb.commit();
            if (list.size() >= 1) {
                JOptionPane.showMessageDialog(this, (list.size() > 1 ? list.size() + " taxa" : "1 taxon") + " deleted.", "Delete taxa", 1);
            }
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void searchAdv() {
        try {
            DialogSelectTaxaAdv dialog = new DialogSelectTaxaAdv((Frame)this.parent, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && dialog.selection.size() > 0) {
                this.addFound(dialog.selection);
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void searchAdvDict() {
        DialogSelectTaxaAdvDict dialog = new DialogSelectTaxaAdvDict((Frame)this.parent, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && !dialog.selection.isEmpty()) {
            this.addFound(dialog.selection);
        }
    }

    void searchCode() {
        DialogSelectTaxaCode dialog = new DialogSelectTaxaCode((Frame)this.parent, true, this.sbdb);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection.size() > 0) {
            this.addFound(dialog.selection);
        }
    }

    private void addFound(List<Taxon> list) {
        DialogList dList = new DialogList(this.parent, true, "Taxa", this.sbdb, list, true, true);
        dList.setLocationRelativeTo(this);
        dList.setVisible(true);
        if (dList.selected != null) {
            for (Object o : dList.selected) {
                Taxon taxon = (Taxon)o;
                if (this.modelTaxa.taxa.contains(taxon)) continue;
                this.modelTaxa.taxa.add(taxon);
                taxon.addObserver((Observer)this);
            }
            this.sorterTaxa.reallocateIndexes();
            this.sorterTaxa.sort((Object)this);
            this.sorterTaxa.fireTableDataChanged();
            int index1 = this.sorterTaxa.getIndexOf(this.modelTaxa.taxa.indexOf(dList.selected.get(0)));
            int index2 = this.sorterTaxa.getIndexOf(this.modelTaxa.taxa.indexOf(dList.selected.get(dList.selected.size() - 1)));
            this.jTableTaxa.setRowSelectionInterval(index1, index2);
        }
    }

    void search(Taxon selectedTaxon) {
        if (!this.parent.parent.checkRLMlicence()) {
            JOptionPane.showMessageDialog(this.parent, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.parent.dispose();
            return;
        }
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa(this.parent, true, this.sbdb, false, selectedTaxon);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                for (Taxon taxon : dialog.selection) {
                    if (this.modelTaxa.taxa.contains(taxon)) continue;
                    this.modelTaxa.taxa.add(taxon);
                    taxon.addObserver((Observer)this);
                }
                this.sorterTaxa.reallocateIndexes();
                this.sorterTaxa.sort((Object)this);
                this.sorterTaxa.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void searchFromList() {
        if (this.jTableTaxa.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        Taxon selectedTaxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
        this.search(selectedTaxon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchWell() {
        DialogWellDisc dialog = new DialogWellDisc((Frame)this.parent, true, this.sbdb, null);
        SB.centreDialog((Dialog)dialog);
        dialog.setVisible(true);
        if (dialog.isOK) {
            try {
                this.parent.setCursor(Cursor.getPredefinedCursor(3));
                for (Well well : dialog.wells) {
                    List list = this.sbdb.getWellTaxa(well, dialog.discID, dialog.analyst);
                    for (Taxon t : list) {
                        if (this.modelTaxa.taxa.contains(t)) continue;
                        this.modelTaxa.taxa.add(t);
                    }
                }
                this.sorterTaxa.reallocateIndexes();
                this.sorterTaxa.sort((Object)this);
                this.sorterTaxa.fireTableDataChanged();
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
            finally {
                this.parent.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    void searchForImages() {
        try {
            List list = this.sbdb.getTaxaWithImages();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(this, "There are no taxa linked to images in the database", this.parent.getTitle(), 1);
                return;
            }
            for (Taxon taxon : list) {
                if (this.modelTaxa.taxa.contains(taxon)) continue;
                boolean status = this.modelTaxa.taxa.add(taxon);
            }
            this.sorterTaxa.reallocateIndexes();
            this.sorterTaxa.sort((Object)this);
            this.sorterTaxa.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchWellOcc() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
            DialogTaxonWellOcc dialog = new DialogTaxonWellOcc((Frame)this.parent, true, this.sbdb, taxon);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selectedItem != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.parent.parent.setSamplesSmpdtl(dialog.well, dialog.selectedItem.smpdtl);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void merge() {
        if (this.jTableTaxa.getSelectedRowCount() < 2) {
            JOptionPane.showMessageDialog(this, "You must select at least 2 taxa from the list to merge", this.getTitle(), 1);
            return;
        }
        LinkedList<Taxon> taxa = new LinkedList<Taxon>();
        for (int row : this.jTableTaxa.getSelectedRows()) {
            taxa.add(this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(row)));
        }
        try {
            DialogMergeTaxa dialog = new DialogMergeTaxa((Frame)this.parent, true, this.sbdb, taxa);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jTableTaxa.clearSelection();
            }
            for (Taxon t : taxa) {
                if (this.sbdb.getTaxon(t.getSpecID()) != null) continue;
                this.modelTaxa.taxa.remove(t);
            }
            this.modelTaxa.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void synonymy() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
            DialogSynonymy dialog = new DialogSynonymy(this.parent, true, this.sbdb, taxon, ((SynonymScheme)this.jComboBoxSynonymScheme.getSelectedItem()).getSchID());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.sorterTaxa.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void notes() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        try {
            Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
            DialogTaxonNotes dialog = new DialogTaxonNotes((Frame)this.parent, true, this.sbdb, taxon);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jTableTaxa.updateUI();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void edit() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
        try {
            if (this.jTableTaxa.getSelectedColumn() == 6) {
                if (Runtime.getRuntime().freeMemory() < 0x100000L) {
                    System.out.println("Memory: " + Runtime.getRuntime().freeMemory());
                    JOptionPane.showMessageDialog(null, "Running low on allocated memory - you may want to close the Control Panel now to avoid problems....", "StrataBugs", 0);
                }
                this.showImages();
            } else if (this.jTableTaxa.getSelectedColumn() == 5) {
                this.synonymy();
            } else {
                DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, taxon, false);
                SB.centreDialog((Dialog)dialog);
                dialog.setVisible(true);
            }
            taxon.notifyObservers();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    Taxon getSelectedTaxon() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            return null;
        }
        return this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
    }

    void numericCodes() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
        try {
            DialogTaxonCode dialog = new DialogTaxonCode((Frame)this.parent, true, this.sbdb, taxon);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    void showImages() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
        try {
            taxon.addObserver((Observer)this);
            DialogTaxonImages dialog = new DialogTaxonImages((Frame)this.parent, true, this.sbdb, taxon);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editOccType() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogEditOccurrences dialog = new DialogEditOccurrences((Frame)this.parent, true, this.sbdb, taxon);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private int getRowOf(Object o) {
        for (int i = 0; i < this.modelTaxa.taxa.size(); ++i) {
            if (this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(i)) != o) continue;
            return i;
        }
        return -1;
    }

    void add() {
        try {
            DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, null, false);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            if (dialog.taxon != null) {
                dialog.taxon.addObserver((Observer)this);
                this.modelTaxa.taxa.add(dialog.taxon);
                this.sorterTaxa.reallocateIndexes();
                this.sorterTaxa.sort((Object)this);
                this.sorterTaxa.fireTableDataChanged();
                int index = this.getRowOf(dialog.taxon);
                if (index >= 0) {
                    this.jTableTaxa.setRowSelectionInterval(index, index);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void initComponents() {
        this.buttonGroupSelection = new ButtonGroup();
        this.jPopupMenuTaxon = new JPopupMenu();
        this.jMenuItemEdit = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemWebLookup = new JMenuItem();
        this.jMenuItemSearchWell = new JMenuItem();
        this.jMenuItemSearch = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemImages = new JMenuItem();
        this.jMenuItemCodes = new JMenuItem();
        this.jMenuItemSynonymy = new JMenuItem();
        this.jMenuItemGroupMembership = new JMenuItem();
        this.jMenuItemRefNotes = new JMenuItem();
        this.jMenuItemEditOccs = new JMenuItem();
        this.jPanelTaxa = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTableTaxa = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxSynonymScheme = new JComboBox();
        this.jButtonSelectAll = new JButton();
        this.jButtonClear = new JButton();
        this.jMenuItemEdit.setText("Edit...");
        this.jMenuItemEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemEditActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemEdit);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemDelete);
        this.jPopupMenuTaxon.add(this.jSeparator1);
        this.jMenuItemWebLookup.setText("Search web...");
        this.jMenuItemWebLookup.setToolTipText("Looks up select genus or species or entire name in your web browser");
        this.jMenuItemWebLookup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemWebLookupActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemWebLookup);
        this.jMenuItemSearchWell.setText("Search wells...");
        this.jMenuItemSearchWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemSearchWellActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemSearchWell);
        this.jMenuItemSearch.setText("Search database...");
        this.jMenuItemSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemSearchActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemSearch);
        this.jPopupMenuTaxon.add(this.jSeparator2);
        this.jMenuItemImages.setText("Images...");
        this.jMenuItemImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemImagesActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemImages);
        this.jMenuItemCodes.setText("Numeric codes...");
        this.jMenuItemCodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemCodesActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemCodes);
        this.jMenuItemSynonymy.setText("Synonymy...");
        this.jMenuItemSynonymy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemSynonymyActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemSynonymy);
        this.jMenuItemGroupMembership.setText("Group membership...");
        this.jMenuItemGroupMembership.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemGroupMembershipActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemGroupMembership);
        this.jMenuItemRefNotes.setText("References and notes...");
        this.jMenuItemRefNotes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemRefNotesActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemRefNotes);
        this.jMenuItemEditOccs.setText("Edit occurrences...");
        this.jMenuItemEditOccs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jMenuItemEditOccsActionPerformed(evt);
            }
        });
        this.jPopupMenuTaxon.add(this.jMenuItemEditOccs);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setTitle("Taxa");
        this.setFrameIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_OccTab.png")));
        this.setMinimumSize(new Dimension(520, 200));
        this.jPanelTaxa.setMaximumSize(new Dimension(500, Short.MAX_VALUE));
        this.jPanelTaxa.setMinimumSize(new Dimension(150, 100));
        this.jPanelTaxa.setPreferredSize(new Dimension(225, 100));
        this.jTableTaxa.setModel((TableModel)this.sorterTaxa);
        this.jTableTaxa.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InternalFrameTaxa.this.jTableTaxaMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                InternalFrameTaxa.this.jTableTaxaMouseReleased(evt);
            }
        });
        this.jTableTaxa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                InternalFrameTaxa.this.jTableTaxaKeyPressed(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableTaxa);
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Synonym Scheme:");
        this.jComboBoxSynonymScheme.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSynonymScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jComboBoxSynonymSchemeActionPerformed(evt);
            }
        });
        this.jButtonSelectAll.setText("Select all");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear selected");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InternalFrameTaxa.this.jButtonClearActionPerformed(evt);
            }
        });
        GroupLayout jPanelTaxaLayout = new GroupLayout((Container)this.jPanelTaxa);
        this.jPanelTaxa.setLayout((LayoutManager)jPanelTaxaLayout);
        jPanelTaxaLayout.setHorizontalGroup((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTaxaLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(1).add((Component)this.jScrollPane4, -1, 684, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanelTaxaLayout.createSequentialGroup().add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonClear).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxSynonymScheme, -2, 122, -2))).addContainerGap()));
        jPanelTaxaLayout.setVerticalGroup((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTaxaLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelTaxaLayout.createParallelGroup(3).add((Component)this.jComboBoxSynonymScheme, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonSelectAll).add((Component)this.jButtonClear)).add(11, 11, 11).add((Component)this.jScrollPane4, -1, 479, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelTaxa, -1, 704, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanelTaxa, -1, 535, Short.MAX_VALUE));
        this.pack();
    }

    private void jComboBoxSynonymSchemeActionPerformed(ActionEvent evt) {
        SynonymScheme scheme = (SynonymScheme)this.jComboBoxSynonymScheme.getSelectedItem();
        if (scheme != null && this.modelTaxa != null && scheme.getSchID() != this.modelTaxa.synSchemeID) {
            this.modelTaxa.synSchemeID = scheme.getSchID();
            this.sorterTaxa.fireTableDataChanged();
        }
    }

    private void jTableTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.edit();
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        if (this.jTableTaxa.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No taxa selected", this.parent.getTitle(), 2);
            return;
        }
        LinkedList<Taxon> toRemove = new LinkedList<Taxon>();
        int[] selection = this.jTableTaxa.getSelectedRows();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(selection[i])));
        }
        for (Taxon t : this.modelTaxa.taxa) {
            t.deleteObserver((Observer)this);
        }
        this.modelTaxa.taxa.removeAll(toRemove);
        this.jTableTaxa.clearSelection();
        this.sorterTaxa.reallocateIndexes();
        this.sorterTaxa.sort((Object)this);
        this.sorterTaxa.fireTableDataChanged();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.jTableTaxa.selectAll();
    }

    private void jTableTaxaKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonClearActionPerformed(null);
        }
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    private void jTableTaxaMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            int rowNumber = this.jTableTaxa.rowAtPoint(evt.getPoint());
            this.jTableTaxa.getSelectionModel().setSelectionInterval(rowNumber, rowNumber);
            this.jPopupMenuTaxon.show(evt.getComponent(), (int)evt.getPoint().getX(), (int)evt.getPoint().getY());
        }
    }

    private void jMenuItemWebLookupActionPerformed(ActionEvent evt) {
        this.webLookup();
    }

    private void jMenuItemSearchWellActionPerformed(ActionEvent evt) {
        this.searchWellOcc();
    }

    private void jMenuItemSearchActionPerformed(ActionEvent evt) {
        this.searchFromList();
    }

    private void jMenuItemEditActionPerformed(ActionEvent evt) {
        this.edit();
    }

    private void jMenuItemImagesActionPerformed(ActionEvent evt) {
        this.showImages();
    }

    private void jMenuItemSynonymyActionPerformed(ActionEvent evt) {
        this.synonymy();
    }

    private void jMenuItemCodesActionPerformed(ActionEvent evt) {
        this.numericCodes();
    }

    private void jMenuItemGroupMembershipActionPerformed(ActionEvent evt) {
        this.groupMembership();
    }

    private void jMenuItemRefNotesActionPerformed(ActionEvent evt) {
        this.notes();
    }

    private void jMenuItemEditOccsActionPerformed(ActionEvent evt) {
        this.editOccType();
    }

    void groupMembership() {
        if (this.jTableTaxa.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
            return;
        }
        Taxon taxon = this.modelTaxa.taxa.get(this.sorterTaxa.getIndexOf(this.jTableTaxa.getSelectedRow()));
        try {
            List list = taxon.getGroups();
            DialogList dialog = new DialogList(this.parent, true, "Groups : " + taxon.toString(false, false), this.sbdb, list, false, false);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    void writeCSV(File file, char delim) throws IOException {
        FileWriter out = new FileWriter(file);
        for (int row = 0; row < this.sorterTaxa.getRowCount(); ++row) {
            for (int col = 0; col < this.sorterTaxa.getColumnCount(); ++col) {
                Object obj = this.sorterTaxa.getValueAt(row, col);
                if (obj != null) {
                    if (obj.toString().contains("" + delim)) {
                        out.write("\"" + obj + "\"");
                    } else {
                        out.write("" + obj);
                    }
                }
                out.write(delim);
            }
            out.write("\r\n");
        }
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findSimilar() {
        int opt;
        if (this.jTableTaxa.getRowCount() > 0) {
            opt = JOptionPane.showConfirmDialog(this, "This option will search for all similar taxa, from the entire dictionary, for potential merging.\nIt may take several minutes to load the list.\nClear existing taxa list first?", this.parent.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.modelTaxa.taxa.clear();
                this.jTableTaxa.clearSelection();
                this.sorterTaxa.reallocateIndexes();
                this.sorterTaxa.sort((Object)this);
                this.sorterTaxa.fireTableDataChanged();
            }
        } else {
            opt = JOptionPane.showConfirmDialog(this, "This option will search for all similar taxa, from the entire dictionary, for potential merging.\nIt may take several minutes to load the list.\nContinue?", this.parent.getTitle(), 0, 3);
            if (opt != 0) {
                return;
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.sbdb.loadTaxa();
            for (Taxon taxon : this.sbdb.getTaxa()) {
                for (Taxon taxon2 : this.sbdb.getTaxa()) {
                    if (taxon == taxon2 || !taxon.toString(false, false).equalsIgnoreCase(taxon2.toString(false, false))) continue;
                    if (!this.modelTaxa.taxa.contains(taxon)) {
                        this.modelTaxa.taxa.add(taxon);
                    }
                    if (this.modelTaxa.taxa.contains(taxon2)) continue;
                    this.modelTaxa.taxa.add(taxon2);
                }
            }
            this.sorterTaxa.reallocateIndexes();
            this.sorterTaxa.sort((Object)this);
            this.sorterTaxa.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

