/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jsbugs.Chart;
import jsbugs.ChartActions;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.ChartJPanelAHD;
import jsbugs.ChartJPanelAge;
import jsbugs.ChartJPanelDepthAge;
import jsbugs.ChartJPanelTVDOffset;
import jsbugs.ChartPanel;
import jsbugs.ChartPropertiesAction;
import jsbugs.DialogBiocom;
import jsbugs.DialogEvent;
import jsbugs.DialogEventOcc;
import jsbugs.DialogLOCIntervals;
import jsbugs.DialogPanelBiocoms;
import jsbugs.DialogPanelChromalog;
import jsbugs.DialogPanelCoreImages;
import jsbugs.DialogPanelDendrogram;
import jsbugs.DialogPanelDepth;
import jsbugs.DialogPanelEnv;
import jsbugs.DialogPanelEvents;
import jsbugs.DialogPanelIGDScheme;
import jsbugs.DialogPanelIntLith;
import jsbugs.DialogPanelIntcoms;
import jsbugs.DialogPanelSQPicks;
import jsbugs.DialogPanelSamples;
import jsbugs.DialogPanelSurfaces;
import jsbugs.DialogPanelTaxon;
import jsbugs.DialogPanelTaxonGroup;
import jsbugs.DialogPanelWellHeader;
import jsbugs.DialogPanelZones;
import jsbugs.DialogProcessing;
import jsbugs.DialogSample;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogWellEvent;
import jsbugs.DialogWirelineLogPanel;
import jsbugs.FrameJsbugs;
import jsbugs.FrameSamples;
import jsbugs.JPanelWell;
import jsbugs.JScrollPaneChart;
import jsbugs.PanelBiocoms;
import jsbugs.PanelChromalog;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelCoreImages;
import jsbugs.PanelDendrogram;
import jsbugs.PanelDepth;
import jsbugs.PanelEnv;
import jsbugs.PanelEvents;
import jsbugs.PanelEventsBase;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelIntLith;
import jsbugs.PanelIntcoms;
import jsbugs.PanelSQPicks;
import jsbugs.PanelSamples;
import jsbugs.PanelSurfaces;
import jsbugs.PanelTaxon;
import jsbugs.PanelTaxonBase;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelWellDepthAge;
import jsbugs.PanelWellHeader;
import jsbugs.PanelWellVS;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelZones;
import jsbugs.SBDialog;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import jsbugs.WellBlock;
import jsbugs.ZoomAction;
import model2.Biocom;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.Discipline;
import model2.LOC;
import model2.Lastval;
import model2.LithBase;
import model2.LithInterval;
import model2.Lithology;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.fop.svg.PDFTranscoder;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.util.UnitConv;
import org.w3c.dom.Document;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class JPanelCharts
extends JPanel
implements ChartActions {
    final FrameSamples parent;
    final JPanelWell parentPanel;
    private final SBdb sbdb;
    final Well well;
    static final float zoomIncrement = 1.5f;
    private Point popupPoint = null;
    private boolean askVersion = true;
    private final JLabel jLabelChartSize = new JLabel();
    private ChartJPanelAHD ahdChartJPanel;
    private ChartJPanelTVDOffset TVDOffsetChartJPanel;
    private ChartJPanelDepthAge depthAgeChartJPanel;
    private ChartJPanelAge chartJPanelAge;
    private JScrollPaneChart jScrollPaneAHD;
    private JScrollPaneChart jScrollPaneTVDOffset;
    private JScrollPaneChart jScrollPaneDepthAge;
    private JScrollPaneChart jScrollPaneAge;
    private JButton jButtonChartProperties;
    private JButton jButtonChartZoomIn;
    private JButton jButtonChartZoomOut;
    private JButton jButtonRedo;
    private JButton jButtonUndo;
    private JLabel jLabelInfo;
    private JMenu jMenuBnd;
    private JMenuItem jMenuItemAGEPanelProperties;
    private JMenuItem jMenuItemAHDAddComment;
    private JMenuItem jMenuItemAHDAddSample;
    private JMenuItem jMenuItemAHDDeleteObject;
    private JMenuItem jMenuItemAHDDuplicate;
    private JMenuItem jMenuItemAHDLithFill;
    private JMenuItem jMenuItemAHDLithPalette;
    private JMenuItem jMenuItemAHDLithUpdate;
    private JMenuItem jMenuItemAHDPanelProperties;
    private JMenuItem jMenuItemAHDPickEvent;
    private JMenuItem jMenuItemAHDRemove;
    private JMenuItem jMenuItemAHDSavePanelTaxon;
    private JMenuItem jMenuItemAddPoint;
    private JMenuItem jMenuItemClearProjection;
    private JMenuItem jMenuItemConfident;
    private JMenuItem jMenuItemDAAddLOC;
    private JMenuItem jMenuItemDAAddNode;
    private JMenuItem jMenuItemDAAddWellEvent;
    private JMenuItem jMenuItemDADeleteNode;
    private JMenuItem jMenuItemDADeriveLOC;
    private JMenuItem jMenuItemDADeriveStrat;
    private JMenuItem jMenuItemDAEditEvent;
    private JMenuItem jMenuItemDAEventUsage;
    private JMenuItem jMenuItemDAGoToAnalysis;
    private JMenuItem jMenuItemDAMigrateComposite;
    private JMenuItem jMenuItemDAPanelProperties;
    private JMenuItem jMenuItemDepthAgeAddToComposite;
    private JMenuItem jMenuItemDepthAgeOtherPanelProperties;
    private JMenuItem jMenuItemExtendUnit;
    private JMenuItem jMenuItemLOCFault;
    private JMenuItem jMenuItemLOCPoss;
    private JMenuItem jMenuItemLOCProb;
    private JMenuItem jMenuItemLOCQFault;
    private JMenuItem jMenuItemLOCQuncf;
    private JMenuItem jMenuItemLOCRFault;
    private JMenuItem jMenuItemLOCUncf;
    private JMenuItem jMenuItemProjectPath;
    private JPopupMenu jPopupMenuAHD;
    private JPopupMenu jPopupMenuAge;
    private JPopupMenu jPopupMenuDepthAge;
    private JPopupMenu jPopupMenuPanelProperties;
    private JPopupMenu jPopupMenuTVDOffset;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparatorAHDLithPalette;
    private JPopupMenu.Separator jSeparatorAHDProperties;
    private JToolBar.Separator jSeparatorUndoRedo;
    private JTabbedPane jTabbedPaneChart;
    private JToggleButton jToggleButtonFreezeHeader;
    private JToolBar jToolBar2;
    private JToolBar jToolBarChartInfo;

    public JPanelCharts(FrameSamples parent, JPanelWell parentPanel, SBdb sbdb, Well well) throws SBException {
        this.parent = parent;
        this.parentPanel = parentPanel;
        this.sbdb = sbdb;
        this.well = well;
        this.initComponents();
        this.initKeyBindings();
        this.setupCharts();
        this.initChartPopups();
        this.initChartSizeLabel();
    }

    private void initKeyBindings() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(61, 128), "zoomIn");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(45, 128), "zoomOut");
        this.getActionMap().put("zoomIn", new ZoomAction(true, this));
        this.getActionMap().put("zoomOut", new ZoomAction(false, this));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(80, 128), "chartProperties");
        this.getActionMap().put("chartProperties", new ChartPropertiesAction(this));
    }

    private void initChartPopups() {
        JPopupMenu[] menus = new JPopupMenu[]{this.jPopupMenuAHD, this.jPopupMenuTVDOffset, this.jPopupMenuDepthAge, this.jPopupMenuAge, this.jPopupMenuPanelProperties};
        for (int i = 0; i < menus.length; ++i) {
            menus[i].addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (JPanelCharts.this.popupPoint == null) {
                        return;
                    }
                    ChartJPanel chartJPanel = JPanelCharts.this.getChartJPanel();
                    Point2D pTemp = chartJPanel.getPoint(JPanelCharts.this.popupPoint);
                    Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
                    ChartPanel panel = chartJPanel.chart.getSelectedPanel(mmPoint);
                    if (panel != null) {
                        panel.setOutline(false);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    JPanelCharts.this.getChartJPanel().repaint();
                }
            });
        }
    }

    private void initChartSizeLabel() {
        this.jToolBarChartInfo.add(Box.createHorizontalGlue());
        this.jToolBarChartInfo.add(this.jLabelChartSize);
        this.jLabelChartSize.setText("Chart Size");
        this.jToolBarChartInfo.add(Box.createHorizontalStrut(this.jTabbedPaneChart.getBoundsAt((int)0).width));
        this.jLabelChartSize.setForeground(Color.LIGHT_GRAY);
    }

    private void initComponents() {
        this.jPopupMenuDepthAge = new JPopupMenu();
        this.jMenuItemDAAddNode = new JMenuItem();
        this.jMenuItemDADeleteNode = new JMenuItem();
        this.jMenuBnd = new JMenu();
        this.jMenuItemLOCPoss = new JMenuItem();
        this.jMenuItemLOCProb = new JMenuItem();
        this.jMenuItemConfident = new JMenuItem();
        this.jMenuItemLOCUncf = new JMenuItem();
        this.jMenuItemLOCQuncf = new JMenuItem();
        this.jMenuItemLOCFault = new JMenuItem();
        this.jMenuItemLOCQFault = new JMenuItem();
        this.jMenuItemLOCRFault = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemDAAddLOC = new JMenuItem();
        this.jMenuItemDADeriveLOC = new JMenuItem();
        this.jMenuItemDADeriveStrat = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemDAAddWellEvent = new JMenuItem();
        this.jMenuItemDAEditEvent = new JMenuItem();
        this.jMenuItemDAGoToAnalysis = new JMenuItem();
        this.jMenuItemDAEventUsage = new JMenuItem();
        this.jMenuItemDAMigrateComposite = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItemDAPanelProperties = new JMenuItem();
        this.jPopupMenuTVDOffset = new JPopupMenu();
        this.jMenuItemProjectPath = new JMenuItem();
        this.jMenuItemClearProjection = new JMenuItem();
        this.jMenuItemAddPoint = new JMenuItem();
        this.jMenuItemExtendUnit = new JMenuItem();
        this.jPopupMenuAHD = new JPopupMenu();
        this.jMenuItemAHDAddSample = new JMenuItem();
        this.jMenuItemAHDPickEvent = new JMenuItem();
        this.jMenuItemAHDAddComment = new JMenuItem();
        this.jMenuItemAHDDeleteObject = new JMenuItem();
        this.jMenuItemAHDLithUpdate = new JMenuItem();
        this.jMenuItemAHDLithFill = new JMenuItem();
        this.jSeparatorAHDLithPalette = new JPopupMenu.Separator();
        this.jMenuItemAHDLithPalette = new JMenuItem();
        this.jSeparatorAHDProperties = new JPopupMenu.Separator();
        this.jMenuItemAHDDuplicate = new JMenuItem();
        this.jMenuItemAHDRemove = new JMenuItem();
        this.jMenuItemAHDSavePanelTaxon = new JMenuItem();
        this.jMenuItemAHDPanelProperties = new JMenuItem();
        this.jPopupMenuPanelProperties = new JPopupMenu();
        this.jMenuItemDepthAgeOtherPanelProperties = new JMenuItem();
        this.jMenuItemDepthAgeAddToComposite = new JMenuItem();
        this.jPopupMenuAge = new JPopupMenu();
        this.jMenuItemAGEPanelProperties = new JMenuItem();
        this.jTabbedPaneChart = new JTabbedPane();
        this.jToolBarChartInfo = new JToolBar();
        this.jLabelInfo = new JLabel();
        this.jToolBar2 = new JToolBar();
        this.jButtonChartZoomIn = new JButton();
        this.jButtonChartZoomOut = new JButton();
        this.jToggleButtonFreezeHeader = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButtonChartProperties = new JButton();
        this.jSeparatorUndoRedo = new JToolBar.Separator();
        this.jButtonUndo = new JButton();
        this.jButtonRedo = new JButton();
        this.jMenuItemDAAddNode.setText("Add LOC node at current position");
        this.jMenuItemDAAddNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAAddNodeActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAAddNode);
        this.jMenuItemDADeleteNode.setText("Delete LOC node at current position");
        this.jMenuItemDADeleteNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDADeleteNodeActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDADeleteNode);
        this.jMenuBnd.setText("Change line to");
        this.jMenuItemLOCPoss.setText("Possible");
        this.jMenuItemLOCPoss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemLOCPossActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemLOCPoss);
        this.jMenuItemLOCProb.setText("Probable");
        this.jMenuItemLOCProb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemLOCProbActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemLOCProb);
        this.jMenuItemConfident.setText("Confident");
        this.jMenuItemConfident.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemConfidentActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemConfident);
        this.jMenuItemLOCUncf.setText("Unconformity");
        this.jMenuItemLOCUncf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemLOCUncfActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemLOCUncf);
        this.jMenuItemLOCQuncf.setText("?Unconformity");
        this.jMenuItemLOCQuncf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemLOCQuncfActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemLOCQuncf);
        this.jMenuItemLOCFault.setText("Fault");
        this.jMenuItemLOCFault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemLOCFaultActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemLOCFault);
        this.jMenuItemLOCQFault.setText("?Fault");
        this.jMenuItemLOCQFault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemLOCQFaultActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemLOCQFault);
        this.jMenuItemLOCRFault.setText("Reverse Fault");
        this.jMenuItemLOCRFault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemLOCRFaultActionPerformed(evt);
            }
        });
        this.jMenuBnd.add(this.jMenuItemLOCRFault);
        this.jPopupMenuDepthAge.add(this.jMenuBnd);
        this.jPopupMenuDepthAge.add(this.jSeparator1);
        this.jMenuItemDAAddLOC.setText("Add new LOC");
        this.jMenuItemDAAddLOC.setActionCommand("Add Straight LOC");
        this.jMenuItemDAAddLOC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAAddLOCActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAAddLOC);
        this.jMenuItemDADeriveLOC.setText("Create LOC from Stratigraphy");
        this.jMenuItemDADeriveLOC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDADeriveLOCActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDADeriveLOC);
        this.jMenuItemDADeriveStrat.setText("Create zones/intervals from LOC");
        this.jMenuItemDADeriveStrat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDADeriveStratActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDADeriveStrat);
        this.jPopupMenuDepthAge.add(this.jSeparator2);
        this.jMenuItemDAAddWellEvent.setText("Pick well event");
        this.jMenuItemDAAddWellEvent.setEnabled(false);
        this.jMenuItemDAAddWellEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAAddWellEventActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAAddWellEvent);
        this.jMenuItemDAEditEvent.setText("Edit well event");
        this.jMenuItemDAEditEvent.setEnabled(false);
        this.jMenuItemDAEditEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAEditEventActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAEditEvent);
        this.jMenuItemDAGoToAnalysis.setText("Go to occurrence...");
        this.jMenuItemDAGoToAnalysis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAGoToAnalysisActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAGoToAnalysis);
        this.jMenuItemDAEventUsage.setText("Event usage...");
        this.jMenuItemDAEventUsage.setEnabled(false);
        this.jMenuItemDAEventUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAEventUsageActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAEventUsage);
        this.jMenuItemDAMigrateComposite.setText("Extend event age in composite to LOC age");
        this.jMenuItemDAMigrateComposite.setEnabled(false);
        this.jMenuItemDAMigrateComposite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAMigrateCompositeActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAMigrateComposite);
        this.jPopupMenuDepthAge.add(this.jSeparator4);
        this.jMenuItemDAPanelProperties.setText("Panel Properties...");
        this.jMenuItemDAPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDAPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuDepthAge.add(this.jMenuItemDAPanelProperties);
        this.jMenuItemProjectPath.setText("Project path to here");
        this.jMenuItemProjectPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemProjectPathActionPerformed(evt);
            }
        });
        this.jPopupMenuTVDOffset.add(this.jMenuItemProjectPath);
        this.jMenuItemClearProjection.setText("Clear projection");
        this.jMenuItemClearProjection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemClearProjectionActionPerformed(evt);
            }
        });
        this.jPopupMenuTVDOffset.add(this.jMenuItemClearProjection);
        this.jMenuItemAddPoint.setText("Add this point to deviation survey");
        this.jMenuItemAddPoint.setEnabled(false);
        this.jMenuItemAddPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAddPointActionPerformed(evt);
            }
        });
        this.jPopupMenuTVDOffset.add(this.jMenuItemAddPoint);
        this.jMenuItemExtendUnit.setText("Extend unit to this sample");
        this.jMenuItemExtendUnit.setEnabled(false);
        this.jPopupMenuTVDOffset.add(this.jMenuItemExtendUnit);
        this.jMenuItemAHDAddSample.setText("Add sample at current cursor position");
        this.jMenuItemAHDAddSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDAddSampleActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDAddSample);
        this.jMenuItemAHDPickEvent.setText("Pick event at cursor position...");
        this.jMenuItemAHDPickEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDPickEventActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDPickEvent);
        this.jMenuItemAHDAddComment.setText("Add/edit comment at cursor position...");
        this.jMenuItemAHDAddComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDAddCommentActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDAddComment);
        this.jMenuItemAHDDeleteObject.setText("Delete");
        this.jMenuItemAHDDeleteObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDDeleteObjectActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDDeleteObject);
        this.jMenuItemAHDLithUpdate.setText("Change lithology to");
        this.jMenuItemAHDLithUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDLithUpdateActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDLithUpdate);
        this.jMenuItemAHDLithFill.setText("Fill lithology");
        this.jMenuItemAHDLithFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDLithFillActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDLithFill);
        this.jPopupMenuAHD.add(this.jSeparatorAHDLithPalette);
        this.jMenuItemAHDLithPalette.setText("Show lithology palette");
        this.jMenuItemAHDLithPalette.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDLithPaletteActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDLithPalette);
        this.jPopupMenuAHD.add(this.jSeparatorAHDProperties);
        this.jMenuItemAHDDuplicate.setText("Duplicate panel");
        this.jMenuItemAHDDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDDuplicateActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDDuplicate);
        this.jMenuItemAHDRemove.setText("Remove panel");
        this.jMenuItemAHDRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDRemoveActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDRemove);
        this.jMenuItemAHDSavePanelTaxon.setText("Save panel data...");
        this.jMenuItemAHDSavePanelTaxon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDSavePanelTaxonActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDSavePanelTaxon);
        this.jMenuItemAHDPanelProperties.setText("Panel properties...");
        this.jMenuItemAHDPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAHDPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuAHD.add(this.jMenuItemAHDPanelProperties);
        this.jMenuItemDepthAgeOtherPanelProperties.setText("Panel Properties...");
        this.jMenuItemDepthAgeOtherPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDepthAgeOtherPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuPanelProperties.add(this.jMenuItemDepthAgeOtherPanelProperties);
        this.jMenuItemDepthAgeAddToComposite.setText("Add event to composite");
        this.jMenuItemDepthAgeAddToComposite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemDepthAgeAddToCompositeActionPerformed(evt);
            }
        });
        this.jPopupMenuPanelProperties.add(this.jMenuItemDepthAgeAddToComposite);
        this.jMenuItemAGEPanelProperties.setText("Panel properties...");
        this.jMenuItemAGEPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jMenuItemAGEPanelPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuAge.add(this.jMenuItemAGEPanelProperties);
        this.jTabbedPaneChart.setTabPlacement(4);
        this.jTabbedPaneChart.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JPanelCharts.this.jTabbedPaneChartStateChanged(evt);
            }
        });
        this.jToolBarChartInfo.setFloatable(false);
        this.jToolBarChartInfo.setBorderPainted(false);
        this.jLabelInfo.setText("~~~~~~~~~~~");
        this.jToolBarChartInfo.add(this.jLabelInfo);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jButtonChartZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomIn24.png")));
        this.jButtonChartZoomIn.setToolTipText("Zoom in (CTRL +)");
        this.jButtonChartZoomIn.setFocusable(false);
        this.jButtonChartZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jButtonChartZoomInActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonChartZoomIn);
        this.jButtonChartZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomOut24.png")));
        this.jButtonChartZoomOut.setToolTipText("Zoom out (CTRL -)");
        this.jButtonChartZoomOut.setFocusable(false);
        this.jButtonChartZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jButtonChartZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonChartZoomOut);
        this.jToggleButtonFreezeHeader.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_FreezePanes.png")));
        this.jToggleButtonFreezeHeader.setToolTipText("Toggle freeze header");
        this.jToggleButtonFreezeHeader.setFocusable(false);
        this.jToggleButtonFreezeHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jToggleButtonFreezeHeaderActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jToggleButtonFreezeHeader);
        this.jToolBar2.add(this.jSeparator3);
        this.jButtonChartProperties.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_ChartProperties.png")));
        this.jButtonChartProperties.setToolTipText("Chart Properties");
        this.jButtonChartProperties.setFocusable(false);
        this.jButtonChartProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jButtonChartPropertiesActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonChartProperties);
        this.jToolBar2.add(this.jSeparatorUndoRedo);
        this.jButtonUndo.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_Undo.png")));
        this.jButtonUndo.setToolTipText("Undo " + this.getUndoTooltip(true) + " (CTRL+Z)");
        this.jButtonUndo.setFocusable(false);
        this.jButtonUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jButtonUndoActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonUndo);
        this.jButtonRedo.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_Redo.png")));
        this.jButtonRedo.setToolTipText("Redo " + this.getUndoTooltip(false) + " (CTRL + SHIFT + Z)");
        this.jButtonRedo.setFocusable(false);
        this.jButtonRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCharts.this.jButtonRedoActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonRedo);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPaneChart, -1, 793, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jToolBarChartInfo, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar2, -2, -1, -2).addGap(7, 7, 7).addComponent(this.jTabbedPaneChart, -1, 591, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBarChartInfo, -2, 20, -2)));
    }

    private void setupCharts() {
        this.ahdChartJPanel = new ChartJPanelAHD(this, this.sbdb);
        this.jScrollPaneAHD = new JScrollPaneChart(this.ahdChartJPanel, new ChartJPanelAHD(this, this.sbdb));
        this.jScrollPaneAHD.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTabbedPaneChart.insertTab("Standard", null, this.jScrollPaneAHD, "Standard chart", 0);
        this.TVDOffsetChartJPanel = new ChartJPanelTVDOffset(this, this.sbdb);
        this.jScrollPaneTVDOffset = new JScrollPaneChart(this.TVDOffsetChartJPanel, new ChartJPanelTVDOffset(this, this.sbdb));
        this.jScrollPaneTVDOffset.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTabbedPaneChart.insertTab("TVD/Offset", null, this.jScrollPaneTVDOffset, "TVD/Offset chart", 1);
        this.depthAgeChartJPanel = new ChartJPanelDepthAge(this, this.sbdb);
        this.jScrollPaneDepthAge = new JScrollPaneChart(this.depthAgeChartJPanel, new ChartJPanelDepthAge(this, this.sbdb));
        this.jScrollPaneDepthAge.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTabbedPaneChart.insertTab("Depth/Age", null, this.jScrollPaneDepthAge, "Depth/Age chart", 2);
        this.chartJPanelAge = new ChartJPanelAge(this, this.sbdb);
        this.jScrollPaneAge = new JScrollPaneChart(this.chartJPanelAge, new ChartJPanelAge(this, this.sbdb));
        this.jScrollPaneAge.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTabbedPaneChart.insertTab("Age", null, this.jScrollPaneAge, "Age chart", 3);
        this.jTabbedPaneChart.setSelectedIndex(0);
    }

    WellInterp getInterp() {
        return this.parentPanel.getInterp();
    }

    public char getUnits() {
        return this.parentPanel.units;
    }

    JFrame getParentFrame() {
        return this.parent.getParentFrame(this);
    }

    private void deriveLOC() {
        if (this.depthAgeChartJPanel.chart == null) {
            JOptionPane.showMessageDialog(this.parent, "No Depth/Age chart selected.", this.parent.getTitle(), 1);
            return;
        }
        PanelWellDepthAge panel = null;
        for (SBPanel o : this.depthAgeChartJPanel.chart.getWellBlock().panels) {
            if (o.getClass() != PanelWellDepthAge.class) continue;
            panel = (PanelWellDepthAge)o;
            break;
        }
        if (panel == null) {
            JOptionPane.showMessageDialog(this.parent, "Block has no well/depth/age panel", this.parent.getTitle(), 1);
            return;
        }
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this.parent, "No version selected.", this.parent.getTitle(), 1);
            return;
        }
        if (panel.getProperties().getScheme() == null) {
            JOptionPane.showMessageDialog(this.parent, "You must select a scheme", this.parent.getTitle(), 1);
            return;
        }
        try {
            if (panel.getProperties().getCmpStd() == null) {
                DialogSelectCmpStd dialog = new DialogSelectCmpStd((Frame)this.parent, true, this.sbdb, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                dialog.selection.loadEvents();
                panel.getProperties().setCmpStd(dialog.selection, this.sbdb);
            }
            if (wellInterp.getLOC() != null) {
                if (JOptionPane.showConfirmDialog(this.parent, "Delete current LOC?", this.parent.getTitle(), 0, 3) != 0) {
                    return;
                }
                wellInterp.deleteLOC(this.well.getWellID());
            }
            wellInterp.deriveLOC(panel.getProperties().getScheme(), this.well, panel.getProperties().getCmpStd());
            wellInterp.getLOC().addObserver((Observer)this.depthAgeChartJPanel);
            this.sbdb.commit();
            this.depthAgeChartJPanel.repaint();
        }
        catch (SQLException e) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("Error creating LOC", e, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error creating LOC", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void setChartVersion(WellInterp wellInterp) throws SQLException, SBException {
        this.parent.setSchemeChartVersion(wellInterp);
        if (this.depthAgeChartJPanel.chart != null) {
            this.depthAgeChartJPanel.initChart();
        }
        if (this.ahdChartJPanel.chart != null) {
            this.ahdChartJPanel.initChart(true);
        }
        if (this.TVDOffsetChartJPanel.chart != null) {
            this.TVDOffsetChartJPanel.initChart();
        }
    }

    void AHDPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            boolean delete;
            this.popupPoint = evt.getPoint();
            Point2D pTemp = this.ahdChartJPanel.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.ahdChartJPanel.chart.getSelectedPanel(mmPoint);
            if (panel == null) {
                return;
            }
            boolean props = panel instanceof PanelTaxonGroup || panel instanceof PanelWirelineLog || panel instanceof PanelEnv || panel instanceof PanelEvents || panel instanceof PanelBiocoms || panel instanceof PanelIntLith || panel instanceof PanelIntcoms || panel instanceof PanelDepth || panel instanceof PanelSQPicks || panel instanceof PanelSamples || panel instanceof PanelCoreImages || panel instanceof PanelChromalog || panel instanceof PanelZones || panel instanceof PanelWellHeader;
            this.jSeparatorAHDProperties.setVisible(props);
            this.jMenuItemAHDPanelProperties.setVisible(props);
            this.jMenuItemAHDDuplicate.setVisible(panel instanceof PanelTaxonGroup);
            this.jMenuItemAHDRemove.setVisible(panel != null);
            if (panel instanceof PanelTaxonGroup) {
                PanelTaxonGroup ptg = (PanelTaxonGroup)panel;
                float xorigin = this.ahdChartJPanel.chart.getPanelOrigin((SBPanel)ptg, (boolean)false, (Chart.Mode)this.ahdChartJPanel.getMode(), (float)mmPoint.x).x;
                PanelTaxonBase inner = ptg.getPanel(mmPoint.x - xorigin);
                if (inner != null && ptg.size() > 1) {
                    this.jMenuItemAHDRemove.setText("Remove '" + inner.toString() + "' (inner)");
                } else {
                    this.jMenuItemAHDRemove.setText("Remove '" + ptg.toString() + "' (outer)");
                }
                if (inner != null) {
                    inner.setOutline(true);
                } else {
                    ptg.setOutline(true);
                }
            } else {
                this.jMenuItemAHDRemove.setText("Remove '" + panel.toString() + "'");
                panel.setOutline(true);
            }
            Object obj = this.ahdChartJPanel.getObject(evt);
            this.jMenuItemAHDPickEvent.setVisible(obj instanceof PanelTaxon.PanelTaxonObject);
            this.jMenuItemAHDAddComment.setVisible(obj instanceof PanelTaxon.PanelTaxonObject);
            this.jMenuItemAHDSavePanelTaxon.setVisible(panel instanceof PanelTaxonGroup);
            boolean bl = delete = obj != null && (panel instanceof PanelIntLith || panel instanceof PanelBiocoms);
            if (delete) {
                String objString = "Delete '" + obj.toString() + "'";
                if (objString.length() > 30) {
                    objString = objString.substring(0, 30).trim() + "...'";
                }
                this.jMenuItemAHDDeleteObject.setText(objString);
            }
            this.jMenuItemAHDDeleteObject.setVisible(delete);
            this.jSeparatorAHDLithPalette.setVisible(panel instanceof PanelIntLith && this.parent.getLithPalette() == null);
            this.jMenuItemAHDLithPalette.setVisible(panel instanceof PanelIntLith && this.parent.getLithPalette() == null);
            this.jMenuItemAHDLithFill.setVisible(panel instanceof PanelIntLith && this.parent.getLithPalette() != null && this.getSelectedLithology() != null && !this.getSelectedLithology().isQual());
            if (panel instanceof PanelIntLith && obj instanceof LithInterval && this.getSelectedLithology() != null && this.getSelectedLithology() != null && !this.getSelectedLithology().isQual()) {
                this.jMenuItemAHDLithUpdate.setText("Change lithology to " + this.getSelectedLithology());
                this.jMenuItemAHDLithUpdate.setVisible(true);
            } else {
                this.jMenuItemAHDLithUpdate.setVisible(false);
            }
            this.jPopupMenuAHD.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private Lithology getSelectedLithology() {
        if (this.parent.getLithPalette() != null) {
            return this.parent.getLithPalette().getSelectedLithology();
        }
        return null;
    }

    void DepthAgePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupPoint = evt.getPoint();
            Point2D pTemp = this.depthAgeChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.depthAgeChartJPanel.chart.getSelectedPanel(mmPoint);
            if (panel != null) {
                this.setPanelOutline(panel, mmPoint);
            }
            Object obj = this.jScrollPaneDepthAge.getObject(evt);
            if (panel instanceof PanelWellDepthAge && !(obj instanceof SchemeBlock)) {
                if (!((PanelWellDepthAge)panel).interactive()) {
                    return;
                }
                this.jMenuItemDAEditEvent.setEnabled(obj instanceof WellEvent);
                this.jMenuItemDAMigrateComposite.setEnabled(obj instanceof WellEvent);
                this.jMenuItemDAEventUsage.setEnabled(obj instanceof WellEvent || obj instanceof CompositeStandardEvent);
                this.jMenuItemDAAddWellEvent.setEnabled(obj instanceof CompositeStandardEvent);
                this.jMenuItemDAGoToAnalysis.setEnabled(obj instanceof CompositeStandardEvent || obj instanceof WellEvent);
                this.jPopupMenuDepthAge.show(evt.getComponent(), evt.getX(), evt.getY());
            } else {
                this.jMenuItemDepthAgeAddToComposite.setVisible(obj instanceof WellEvent);
                this.jPopupMenuPanelProperties.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    void AgePopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupPoint = evt.getPoint();
            Point2D pTemp = this.chartJPanelAge.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.chartJPanelAge.chart.getSelectedPanel(mmPoint);
            if (panel != null) {
                this.setPanelOutline(panel, mmPoint);
            }
            if (panel == null) {
                return;
            }
            this.jPopupMenuAge.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void setPanelOutline(ChartPanel panel, Point2D.Float mmPoint) {
        if (panel instanceof PanelTaxonGroup) {
            PanelTaxonGroup ptg = (PanelTaxonGroup)panel;
            float xorigin = this.getChartJPanel().chart.getPanelOrigin((SBPanel)ptg, (boolean)false, (Chart.Mode)this.getChartJPanel().getMode(), (float)mmPoint.x).x;
            PanelTaxonBase inner = ptg.getPanel(mmPoint.x - xorigin);
            if (inner != null) {
                inner.setOutline(true);
            } else {
                ptg.setOutline(true);
            }
        } else {
            panel.setOutline(true);
        }
    }

    void TVDOffsetPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.popupPoint = evt.getPoint();
            Point2D pTemp = this.TVDOffsetChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.TVDOffsetChartJPanel.chart.getSelectedPanel(mmPoint);
            if (panel != null) {
                this.setPanelOutline(panel, mmPoint);
                if (panel instanceof PanelWellVS) {
                    if (this.TVDOffsetChartJPanel.predictPointDraggable) {
                        this.jPopupMenuTVDOffset.getComponent(2).setEnabled(true);
                    } else {
                        this.jPopupMenuTVDOffset.getComponent(2).setEnabled(false);
                    }
                    this.jPopupMenuTVDOffset.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.jMenuItemDepthAgeAddToComposite.setVisible(false);
                    this.jPopupMenuPanelProperties.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }
    }

    private void addLOC() {
        try {
            Point2D mmPoint = this.depthAgeChartJPanel.getPoint(this.popupPoint);
            ChartPanel panel = this.depthAgeChartJPanel.chart.getSelectedPanel(mmPoint);
            if (panel == null || !(panel instanceof PanelWellDepthAge)) {
                JOptionPane.showMessageDialog(this.parent, "No LOC panel selected", this.parent.getTitle(), 1);
                return;
            }
            PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
            wellPanel.addLOC();
            this.depthAgeChartJPanel.repaint();
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), "Add LOC", 2);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }

    void printChart() {
        Chart chart = this.getChartJPanel().chart;
        if (chart == null) {
            JOptionPane.showMessageDialog(this.parent, "No chart selected/created. Use the Chart tab and select chart", this.parent.getTitle(), 1);
            return;
        }
        FrameSamples.printChart(chart, this.parent, this.sbdb, this.parent.getParent().isDemoLicense());
    }

    private PanelWellVS getTVDPanelVS() {
        WellBlock block = (WellBlock)this.TVDOffsetChartJPanel.chart.blocks.get(1);
        for (SBPanel panel : block.panels) {
            if (!(panel instanceof PanelWellVS)) continue;
            PanelWellVS panelVS = (PanelWellVS)panel;
            return panelVS;
        }
        return null;
    }

    private ChartJPanel getChartJPanel() {
        if (this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneAHD) {
            return this.ahdChartJPanel;
        }
        if (this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneTVDOffset) {
            return this.TVDOffsetChartJPanel;
        }
        if (this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneAge) {
            return this.chartJPanelAge;
        }
        return this.depthAgeChartJPanel;
    }

    @Override
    public void chartProperties() {
        try {
            this.getChartJPanel().chartProperties();
            ((JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent()).setHeader(this.jToggleButtonFreezeHeader.isSelected());
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonChartPropertiesActionPerformed(ActionEvent evt) {
        this.chartProperties();
    }

    void stateChanged() {
        this.jTabbedPaneChartStateChanged(null);
    }

    private void undoRedoVisible(boolean visible) {
        this.jButtonUndo.setVisible(visible);
        this.jButtonRedo.setVisible(visible);
        this.jSeparatorUndoRedo.setVisible(visible);
        this.setUndoTooltips();
    }

    private void jTabbedPaneChartStateChanged(ChangeEvent evt) {
        this.jLabelInfo.setText(null);
        this.undoRedoVisible(this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneDepthAge || this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneAHD);
        if (this.parentPanel.inStartup) {
            return;
        }
        if (this.parentPanel.getInterp() == null && this.askVersion) {
            int opt = JOptionPane.showConfirmDialog(this.parentPanel, "No version loaded. Do you want to load the default version?", "Version", 0);
            if (opt == 0) {
                this.parentPanel.selectDefaultVersion();
            }
            this.askVersion = false;
        }
        if (this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneAHD) {
            this.ahdChartJPanel.initChart(true);
        } else if (this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneTVDOffset) {
            this.TVDOffsetChartJPanel.initChart();
        } else if (this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneDepthAge) {
            this.depthAgeChartJPanel.initChart();
        } else if (this.jTabbedPaneChart.getSelectedComponent() == this.jScrollPaneAge) {
            this.chartJPanelAge.initChart();
        }
        this.jToggleButtonFreezeHeader.setSelected(((JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent()).hasHeader());
        this.setChartSizeLabel();
    }

    @Override
    public void zoom(boolean in) {
        JScrollPaneChart scrollPane = (JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent();
        scrollPane.zoom(in);
    }

    private void jButtonChartZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void jButtonChartZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    private void jMenuItemDAAddNodeActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.addDeleteLOCNode(true, this.popupPoint);
    }

    private void jMenuItemDADeleteNodeActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.addDeleteLOCNode(false, this.popupPoint);
    }

    private void jMenuItemDAAddLOCActionPerformed(ActionEvent evt) {
        this.addLOC();
    }

    private void jMenuItemDADeriveLOCActionPerformed(ActionEvent evt) {
        this.deriveLOC();
    }

    private void jMenuItemLOCPossActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(1, this.popupPoint);
    }

    private void jMenuItemLOCProbActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(2, this.popupPoint);
    }

    private void jMenuItemConfidentActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(3, this.popupPoint);
    }

    private void jMenuItemLOCUncfActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(4, this.popupPoint);
    }

    private void jMenuItemLOCQuncfActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(5, this.popupPoint);
    }

    private void jMenuItemDADeriveStratActionPerformed(ActionEvent evt) {
        Point2D mmPoint = this.depthAgeChartJPanel.getPoint(this.popupPoint);
        ChartPanel panel = this.depthAgeChartJPanel.chart.getSelectedPanel(mmPoint);
        if (panel != null && panel instanceof PanelWellDepthAge) {
            PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
            try {
                DialogLOCIntervals dialog = new DialogLOCIntervals(this.parent, true, this.well, wellPanel.getProperties().getInterpID(), wellPanel.getProperties().getScheme());
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    wellPanel.getProperties().setScheme(dialog.scheme);
                }
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            this.depthAgeChartJPanel.repaint();
        } else {
            JOptionPane.showMessageDialog(this.parent, "No LOC panel selected", this.parent.getTitle(), 1);
        }
    }

    private void jMenuItemDAMigrateCompositeActionPerformed(ActionEvent evt) {
        Object obj = this.depthAgeChartJPanel.getObject(this.popupPoint);
        if (obj instanceof WellEvent) {
            double age;
            WellEvent wellEvent = (WellEvent)obj;
            if (wellEvent.getCharType() == ' ') {
                JOptionPane.showMessageDialog(this.parent, "You can't migrate a single event: " + wellEvent.getEvent().getName(), this.parent.getTitle(), 1);
                return;
            }
            WellInterp wellInterp = this.getInterp();
            LOC loc = wellInterp.getLOC();
            WellBlock block = this.depthAgeChartJPanel.chart.getWellBlock();
            try {
                double depth = block.well.getDepth(wellEvent.getSample(), this.depthAgeChartJPanel.chart.chartProperties.correctDepths, this.depthAgeChartJPanel.chart.chartProperties.correctCuttings);
                age = loc.getAge(depth, false);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                return;
            }
            if (age < 0.0) {
                JOptionPane.showMessageDialog(this.parent, "There is no LOC available to project onto.", this.parent.getTitle(), 1);
                return;
            }
            PanelWellDepthAge panel = null;
            for (SBPanel o : block.panels) {
                if (!(o instanceof PanelWellDepthAge)) continue;
                panel = (PanelWellDepthAge)o;
                break;
            }
            if (panel == null) {
                JOptionPane.showMessageDialog(this.parent, "No depth age panel found!", this.parent.getTitle(), 1);
                return;
            }
            CompositeStandard cmpStd = panel.getProperties().getCmpStd();
            if (cmpStd == null) {
                JOptionPane.showMessageDialog(this.parent, "No composite standard selected.", this.parent.getTitle(), 1);
                return;
            }
            if (wellEvent.getCharType() == ' ' && wellEvent.getCharType() == '\u0000') {
                JOptionPane.showMessageDialog(this, "You can't migrate a single event: " + wellEvent.getEvent().getName(), this.parent.getTitle(), 1);
                return;
            }
            CompositeStandardEvent cmpStdEvt = cmpStd.getEvent(wellEvent.getEvent().getEvID(), wellEvent.getTypeObj());
            if (cmpStdEvt == null) {
                JOptionPane.showMessageDialog(this.parent, "Event is not in composite.", this.parent.getTitle(), 1);
                return;
            }
            double cmpStdAge = cmpStd.getAge(cmpStdEvt.getCSU());
            if (wellEvent.getTypeObj() == SBEvent.EventType.TOP && age >= cmpStdAge ? JOptionPane.showConfirmDialog(this, "WARNING: LOC age (" + SB.floatString((double)age, (int)4).trim() + ") for event: " + wellEvent.getEvent().getName() + " is older than (or equal to) composite standard age (" + SB.floatString((double)cmpStdAge, (int)4).trim() + ")\nThis REDUCES the range in the composite.\nDo you still want to update it?", this.parent.getTitle(), 0, 3) != 0 : (wellEvent.getTypeObj() == SBEvent.EventType.BASE && age <= cmpStdAge ? JOptionPane.showConfirmDialog(this, "WARNING: LOC age (" + SB.floatString((double)age, (int)4).trim() + ") for event: " + wellEvent.getEvent().getName() + " is younger than (or equal to) composite standard age (" + SB.floatString((double)cmpStdAge, (int)4).trim() + ")\nThis REDUCES the range in the composite.\nDo you still want to update it?", this.parent.getTitle(), 0, 3) != 0 : JOptionPane.showConfirmDialog(this.parent, "Extend range in standard from: " + cmpStdAge + " to: " + SB.floatString((double)age, (int)4) + " for event: " + wellEvent.getEvent().getName() + "?", this.parent.getTitle(), 0, 3) != 0)) {
                return;
            }
            try {
                cmpStd.updateCsu(cmpStdEvt, age);
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
            this.depthAgeChartJPanel.repaint();
            cmpStd.notifyObservers();
        } else {
            JOptionPane.showMessageDialog(this, "No event under cursor", this.parent.getTitle(), 1);
        }
    }

    private void addEventToComposite() {
        Object obj = this.depthAgeChartJPanel.getObject(this.popupPoint);
        if (obj instanceof WellEvent) {
            double age;
            WellEvent wellEvent = (WellEvent)obj;
            WellBlock block = this.depthAgeChartJPanel.chart.getWellBlock();
            PanelWellDepthAge panel = null;
            for (SBPanel o : block.panels) {
                if (!(o instanceof PanelWellDepthAge)) continue;
                panel = (PanelWellDepthAge)o;
                break;
            }
            if (panel == null) {
                JOptionPane.showMessageDialog(this.parent, "No depth age panel found!", this.parent.getTitle(), 1);
                return;
            }
            CompositeStandard cmpStd = panel.getProperties().getCmpStd();
            if (cmpStd == null) {
                JOptionPane.showMessageDialog(this.parent, "No composite standard selected.", this.parent.getTitle(), 1);
                return;
            }
            CompositeStandardEvent cmpStdEvt = cmpStd.getEvent(wellEvent.getEvent().getEvID(), wellEvent.getTypeObj());
            if (cmpStdEvt != null) {
                JOptionPane.showMessageDialog(this.parent, "Event is already in composite!", this.parent.getTitle(), 1);
                return;
            }
            WellInterp wellInterp = this.getInterp();
            LOC loc = wellInterp.getLOC();
            if (loc == null) {
                JOptionPane.showMessageDialog(this.parent, "There is no LOC available to project onto.", this.parent.getTitle(), 1);
                return;
            }
            try {
                double depth = block.well.getDepth(wellEvent.getSample(), this.depthAgeChartJPanel.chart.chartProperties.correctDepths, this.depthAgeChartJPanel.chart.chartProperties.correctCuttings);
                age = SB.round((double)loc.getAge(depth, false), (int)4);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                return;
            }
            if (age < 0.0) {
                JOptionPane.showMessageDialog(this.parent, "There is no LOC segment available to project onto.", this.parent.getTitle(), 1);
                return;
            }
            double CSU = cmpStd.getCSU(age);
            if (CSU < 0.0) {
                JOptionPane.showMessageDialog(this, "Age is outside composite range", "Error", 2);
                return;
            }
            if (JOptionPane.showConfirmDialog(this.getParentFrame(), "Create composite standard event at: " + SB.floatString((double)age, (int)4) + " for event: " + wellEvent.getEvent().getName() + "?", this.parent.getTitle(), 0, 3) == 0) {
                try {
                    cmpStd.addEvent(new CompositeStandardEvent.Builder().event(wellEvent.getEvent()).type(wellEvent.getTypeObj()).csu(CSU));
                    this.sbdb.commit();
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(this, ife.getMessage(), "Error", 2);
                }
                catch (SQLException sql) {
                    this.sbdb.doRollback();
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
                catch (SBException sbe) {
                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                }
                catch (RuntimeException re) {
                    SB.showStackError((String)"", (Exception)re);
                }
                this.depthAgeChartJPanel.repaint();
                cmpStd.notifyObservers();
            }
        } else {
            JOptionPane.showMessageDialog(this, "No event under cursor\n(Move mouse until event shows in tooltip, zoom in if necessary)", this.parent.getTitle(), 1);
        }
    }

    private void jMenuItemDAEditEventActionPerformed(ActionEvent evt) {
        Object obj = this.depthAgeChartJPanel.getObject(this.popupPoint);
        if (obj instanceof WellEvent) {
            WellEvent wellEvent = (WellEvent)obj;
            WellBlock block = this.depthAgeChartJPanel.chart.getWellBlock();
            PanelWellDepthAge panel = null;
            for (SBPanel o : block.panels) {
                if (!(o instanceof PanelWellDepthAge)) continue;
                panel = (PanelWellDepthAge)o;
                break;
            }
            if (panel == null) {
                JOptionPane.showMessageDialog(this.parent, "No depth age panel found!", this.parent.getTitle(), 1);
                return;
            }
            WellInterp wellInterp = this.getInterp();
            DialogWellEvent dialog = new DialogWellEvent(this.getParentFrame(), true, this.sbdb, this.well, wellInterp, this.getUnits(), wellEvent, null, null, null);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "No event under cursor\n(Move mouse until event shows in tooltip, zoom in if necessary)", this.parent.getTitle(), 1);
        }
    }

    private void jMenuItemProjectPathActionPerformed(ActionEvent evt) {
        Point2D mmPoint = this.TVDOffsetChartJPanel.getPoint(this.popupPoint);
        Point2D.Float mmPointF = (Point2D.Float)mmPoint;
        Point2D.Float panelOrigin = this.TVDOffsetChartJPanel.chart.getPanelOrigin(this.getTVDPanelVS(), true, this.TVDOffsetChartJPanel.getMode(), 0.0f);
        mmPoint.setLocation(mmPointF.x, mmPointF.y - panelOrigin.y);
        boolean returnval = this.getTVDPanelVS().setPredictPoint(mmPointF);
        if (!returnval) {
            JOptionPane.showMessageDialog(this, "Vertical section must be greater than last point on deviation survey", this.parent.getTitle(), 0);
        } else {
            this.TVDOffsetChartJPanel.repaint();
        }
    }

    private void jMenuItemClearProjectionActionPerformed(ActionEvent evt) {
        this.getTVDPanelVS().setPredictPoint(null);
        this.TVDOffsetChartJPanel.repaint();
    }

    private void jMenuItemAddPointActionPerformed(ActionEvent evt) {
        try {
            Point2D mmPoint = this.TVDOffsetChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPointF = (Point2D.Float)mmPoint;
            PanelWellVS vspanel = this.getTVDPanelVS();
            float oldmax = (float)this.well.getTVDlist(false).getMaxVS();
            Chart chart = this.TVDOffsetChartJPanel.chart;
            vspanel.addPredictNode(mmPointF, this.TVDOffsetChartJPanel.chart.chartProperties, this.jScrollPaneTVDOffset.getViewMode());
            vspanel.setVS(vspanel.getProps().minVS, vspanel.getProps().maxVS + (vspanel.getVSfromPoint((float)mmPoint.getX()) - oldmax), false);
            this.TVDOffsetChartJPanel.initChart();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jMenuItemAHDAddSampleActionPerformed(ActionEvent evt) {
        try {
            float ydiff;
            Point2D pTemp = this.ahdChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            switch (this.ahdChartJPanel.getMode()) {
                case NO_HEADER: {
                    ydiff = 0.0f;
                    break;
                }
                default: {
                    ydiff = this.ahdChartJPanel.chart.getHeaderHeight();
                }
            }
            double depth = this.ahdChartJPanel.chart.getWellBlock().getDepth(mmPoint.y - ydiff);
            DialogSample dialog = new DialogSample(this.getParentFrame(), true, this.sbdb, this.well, this.getUnits(), null, false);
            dialog.setDepth(depth);
            dialog.setType("LOG");
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemAHDPickEventActionPerformed(ActionEvent evt) {
        try {
            SBEvent event;
            JDialog dialog;
            List<SBEvent> events;
            Object o = this.ahdChartJPanel.getObject(this.popupPoint);
            if (!(o instanceof PanelTaxon.PanelTaxonObject)) {
                return;
            }
            PanelTaxon.PanelTaxonObject pto = (PanelTaxon.PanelTaxonObject)o;
            Object obj = pto.getObject();
            if (this.getInterp() == null) {
                JOptionPane.showMessageDialog(this.parentPanel, "Select a version on the interpretations tab", "Select Version", 2);
                return;
            }
            Taxon taxon = null;
            if (obj instanceof Taxon) {
                taxon = (Taxon)obj;
                events = this.sbdb.getSBEvents(taxon.getSpecID());
            } else {
                events = new LinkedList();
            }
            Sample sample = pto.sample;
            if (events.isEmpty() && taxon != null) {
                dialog = new DialogEvent(this.getParentFrame(), true, this.sbdb, null, taxon);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (((DialogEvent)dialog).sbEvent == null) {
                    return;
                }
                event = ((DialogEvent)dialog).sbEvent;
            } else if (events.size() == 1) {
                event = (SBEvent)events.get(0);
            } else {
                dialog = new DialogSelectEvent((Frame)this.getParentFrame(), true, this.sbdb, events);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (((DialogSelectEvent)dialog).selection == null) {
                    return;
                }
                event = ((DialogSelectEvent)dialog).selection;
            }
            if (!this.checkEventPicked(event)) {
                return;
            }
            dialog = new DialogWellEvent(this.getParentFrame(), true, this.sbdb, this.well, this.getInterp(), this.well.getWellUnits(), null, sample, event, null);
            dialog.setLocationRelativeTo(this.parent);
            if (pto.smpdtl != null) {
                ((DialogWellEvent)dialog).setSmpdtl(pto.smpdtl.getDiscID(), pto.smpdtl.getAnalyst());
            }
            dialog.setVisible(true);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private boolean checkEventPicked(SBEvent event) {
        if (!this.getInterp().getEvents().isEmpty()) {
            boolean picked = false;
            String msg = "This taxon is already linked to events:\n\n";
            for (WellEvent e : this.getInterp().getEvents()) {
                if (e.getEvent().getEvID() != event.getEvID()) continue;
                msg = msg + e.toString() + "\n";
                picked = true;
            }
            return !picked || JOptionPane.showConfirmDialog(this.parentPanel, msg = msg + "\nContinue?\n", "Pick Event", 0) == 0;
        }
        return true;
    }

    private void jMenuItemDAAddWellEventActionPerformed(ActionEvent evt) {
        try {
            Object o = this.depthAgeChartJPanel.getObject(this.popupPoint);
            if (!(o instanceof CompositeStandardEvent)) {
                return;
            }
            SBEvent event = ((CompositeStandardEvent)o).getEvent();
            PanelWellDepthAge wellPanel = null;
            WellBlock block = this.depthAgeChartJPanel.getBlock();
            for (SBPanel p : block.panels) {
                if (!(p instanceof PanelWellDepthAge)) continue;
                wellPanel = (PanelWellDepthAge)p;
            }
            if (wellPanel == null) {
                System.out.println("In JPanel Charts, wellPanel was null");
                return;
            }
            Point2D mmPoint = this.depthAgeChartJPanel.getPoint(this.popupPoint);
            Point2D.Float panelOrigin = this.depthAgeChartJPanel.chart.getPanelOrigin(wellPanel, true, this.depthAgeChartJPanel.getMode(), 0.0f);
            Sample sample = wellPanel.getSample((float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.depthAgeChartJPanel.zoom, this.depthAgeChartJPanel.chart.chartProperties);
            if (sample == null) {
                JOptionPane.showMessageDialog(this.parentPanel, "Cursor must be over a sample", "Pick Event", 2);
                return;
            }
            if (!this.checkEventPicked(event)) {
                return;
            }
            DialogWellEvent dialog = new DialogWellEvent(this.getParentFrame(), true, this.sbdb, this.well, this.getInterp(), this.well.getWellUnits(), null, sample, event, null);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void panelProperties(ChartJPanel chartJPanel) {
        try {
            Point2D pTemp = chartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = chartJPanel.chart.getSelectedPanel(mmPoint);
            if (panel == null) {
                return;
            }
            SBDialog dialog = null;
            if (panel instanceof PanelWirelineLog) {
                PanelWirelineLog logPanel = (PanelWirelineLog)panel;
                dialog = new DialogWirelineLogPanel(this.getParentFrame(), true, logPanel, this.ahdChartJPanel.chart.getWellBlock(), this.sbdb);
            } else if (panel instanceof PanelTaxonGroup) {
                PanelTaxonGroup ptg = (PanelTaxonGroup)panel;
                float xorigin = chartJPanel.chart.getPanelOrigin((SBPanel)ptg, (boolean)false, (Chart.Mode)chartJPanel.getMode(), (float)mmPoint.x).x;
                PanelTaxonBase inner = ptg.getPanel(mmPoint.x - xorigin);
                if (inner != null) {
                    if (inner instanceof PanelTaxon) {
                        dialog = new DialogPanelTaxon(this.getParentFrame(), true, this.sbdb, ptg, (PanelTaxon)inner, this.ahdChartJPanel.chart.chartProperties, this.getInterp());
                    } else if (inner instanceof PanelDendrogram) {
                        dialog = new DialogPanelDendrogram(this.getParentFrame(), true, this.sbdb, ptg, (PanelDendrogram)inner);
                    }
                    inner.setOutline(true);
                } else {
                    dialog = new DialogPanelTaxonGroup((Frame)this.getParentFrame(), true, ptg);
                    ptg.setOutline(true);
                }
            } else if (panel instanceof PanelEnv) {
                PanelEnv envPanel = (PanelEnv)panel;
                dialog = new DialogPanelEnv(this.getParentFrame(), true, envPanel, this.sbdb, this.ahdChartJPanel.chart.getWellBlock());
            } else if (panel instanceof PanelEvents) {
                PanelEvents panelEvents = (PanelEvents)panel;
                dialog = new DialogPanelEvents((Frame)this.getParentFrame(), true, (PanelEventsBase)panelEvents, this.sbdb);
            } else if (panel instanceof PanelBiocoms) {
                PanelBiocoms panelBiocoms = (PanelBiocoms)panel;
                dialog = new DialogPanelBiocoms((Frame)this.getParentFrame(), true, panelBiocoms, this.sbdb);
            } else if (panel instanceof PanelIntcoms) {
                PanelIntcoms panelIntcoms = (PanelIntcoms)panel;
                dialog = new DialogPanelIntcoms((Frame)this.getParentFrame(), true, panelIntcoms);
            } else if (panel instanceof PanelIntLith) {
                PanelIntLith panelIntLith = (PanelIntLith)panel;
                dialog = new DialogPanelIntLith((Frame)this.getParentFrame(), true, panelIntLith);
            } else if (panel instanceof PanelDepth) {
                PanelDepth panelDepth = (PanelDepth)panel;
                dialog = new DialogPanelDepth((Frame)this.getParentFrame(), true, panelDepth);
            } else if (panel instanceof PanelSQPicks) {
                PanelSQPicks panelPicks = (PanelSQPicks)panel;
                dialog = new DialogPanelSQPicks((Frame)this.getParentFrame(), true, this.sbdb, panelPicks);
            } else if (panel instanceof PanelSamples) {
                PanelSamples panelSamples = (PanelSamples)panel;
                dialog = new DialogPanelSamples((Frame)this.getParentFrame(), true, panelSamples, this.sbdb);
            } else if (panel instanceof PanelCoreImages) {
                PanelCoreImages panelCI = (PanelCoreImages)panel;
                dialog = new DialogPanelCoreImages((Frame)this.getParentFrame(), true, panelCI, this.sbdb);
            } else if (panel instanceof PanelChromalog) {
                PanelChromalog panelCHR = (PanelChromalog)panel;
                dialog = new DialogPanelChromalog(this.getParentFrame(), true, panelCHR);
            } else if (panel instanceof PanelZones) {
                PanelZones panelZones = (PanelZones)panel;
                dialog = new DialogPanelZones((Frame)this.getParentFrame(), true, panelZones, this.sbdb);
            } else if (panel instanceof PanelWellDepthAge) {
                SBPanel panelHorz = ((PanelWellDepthAge)panel).getProperties().sBlock.getPanelHorz(mmPoint.y - this.getChartJPanel().chart.chartProperties.margin - this.getChartJPanel().chart.chartProperties.panelCaptionHeight);
                if (panelHorz instanceof PanelCompositeStandard) {
                    dialog = new DialogPanelEvents((Frame)this.getParentFrame(), true, (PanelEventsBase)((PanelCompositeStandard)panelHorz), this.sbdb);
                } else if (panelHorz instanceof PanelIGDScheme) {
                    dialog = new DialogPanelIGDScheme(this.getParentFrame(), true, (PanelIGDScheme)panelHorz);
                } else if (panelHorz instanceof PanelSurfaces) {
                    dialog = new DialogPanelSurfaces((Frame)this.getParentFrame(), true, (PanelSurfaces)panelHorz);
                }
            } else if (panel instanceof PanelIGDScheme) {
                dialog = new DialogPanelIGDScheme(this.getParentFrame(), true, (PanelIGDScheme)panel);
            } else if (panel instanceof PanelCompositeStandard) {
                dialog = new DialogPanelEvents((Frame)this.getParentFrame(), true, (PanelEventsBase)((PanelCompositeStandard)panel), this.sbdb);
            } else if (panel instanceof PanelWellHeader) {
                dialog = new DialogPanelWellHeader((Frame)this.getParentFrame(), true, (PanelWellHeader)panel);
            } else if (panel instanceof PanelSurfaces) {
                dialog = new DialogPanelSurfaces((Frame)this.getParentFrame(), true, (PanelSurfaces)panel);
            }
            if (!(panel instanceof PanelTaxonGroup)) {
                panel.setOutline(true);
            }
            if (dialog != null) {
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog instanceof SBDialog && dialog.isOK()) {
                    try {
                        chartJPanel.setCursor(Cursor.getPredefinedCursor(3));
                        if (panel instanceof SBPanel) {
                            chartJPanel.chart.setData((SBPanel)panel);
                        }
                        String key = null;
                        if (chartJPanel == this.depthAgeChartJPanel) {
                            key = this.depthAgeChartJPanel.getBlock().getPrefKey(2);
                        } else if (chartJPanel == this.chartJPanelAge) {
                            key = this.chartJPanelAge.getWellBlock().getPrefKey(4);
                        } else if (chartJPanel == this.TVDOffsetChartJPanel) {
                            key = ((WellBlock)this.TVDOffsetChartJPanel.chart.blocks.get(this.TVDOffsetChartJPanel.chart.blocks.size() - 1)).getPrefKey(3);
                        }
                        if (key != null) {
                            chartJPanel.chart.savePreference(this.sbdb, key, panel);
                            this.sbdb.commit();
                        }
                    }
                    finally {
                        chartJPanel.setCursor(Cursor.getDefaultCursor());
                    }
                }
                if (panel instanceof PanelWellDepthAge) {
                    chartJPanel.chart.chartProperties.setPanelSubHeaderHeight(((PanelWellDepthAge)panel).getProperties().sBlock.getWidth());
                }
            } else if (panel instanceof PanelWellDepthAge) {
                this.chartProperties();
            }
            chartJPanel.chart.calcChartSize();
            chartJPanel.setSize(chartJPanel.zoom);
            chartJPanel.revalidate();
            chartJPanel.repaint();
            this.setChartSizeLabel();
            panel.setOutline(false);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (IOException e) {
            SB.showStackError((String)"I/O Error", (Exception)e);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemAHDPanelPropertiesActionPerformed(ActionEvent evt) {
        this.panelProperties(this.ahdChartJPanel);
    }

    private void jMenuItemAHDAddCommentActionPerformed(ActionEvent evt) {
        try {
            DialogBiocom dialog;
            float xorigin;
            PanelTaxonGroup ptg;
            PanelTaxonBase panelTaxon;
            Object o = this.ahdChartJPanel.getObject(this.popupPoint);
            if (!(o instanceof PanelTaxon.PanelTaxonObject)) {
                return;
            }
            PanelTaxon.PanelTaxonObject pto = (PanelTaxon.PanelTaxonObject)o;
            Object obj = pto.getObject();
            if (!(obj instanceof Taxon)) {
                return;
            }
            if (this.getInterp() == null) {
                JOptionPane.showMessageDialog(this.parentPanel, "Select a version on the interpretations tab", "Select Version", 2);
                return;
            }
            Taxon taxon = (Taxon)obj;
            Sample sample = pto.sample;
            Point2D pTemp = this.ahdChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.ahdChartJPanel.chart.getSelectedPanel(mmPoint);
            char discID = '\u0000';
            if (panel instanceof PanelTaxonGroup && (panelTaxon = (ptg = (PanelTaxonGroup)panel).getPanel(mmPoint.x - (xorigin = this.ahdChartJPanel.chart.getPanelOrigin((SBPanel)ptg, (boolean)false, (Chart.Mode)this.ahdChartJPanel.getMode(), (float)mmPoint.x).x))) instanceof PanelTaxon) {
                discID = ((PanelTaxon)panelTaxon).getDiscID();
            }
            if (discID == '\u0000') {
                return;
            }
            ListIterator it = this.getInterp().getComments(discID).listIterator();
            Biocom comment = null;
            while (it.hasNext()) {
                Biocom b = (Biocom)it.next();
                if (b.getTopSample() != sample || b.getAnalyst() != pto.smpdtl.getHeader().getAnalystUsrid()) continue;
                comment = b;
                break;
            }
            if (comment != null) {
                dialog = new DialogBiocom(this.getParentFrame(), true, this.sbdb, this.well, this.getInterp(), this.well.getWellUnits(), comment, null, null);
            } else {
                dialog = new DialogBiocom(this.getParentFrame(), true, this.sbdb, this.well, this.getInterp(), this.well.getWellUnits(), null, pto.smpdtl.getSample(), null);
                dialog.setAnalyst(pto.smpdtl.getAnalyst());
                dialog.setDiscipline(Discipline.getDisc((char)pto.smpdtl.getDiscID()));
            }
            boolean abr = this.parent.isAbrBiocom();
            String text = taxon.toGenString(abr, false);
            dialog.addText(text);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemDAEventUsageActionPerformed(ActionEvent evt) {
        SBEvent event;
        block5: {
            event = null;
            try {
                Object o = this.depthAgeChartJPanel.getObject(this.popupPoint);
                if (o instanceof CompositeStandardEvent) {
                    event = ((CompositeStandardEvent)o).getEvent();
                    break block5;
                }
                if (o instanceof WellEvent) {
                    event = ((WellEvent)o).getEvent();
                    break block5;
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (event != null) {
            DialogEventOcc dialog = new DialogEventOcc((Frame)this.getParentFrame(), true, event, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
    }

    public JLabel getJLabelInfo() {
        return this.jLabelInfo;
    }

    public void setJLabelInfoText(String text) {
        this.jLabelInfo.setText(text);
    }

    public void setJLabelInfoColour(Color colour) {
        this.jLabelInfo.setForeground(colour);
    }

    void setChartSizeLabel() {
        this.jLabelChartSize.setText((int)Math.floor(this.getChartJPanel().chart.getMMwidth()) + " x " + (int)Math.floor(this.getChartJPanel().chart.getMMheight()) + " mm");
    }

    void setUndoTooltips() {
        this.jButtonUndo.setToolTipText(this.getUndoTooltip(true));
        this.jButtonRedo.setToolTipText(this.getUndoTooltip(false));
    }

    private String getUndoTooltip(boolean undo) {
        if (this.parentPanel.inStartup) {
            return null;
        }
        UndoManager manager = this.getChartJPanel().getUndoManager();
        if (manager == null) {
            return null;
        }
        if (undo) {
            return this.getChartJPanel().getUndoManager().getUndoPresentationName() + " (Ctrl + Z)";
        }
        return this.getChartJPanel().getUndoManager().getRedoPresentationName() + " (Ctrl + Shift + Z)";
    }

    @Override
    public void undoRedo(boolean undo) {
        UndoManager manager = this.getChartJPanel().getUndoManager();
        if (manager == null || undo && !manager.canUndo() || !undo && !manager.canRedo()) {
            this.getToolkit().beep();
            return;
        }
        if (undo) {
            manager.undo();
        } else {
            manager.redo();
        }
        this.getChartJPanel().repaint();
        this.setUndoTooltips();
    }

    private void jButtonUndoActionPerformed(ActionEvent evt) {
        this.undoRedo(true);
    }

    private void jButtonRedoActionPerformed(ActionEvent evt) {
        this.undoRedo(false);
    }

    private void jMenuItemDepthAgeOtherPanelPropertiesActionPerformed(ActionEvent evt) {
        this.panelProperties(this.getChartJPanel());
    }

    private void jMenuItemDepthAgeAddToCompositeActionPerformed(ActionEvent evt) {
        this.addEventToComposite();
    }

    private void jMenuItemAGEPanelPropertiesActionPerformed(ActionEvent evt) {
        this.panelProperties(this.getChartJPanel());
    }

    private void jMenuItemLOCFaultActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(6, this.popupPoint);
    }

    private void jMenuItemLOCQFaultActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(7, this.popupPoint);
    }

    private void jMenuItemLOCRFaultActionPerformed(ActionEvent evt) {
        this.depthAgeChartJPanel.UpdateLOCNodeBnd(8, this.popupPoint);
    }

    private void jMenuItemAHDDeleteObjectActionPerformed(ActionEvent evt) {
        try {
            Object o = this.ahdChartJPanel.getObject(this.popupPoint);
            Point2D pTemp = this.ahdChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.ahdChartJPanel.chart.getSelectedPanel(mmPoint);
            UndoManager manager = this.getChartJPanel().getUndoManager();
            try {
                if (o instanceof LithBase) {
                    manager.addEdit((UndoableEdit)this.well.deleteLithBase((LithBase)o));
                } else if (o instanceof Biocom && panel instanceof PanelBiocoms) {
                    PanelBiocoms panelBiocoms = (PanelBiocoms)panel;
                    manager.addEdit((UndoableEdit)this.well.getInterp(panelBiocoms.interpID).deleteBiocom((Biocom)o, this.well.getWellID()));
                }
            }
            catch (SQLException sql) {
                this.sbdb.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            this.ahdChartJPanel.repaint();
            this.setUndoTooltips();
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemAHDLithPaletteActionPerformed(ActionEvent evt) {
        this.parent.showLithPalette(this);
    }

    private void jMenuItemAHDLithUpdateActionPerformed(ActionEvent evt) {
        try {
            Object o = this.ahdChartJPanel.getObject(this.popupPoint);
            Lithology selectedLithology = this.parent.getLithPalette().getSelectedLithology();
            if (o instanceof LithInterval && selectedLithology != null) {
                this.getChartJPanel().getUndoManager().addEdit(this.well.updateLithInterval((LithInterval)o, selectedLithology));
            }
            this.ahdChartJPanel.repaint();
            this.setUndoTooltips();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemAHDLithFillActionPerformed(ActionEvent evt) {
        try {
            this.getChartJPanel().getUndoManager().addEdit(this.well.fillLithIntervals(this.parent.getLithPalette().getSelectedLithology()));
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sqle) {
            this.sbdb.doRollback();
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
    }

    private void jMenuItemAHDDuplicateActionPerformed(ActionEvent evt) {
        try {
            Point2D pTemp = this.ahdChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.ahdChartJPanel.chart.getSelectedPanel(mmPoint);
            if (panel instanceof PanelTaxonGroup) {
                PanelTaxonGroup existing = (PanelTaxonGroup)panel;
                PanelTaxonGroup newPanel = existing.duplicate();
                existing.getBlock().panels.add(existing.getBlock().panels.indexOf(existing) + 1, newPanel);
                this.ahdChartJPanel.chart.setData(newPanel);
                this.ahdChartJPanel.chart.calcChartSize();
                this.ahdChartJPanel.setSize(this.ahdChartJPanel.zoom);
                this.ahdChartJPanel.revalidate();
                this.ahdChartJPanel.repaint();
                this.jScrollPaneAHD.setHeader(this.jToggleButtonFreezeHeader.isSelected());
                this.setChartSizeLabel();
            } else assert (false);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (IOException e) {
            SB.showStackError((String)"I/O Error", (Exception)e);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jMenuItemAHDRemoveActionPerformed(ActionEvent evt) {
        try {
            float xorigin;
            PanelTaxonGroup ptg;
            PanelTaxonBase inner;
            Point2D pTemp = this.ahdChartJPanel.getPoint(this.popupPoint);
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.ahdChartJPanel.chart.getSelectedPanel(mmPoint);
            int opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove this panel?", "Remove panel", 0);
            if (opt != 0) {
                return;
            }
            boolean removed = false;
            if (panel instanceof PanelTaxonGroup && (inner = (ptg = (PanelTaxonGroup)panel).getPanel(mmPoint.x - (xorigin = this.ahdChartJPanel.chart.getPanelOrigin((SBPanel)ptg, (boolean)false, (Chart.Mode)this.ahdChartJPanel.getMode(), (float)mmPoint.x).x))) != null && ptg.size() > 1) {
                ptg.removePanel(inner);
                removed = true;
            }
            if (!removed) {
                ChartBlock selectedBlock = this.ahdChartJPanel.chart.getSelectedBlock(mmPoint);
                selectedBlock.removePanel(panel);
                if (selectedBlock instanceof WellBlock && panel instanceof SBPanel) {
                    ((WellBlock)selectedBlock).removedPanels.add((SBPanel)panel);
                }
            }
            this.ahdChartJPanel.chart.calcChartSize();
            this.ahdChartJPanel.setSize(this.ahdChartJPanel.zoom);
            this.ahdChartJPanel.revalidate();
            this.ahdChartJPanel.repaint();
            this.jScrollPaneAHD.setHeader(this.jToggleButtonFreezeHeader.isSelected());
            this.setChartSizeLabel();
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jToggleButtonFreezeHeaderActionPerformed(ActionEvent evt) {
        ((JScrollPaneChart)this.jTabbedPaneChart.getSelectedComponent()).setHeader(this.jToggleButtonFreezeHeader.isSelected());
        this.getChartJPanel().setSize();
    }

    private void jMenuItemDAGoToAnalysisActionPerformed(ActionEvent evt) {
        CompositeStandardEvent event;
        Object object = this.depthAgeChartJPanel.getObject(this.popupPoint);
        Taxon taxon = null;
        if (object instanceof CompositeStandardEvent) {
            event = (CompositeStandardEvent)object;
            taxon = event.getEvent().getTaxon();
        } else if (object instanceof WellEvent) {
            event = (WellEvent)object;
            taxon = event.getEvent().getTaxon();
        } else {
            System.out.println("Returning from jMenuItemDAGoToAnalysis with object: " + object.toString());
            return;
        }
        if (taxon == null) {
            JOptionPane.showMessageDialog(this, "Event has no taxon", "Go to Occurrence", 1);
            return;
        }
        Point2D pTemp = this.depthAgeChartJPanel.getPoint(this.popupPoint);
        Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
        ChartPanel panel = this.depthAgeChartJPanel.chart.getSelectedPanel(mmPoint);
        if (!(panel instanceof PanelWellDepthAge)) {
            return;
        }
        PanelWellDepthAge daPanel = (PanelWellDepthAge)panel;
        Point2D.Float panelOrigin = this.depthAgeChartJPanel.chart.getPanelOrigin(daPanel, true, this.depthAgeChartJPanel.getMode(), mmPoint.x);
        Sample sample = daPanel.getSample((float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.depthAgeChartJPanel.zoom, this.depthAgeChartJPanel.chart.chartProperties);
        if (sample == null) {
            JOptionPane.showMessageDialog(this, "No analyses under cursor", "Go to Occurrence", 1);
            return;
        }
        Smpdtl targetDtl = null;
        TaxonOcc targetOcc = null;
        block0: for (Smpdtl dtl : sample.getAnalyses()) {
            for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                if (occ.getTaxon() != taxon) continue;
                targetDtl = dtl;
                targetOcc = occ;
                break block0;
            }
        }
        if (targetDtl == null) {
            JOptionPane.showMessageDialog(this, "No analyses near cursor with occurrences of " + taxon.toString(false, false), "Go to occurrence", 1);
            return;
        }
        this.parentPanel.setSmpdtl(targetDtl);
        this.parentPanel.setSelectedTaxonOcc(targetOcc);
    }

    private void jMenuItemAHDSavePanelTaxonActionPerformed(ActionEvent evt) {
        float xorigin;
        Point2D pTemp = this.ahdChartJPanel.getPoint(this.popupPoint);
        Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
        ChartPanel panel = this.ahdChartJPanel.chart.getSelectedPanel(mmPoint);
        PanelTaxonGroup ptg = (PanelTaxonGroup)panel;
        PanelTaxonBase inner = ptg.getPanel(mmPoint.x - (xorigin = this.ahdChartJPanel.chart.getPanelOrigin((SBPanel)ptg, (boolean)false, (Chart.Mode)this.ahdChartJPanel.getMode(), (float)mmPoint.x).x));
        if (inner instanceof PanelTaxon) {
            this.saveTaxonPanel(ptg, (PanelTaxon)inner);
        }
    }

    private void jMenuItemDAPanelPropertiesActionPerformed(ActionEvent evt) {
        this.panelProperties(this.depthAgeChartJPanel);
    }

    void saveTaxonPanel(PanelTaxonGroup p, PanelTaxon panel) {
        int option;
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", "Export", 2);
            return;
        }
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)p.getDb(), (String)"WINPTGFILE", (String)"UNXPTGFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser1.setFileFilter((FileFilter)filter);
        String fileName = null;
        if (0 == jFileChooser1.showSaveDialog(this) && (fileName = jFileChooser1.getSelectedFile().getPath()).indexOf(".csv") < 0 && fileName.indexOf(".CSV") < 0) {
            fileName = fileName + ".csv";
        }
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        if (file.exists() && (option = JOptionPane.showConfirmDialog(this, "Overwrite file '" + fileName + "?", "Save taxon data", 1, 3)) != 0) {
            return;
        }
        try {
            p.saveText(file, panel);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error writing file: " + ioe.getMessage(), "Save taxon data", 2);
            return;
        }
        try {
            Lastval.putString((SBdb)p.getDb(), (String)"WINPTGFILE", (String)"UNXPTGFILE", (String)file.getPath());
            p.getDb().commit();
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        JOptionPane.showMessageDialog(this, "File written.", "Save taxon data", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveChart(boolean vector) throws SBException {
        Chart chart = this.getChartJPanel().chart;
        if (chart == null) {
            JOptionPane.showMessageDialog(this.parent, "No chart selected/created. Use the Chart tab and select chart", this.parent.getTitle(), 1);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        for (ImageFileType vtype : ImageFileType.values()) {
            if (vtype.isVector() != vector) continue;
            jFileChooser.addChoosableFileFilter((FileFilter)vtype.filter);
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = vector ? new File(Lastval.getString((SBdb)this.sbdb, (String)"WINVECIMG", (String)"UNXVECIMG")) : new File(Lastval.getString((SBdb)this.sbdb, (String)"WINRASIMG", (String)"UNXRASIMG"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            jFileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (0 == jFileChooser.showSaveDialog(this)) {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (jFileChooser.getSelectedFile().exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                    return;
                }
                setDir = jFileChooser.getSelectedFile();
                SbugsFileFilter filter = (SbugsFileFilter)jFileChooser.getFileFilter();
                if (filter == null) {
                    ImageFileType type;
                    if (setDir.getName().lastIndexOf(".") > 0 && (type = ImageFileType.getType(setDir.getName().substring(setDir.getName().lastIndexOf(".") + 1))) != null) {
                        filter = type.getFilter();
                    }
                    if (filter == null) {
                        filter = ImageFileType.getDefaultFilter(vector);
                    }
                }
                if (!setDir.getName().endsWith("." + filter.getExtension())) {
                    setDir = new File(setDir.getPath() + "." + filter.getExtension());
                }
                if (vector) {
                    final File dir = setDir;
                    final ImageFileType type = ImageFileType.getType(filter.getExtension());
                    final JPanelCharts messageParent = this;
                    final DialogProcessing dialog = new DialogProcessing((Frame)this.parent, true);
                    dialog.setMessage("Writing image file...");
                    dialog.setLocationRelativeTo(this);
                    new SwingWorker(){
                        boolean done;

                        protected Object doInBackground() throws IOException, TranscoderException {
                            try {
                                JPanelCharts.saveVectorImage(dir, type, ((JPanelCharts)JPanelCharts.this).getChartJPanel().chart, JPanelCharts.this.sbdb, JPanelCharts.this.parent.getParent().isDemoLicense());
                                dialog.setComplete();
                            }
                            catch (FileNotFoundException fnf) {
                                JOptionPane.showMessageDialog(messageParent, fnf.getMessage(), "Error saving chart", 0);
                                dialog.setMessage(fnf.getMessage());
                            }
                            catch (IOException ioe) {
                                SB.showStackError((String)"IO Error creating file", (Exception)ioe);
                            }
                            catch (NoClassDefFoundError c) {
                                JOptionPane.showMessageDialog(messageParent, "A required library may be missing - please contct your system administrator\n" + c.getMessage(), "Error saving chart", 0);
                            }
                            catch (OutOfMemoryError e) {
                                JOptionPane.showMessageDialog(messageParent, "Error writing image - out of memory!\nNote that some chart panels are more memory-intensive than others:\ntry removing lithology and wireline log panels, or save to SVG.", "Memory error", 0);
                            }
                            catch (Exception e) {
                                SB.showStackError((String)"Error creating file", (Exception)e);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            dialog.dispose();
                        }
                    }.execute();
                    dialog.setVisible(true);
                    if (!dialog.isTaskComplete()) {
                        return;
                    }
                } else {
                    RenderedImage img;
                    block28: {
                        img = this.getChartImage();
                        if (img != null) break block28;
                        JOptionPane.showMessageDialog(this, "Not enough memory to write this image", "Image", 2);
                        return;
                    }
                    try {
                        if (ImageIO.write(img, filter.getExtension(), setDir)) {
                            System.out.println("Image written.");
                        }
                    }
                    catch (Exception e) {
                        SB.showStackError((String)"Error writing file", (Exception)e);
                    }
                }
                try {
                    Lastval.putString((SBdb)this.sbdb, (String)(vector ? "WINVECIMG" : "WINRASIMG"), (String)setDir.getPath());
                    this.sbdb.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            JOptionPane.showMessageDialog(this, "Image written.", "Export image", 1);
        }
    }

    public RenderedImage getChartImage() {
        Chart chart = this.getChartJPanel().chart;
        int nPix = (int)(chart.getMMheight() * chart.getMMwidth());
        long maxMemory = Runtime.getRuntime().maxMemory();
        System.out.println("maxMemory: " + maxMemory + " nPix: " + nPix);
        float scale = (float)Math.sqrt(maxMemory / (long)(nPix * 20));
        if (scale > 10.0f) {
            scale = 10.0f;
        } else if (scale < 1.0f) {
            return null;
        }
        System.out.println("Using scale : " + scale);
        int width = (int)(chart.getMMwidth() * scale);
        int height = (int)(chart.getMMheight() * scale);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setClip(0, 0, width, height);
        AffineTransform tnf = new AffineTransform();
        tnf.scale(scale / 100.0f, scale / 100.0f);
        g.transform(tnf);
        SBGraphics sbg = new SBGraphics(g, null, true, true);
        sbg.setColor(Color.WHITE);
        sbg.fillRect(0.0f, 0.0f, width, height);
        g.setColor(Color.BLACK);
        chart.draw(sbg, Chart.Mode.NORMAL);
        return bufferedImage;
    }

    public static void saveVectorImage(File file, ImageFileType type, Chart chart, SBdb sbdb, boolean demoLicense) throws IOException {
        assert (type.isVector());
        switch (type) {
            case SVG: {
                Document doc = JPanelCharts.createSVGFile(file, chart, sbdb, demoLicense);
                break;
            }
            case PDF: {
                Document doc = JPanelCharts.createPDFFile(file, chart, demoLicense);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static Document createSVGFile(File svgFile, Chart chart, SBdb sbdb, boolean demoLicense) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            document = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException p) {
            p.printStackTrace();
        }
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setComment("Generated in StrataBugs version v2.0 on " + DateFormat.getDateInstance(2).format(new Date()) + " by " + sbdb.licence.getCompany() + ", " + sbdb.licence.getLocation());
        SVGGraphics2D g = new SVGGraphics2D(ctx, false);
        int width = (int)chart.getMMwidth();
        int height = (int)chart.getMMheight();
        g.setSVGCanvasSize(new Dimension((int)((float)width * 2.8346457f), (int)((float)height * 2.8346457f)));
        AffineTransform tnf = new AffineTransform();
        tnf.scale(0.028346456587314606, 0.028346456587314606);
        g.transform(tnf);
        g.setClip(0, 0, (int)((float)width * 100.0f), (int)((float)height * 100.0f));
        SBGraphics sbg = new SBGraphics((Graphics2D)g, null, true, true);
        sbg.setColor(Color.WHITE);
        sbg.fillRect(0.0f, 0.0f, width, height);
        if (demoLicense) {
            chart.drawWatermark(sbg, true);
        } else {
            chart.draw(sbg, Chart.Mode.NORMAL);
        }
        try {
            g.stream(svgFile.getAbsolutePath());
        }
        catch (SVGGraphics2DIOException e) {
            e.printStackTrace();
        }
        return document;
    }

    private static Document createPDFFile(File pdfFile, Chart chart, boolean demoLicense) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            document = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException p) {
            p.printStackTrace();
        }
        PDFDocumentGraphics2D g = new PDFDocumentGraphics2D(false);
        g.setGraphicContext(new GraphicContext());
        try {
            JPanelCharts.configure(g, JPanelCharts.createAutoFontsConfiguration());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        OutputStream out = new FileOutputStream(pdfFile);
        out = new BufferedOutputStream(out);
        int width = (int)chart.getMMwidth();
        int height = (int)chart.getMMheight();
        g.setupDocument(out, (int)UnitConv.mm2pt((double)width), (int)UnitConv.mm2pt((double)height));
        AffineTransform tnf = new AffineTransform();
        tnf.scale(0.028346456587314606, 0.028346456587314606);
        g.transform(tnf);
        int clipW = (int)((double)((float)width * 100.0f) * 4.2);
        int clipH = (int)((double)((float)height * 100.0f) * 4.2);
        g.setClip(0, 0, clipW, clipH);
        SBGraphics sbg = new SBGraphics((Graphics2D)((Object)g), null, true, true);
        sbg.setColor(Color.WHITE);
        sbg.fillRect(0.0f, 0.0f, width, height);
        if (demoLicense) {
            chart.drawWatermark(sbg, true);
        } else {
            chart.draw(sbg, Chart.Mode.NORMAL);
        }
        g.finish();
        out.flush();
        out.close();
        return document;
    }

    private static Configuration createAutoFontsConfiguration() {
        DefaultConfiguration c = new DefaultConfiguration("cfg");
        DefaultConfiguration fonts = new DefaultConfiguration("fonts");
        c.addChild(fonts);
        DefaultConfiguration autodetect = new DefaultConfiguration("auto-detect");
        fonts.addChild(autodetect);
        return c;
    }

    private static void configure(PDFDocumentGraphics2D g2d, Configuration cfg) throws ConfigurationException {
        PDFDocumentGraphics2DConfigurator configurator = new PDFDocumentGraphics2DConfigurator();
        boolean useComplexScriptFeatures = false;
        configurator.configure(g2d, cfg, useComplexScriptFeatures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transcodeSVGFile(File file, File svgFile) throws IOException, TranscoderException {
        PDFTranscoder transcoder = new PDFTranscoder();
        FileInputStream in = new FileInputStream(svgFile);
        try {
            TranscoderInput input = new TranscoderInput((InputStream)in);
            OutputStream out = new FileOutputStream(file);
            out = new BufferedOutputStream(out);
            try {
                TranscoderOutput output = new TranscoderOutput(out);
                transcoder.transcode(input, output);
            }
            finally {
                out.close();
            }
        }
        finally {
            ((InputStream)in).close();
            svgFile.delete();
        }
    }

    void writeHTMLChart() {
        Chart chart;
        if (!(this.getChartJPanel() instanceof ChartJPanelAHD)) {
            JOptionPane.showMessageDialog(this, "You can only export from the standard chart.", "Export chart", 2);
        }
        if ((chart = this.getChartJPanel().chart) == null) {
            JOptionPane.showMessageDialog(this, "No chart", "Export Chart", 2);
            return;
        }
        File file = FrameJsbugs.chooseFile(this.sbdb, this.parent, "WINHTMLCHT", "UNXHTMLCHT", new String[]{"html"}, new String[]{"html"}, null);
        try {
            FileWriter out = new FileWriter(file);
            try {
                this.getChartJPanel().chart.writeHTML(out);
            }
            catch (SBException sbe) {
                JOptionPane.showMessageDialog(this, "Error exporting chart: " + sbe.getMessage(), "Export chart", 2);
                out.close();
                return;
            }
            out.close();
            JOptionPane.showMessageDialog(this, "File written.", "Export Chart", 1);
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(this, "Error writing file: " + io.getMessage(), "Output HTML", 0);
            io.printStackTrace();
        }
    }

    public static enum ImageFileType {
        SVG("svg", true),
        PDF("pdf", true),
        PNG("png", false),
        GIF("gif", false),
        JPG("jpg", false);

        private final boolean vector;
        private final String extension;
        private final SbugsFileFilter filter;

        private ImageFileType(String extension, boolean vector) {
            this.vector = vector;
            this.extension = extension;
            this.filter = new SbugsFileFilter(extension.toLowerCase(), extension.toUpperCase());
        }

        public String getExtension() {
            return this.extension;
        }

        public SbugsFileFilter getFilter() {
            return this.filter;
        }

        public boolean isVector() {
            return this.vector;
        }

        public static ImageFileType getType(String ex) {
            for (ImageFileType type : ImageFileType.values()) {
                if (!ex.equalsIgnoreCase(type.getExtension())) continue;
                return type;
            }
            return null;
        }

        public static SbugsFileFilter getDefaultFilter(boolean vector) {
            if (vector) {
                return PDF.getFilter();
            }
            return JPG.getFilter();
        }
    }
}

