/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelCmpStd;
import model2.CompositeStandard;
import model2.SBdb;
import util.InvalidFieldException;
import util.SB;

public class JPanelCmpStdHeader
extends JPanel {
    private final TableModelCmpStd model;
    private ButtonGroup buttonGroupAge;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JRadioButton jRadioButtonAge;
    private JRadioButton jRadioButtonCSU;
    private JTextField jTextFieldBaseCSU;
    private JTextField jTextFieldMaxAge;
    private JTextField jTextFieldMinAge;
    private JTextField jTextFieldName;
    private JTextField jTextFieldTopCSU;

    public JPanelCmpStdHeader(TableModelCmpStd model) {
        if (model == null) {
            throw new IllegalArgumentException("Attempt to create composite standard header panel with null table model");
        }
        this.model = model;
        this.initComponents();
    }

    public void setNameField(String name) {
        this.model.setNameField(name);
        this.jTextFieldName.setText(this.model.stdName);
    }

    public void setModelAge() {
        this.model.setAgeScale(this.jRadioButtonAge.isSelected());
    }

    public void setFields() {
        this.jTextFieldName.setText(this.model.stdName);
        if (!this.model.isAgeScale) {
            this.jRadioButtonCSU.setSelected(true);
            this.jTextFieldTopCSU.setText("" + this.model.topCSU);
            this.jTextFieldTopCSU.setEnabled(true);
            this.jTextFieldBaseCSU.setText("" + this.model.baseCSU);
            this.jTextFieldBaseCSU.setEnabled(true);
        } else {
            this.jRadioButtonAge.setSelected(true);
            this.jTextFieldTopCSU.setEnabled(false);
            this.jTextFieldTopCSU.setText("");
            this.jTextFieldBaseCSU.setEnabled(false);
            this.jTextFieldBaseCSU.setText("");
        }
        this.jTextFieldMinAge.setText("" + this.model.minAge);
        this.jTextFieldMaxAge.setText("" + this.model.maxAge);
    }

    public String getTopCSUString() {
        return this.jTextFieldTopCSU.getText().trim();
    }

    public String getBaseCSUString() {
        return this.jTextFieldBaseCSU.getText().trim();
    }

    public boolean isAgeScale() {
        return this.jRadioButtonAge.isSelected();
    }

    public void validateFields(SBdb db, CompositeStandard cmpStd) throws InvalidFieldException {
        String name = this.jTextFieldName.getText().trim();
        if (name.isEmpty()) {
            throw new InvalidFieldException("Enter a name");
        }
        try {
            for (CompositeStandard std : db.getCompositeStandards()) {
                if (cmpStd != null && std.getStdID() == cmpStd.getStdID() || !name.equalsIgnoreCase(std.getName())) continue;
                throw new InvalidFieldException("New name is already used by an existing Composite Standard");
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, db);
            return;
        }
        this.model.stdName = name;
        String minAgeString = this.jTextFieldMinAge.getText().trim();
        String maxAgeString = this.jTextFieldMaxAge.getText().trim();
        if (minAgeString.isEmpty() || maxAgeString.isEmpty()) {
            throw new InvalidFieldException("Enter minimum and maximum ages");
        }
        double minAge = Double.parseDouble(minAgeString);
        double maxAge = Double.parseDouble(maxAgeString);
        this.model.minAge = minAge;
        this.model.maxAge = maxAge;
        if (minAge < 0.0 || maxAge < 0.0 || maxAge - minAge <= 1.0E-6) {
            throw new InvalidFieldException("Invalid age range");
        }
        boolean isAgeScale = this.isAgeScale();
        if (!isAgeScale) {
            double baseCSU;
            String topCSUString = this.jTextFieldTopCSU.getText().trim();
            String baseCSUString = this.jTextFieldBaseCSU.getText().trim();
            if (topCSUString.isEmpty() || baseCSUString.isEmpty()) {
                throw new InvalidFieldException("Enter top and base CSU");
            }
            double topCSU = Double.parseDouble(topCSUString);
            if (Math.abs(topCSU - (baseCSU = Double.parseDouble(baseCSUString))) < 1.0) {
                throw new InvalidFieldException("No CSU range specified");
            }
            this.model.topCSU = topCSU;
            this.model.baseCSU = baseCSU;
        } else {
            this.model.baseCSU = 0.0;
            this.model.topCSU = 0.0;
        }
    }

    private void initComponents() {
        this.buttonGroupAge = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldBaseCSU = new JTextField();
        this.jTextFieldTopCSU = new JTextField();
        this.jTextFieldName = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldMaxAge = new JTextField();
        this.jTextFieldMinAge = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jRadioButtonAge = new JRadioButton();
        this.jRadioButtonCSU = new JRadioButton();
        this.jLabel1.setText("Name:");
        this.jLabel2.setText("Top CSU:");
        this.jLabel3.setText("Base CSU:");
        this.jTextFieldBaseCSU.setEnabled(false);
        this.jTextFieldBaseCSU.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldBaseCSUFocusLost(evt);
            }
        });
        this.jTextFieldBaseCSU.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldBaseCSUKeyTyped(evt);
            }
        });
        this.jTextFieldTopCSU.setEnabled(false);
        this.jTextFieldTopCSU.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldTopCSUFocusLost(evt);
            }
        });
        this.jTextFieldTopCSU.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldTopCSUKeyTyped(evt);
            }
        });
        this.jTextFieldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldNameFocusLost(evt);
            }
        });
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Min age:");
        this.jLabel6.setText("Max age:");
        this.jTextFieldMaxAge.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldMaxAgeFocusLost(evt);
            }
        });
        this.jTextFieldMaxAge.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldMaxAgeKeyTyped(evt);
            }
        });
        this.jTextFieldMinAge.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldMinAgeFocusLost(evt);
            }
        });
        this.jTextFieldMinAge.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JPanelCmpStdHeader.this.jTextFieldMinAgeKeyTyped(evt);
            }
        });
        this.jLabel7.setText("Ma");
        this.jLabel8.setText("Ma");
        this.buttonGroupAge.add(this.jRadioButtonAge);
        this.jRadioButtonAge.setSelected(true);
        this.jRadioButtonAge.setText("CSUs are ages");
        this.jRadioButtonAge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCmpStdHeader.this.jRadioButtonAgeActionPerformed(evt);
            }
        });
        this.buttonGroupAge.add(this.jRadioButtonCSU);
        this.jRadioButtonCSU.setText("Ages are derived from CSUs");
        this.jRadioButtonCSU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelCmpStdHeader.this.jRadioButtonCSUActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldTopCSU).addComponent(this.jTextFieldBaseCSU, -2, 113, -2)).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldMinAge).addComponent(this.jTextFieldMaxAge, -2, 99, -2))).addComponent(this.jTextFieldName, -2, 277, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAge).addComponent(this.jRadioButtonCSU)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel1)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCSU)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldTopCSU, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel5).addComponent(this.jTextFieldMinAge, -2, -1, -2).addComponent(this.jLabel7)).addGap(26, 26, 26)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldBaseCSU, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jTextFieldMaxAge, -2, -1, -2).addComponent(this.jLabel8)).addGap(1, 1, 1)))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jTextFieldMinAgeFocusLost(FocusEvent evt) {
        double minAge;
        try {
            minAge = Double.parseDouble(this.jTextFieldMinAge.getText().trim());
        }
        catch (NumberFormatException e) {
            minAge = -1.0;
        }
        this.model.setMinAge(minAge);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldMinAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMinAge, (int)7, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMaxAgeFocusLost(FocusEvent evt) {
        double age;
        try {
            age = Double.parseDouble(this.jTextFieldMaxAge.getText().trim());
        }
        catch (NumberFormatException e) {
            age = -1.0;
        }
        this.model.setMaxAge(age);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldMaxAgeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMaxAge, (int)7, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopCSUFocusLost(FocusEvent evt) {
        double csu;
        try {
            csu = Double.parseDouble(this.jTextFieldTopCSU.getText().trim());
        }
        catch (NumberFormatException e) {
            csu = -1.0;
        }
        this.model.setTopCSU(csu);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldTopCSUKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldTopCSU, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseCSUFocusLost(FocusEvent evt) {
        double csu;
        try {
            csu = Double.parseDouble(this.jTextFieldBaseCSU.getText().trim());
        }
        catch (NumberFormatException e) {
            csu = -1.0;
        }
        this.model.setBaseCSU(csu);
        this.model.fireTableDataChanged();
    }

    private void jTextFieldBaseCSUKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldBaseCSU, (int)5, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonAgeActionPerformed(ActionEvent evt) {
        if (this.jTextFieldTopCSU.isEnabled()) {
            this.jTextFieldTopCSU.setEnabled(false);
            this.jTextFieldBaseCSU.setEnabled(false);
            this.model.fireTableDataChanged();
        }
        this.model.setAgeScale(true);
    }

    private void jRadioButtonCSUActionPerformed(ActionEvent evt) {
        if (!this.jTextFieldTopCSU.isEnabled()) {
            this.jTextFieldTopCSU.setEnabled(true);
            this.jTextFieldBaseCSU.setEnabled(true);
            this.model.fireTableDataChanged();
        }
        this.model.setAgeScale(false);
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldNameFocusLost(FocusEvent evt) {
        this.model.setNameField(this.jTextFieldName.getText().trim());
    }
}

