/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.InternalFrameGroup;
import jsbugs.PanelGroupsTableModel;
import model2.SBChart;
import model2.SBdb;
import model2.TxGroup;
import util.SB;
import util.SBException;
import util.TableSorter;

public class JPanelGroups
extends JPanel
implements Observer {
    private final SBdb sbdb;
    private final FrameTaxaDB parent;
    private final PanelGroupsTableModel modelGroup = new PanelGroupsTableModel();
    private final TableSorter sorter = new TableSorter((TableModel)this.modelGroup);
    private Point mousePoint;
    private JMenuItem jMenuItemColour;
    private JMenuItem jMenuItemGroupDelete;
    private JMenuItem jMenuItemGroupName;
    private JPopupMenu jPopupMenuGroups;
    private JScrollPane jScrollPane1;
    private JPopupMenu.Separator jSeparator1;
    private JTable jTableGroup;

    public JPanelGroups(FrameTaxaDB parent, SBdb db) throws SQLException {
        this.initComponents();
        this.parent = parent;
        this.sbdb = db;
        this.init();
    }

    private void init() throws SQLException {
        this.modelGroup.setupTable(this.jTableGroup);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableGroup);
        this.modelGroup.groups.addAll(this.sbdb.getTxGroups());
        Collections.sort(this.modelGroup.groups);
        for (TxGroup group : this.modelGroup.groups) {
            group.addObserver((Observer)this);
        }
        this.sbdb.addObserver((Observer)this);
        this.sorter.reallocateIndexes();
        this.jTableGroup.repaint();
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs instanceof TxGroup) {
            this.sorter.reallocateIndexes();
            this.sorter.sort((Object)this);
            this.sorter.fireTableDataChanged();
        } else if (obj instanceof TxGroup) {
            try {
                this.modelGroup.groups.clear();
                this.modelGroup.groups.addAll(this.sbdb.getTxGroups());
                Collections.sort(this.modelGroup.groups);
                for (TxGroup group : this.modelGroup.groups) {
                    group.addObserver((Observer)this);
                }
                this.sorter.reallocateIndexes();
                this.sorter.sort((Object)this);
                this.sorter.fireTableDataChanged();
                int index = this.modelGroup.groups.indexOf(obj);
                if (index >= 0) {
                    index = this.sorter.getIndexOf(index);
                    this.jTableGroup.setRowSelectionInterval(index, index);
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error loading groups", sql, this.sbdb);
            }
        }
    }

    private int getRowOf(Object o) {
        for (int i = 0; i < this.modelGroup.groups.size(); ++i) {
            if (this.modelGroup.groups.get(this.sorter.getIndexOf(i)) != o) continue;
            return i;
        }
        return -1;
    }

    TxGroup getSelectedGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            return null;
        }
        return this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
    }

    void editGroupColour() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            Color colour = JColorChooser.showDialog(this, "Select Group Colour", group.getColour());
            if (colour != null && !colour.equals(group.getColour())) {
                group.setColour(colour);
                this.sbdb.commit();
                group.notifyObservers();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error saving group colour", sql, this.sbdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showCharts() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        LinkedList<SBChart> groupCharts = new LinkedList<SBChart>();
        try {
            this.parent.setCursor(Cursor.getPredefinedCursor(3));
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList charts = new LinkedList();
            SBChart.load((SBdb)this.sbdb, charts, (String)"%");
            for (SBChart chart : charts) {
                chart.loadData();
                if (!chart.hasGroup(group.getID())) continue;
                groupCharts.add(chart);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.parent.setCursor(Cursor.getDefaultCursor());
        }
        if (!groupCharts.isEmpty()) {
            DialogList dialog = new DialogList(this.parent, true, "Charts containing group: " + group.toString(), this.sbdb, groupCharts, false, false);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.parent, "Group does not appear in any charts.", group.getName(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to delete", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            List sets = group.getSets();
            if (!sets.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Group belongs to sets - remove group from the following set(s) first. ", this.parent.getTitle(), 0);
                DialogList dialog = new DialogList((Frame)null, true, group.toString(), this.sbdb, sets, false, false);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, "Really delete group: " + group.getName() + "?", this.parent.getTitle(), 0, 3) != 0) {
                return;
            }
            int opt = JOptionPane.showConfirmDialog(this, "Check charts for this group?", this.parent.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                LinkedList<SBChart> groupCharts = new LinkedList<SBChart>();
                LinkedList charts = new LinkedList();
                SBChart.load((SBdb)this.sbdb, charts, (String)"%");
                for (SBChart chart : charts) {
                    chart.loadData();
                    if (!chart.hasGroup(group.getID())) continue;
                    groupCharts.add(chart);
                }
                if (!groupCharts.isEmpty()) {
                    DialogList dialog = new DialogList((Frame)null, true, "Charts containing group: " + group.toString(), this.sbdb, groupCharts, false, false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Group not linked to charts.\nContinue to delete?", this.parent.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            this.sbdb.deleteTxGroup(group);
            this.sbdb.commit();
            this.jTableGroup.clearSelection();
            this.modelGroup.groups.remove(group);
            this.sorter.reallocateIndexes();
            this.sorter.sort((Object)this);
            this.jTableGroup.repaint();
            this.parent.removeInternalFrameGroup(group);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void addGroup() throws SQLException, SBException {
        String name = JOptionPane.showInputDialog(this, (Object)"Name");
        if (name == null) {
            return;
        }
        if (this.sbdb.getTxGroup(name) != null) {
            JOptionPane.showMessageDialog(this, "A group of that name already exists", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.sbdb.addTxGroup(name, null, -1);
        this.sbdb.commit();
        group.addObserver((Observer)this);
        int index = this.getRowOf(group);
        this.jTableGroup.setRowSelectionInterval(index, index);
        this.jTableGroup.scrollRectToVisible(this.jTableGroup.getCellRect(index, 0, true));
        this.jTableGroup.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void editGroup() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            InternalFrameGroup frame = this.parent.getGroupFrame(group);
            if (frame != null) {
                frame.setVisible(true);
                frame.setLocation(50, 50);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.parent.createInternalFrameGroup(group);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void editGroupName() {
        if (this.jTableGroup.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one group to edit", this.parent.getTitle(), 2);
            return;
        }
        TxGroup group = this.modelGroup.groups.get(this.sorter.getIndexOf(this.jTableGroup.getSelectedRow()));
        try {
            String newName = JOptionPane.showInputDialog(this, "Name", group.getName());
            if (newName == null) {
                return;
            }
            if (newName.length() > 30) {
                newName = newName.substring(0, 30);
            }
            if (!newName.equals(group.getName())) {
                group.setName(newName);
                this.sbdb.commit();
                this.jTableGroup.clearSelection();
                group.notifyObservers();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error updating group name", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error updating group name", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void setSelectedGroup(TxGroup group) {
        if (this.getSelectedGroup() == group) {
            return;
        }
        for (int row = 0; row < this.modelGroup.getRowCount(); ++row) {
            if (this.jTableGroup.getValueAt(row, 0) != group) continue;
            this.jTableGroup.setRowSelectionInterval(row, row);
        }
    }

    private void initComponents() {
        this.jPopupMenuGroups = new JPopupMenu();
        this.jMenuItemGroupName = new JMenuItem();
        this.jMenuItemColour = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemGroupDelete = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTableGroup = new JTable();
        this.jMenuItemGroupName.setText("Rename");
        this.jMenuItemGroupName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelGroups.this.jMenuItemGroupNameActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemGroupName);
        this.jMenuItemColour.setText("Edit group colour");
        this.jMenuItemColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelGroups.this.jMenuItemColourActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemColour);
        this.jPopupMenuGroups.add(this.jSeparator1);
        this.jMenuItemGroupDelete.setText("Delete");
        this.jMenuItemGroupDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelGroups.this.jMenuItemGroupDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuGroups.add(this.jMenuItemGroupDelete);
        this.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(0, 200));
        this.setPreferredSize(new Dimension(100, 436));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 402));
        this.jTableGroup.setModel((TableModel)this.sorter);
        this.jTableGroup.setSelectionMode(0);
        this.jTableGroup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelGroups.this.jTableGroupMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                JPanelGroups.this.jTableGroupMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JPanelGroups.this.jTableGroupMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableGroup);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 80, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 425, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTableGroupMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editGroup();
        }
    }

    private void jMenuItemGroupNameActionPerformed(ActionEvent evt) {
        this.editGroupName();
    }

    private void jTableGroupMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenuGroups.show(evt.getComponent(), (int)this.mousePoint.getX(), (int)this.mousePoint.getY());
        }
    }

    private void jTableGroupMousePressed(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.mousePoint = evt.getPoint();
            int row = this.jTableGroup.rowAtPoint(evt.getPoint());
            this.jTableGroup.clearSelection();
            this.jTableGroup.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private void jMenuItemColourActionPerformed(ActionEvent evt) {
        this.editGroupColour();
    }

    private void jMenuItemGroupDeleteActionPerformed(ActionEvent evt) {
        this.deleteGroup();
    }
}

