/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.DialogMatchAnalyses;
import jsbugs.DialogMatchBiocoms;
import jsbugs.DialogMatchCasing;
import jsbugs.DialogMatchCores;
import jsbugs.DialogMatchIGDIntervals;
import jsbugs.DialogMatchIntLith;
import jsbugs.DialogMatchIntcom;
import jsbugs.DialogMatchMarkers;
import jsbugs.DialogMatchPalaeoenvs;
import jsbugs.DialogMatchSampleLithology;
import jsbugs.DialogMatchSamples;
import jsbugs.DialogMatchSqpick;
import jsbugs.DialogMatchWellEvents;
import jsbugs.DialogMatchWellHeader;
import jsbugs.FrameOrganiser;
import jsbugs.TableModelOrganiser;
import model2.AnalystHeader;
import model2.Biocom;
import model2.CasingPoint;
import model2.CoredInterval;
import model2.IGDInterval;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.Intcom;
import model2.InterpHdr;
import model2.LOC;
import model2.LithBase;
import model2.Project;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.SampleLithology;
import model2.SeismicMarker;
import model2.Smpdtl;
import model2.TVDList;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.DTMonitor;
import util.SB;
import util.SBException;
import util.TableSorter;

public class JPanelOrganiser
extends JPanel
implements Observer {
    TableModelOrganiser model = new TableModelOrganiser();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb ws;
    SBdb db;
    List<Integer> dataTypes;
    InterpHdr hdr;
    FrameOrganiser parent;
    private JScrollPane jScrollPane1;
    private JTable jTableOrg;

    public JPanelOrganiser(FrameOrganiser parent, SBdb ws, SBdb db, InterpHdr hdr, List<Integer> dataTypes) {
        this.parent = parent;
        this.ws = ws;
        this.db = db;
        this.hdr = hdr;
        this.dataTypes = dataTypes;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.model.setupTable(this.jTableOrg);
        this.model.setDataTypes(this.jTableOrg, null);
        this.model.setInterp(this.hdr);
        this.jTableOrg.setSelectionBackground(new Color(204, 51, 51));
        this.setName();
        if (this.model.wsWells != null) {
            System.out.println("In JPanelOrganiser init(), model.wsWells is not null");
            for (WsWell wsWell : this.model.wsWells) {
                if (wsWell.getLink() == null) continue;
                wsWell.getLink().addObserver((Observer)this);
            }
        }
    }

    public void setName() {
        if (this.hdr != null) {
            String name = this.hdr.toString();
            if (this.hdr.getLink() != null) {
                name = name + " > " + this.hdr.getLink().toString();
            }
            this.setName(name);
        } else {
            this.setName("Non-version data");
        }
    }

    JTable getJtableOrg() {
        return this.jTableOrg;
    }

    TableSorter getSorter() {
        return this.sorter;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableOrg = new JTable();
        this.jTableOrg.setModel((TableModel)this.sorter);
        this.jTableOrg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelOrganiser.this.jTableOrgMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableOrg);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 865, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 865, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 421, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 421, Short.MAX_VALUE));
    }

    private void jTableOrgMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.viewData();
        }
    }

    void refreshView(boolean reload) throws SQLException, SBException {
        if (reload) {
            if (this.ws == null) {
                return;
            }
            if (this.model.wsWells != null) {
                for (WsWell well : this.model.wsWells) {
                    Well dbWell = well.getLink();
                    if (dbWell == null) continue;
                    dbWell.deleteObserver((Observer)this);
                    if (this.hdr == null) continue;
                    dbWell.getAddInterp(this.hdr).deleteObserver((Observer)this);
                }
            }
            Project project = this.ws.getProject(0);
            Iterator it = project.getWellIterator();
            boolean row = false;
            this.model.wsWells = new LinkedList<WsWell>();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                if (well.getLink() != null) {
                    well.getLink().addObserver((Observer)this);
                }
                if (this.hdr != null) {
                    well.getAddInterp(this.hdr);
                    if (this.hdr.getLink() != null && well.getLink() != null) {
                        well.getLink().getAddInterp(this.hdr.getLink()).addObserver((Observer)this);
                    }
                }
                this.model.wsWells.add(well);
                for (int j = 1; j < 27; ++j) {
                    if (j == 1 || this.dataTypes.contains(new Integer(j))) continue;
                    if (this.hdr == null && !SBdb.isInterpDataType((int)j)) {
                        well.unloadData(j, 0);
                        continue;
                    }
                    if (this.hdr == null || !SBdb.isInterpDataType((int)j)) continue;
                    well.unloadData(j, this.hdr.getInterpID());
                }
            }
        }
        this.model.setDataTypes(this.jTableOrg, this.dataTypes);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    void viewData() {
        try {
            int row = this.sorter.getIndexOf(this.jTableOrg.getSelectedRow());
            int column = this.jTableOrg.convertColumnIndexToModel(this.jTableOrg.getSelectedColumn());
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (row > -1) {
                if (column > 0) {
                    int columnType = this.model.getColumnType(column);
                    WsWell well = this.model.wsWells.get(row);
                    switch (columnType) {
                        case 1: {
                            DialogMatchSamples dialogMatchSamples = new DialogMatchSamples((Frame)this.parent, true, well, well.getPrefUnits(this.model.units));
                            dialogMatchSamples.setLocationRelativeTo(this);
                            dialogMatchSamples.setVisible(true);
                            break;
                        }
                        case 2: {
                            DialogMatchAnalyses dialog = new DialogMatchAnalyses(this.parent, true, this.ws, this.db, well, well.getPrefUnits(this.model.units), 'M');
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            break;
                        }
                        case 6: {
                            DialogMatchAnalyses dialog = new DialogMatchAnalyses(this.parent, true, this.ws, this.db, well, well.getPrefUnits(this.model.units), 'P');
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            break;
                        }
                        case 4: {
                            DialogMatchAnalyses dialog = new DialogMatchAnalyses(this.parent, true, this.ws, this.db, well, well.getPrefUnits(this.model.units), 'N');
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            break;
                        }
                        case 8: {
                            DialogMatchAnalyses dialog = new DialogMatchAnalyses(this.parent, true, this.ws, this.db, well, well.getPrefUnits(this.model.units), 'A');
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            DialogMatchIGDIntervals dialog = new DialogMatchIGDIntervals(this.parent, true, this.ws, this.db, well, well.getPrefUnits(this.model.units), this.hdr, IGDInterval.dType2IGDtype((int)columnType));
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            break;
                        }
                        case 15: {
                            DialogMatchPalaeoenvs dialogMatchPalaeoenvs = new DialogMatchPalaeoenvs(this.parent, true, well, well.getPrefUnits(this.model.units), this.hdr);
                            dialogMatchPalaeoenvs.setLocationRelativeTo(this);
                            dialogMatchPalaeoenvs.setVisible(true);
                            break;
                        }
                        case 14: {
                            DialogMatchSqpick dialogMatchSqpicks = new DialogMatchSqpick(this.parent, true, this.ws, this.db, well, well.getPrefUnits(this.model.units), this.hdr);
                            dialogMatchSqpicks.setLocationRelativeTo(this);
                            dialogMatchSqpicks.setVisible(true);
                            break;
                        }
                        case 16: {
                            DialogMatchWellEvents dialogMatchWellEvents = new DialogMatchWellEvents(this.parent, true, this.ws, this.db, well, well.getPrefUnits(this.model.units), this.hdr);
                            dialogMatchWellEvents.setLocationRelativeTo(this);
                            dialogMatchWellEvents.setVisible(true);
                            break;
                        }
                        case 17: {
                            DTMonitor monitor = (DTMonitor)this.model.getValueAt(row, column);
                            String strg = "Workspace: " + monitor.getStatusString() + "\n";
                            strg = strg + "Database: " + monitor.dbStatusString();
                            if (monitor.getStatus() == DTMonitor.CONFLICT) {
                                strg = strg + "\nConflict reason: " + well.getInterp(this.hdr.getInterpID()).getLOC().getConflictReason();
                            }
                            JOptionPane.showMessageDialog(this.parent, strg, "LOC range", 1);
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 7: 
                        case 9: {
                            DialogMatchBiocoms dialogMatchBioComs = new DialogMatchBiocoms(this.parent, true, this.ws, this.db, well, SBdb.dt2discID((int)columnType), well.getPrefUnits(this.model.units), this.hdr);
                            dialogMatchBioComs.setLocationRelativeTo(this);
                            dialogMatchBioComs.setVisible(true);
                            break;
                        }
                        case 18: {
                            DialogMatchIntcom dialogMatchIntcom = new DialogMatchIntcom(this.parent, true, this.db, well, well.getPrefUnits(this.model.units), this.hdr);
                            dialogMatchIntcom.setLocationRelativeTo(this);
                            dialogMatchIntcom.setVisible(true);
                            break;
                        }
                        case 21: {
                            DialogMatchIntLith dialogMatchIntLith = new DialogMatchIntLith(this.parent, true, well, well.getPrefUnits(this.model.units), this.ws, this.db);
                            dialogMatchIntLith.setLocationRelativeTo(this);
                            dialogMatchIntLith.setVisible(true);
                            break;
                        }
                        case 24: {
                            DialogMatchMarkers dialogMatchMarkers = new DialogMatchMarkers((Frame)this.parent, true, well, well.getPrefUnits(this.model.units));
                            dialogMatchMarkers.setLocationRelativeTo(this);
                            dialogMatchMarkers.setVisible(true);
                            break;
                        }
                        case 19: {
                            DialogMatchCores dialogMatchCores = new DialogMatchCores((Frame)this.parent, true, well, well.getPrefUnits(this.model.units));
                            dialogMatchCores.setLocationRelativeTo(this);
                            dialogMatchCores.setVisible(true);
                            break;
                        }
                        case 20: {
                            DialogMatchCasing dialogMatchCasing = new DialogMatchCasing((Frame)this.parent, true, well, well.getPrefUnits(this.model.units));
                            dialogMatchCasing.setLocationRelativeTo(this);
                            dialogMatchCasing.setVisible(true);
                            break;
                        }
                        case 22: {
                            DialogMatchSampleLithology dialogMatchSampleLith = new DialogMatchSampleLithology(this.parent, true, well, this.db, this.ws, well.getPrefUnits(this.model.units));
                            dialogMatchSampleLith.setLocationRelativeTo(this);
                            dialogMatchSampleLith.setVisible(true);
                            break;
                        }
                    }
                } else {
                    WsWell well = this.model.wsWells.get(row);
                    DialogMatchWellHeader dialogMatchWellHeader = new DialogMatchWellHeader(this.parent, true, this.ws, this.db, well);
                    dialogMatchWellHeader.setLocationRelativeTo(this);
                    dialogMatchWellHeader.setVisible(true);
                }
            }
            this.refreshView(false);
        }
        catch (SBException se) {
            se.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + se.getMessage(), "StrataBugs Error", 0);
        }
        catch (SQLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), "StrataBugs Error", 0);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.sorter.fireTableDataChanged();
    }

    void setUnits(char units) {
        if (this.model.units != units) {
            this.model.units = units;
            for (WsWell well : this.model.wsWells) {
                well.resetDataMonitors();
            }
            this.sorter.fireTableDataChanged();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        block56: {
            System.out.println("In JPanelOrganiser update(), o is " + o + " and arg is " + arg);
            if (this.parent.isSavingData) {
                System.out.println("Not refreshing status during data save due to isSavingData flag");
                return;
            }
            try {
                if (o instanceof Well) {
                    Well well = (Well)o;
                    for (WsWell wsWell : this.model.wsWells) {
                        if (arg != null) {
                            if (wsWell.getLink() == null || wsWell.getLink().getWellID() != well.getWellID()) continue;
                            if (arg.getClass() == Sample.class || arg == Sample.class || arg == Smpdtl.class) {
                                wsWell.updateSampleStatus(true);
                            } else if (arg instanceof AnalystHeader) {
                                wsWell.updateAnalystHeadersStatus();
                            } else if (arg instanceof SeismicMarker) {
                                wsWell.updateMarkersStatus(true);
                            } else if (arg instanceof CasingPoint) {
                                wsWell.updateCasingStatus(true);
                            } else if (arg instanceof CoredInterval) {
                                wsWell.updateCoreStatus(true);
                            } else if (arg instanceof TVDList) {
                                wsWell.updateTVDStatus(true);
                            } else if (arg instanceof LithBase) {
                                wsWell.updateLithologyStatus(true);
                            } else if (arg instanceof SampleLithology) {
                                wsWell.updateSampleLithologyStatus(true);
                            } else if (arg instanceof WellInterp) {
                                Iterator it = wsWell.getInterpIterator();
                                while (it.hasNext()) {
                                    WellInterp wsInterp = (WellInterp)it.next();
                                    if (wsInterp.getHeader().getLink() == null || wsInterp.getHeader().getLink().getInterpID() != ((WellInterp)arg).getHeader().getInterpID()) continue;
                                    wsWell.updateInterpStatus((WellInterp)arg, wsWell.getWellUnits());
                                    break;
                                }
                            } else {
                                System.out.println("JPanelOrganiser calling default updateStatus on wsWell " + wsWell);
                                wsWell.updateStatus();
                            }
                            this.refreshView(false);
                            break block56;
                        }
                        wsWell.updateStatus();
                        this.refreshView(false);
                    }
                    break block56;
                }
                if (o instanceof WellInterp && arg != null) {
                    WellInterp interp = (WellInterp)o;
                    WsWell foundWell = null;
                    for (WsWell wsWell : this.model.wsWells) {
                        if (wsWell.getLink() == null || !wsWell.getLink().getAddInterp(this.hdr.getLink()).equals(interp)) continue;
                        foundWell = wsWell;
                        break;
                    }
                    if (foundWell != null) {
                        int igdType = 0;
                        if (arg.getClass() == Integer.class) {
                            igdType = (Integer)arg;
                        } else if (arg.getClass() == IGDIntervalZone.class) {
                            IGDIntervalZone zone = (IGDIntervalZone)arg;
                            igdType = zone.getIGDType();
                        } else if (arg == IGDIntervalZone.class) {
                            igdType = 3;
                        } else if (arg.getClass() == Biocom.class) {
                            igdType = 19;
                        } else if (arg.getClass() == IGDIntervalEnv.class) {
                            igdType = 5;
                        } else if (arg.getClass() == SQPick.class) {
                            igdType = 21;
                        } else if (arg.getClass() == WellEvent.class) {
                            igdType = 20;
                        } else if (arg.getClass() == Intcom.class) {
                            igdType = 22;
                        } else if (arg.getClass() == LOC.class) {
                            igdType = 23;
                        }
                        switch (igdType) {
                            case 2: 
                            case 3: 
                            case 4: {
                                foundWell.updateZoneStatus(foundWell.getAddInterp(this.hdr), interp.getHeader(), igdType, foundWell.getWellUnits(), true);
                                break;
                            }
                            case 19: {
                                foundWell.updateAllBCMStatus(foundWell.getAddInterp(this.hdr), interp.getHeader(), foundWell.getWellUnits(), true);
                                break;
                            }
                            case 5: {
                                foundWell.updateEnvStatus(foundWell.getAddInterp(this.hdr), interp.getHeader(), foundWell.getWellUnits(), true);
                                break;
                            }
                            case 21: {
                                foundWell.updateSQPickStatus(foundWell.getAddInterp(this.hdr), interp.getHeader(), foundWell.getWellUnits(), true);
                                break;
                            }
                            case 20: {
                                foundWell.updateEventsStatus(foundWell.getAddInterp(this.hdr), interp.getHeader(), foundWell.getWellUnits(), true);
                                break;
                            }
                            case 22: {
                                foundWell.updateIntcomStatus(foundWell.getAddInterp(this.hdr), interp.getHeader(), foundWell.getWellUnits(), true);
                                break;
                            }
                            case 23: {
                                foundWell.updateLOCStatus(foundWell.getAddInterp(this.hdr), interp.getHeader(), foundWell.getWellUnits(), true);
                                break;
                            }
                            default: {
                                System.out.println("JPanelOrganiser doing default update...");
                                foundWell.updateInterpStatus(interp, foundWell.getLink().getWellUnits());
                            }
                        }
                        this.refreshView(false);
                    }
                }
            }
            catch (SQLException sql) {
                JOptionPane.showMessageDialog(this.parent, "SQL error during Organiser refresh: \n" + sql.getMessage(), this.parent.getTitle(), 0);
                sql.printStackTrace();
            }
            catch (SBException sbe) {
                JOptionPane.showMessageDialog(this.parent, "Error refreshing Organser table: " + sbe.getMessage(), this.parent.getTitle(), 0);
                sbe.printStackTrace();
            }
        }
    }

    int getInterpID() {
        if (this.hdr == null) {
            return 0;
        }
        return this.hdr.getInterpID();
    }
}

