/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.DialogSelectGroup;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogSpecType;
import jsbugs.DialogTaxon;
import jsbugs.DialogTaxonImages;
import jsbugs.FrameJsbugs;
import jsbugs.FrameSamples;
import jsbugs.TaxonTransferHandler;
import model2.AbnScheme;
import model2.Lastval;
import model2.SBdb;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TaxonQual;
import model2.TxGroup;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsCompoundEdit;

public class JPanelPicklist
extends JPanel
implements Observer {
    private FrameSamples parent;
    private SBdb sbdb;
    private DefaultListModel picklistModel = new DefaultListModel();
    private DefaultComboBoxModel abundModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel specTypeModel = new DefaultComboBoxModel();
    AbnScheme abnScheme = null;
    static final String SELECT_STRING = "<select>";
    private static boolean sampleTotalMessage = false;
    private UndoableEditSupport undoSupport = new UndoableEditSupport();
    private String tempCount = "";
    private boolean changed = false;
    private TxGroup group = null;
    private Boolean groupAutoSave = null;
    private ButtonGroup buttonGroupConfidence;
    private ButtonGroup buttonGroupPickSort;
    private ButtonGroup buttonGroupQualifiers;
    private ButtonGroup buttonGroupSituation;
    private JButton jButtonAddToSample;
    private JButton jButtonClearAll;
    private JButton jButtonClearSelected;
    private JButton jButtonInsertGroup;
    private JButton jButtonInsertTaxa;
    private JButton jButtonInsertWell;
    private JButton jButtonRestore;
    private JButton jButtonSelectSpecType;
    private JButton jButtonTaxonImage;
    private JCheckBox jCheckBoxCaved;
    private JCheckBox jCheckBoxMarker;
    private JComboBox jComboBoxAbund;
    private JComboBox jComboBoxSpecType;
    private JLabel jLabel1;
    private JLabel jLabelCoarse;
    private JLabel jLabelFine;
    private JLabel jLabelMedium;
    private JList jListPick;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JRadioButton jRadioButtonAff;
    private JRadioButton jRadioButtonCategory;
    private JRadioButton jRadioButtonCf;
    private JRadioButton jRadioButtonConfident;
    private JRadioButton jRadioButtonGenus;
    private JRadioButton jRadioButtonGrp;
    private JRadioButton jRadioButtonInSitu;
    private JRadioButton jRadioButtonNone;
    private JRadioButton jRadioButtonQuestionable;
    private JRadioButton jRadioButtonReworked;
    private JRadioButton jRadioButtonSpecies;
    private JRadioButton jRadioButtonSpp;
    private JScrollPane jScrollPanePicklist;
    private JToolBar.Separator jSeparator1;
    private JSpinner jSpinnerCoarse;
    private JSpinner jSpinnerFine;
    private JSpinner jSpinnerMedium;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;

    public JPanelPicklist(FrameSamples parent, SBdb sbdb) {
        this.parent = parent;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    void setGroup(TxGroup group) {
        this.group = group;
        group.addObserver((Observer)this);
    }

    DefaultListModel getModel() {
        return this.picklistModel;
    }

    boolean isChanged() {
        if (this.picklistModel.isEmpty()) {
            return false;
        }
        return this.changed;
    }

    boolean isEmpty() {
        return this.picklistModel.isEmpty();
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs == this.sbdb && obj == Taxon.class) {
            if (this.picklistModel != null) {
                Enumeration itT = this.picklistModel.elements();
                while (itT.hasMoreElements()) {
                    Taxon t = (Taxon)itT.nextElement();
                    if (this.sbdb.hasTaxon(t)) continue;
                    this.picklistModel.removeElement(t);
                }
                this.jListPick.repaint();
            }
        } else if (obs.getClass() == Taxon.class) {
            this.jListPick.repaint();
        } else if (obs.getClass() == TxGroup.class && obs == this.group) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JPanelPicklist.this.setTaxa(JPanelPicklist.this.sbdb.getTxGroupTaxa(JPanelPicklist.this.group));
                        JPanelPicklist.this.parent.setPicklistGroupTitle(JPanelPicklist.this.group);
                    }
                    catch (Exception ex) {
                        SB.showStackError((String)ex.toString(), (Exception)ex);
                    }
                    JPanelPicklist.this.jListPick.repaint();
                }
            });
        }
    }

    public void resetSampleTotalMessage() {
        sampleTotalMessage = false;
    }

    void setControls(boolean isCMF, boolean isNumeric) {
        this.jLabelMedium.setText(isCMF ? "Medium:" : "Counts:");
        if (isNumeric) {
            this.jLabelCoarse.setEnabled(isCMF);
            this.jSpinnerCoarse.setEnabled(isCMF);
            this.jLabelFine.setEnabled(isCMF);
            this.jSpinnerFine.setEnabled(isCMF);
        } else {
            if (this.parent.isNumeric() || this.abundModel.getSize() == 0) {
                this.fillAbundCombo();
            }
            this.jLabelCoarse.setEnabled(false);
            this.jSpinnerCoarse.setEnabled(false);
            this.jLabelFine.setEnabled(false);
            this.jSpinnerFine.setEnabled(false);
        }
        this.jComboBoxAbund.setEnabled(!isNumeric);
        this.jLabelMedium.setEnabled(isNumeric);
        this.jSpinnerMedium.setEnabled(isNumeric);
    }

    private boolean addToSample(boolean fromListClick) {
        if (!this.parent.occurrencesTabSelected()) {
            JOptionPane.showMessageDialog(this, "Select the Occurrences tab to record sample data", this.parent.getTitle(), 2);
            return true;
        }
        Smpdtl smpdtl = this.parent.getTableModelOcc().smpdtl;
        int sampID = smpdtl.getSample().getSampID();
        if (smpdtl == null) {
            JOptionPane.showMessageDialog(this, "Make a selection from list of analyses", this.parent.getTitle(), 2);
            return true;
        }
        this.parent.getWellPanel().stopCellEditor();
        TaxonOcc newOcc = null;
        Well well = this.parent.getWellPanel().getWell();
        int count = 0;
        int coarse = 0;
        int fine = 0;
        String subjAbund = null;
        boolean single = false;
        try {
            Object[] taxa;
            if (this.parent.isNumeric()) {
                this.jSpinnerMedium.commitEdit();
                count = Integer.parseInt("" + this.jSpinnerMedium.getValue());
                if (this.jSpinnerCoarse.isEnabled() && this.jSpinnerFine.isEnabled()) {
                    this.jSpinnerCoarse.commitEdit();
                    this.jSpinnerFine.commitEdit();
                    coarse = Integer.parseInt("" + this.jSpinnerCoarse.getValue());
                    fine = Integer.parseInt("" + this.jSpinnerFine.getValue());
                }
                if (!this.tempCount.isEmpty()) {
                    count = Integer.parseInt(this.tempCount);
                }
                if (fromListClick && this.tempCount.isEmpty()) {
                    single = true;
                }
            } else {
                AbnScheme a;
                subjAbund = "" + this.jComboBoxAbund.getSelectedItem();
                if (subjAbund.equals(SELECT_STRING)) {
                    subjAbund = "";
                }
                if ((a = this.parent.getAbnScheme()) != this.abnScheme) {
                    this.fillAbundCombo();
                }
                if (this.abnScheme == null) {
                    JOptionPane.showMessageDialog(this, "No abundance scheme specified", this.parent.getTitle(), 2);
                    return true;
                }
                if ((subjAbund = this.abnScheme.getAbr(subjAbund)).length() == 0) {
                    subjAbund = "+";
                }
            }
            if ((taxa = this.jListPick.getSelectedValues()).length == 0) {
                JOptionPane.showMessageDialog(this, "No taxa selected.", this.parent.getTitle(), 2);
                return true;
            }
            int specTypeID = this.sbdb.getSpecType((String)this.jComboBoxSpecType.getSelectedItem());
            for (Object o : taxa) {
                Taxon taxon = (Taxon)o;
                try {
                    boolean reworked = this.jRadioButtonReworked.isSelected();
                    boolean questionable = this.jRadioButtonQuestionable.isSelected();
                    boolean incremented = false;
                    if (!this.jRadioButtonNone.isSelected()) {
                        boolean found = false;
                        List tlist = Taxon.search((SBdb)this.sbdb, (String)taxon.getCatMnem(), (boolean)false, (String)taxon.getGenusName(), (String)taxon.getSubGenus(), (String)(this.jRadioButtonSpp.isSelected() ? "spp." : taxon.getSpecies()), (String)taxon.getSubSpecies(), (String)"", (String)this.getNull(taxon.getQualifier(0).toString()), (String)this.getNull(taxon.getQualifier(1).toString()), (String)this.getNull(taxon.getQualifier(2).toString()), (String)this.getNull(taxon.getQualifier(2).toString()), (String)this.getNull(taxon.getQualifier(4).toString()), (String)this.getNull(taxon.getQualifier(5).toString()), (String)this.getNull(taxon.getQualifier(6).toString()), (String)this.getNull(taxon.getQualifier(7).toString()));
                        for (Taxon t : tlist) {
                            if (!t.getSubGenus().equalsIgnoreCase(taxon.getSubGenus())) continue;
                            if (this.jRadioButtonSpp.isSelected()) {
                                taxon = t;
                                found = true;
                                break;
                            }
                            if (this.jRadioButtonAff.isSelected() && t.getQ1().hasQual(TaxonQual.AFF)) {
                                taxon = t;
                                found = true;
                                break;
                            }
                            if (this.jRadioButtonCf.isSelected() && t.getQ1().hasQual(TaxonQual.CF)) {
                                taxon = t;
                                found = true;
                                break;
                            }
                            if (!this.jRadioButtonGrp.isSelected() || !t.getQ2().hasQual(TaxonQual.GRP)) continue;
                            taxon = t;
                            found = true;
                            break;
                        }
                        if (!found) {
                            DialogTaxon dialog = new DialogTaxon(this.parent, true, this.sbdb, taxon, true);
                            if (this.jRadioButtonSpp.isSelected()) {
                                dialog.setSpecies("spp.");
                            } else if (this.jRadioButtonAff.isSelected()) {
                                dialog.setSq1(TaxonQual.AFF);
                            } else if (this.jRadioButtonCf.isSelected()) {
                                dialog.setSq1(TaxonQual.CF);
                            } else if (this.jRadioButtonGrp.isSelected()) {
                                dialog.setSq2(TaxonQual.GRP);
                            }
                            dialog.setLocationRelativeTo(this);
                            dialog.setVisible(true);
                            if (dialog.taxon == null) {
                                return true;
                            }
                            taxon = dialog.taxon;
                        }
                    }
                    TaxonOcc fss = smpdtl.getFss(taxon, reworked, questionable ? (char)'?' : 'P', specTypeID);
                    if (this.parent.isNumeric()) {
                        boolean exceededTotal = false;
                        if (smpdtl.getTotalCount() >= this.parent.getPicklistTotaliser() && this.parent.getPicklistTotaliser() > 0 && (fromListClick || count > 0)) {
                            exceededTotal = true;
                            boolean beeped = false;
                            if (!sampleTotalMessage) {
                                this.getToolkit().beep();
                                beeped = true;
                                JOptionPane.showMessageDialog(this, "Total count reached", "Samples", 1);
                                sampleTotalMessage = true;
                            }
                            if (fss != null && fromListClick) {
                                if (!beeped) {
                                    this.getToolkit().beep();
                                }
                                return true;
                            }
                            this.jSpinnerMedium.setValue(0);
                            this.jSpinnerCoarse.setValue(0);
                            this.jSpinnerFine.setValue(0);
                            count = 0;
                            coarse = 0;
                            fine = 0;
                        }
                        if (fss != null) {
                            if (fss.getSubAbund() != null && fss.getSubAbund().length() > 0 && JOptionPane.showConfirmDialog(this, "Occurrence is already recorded semi-quantitatively.\nClear semi-quantitative abundance?", "Abundance", 0, 3) != 0) {
                                return true;
                            }
                            if (!exceededTotal) {
                                if (count < 0 && fss.getTotalCount() == 0) {
                                    this.getToolkit().beep();
                                    return true;
                                }
                                SbugsCompoundEdit compoundEdit = new SbugsCompoundEdit("increment occurrence");
                                compoundEdit.addEdit((UndoableEdit)smpdtl.incrementOcc(well.getWellID(), sampID, fss, 2, single ? 1 : count, true));
                                if (coarse != 0 && !single) {
                                    compoundEdit.addEdit((UndoableEdit)smpdtl.incrementOcc(well.getWellID(), sampID, fss, 1, coarse, true));
                                }
                                if (fine != 0 && !single) {
                                    compoundEdit.addEdit((UndoableEdit)smpdtl.incrementOcc(well.getWellID(), sampID, fss, 3, fine, true));
                                }
                                compoundEdit.end();
                                this.parent.getWellPanel().getUndoSupport().postEdit((UndoableEdit)compoundEdit);
                            }
                            incremented = true;
                            newOcc = fss;
                        }
                    }
                    if (!incremented) {
                        if (fss != null) {
                            JOptionPane.showMessageDialog(this.parent, "An occurrence of " + fss.getTaxon() + " already exists in analysis", this.parent.getTitle(), 2);
                            continue;
                        }
                        Smpdtl.OccAddDelete edit = smpdtl.insertOccurrence(new TaxonOcc.Builder(this.sbdb, taxon, reworked, questionable, specTypeID).count(coarse, count, fine).subjAbund(subjAbund).marker(this.jCheckBoxMarker.isSelected()).caved(this.jCheckBoxCaved.isSelected()), well.getWellID());
                        this.parent.getWellPanel().getUndoSupport().postEdit((UndoableEdit)edit);
                        newOcc = edit.getOccurrence();
                    }
                    this.sbdb.commit();
                    smpdtl.notifyObservers();
                }
                catch (SBException e) {
                    SB.showStackError((String)"Error", (Exception)((Object)e));
                }
            }
            this.sbdb.commit();
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error in picklist", sqle, this.sbdb);
            this.sbdb.doRollback();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
            this.sbdb.doRollback();
        }
        this.jListPick.setToolTipText(null);
        smpdtl.notifyObservers();
        this.parent.getWellPanel().setBarren(smpdtl.getBarren());
        this.parent.getWellPanel().setSelectedTaxonOcc(newOcc);
        if (this.parent.playOccSounds()) {
            this.parent.playOccSound();
        }
        return false;
    }

    static void addToSample(Taxon taxon, int count, String subjAbund, boolean rw, boolean cv, boolean questionable, FrameSamples parent, SBdb sbdb) throws SBException {
        Smpdtl smpdtl = parent.getTableModelOcc().smpdtl;
        Well well = parent.getWellPanel().getWell();
        int sampID = smpdtl.getSample().getSampID();
        TaxonOcc fss = null;
        if (smpdtl == null) {
            JOptionPane.showMessageDialog(parent, "Make a selection from list of analyses", parent.getTitle(), 2);
            return;
        }
        try {
            AbstractUndoableEdit edit;
            fss = smpdtl.getFss(taxon, rw, questionable ? (char)'?' : 'P', 0);
            if (fss != null) {
                edit = smpdtl.incrementOcc(well.getWellID(), sampID, fss, 2, count, true);
            } else {
                edit = smpdtl.insertOccurrence(new TaxonOcc.Builder(sbdb, taxon, rw, questionable, 0).count(count).subjAbund(subjAbund).caved(cv), well.getWellID());
                fss = ((Smpdtl.OccAddDelete)edit).getOccurrence();
            }
            parent.getWellPanel().getUndoSupport().postEdit(edit);
            sbdb.commit();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        smpdtl.notifyObservers();
        parent.getWellPanel().setSelectedTaxonOcc(fss);
    }

    private String getNull(String strg) {
        if (strg == null) {
            return null;
        }
        if (strg.length() == 0) {
            return null;
        }
        return strg;
    }

    private void fillAbundCombo() {
        this.jComboBoxAbund.removeAllItems();
        this.jComboBoxAbund.addItem(SELECT_STRING);
        try {
            this.abnScheme = this.parent.getAbnScheme();
            if (this.abnScheme == null) {
                this.jComboBoxAbund.setToolTipText("No abundance scheme selected for suite");
                return;
            }
            this.abnScheme.fillCombo(this.jComboBoxAbund, false);
            this.jComboBoxAbund.setToolTipText("Scheme: " + this.abnScheme.getName());
            this.jComboBoxAbund.repaint();
        }
        catch (Exception e) {
            this.jComboBoxAbund.setToolTipText("No abundance scheme selected for suite");
            e.printStackTrace();
        }
    }

    public void setAbnScheme() throws SBException, SQLException {
        if (!this.parent.isNumeric() && this.parent.getAbnScheme() != this.abnScheme) {
            this.fillAbundCombo();
            this.jComboBoxAbund.setEnabled(true);
        }
    }

    void clear() {
        this.picklistModel.removeAllElements();
        this.jListPick.repaint();
    }

    void clearSelection() {
        Object[] selection = this.jListPick.getSelectedValues();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No picklist entries selected", this.parent.getTitle(), 1);
            return;
        }
        for (Object obj : selection) {
            this.picklistModel.removeElement(obj);
        }
        this.jListPick.repaint();
    }

    void saveAsGroup() {
        try {
            DialogSelectGroup dialog = new DialogSelectGroup((Frame)this.parent, true, this.sbdb, this.group);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                TxGroup group = dialog.selection;
                if (group.getSize() > 0) {
                    int opt = JOptionPane.showConfirmDialog(this, "Clear contents of group before adding?", this.parent.getTitle(), 1, 3);
                    if (opt == 2 || opt == -1) {
                        return;
                    }
                    if (opt == 0) {
                        group.deleteAllTaxa();
                    }
                }
                LinkedList<Taxon> picklistTaxa = new LinkedList<Taxon>();
                Enumeration en = this.picklistModel.elements();
                while (en.hasMoreElements()) {
                    Taxon taxon = (Taxon)en.nextElement();
                    if (group.isMember(taxon.getSpecID())) continue;
                    picklistTaxa.add(taxon);
                }
                group.addTaxa(picklistTaxa);
                this.sbdb.commit();
                this.changed = false;
                this.group = group;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    void saveGroup() {
        try {
            LinkedList<Taxon> picklistTaxa = new LinkedList<Taxon>();
            Enumeration en = this.picklistModel.elements();
            while (en.hasMoreElements()) {
                Taxon taxon = (Taxon)en.nextElement();
                if (this.group.isMember(taxon.getSpecID())) continue;
                picklistTaxa.add(taxon);
            }
            this.group.addTaxa(picklistTaxa);
            this.sbdb.commit();
            this.changed = false;
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    void setListLayout(int orientation) {
        this.jListPick.setLayoutOrientation(orientation);
        this.jListPick.repaint();
        try {
            Lastval.putInt((SBdb)this.sbdb, (String)"PICKCOL", (int)orientation);
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error: ", (SQLException)sql);
        }
    }

    synchronized void setTaxa(Collection<Taxon> taxa) {
        for (Taxon taxon : taxa) {
            if (this.picklistModel.contains(taxon)) continue;
            this.picklistModel.addElement(taxon);
            taxon.addObserver((Observer)this);
        }
        this.sortPicklist();
    }

    private void init() {
        this.jListPick.setDragEnabled(true);
        this.jListPick.setTransferHandler(new TaxonTransferHandler(null));
        this.jListPick.setDropTarget(null);
        this.setTransferHandler(new TaxonTransferHandler(null));
        this.setListIcon();
        this.sbdb.addObserver((Observer)this);
        try {
            this.initSpecTypeModel();
            int i = Lastval.getInt((SBdb)this.sbdb, (String)"PICKCOL");
            this.setListLayout(i);
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
    }

    private void setListIcon() {
        this.jListPick.setCellRenderer(new PicklistListLabel());
    }

    private void initSpecTypeModel() throws SQLException {
        this.specTypeModel.removeAllElements();
        Iterator it = this.sbdb.getSpecTypeIterator();
        while (it.hasNext()) {
            this.specTypeModel.addElement(it.next());
        }
        this.jComboBoxSpecType.repaint();
    }

    private void initComponents() {
        this.buttonGroupPickSort = new ButtonGroup();
        this.buttonGroupConfidence = new ButtonGroup();
        this.buttonGroupSituation = new ButtonGroup();
        this.buttonGroupQualifiers = new ButtonGroup();
        this.jPanel13 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jRadioButtonNone = new JRadioButton();
        this.jRadioButtonSpp = new JRadioButton();
        this.jRadioButtonGrp = new JRadioButton();
        this.jRadioButtonAff = new JRadioButton();
        this.jRadioButtonCf = new JRadioButton();
        this.jPanel9 = new JPanel();
        this.jSpinnerCoarse = new JSpinner();
        this.jLabelCoarse = new JLabel();
        this.jSpinnerFine = new JSpinner();
        this.jLabelMedium = new JLabel();
        this.jLabelFine = new JLabel();
        this.jSpinnerMedium = new JSpinner();
        this.jComboBoxAbund = new JComboBox();
        this.jPanel10 = new JPanel();
        this.jRadioButtonReworked = new JRadioButton();
        this.jRadioButtonInSitu = new JRadioButton();
        this.jCheckBoxCaved = new JCheckBox();
        this.jCheckBoxMarker = new JCheckBox();
        this.jPanel11 = new JPanel();
        this.jRadioButtonConfident = new JRadioButton();
        this.jRadioButtonQuestionable = new JRadioButton();
        this.jPanel12 = new JPanel();
        this.jRadioButtonCategory = new JRadioButton();
        this.jRadioButtonSpecies = new JRadioButton();
        this.jRadioButtonGenus = new JRadioButton();
        this.jToolBar2 = new JToolBar();
        this.jButtonAddToSample = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonRestore = new JButton();
        this.jButtonClearSelected = new JButton();
        this.jButtonClearAll = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jButtonInsertTaxa = new JButton();
        this.jButtonInsertGroup = new JButton();
        this.jButtonInsertWell = new JButton();
        this.jLabel1 = new JLabel();
        this.jToolBar3 = new JToolBar();
        this.jButtonTaxonImage = new JButton();
        this.jComboBoxSpecType = new JComboBox();
        this.jButtonSelectSpecType = new JButton();
        this.jScrollPanePicklist = new JScrollPane();
        this.jListPick = new JList();
        this.setMinimumSize(new Dimension(200, 600));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(null, "Qualifiers", 0, 0, null, new Color(51, 102, 204)));
        this.jPanel8.setPreferredSize(new Dimension(153, 106));
        this.buttonGroupQualifiers.add(this.jRadioButtonNone);
        this.jRadioButtonNone.setSelected(true);
        this.jRadioButtonNone.setText("None");
        this.jRadioButtonNone.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonNone.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupQualifiers.add(this.jRadioButtonSpp);
        this.jRadioButtonSpp.setText("spp.");
        this.jRadioButtonSpp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSpp.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupQualifiers.add(this.jRadioButtonGrp);
        this.jRadioButtonGrp.setText("grp.");
        this.jRadioButtonGrp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonGrp.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupQualifiers.add(this.jRadioButtonAff);
        this.jRadioButtonAff.setText("aff.");
        this.jRadioButtonAff.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonAff.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupQualifiers.add(this.jRadioButtonCf);
        this.jRadioButtonCf.setText("cf.");
        this.jRadioButtonCf.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCf.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel8Layout = new GroupLayout((Container)this.jPanel8);
        this.jPanel8.setLayout((LayoutManager)jPanel8Layout);
        jPanel8Layout.setHorizontalGroup((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel8Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel8Layout.createSequentialGroup().add((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((Component)this.jRadioButtonNone).add((Component)this.jRadioButtonSpp)).add(18, 18, 18).add((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((Component)this.jRadioButtonCf).add((Component)this.jRadioButtonAff))).add((Component)this.jRadioButtonGrp)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel8Layout.createSequentialGroup().add((GroupLayout.Group)jPanel8Layout.createParallelGroup(3).add((Component)this.jRadioButtonNone).add((Component)this.jRadioButtonAff)).addPreferredGap(0).add((GroupLayout.Group)jPanel8Layout.createParallelGroup(3).add((Component)this.jRadioButtonCf).add((Component)this.jRadioButtonSpp)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonGrp).addContainerGap()));
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(null, "Abundance", 0, 0, null, new Color(51, 102, 204)));
        this.jSpinnerCoarse.setModel(new SpinnerNumberModel(0, 0, 999999, 1));
        this.jSpinnerCoarse.setEnabled(false);
        this.jLabelCoarse.setHorizontalAlignment(11);
        this.jLabelCoarse.setText("Coarse:");
        this.jLabelCoarse.setEnabled(false);
        this.jSpinnerFine.setModel(new SpinnerNumberModel(0, 0, 999999, 1));
        this.jSpinnerFine.setEnabled(false);
        this.jLabelMedium.setHorizontalAlignment(11);
        this.jLabelMedium.setText("Counts:");
        this.jLabelFine.setHorizontalAlignment(11);
        this.jLabelFine.setText("Fine:");
        this.jLabelFine.setEnabled(false);
        this.jSpinnerMedium.setModel(new SpinnerNumberModel(0, 0, 999999, 1));
        this.jSpinnerMedium.setValue(this.parent.isCMF() ? 0 : 1);
        this.jComboBoxAbund.setModel(this.abundModel);
        this.jComboBoxAbund.setOpaque(false);
        GroupLayout jPanel9Layout = new GroupLayout((Container)this.jPanel9);
        this.jPanel9.setLayout((LayoutManager)jPanel9Layout);
        jPanel9Layout.setHorizontalGroup((GroupLayout.Group)jPanel9Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel9Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel9Layout.createParallelGroup(2, false).add(1, (Component)this.jComboBoxAbund, 0, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)jPanel9Layout.createSequentialGroup().add((GroupLayout.Group)jPanel9Layout.createParallelGroup(2).add((Component)this.jLabelFine).add((Component)this.jLabelMedium).add((Component)this.jLabelCoarse)).addPreferredGap(0).add((GroupLayout.Group)jPanel9Layout.createParallelGroup(1).add((Component)this.jSpinnerFine).add((Component)this.jSpinnerMedium).add((Component)this.jSpinnerCoarse)))).addContainerGap()));
        jPanel9Layout.linkSize(new Component[]{this.jLabelCoarse, this.jLabelFine, this.jLabelMedium}, 1);
        jPanel9Layout.setVerticalGroup((GroupLayout.Group)jPanel9Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel9Layout.createSequentialGroup().add((GroupLayout.Group)jPanel9Layout.createParallelGroup(3).add((Component)this.jSpinnerCoarse, -2, -1, -2).add((Component)this.jLabelCoarse)).addPreferredGap(0).add((GroupLayout.Group)jPanel9Layout.createParallelGroup(3).add((Component)this.jSpinnerMedium, -2, -1, -2).add((Component)this.jLabelMedium)).addPreferredGap(0).add((GroupLayout.Group)jPanel9Layout.createParallelGroup(3).add((Component)this.jLabelFine).add((Component)this.jSpinnerFine, -2, -1, -2)).addPreferredGap(1).add((Component)this.jComboBoxAbund, -2, -1, -2)));
        this.jPanel10.setBorder(BorderFactory.createTitledBorder(null, "Situation", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupSituation.add(this.jRadioButtonReworked);
        this.jRadioButtonReworked.setText("Reworked");
        this.jRadioButtonReworked.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonReworked.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupSituation.add(this.jRadioButtonInSitu);
        this.jRadioButtonInSitu.setSelected(true);
        this.jRadioButtonInSitu.setText("In-situ");
        this.jRadioButtonInSitu.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonInSitu.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxCaved.setText("Caved");
        this.jCheckBoxCaved.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxCaved.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxMarker.setText("Marker");
        this.jCheckBoxMarker.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxMarker.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel10Layout = new GroupLayout((Container)this.jPanel10);
        this.jPanel10.setLayout((LayoutManager)jPanel10Layout);
        jPanel10Layout.setHorizontalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel10Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((Component)this.jRadioButtonInSitu).add((Component)this.jCheckBoxCaved).add((Component)this.jCheckBoxMarker).add((Component)this.jRadioButtonReworked)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel10Layout.createSequentialGroup().add((Component)this.jRadioButtonInSitu).addPreferredGap(0).add((Component)this.jRadioButtonReworked).addPreferredGap(0).add((Component)this.jCheckBoxCaved).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxMarker).addContainerGap()));
        this.jPanel11.setBorder(BorderFactory.createTitledBorder(null, "Identification", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupConfidence.add(this.jRadioButtonConfident);
        this.jRadioButtonConfident.setSelected(true);
        this.jRadioButtonConfident.setText("Positive");
        this.jRadioButtonConfident.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonConfident.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupConfidence.add(this.jRadioButtonQuestionable);
        this.jRadioButtonQuestionable.setText("Questionable");
        this.jRadioButtonQuestionable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonQuestionable.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel11Layout = new GroupLayout((Container)this.jPanel11);
        this.jPanel11.setLayout((LayoutManager)jPanel11Layout);
        jPanel11Layout.setHorizontalGroup((GroupLayout.Group)jPanel11Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel11Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel11Layout.createParallelGroup(1).add((Component)this.jRadioButtonConfident).add((Component)this.jRadioButtonQuestionable)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup((GroupLayout.Group)jPanel11Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel11Layout.createSequentialGroup().add((Component)this.jRadioButtonConfident).addPreferredGap(0).add((Component)this.jRadioButtonQuestionable).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel12.setBorder(BorderFactory.createTitledBorder(null, "Sort", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupPickSort.add(this.jRadioButtonCategory);
        this.jRadioButtonCategory.setText("Category");
        this.jRadioButtonCategory.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonCategory.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jRadioButtonCategoryActionPerformed(evt);
            }
        });
        this.buttonGroupPickSort.add(this.jRadioButtonSpecies);
        this.jRadioButtonSpecies.setText("Species");
        this.jRadioButtonSpecies.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSpecies.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jRadioButtonSpeciesActionPerformed(evt);
            }
        });
        this.buttonGroupPickSort.add(this.jRadioButtonGenus);
        this.jRadioButtonGenus.setSelected(true);
        this.jRadioButtonGenus.setText("Genus");
        this.jRadioButtonGenus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonGenus.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButtonGenus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jRadioButtonGenusActionPerformed(evt);
            }
        });
        GroupLayout jPanel12Layout = new GroupLayout((Container)this.jPanel12);
        this.jPanel12.setLayout((LayoutManager)jPanel12Layout);
        jPanel12Layout.setHorizontalGroup((GroupLayout.Group)jPanel12Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel12Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel12Layout.createParallelGroup(1).add((Component)this.jRadioButtonSpecies).add((Component)this.jRadioButtonGenus).add((Component)this.jRadioButtonCategory)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel12Layout.setVerticalGroup((GroupLayout.Group)jPanel12Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel12Layout.createSequentialGroup().add((Component)this.jRadioButtonCategory).addPreferredGap(0).add((Component)this.jRadioButtonSpecies).addPreferredGap(0).add((Component)this.jRadioButtonGenus)));
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jButtonAddToSample.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_AddTaxon.png")));
        this.jButtonAddToSample.setToolTipText("<html>Add selected taxon to analysis<br>and restore default settings</html>");
        this.jButtonAddToSample.setFocusable(false);
        this.jButtonAddToSample.setHorizontalTextPosition(0);
        this.jButtonAddToSample.setVerticalTextPosition(3);
        this.jButtonAddToSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonAddToSampleActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonAddToSample);
        this.jToolBar2.add(this.jSeparator1);
        this.jButtonRestore.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_Restore.png")));
        this.jButtonRestore.setToolTipText("Restore default settings");
        this.jButtonRestore.setFocusable(false);
        this.jButtonRestore.setHorizontalTextPosition(0);
        this.jButtonRestore.setVerticalTextPosition(3);
        this.jButtonRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonRestoreActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonRestore);
        this.jButtonClearSelected.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_ClearSelected.png")));
        this.jButtonClearSelected.setToolTipText("Clear selected items from the picklist");
        this.jButtonClearSelected.setFocusable(false);
        this.jButtonClearSelected.setHorizontalTextPosition(0);
        this.jButtonClearSelected.setVerticalTextPosition(3);
        this.jButtonClearSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonClearSelectedActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonClearSelected);
        this.jButtonClearAll.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_ClearAll.png")));
        this.jButtonClearAll.setToolTipText("Clear picklist");
        this.jButtonClearAll.setFocusable(false);
        this.jButtonClearAll.setHorizontalTextPosition(0);
        this.jButtonClearAll.setVerticalTextPosition(3);
        this.jButtonClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonClearAllActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButtonClearAll);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonInsertTaxa.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameTaxa_FindTaxon.png")));
        this.jButtonInsertTaxa.setToolTipText("Add individual taxa to picklist");
        this.jButtonInsertTaxa.setFocusable(false);
        this.jButtonInsertTaxa.setHorizontalTextPosition(0);
        this.jButtonInsertTaxa.setMargin(new Insets(2, 1, 2, 1));
        this.jButtonInsertTaxa.setVerticalTextPosition(3);
        this.jButtonInsertTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonInsertTaxaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonInsertTaxa);
        this.jButtonInsertGroup.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_AddGroup.png")));
        this.jButtonInsertGroup.setToolTipText("Add group to picklist");
        this.jButtonInsertGroup.setFocusable(false);
        this.jButtonInsertGroup.setHorizontalTextPosition(0);
        this.jButtonInsertGroup.setMargin(new Insets(2, 1, 2, 1));
        this.jButtonInsertGroup.setVerticalTextPosition(3);
        this.jButtonInsertGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonInsertGroupActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonInsertGroup);
        this.jButtonInsertWell.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameIcon_Wells/24Wells.png")));
        this.jButtonInsertWell.setToolTipText("Add taxa from a well to picklist");
        this.jButtonInsertWell.setFocusable(false);
        this.jButtonInsertWell.setHorizontalTextPosition(0);
        this.jButtonInsertWell.setMargin(new Insets(2, 1, 2, 1));
        this.jButtonInsertWell.setVerticalTextPosition(3);
        this.jButtonInsertWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonInsertWellActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonInsertWell);
        this.jLabel1.setForeground(new Color(51, 102, 204));
        this.jLabel1.setText("Add taxa to picklist:");
        this.jToolBar3.setFloatable(false);
        this.jToolBar3.setRollover(true);
        this.jButtonTaxonImage.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/Camera.png")));
        this.jButtonTaxonImage.setToolTipText("Display image(s) of selected taxon");
        this.jButtonTaxonImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonTaxonImageActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButtonTaxonImage);
        this.jComboBoxSpecType.setModel(this.specTypeModel);
        this.jButtonSelectSpecType.setText("...");
        this.jButtonSelectSpecType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelPicklist.this.jButtonSelectSpecTypeActionPerformed(evt);
            }
        });
        GroupLayout jPanel13Layout = new GroupLayout((Container)this.jPanel13);
        this.jPanel13.setLayout((LayoutManager)jPanel13Layout);
        jPanel13Layout.setHorizontalGroup((GroupLayout.Group)jPanel13Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel13Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel13Layout.createParallelGroup(1).add((Component)this.jToolBar2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel13Layout.createSequentialGroup().add((Component)this.jComboBoxSpecType, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonSelectSpecType, -2, 32, -2).add(8, 8, 8)).add((GroupLayout.Group)jPanel13Layout.createSequentialGroup().add((GroupLayout.Group)jPanel13Layout.createParallelGroup(2, false).add(1, (Component)this.jPanel11, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel10, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jToolBar1, -2, 116, -2).add(1, (Component)this.jLabel1).add(1, (GroupLayout.Group)jPanel13Layout.createSequentialGroup().add((Component)this.jPanel12, -2, -1, -2).addPreferredGap(0).add((Component)this.jToolBar3, -2, -1, -2)).add(1, (Component)this.jPanel9, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel8, -1, -1, Short.MAX_VALUE)).add(0, 0, Short.MAX_VALUE))).add(4, 4, 4)));
        jPanel13Layout.setVerticalGroup((GroupLayout.Group)jPanel13Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel13Layout.createSequentialGroup().add((Component)this.jLabel1).add(1, 1, 1).add((Component)this.jToolBar1, -2, 30, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel13Layout.createParallelGroup(2).add((Component)this.jToolBar3, -2, -1, -2).add((Component)this.jPanel12, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanel8, -2, 82, -2).addPreferredGap(0).add((Component)this.jPanel9, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel10, -2, 104, -2).addPreferredGap(0).add((Component)this.jPanel11, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel13Layout.createParallelGroup(3).add((Component)this.jComboBoxSpecType, -2, -1, -2).add((Component)this.jButtonSelectSpecType)).addPreferredGap(0, 18, Short.MAX_VALUE).add((Component)this.jToolBar2, -2, -1, -2).add(22, 22, 22)));
        this.jScrollPanePicklist.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPanePicklist.setMinimumSize(new Dimension(205, 628));
        this.jListPick.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPick.setModel(this.picklistModel);
        this.jListPick.setLayoutOrientation(1);
        this.jListPick.setVisibleRowCount(0);
        this.jListPick.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelPicklist.this.jListPickMouseClicked(evt);
            }
        });
        this.jListPick.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JPanelPicklist.this.jListPickValueChanged(evt);
            }
        });
        this.jListPick.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelPicklist.this.jListPickKeyPressed(evt);
            }
        });
        this.jScrollPanePicklist.setViewportView(this.jListPick);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPanePicklist, -1, 205, Short.MAX_VALUE).add(2, 2, 2).add((Component)this.jPanel13, -2, -1, -2).add(6, 6, 6)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPanePicklist, -1, -1, Short.MAX_VALUE).addContainerGap()).add((Component)this.jPanel13, -1, -1, Short.MAX_VALUE))));
    }

    Taxon getSelectedTaxon() {
        return (Taxon)this.jListPick.getSelectedValue();
    }

    void addTaxonPick() {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa(this.parent, true, this.sbdb, false, (Taxon)this.jListPick.getSelectedValue());
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                for (Taxon t : dialog.selection) {
                    if (this.picklistModel.contains(t)) continue;
                    this.picklistModel.addElement(t);
                    t.addObserver((Observer)this);
                }
                this.sortPicklist();
                int[] selection = new int[dialog.selection.size()];
                int i = 0;
                for (Taxon t : dialog.selection) {
                    selection[i] = this.picklistModel.indexOf(t);
                    ++i;
                }
                this.jListPick.setSelectedIndices(selection);
                this.jListPick.scrollRectToVisible(this.jListPick.getCellBounds(selection[0], selection[selection.length - 1]));
                this.jListPick.requestFocusInWindow();
                if (this.getGroupAutoSave()) {
                    this.saveGroup();
                } else {
                    this.changed = true;
                }
            }
            this.parent.setAlwaysOnTop(true);
            this.parent.setAlwaysOnTop(false);
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    boolean getGroupAutoSave() {
        if (this.group != null && !this.changed) {
            if (this.groupAutoSave == null) {
                int opt = JOptionPane.showConfirmDialog(this.parent, "Do you want to update your picklist group: " + this.group.getName() + " with all new taxa as they are added to the list?", "Picklist", 0);
                this.groupAutoSave = opt == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        } else {
            return false;
        }
        return this.groupAutoSave;
    }

    boolean isUnsaved() {
        return this.picklistModel.size() > 0 && this.changed;
    }

    int getGroupID() {
        if (this.group != null) {
            return this.group.getID();
        }
        return 0;
    }

    private void jListPickMouseClicked(MouseEvent evt) {
        boolean added;
        this.parent.getWellPanel().stopCellEditor();
        if ((this.parent.isMultiClick() && evt.getClickCount() > 1 || !this.parent.isMultiClick() && evt.getClickCount() == 2) && evt.getButton() == 1 && !(added = this.addToSample(true)) && !this.parent.isNumeric()) {
            this.restorePicklist();
        }
        this.tempCount = "";
    }

    private void jRadioButtonCategoryActionPerformed(ActionEvent evt) {
        this.sortPicklist(Taxon.SortOrder.SORT_CATEGORY);
    }

    private void jRadioButtonSpeciesActionPerformed(ActionEvent evt) {
        this.sortPicklist(Taxon.SortOrder.SORT_SPECIES);
    }

    private void jRadioButtonGenusActionPerformed(ActionEvent evt) {
        this.sortPicklist(Taxon.SortOrder.SORT_GENUS);
    }

    private void jButtonInsertTaxaActionPerformed(ActionEvent evt) {
        this.addTaxonPick();
    }

    private void jButtonInsertGroupActionPerformed(ActionEvent evt) {
        boolean empty = this.picklistModel.isEmpty();
        this.parent.insertGroup(this);
        if (!empty) {
            this.changed = true;
        }
    }

    private void jButtonInsertWellActionPerformed(ActionEvent evt) {
        this.parent.insertWell(this);
        this.changed = true;
    }

    private void jButtonAddToSampleActionPerformed(ActionEvent evt) {
        if (this.addToSample(false)) {
            return;
        }
        this.restorePicklist();
    }

    void restorePicklist() {
        this.jRadioButtonNone.setSelected(true);
        this.jRadioButtonInSitu.setSelected(true);
        this.jCheckBoxCaved.setSelected(false);
        this.jCheckBoxMarker.setSelected(false);
        this.jRadioButtonConfident.setSelected(true);
        if (this.parent.isNumeric()) {
            this.jSpinnerCoarse.setValue(0);
            if (this.parent.isCMF()) {
                this.jSpinnerMedium.setValue(0);
            } else {
                this.jSpinnerMedium.setValue(1);
            }
            this.jSpinnerFine.setValue(0);
        } else {
            this.jComboBoxAbund.setSelectedIndex(this.abundModel.getSize() > 1 ? 1 : 0);
        }
        this.jComboBoxSpecType.setSelectedIndex(0);
    }

    private void jButtonRestoreActionPerformed(ActionEvent evt) {
        this.restorePicklist();
    }

    private void jButtonClearSelectedActionPerformed(ActionEvent evt) {
        this.clearSelection();
        this.changed = !this.picklistModel.isEmpty();
    }

    private void jButtonClearAllActionPerformed(ActionEvent evt) {
        this.clear();
        this.changed = false;
    }

    private void jButtonTaxonImageActionPerformed(ActionEvent evt) {
        try {
            Object[] taxa = this.jListPick.getSelectedValues();
            if (taxa.length == 0) {
                JOptionPane.showMessageDialog(this, "No taxa selected.", this.parent.getTitle(), 2);
                return;
            }
            int i$ = 0;
            Object[] arr$ = taxa;
            int len$ = arr$.length;
            if (i$ < len$) {
                Object o = arr$[i$];
                Taxon taxon = (Taxon)o;
                DialogTaxonImages dialog = new DialogTaxonImages((Frame)this.parent, true, this.sbdb, taxon);
                dialog.setLocationRelativeTo(this.jButtonTaxonImage);
                dialog.setVisible(true);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jButtonSelectSpecTypeActionPerformed(ActionEvent evt) {
        try {
            DialogSpecType dialog = new DialogSpecType((Frame)this.parent, true, this.sbdb);
            dialog.setLocationRelativeTo(this.jButtonSelectSpecType);
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            this.initSpecTypeModel();
            this.parent.setAlwaysOnTop(true);
            this.parent.setAlwaysOnTop(false);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jListPickValueChanged(ListSelectionEvent evt) {
        this.tempCount = "";
    }

    private void jListPickKeyPressed(KeyEvent evt) {
        this.parent.getWellPanel().stopCellEditor();
        switch (evt.getKeyCode()) {
            case 109: {
                this.tempCount = "-1";
            }
            case 10: {
                this.addToSample(true);
                this.tempCount = "";
                return;
            }
            case 8: {
                if (this.tempCount.length() > 0) {
                    if (this.tempCount.length() == 1) {
                        this.tempCount = "";
                        this.jListPick.setToolTipText(null);
                    } else {
                        this.tempCount = this.tempCount.substring(0, this.tempCount.length() - 1);
                        if (Integer.parseInt(this.tempCount) > 0) {
                            this.jListPick.setToolTipText(this.tempCount);
                        } else {
                            this.jListPick.setToolTipText(null);
                        }
                    }
                }
                return;
            }
        }
        char c = evt.getKeyChar();
        if (c == '\uffff') {
            return;
        }
        if (c >= '0' && c <= '9') {
            if (this.tempCount.isEmpty() || Integer.parseInt(this.tempCount) <= 0) {
                this.tempCount = Character.toString(c);
            } else if (this.tempCount.length() >= 6) {
                this.getToolkit().beep();
            } else {
                this.tempCount = this.tempCount + Character.toString(c);
            }
        } else if (c == '+') {
            this.tempCount = "0";
        }
        if (this.tempCount.length() > 0 && !this.tempCount.equals("0")) {
            this.jListPick.setToolTipText(this.tempCount);
        } else {
            this.jListPick.setToolTipText(null);
        }
    }

    private void sortPicklist() {
        if (this.jRadioButtonGenus.isSelected()) {
            this.sortPicklist(Taxon.SortOrder.SORT_GENUS);
        } else if (this.jRadioButtonSpecies.isSelected()) {
            this.sortPicklist(Taxon.SortOrder.SORT_SPECIES);
        } else {
            this.sortPicklist(Taxon.SortOrder.SORT_CATEGORY);
        }
    }

    private void sortPicklist(Taxon.SortOrder order) {
        LinkedList<Taxon> picklist = new LinkedList<Taxon>();
        Enumeration en = this.picklistModel.elements();
        while (en.hasMoreElements()) {
            picklist.add((Taxon)en.nextElement());
        }
        Taxon.sort(picklist, (Taxon.SortOrder)order);
        this.picklistModel.clear();
        for (Taxon t : picklist) {
            this.picklistModel.addElement(t);
        }
        this.jListPick.repaint();
    }

    static boolean getSampleTotalMessage() {
        return sampleTotalMessage;
    }

    static void setSampleTotalMessage() {
        sampleTotalMessage = true;
    }

    void repaintList() {
        this.jListPick.repaint();
    }

    private class PicklistListLabel
    extends JPanel
    implements ListCellRenderer {
        JLabel textLabel = new JLabel();
        JLabel iconLabel = new JLabel();

        private PicklistListLabel() {
            this.setOpaque(true);
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add(this.textLabel);
            this.add(Box.createHorizontalStrut(10));
            this.add(this.iconLabel);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.textLabel.getPreferredSize().width + this.iconLabel.getPreferredSize().width + 10, super.getPreferredSize().height);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.getFont().getStyle() != 0) {
                this.setFont(this.getFont().deriveFont(0));
            }
            this.iconLabel.setIcon(null);
            this.textLabel.setText(value.toString());
            if (value instanceof Taxon) {
                Taxon taxon = (Taxon)value;
                try {
                    if (taxon.hasTypeImage()) {
                        this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/CameraSmall_bw.png")));
                    }
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
            this.textLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

