/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.util.List;
import javax.swing.JOptionPane;
import jsbugs.DialogList;
import jsbugs.DialogPanelEvents;
import jsbugs.DialogPanelIGDScheme;
import jsbugs.DialogPanelSurfaces;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.JPanelChartBlock;
import jsbugs.PanelAgeCurve;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelEventsBase;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelSurfaces;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.AgeCurve;
import model2.SBdb;
import util.SB;

public class JPanelSchemeBlock
extends JPanelChartBlock {
    SchemeBlock block;

    JPanelSchemeBlock(SchemeBlock block, SBdb sbdb, SBDialog parent) {
        super(sbdb, parent);
        this.block = block;
        this.init();
    }

    @Override
    SchemeBlock getBlock() {
        return this.block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addPanel() {
        try {
            DialogSelectIGDType typeDialog = new DialogSelectIGDType(this.parent, true, true, false, true, true);
            typeDialog.setLocationRelativeTo(this.parent);
            typeDialog.setVisible(true);
            if (!typeDialog.isOK()) {
                return;
            }
            int igdType = typeDialog.igdType;
            if (igdType == 20) {
                DialogSelectCmpStd dialog = new DialogSelectCmpStd(this.parent, true, this.sbdb);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    PanelCompositeStandard pcs = new PanelCompositeStandard(dialog.selection, this.sbdb, this.block);
                    this.block.addPanel(pcs);
                }
            } else if (igdType == 25) {
                List ageCurves = this.sbdb.getAgeCurves();
                DialogList dialog = new DialogList(this.parent, true, "Select Age Curve", this.sbdb, ageCurves, true, false);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    AgeCurve curve = (AgeCurve)dialog.selection;
                    PanelAgeCurve panel = new PanelAgeCurve(this.block, curve);
                    this.block.addPanel(panel);
                }
            } else if (igdType < 0) {
                if (!this.block.addAgeScale()) {
                    JOptionPane.showMessageDialog(this, "Block already has an age scale panel", "Add scale", 1);
                }
            } else {
                DialogSelectScheme dialog = new DialogSelectScheme(this.parent, true, this.sbdb, igdType, null);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    dialog.selection.loadUnits();
                    PanelIGDScheme newPanel = new PanelIGDScheme(dialog.selection, this.block);
                    this.block.addPanel(newPanel);
                }
                if (igdType == 10) {
                    PanelSurfaces sPanel = new PanelSurfaces(dialog.selection, this.block);
                    this.block.addPanel(sPanel);
                }
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error creating scheme chart", (Exception)e);
        }
        finally {
            this.createPanelList(this.block);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    void panelProperties(SBPanel selection) {
        SBDialog dialog = null;
        if (selection instanceof PanelCompositeStandard) {
            dialog = new DialogPanelEvents((Dialog)this.parent, true, (PanelEventsBase)((PanelCompositeStandard)selection), this.sbdb);
        } else if (selection instanceof PanelIGDScheme) {
            dialog = new DialogPanelIGDScheme((Dialog)this.parent, true, (PanelIGDScheme)selection);
        } else if (selection instanceof PanelSurfaces) {
            dialog = new DialogPanelSurfaces((Dialog)this.parent, true, (PanelSurfaces)selection);
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "No properties available", "Panel properties", 2);
        }
    }
}

