/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.DialogList;
import jsbugs.DialogSet;
import jsbugs.FrameTaxaDB;
import jsbugs.InternalFrameGroup;
import model2.SBChart;
import model2.SBdb;
import model2.TxGroup;
import model2.TxGroupSet;
import util.SB;

public class JPanelSets
extends JPanel
implements Observer {
    FrameTaxaDB parent;
    SBdb sbdb;
    DefaultListModel setModel = new DefaultListModel();
    private JLabel jLabel1;
    private JList jListSets;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemOpenGroups;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane3;
    private JPopupMenu.Separator jSeparator1;

    @Override
    public void update(Observable obs, Object obj) {
        if (obs instanceof TxGroupSet) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPanelSets.this.jListSets.repaint();
                }
            });
        } else if (obj != null && obj instanceof TxGroupSet) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        JPanelSets.this.setModel.clear();
                        JPanelSets.this.init();
                    }
                    catch (Exception ex) {
                        SB.showStackError((String)ex.getMessage(), (Exception)ex);
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public JPanelSets(FrameTaxaDB parent, SBdb db) throws SQLException {
        this.parent = parent;
        this.sbdb = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setModel.clear();
        for (TxGroupSet set : this.sbdb.getTxGroupSetsSorted()) {
            this.setModel.addElement(set);
            set.addObserver((Observer)this);
        }
        this.sbdb.addObserver((Observer)this);
        this.jListSets.repaint();
    }

    void addSet() {
        try {
            DialogSet dialog = new DialogSet((Frame)this.parent, true, this.sbdb, null);
            dialog.setLocationRelativeTo(null);
            dialog.setTitle("Set : Add");
            dialog.setVisible(true);
            if (dialog.set != null) {
                this.init();
                this.jListSets.setSelectedValue(dialog.set, true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.parent.getTitle(), 2);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
    }

    void editSet() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            DialogSet dialog = new DialogSet((Frame)this.parent, true, this.sbdb, set);
            dialog.setLocationRelativeTo(null);
            dialog.setTitle("Set : Edit - " + set.getName());
            dialog.setVisible(true);
            this.jListSets.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error: " + e.getMessage(), this.parent.getTitle(), 2);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showGroups() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            for (TxGroup group : set.getGroups()) {
                InternalFrameGroup frame = this.parent.getGroupFrame(group);
                if (frame != null) {
                    frame.setIcon(false);
                    frame.setVisible(true);
                    frame.setLocation(50, 50);
                    continue;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.parent.createInternalFrameGroup(group);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.parent.getTitle(), 0);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showCharts() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            LinkedList<SBChart> groupSetCharts = new LinkedList<SBChart>();
            LinkedList charts = new LinkedList();
            SBChart.load((SBdb)this.sbdb, charts, (String)"%");
            for (SBChart chart : charts) {
                chart.loadData();
                if (!chart.hasSet(set.getID())) continue;
                groupSetCharts.add(chart);
            }
            if (!groupSetCharts.isEmpty()) {
                DialogList dialog = new DialogList(this.parent, true, "Charts containing set: " + set.toString(), this.sbdb, groupSetCharts, false, false);
                dialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this.parent, "Set does not appear in any charts", set.getName(), 1);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.parent.getTitle(), 0);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSet() {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Really delete set: " + set + "?", this.parent.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            int opt = JOptionPane.showConfirmDialog(this, "Check charts for this set?", this.parent.getTitle(), 1, 3);
            if (opt == 2 || opt == -1) {
                return;
            }
            if (opt == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                LinkedList<SBChart> setCharts = new LinkedList<SBChart>();
                LinkedList charts = new LinkedList();
                SBChart.load((SBdb)this.sbdb, charts, (String)"%");
                for (SBChart chart : charts) {
                    chart.loadData();
                    if (!chart.hasSet(set.getID())) continue;
                    setCharts.add(chart);
                }
                if (!setCharts.isEmpty()) {
                    DialogList dialog = new DialogList((Frame)null, true, "Charts containing set: " + set.toString(), this.sbdb, setCharts, false, false);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    return;
                }
                if (JOptionPane.showConfirmDialog(this, "Set not linked to charts.\nContinue to delete?", this.parent.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            this.sbdb.deleteTxGroupSet(set);
            this.setModel.removeElement(set);
            this.jListSets.repaint();
            this.sbdb.commit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error deleting set: " + e.getMessage(), this.parent.getTitle(), 2);
            e.printStackTrace();
            this.sbdb.doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public TxGroupSet getSelectedSet() {
        return this.getSelected();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemOpenGroups = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemDelete = new JMenuItem();
        this.jScrollPane3 = new JScrollPane();
        this.jListSets = new JList();
        this.jLabel1 = new JLabel();
        this.jMenuItemOpenGroups.setText("Open groups");
        this.jMenuItemOpenGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelSets.this.jMenuItemOpenGroupsActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemOpenGroups);
        this.jPopupMenu1.add(this.jSeparator1);
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelSets.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemDelete);
        this.setMinimumSize(new Dimension(0, 100));
        this.setPreferredSize(new Dimension(100, 429));
        this.jScrollPane3.setMinimumSize(new Dimension(0, 0));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 130));
        this.jListSets.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListSets.setModel(this.setModel);
        this.jListSets.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelSets.this.jListSetsMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JPanelSets.this.jListSetsMouseReleased(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListSets);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setText("Sets:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 80, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 385, Short.MAX_VALUE).addContainerGap()));
    }

    private TxGroupSet getSelected() {
        TxGroupSet set = (TxGroupSet)this.jListSets.getSelectedValue();
        if (set == null) {
            JOptionPane.showMessageDialog(this.parent, "No set selected", this.parent.getTitle(), 2);
        }
        return set;
    }

    private void jListSetsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.editSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jMenuItemOpenGroupsActionPerformed(ActionEvent evt) {
        TxGroupSet set = this.getSelected();
        if (set == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (TxGroup group : set.getGroups()) {
                InternalFrameGroup frame = this.parent.getGroupFrame(group);
                if (frame != null) {
                    frame.setIcon(false);
                    frame.setVisible(true);
                    frame.setLocation(50, 50);
                    return;
                }
                this.parent.createInternalFrameGroup(group);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jListSetsMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.jPopupMenu1.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.deleteSet();
    }
}

