/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.DialogAnalysis;
import jsbugs.DialogAnalystHeaders;
import jsbugs.DialogBiocom;
import jsbugs.DialogCSVExport;
import jsbugs.DialogEvent;
import jsbugs.DialogMergeSamples;
import jsbugs.DialogOccurrence;
import jsbugs.DialogOverlayWeb;
import jsbugs.DialogOverlays;
import jsbugs.DialogSample;
import jsbugs.DialogSampleAge;
import jsbugs.DialogSampleCopy;
import jsbugs.DialogSampleGenerate;
import jsbugs.DialogSampleLithology;
import jsbugs.DialogSampleReport;
import jsbugs.DialogSelectEvent;
import jsbugs.DialogSelectSample;
import jsbugs.DialogTaxonReassign;
import jsbugs.DialogWellEvent;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOrganiser;
import jsbugs.FrameOverlay;
import jsbugs.FrameSamples;
import jsbugs.FrameWellChartsDetached;
import jsbugs.JPanelCharts;
import jsbugs.JPanelPicklist;
import jsbugs.JPanelWellInterp;
import jsbugs.OverlayWebServer;
import jsbugs.TableModelAnalyses;
import jsbugs.TableModelOccurence;
import jsbugs.TableModelSB;
import jsbugs.TableModelSamples;
import jsbugs.TablePair;
import jsbugs.TaxonTransferHandler;
import jsbugs.UndoRedoAction;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.Biocom;
import model2.Discipline;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.ImageSet;
import model2.InterpHdr;
import model2.Lastval;
import model2.SBEvent;
import model2.SBdb;
import model2.Sample;
import model2.SampleLithology;
import model2.Smpdtl;
import model2.Surface;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import model2.WellHeader;
import model2.WellInterp;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPrivilegeException;
import util.SbugsCompoundEdit;
import util.SbugsTable;
import util.TableSorter;

public class JPanelWell
extends JPanel
implements Observer {
    private static final String ALL_STRING = "<all>";
    private static final String DEFAULT_COMMENT_TEXT = "Double-click to add a biostratigraphic comment...";
    static boolean tabIsName = true;
    final FrameSamples parent;
    final Well well;
    private final SBdb sbdb;
    private Discipline discID;
    FrameWellChartsDetached chartsFrameDetached = null;
    char units;
    private String analystString = null;
    private int analyNo = 0;
    boolean hasPrefs = false;
    private Biocom biocom;
    boolean inStartup = true;
    private OverlayWebServer overlayServer = null;
    private final TableModelSamples tableModelSamples = new TableModelSamples(false);
    final TableModelOccurence tableModelOcc = new TableModelOccurence();
    final TableModelAnalyses tableModelAnalyses = new TableModelAnalyses();
    private final TableSorter tableSorterSamples = new TableSorter((TableModel)this.tableModelSamples);
    private final TableSorter tableSorterAnalyses = new TableSorter((TableModel)this.tableModelAnalyses);
    final TableSorter tableSorterOcc = new TableSorter((TableModel)this.tableModelOcc);
    private final DefaultComboBoxModel comboModelAnalyst = new DefaultComboBoxModel();
    private final DefaultComboBoxModel comboModelAnalyNo = new DefaultComboBoxModel();
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    final UndoManager undoManagerOccs;
    private final UndoableEditSupport undoSupportOccs = new UndoableEditSupport();
    private final JPanelWellInterp jPanelInterpretations;
    private final JPanelCharts jPanelCharts;
    private ButtonGroup buttonGroupDepthUnits;
    private JButton jButtonAddSample;
    private JButton jButtonAddSampleSmpdtl;
    private JButton jButtonAddSmpdtl;
    private JButton jButtonAnalystHeader;
    private JButton jButtonDeleteOccurences;
    private JButton jButtonDeleteSamples;
    private JButton jButtonDeleteSmpdtl;
    private JButton jButtonEditSample;
    private JButton jButtonEditSmpdtl;
    private JButton jButtonNext;
    private JButton jButtonOccComment;
    private JButton jButtonOccEdit;
    private JButton jButtonOccEvent;
    private JButton jButtonOccInsertPrev;
    private JButton jButtonOccRedo;
    private JButton jButtonOccUndo;
    private JButton jButtonPrevious;
    private JButton jButtonSaveAsAnalyses;
    private JButton jButtonSaveSamples;
    private JButton jButtonShowAll;
    private JCheckBox jCheckBoxBarren;
    private JComboBox jComboBoxAnalysisNumber;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxDiscipline;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelNtaxa;
    private JLabel jLabelNtaxaTotal;
    private JLabel jLabelSamples;
    private JLabel jLabelnAnalyses;
    private JPanel jPanel2;
    private JPanel jPanelAnalyses;
    private JPanel jPanelOccurences;
    private JPanel jPanelSamples;
    private JPanel jPanelTotals;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneAnalyses;
    private JScrollPane jScrollPaneOccurences;
    private JScrollPane jScrollPaneSamples;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPaneSampleData;
    private JTable jTableAnalyses;
    private JTable jTableOccurrences;
    private JTable jTableSamples;
    private JTextArea jTextAreaComments;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldDiscipline;
    private JTextField jTextFieldSample;
    private JToolBar jToolBarOccUndo;
    HashMap<String, TotalLabel> totalLabels;

    public JPanelWell(FrameSamples parent, SBdb sbdb, Well well) throws SQLException, SBException {
        this.undoManagerOccs = new UndoManager(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                JPanelWell.this.undoManagerOccs.addEdit(e.getEdit());
                JPanelWell.this.setUndoTooltips();
            }
        };
        this.totalLabels = new HashMap();
        this.parent = parent;
        this.well = well;
        this.sbdb = sbdb;
        this.initComponents();
        this.jPanelInterpretations = new JPanelWellInterp(parent, this, sbdb, well);
        this.jPanelCharts = new JPanelCharts(parent, this, sbdb, well);
        this.init();
        this.refresh();
    }

    private void init() throws SQLException, SBException {
        this.comboModelDiscipline.insertElementAt(ALL_STRING, 0);
        this.jComboBoxDiscipline.setSelectedIndex(0);
        this.tableModelSamples.setupTable(this.jTableSamples, this.tableSorterSamples, true, this.sbdb);
        this.tableSorterSamples.addMouseListenerToHeaderInTable(this.jTableSamples);
        this.undoManagerOccs.setLimit(50);
        this.undoSupportOccs.addUndoableEditListener(this.undoManagerOccs);
        this.tableModelOcc.setupTable(this.jTableOccurrences, false, this.parent.getLogging(), this.tableSorterOcc, this.sbdb);
        this.tableSorterOcc.addMouseListenerToHeaderInTable(this.jTableOccurrences);
        this.tableModelOcc.undoSupport.addUndoableEditListener(this.undoManagerOccs);
        this.jTableOccurrences.setDragEnabled(true);
        this.jTableOccurrences.setTransferHandler(new TaxonTransferHandler(null));
        this.tableModelAnalyses.setupTable(this.jTableAnalyses, this.sbdb);
        this.tableSorterAnalyses.addMouseListenerToHeaderInTable(this.jTableAnalyses);
        this.jTabbedPaneSampleData.insertTab("Interpretations", new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_IntTab.png")), this.jPanelInterpretations, null, 3);
        this.addChartTab();
        this.setUnits(this.well.getWellUnits());
        if (this.units == 'F') {
            this.jRadioButtonFeet.setSelected(true);
        } else {
            this.jRadioButtonMetres.setSelected(true);
        }
        this.setSampleLabel();
        this.initKeyBindings();
        this.inStartup = false;
    }

    boolean occurrencesTabSelected() {
        return this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences;
    }

    UndoableEditSupport getUndoSupport() {
        return this.undoSupportOccs;
    }

    Smpdtl getSmpdtl() {
        if (this.jTableAnalyses.getSelectedRow() >= 0) {
            return this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
        }
        return null;
    }

    char getDiscID() {
        return Discipline.getChar((Discipline)this.getDiscipline());
    }

    Discipline getDiscipline() {
        Object o = this.jComboBoxDiscipline.getSelectedItem();
        Discipline d = o instanceof Discipline ? (Discipline)o : null;
        return d;
    }

    void moveAnalyses() {
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one or more analyses from the list", this.parent.getTitle(), 1);
            return;
        }
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        int[] selection = this.jTableAnalyses.getSelectedRows();
        AnalystHeader hdr = null;
        for (int i : selection) {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(i));
            if (hdr == null) {
                hdr = smpdtl.getHeader();
            } else if (hdr != smpdtl.getHeader()) {
                JOptionPane.showMessageDialog(this.parent, "You must select analyses from the same suite.", this.parent.getTitle(), 1);
                return;
            }
            smpdtls.add(smpdtl);
        }
        try {
            DialogAnalystHeaders dialog = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            AnalystHeader newHdr = dialog.selection;
            if (newHdr == hdr) {
                JOptionPane.showMessageDialog(this.parent, "The selected suite is the same as the selected analyses.", this.parent.getTitle(), 1);
                return;
            }
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                for (Smpdtl dtl : sample.getAnalyses()) {
                    if (dtl.getHeader() != newHdr) continue;
                    JOptionPane.showMessageDialog(this.parent, "Can't move - already analysis in target set for sample: " + sample, this.parent.getTitle(), 1);
                    return;
                }
            }
            Sample lastSample = null;
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                sample.moveDtl(this.well.getWellID(), hdr, newHdr);
                this.sbdb.commit();
                lastSample = sample;
            }
            lastSample.notifyObservers();
            this.jTableAnalyses.clearSelection();
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQL Error", (SQLException)ex);
            this.sbdb.doRollback();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    public String getTabTitle() {
        if (tabIsName) {
            return this.well.getWellName();
        }
        return this.well.getWellCode();
    }

    void reassignTaxon() {
        if (this.jTableOccurrences.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one occurrence from the list on the occurrences tab.", this.parent.getTitle(), 1);
            return;
        }
        TaxonOcc occ = (TaxonOcc)this.tableModelOcc.smpdtl.getOccurUnsorted().get(this.tableSorterOcc.getIndexOf(this.jTableOccurrences.getSelectedRow()));
        if (occ == null) {
            JOptionPane.showMessageDialog(this.parent, "No occurrence selected.", this.parent.getTitle(), 1);
            return;
        }
        try {
            DialogTaxonReassign dialog = new DialogTaxonReassign(this.parent, true, this.sbdb, this.well, occ.getTaxon());
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            this.jTableOccurrences.clearSelection();
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQLError", (SQLException)ex);
            this.sbdb.doRollback();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    void printChart() {
        this.jPanelCharts.printChart();
    }

    void saveChart(boolean vector) {
        try {
            this.jPanelCharts.saveChart(vector);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    void exportChartHTML() {
        this.jPanelCharts.writeHTMLChart();
    }

    void mergeAnalyses() {
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one or more analyses from the list", this.parent.getTitle(), 1);
            return;
        }
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        int[] selection = this.jTableAnalyses.getSelectedRows();
        AnalystHeader hdr = null;
        for (int i : selection) {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(i));
            if (hdr == null) {
                hdr = smpdtl.getHeader();
            } else if (hdr != smpdtl.getHeader()) {
                JOptionPane.showMessageDialog(this.parent, "You must select analyses from the same suite.", this.parent.getTitle(), 1);
                return;
            }
            smpdtls.add(smpdtl);
        }
        try {
            DialogAnalystHeaders dialog = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            AnalystHeader newHdr = dialog.selection;
            if (newHdr == hdr) {
                JOptionPane.showMessageDialog(this.parent, "The selected suite is the same as the selected analyses.", this.parent.getTitle(), 1);
                return;
            }
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                boolean foundExisting = false;
                for (Smpdtl dtl : sample.getAnalyses()) {
                    if (dtl.getHeader() != newHdr) continue;
                    foundExisting = true;
                    break;
                }
                if (foundExisting) continue;
                JOptionPane.showMessageDialog(this.parent, "Can't merge - there is no analysis in target set for sample: " + sample, this.parent.getTitle(), 1);
                return;
            }
            Sample lastSample = null;
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = smpdtl.getSample();
                sample.mergeDtl(this.well.getWellID(), smpdtl, newHdr);
                this.sbdb.commit();
                lastSample = sample;
            }
            lastSample.notifyObservers();
            this.jTableAnalyses.clearSelection();
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQLError", (SQLException)ex);
            this.sbdb.doRollback();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    void mergeSamples() {
        if (this.jTableSamples.getSelectedRowCount() != 2) {
            JOptionPane.showMessageDialog(this.parent, "Select two contiguous samples from the list", this.parent.getTitle(), 1);
            return;
        }
        int[] selection = this.jTableSamples.getSelectedRows();
        try {
            Sample sample1 = this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(selection[0]));
            Sample sample2 = this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(selection[1]));
            if (this.well.getSamples().indexOf(sample2) != this.well.getSamples().indexOf(sample1) + 1) {
                JOptionPane.showMessageDialog(this.parent, "Selected samples are not contiguous in the well. Remove intervening samples if necessary", this.parent.getTitle(), 1);
                return;
            }
            String reason = this.well.mergeSampleCheckConflicts(sample1, sample2);
            if (reason != null) {
                JOptionPane.showMessageDialog(this, "Cannot merge these samples without creating conflicting data: " + reason + "\nDelete data before proceeding", this.parent.getTitle(), 2);
                return;
            }
            DialogMergeSamples dialog = new DialogMergeSamples(this.parent, true, this.sbdb, this.units, this.well, sample1, sample2);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.jTableSamples.clearSelection();
            }
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQLError", (SQLException)ex);
            this.sbdb.doRollback();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    List<Smpdtl> getSelectedSmpdtls() {
        int[] rows;
        List<Smpdtl> smpdtls = this.tableModelAnalyses.getSmpdtls();
        LinkedList<Smpdtl> selected = new LinkedList<Smpdtl>();
        for (int row : rows = this.jTableAnalyses.getSelectedRows()) {
            selected.add(smpdtls.get(this.tableSorterAnalyses.getIndexOf(row)));
        }
        return selected;
    }

    void openOverlay() {
        try {
            Smpdtl smpdtl = null;
            if (this.jTableAnalyses.getSelectedRowCount() == 1) {
                smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
            }
            if (this.parent.parent.getFrameOverlay() == null) {
                DialogOverlays dialog = new DialogOverlays(this.parent, this.parent.parent, true, this.sbdb, true);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.selection == null) {
                    return;
                }
                dialog.selection.load();
                FrameOverlay frameOverlay = new FrameOverlay(this.parent.getParent().getAltGC(), this.parent.getParent(), this.sbdb, this.well, smpdtl, dialog.selection, this.parent.isCMF(), this.parent);
                this.parent.parent.setFrameOverlay(frameOverlay);
                this.parent.parent.getFrameOverlay().setExtendedState(6);
                frameOverlay.getUndoSupport().addUndoableEditListener(this.undoManagerOccs);
                this.parent.setOverlayTotaliser();
            } else {
                JOptionPane.showMessageDialog(this, "An overlay is already in use - close before reopening", "Close Overlay", 2);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    void openOverlayBrowser() {
        try {
            if (this.overlayServer != null) {
                if (JOptionPane.showConfirmDialog(this.parent, "An overlay server is already in use - restart?", this.parent.getTitle(), 0, 3) == 0) {
                    this.overlayServer.close();
                    this.overlayServer = null;
                } else {
                    return;
                }
            }
            DialogOverlays dialog = new DialogOverlays(this.parent, this.parent.parent, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            dialog.selection.load();
            DialogOverlayWeb dialogWeb = new DialogOverlayWeb((Frame)this.parent, true, this.sbdb, dialog.selection);
            dialogWeb.setLocationRelativeTo(this);
            dialogWeb.setVisible(true);
            if (!dialogWeb.isOk) {
                return;
            }
            this.overlayServer = new OverlayWebServer(dialogWeb.portNo, dialogWeb.textSize, dialogWeb.useSounds, this.sbdb, this.parent, this, dialog.selection);
            JOptionPane.showMessageDialog(this.parent, "Server started, use the following address in your browser:\nhttp://" + dialogWeb.myIp + ":" + dialogWeb.portNo, "StrataBugs overlay server", 1);
            this.overlayServer.getUndoSupport().addUndoableEditListener(this.undoManagerOccs);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parent, ex.getMessage(), this.parent.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    void closeOverlayServer() {
        if (this.overlayServer == null) {
            return;
        }
        this.overlayServer.close();
        this.overlayServer = null;
    }

    private void updateOverlay() {
        if (this.parent.parent.getFrameOverlay() == null) {
            return;
        }
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
        this.parent.parent.getFrameOverlay().setSmpdtl(this.well, smpdtl);
        smpdtl.addObserver((Observer)this);
    }

    private void updateComments() {
        String comment = DEFAULT_COMMENT_TEXT;
        Color foreground = Color.GRAY;
        this.jTextAreaComments.setEditable(false);
        try {
            Smpdtl smpdtl = this.tableModelOcc.smpdtl;
            WellInterp interp = this.jPanelInterpretations.getInterp();
            if (interp == null) {
                comment = "No interpretation loaded";
            } else if (smpdtl != null) {
                char occDiscID = smpdtl.getDiscID();
                Iterator it = interp.getComments(occDiscID).iterator();
                this.biocom = null;
                while (it.hasNext()) {
                    Biocom b = (Biocom)it.next();
                    if (b.getTopSample() != smpdtl.getSample() || b.getAnalyst() != smpdtl.getHeader().getAnalystUsrid()) continue;
                    this.biocom = b;
                    break;
                }
                if (this.biocom != null) {
                    comment = this.biocom.getText();
                    foreground = Color.BLACK;
                    this.jTextAreaComments.setEditable(true);
                }
            }
        }
        catch (Exception sb) {
            sb.printStackTrace();
        }
        this.jTextAreaComments.setText(comment);
        this.jTextAreaComments.setForeground(foreground);
    }

    void sampleAge() {
        if (this.jTableSamples.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one sample from the list", this.parent.getTitle(), 1);
            return;
        }
        int selection = this.jTableSamples.getSelectedRow();
        try {
            Sample sample = this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(selection));
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this.parent, "Select a version", this.parent.getTitle(), 1);
                return;
            }
            DialogSampleAge dialog = new DialogSampleAge(this.parent, true, this.well, sample, wellInterp.getHeader().getInterpID());
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.tableSorterSamples.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    void sampleWeight() {
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select at least one sample analysis.", this.parent.getTitle(), 2);
            return;
        }
        int[] selection = this.jTableAnalyses.getSelectedRows();
        String weightString = JOptionPane.showInputDialog(this.parent, (Object)"Enter sample weight for all selected analyses: ");
        if (weightString == null || weightString.length() == 0) {
            return;
        }
        try {
            float weight = Float.parseFloat(weightString);
            Smpdtl last = null;
            for (int i = 0; i < selection.length; ++i) {
                Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(selection[i]);
                smpdtl.setWeight(this.sbdb, this.well.getWellID(), weight);
                last = smpdtl;
            }
            last.notifyObservers();
            this.sbdb.commit();
        }
        catch (Exception e) {
            this.sbdb.doRollback();
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    void sampleCopy() {
        if (this.jTableAnalyses.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select a sample analysis to copy into", this.parent.getTitle(), 2);
            return;
        }
        if (this.tableModelOcc.unsaved != null && !this.tableModelOcc.unsaved.isEmpty()) {
            this.tableModelOcc.unsaved = null;
        }
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
        try {
            smpdtl.load(this.well.getWellID());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        String smpdtlStrg = smpdtl.getSample().toString(this.units) + " " + smpdtl.getHeader().toString();
        DialogSampleCopy dialog = new DialogSampleCopy(this.parent, true, this.sbdb, this.well, smpdtl.getDiscID(), smpdtlStrg, smpdtl.getOccur().isEmpty());
        SB.centreDialog((Dialog)dialog);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.doSampleCopy(dialog.smpdtlFrom, smpdtl, dialog.getKeepAbundance(), dialog.getIgnoreQs(), dialog.getKeepComments(), dialog.getTaxa());
        }
    }

    private void doSampleCopy(Smpdtl smpdtlFrom, Smpdtl smpdtl, int abnOpt, boolean ignoreQ, boolean keepComments, List<Taxon> taxaToCopy) {
        try {
            this.showOccurrences();
            int abnSchID = smpdtlFrom.getHeader().getAbnSchID();
            AbnScheme abn = null;
            if (abnSchID > 0) {
                abn = this.sbdb.getAbnScheme(abnSchID, false);
            }
            SbugsCompoundEdit edit = null;
            if (abnOpt != 3) {
                edit = new SbugsCompoundEdit("copy occurrences");
            }
            block7: for (TaxonOcc fss : smpdtlFrom.getOccur()) {
                int fine;
                int medium;
                int coarse;
                String subj;
                if (!taxaToCopy.contains(fss.getTaxon())) continue;
                if (abnOpt == 3 && !smpdtl.getOccur().isEmpty()) {
                    for (TaxonOcc occ : smpdtl.getOccur()) {
                        if (occ.getTaxon() != fss.getTaxon() || !ignoreQ && (fss.getReworked() != occ.getReworked() || fss.getQuestionable() != occ.getQuestionable() || fss.getSpecType() != occ.getSpecType())) continue;
                        continue block7;
                    }
                }
                switch (abnOpt) {
                    default: {
                        subj = fss.getSubAbund();
                        coarse = fss.getCoarse();
                        medium = fss.getMedium();
                        fine = fss.getFine();
                        break;
                    }
                    case 2: 
                    case 3: {
                        subj = "+";
                        coarse = 0;
                        medium = 0;
                        fine = 0;
                    }
                }
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.sbdb, fss.getTaxon(), ignoreQ ? false : fss.getReworked(), ignoreQ ? false : fss.getQuestionable(), fss.getSpecType());
                if (!ignoreQ) {
                    builder.caved(fss.getCaved());
                    builder.marker(fss.isMarker());
                }
                if (keepComments) {
                    builder.preservation(fss.getPreservation());
                    builder.colour(fss.getColour());
                    builder.comment(fss.getComment());
                }
                if (abnOpt == 3) {
                    this.tableModelOcc.addUnsaved(builder);
                    this.tableModelOcc.fireTableDataChanged();
                    continue;
                }
                builder.count(coarse, medium, fine).subjAbund(subj);
                edit.addEdit((UndoableEdit)smpdtl.insertOccurrence(builder, this.well.getWellID()));
            }
            if (edit != null) {
                edit.end();
                this.undoSupportOccs.postEdit((UndoableEdit)edit);
            }
            smpdtl.notifyObservers();
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            this.sbdb.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void sampleGenerate() {
        try {
            DialogSampleGenerate dialog = new DialogSampleGenerate(this.parent, true, this.sbdb, this.well, this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.addAnalyses && !dialog.generated.isEmpty()) {
                AnalystHeader hdr;
                if (this.well.getAnalystHeaders().size() == 1) {
                    hdr = (AnalystHeader)this.well.getAnalystHeaders().get(0);
                } else {
                    DialogAnalystHeaders dialogAnalystHeaders = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
                    dialogAnalystHeaders.setLocationRelativeTo(this.parent);
                    dialogAnalystHeaders.setVisible(true);
                    hdr = dialogAnalystHeaders.selection;
                }
                if (hdr != null) {
                    int added = 0;
                    for (Sample sample : dialog.generated) {
                        sample.addDtl(this.well.getWellID(), hdr, Smpdtl.AnalysisType.PREPARED, "", "", "", 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
                        ++added;
                    }
                    if (added > 0) {
                        this.sbdb.commit();
                        this.well.setDataChanged();
                        this.well.notifyObservers(Smpdtl.class);
                        JOptionPane.showMessageDialog(this, added + " analyses added", "Generate samples", 1);
                    }
                }
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void initKeyBindings() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, 128), "undo");
        this.getActionMap().put("undo", new UndoAction(true));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(90, 192), "redo");
        this.getActionMap().put("redo", new UndoAction(false));
    }

    void addChartTab() {
        this.jTabbedPaneSampleData.insertTab("Charts", new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_ChartTab.png")), this.jPanelCharts, null, 4);
        this.chartsFrameDetached = null;
    }

    boolean detachChartTab() {
        boolean ret = false;
        if (this.chartsFrameDetached == null) {
            this.jPanelCharts.stateChanged();
            this.chartsFrameDetached = new FrameWellChartsDetached(this, this.jPanelCharts);
            this.remove(this.jPanelCharts);
            ret = true;
        }
        this.chartsFrameDetached.setLocationRelativeTo(this);
        this.chartsFrameDetached.setVisible(true);
        return ret;
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof Well && obs == this.well) {
            if (!(arg instanceof WellInterp)) {
                if (arg instanceof WellHeader) {
                    this.parent.setWellTabTitle(this.well);
                } else if (arg instanceof AnalystHeader) {
                    AnalystHeader hdr = (AnalystHeader)arg;
                    if (this.comboModelAnalyNo.getIndexOf(hdr.getAnalyNumber()) < 0) {
                        this.comboModelAnalyNo.addElement(hdr.getAnalyNumber());
                        this.jComboBoxAnalysisNumber.updateUI();
                    }
                    try {
                        if (this.comboModelAnalyst.getIndexOf(hdr.getAnalyst()) < 0) {
                            this.comboModelAnalyst.addElement(hdr.getAnalyst());
                            this.jComboBoxAnalyst.updateUI();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (arg instanceof Smpdtl) {
                    if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences && (Smpdtl)arg == this.tableModelOcc.smpdtl) {
                        this.tableSorterOcc.reallocateIndexes();
                        this.tableSorterOcc.fireTableDataChanged();
                        this.tableSorterOcc.sort((Object)this);
                    } else {
                        this.refreshAnalyses();
                    }
                } else if (arg instanceof Sample || arg == Sample.class) {
                    this.tableSorterSamples.reallocateIndexes();
                    this.tableSorterSamples.sort((Object)this);
                    this.tableSorterSamples.fireTableDataChanged();
                    this.refreshAnalyses();
                    try {
                        this.setSampleLabel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (arg == SampleLithology.class) {
                    this.tableSorterSamples.reallocateIndexes();
                    this.tableSorterSamples.sort((Object)this);
                    this.tableSorterSamples.fireTableDataChanged();
                } else {
                    this.tableSorterSamples.reallocateIndexes();
                    this.tableSorterSamples.sort((Object)this);
                    this.tableSorterSamples.fireTableDataChanged();
                    this.refreshAnalyses();
                    try {
                        this.setSampleLabel();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else if (obs instanceof Smpdtl && obs == this.tableModelOcc.smpdtl) {
            this.tableSorterOcc.reallocateIndexes();
            this.tableSorterOcc.fireTableDataChanged();
            this.tableSorterOcc.sort((Object)this);
            Smpdtl smpdtl = this.tableModelOcc.smpdtl;
            try {
                this.jTextFieldAnalyst.setText(smpdtl.getAnalyst() + "/" + smpdtl.getHeader().getAnalyNumber());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.jCheckBoxBarren.isSelected() != smpdtl.getBarren()) {
                this.jCheckBoxBarren.setSelected(smpdtl.getBarren());
            }
            this.setNTaxaText(smpdtl);
            this.updateTotals();
            if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelAnalyses) {
                this.refreshAnalyses();
            }
        } else if (obs instanceof Sample) {
            this.refreshAnalyses();
        } else if (obs instanceof WellInterp && obs == this.jPanelInterpretations.getInterp() && arg instanceof Biocom) {
            this.updateComments();
        }
    }

    void setNTaxaText() {
        this.setNTaxaText(this.getSmpdtl());
    }

    void setNTaxaText(Smpdtl smpdtl) {
        if (smpdtl != null) {
            this.jLabelNtaxa.setText("<html><b>Taxa: </b>" + smpdtl.getOccur().size() + "</html>");
            String text = "<html><b>Total: </b>" + smpdtl.getTotalCount(this.parent.getTotExRwCv());
            if (this.parent.getPicklistTotaliser() > 0) {
                text = text + "/" + this.parent.getPicklistTotaliser();
            }
            text = text + "</html>";
            this.jLabelNtaxaTotal.setText(text);
        }
    }

    private void refresh() {
        this.well.addObserver((Observer)this);
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.tableModelSamples.setSamples(this.well, this);
            this.tableModelAnalyses.setSmpdtls(this.well.getAnalyses('\u0000', null, 0), this);
            this.fillAnalystCombo();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error loading samples", (Exception)e);
        }
        this.tableSorterSamples.reallocateIndexes();
        this.tableSorterSamples.fireTableDataChanged();
        this.tableSorterAnalyses.reallocateIndexes();
        this.tableSorterAnalyses.fireTableDataChanged();
        try {
            this.jPanelInterpretations.fillBioSchemeCombo();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error loading samples", (Exception)e);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    void setUnits(char units) {
        if (units == 'M' && this.units != 'M' || units == 'F' && this.units != 'F') {
            this.units = units;
            this.tableModelSamples.setUnits(units);
            this.jTableSamples.getColumnModel().getColumn(0).setHeaderValue(TableModelSamples.columnHeaders[0] + " (" + SB.unitAbr((char)units) + ")");
            this.tableSorterSamples.fireTableDataChanged();
            this.tableModelAnalyses.units = units;
            this.tableSorterAnalyses.fireTableDataChanged();
            this.jPanelInterpretations.setUnits(units);
        }
    }

    void setBarren(boolean barren) {
        this.jCheckBoxBarren.setSelected(barren);
    }

    private void fillAnalystCombo() throws SQLException, SBException {
        this.comboModelAnalyst.removeAllElements();
        this.comboModelAnalyst.addElement(ALL_STRING);
        this.comboModelAnalyNo.removeAllElements();
        this.comboModelAnalyNo.addElement(ALL_STRING);
        List hdrs = this.well.getAnalystHeaders();
        for (AnalystHeader hdr : hdrs) {
            if (this.comboModelAnalyst.getIndexOf(hdr.getAnalyst()) < 0) {
                this.comboModelAnalyst.addElement(hdr.getAnalyst());
            }
            if (this.comboModelAnalyNo.getIndexOf(hdr.getAnalyNumber()) >= 0) continue;
            this.comboModelAnalyNo.addElement(hdr.getAnalyNumber());
        }
        this.jComboBoxAnalyst.updateUI();
        this.jComboBoxAnalyst.setSelectedIndex(0);
        this.jComboBoxAnalysisNumber.setSelectedIndex(0);
        this.analyNo = 0;
        this.analystString = "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean addAnalysis(boolean fromSampleTab) {
        try {
            AnalystHeader analyHdr;
            Sample sample = null;
            LinkedList<Sample> samples = null;
            if (!fromSampleTab && this.jTableAnalyses.getSelectedRowCount() == 1) {
                Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
                sample = smpdtl.getSample();
            } else if (this.jTableSamples.getSelectedRowCount() < 1) {
                DialogSelectSample samplesDialog = new DialogSelectSample(this.parent, true, this.sbdb, this.well, null, this.units);
                samplesDialog.setLocationRelativeTo(this);
                samplesDialog.setVisible(true);
                if (!samplesDialog.isOK) return false;
                sample = samplesDialog.selection;
            } else if (this.jTableSamples.getSelectedRowCount() == 1) {
                sample = this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(this.jTableSamples.getSelectedRow()));
            } else {
                samples = new LinkedList<Sample>();
                int[] selection = this.jTableSamples.getSelectedRows();
                for (int index = 0; index < selection.length; ++index) {
                    samples.add(this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(selection[index])));
                }
            }
            Discipline currentDiscID = this.getDiscipline();
            if (currentDiscID == null || this.analystString == null || this.analystString.length() == 0 || this.analyNo == 0) {
                DialogAnalystHeaders dialogAnalystHeaders = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
                dialogAnalystHeaders.setLocationRelativeTo(this.parent);
                dialogAnalystHeaders.setVisible(true);
                if (dialogAnalystHeaders.selection == null) {
                    return false;
                }
                analyHdr = dialogAnalystHeaders.selection;
            } else {
                analyHdr = this.well.getAnalystHeader(this.analystString, currentDiscID.getChar(), this.analyNo, true);
            }
            if (samples == null) {
                DialogAnalysis dialog = new DialogAnalysis(this.parent, true, this.sbdb, this.well, sample, null, analyHdr, this.units);
                dialog.setLocationRelativeTo(this.parent);
                dialog.setVisible(true);
                if (!dialog.isOK()) return false;
                this.tableSorterSamples.fireTableDataChanged();
                this.setSelectedSample(sample);
                this.setSelectedAnalysis(sample, dialog.smpdtl);
                return true;
            }
            for (Sample toAdd : samples) {
                if (toAdd.getAnalysis(analyHdr.getAnalyID()) != null) continue;
                toAdd.addDtl(this.well.getWellID(), analyHdr, Smpdtl.AnalysisType.PREPARED, "", "", "", 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
                sample = toAdd;
            }
            if (sample != null) {
                this.sbdb.commit();
                sample.notifyObservers();
                this.well.setDataChanged();
                this.well.notifyObservers(Smpdtl.class);
                this.tableSorterSamples.fireTableDataChanged();
                return true;
            }
            JOptionPane.showMessageDialog(this.parent, "Analyses already exist - no new analyses added", this.parent.getTitle(), 1);
            return false;
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQL Error", (SQLException)ex);
            this.sbdb.doRollback();
            return false;
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
        return false;
    }

    void editAnalysis() {
        if (this.jTableAnalyses.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one analysis from the list", this.parent.getTitle(), 1);
            return;
        }
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
        Sample sample = smpdtl.getSample();
        try {
            DialogAnalysis dialog = new DialogAnalysis(this.parent, true, this.sbdb, this.well, sample, smpdtl, smpdtl.getHeader(), this.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            int index = this.tableSorterAnalyses.getIndexOf(this.tableModelAnalyses.getSmpdtls().indexOf(dialog.smpdtl));
            if (index >= 0) {
                this.jTableAnalyses.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQLError", (SQLException)ex);
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    WellInterp getInterp() {
        return this.jPanelInterpretations.getInterp();
    }

    void selectDefaultVersion() {
        this.jPanelInterpretations.loadDefaultVersion();
    }

    Well getWell() {
        return this.well;
    }

    private void refreshAnalyses() {
        try {
            this.tableModelAnalyses.setSmpdtls(this.well.getAnalyses(this.getDiscID(), this.analystString, this.analyNo), this);
            this.tableSorterAnalyses.reallocateIndexes();
            this.tableSorterAnalyses.sort((Object)this);
            this.tableSorterAnalyses.fireTableDataChanged();
            if (this.tableModelOcc.smpdtl != null && this.tableModelAnalyses.getSmpdtls().indexOf(this.tableModelOcc.smpdtl) < 0) {
                this.tableModelOcc.smpdtl = null;
                this.tableModelOcc.unsaved = null;
            }
            this.tableSorterOcc.fireTableDataChanged();
            this.jLabelnAnalyses.setText(this.tableModelAnalyses.getSmpdtls().size() + " Analyses");
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (SBException ex) {
            ex.printStackTrace();
        }
    }

    private void setSplits(Smpdtl smpdtl) {
        TableColumnModel columns = this.jTableOccurrences.getColumnModel();
        TableColumn coarseCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(8));
        TableColumn mediumCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(9));
        TableColumn fineCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(10));
        TableColumn aggCol = columns.getColumn(this.jTableOccurrences.convertColumnIndexToView(11));
        if (!(this.parent.isCMF() || smpdtl != null && smpdtl.hasSplitCountData())) {
            coarseCol.setMinWidth(0);
            coarseCol.setMaxWidth(0);
            coarseCol.setResizable(false);
            fineCol.setMinWidth(0);
            fineCol.setMaxWidth(0);
            fineCol.setResizable(false);
            aggCol.setMinWidth(0);
            aggCol.setMaxWidth(0);
            aggCol.setResizable(false);
            mediumCol.setHeaderValue("Counts");
        } else {
            int maxwidth = columns.getColumn(9).getMaxWidth();
            coarseCol.setMaxWidth(maxwidth);
            coarseCol.setMinWidth(15);
            coarseCol.setPreferredWidth(this.tableModelOcc.getDefaultColumnWidths()[8]);
            coarseCol.setResizable(true);
            fineCol.setMaxWidth(maxwidth);
            fineCol.setMinWidth(15);
            fineCol.setPreferredWidth(this.tableModelOcc.getDefaultColumnWidths()[10]);
            fineCol.setResizable(true);
            aggCol.setMinWidth(15);
            aggCol.setMaxWidth(maxwidth);
            aggCol.setPreferredWidth(this.tableModelOcc.getDefaultColumnWidths()[11]);
            aggCol.setResizable(true);
            mediumCol.setHeaderValue(TableModelOccurence.columnTitles[9]);
        }
    }

    private boolean showOccurrences() {
        if (this.tableModelAnalyses.getRowCount() > 0) {
            int row = this.jTableAnalyses.getSelectedRow();
            if (row < 0) {
                row = 0;
                this.jTableAnalyses.setRowSelectionInterval(row, row);
            }
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(row));
            if (this.tableModelOcc.smpdtl != null && smpdtl != this.tableModelOcc.smpdtl && this.tableModelOcc.unsaved != null && !this.tableModelOcc.unsaved.isEmpty()) {
                String msg = "You will lose all unsaved occurrences in analysis '" + this.tableModelOcc.smpdtl.getSample().toString(this.well.getWellUnits(), true, false) + " " + this.tableModelOcc.smpdtl.getHeader() + " " + SBdb.getDiscAbr((char)this.tableModelOcc.smpdtl.getDiscID()) + "'\nContinue?";
                if (JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0) != 0) {
                    return false;
                }
                this.tableModelOcc.unsaved = null;
            }
            try {
                smpdtl.load(this.well.getWellID());
                this.jTextFieldDiscipline.setText(SBdb.getDiscAbr((char)smpdtl.getDiscID()));
                this.jTextFieldSample.setText(smpdtl.getSample().toString(this.units));
                this.jTextFieldAnalyst.setText(smpdtl.getAnalyst() + "/" + smpdtl.getHeader().getAnalyNumber());
                this.jCheckBoxBarren.setSelected(smpdtl.getBarren());
                this.tableModelOcc.smpdtl = smpdtl;
                this.tableModelOcc.well = this.well;
                this.tableSorterOcc.reallocateIndexes();
                this.tableSorterOcc.sort((Object)this);
                this.setSplits(smpdtl);
                this.tableModelOcc.setRowHeight(this.jTableOccurrences, this.tableSorterOcc);
                this.tableSorterOcc.fireTableDataChanged();
                this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelOccurences);
                this.setNTaxaText(smpdtl);
                this.updateTotals();
                smpdtl.addObserver((Observer)this);
                for (JPanelPicklist picklist : this.parent.getPicklists()) {
                    picklist.setAbnScheme();
                    picklist.resetSampleTotalMessage();
                }
                this.parent.setOverlayTotaliser();
                this.updateComments();
                this.undoManagerOccs.discardAllEdits();
                this.setUndoTooltips();
                boolean enableOccButtons = true;
                if (this.sbdb.restrictedToDiscID(smpdtl.getDiscID())) {
                    enableOccButtons = false;
                }
                this.jButtonOccComment.setEnabled(enableOccButtons);
                this.jButtonOccEdit.setEnabled(enableOccButtons);
                this.jButtonOccEvent.setEnabled(enableOccButtons);
                this.jButtonDeleteOccurences.setEnabled(enableOccButtons);
                return true;
            }
            catch (SQLException ex) {
                SB.showStackError((String)"SQLError", (SQLException)ex);
            }
            catch (SBException ex) {
                SB.showStackError((String)"Error", (Exception)((Object)ex));
            }
            return false;
        }
        this.jTextFieldDiscipline.setText("");
        this.jTextFieldSample.setText("No analyses");
        this.jTextFieldAnalyst.setText("");
        this.jLabelNtaxa.setText("");
        this.jCheckBoxBarren.setSelected(false);
        this.tableModelOcc.smpdtl = null;
        this.tableSorterOcc.reallocateIndexes();
        this.tableSorterOcc.fireTableDataChanged();
        this.setNTaxaText(null);
        JPanelPicklist picklist = this.parent.getPicklists().get(0);
        if (picklist != null) {
            picklist.resetSampleTotalMessage();
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroupDepthUnits = new ButtonGroup();
        this.jTabbedPaneSampleData = new JTabbedPane();
        this.jPanelSamples = new JPanel();
        this.jButtonAddSample = new JButton();
        this.jButtonEditSample = new JButton();
        this.jButtonDeleteSamples = new JButton();
        this.jScrollPaneSamples = new JScrollPane();
        this.jTableSamples = new JTable();
        this.jButtonAddSampleSmpdtl = new JButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jLabelSamples = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.jButtonSaveSamples = new JButton();
        this.jPanelAnalyses = new JPanel();
        this.jScrollPaneAnalyses = new JScrollPane();
        this.jTableAnalyses = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBoxDiscipline = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxAnalyst = new JComboBox();
        this.jButtonAnalystHeader = new JButton();
        this.jButtonAddSmpdtl = new JButton();
        this.jButtonEditSmpdtl = new JButton();
        this.jButtonDeleteSmpdtl = new JButton();
        this.jLabel7 = new JLabel();
        this.jComboBoxAnalysisNumber = new JComboBox();
        this.jButtonShowAll = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonSaveAsAnalyses = new JButton();
        this.jLabelnAnalyses = new JLabel();
        this.jPanelOccurences = new JPanel();
        this.jTextFieldSample = new JTextField();
        this.jButtonNext = new JButton();
        this.jButtonPrevious = new JButton();
        this.jCheckBoxBarren = new JCheckBox();
        this.jTextFieldAnalyst = new JTextField();
        this.jTextFieldDiscipline = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonDeleteOccurences = new JButton();
        this.jButtonOccEvent = new JButton();
        this.jButtonOccEdit = new JButton();
        this.jButtonOccComment = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPaneOccurences = new JScrollPane();
        this.jTableOccurrences = new SbugsTable(this.tableSorterOcc);
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComments = new JTextArea();
        this.jPanelTotals = new JPanel();
        this.jPanelTotals.setLayout(new GridLayout(0, 1, 0, 3));
        this.jLabelNtaxa = new JLabel();
        this.jLabelNtaxaTotal = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jToolBarOccUndo = new JToolBar();
        this.jButtonOccUndo = new JButton();
        this.jButtonOccRedo = new JButton();
        this.jButtonOccInsertPrev = new JButton();
        this.jTabbedPaneSampleData.setMinimumSize(new Dimension(550, 600));
        this.jTabbedPaneSampleData.setPreferredSize(new Dimension(300, 100));
        this.jTabbedPaneSampleData.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWell.this.jTabbedPaneSampleDataMouseClicked(evt);
            }
        });
        this.jTabbedPaneSampleData.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JPanelWell.this.jTabbedPaneSampleDataStateChanged(evt);
            }
        });
        this.jButtonAddSample.setText("Add...");
        this.jButtonAddSample.setToolTipText("Add a new sample");
        this.jButtonAddSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonAddSampleActionPerformed(evt);
            }
        });
        this.jButtonEditSample.setText("Edit...");
        this.jButtonEditSample.setToolTipText("Edit selected sample");
        this.jButtonEditSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonEditSampleActionPerformed(evt);
            }
        });
        this.jButtonDeleteSamples.setText("Delete");
        this.jButtonDeleteSamples.setToolTipText("<html>Delete selected sample(s)<br>\n[DEL]");
        this.jButtonDeleteSamples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonDeleteSamplesActionPerformed(evt);
            }
        });
        this.jTableSamples.setModel((TableModel)this.tableSorterSamples);
        this.jTableSamples.setAutoResizeMode(1);
        this.jTableSamples.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWell.this.jTableSamplesMouseClicked(evt);
            }
        });
        this.jTableSamples.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWell.this.jTableSamplesKeyPressed(evt);
            }
        });
        this.jScrollPaneSamples.setViewportView(this.jTableSamples);
        this.jButtonAddSampleSmpdtl.setText("Add Analysis...");
        this.jButtonAddSampleSmpdtl.setToolTipText("Create analysis for selected sample(s)");
        this.jButtonAddSampleSmpdtl.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddSampleSmpdtl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonAddSampleSmpdtlActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupDepthUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupDepthUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabelSamples.setFont(new Font("Tahoma", 1, 11));
        this.jLabelSamples.setText("samples");
        this.jButtonSaveSamples.setText("Save as...");
        this.jButtonSaveSamples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonSaveSamplesActionPerformed(evt);
            }
        });
        GroupLayout jPanelSamplesLayout = new GroupLayout((Container)this.jPanelSamples);
        this.jPanelSamples.setLayout((LayoutManager)jPanelSamplesLayout);
        jPanelSamplesLayout.setHorizontalGroup((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSamplesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1, false).add((Component)this.jSeparator5).add((Component)this.jButtonDeleteSamples, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditSample, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddSample, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelSamples).add((Component)this.jSeparator4).add((Component)this.jButtonSaveSamples, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddSampleSmpdtl, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jScrollPaneSamples, -1, 699, Short.MAX_VALUE)));
        jPanelSamplesLayout.setVerticalGroup((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSamplesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSamplesLayout.createParallelGroup(1).add((Component)this.jScrollPaneSamples, -1, 606, Short.MAX_VALUE).add((GroupLayout.Group)jPanelSamplesLayout.createSequentialGroup().add((Component)this.jButtonAddSample).addPreferredGap(0).add((Component)this.jButtonEditSample).addPreferredGap(0).add((Component)this.jButtonDeleteSamples).addPreferredGap(1).add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonAddSampleSmpdtl).addPreferredGap(1).add((Component)this.jSeparator5, -2, 11, -2).addPreferredGap(0).add((Component)this.jButtonSaveSamples).add(28, 28, 28).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, 295, Short.MAX_VALUE).add((Component)this.jLabelSamples).addContainerGap()))));
        this.jTabbedPaneSampleData.addTab("Samples", new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_SamplesTab.png")), this.jPanelSamples);
        this.jTableAnalyses.setModel((TableModel)this.tableSorterAnalyses);
        this.jTableAnalyses.setAutoResizeMode(1);
        this.jTableAnalyses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWell.this.jTableAnalysesMouseClicked(evt);
            }
        });
        this.jTableAnalyses.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWell.this.jTableAnalysesKeyPressed(evt);
            }
        });
        this.jScrollPaneAnalyses.setViewportView(this.jTableAnalyses);
        this.jLabel1.setForeground(new Color(51, 102, 204));
        this.jLabel1.setText("Discipline:");
        this.jComboBoxDiscipline.setModel(this.comboModelDiscipline);
        this.jComboBoxDiscipline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jComboBoxDisciplineActionPerformed(evt);
            }
        });
        this.jLabel2.setForeground(new Color(51, 102, 204));
        this.jLabel2.setText("Analyst:");
        this.jComboBoxAnalyst.setModel(this.comboModelAnalyst);
        this.jComboBoxAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jComboBoxAnalystActionPerformed(evt);
            }
        });
        this.jButtonAnalystHeader.setText("...");
        this.jButtonAnalystHeader.setToolTipText("View analyst suites");
        this.jButtonAnalystHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonAnalystHeaderActionPerformed(evt);
            }
        });
        this.jButtonAddSmpdtl.setText("Add...");
        this.jButtonAddSmpdtl.setToolTipText("Add new analysis for selected sample");
        this.jButtonAddSmpdtl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonAddSmpdtlActionPerformed(evt);
            }
        });
        this.jButtonEditSmpdtl.setText("Edit...");
        this.jButtonEditSmpdtl.setToolTipText("Edit selected analysis");
        this.jButtonEditSmpdtl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonEditSmpdtlActionPerformed(evt);
            }
        });
        this.jButtonDeleteSmpdtl.setText("Delete");
        this.jButtonDeleteSmpdtl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonDeleteSmpdtlActionPerformed(evt);
            }
        });
        this.jLabel7.setForeground(new Color(51, 102, 204));
        this.jLabel7.setText("Suite:");
        this.jComboBoxAnalysisNumber.setModel(this.comboModelAnalyNo);
        this.jComboBoxAnalysisNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jComboBoxAnalysisNumberActionPerformed(evt);
            }
        });
        this.jButtonShowAll.setText("Show all");
        this.jButtonShowAll.setToolTipText("Show all disciplines, analysts and suites");
        this.jButtonShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonShowAllActionPerformed(evt);
            }
        });
        this.jButtonSaveAsAnalyses.setText("Save as...");
        this.jButtonSaveAsAnalyses.setToolTipText("Save the list (or selected) analyses as a CSV file");
        this.jButtonSaveAsAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonSaveAsAnalysesActionPerformed(evt);
            }
        });
        this.jLabelnAnalyses.setFont(new Font("Tahoma", 1, 11));
        this.jLabelnAnalyses.setText("Analyses");
        GroupLayout jPanelAnalysesLayout = new GroupLayout((Container)this.jPanelAnalyses);
        this.jPanelAnalyses.setLayout((LayoutManager)jPanelAnalysesLayout);
        jPanelAnalysesLayout.setHorizontalGroup((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add(2, (Component)this.jSeparator2).add((Component)this.jButtonEditSmpdtl, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddSmpdtl, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteSmpdtl, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAsAnalyses, -2, 83, -2).add((Component)this.jLabelnAnalyses)).addPreferredGap(0).add((Component)this.jScrollPaneAnalyses, -1, 703, Short.MAX_VALUE)).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBoxDiscipline, -2, 128, -2).add(7, 7, 7).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jComboBoxAnalyst, -2, 83, -2).add(12, 12, 12).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.jComboBoxAnalysisNumber, -2, 60, -2).addPreferredGap(0).add((Component)this.jButtonAnalystHeader, -2, 30, -2).addPreferredGap(0).add((Component)this.jButtonShowAll))).addContainerGap()));
        jPanelAnalysesLayout.linkSize(new Component[]{this.jButtonAddSmpdtl, this.jButtonDeleteSmpdtl, this.jButtonEditSmpdtl, this.jButtonSaveAsAnalyses, this.jSeparator2}, 1);
        jPanelAnalysesLayout.setVerticalGroup((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxDiscipline, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jComboBoxAnalyst, -2, -1, -2).add((Component)this.jComboBoxAnalysisNumber, -2, -1, -2).add((Component)this.jButtonAnalystHeader).add((Component)this.jButtonShowAll).add((Component)this.jLabel7)).add(13, 13, 13).add((GroupLayout.Group)jPanelAnalysesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelAnalysesLayout.createSequentialGroup().add((Component)this.jButtonAddSmpdtl).add(4, 4, 4).add((Component)this.jButtonEditSmpdtl).addPreferredGap(0).add((Component)this.jButtonDeleteSmpdtl).addPreferredGap(1).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSaveAsAnalyses).addPreferredGap(0, 416, Short.MAX_VALUE).add((Component)this.jLabelnAnalyses).addContainerGap()).add((Component)this.jScrollPaneAnalyses, -1, 570, Short.MAX_VALUE))));
        this.jTabbedPaneSampleData.addTab("Analyses", new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameIcon_Samples/16Samples.png")), this.jPanelAnalyses);
        this.jTextFieldSample.setBackground(new Color(255, 255, 204));
        this.jTextFieldSample.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextFieldSample.setEnabled(false);
        this.jTextFieldSample.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JPanelWell.this.jTextFieldSampleFocusGained(evt);
            }
        });
        this.jButtonNext.setText("Next");
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonNextActionPerformed(evt);
            }
        });
        this.jButtonPrevious.setText("Previous");
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jCheckBoxBarren.setText("Barren");
        this.jCheckBoxBarren.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxBarren.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxBarren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jCheckBoxBarrenActionPerformed(evt);
            }
        });
        this.jTextFieldAnalyst.setEditable(false);
        this.jTextFieldAnalyst.setBackground(new Color(255, 255, 204));
        this.jTextFieldAnalyst.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextFieldAnalyst.setEnabled(false);
        this.jTextFieldDiscipline.setEditable(false);
        this.jTextFieldDiscipline.setBackground(new Color(255, 255, 204));
        this.jTextFieldDiscipline.setDisabledTextColor(new Color(0, 0, 0));
        this.jTextFieldDiscipline.setEnabled(false);
        this.jLabel5.setText("Discipline:");
        this.jLabel6.setText("Analysis suite:");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Sample: ");
        this.jButtonDeleteOccurences.setText("Delete");
        this.jButtonDeleteOccurences.setPreferredSize(new Dimension(73, 23));
        this.jButtonDeleteOccurences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonDeleteOccurencesActionPerformed(evt);
            }
        });
        this.jButtonOccEvent.setText("Event...");
        this.jButtonOccEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonOccEventActionPerformed(evt);
            }
        });
        this.jButtonOccEdit.setText("Edit...");
        this.jButtonOccEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonOccEditActionPerformed(evt);
            }
        });
        this.jButtonOccComment.setText("Comment...");
        this.jButtonOccComment.setToolTipText("<html>Add selected occurrences to<br> Biostratigraphic comment at this depth</html>");
        this.jButtonOccComment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonOccCommentActionPerformed(evt);
            }
        });
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jTableOccurrences.setModel((TableModel)this.tableSorterOcc);
        this.jTableOccurrences.setAutoResizeMode(4);
        this.jTableOccurrences.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWell.this.jTableOccurrencesMouseClicked(evt);
            }
        });
        this.jTableOccurrences.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWell.this.jTableOccurrencesKeyPressed(evt);
            }
        });
        this.jScrollPaneOccurences.setViewportView(this.jTableOccurrences);
        this.jSplitPane1.setTopComponent(this.jScrollPaneOccurences);
        this.jTextAreaComments.setColumns(20);
        this.jTextAreaComments.setEditable(false);
        this.jTextAreaComments.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaComments.setForeground(Color.GRAY);
        this.jTextAreaComments.setLineWrap(true);
        this.jTextAreaComments.setRows(5);
        this.jTextAreaComments.setText(DEFAULT_COMMENT_TEXT);
        this.jTextAreaComments.setToolTipText("Biostratigraphic comments");
        this.jTextAreaComments.setWrapStyleWord(true);
        this.jTextAreaComments.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWell.this.jTextAreaCommentsMouseClicked(evt);
            }
        });
        this.jTextAreaComments.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanelWell.this.jTextAreaCommentsFocusLost(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaComments);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jPanelTotals.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Totals", 0, 0, null, new Color(51, 102, 204)), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        GroupLayout jPanelTotalsLayout = new GroupLayout((Container)this.jPanelTotals);
        this.jPanelTotals.setLayout((LayoutManager)jPanelTotalsLayout);
        jPanelTotalsLayout.setHorizontalGroup((GroupLayout.Group)jPanelTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTotalsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelTotalsLayout.createParallelGroup(1, false).add((Component)this.jLabelNtaxaTotal, -1, 57, Short.MAX_VALUE).add((Component)this.jLabelNtaxa, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator3)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelTotalsLayout.linkSize(new Component[]{this.jLabelNtaxa, this.jLabelNtaxaTotal}, 1);
        jPanelTotalsLayout.setVerticalGroup((GroupLayout.Group)jPanelTotalsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelTotalsLayout.createSequentialGroup().add((Component)this.jLabelNtaxa, -2, 16, -2).addPreferredGap(0).add((Component)this.jLabelNtaxaTotal, -2, 13, -2).addPreferredGap(0).add((Component)this.jSeparator3, -2, 10, -2).add(0, 28, Short.MAX_VALUE)));
        jPanelTotalsLayout.linkSize(new Component[]{this.jLabelNtaxa, this.jLabelNtaxaTotal}, 2);
        this.jToolBarOccUndo.setFloatable(false);
        this.jToolBarOccUndo.setRollover(true);
        this.jButtonOccUndo.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_Undo.png")));
        this.jButtonOccUndo.setFocusable(false);
        this.jButtonOccUndo.setHorizontalTextPosition(0);
        this.jButtonOccUndo.setVerticalTextPosition(3);
        this.jButtonOccUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonOccUndoActionPerformed(evt);
            }
        });
        this.jToolBarOccUndo.add(this.jButtonOccUndo);
        this.jButtonOccRedo.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_Redo.png")));
        this.jButtonOccRedo.setFocusable(false);
        this.jButtonOccRedo.setHorizontalTextPosition(0);
        this.jButtonOccRedo.setVerticalTextPosition(3);
        this.jButtonOccRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonOccRedoActionPerformed(evt);
            }
        });
        this.jToolBarOccUndo.add(this.jButtonOccRedo);
        this.jButtonOccInsertPrev.setText("Insert previous");
        this.jButtonOccInsertPrev.setToolTipText("Add all taxa from previous analysis as unsaved occurrences");
        this.jButtonOccInsertPrev.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonOccInsertPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWell.this.jButtonOccInsertPrevActionPerformed(evt);
            }
        });
        GroupLayout jPanelOccurencesLayout = new GroupLayout((Container)this.jPanelOccurences);
        this.jPanelOccurences.setLayout((LayoutManager)jPanelOccurencesLayout);
        jPanelOccurencesLayout.setHorizontalGroup((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 792, Short.MAX_VALUE).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1, false).add((Component)this.jTextFieldAnalyst).add((Component)this.jTextFieldDiscipline, -1, 69, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jLabel3, -2, 41, -2).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((Component)this.jButtonPrevious).add(1, 1, 1).add((Component)this.jButtonNext, -2, 78, -2)).add((Component)this.jTextFieldSample, -2, 152, -2)).addPreferredGap(1).add((Component)this.jCheckBoxBarren).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1, false).add((Component)this.jToolBarOccUndo, -2, -1, -2).add((Component)this.jButtonOccEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteOccurences, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOccEvent, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOccComment, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOccInsertPrev, -1, -1, Short.MAX_VALUE).add((Component)this.jPanelTotals, -2, 0, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jSplitPane1))).addContainerGap()));
        jPanelOccurencesLayout.setVerticalGroup((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(3).add((Component)this.jTextFieldDiscipline, -2, 20, -2).add((Component)this.jTextFieldSample, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jCheckBoxBarren, -2, 23, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldAnalyst, -2, -1, -2).add((Component)this.jButtonPrevious).add((Component)this.jButtonNext)).add(15, 15, 15).add((Component)this.jSeparator1, -2, 8, -2).addPreferredGap(0).add((GroupLayout.Group)jPanelOccurencesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelOccurencesLayout.createSequentialGroup().add((Component)this.jToolBarOccUndo, -2, 25, -2).addPreferredGap(1).add((Component)this.jButtonOccEdit).addPreferredGap(0).add((Component)this.jButtonDeleteOccurences, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonOccEvent).addPreferredGap(0).add((Component)this.jButtonOccComment).addPreferredGap(0).add((Component)this.jButtonOccInsertPrev).addPreferredGap(1).add((Component)this.jPanelTotals, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add((Component)this.jSplitPane1, -1, 525, Short.MAX_VALUE))));
        this.jTabbedPaneSampleData.addTab("Occurrences", new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/FrameSamples_OccTab.png")), this.jPanelOccurences);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPaneSampleData, -1, 817, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTabbedPaneSampleData, -1, 647, Short.MAX_VALUE));
    }

    private void jButtonAddSampleActionPerformed(ActionEvent evt) {
        DialogSample dialog = new DialogSample(this.parent, true, this.sbdb, this.well, this.units, null, true);
        dialog.setVisible(true);
        if (dialog.isOK) {
            try {
                dialog.sample.addObserver((Observer)this);
                this.setSelectedSample(dialog.sample);
                if (dialog.addAnalysis) {
                    AnalystHeader hdr;
                    if (this.well.getAnalystHeaders().size() == 1) {
                        hdr = (AnalystHeader)this.well.getAnalystHeaders().get(0);
                    } else {
                        DialogAnalystHeaders dialogAnalystHeaders = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, true);
                        dialogAnalystHeaders.setLocationRelativeTo(this.parent);
                        dialogAnalystHeaders.setVisible(true);
                        hdr = dialogAnalystHeaders.selection;
                    }
                    if (hdr != null) {
                        Smpdtl smpdtl = dialog.sample.addDtl(this.well.getWellID(), hdr, Smpdtl.AnalysisType.PREPARED, "", "", "", 0.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0);
                        this.sbdb.commit();
                        this.well.setDataChanged();
                        this.well.notifyObservers(Smpdtl.class);
                        this.setSmpdtl(smpdtl);
                    }
                }
            }
            catch (Exception e) {
                SB.showStackError((String)"Error adding sample: ", (Exception)e);
                e.printStackTrace();
            }
        }
    }

    private void jButtonEditSampleActionPerformed(ActionEvent evt) {
        if (this.jTableSamples.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one sample to edit", this.parent.getTitle(), 1);
            return;
        }
        try {
            Sample sample = this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(this.jTableSamples.getSelectedRow()));
            DialogSample dialog = new DialogSample(this.parent, true, this.sbdb, this.well, this.units, sample, false);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.jTableSamples.clearSelection();
                this.tableSorterSamples.fireTableDataChanged();
                int index = this.tableSorterSamples.getIndexOf(this.tableModelSamples.getSamples().indexOf(dialog.sample));
                if (index >= 0) {
                    this.jTableSamples.getSelectionModel().setSelectionInterval(index, index);
                }
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void jButtonDeleteSamplesActionPerformed(ActionEvent evt) {
        int[] selected = this.jTableSamples.getSelectedRows();
        if (selected.length == 0) {
            JOptionPane.showMessageDialog(this.parent, "No samples selected", this.parent.getTitle(), 1);
            return;
        }
        LinkedList<Sample> samples = new LinkedList<Sample>();
        try {
            for (int i : selected) {
                samples.add((Sample)this.well.getSamples().get(this.tableSorterSamples.getIndexOf(i)));
            }
            for (Sample sample : samples) {
                int dType = this.well.hasSampleIGD(sample);
                if (dType == 0) continue;
                String msg = "Can't delete sample '" + sample.toString(this.units) + "' because of associated interpreted data, which should be deleted first.\nData type: " + SBdb.dTypeNames[dType];
                JOptionPane.showMessageDialog(this.parent, msg, this.parent.getTitle(), 1);
                return;
            }
            if (samples.size() > 0) {
                String msg = "Really delete " + (samples.size() > 1 ? "these " + samples.size() + " samples?" : "this sample?");
                int analyses = 0;
                for (Sample s : samples) {
                    analyses += s.getAnalyses().size();
                }
                if (analyses > 0) {
                    msg = msg + "\n" + analyses + (analyses == 1 ? " analysis" : " analyses") + " will also be deleted.";
                }
                if (JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0, 3) != 0) {
                    return;
                }
                for (Sample sample : samples) {
                    this.well.deleteSample(sample);
                }
                this.well.setDataChanged();
                this.well.notifyObservers(samples.get(0));
                this.sbdb.commit();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void jTableSamplesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            Sample sample;
            int col = this.jTableSamples.getColumnModel().getColumn(this.jTableSamples.getSelectedColumn()).getModelIndex();
            int row = this.jTableSamples.getSelectedRow();
            try {
                sample = this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(row));
            }
            catch (Exception e) {
                SB.showStackError((String)"Error", (Exception)e);
                return;
            }
            if (col == 10 && sample != null) {
                try {
                    DialogSampleLithology dialog = new DialogSampleLithology(this.parent, true, this.sbdb, this.well, sample);
                    dialog.setLocationRelativeTo(this.jScrollPaneSamples);
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        this.tableSorterSamples.fireTableDataChanged();
                    }
                }
                catch (Exception e) {
                    SB.showStackError((String)"Error", (Exception)e);
                }
            } else if (col == 9 && sample != null) {
                try {
                    WellInterp wellInterp = this.getInterp();
                    if (wellInterp == null) {
                        JOptionPane.showMessageDialog(this.parent, "Select a version", this.parent.getTitle(), 1);
                        return;
                    }
                    DialogSampleAge dialogSA = new DialogSampleAge(this.parent, true, this.well, sample, wellInterp.getHeader().getInterpID());
                    dialogSA.setLocationRelativeTo(this.parent);
                    dialogSA.setVisible(true);
                    if (dialogSA.isOK) {
                        this.tableSorterSamples.fireTableDataChanged();
                    }
                }
                catch (Exception e) {
                    SB.showStackError((String)"Error", (Exception)e);
                }
            } else if (col == 5 && sample != null) {
                if (sample.getAnalyses().isEmpty()) {
                    this.jButtonAddSmpdtlActionPerformed(null);
                    if (sample.getAnalyses().isEmpty()) {
                        return;
                    }
                } else {
                    List<Smpdtl> smpdtls = this.tableModelAnalyses.getSmpdtls();
                    boolean first = true;
                    int i = 0;
                    for (Smpdtl dtl : smpdtls) {
                        if (dtl.getSample() == sample) {
                            int index = this.tableSorterAnalyses.getIndexOf(i);
                            if (first) {
                                this.jTableAnalyses.setRowSelectionInterval(index, index);
                                first = false;
                            } else {
                                this.jTableAnalyses.addRowSelectionInterval(index, index);
                            }
                        }
                        ++i;
                    }
                }
                this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelAnalyses);
            } else {
                this.jButtonEditSampleActionPerformed(null);
            }
        }
    }

    private void jButtonAddSampleSmpdtlActionPerformed(ActionEvent evt) {
        if (this.addAnalysis(true)) {
            this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelAnalyses);
        }
    }

    private void jTableAnalysesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.showOccurrences();
            this.updateOverlay();
        }
    }

    private void jComboBoxDisciplineActionPerformed(ActionEvent evt) {
        Object o = this.jComboBoxDiscipline.getSelectedItem();
        Discipline d = o instanceof Discipline ? (Discipline)o : null;
        if (d != this.discID) {
            this.discID = d;
            this.refreshAnalyses();
        }
    }

    private void jComboBoxAnalystActionPerformed(ActionEvent evt) {
        String tempAnalyst = (String)this.jComboBoxAnalyst.getSelectedItem();
        if (tempAnalyst.equals(ALL_STRING)) {
            tempAnalyst = "";
        }
        if (tempAnalyst != null && !tempAnalyst.equals(this.analystString)) {
            try {
                this.analystString = tempAnalyst;
                this.refreshAnalyses();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "Error getting analyst", this.parent.getTitle(), 0);
            }
        }
    }

    private void jButtonAnalystHeaderActionPerformed(ActionEvent evt) {
        try {
            DialogAnalystHeaders dialog = new DialogAnalystHeaders(this.parent, true, this.sbdb, this.well, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error creating dialog", (Exception)e);
        }
    }

    private void jButtonAddSmpdtlActionPerformed(ActionEvent evt) {
        this.addAnalysis(false);
    }

    private void jButtonEditSmpdtlActionPerformed(ActionEvent evt) {
        this.editAnalysis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteSmpdtlActionPerformed(ActionEvent evt) {
        int[] selection;
        if (this.jTableAnalyses.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parent, "Select one or more analyses from the list", this.parent.getTitle(), 1);
            return;
        }
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        for (int i : selection = this.jTableAnalyses.getSelectedRows()) {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(i));
            smpdtls.add(smpdtl);
        }
        try {
            String msg = "Really delete " + (smpdtls.size() == 1 ? "this analysis?" : "these " + smpdtls.size() + " analyses?");
            int nImageSets = 0;
            int nImages = 0;
            for (Smpdtl dtl : smpdtls) {
                for (TaxonOcc occ : dtl.getOccurUnsorted()) {
                    ImageSet set = occ.getImageSet();
                    if (set == null || set.getSize() == 0) continue;
                    ++nImageSets;
                    nImages += set.getSize();
                }
            }
            if (nImageSets > 0) {
                msg = msg + "\n" + nImageSets + " image set" + (nImageSets > 1 ? "s (" : " (") + nImages + " image" + (nImages > 1 ? "s)" : ")") + " will also be deleted.";
            }
            if (JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0, 3) != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            Sample lastSample = null;
            for (Smpdtl smpdtl : smpdtls) {
                Sample sample = this.well.getSample(smpdtl.getSample().getSampID());
                sample.deleteDtl(this.well.getWellID(), smpdtl.getHeader().getAnalyID(), smpdtl);
                this.sbdb.commit();
                lastSample = sample;
            }
            lastSample.notifyObservers();
            this.jTableAnalyses.clearSelection();
            this.refreshAnalyses();
            this.well.setDataChanged();
            this.well.notifyObservers(Smpdtl.class);
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQLError", (SQLException)ex);
            this.sbdb.doRollback();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jComboBoxAnalysisNumberActionPerformed(ActionEvent evt) {
        int tempNo = 0;
        try {
            tempNo = (Integer)this.jComboBoxAnalysisNumber.getSelectedItem();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tempNo != this.analyNo) {
            try {
                this.analyNo = tempNo;
                this.refreshAnalyses();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "Error getting analyst", this.parent.getTitle(), 0);
            }
        }
    }

    private void jTextFieldSampleFocusGained(FocusEvent evt) {
        this.jTextFieldSample.setSelectionStart(0);
        this.jTextFieldSample.setSelectionEnd(this.jTextFieldSample.getText().length());
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        try {
            this.nextOcc(true);
        }
        catch (SBException se) {
            JOptionPane.showMessageDialog(this.parent, se.getMessage(), this.parent.getTitle(), 2);
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        try {
            this.nextOcc(false);
        }
        catch (SBException se) {
            JOptionPane.showMessageDialog(this.parent, se.getMessage(), this.parent.getTitle(), 2);
        }
    }

    void nextOcc(boolean forward) throws SBException {
        this.stopCellEditor();
        int selectedRow = this.jTableAnalyses.getSelectedRow();
        if (selectedRow < 0) {
            throw new SBException("Make a selection from list of Analyses");
        }
        selectedRow = forward ? ++selectedRow : --selectedRow;
        try {
            this.tableSorterAnalyses.getIndexOf(selectedRow);
        }
        catch (Exception e) {
            throw new SBException("There is no " + (forward ? "next" : "previous") + " sample in selected data set");
        }
        this.jTableAnalyses.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        if (!this.showOccurrences()) {
            if (forward) {
                this.jTableAnalyses.getSelectionModel().setSelectionInterval(--selectedRow, selectedRow);
            } else {
                this.jTableAnalyses.getSelectionModel().setSelectionInterval(++selectedRow, selectedRow);
            }
        }
        this.updateComments();
        this.updateOverlay();
        this.updateTotals();
        for (JPanelPicklist picklist : this.parent.getPicklists()) {
            picklist.restorePicklist();
        }
    }

    private void jCheckBoxBarrenActionPerformed(ActionEvent evt) {
        Smpdtl smpdtl = this.tableModelOcc.smpdtl;
        if (this.jCheckBoxBarren.isSelected() != smpdtl.getBarren()) {
            if (!smpdtl.getBarren() && smpdtl.getOccur().size() > 0 && JOptionPane.showConfirmDialog(this.parent, "Clear occurrences?", this.parent.getTitle(), 0, 3) != 0) {
                this.jCheckBoxBarren.setSelected(false);
                return;
            }
            try {
                AbstractUndoableEdit e = smpdtl.setBarren(this.well.getWellID(), this.jCheckBoxBarren.isSelected());
                if (e != null) {
                    this.undoSupportOccs.postEdit(e);
                }
                smpdtl.notifyObservers();
                this.sbdb.commit();
            }
            catch (Exception ex) {
                SB.showStackError((String)"Error setting barren flag", (Exception)ex);
                this.sbdb.doRollback();
            }
        }
    }

    private void jButtonDeleteOccurencesActionPerformed(ActionEvent evt) {
        int[] selection;
        this.stopCellEditor();
        if (this.jTableOccurrences.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.parent, "No occurrences selected.", this.parent.getTitle(), 2);
            return;
        }
        for (int i : selection = this.jTableOccurrences.getSelectedRows()) {
            if (this.tableModelOcc.getSaved(this.tableSorterOcc.getIndexOf(i))) continue;
            this.getToolkit().beep();
            return;
        }
        Smpdtl smpdtl = this.tableModelOcc.smpdtl;
        String msg = "Really delete " + (selection.length > 1 ? "these " + selection.length + " " : "this ") + "occurrence" + (selection.length > 1 ? "s?" : "?");
        int nImageSets = 0;
        int nImages = 0;
        try {
            int opt;
            for (int i : selection) {
                ImageSet set = ((TaxonOcc)smpdtl.getOccur().get(this.tableSorterOcc.getIndexOf(i))).getImageSet();
                if (set == null || set.getSize() == 0) continue;
                ++nImageSets;
                nImages += set.getSize();
            }
            if (nImageSets > 0) {
                msg = msg + "\n" + nImageSets + " image set" + (nImageSets > 1 ? "s (" : " (") + nImages + " image" + (nImages > 1 ? "s)" : ")") + " will also be deleted.";
                msg = msg + "\nImage sets may not be restored by undo actions.";
            }
            if ((opt = JOptionPane.showConfirmDialog(this.parent, msg, this.parent.getTitle(), 0, 3)) != 0) {
                return;
            }
            LinkedList toDelete = new LinkedList();
            for (int i : selection) {
                toDelete.add(smpdtl.getOccur().get(this.tableSorterOcc.getIndexOf(i)));
            }
            this.undoSupportOccs.postEdit(smpdtl.deleteOccs(this.well.getWellID(), toDelete));
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQLError", (SQLException)ex);
            this.sbdb.doRollback();
        }
        catch (SBPrivilegeException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.getMessage(), this.parent.getTitle(), 2);
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error", (Exception)((Object)ex));
            this.sbdb.doRollback();
        }
        this.jTableOccurrences.clearSelection();
        smpdtl.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOccEventActionPerformed(ActionEvent evt) {
        this.stopCellEditor();
        if (this.jTableOccurrences.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.parent, "Select an occurrence to create a well event from", this.parent.getTitle(), 1);
            return;
        }
        int selection = this.jTableOccurrences.getSelectedRow();
        if (!this.tableModelOcc.getSaved(this.tableSorterOcc.getIndexOf(selection))) {
            JOptionPane.showMessageDialog(this.parent, "Cannot create event for unsaved occurrence", this.parent.getTitle(), 1);
            return;
        }
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this.parent, "Select a version", this.parent.getTitle(), 1);
            return;
        }
        if (selection < 0) {
            JOptionPane.showMessageDialog(this.parent, "Select an occurrence", this.parent.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
            if (smpdtl != null) {
                SBEvent event;
                Taxon taxon = ((TaxonOcc)smpdtl.getOccurUnsorted().get(this.tableSorterOcc.getIndexOf(selection))).getTaxon();
                List list = this.sbdb.getSBEvents(taxon.getSpecID());
                if (list == null || list.isEmpty()) {
                    int opt = JOptionPane.showConfirmDialog(this.parent, "There are no events available in the event dictionary for selected taxon.\nDo you want to add it to the dictionary?", this.parent.getTitle(), 0, 3);
                    if (opt != 0) {
                        return;
                    }
                    DialogEvent dialogEvent = new DialogEvent(this.parent, true, this.sbdb, null, null);
                    dialogEvent.setTaxon(taxon);
                    dialogEvent.setLocation(this.jButtonOccEvent.getLocationOnScreen());
                    dialogEvent.setVisible(true);
                    if (dialogEvent.sbEvent == null) {
                        return;
                    }
                    event = dialogEvent.sbEvent;
                } else {
                    DialogSelectEvent dialog = new DialogSelectEvent((Frame)this.parent, true, this.sbdb, list);
                    dialog.setLocation(this.jButtonOccEvent.getLocationOnScreen());
                    dialog.setVisible(true);
                    if (dialog.selection == null) {
                        return;
                    }
                    event = dialog.selection;
                }
                DialogWellEvent dialog = new DialogWellEvent(this.parent, true, this.sbdb, this.well, wellInterp, this.units, null, smpdtl.getSample(), event, null);
                dialog.setSmpdtl(smpdtl.getDiscID(), smpdtl.getAnalyst());
                dialog.setLocation(this.jButtonOccEvent.getLocationOnScreen());
                dialog.setVisible(true);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening dialog", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTableOccurrencesMouseClicked(MouseEvent evt) {
        block27: {
            if (this.parent.isMultiClick() && evt.getClickCount() > 1 || !this.parent.isMultiClick() && evt.getClickCount() == 2) {
                try {
                    int selectedRow = this.jTableOccurrences.getSelectedRow();
                    if (selectedRow < 0) {
                        return;
                    }
                    Object o = this.tableModelOcc.getOcc(this.tableSorterOcc.getIndexOf(selectedRow));
                    if (o == null) break block27;
                    boolean saved = true;
                    if (!this.tableModelOcc.getSaved(this.tableSorterOcc.getIndexOf(selectedRow))) {
                        if (evt.getButton() != 1) {
                            this.getToolkit().beep();
                            return;
                        }
                        saved = false;
                    }
                    if (this.parent.getLogging()) {
                        TaxonOcc newFss = null;
                        if (this.parent.isNumeric()) {
                            int total;
                            if (this.parent.getPicklistTotaliser() > 0 && (total = this.tableModelOcc.smpdtl.getTotalCount()) >= this.parent.getPicklistTotaliser()) {
                                this.getToolkit().beep();
                                if (JPanelPicklist.getSampleTotalMessage()) {
                                    JOptionPane.showMessageDialog(this, "Total count reached", "Samples", 1);
                                    JPanelPicklist.setSampleTotalMessage();
                                }
                                return;
                            }
                            int sizeFraction = 0;
                            if (!saved) {
                                TaxonOcc.Builder occBuilder = (TaxonOcc.Builder)o;
                                this.tableModelOcc.unsaved.remove(occBuilder);
                                occBuilder.count(1);
                                Smpdtl.OccAddDelete edit = this.tableModelOcc.smpdtl.insertOccurrence(occBuilder, this.well.getWellID());
                                newFss = edit.getOccurrence();
                                this.undoSupportOccs.postEdit((UndoableEdit)edit);
                            } else {
                                TaxonOcc fss = (TaxonOcc)o;
                                if (evt.getButton() != 1 && (fss.getSubAbund(true).equals("+") || sizeFraction == 0 && fss.getMedium() == 0)) {
                                    this.getToolkit().beep();
                                    return;
                                }
                                this.undoSupportOccs.postEdit(this.tableModelOcc.smpdtl.incrementOcc(this.well.getWellID(), this.tableModelOcc.smpdtl.getSample().getSampID(), fss, sizeFraction, evt.getButton() == 1 ? 1 : -1, true));
                            }
                        } else if (!saved) {
                            this.tableModelOcc.unsaved.remove((TaxonOcc.Builder)o);
                            Smpdtl.OccAddDelete addition = this.tableModelOcc.smpdtl.insertOccurrence((TaxonOcc.Builder)o, this.well.getWellID());
                            this.undoSupportOccs.postEdit((UndoableEdit)addition);
                            newFss = addition.getOccurrence();
                            int select = this.tableSorterOcc.getIndexOf(this.tableModelOcc.smpdtl.getOccur().indexOf(newFss));
                            this.jTableOccurrences.setRowSelectionInterval(select, select);
                        } else {
                            TaxonOcc fss = (TaxonOcc)o;
                            if (this.tableModelOcc.smpdtl.getHeader().getAbnSchID() <= 0) {
                                JOptionPane.showMessageDialog(this.parent, "You must set an abundance scheme for this analyst suite\nbefore recording semi-quantitative data.", "Edit abundance", 2);
                                return;
                            }
                            AbnScheme sch = this.sbdb.getAbnScheme(this.tableModelOcc.smpdtl.getHeader().getAbnSchID(), true);
                            if (fss.getTotalCount() > 0 && JOptionPane.showConfirmDialog(this.parent, "You can't mix semi-quantitative and quantitative abundance.\nDelete quantitative data?", "Edit abundance", 0) != 0) {
                                return;
                            }
                            if (evt.getButton() != 1 && (fss.getSubAbund().isEmpty() || fss.getSubAbund(true).equals("+"))) {
                                this.getToolkit().beep();
                                return;
                            }
                            if (evt.getButton() == 1 && fss.getSubAbund().equals(sch.getEntry(sch.getNClasses() - 1))) {
                                this.getToolkit().beep();
                                return;
                            }
                            this.undoSupportOccs.postEdit(this.tableModelOcc.smpdtl.incrementOcc(this.well.getWellID(), this.tableModelOcc.smpdtl.getSample().getSampID(), fss, 0, evt.getButton() == 1 ? 1 : -1, false));
                        }
                        this.sbdb.commit();
                        this.tableModelOcc.smpdtl.notifyObservers();
                        this.tableSorterOcc.sort((Object)this);
                        if (!saved && newFss != null) {
                            int select = this.tableSorterOcc.getRowOf(this.tableModelOcc.smpdtl.getOccur().indexOf(newFss));
                            this.jTableOccurrences.setRowSelectionInterval(select, select);
                        } else {
                            int select = this.tableSorterOcc.getRowOf(this.tableModelOcc.smpdtl.getOccur().indexOf((TaxonOcc)o));
                            this.jTableOccurrences.setRowSelectionInterval(select, select);
                        }
                        if (this.parent.playOccSounds()) {
                            this.parent.playOccSound();
                        }
                        break block27;
                    }
                    if (!saved) {
                        System.out.println("Didn't edit unsaved occ");
                        break block27;
                    }
                    this.editOccurrence((TaxonOcc)o);
                }
                catch (SQLException ex) {
                    SB.showStackError((String)"SQL Error", (SQLException)ex);
                    this.sbdb.doRollback();
                }
                catch (Exception ex) {
                    SB.showStackError((String)"SQL Error", (Exception)ex);
                    this.sbdb.doRollback();
                }
            } else if (!(evt.isShiftDown() || evt.isControlDown() || evt.isMetaDown())) {
                this.jTableOccurrences.changeSelection(this.jTableOccurrences.getSelectedRow(), this.jTableOccurrences.getSelectedColumn(), false, false);
            }
        }
    }

    private void editOccurrence(TaxonOcc fss) throws SQLException, SBException {
        this.stopCellEditor();
        DialogOccurrence dialog = new DialogOccurrence(this.parent, true, this.sbdb, this.well, this.tableModelOcc.smpdtl, fss, null, false, false, false, false, this.parent.isCMF());
        dialog.setLocationRelativeTo(this.jScrollPaneOccurences);
        dialog.undoSupport.addUndoableEditListener(this.undoManagerOccs);
        dialog.setVisible(true);
    }

    private void jTabbedPaneSampleDataMouseClicked(MouseEvent evt) {
        if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences) {
            if (!this.showOccurrences()) {
                this.jTabbedPaneSampleData.setSelectedComponent(this.jPanelAnalyses);
            }
            this.updateOverlay();
        }
    }

    private void jTabbedPaneSampleDataStateChanged(ChangeEvent evt) {
        if (!this.parent.parent.checkRLMlicence()) {
            JOptionPane.showMessageDialog(this.parent, "StrataBugs licence no longer available.", "StrataBugs", 0);
            this.parent.exit(false);
            return;
        }
        this.stopCellEditor();
        if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelCharts) {
            this.jPanelCharts.stateChanged();
            if (this.parent.getWellPanel().getInterp() == null) {
                // empty if block
            }
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        if (this.units != 'M') {
            this.setUnits('M');
        }
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        if (this.units != 'F') {
            this.setUnits('F');
        }
    }

    private void jButtonOccEditActionPerformed(ActionEvent evt) {
        try {
            int selectedRow = this.jTableOccurrences.getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            if (!this.tableModelOcc.getSaved(this.tableSorterOcc.getIndexOf(selectedRow))) {
                this.getToolkit().beep();
                return;
            }
            TaxonOcc fss = (TaxonOcc)this.tableModelOcc.smpdtl.getOccur().get(this.tableSorterOcc.getIndexOf(selectedRow));
            if (fss != null) {
                this.editOccurrence(fss);
            }
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQL Error", (SQLException)ex);
            this.sbdb.doRollback();
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
            this.sbdb.doRollback();
        }
    }

    private void jTableSamplesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteSamplesActionPerformed(null);
        }
    }

    private void jTableAnalysesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteSmpdtlActionPerformed(null);
        }
    }

    private void jTableOccurrencesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteOccurencesActionPerformed(null);
        }
    }

    private void jButtonOccCommentActionPerformed(ActionEvent evt) {
        this.editBiocomOcc(true);
    }

    private void editBiocomOcc(boolean useSelection) {
        this.stopCellEditor();
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this.parent, "No version selected", this.parent.getTitle(), 1);
            return;
        }
        if (this.jTableAnalyses.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No analysis selected!", this.parent.getTitle(), 2);
            return;
        }
        try {
            Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(this.jTableAnalyses.getSelectedRow()));
            if (smpdtl != null) {
                DialogBiocom dialog;
                if (this.sbdb.restrictedToDiscID(smpdtl.getDiscID())) {
                    throw new SBPrivilegeException("You can only add/edit data within " + this.sbdb.getUser().getDiscipline());
                }
                Iterator it = wellInterp.getComments().iterator();
                Biocom comment = null;
                while (it.hasNext()) {
                    Biocom b = (Biocom)it.next();
                    if (b.getTopSample() != smpdtl.getSample() || b.getAnalyst() != smpdtl.getHeader().getAnalystUsrid() || b.getDiscID() != smpdtl.getHeader().getDiscID()) continue;
                    comment = b;
                    break;
                }
                if (comment != null) {
                    dialog = new DialogBiocom(this.parent, true, this.sbdb, this.well, wellInterp, this.units, comment, null, null);
                } else {
                    dialog = new DialogBiocom(this.parent, true, this.sbdb, this.well, wellInterp, this.units, null, smpdtl.getSample(), null);
                    dialog.setAnalyst(smpdtl.getAnalyst());
                    dialog.setDiscipline(Discipline.getDisc((char)smpdtl.getDiscID()));
                }
                dialog.undoSupport.addUndoableEditListener(this.undoManagerOccs);
                if (useSelection) {
                    boolean abr = this.parent.isAbrBiocom();
                    String text = "";
                    int[] selection = this.jTableOccurrences.getSelectedRows();
                    for (int i = 0; i < selection.length; ++i) {
                        if (!this.tableModelOcc.getSaved(this.tableSorterOcc.getIndexOf(selection[i]))) continue;
                        Taxon taxon = ((TaxonOcc)smpdtl.getOccur().get(this.tableSorterOcc.getIndexOf(selection[i]))).getTaxon();
                        if (text.length() > 0) {
                            text = text + ", ";
                        }
                        text = text + taxon.toGenString(abr, false);
                    }
                    dialog.addText(text);
                }
                dialog.setLocation(this.jButtonOccComment.getLocationOnScreen());
                dialog.setVisible(true);
                if (dialog.isOK() && useSelection) {
                    this.jTableOccurrences.clearSelection();
                }
                this.updateComments();
            }
        }
        catch (SBPrivilegeException e) {
            JOptionPane.showMessageDialog(this.parent, e.getMessage(), this.parent.getTitle(), 2);
            e.printStackTrace();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error opening dialog", (Exception)e);
        }
    }

    private void jTextAreaCommentsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1 && this.jTextAreaComments.getText().equals(DEFAULT_COMMENT_TEXT)) {
            this.stopCellEditor();
            this.editBiocomOcc(true);
        }
    }

    private void jTextAreaCommentsFocusLost(FocusEvent evt) {
        String comment = this.jTextAreaComments.getText().trim();
        if (!comment.equals(DEFAULT_COMMENT_TEXT)) {
            if (this.biocom != null) {
                if (this.sbdb.restrictedToDiscID(this.biocom.getDiscID())) {
                    JOptionPane.showMessageDialog(this.parent, "You can only add/edit data within " + this.sbdb.getUser().getDiscipline());
                    return;
                }
                if (!this.biocom.getText().equals(comment)) {
                    try {
                        if (comment.isEmpty()) {
                            this.undoSupportOccs.postEdit((UndoableEdit)this.getInterp().deleteBiocom(this.biocom, this.well.getWellID()));
                            this.biocom = null;
                        } else {
                            Biocom.Builder builder = new Biocom.Builder(this.sbdb, this.biocom.getDiscipline(), this.biocom.getAnalyst(), this.biocom.getTopSample(), comment);
                            WellInterp.BiocomEdit edit = this.getInterp().updateBiocom(this.biocom, builder, this.well.getWellID());
                            this.biocom = edit.getBiocom();
                            this.getInterp().notifyObservers((Object)this.biocom);
                            this.undoSupportOccs.postEdit((UndoableEdit)edit);
                        }
                        this.sbdb.commit();
                    }
                    catch (Exception ex) {
                        System.out.println("SQL: " + SB.sql);
                        SB.showStackError((String)ex.getMessage(), (Exception)ex);
                        this.sbdb.doRollback();
                    }
                }
            } else {
                System.out.println("Biocom null in focus lost!");
            }
        }
    }

    private void jButtonShowAllActionPerformed(ActionEvent evt) {
        this.jComboBoxDiscipline.setSelectedIndex(0);
        this.jComboBoxAnalyst.setSelectedIndex(0);
        this.jComboBoxAnalysisNumber.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsAnalysesActionPerformed(ActionEvent evt) {
        try {
            File file;
            int opt;
            LinkedList<Smpdtl> selection = null;
            if (this.jTableAnalyses.getSelectedRowCount() > 0 && (opt = JOptionPane.showConfirmDialog(this, "Restrict output to the selected " + this.jTableAnalyses.getSelectedRowCount() + " analyses only?", this.parent.getTitle(), 0, 3)) == 0) {
                selection = new LinkedList();
                int[] selected = this.jTableAnalyses.getSelectedRows();
                for (int i = 0; i < selected.length; ++i) {
                    selection.add(this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(selected[i])));
                }
            }
            if (selection == null) {
                selection = new LinkedList<Smpdtl>();
                for (int i = 0; i < this.jTableAnalyses.getRowCount(); ++i) {
                    selection.add(this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(i)));
                }
            }
            if (selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No analyses to export", this.parent.getTitle(), 2);
                return;
            }
            String pref = "";
            try {
                pref = Lastval.getString((SBdb)this.sbdb, (String)"SMPDTLTYPE");
            }
            catch (Exception e) {
                // empty catch block
            }
            String[] extensions = new String[]{"csv", "zip"};
            String[] descriptions = new String[]{"CSV", "StrataBugs XML/ZIP"};
            if (!pref.isEmpty() && pref.equals("csv")) {
                extensions[0] = "zip";
                extensions[1] = "csv";
                descriptions[0] = "StrataBugs XML/ZIP";
                descriptions[1] = "CSV";
            }
            if ((file = FrameJsbugs.chooseFile(this.sbdb, this, "WINSMPDTL", "UNXSMPDTL", extensions, descriptions, null)) == null) {
                return;
            }
            String extension = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            if (extension.equalsIgnoreCase("csv")) {
                Lastval.putString((SBdb)this.sbdb, (String)"SMPDTLTYPE", (String)"csv");
                DialogCSVExport dialog = new DialogCSVExport(this.parent, true, this.sbdb, selection, this.well, this.units, Discipline.getChar((Discipline)this.discID), this.sbdb.getUserID(this.analystString), this.analyNo, file.getPath());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            } else {
                Lastval.putString((SBdb)this.sbdb, (String)"SMPDTLTYPE", (String)"zip");
                this.exportSmpdtlXML(file, selection);
                JOptionPane.showMessageDialog(this, "File written.", this.parent.getTitle(), 1);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error writing file", (Exception)e);
            this.sbdb.doRollback();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void jButtonSaveSamplesActionPerformed(ActionEvent evt) {
        LinkedList<Sample> selection = null;
        try {
            int opt;
            if (this.jTableSamples.getSelectedRowCount() > 0 && (opt = JOptionPane.showConfirmDialog(this, "Restrict output to the selected " + this.jTableSamples.getSelectedRowCount() + " samples only?", this.parent.getTitle(), 0, 3)) == 0) {
                selection = new LinkedList();
                int[] selected = this.jTableSamples.getSelectedRows();
                for (int i = 0; i < selected.length; ++i) {
                    selection.add(this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(selected[i])));
                }
            }
            if (selection == null) {
                selection = new LinkedList<Sample>();
                for (int i = 0; i < this.jTableSamples.getRowCount(); ++i) {
                    selection.add(this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(i)));
                }
            }
            if (selection.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No samples to export", this.parent.getTitle(), 2);
                return;
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        File file = FrameJsbugs.chooseFile(this.sbdb, this, "SMPRPRTWIN", "SMPRPRTUNX", new String[]{"csv"}, new String[]{"CSV files"}, null);
        if (file == null) {
            return;
        }
        DialogSampleReport dialog = new DialogSampleReport(this.parent, true, this.well, file.getPath(), this.sbdb, selection);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonOccUndoActionPerformed(ActionEvent evt) {
        this.undoRedoOccs(true);
    }

    private void jButtonOccRedoActionPerformed(ActionEvent evt) {
        this.undoRedoOccs(false);
    }

    private void jButtonOccInsertPrevActionPerformed(ActionEvent evt) {
        int selectedRow = this.jTableAnalyses.getSelectedRow();
        if (selectedRow < 0) {
            JOptionPane.showMessageDialog(this, "No analysis", "Copy", 2);
            return;
        }
        Smpdtl smpdtl = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(selectedRow));
        Smpdtl prevDtl = null;
        while (prevDtl == null && selectedRow > 0) {
            Smpdtl candidate = this.tableModelAnalyses.getSmpdtls().get(this.tableSorterAnalyses.getIndexOf(--selectedRow));
            if (candidate.getHeader() != smpdtl.getHeader() || !candidate.isAnalysed() || candidate.getBarren()) continue;
            prevDtl = candidate;
        }
        if (prevDtl == null) {
            JOptionPane.showMessageDialog(this, "No previous analysis in " + smpdtl.getHeader().getDiscipline().getAbr(true) + " suite '" + smpdtl.getHeader() + "'", "copy", 2);
            return;
        }
        ArrayList<Taxon> list = new ArrayList<Taxon>();
        for (TaxonOcc occ : prevDtl.getOccur()) {
            list.add(occ.getTaxon());
        }
        this.doSampleCopy(prevDtl, smpdtl, 3, false, false, list);
    }

    private void undoRedoOccs(boolean undo) {
        this.stopCellEditor();
        if (undo && this.undoManagerOccs.canUndo() || !undo && this.undoManagerOccs.canRedo()) {
            if (undo) {
                this.undoManagerOccs.undo();
            } else {
                this.undoManagerOccs.redo();
            }
            this.tableModelOcc.fireTableDataChanged();
            this.tableModelOcc.smpdtl.notifyObservers();
            this.setUndoTooltips();
        } else {
            this.getToolkit().beep();
        }
    }

    private void setUndoTooltips() {
        this.jButtonOccUndo.setToolTipText(this.undoManagerOccs.getUndoPresentationName());
        this.jButtonOccRedo.setToolTipText(this.undoManagerOccs.getRedoPresentationName());
    }

    private void exportSmpdtlXML(File file, List<Smpdtl> dtls) throws SQLException, SBException {
        SBdb ws = new SBdb(this.sbdb);
        WsWell wsWell = new WsWell(ws, this.well);
        ws.getProject(0).addWell(ws, (Well)wsWell);
        wsWell.fillAnalyses(dtls);
        LinkedList<File> files = new LinkedList<File>();
        try {
            String rootName;
            LinkedList<Integer> dTypes = new LinkedList<Integer>();
            dTypes.add(6);
            dTypes.add(2);
            dTypes.add(4);
            dTypes.add(8);
            if (!file.getName().toLowerCase().endsWith("zip")) {
                rootName = file.getName();
                file = new File(file.getPath() + ".zip");
            } else {
                rootName = file.getName().substring(0, file.getName().length() - 4);
            }
            File tempXML = new File(rootName + ".xml");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempXML), "UTF8"));
            ws.writeXML(out, dTypes, this.sbdb, files);
            files.add(tempXML);
            FrameOrganiser.writeZipFile(file, files);
            tempXML.delete();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    Sample getSelectedSample() throws SQLException, SBException {
        Sample sample = null;
        if (this.jTableSamples.getSelectedRowCount() > 0) {
            sample = this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(this.jTableSamples.getSelectedRows()[0]));
        }
        return sample;
    }

    Sample getSelectedTopSample() throws SQLException, SBException {
        if (this.jTableSamples.getSelectedRowCount() > 0) {
            return this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(this.jTableSamples.getSelectedRows()[0]));
        }
        return null;
    }

    Sample getSelectedBaseSample() throws SQLException, SBException {
        if (this.jTableSamples.getSelectedRowCount() > 0) {
            return this.tableModelSamples.getSamples().get(this.tableSorterSamples.getIndexOf(this.jTableSamples.getSelectedRows()[this.jTableSamples.getSelectedRowCount() - 1]));
        }
        return null;
    }

    void clearSampleSelection() {
        this.jTableSamples.clearSelection();
    }

    void setSamplesInterp(WellInterp wellInterp) throws SQLException, SBException {
        this.tableModelSamples.setInterp(this.well, wellInterp, this.sbdb);
        this.jTableSamples.setToolTipText(null);
        this.jTextAreaComments.setToolTipText("Biostratigraphic Comments - " + wellInterp.getHeader().toString());
    }

    void setVersion(WellInterp wellInterp) throws SQLException, SBException {
        this.setSamplesInterp(wellInterp);
        if (this.jPanelCharts != null) {
            this.jPanelCharts.setChartVersion(wellInterp);
        }
        this.parent.setTabVersion(this, wellInterp.getHeader());
    }

    void setVersion(InterpHdr header) throws SQLException, SBException {
        this.jPanelInterpretations.setVersion(header);
    }

    void addZone(int igdType, IGDUnit unit, IGDScheme scheme) {
        this.jPanelInterpretations.addZone(igdType, unit, scheme);
    }

    void addEvent(SBEvent event, SBEvent.EventType evType) {
        this.jPanelInterpretations.addEvent(event, evType);
    }

    void addSQPick(Surface surface) {
        this.jPanelInterpretations.addSQPick(surface);
    }

    void setSelectedSample(Sample sample) throws SQLException, SBException {
        int index = this.tableModelSamples.getSamples().indexOf(sample);
        if (index >= 0) {
            index = this.tableSorterSamples.getIndexOf(index);
            this.jTableSamples.setRowSelectionInterval(index, index);
            this.jTableSamples.scrollRectToVisible(this.jTableSamples.getCellRect(index, 0, true));
        }
    }

    void setSelectedAnalysis(Sample sample, Smpdtl smpdtl) {
        int index;
        if (smpdtl != null && (index = this.tableModelAnalyses.getSmpdtls().indexOf(smpdtl)) >= 0) {
            index = this.tableSorterAnalyses.getIndexOf(index);
            this.jTableAnalyses.setRowSelectionInterval(index, index);
            this.jTableAnalyses.scrollRectToVisible(this.jTableAnalyses.getCellRect(index, 0, true));
            return;
        }
        if (sample != null && (smpdtl = (Smpdtl)sample.getAnalyses().get(sample.getAnalyses().size() - 1)) != null && (index = this.tableModelAnalyses.getSmpdtls().indexOf(smpdtl)) >= 0) {
            index = this.tableSorterAnalyses.getIndexOf(index);
            this.jTableAnalyses.setRowSelectionInterval(index, index);
            this.jTableAnalyses.scrollRectToVisible(this.jTableAnalyses.getCellRect(index, 0, true));
        }
    }

    boolean isOccurrencesTableScroll() {
        return this.jTableOccurrences.getAutoResizeMode() != 4;
    }

    void setOccurrencesTableScroll(boolean scroll) {
        if (scroll) {
            this.jTableOccurrences.setAutoResizeMode(0);
        } else {
            this.jTableOccurrences.setAutoResizeMode(4);
        }
    }

    void setCMF(boolean cMF) {
        Smpdtl smpdtl = this.tableModelOcc.smpdtl;
        this.setSplits(smpdtl);
        this.tableModelOcc.setSplits(this.jTableOccurrences, cMF);
        if (this.jTabbedPaneSampleData.getSelectedComponent() == this.jPanelOccurences) {
            this.tableSorterOcc.fireTableDataChanged();
        }
    }

    void setSmpdtl(Smpdtl smpdtl) {
        this.setSelectedAnalysis(null, smpdtl);
        this.jButtonShowAllActionPerformed(null);
        this.showOccurrences();
        this.updateOverlay();
    }

    JTable getOccTable() {
        return this.jTableOccurrences;
    }

    void removeChart() {
        if (this.chartsFrameDetached != null) {
            this.chartsFrameDetached.setVisible(false);
            this.chartsFrameDetached = null;
        }
    }

    void setSampleLabel() throws SQLException, SBException {
        this.jLabelSamples.setText(this.well.getSamples().size() + " Samples");
    }

    void setSelectedTaxonOcc(TaxonOcc occ) {
        if (occ == null || this.tableModelOcc.smpdtl.getOccur().indexOf(occ) < 0) {
            return;
        }
        int index = this.tableSorterOcc.getIndexOf(this.tableModelOcc.smpdtl.getOccur().indexOf(occ));
        this.jTableOccurrences.getSelectionModel().setSelectionInterval(index, index);
        this.jTableOccurrences.scrollRectToVisible(this.jTableOccurrences.getCellRect(index, 0, true));
    }

    void stopCellEditor() {
        TableCellEditor editor = this.jTableOccurrences.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    void updateTotals() {
        for (int i = this.jPanelTotals.getComponentCount() - 1; i > 2; --i) {
            this.jPanelTotals.remove(i);
        }
        this.totalLabels = new HashMap();
        this.jPanelTotals.setLayout(new GridLayout(0, 1, 0, 3));
        if (this.getSmpdtl() != null) {
            AbnScheme scheme = null;
            try {
                scheme = this.sbdb.getAbnScheme(this.getSmpdtl().getHeader().getAbnSchID(), false);
            }
            catch (SQLException sql) {
                SB.showStackError((String)"Error setting total labels", (SQLException)sql);
            }
            for (TaxonOcc occ : this.getSmpdtl().getOccur()) {
                int count;
                if (this.parent.getTotExRwCv() && (occ.getCaved() || occ.getReworked())) continue;
                String mnem = occ.getTaxon().getCatMnem();
                if (this.totalLabels.get(mnem) == null) {
                    this.totalLabels.put(mnem, new TotalLabel(mnem));
                }
                if ((count = occ.getTotalCount()) > 0) {
                    this.totalLabels.get((Object)mnem).count += count;
                    continue;
                }
                String abn = occ.getSubAbund(true);
                if (scheme != null) {
                    this.totalLabels.get((Object)mnem).abnIndex = Math.max(scheme.getIndex(abn), this.totalLabels.get((Object)mnem).abnIndex);
                    continue;
                }
                this.totalLabels.get((Object)mnem).abnIndex = -1;
            }
            LinkedList<TotalLabel> values = new LinkedList<TotalLabel>(this.totalLabels.values());
            Collections.sort(values);
            for (TotalLabel label : values) {
                label.updateLabel(scheme);
                this.jPanelTotals.add(label.label);
                label.label.setVisible(true);
            }
        }
        this.jPanelTotals.revalidate();
        this.jPanelTotals.repaint();
    }

    void putTableColumnWidths() {
        HashMap<JTable, TableModelSB> tables = new HashMap<JTable, TableModelSB>();
        tables.put(this.jTableOccurrences, this.tableModelOcc);
        tables.put(this.jTableAnalyses, this.tableModelAnalyses);
        tables.put(this.jTableSamples, this.tableModelSamples);
        try {
            for (Map.Entry entry : tables.entrySet()) {
                ((TableModelSB)entry.getValue()).putTableColumnWidths(this.sbdb, (JTable)entry.getKey());
                ((TableModelSB)entry.getValue()).putTableColumnOrder(this.sbdb, (JTable)entry.getKey());
            }
            this.jPanelInterpretations.putTableColumnWidths();
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }

    TableModelSB getSelectedTable() {
        Component c = this.jTabbedPaneSampleData.getSelectedComponent();
        if (c == this.jPanelSamples) {
            return this.tableModelSamples;
        }
        if (c == this.jPanelAnalyses) {
            return this.tableModelAnalyses;
        }
        if (c == this.jPanelOccurences) {
            return this.tableModelOcc;
        }
        if (c instanceof JPanelWellInterp) {
            return ((JPanelWellInterp)c).getSelectedTable();
        }
        return null;
    }

    LinkedList<TablePair> getTablePair(TableModelSB model) {
        LinkedList<TablePair> tables = new LinkedList<TablePair>();
        if (model instanceof TableModelOccurence) {
            tables.add(new TablePair(this.tableModelOcc, this.jTableOccurrences));
        } else if (model instanceof TableModelSamples) {
            tables.add(new TablePair(this.tableModelSamples, this.jTableSamples));
        } else if (model instanceof TableModelAnalyses) {
            tables.add(new TablePair(this.tableModelAnalyses, this.jTableAnalyses));
        } else {
            tables.addAll(this.jPanelInterpretations.getTablePair(model));
        }
        return tables;
    }

    class TotalLabel
    implements Comparable {
        JLabel label;
        int count;
        int abnIndex = -1;

        TotalLabel(String mnem) {
            this.label = new JLabel(mnem);
        }

        void updateLabel(AbnScheme sch) {
            String text = "";
            text = this.count > 0 ? text + this.count : (sch != null && this.abnIndex > -1 ? text + sch.getEntry(this.abnIndex) : "+");
            this.label.setText(this.label.getText() + ": " + text);
        }

        public int compareTo(Object o) {
            return this.label.getText().compareTo(((TotalLabel)o).label.getText());
        }
    }

    private class UndoOccsAction
    extends AbstractAction {
        private boolean undo;

        public UndoOccsAction(boolean undo) {
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.undo) {
                JPanelWell.this.undoRedoOccs(true);
            } else {
                JPanelWell.this.undoRedoOccs(false);
            }
        }
    }

    private class UndoAction
    extends AbstractAction {
        private boolean undo;

        UndoAction(boolean undo) {
            this.undo = undo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JPanelWell.this.jTabbedPaneSampleData.getSelectedComponent() == JPanelWell.this.jPanelCharts) {
                new UndoRedoAction(this.undo, JPanelWell.this.jPanelCharts).actionPerformed(e);
            } else if (JPanelWell.this.jTabbedPaneSampleData.getSelectedComponent() == JPanelWell.this.jPanelOccurences) {
                new UndoOccsAction(this.undo).actionPerformed(e);
            }
        }
    }
}

