/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import jsbugs.ChartProperties;
import jsbugs.DialogPanelBiocoms;
import jsbugs.DialogPanelDepth;
import jsbugs.DialogPanelEvents;
import jsbugs.DialogPanelSQPicks;
import jsbugs.DialogPanelSamples;
import jsbugs.DialogPanelTaxonGroup;
import jsbugs.DialogPanelZones;
import jsbugs.DialogSelectIGDPanel;
import jsbugs.DialogWirelineLogPanel;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelChartBlock;
import jsbugs.PanelBiocoms;
import jsbugs.PanelDepth;
import jsbugs.PanelEvents;
import jsbugs.PanelEventsBase;
import jsbugs.PanelSQPicks;
import jsbugs.PanelSamples;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelZones;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.SBdb;
import util.SB;
import util.SBException;

public class JPanelWellBlock
extends JPanelChartBlock {
    WellBlock block;
    ChartProperties cp;

    public JPanelWellBlock() {
    }

    public JPanelWellBlock(WellBlock block, SBdb sbdb, SBDialog parent, ChartProperties cp) {
        super(sbdb, parent);
        this.block = block;
        this.cp = cp;
        this.init();
    }

    void init(WellBlock block, SBdb sbdb, SBDialog parent, ChartProperties cp) {
        this.init(sbdb, parent);
        this.block = block;
        this.cp = cp;
        this.createPanelList(block);
        this.createOrigPanelList(block);
    }

    @Override
    WellBlock getBlock() {
        return this.block;
    }

    @Override
    void addPanel() {
        if (this.block.well == null) {
            JOptionPane.showMessageDialog(this, "No well selected!", "Add Panel", 2);
            return;
        }
        DialogSelectIGDPanel dialog = new DialogSelectIGDPanel(this.parent, true, this.sbdb, this.block, null, "Add Panels", null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                if (!this.panelModel.isEmpty()) {
                    this.parent.setCursor(Cursor.getPredefinedCursor(3));
                    for (SBPanel panel : this.block.panels) {
                        if (this.panelModel.contains(panel)) continue;
                        this.block.setData(panel, this.cp);
                    }
                    this.parent.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error setting data", (Exception)((Object)sbe));
            }
            catch (IOException e) {
                SB.showStackError((String)"I/O Error", (Exception)e);
            }
            catch (SQLException sqle) {
                SB.showStackError((String)"SQL Error setting data", (SQLException)sqle);
            }
            this.createPanelList(this.block);
        }
    }

    @Override
    void panelProperties(SBPanel panel) {
        SBDialog dialog = null;
        if (panel instanceof PanelDepth) {
            dialog = new DialogPanelDepth((Dialog)this.parent, true, (PanelDepth)panel);
        } else if (panel instanceof PanelSamples) {
            dialog = new DialogPanelSamples((Dialog)this.parent, true, (PanelSamples)panel, this.sbdb);
        } else if (panel instanceof PanelEvents) {
            dialog = new DialogPanelEvents((Dialog)this.parent, true, (PanelEventsBase)((PanelEvents)panel), this.sbdb);
        } else if (panel instanceof PanelWirelineLog) {
            dialog = new DialogWirelineLogPanel(this.parent, true, (PanelWirelineLog)panel, this.block, this.sbdb);
        } else if (panel instanceof PanelSQPicks) {
            dialog = new DialogPanelSQPicks((Dialog)this.parent, true, this.sbdb, (PanelSQPicks)panel);
        } else if (panel instanceof PanelZones) {
            dialog = new DialogPanelZones((Dialog)this.parent, true, (PanelZones)panel, this.sbdb);
        } else if (panel instanceof PanelBiocoms) {
            dialog = new DialogPanelBiocoms((Dialog)this.parent, true, (PanelBiocoms)panel, this.sbdb);
        } else if (panel instanceof PanelTaxonGroup) {
            dialog = new DialogPanelTaxonGroup((Dialog)this.parent, true, (PanelTaxonGroup)panel);
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                try {
                    this.block.setData(panel, this.cp);
                }
                catch (SBException sbe) {
                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
                catch (IOException e) {
                    SB.showStackError((String)"I/O Error", (Exception)e);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "No properties available for this panel", "Panel Properties", 1);
        }
    }
}

