/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import jsbugs.BiocomTableModel;
import jsbugs.DialogBiocom;
import jsbugs.DialogCmpStd;
import jsbugs.DialogEnv;
import jsbugs.DialogEventComments;
import jsbugs.DialogFault;
import jsbugs.DialogFillHierarchy;
import jsbugs.DialogGenerateEvent;
import jsbugs.DialogIGDColmap;
import jsbugs.DialogIGDHdrs;
import jsbugs.DialogInterval;
import jsbugs.DialogIntervalComment;
import jsbugs.DialogLOCnode;
import jsbugs.DialogSQPick;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectVersion;
import jsbugs.DialogWellEvent;
import jsbugs.EnvTableModel;
import jsbugs.EventsTableModel;
import jsbugs.FaultsTableModel;
import jsbugs.FrameJsbugs;
import jsbugs.FrameSamples;
import jsbugs.IntervalCommentsTableModel;
import jsbugs.JPanelWell;
import jsbugs.LOCTableModel;
import jsbugs.SQPickTableModel;
import jsbugs.TableModelSB;
import jsbugs.TablePair;
import jsbugs.ZonesTableModel;
import model2.Biocom;
import model2.Discipline;
import model2.Fault;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.IGDUnit;
import model2.Intcom;
import model2.InterpHdr;
import model2.LASFile;
import model2.LOC;
import model2.Lastval;
import model2.SBEvent;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Surface;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.AgeFormat;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.TableSorter;

public class JPanelWellInterp
extends JPanel
implements Observer {
    FrameSamples parentFrame;
    JPanelWell parentPanel;
    SBdb sbdb;
    Well well;
    char units;
    static final String SELECT_STRING = "<Select>";
    static final String SAVEAS_TOOLTIP = "<html>Save this table to a text file<br>(<b>Hint:</b> copy table cells using <b>CTRL+C</b>)</html>";
    static int ROW_HEIGHT;
    ZonesTableModel tableModelBiozones = new ZonesTableModel();
    EventsTableModel tableModelEvents = new EventsTableModel();
    BiocomTableModel tableModelBiocom = new BiocomTableModel();
    IntervalCommentsTableModel tableModelIntervalComments = new IntervalCommentsTableModel();
    ZonesTableModel tableModelChrono = new ZonesTableModel();
    SQPickTableModel tableModelSQPicks = new SQPickTableModel();
    EnvTableModel tableModelEnv = new EnvTableModel();
    ZonesTableModel tableModelLstrat = new ZonesTableModel();
    LOCTableModel tableModelLOC = new LOCTableModel();
    FaultsTableModel tableModelFaults = new FaultsTableModel();
    TableSorter tableSorterChrono = new TableSorter((TableModel)this.tableModelChrono);
    TableSorter tableSorterLstrat = new TableSorter((TableModel)this.tableModelLstrat);
    TableSorter tableSorterBiozones = new TableSorter((TableModel)this.tableModelBiozones);
    TableSorter tableSorterBiocom = new TableSorter((TableModel)this.tableModelBiocom);
    TableSorter tableSorterEnv = new TableSorter((TableModel)this.tableModelEnv);
    TableSorter tableSorterEvents = new TableSorter((TableModel)this.tableModelEvents);
    TableSorter tableSorterSQPicks = new TableSorter((TableModel)this.tableModelSQPicks);
    TableSorter tableSorterIntervalComments = new TableSorter((TableModel)this.tableModelIntervalComments);
    TableSorter tableSorterFaults = new TableSorter((TableModel)this.tableModelFaults);
    boolean comboVersionLoading = true;
    DefaultComboBoxModel comboModelBioScheme = new DefaultComboBoxModel();
    private ButtonGroup buttonGroupAgeDisplay;
    private JButton jButtonAddBio;
    private JButton jButtonAddChrono;
    private JButton jButtonAddCom;
    private JButton jButtonAddEvent;
    private JButton jButtonAddFault;
    private JButton jButtonAddIntCom;
    private JButton jButtonAddLOC;
    private JButton jButtonAddLith;
    private JButton jButtonAddPal;
    private JButton jButtonAddSQPick;
    private JButton jButtonBioColmap;
    private JButton jButtonChronoColmap;
    private JButton jButtonCommentEvents;
    private JButton jButtonCopyBio;
    private JButton jButtonCopyChrono;
    private JButton jButtonCopyCom;
    private JButton jButtonCopyEvents;
    private JButton jButtonCopyIntCom;
    private JButton jButtonCopyLOC;
    private JButton jButtonCopyLith;
    private JButton jButtonCopyPal;
    private JButton jButtonCopySQPicks;
    private JButton jButtonCreateComposite;
    private JButton jButtonCreateSamples;
    private JButton jButtonDeleteBio;
    private JButton jButtonDeleteChrono;
    private JButton jButtonDeleteCom;
    private JButton jButtonDeleteEvent;
    private JButton jButtonDeleteFault;
    private JButton jButtonDeleteIntCom;
    private JButton jButtonDeleteLOC;
    private JButton jButtonDeleteLith;
    private JButton jButtonDeletePal;
    private JButton jButtonDeleteSQPick;
    private JButton jButtonEditBio;
    private JButton jButtonEditChrono;
    private JButton jButtonEditCom;
    private JButton jButtonEditEvent;
    private JButton jButtonEditFault;
    private JButton jButtonEditIntCom;
    private JButton jButtonEditLith;
    private JButton jButtonEditPal;
    private JButton jButtonEditSQPick;
    private JButton jButtonEventComments;
    private JButton jButtonFillBiozoneHierachy;
    private JButton jButtonFillChronoHierachy;
    private JButton jButtonFillLstratHierachy;
    private JButton jButtonGenerateEvents;
    private JButton jButtonIGDHdrs;
    private JButton jButtonLstratColmap;
    private JButton jButtonMoveBio;
    private JButton jButtonMoveChrono;
    private JButton jButtonMoveCom;
    private JButton jButtonMoveEvents;
    private JButton jButtonMoveIntCom;
    private JButton jButtonMoveLOC;
    private JButton jButtonMoveLith;
    private JButton jButtonMovePal;
    private JButton jButtonMoveSQPick;
    private JButton jButtonSaveAsBio;
    private JButton jButtonSaveAsChrono;
    private JButton jButtonSaveAsCom;
    private JButton jButtonSaveAsIntCom;
    private JButton jButtonSaveAsLOC;
    private JButton jButtonSaveAsLith;
    private JButton jButtonSaveAsPal;
    private JButton jButtonSaveAsSQPick;
    private JButton jButtonSelectAllBio;
    private JButton jButtonSelectAllChrono;
    private JButton jButtonSelectAllCom;
    private JButton jButtonSelectAllEvents;
    private JButton jButtonSelectAllIntCom;
    private JButton jButtonSelectAllLith;
    private JButton jButtonSelectAllPal;
    private JButton jButtonSelectAllSQPick;
    private JButton jButtonShowChronoScheme;
    private JButton jButtonShowLstratScheme;
    private JButton jButtonShowSQschemetScheme;
    private JButton jButtonShowSchemeBiozone;
    private JButton jButtonVersionSelect;
    private JComboBox jComboBoxSchemeBio;
    private JComboBox jComboBoxVersion;
    private JLabel jLabel10;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabelLOCAudit;
    private JPanel jPanel1;
    private JPanel jPanelBiozones;
    private JPanel jPanelChrono;
    private JPanel jPanelComments;
    private JPanel jPanelEnv;
    private JPanel jPanelEvents;
    private JPanel jPanelFaults;
    private JPanel jPanelIntComments;
    private JPanel jPanelLOC;
    private JPanel jPanelLStrat;
    private JPanel jPanelSQPick;
    private JRadioButton jRadioButtonAgeFormatKa;
    private JRadioButton jRadioButtonAgeFormatMA;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPaneComments;
    private JScrollPane jScrollPaneIntComments;
    private JScrollPane jScrollPaneLOC;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator15;
    private JSeparator jSeparator16;
    private JSeparator jSeparator17;
    private JSeparator jSeparator18;
    private JSeparator jSeparator19;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JTabbedPane jTabbedPaneInterpretations;
    private JTable jTableBiozones;
    private JTable jTableChrono;
    private JTable jTableComments;
    private JTable jTableEnv;
    private JTable jTableEvents;
    private JTable jTableFaults;
    private JTable jTableIntComments;
    private JTable jTableLOC;
    private JTable jTableLStrat;
    private JTable jTableSQPicks;
    private JTextField jTextFieldLOCColour;

    public JPanelWellInterp(FrameSamples parent, JPanelWell parentPanel, SBdb sbdb, Well well) throws SQLException, SBException {
        this.initComponents();
        this.parentFrame = parent;
        this.parentPanel = parentPanel;
        this.sbdb = sbdb;
        this.well = well;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.tableModelBiozones.setupTable(this.jTableBiozones, this.sbdb);
        this.tableSorterBiozones.addMouseListenerToHeaderInTable(this.jTableBiozones);
        this.tableModelEvents.setupTable(this.jTableEvents, this.sbdb);
        this.tableSorterEvents.addMouseListenerToHeaderInTable(this.jTableEvents);
        this.tableModelBiocom.setupTable(this.jTableComments, this.sbdb);
        this.tableSorterBiocom.addMouseListenerToHeaderInTable(this.jTableComments);
        this.tableModelIntervalComments.setupTable(this.jTableIntComments, this.sbdb);
        this.tableSorterIntervalComments.addMouseListenerToHeaderInTable(this.jTableIntComments);
        this.tableModelChrono.setupTable(this.jTableChrono, this.sbdb);
        this.tableSorterChrono.addMouseListenerToHeaderInTable(this.jTableChrono);
        this.tableModelSQPicks.setupTable(this.jTableSQPicks, this.sbdb);
        this.tableSorterSQPicks.addMouseListenerToHeaderInTable(this.jTableSQPicks);
        this.tableModelEnv.setupTable(this.jTableEnv, this.sbdb);
        this.tableSorterEnv.addMouseListenerToHeaderInTable(this.jTableEnv);
        this.tableModelLstrat.setupTable(this.jTableLStrat, this.sbdb);
        this.tableSorterLstrat.addMouseListenerToHeaderInTable(this.jTableLStrat);
        this.tableModelFaults.setupTable(this.jTableFaults, this.sbdb);
        this.tableSorterFaults.addMouseListenerToHeaderInTable(this.jTableFaults);
        this.tableModelLOC.db = this.sbdb;
        this.tableModelLOC.setupTable(this.jTableLOC);
        this.well.loadInterps();
        this.sbdb.commit();
        this.comboVersionLoading = true;
        this.well.fillInterpCombo(this.jComboBoxVersion);
        if (this.jComboBoxVersion.getItemCount() > 1) {
            this.jComboBoxVersion.insertItemAt(SELECT_STRING, 0);
            this.jComboBoxVersion.setSelectedIndex(0);
        } else {
            this.comboVersionLoading = false;
            this.jComboBoxVersion.setSelectedIndex(0);
            this.getInterp().addObserver((Observer)this.parentFrame.getSchemeChart());
            this.getInterp().addObserver((Observer)this.parentPanel);
        }
        this.fillBioSchemeCombo();
        this.comboVersionLoading = false;
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (arg != null && (arg.getClass() == WellInterp.class || arg.getClass() == InterpHdr.class)) {
            int origID = 0;
            if (this.getInterp() != null) {
                origID = this.getInterp().getHeader().getInterpID();
            }
            this.comboVersionLoading = true;
            this.well.fillInterpCombo(this.jComboBoxVersion);
            this.comboVersionLoading = false;
            try {
                if (arg.getClass() == WellInterp.class && this.well.getInterp(((WellInterp)arg).getHeader().getInterpID()) != null) {
                    this.jComboBoxVersion.setSelectedItem(arg);
                } else if (arg.getClass() == InterpHdr.class && this.getInterp().getHeader().getInterpID() != origID) {
                    this.jComboBoxVersionActionPerformed(null);
                }
            }
            catch (SBException sbe) {
                SB.showStackError((String)sbe.toString(), (Exception)((Object)sbe));
            }
        } else if (obs instanceof WellInterp) {
            int igdType = 0;
            if (arg.getClass() == IGDIntervalZone.class) {
                IGDIntervalZone zone = (IGDIntervalZone)arg;
                igdType = zone.getIGDType();
            } else if (arg.getClass() == Biocom.class) {
                igdType = 19;
            } else if (arg.getClass() == Integer.class) {
                igdType = (Integer)arg;
            } else if (arg.getClass() == IGDIntervalEnv.class) {
                igdType = 5;
            } else if (arg.getClass() == WellEvent.class) {
                igdType = 20;
            } else if (arg.getClass() == SQPick.class) {
                igdType = 21;
            } else if (arg.getClass() == Intcom.class) {
                igdType = 22;
            } else if (arg.getClass() == LOC.class) {
                igdType = 23;
            } else if (arg.getClass() == Fault.class) {
                igdType = 24;
            }
            switch (igdType) {
                case 3: {
                    this.tableSorterChrono.reallocateIndexes();
                    this.tableSorterChrono.sort((Object)this);
                    this.tableSorterChrono.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableChrono, this.tableModelChrono.zones, this.tableSorterChrono);
                    break;
                }
                case 2: {
                    this.tableSorterLstrat.reallocateIndexes();
                    this.tableSorterLstrat.sort((Object)this);
                    this.tableSorterLstrat.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableLStrat, this.tableModelLstrat.zones, this.tableSorterLstrat);
                    break;
                }
                case 10: {
                    System.out.println("In IGD_SEQUENCE??");
                    this.tableSorterSQPicks.reallocateIndexes();
                    this.tableSorterSQPicks.sort((Object)this);
                    this.tableSorterSQPicks.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableSQPicks, this.tableModelSQPicks.picks, this.tableSorterSQPicks);
                    break;
                }
                case 4: {
                    System.out.println("In JPanelWellInterp, re-sorting");
                    this.jComboBoxSchemeBioActionPerformed(null);
                    try {
                        this.updateBioSchemeCombo();
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this.parentFrame, "Error updating biozone scheme combo: " + ex.getMessage(), this.parentFrame.getTitle(), 1);
                        ex.printStackTrace();
                    }
                    this.setTableSelection(arg, this.jTableBiozones, this.tableModelBiozones.zones, this.tableSorterBiozones);
                    break;
                }
                case 19: {
                    this.tableSorterBiocom.reallocateIndexes();
                    this.tableSorterBiocom.sort((Object)this);
                    this.tableSorterBiocom.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableComments, this.tableModelBiocom.comments, this.tableSorterBiocom);
                    break;
                }
                case 5: {
                    this.tableSorterEnv.reallocateIndexes();
                    this.tableSorterEnv.sort((Object)this);
                    this.tableSorterEnv.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableEnv, this.tableModelEnv.envs, this.tableSorterEnv);
                    break;
                }
                case 20: {
                    this.tableSorterEvents.reallocateIndexes();
                    this.tableSorterEvents.sort((Object)this);
                    this.tableSorterEvents.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableEvents, this.tableModelEvents.events, this.tableSorterEvents);
                    break;
                }
                case 21: {
                    this.tableSorterSQPicks.reallocateIndexes();
                    this.tableSorterSQPicks.sort((Object)this);
                    this.tableSorterSQPicks.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableSQPicks, this.tableModelSQPicks.picks, this.tableSorterSQPicks);
                    break;
                }
                case 22: {
                    this.tableSorterIntervalComments.reallocateIndexes();
                    this.tableSorterIntervalComments.sort((Object)this);
                    this.tableSorterIntervalComments.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableIntComments, this.tableModelIntervalComments.comments, this.tableSorterIntervalComments);
                    break;
                }
                case 24: {
                    this.tableSorterFaults.reallocateIndexes();
                    this.tableSorterFaults.sort((Object)this);
                    this.tableSorterFaults.fireTableDataChanged();
                    this.setTableSelection(arg, this.jTableFaults, this.tableModelFaults.faults, this.tableSorterFaults);
                    break;
                }
                case 23: {
                    WellInterp wellInterp = this.getInterp();
                    if (wellInterp != null) {
                        try {
                            AgeFormat af = this.tableModelLOC.setLOC(wellInterp, this.jTableLOC, this.well.getWellID());
                            if (wellInterp.getLOC() != null) {
                                this.jLabelLOCAudit.setText(wellInterp.getLOC().getAudit().toString(this.sbdb, true));
                            } else {
                                this.jLabelLOCAudit.setText("");
                            }
                            this.setAgeFormatButton(af);
                        }
                        catch (Exception e) {
                            SB.showStackError((String)"Error updating LOC table", (Exception)e);
                        }
                        if (wellInterp.getLOC() != null) {
                            wellInterp.getLOC().addObserver((Observer)this);
                        }
                    }
                    this.tableModelLOC.fireTableDataChanged();
                }
            }
        } else if (obs instanceof LOC && obs == this.tableModelLOC.getLOC()) {
            this.tableModelLOC.fireTableDataChanged();
        }
    }

    void setUnits(char units) {
        if (units == 'M' && this.units != 'M' || units == 'F' && this.units != 'F') {
            this.units = units;
            this.tableModelChrono.units = units;
            this.tableSorterChrono.fireTableDataChanged();
            this.tableModelLstrat.units = units;
            this.tableSorterLstrat.fireTableDataChanged();
            this.tableModelBiozones.units = units;
            this.tableSorterBiozones.fireTableDataChanged();
            this.tableModelEnv.units = units;
            this.tableSorterEnv.fireTableDataChanged();
            this.tableModelBiocom.units = units;
            this.tableSorterBiocom.fireTableDataChanged();
            this.tableModelEvents.units = units;
            this.tableSorterEvents.fireTableDataChanged();
            this.tableModelIntervalComments.units = units;
            this.tableModelIntervalComments.type = this.well.getType();
            this.tableSorterIntervalComments.fireTableDataChanged();
            this.tableModelLOC.setUnits(units);
            this.tableModelLOC.type = this.well.getType();
            this.tableModelLOC.fireTableDataChanged();
            this.tableModelSQPicks.units = units;
            this.tableSorterSQPicks.fireTableDataChanged();
            this.tableModelFaults.units = units;
            this.tableSorterFaults.fireTableDataChanged();
        }
    }

    void fillBioSchemeCombo() throws SQLException {
        this.comboModelBioScheme.removeAllElements();
        Object obj = this.jComboBoxVersion.getSelectedItem();
        if (obj instanceof WellInterp) {
            WellInterp wellInterp = (WellInterp)obj;
            for (IGDIntervalZone zone : wellInterp.getIGDList(4, 0)) {
                IGDScheme scheme = this.sbdb.getIGDScheme(zone.getSchID());
                if (this.comboModelBioScheme.getIndexOf(scheme) >= 0) continue;
                this.comboModelBioScheme.addElement(scheme);
            }
            this.jComboBoxSchemeBio.repaint();
        }
    }

    void updateBioSchemeCombo() throws SQLException {
        IGDScheme addedScheme = null;
        Object obj = this.jComboBoxVersion.getSelectedItem();
        if (obj instanceof WellInterp) {
            WellInterp wellInterp = (WellInterp)obj;
            for (IGDIntervalZone zone : wellInterp.getIGDList(4, 0)) {
                IGDScheme scheme = this.sbdb.getIGDScheme(zone.getSchID());
                if (this.comboModelBioScheme.getIndexOf(scheme) >= 0) continue;
                this.comboModelBioScheme.addElement(scheme);
                addedScheme = scheme;
            }
            this.jComboBoxSchemeBio.repaint();
        }
        if (addedScheme != null) {
            this.comboModelBioScheme.setSelectedItem(addedScheme);
        }
    }

    WellInterp getInterp() {
        if (!(this.jComboBoxVersion.getSelectedItem() instanceof WellInterp)) {
            return null;
        }
        return (WellInterp)this.jComboBoxVersion.getSelectedItem();
    }

    void loadDefaultVersion() {
        if (!(this.jComboBoxVersion.getSelectedItem() instanceof WellInterp)) {
            try {
                this.jComboBoxVersion.setSelectedItem(this.well.getInterp(0));
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
        }
    }

    void editZone(IGDIntervalZone zone) {
        try {
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
                return;
            }
            DialogInterval dialog = new DialogInterval(this.parentFrame, true, zone.getIGDType(), this.sbdb, this.well, wellInterp, this.units, zone, null, null, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error opening dialog: " + e.getMessage(), this.parentFrame.getTitle(), 0);
        }
    }

    void addEvent(SBEvent event, SBEvent.EventType eventType) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Sample sample = null;
        try {
            sample = this.parentPanel.getSelectedSample();
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error getting selected sample", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        DialogWellEvent dialog = new DialogWellEvent(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, null, sample, event, eventType);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    void addSQPick(Surface surface) {
        try {
            WellInterp wellInterp = this.getSelectedVersion();
            if (wellInterp == null) {
                return;
            }
            Sample sample = null;
            IGDScheme scheme = null;
            try {
                sample = this.parentPanel.getSelectedSample();
                if (surface == null) {
                    Iterator i$ = wellInterp.getSQPicks().iterator();
                    if (i$.hasNext()) {
                        SQPick pick = (SQPick)i$.next();
                        scheme = pick.getSurface().getScheme();
                    }
                } else {
                    scheme = surface.getScheme();
                }
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("Error getting selected sample", sql, this.sbdb);
            }
            try {
                DialogSQPick dialog = new DialogSQPick(this.parentFrame, true, this.sbdb, scheme, this.well, wellInterp, this.units, null, sample, surface);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
            catch (SQLException e) {
                FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
            }
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void addZone(int igdType, IGDUnit unit, IGDScheme scheme) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            Sample topSample = this.parentPanel.getSelectedTopSample();
            Sample baseSample = this.parentPanel.getSelectedBaseSample();
            if (scheme == null) {
                for (IGDIntervalZone zone : wellInterp.getIGDList(igdType, 0)) {
                    scheme = this.sbdb.getIGDScheme(zone.getSchID());
                }
            }
            DialogInterval dialog = new DialogInterval(this.parentFrame, true, igdType, this.sbdb, this.well, wellInterp, this.units, null, topSample, baseSample, unit, scheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.baseSample != null) {
                this.parentPanel.setSelectedSample(dialog.baseSample);
            }
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void deleteZones(JTable table, ZonesTableModel model, TableSorter sorter) {
        int nRows = table.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select interval(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        String msg = "Really delete ";
        msg = nRows == 1 ? msg + "this interval?" : msg + "these " + nRows + " intervals?";
        if (JOptionPane.showConfirmDialog(this, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<IGDIntervalZone> toKill = new LinkedList<IGDIntervalZone>();
        for (int row : table.getSelectedRows()) {
            toKill.add(model.zones.get(sorter.getIndexOf(row)));
        }
        try {
            int igdType = 0;
            for (IGDIntervalZone zone : toKill) {
                igdType = zone.getIGDType();
                wellInterp.deleteZone(this.well, zone);
                this.sbdb.commit();
            }
            table.clearSelection();
            wellInterp.notifyObservers((Object)igdType);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error deleting zones", ex, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error deleting zones", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void initComponents() {
        this.buttonGroupAgeDisplay = new ButtonGroup();
        this.jLabel4 = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.jButtonVersionSelect = new JButton();
        this.jTabbedPaneInterpretations = new JTabbedPane();
        this.jPanelChrono = new JPanel();
        this.jButtonAddChrono = new JButton();
        this.jButtonEditChrono = new JButton();
        this.jButtonDeleteChrono = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jButtonSelectAllChrono = new JButton();
        this.jButtonCopyChrono = new JButton();
        this.jButtonMoveChrono = new JButton();
        this.jSeparator5 = new JSeparator();
        this.jButtonSaveAsChrono = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableChrono = new JTable();
        this.jButtonChronoColmap = new JButton();
        this.jButtonFillChronoHierachy = new JButton();
        this.jButtonShowChronoScheme = new JButton();
        this.jPanelBiozones = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.jTableBiozones = new JTable();
        this.jButtonAddBio = new JButton();
        this.jButtonEditBio = new JButton();
        this.jButtonDeleteBio = new JButton();
        this.jButtonMoveBio = new JButton();
        this.jButtonCopyBio = new JButton();
        this.jButtonSelectAllBio = new JButton();
        this.jButtonSaveAsBio = new JButton();
        this.jSeparator12 = new JSeparator();
        this.jSeparator13 = new JSeparator();
        this.jComboBoxSchemeBio = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jButtonBioColmap = new JButton();
        this.jButtonFillBiozoneHierachy = new JButton();
        this.jButtonShowSchemeBiozone = new JButton();
        this.jPanelLStrat = new JPanel();
        this.jButtonAddLith = new JButton();
        this.jButtonEditLith = new JButton();
        this.jButtonDeleteLith = new JButton();
        this.jSeparator10 = new JSeparator();
        this.jButtonSelectAllLith = new JButton();
        this.jButtonCopyLith = new JButton();
        this.jButtonMoveLith = new JButton();
        this.jSeparator11 = new JSeparator();
        this.jButtonSaveAsLith = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTableLStrat = new JTable();
        this.jButtonLstratColmap = new JButton();
        this.jButtonFillLstratHierachy = new JButton();
        this.jButtonShowLstratScheme = new JButton();
        this.jPanelSQPick = new JPanel();
        this.jButtonAddSQPick = new JButton();
        this.jButtonEditSQPick = new JButton();
        this.jButtonDeleteSQPick = new JButton();
        this.jSeparator18 = new JSeparator();
        this.jButtonSelectAllSQPick = new JButton();
        this.jButtonMoveSQPick = new JButton();
        this.jSeparator19 = new JSeparator();
        this.jButtonSaveAsSQPick = new JButton();
        this.jScrollPane6 = new JScrollPane();
        this.jTableSQPicks = new JTable();
        this.jButtonShowSQschemetScheme = new JButton();
        this.jButtonCopySQPicks = new JButton();
        this.jPanelEnv = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableEnv = new JTable();
        this.jButtonAddPal = new JButton();
        this.jButtonEditPal = new JButton();
        this.jButtonDeletePal = new JButton();
        this.jSeparator6 = new JSeparator();
        this.jButtonSelectAllPal = new JButton();
        this.jButtonCopyPal = new JButton();
        this.jButtonMovePal = new JButton();
        this.jSeparator7 = new JSeparator();
        this.jButtonSaveAsPal = new JButton();
        this.jPanelComments = new JPanel();
        this.jScrollPaneComments = new JScrollPane();
        this.jTableComments = new JTable();
        this.jButtonAddCom = new JButton();
        this.jButtonEditCom = new JButton();
        this.jButtonDeleteCom = new JButton();
        this.jButtonSaveAsCom = new JButton();
        this.jButtonCopyCom = new JButton();
        this.jButtonMoveCom = new JButton();
        this.jButtonSelectAllCom = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jButtonCommentEvents = new JButton();
        this.jPanelIntComments = new JPanel();
        this.jScrollPaneIntComments = new JScrollPane();
        this.jTableIntComments = new JTable();
        this.jButtonAddIntCom = new JButton();
        this.jButtonEditIntCom = new JButton();
        this.jButtonDeleteIntCom = new JButton();
        this.jButtonSaveAsIntCom = new JButton();
        this.jButtonCopyIntCom = new JButton();
        this.jButtonMoveIntCom = new JButton();
        this.jButtonSelectAllIntCom = new JButton();
        this.jSeparator16 = new JSeparator();
        this.jPanelEvents = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.jTableEvents = new JTable();
        this.jButtonAddEvent = new JButton();
        this.jButtonDeleteEvent = new JButton();
        this.jButtonGenerateEvents = new JButton();
        this.jSeparator14 = new JSeparator();
        this.jButtonSelectAllEvents = new JButton();
        this.jButtonMoveEvents = new JButton();
        this.jButtonCopyEvents = new JButton();
        this.jSeparator15 = new JSeparator();
        this.jButtonEditEvent = new JButton();
        this.jButtonCreateComposite = new JButton();
        this.jButtonEventComments = new JButton();
        this.jPanelLOC = new JPanel();
        this.jScrollPaneLOC = new JScrollPane();
        this.jTableLOC = new JTable();
        this.jButtonAddLOC = new JButton();
        this.jButtonDeleteLOC = new JButton();
        this.jButtonSaveAsLOC = new JButton();
        this.jButtonCopyLOC = new JButton();
        this.jButtonMoveLOC = new JButton();
        this.jSeparator17 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.jTextFieldLOCColour = new JTextField();
        this.jButtonCreateSamples = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonAgeFormatMA = new JRadioButton();
        this.jRadioButtonAgeFormatKa = new JRadioButton();
        this.jLabelLOCAudit = new JLabel();
        this.jPanelFaults = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableFaults = new JTable();
        this.jButtonAddFault = new JButton();
        this.jButtonEditFault = new JButton();
        this.jButtonDeleteFault = new JButton();
        this.jButtonIGDHdrs = new JButton();
        this.jLabel4.setText("Version:");
        this.jComboBoxVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jComboBoxVersionActionPerformed(evt);
            }
        });
        this.jButtonVersionSelect.setText("...");
        this.jButtonVersionSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonVersionSelectActionPerformed(evt);
            }
        });
        this.jButtonAddChrono.setText("Add...");
        this.jButtonAddChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddChronoActionPerformed(evt);
            }
        });
        this.jButtonEditChrono.setText("Edit...");
        this.jButtonEditChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditChronoActionPerformed(evt);
            }
        });
        this.jButtonDeleteChrono.setText("Delete");
        this.jButtonDeleteChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteChronoActionPerformed(evt);
            }
        });
        this.jButtonSelectAllChrono.setText("Select all");
        this.jButtonSelectAllChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllChronoActionPerformed(evt);
            }
        });
        this.jButtonCopyChrono.setText("Copy...");
        this.jButtonCopyChrono.setToolTipText("Copy selected intervals to a different version");
        this.jButtonCopyChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyChronoActionPerformed(evt);
            }
        });
        this.jButtonMoveChrono.setText("Move...");
        this.jButtonMoveChrono.setToolTipText("Move selected intervals to different version");
        this.jButtonMoveChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveChronoActionPerformed(evt);
            }
        });
        this.jButtonSaveAsChrono.setText("Save as...");
        this.jButtonSaveAsChrono.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsChrono.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSaveAsChronoActionPerformed(evt);
            }
        });
        this.jTableChrono.setModel((TableModel)this.tableSorterChrono);
        this.jTableChrono.setRowHeight(20);
        this.jTableChrono.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableChronoMouseClicked(evt);
            }
        });
        this.jTableChrono.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableChronoKeyPressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableChrono);
        this.jButtonChronoColmap.setText("Column mapping...");
        this.jButtonChronoColmap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonChronoColmapActionPerformed(evt);
            }
        });
        this.jButtonFillChronoHierachy.setText("Fill...");
        this.jButtonFillChronoHierachy.setToolTipText("Fill the higher levels of selected intervals from the scheme");
        this.jButtonFillChronoHierachy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonFillChronoHierachyActionPerformed(evt);
            }
        });
        this.jButtonShowChronoScheme.setText("Show Scheme...");
        this.jButtonShowChronoScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonShowChronoSchemeActionPerformed(evt);
            }
        });
        GroupLayout jPanelChronoLayout = new GroupLayout((Container)this.jPanelChrono);
        this.jPanelChrono.setLayout((LayoutManager)jPanelChronoLayout);
        jPanelChronoLayout.setHorizontalGroup((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(2).add((Component)this.jButtonAddChrono, -2, 83, -2).add((Component)this.jButtonEditChrono, -2, 83, -2)).add((Component)this.jButtonDeleteChrono, -2, 83, -2).add((Component)this.jSeparator4, -2, 83, -2).add((Component)this.jButtonSelectAllChrono, -2, 83, -2).add(2, (Component)this.jButtonMoveChrono, -2, 83, -2).add((Component)this.jButtonFillChronoHierachy, -2, 73, -2).add((Component)this.jSeparator5, -2, 83, -2).add((Component)this.jButtonSaveAsChrono, -2, 83, -2)).add((Component)this.jButtonCopyChrono, -2, 83, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().add((Component)this.jButtonChronoColmap).addPreferredGap(0, 348, Short.MAX_VALUE).add((Component)this.jButtonShowChronoScheme).addContainerGap()).add((Component)this.jScrollPane2, -1, 592, Short.MAX_VALUE))));
        jPanelChronoLayout.linkSize(new Component[]{this.jButtonFillChronoHierachy, this.jButtonMoveChrono}, 1);
        jPanelChronoLayout.setVerticalGroup((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(3).add((Component)this.jButtonChronoColmap).add((Component)this.jButtonShowChronoScheme)).addPreferredGap(1).add((GroupLayout.Group)jPanelChronoLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelChronoLayout.createSequentialGroup().add((Component)this.jButtonAddChrono).addPreferredGap(0).add((Component)this.jButtonEditChrono).addPreferredGap(0).add((Component)this.jButtonDeleteChrono).addPreferredGap(0).add((Component)this.jSeparator4, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllChrono).addPreferredGap(0).add((Component)this.jButtonCopyChrono, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveChrono).addPreferredGap(1).add((Component)this.jSeparator5, -2, 10, -2).add(10, 10, 10).add((Component)this.jButtonFillChronoHierachy).addPreferredGap(0).add((Component)this.jButtonSaveAsChrono).addContainerGap()).add((Component)this.jScrollPane2, -1, 474, Short.MAX_VALUE))));
        this.jTabbedPaneInterpretations.addTab("Chronostratigraphy", this.jPanelChrono);
        this.jTableBiozones.setModel((TableModel)this.tableSorterBiozones);
        this.jTableBiozones.setRowHeight(20);
        this.jTableBiozones.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableBiozonesMouseClicked(evt);
            }
        });
        this.jTableBiozones.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableBiozonesKeyPressed(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.jTableBiozones);
        this.jButtonAddBio.setText("Add...");
        this.jButtonAddBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddBioActionPerformed(evt);
            }
        });
        this.jButtonEditBio.setText("Edit...");
        this.jButtonEditBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditBioActionPerformed(evt);
            }
        });
        this.jButtonDeleteBio.setText("Delete");
        this.jButtonDeleteBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteBioActionPerformed(evt);
            }
        });
        this.jButtonMoveBio.setText("Move...");
        this.jButtonMoveBio.setToolTipText("move zones to new version");
        this.jButtonMoveBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveBioActionPerformed(evt);
            }
        });
        this.jButtonCopyBio.setText("Copy...");
        this.jButtonCopyBio.setToolTipText("Copy selected intervals to a different version");
        this.jButtonCopyBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyBioActionPerformed(evt);
            }
        });
        this.jButtonSelectAllBio.setText("Select all");
        this.jButtonSelectAllBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllBioActionPerformed(evt);
            }
        });
        this.jButtonSaveAsBio.setText("Save as...");
        this.jButtonSaveAsBio.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSaveAsBioActionPerformed(evt);
            }
        });
        this.jComboBoxSchemeBio.setModel(this.comboModelBioScheme);
        this.jComboBoxSchemeBio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jComboBoxSchemeBioActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Scheme:");
        this.jButtonBioColmap.setText("Column mapping...");
        this.jButtonBioColmap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonBioColmapActionPerformed(evt);
            }
        });
        this.jButtonFillBiozoneHierachy.setText("Fill...");
        this.jButtonFillBiozoneHierachy.setToolTipText("Fill the higher levels of selected intervals from the scheme");
        this.jButtonFillBiozoneHierachy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonFillBiozoneHierachyActionPerformed(evt);
            }
        });
        this.jButtonShowSchemeBiozone.setText("Show...");
        this.jButtonShowSchemeBiozone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonShowSchemeBiozoneActionPerformed(evt);
            }
        });
        GroupLayout jPanelBiozonesLayout = new GroupLayout((Container)this.jPanelBiozones);
        this.jPanelBiozones.setLayout((LayoutManager)jPanelBiozonesLayout);
        jPanelBiozonesLayout.setHorizontalGroup((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(2).add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((Component)this.jSeparator13, -2, 83, -2).add((Component)this.jButtonDeleteBio, -2, 83, -2).add((Component)this.jButtonEditBio, -2, 83, -2).add((Component)this.jButtonAddBio, -2, 83, -2).add((Component)this.jButtonCopyBio, -2, 83, -2).add((Component)this.jSeparator12, -2, 83, -2)).add((Component)this.jButtonSelectAllBio, -2, 83, -2)).add((Component)this.jButtonMoveBio, -2, 83, -2).add((Component)this.jButtonFillBiozoneHierachy, -2, 83, -2).add((Component)this.jButtonSaveAsBio)).addPreferredGap(0).add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().add((Component)this.jButtonBioColmap).addPreferredGap(0, 135, Short.MAX_VALUE).add((Component)this.jLabel8).addPreferredGap(0).add((Component)this.jComboBoxSchemeBio, -2, 206, -2).addPreferredGap(0).add((Component)this.jButtonShowSchemeBiozone).addContainerGap()).add((Component)this.jScrollPane7, -1, 596, Short.MAX_VALUE))));
        jPanelBiozonesLayout.linkSize(new Component[]{this.jButtonFillBiozoneHierachy, this.jButtonMoveBio}, 1);
        jPanelBiozonesLayout.setVerticalGroup((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(3).add((Component)this.jButtonBioColmap).add((Component)this.jComboBoxSchemeBio, -2, -1, -2).add((Component)this.jLabel8).add((Component)this.jButtonShowSchemeBiozone)).addPreferredGap(0).add((GroupLayout.Group)jPanelBiozonesLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelBiozonesLayout.createSequentialGroup().add((Component)this.jButtonAddBio).addPreferredGap(0).add((Component)this.jButtonEditBio).addPreferredGap(0).add((Component)this.jButtonDeleteBio).addPreferredGap(0).add((Component)this.jSeparator13, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllBio).addPreferredGap(0).add((Component)this.jButtonCopyBio).addPreferredGap(0).add((Component)this.jButtonMoveBio).addPreferredGap(0).add((Component)this.jSeparator12, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonFillBiozoneHierachy).addPreferredGap(0).add((Component)this.jButtonSaveAsBio).addContainerGap()).add((Component)this.jScrollPane7, -1, 479, Short.MAX_VALUE))));
        this.jTabbedPaneInterpretations.addTab("Biozones", this.jPanelBiozones);
        this.jButtonAddLith.setText("Add...");
        this.jButtonAddLith.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddLithActionPerformed(evt);
            }
        });
        this.jButtonEditLith.setText("Edit...");
        this.jButtonEditLith.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditLithActionPerformed(evt);
            }
        });
        this.jButtonDeleteLith.setText("Delete");
        this.jButtonDeleteLith.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteLithActionPerformed(evt);
            }
        });
        this.jButtonSelectAllLith.setText("Select all");
        this.jButtonSelectAllLith.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllLithActionPerformed(evt);
            }
        });
        this.jButtonCopyLith.setText("Copy...");
        this.jButtonCopyLith.setToolTipText("Copy selected intervals to a different version");
        this.jButtonCopyLith.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyLithActionPerformed(evt);
            }
        });
        this.jButtonMoveLith.setText("Move...");
        this.jButtonMoveLith.setToolTipText("move zones to a different version");
        this.jButtonMoveLith.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveLithActionPerformed(evt);
            }
        });
        this.jButtonSaveAsLith.setText("Save as...");
        this.jButtonSaveAsLith.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsLith.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSaveAsLithActionPerformed(evt);
            }
        });
        this.jTableLStrat.setModel((TableModel)this.tableSorterLstrat);
        this.jTableLStrat.setRowHeight(20);
        this.jTableLStrat.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableLStratMouseClicked(evt);
            }
        });
        this.jTableLStrat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableLStratKeyPressed(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableLStrat);
        this.jButtonLstratColmap.setText("Column mapping...");
        this.jButtonLstratColmap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonLstratColmapActionPerformed(evt);
            }
        });
        this.jButtonFillLstratHierachy.setText("Fill...");
        this.jButtonFillLstratHierachy.setToolTipText("Fill the higher levels of selected intervals from the scheme");
        this.jButtonFillLstratHierachy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonFillLstratHierachyActionPerformed(evt);
            }
        });
        this.jButtonShowLstratScheme.setText("Show Scheme...");
        this.jButtonShowLstratScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonShowLstratSchemeActionPerformed(evt);
            }
        });
        GroupLayout jPanelLStratLayout = new GroupLayout((Container)this.jPanelLStrat);
        this.jPanelLStrat.setLayout((LayoutManager)jPanelLStratLayout);
        jPanelLStratLayout.setHorizontalGroup((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((Component)this.jButtonSelectAllLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonEditLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonAddLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonDeleteLith, -1, 83, Short.MAX_VALUE).add((Component)this.jSeparator10, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonCopyLith, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonMoveLith, -1, 83, Short.MAX_VALUE).add((Component)this.jSeparator11, -1, 83, Short.MAX_VALUE).add((Component)this.jButtonFillLstratHierachy, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaveAsLith)).addPreferredGap(0).add((Component)this.jScrollPane4, -1, 586, Short.MAX_VALUE)).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().add(89, 89, 89).add((Component)this.jButtonLstratColmap).addPreferredGap(0, 352, Short.MAX_VALUE).add((Component)this.jButtonShowLstratScheme))).addContainerGap()));
        jPanelLStratLayout.linkSize(new Component[]{this.jButtonAddLith, this.jButtonCopyLith, this.jButtonDeleteLith, this.jButtonEditLith, this.jButtonFillLstratHierachy, this.jButtonMoveLith, this.jButtonSaveAsLith, this.jButtonSelectAllLith, this.jSeparator10, this.jSeparator11}, 1);
        jPanelLStratLayout.setVerticalGroup((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(3).add((Component)this.jButtonLstratColmap).add((Component)this.jButtonShowLstratScheme)).addPreferredGap(0).add((GroupLayout.Group)jPanelLStratLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLStratLayout.createSequentialGroup().add((Component)this.jButtonAddLith).addPreferredGap(0).add((Component)this.jButtonEditLith).addPreferredGap(0).add((Component)this.jButtonDeleteLith).addPreferredGap(0).add((Component)this.jSeparator10, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllLith).addPreferredGap(0).add((Component)this.jButtonCopyLith, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveLith).addPreferredGap(0).add((Component)this.jSeparator11, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonFillLstratHierachy).addPreferredGap(0).add((Component)this.jButtonSaveAsLith).addContainerGap()).add((Component)this.jScrollPane4, -1, 479, Short.MAX_VALUE))));
        this.jTabbedPaneInterpretations.addTab("Lithostratigraphy", this.jPanelLStrat);
        this.jButtonAddSQPick.setText("Add...");
        this.jButtonAddSQPick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddSQPickActionPerformed(evt);
            }
        });
        this.jButtonEditSQPick.setText("Edit...");
        this.jButtonEditSQPick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditSQPickActionPerformed(evt);
            }
        });
        this.jButtonDeleteSQPick.setText("Delete");
        this.jButtonDeleteSQPick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteSQPickActionPerformed(evt);
            }
        });
        this.jButtonSelectAllSQPick.setText("Select all");
        this.jButtonSelectAllSQPick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllSQPickActionPerformed(evt);
            }
        });
        this.jButtonMoveSQPick.setText("Move...");
        this.jButtonMoveSQPick.setToolTipText("move picks to a different version");
        this.jButtonMoveSQPick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveSQPickActionPerformed(evt);
            }
        });
        this.jButtonSaveAsSQPick.setText("Save as...");
        this.jButtonSaveAsSQPick.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsSQPick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSaveAsSQPickActionPerformed(evt);
            }
        });
        this.jTableSQPicks.setModel((TableModel)this.tableSorterSQPicks);
        this.jTableSQPicks.setRowHeight(20);
        this.jTableSQPicks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableSQPicksMouseClicked(evt);
            }
        });
        this.jTableSQPicks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableSQPicksKeyPressed(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.jTableSQPicks);
        this.jButtonShowSQschemetScheme.setText("Show Scheme...");
        this.jButtonShowSQschemetScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonShowSQschemetSchemeActionPerformed(evt);
            }
        });
        this.jButtonCopySQPicks.setText("Copy...");
        this.jButtonCopySQPicks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopySQPicksActionPerformed(evt);
            }
        });
        GroupLayout jPanelSQPickLayout = new GroupLayout((Container)this.jPanelSQPick);
        this.jPanelSQPick.setLayout((LayoutManager)jPanelSQPickLayout);
        jPanelSQPickLayout.setHorizontalGroup((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().add((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((Component)this.jButtonSaveAsSQPick, -2, 85, -2).add((Component)this.jSeparator18, -2, 85, -2).add((Component)this.jSeparator19, -2, 85, -2).add((Component)this.jButtonDeleteSQPick, -2, 85, -2).add((Component)this.jButtonEditSQPick, -2, 85, -2).add((Component)this.jButtonAddSQPick, -2, 85, -2).add((Component)this.jButtonSelectAllSQPick, -2, 85, -2).add((Component)this.jButtonCopySQPicks, -2, 85, -2).add((Component)this.jButtonMoveSQPick, -2, 85, -2)).addPreferredGap(0).add((Component)this.jScrollPane6, -1, 594, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().add((Component)this.jButtonShowSQschemetScheme).addContainerGap()))));
        jPanelSQPickLayout.setVerticalGroup((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().addContainerGap().add((Component)this.jButtonShowSQschemetScheme).addPreferredGap(0).add((GroupLayout.Group)jPanelSQPickLayout.createParallelGroup(1).add((Component)this.jScrollPane6, -1, 479, Short.MAX_VALUE).add((GroupLayout.Group)jPanelSQPickLayout.createSequentialGroup().add((Component)this.jButtonAddSQPick).addPreferredGap(0).add((Component)this.jButtonEditSQPick).addPreferredGap(0).add((Component)this.jButtonDeleteSQPick).addPreferredGap(0).add((Component)this.jSeparator18, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllSQPick).addPreferredGap(0).add((Component)this.jButtonCopySQPicks).addPreferredGap(0).add((Component)this.jButtonMoveSQPick).addPreferredGap(0).add((Component)this.jSeparator19, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSaveAsSQPick).addContainerGap(250, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Sequence Picks", this.jPanelSQPick);
        this.jTableEnv.setModel((TableModel)this.tableSorterEnv);
        this.jTableEnv.setRowHeight(20);
        this.jTableEnv.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableEnvMouseClicked(evt);
            }
        });
        this.jTableEnv.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableEnvKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableEnv);
        this.jButtonAddPal.setText("Add...");
        this.jButtonAddPal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddPalActionPerformed(evt);
            }
        });
        this.jButtonEditPal.setText("Edit...");
        this.jButtonEditPal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditPalActionPerformed(evt);
            }
        });
        this.jButtonDeletePal.setText("Delete");
        this.jButtonDeletePal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeletePalActionPerformed(evt);
            }
        });
        this.jButtonSelectAllPal.setText("Select all");
        this.jButtonSelectAllPal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllPalActionPerformed(evt);
            }
        });
        this.jButtonCopyPal.setText("Copy...");
        this.jButtonCopyPal.setToolTipText("Copy seleced intervals to a different version");
        this.jButtonCopyPal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyPalActionPerformed(evt);
            }
        });
        this.jButtonMovePal.setText("Move...");
        this.jButtonMovePal.setToolTipText("Move selected intervals to a different version");
        this.jButtonMovePal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMovePalActionPerformed(evt);
            }
        });
        this.jButtonSaveAsPal.setText("Save as...");
        this.jButtonSaveAsPal.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsPal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSaveAsPalActionPerformed(evt);
            }
        });
        GroupLayout jPanelEnvLayout = new GroupLayout((Container)this.jPanelEnv);
        this.jPanelEnv.setLayout((LayoutManager)jPanelEnvLayout);
        jPanelEnvLayout.setHorizontalGroup((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEnvLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1).add((Component)this.jButtonDeletePal, -2, 83, -2).add((Component)this.jButtonEditPal, -2, 83, -2).add((Component)this.jButtonAddPal, -2, 83, -2).add((Component)this.jSeparator6, -2, 83, -2).add((Component)this.jButtonMovePal, -2, 83, -2).add((Component)this.jButtonCopyPal, -2, 83, -2).add((Component)this.jButtonSelectAllPal, -2, 83, -2).add((Component)this.jSeparator7, -2, 83, -2).add((Component)this.jButtonSaveAsPal, -2, 83, -2)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 596, Short.MAX_VALUE)));
        jPanelEnvLayout.setVerticalGroup((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEnvLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEnvLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 508, Short.MAX_VALUE).add((GroupLayout.Group)jPanelEnvLayout.createSequentialGroup().add((Component)this.jButtonAddPal).addPreferredGap(0).add((Component)this.jButtonEditPal).addPreferredGap(0).add((Component)this.jButtonDeletePal).addPreferredGap(0).add((Component)this.jSeparator6, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllPal).addPreferredGap(0).add((Component)this.jButtonCopyPal, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMovePal).addPreferredGap(0).add((Component)this.jSeparator7, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSaveAsPal).addContainerGap(279, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Palaeoenvironments", this.jPanelEnv);
        this.jTableComments.setModel((TableModel)this.tableSorterBiocom);
        this.jTableComments.setRowHeight(20);
        this.jTableComments.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableCommentsMouseClicked(evt);
            }
        });
        this.jTableComments.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableCommentsKeyPressed(evt);
            }
        });
        this.jScrollPaneComments.setViewportView(this.jTableComments);
        this.jButtonAddCom.setText("Add...");
        this.jButtonAddCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddComActionPerformed(evt);
            }
        });
        this.jButtonEditCom.setText("Edit...");
        this.jButtonEditCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditComActionPerformed(evt);
            }
        });
        this.jButtonDeleteCom.setText("Delete");
        this.jButtonDeleteCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteComActionPerformed(evt);
            }
        });
        this.jButtonSaveAsCom.setText("Save as...");
        this.jButtonSaveAsCom.setToolTipText("Save the comments as a CSV file, or to copy the text, select the row(s), press Ctrl-C, and Paste into your application");
        this.jButtonSaveAsCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSaveAsComActionPerformed(evt);
            }
        });
        this.jButtonCopyCom.setText("Copy...");
        this.jButtonCopyCom.setToolTipText("Copy selected comments to a different version");
        this.jButtonCopyCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyComActionPerformed(evt);
            }
        });
        this.jButtonMoveCom.setText("Move...");
        this.jButtonMoveCom.setToolTipText("Move selected comments to a different version");
        this.jButtonMoveCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveComActionPerformed(evt);
            }
        });
        this.jButtonSelectAllCom.setText("Select all");
        this.jButtonSelectAllCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllComActionPerformed(evt);
            }
        });
        this.jButtonCommentEvents.setText("Events...");
        this.jButtonCommentEvents.setToolTipText("Parse events from selected comments");
        this.jButtonCommentEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCommentEventsActionPerformed(evt);
            }
        });
        GroupLayout jPanelCommentsLayout = new GroupLayout((Container)this.jPanelComments);
        this.jPanelComments.setLayout((LayoutManager)jPanelCommentsLayout);
        jPanelCommentsLayout.setHorizontalGroup((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1, false).add((Component)this.jSeparator2).add((Component)this.jSeparator3).add((Component)this.jButtonSaveAsCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAllCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonMoveCom, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCommentEvents, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jScrollPaneComments, -1, 596, Short.MAX_VALUE)));
        jPanelCommentsLayout.setVerticalGroup((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelCommentsLayout.createParallelGroup(1).add((Component)this.jScrollPaneComments, -1, 508, Short.MAX_VALUE).add((GroupLayout.Group)jPanelCommentsLayout.createSequentialGroup().add((Component)this.jButtonAddCom).addPreferredGap(0).add((Component)this.jButtonEditCom).addPreferredGap(0).add((Component)this.jButtonDeleteCom).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllCom).addPreferredGap(0).add((Component)this.jButtonCopyCom, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveCom).addPreferredGap(0).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSaveAsCom).addPreferredGap(0).add((Component)this.jButtonCommentEvents).addContainerGap(-1, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Bio. Comments", this.jPanelComments);
        this.jTableIntComments.setModel((TableModel)this.tableSorterIntervalComments);
        this.jTableIntComments.setRowHeight(20);
        this.jTableIntComments.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableIntCommentsMouseClicked(evt);
            }
        });
        this.jTableIntComments.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableIntCommentsKeyPressed(evt);
            }
        });
        this.jScrollPaneIntComments.setViewportView(this.jTableIntComments);
        this.jButtonAddIntCom.setText("Add...");
        this.jButtonAddIntCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddIntComActionPerformed(evt);
            }
        });
        this.jButtonEditIntCom.setText("Edit...");
        this.jButtonEditIntCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditIntComActionPerformed(evt);
            }
        });
        this.jButtonDeleteIntCom.setText("Delete");
        this.jButtonDeleteIntCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteIntComActionPerformed(evt);
            }
        });
        this.jButtonSaveAsIntCom.setText("Save as...");
        this.jButtonSaveAsIntCom.setToolTipText(SAVEAS_TOOLTIP);
        this.jButtonSaveAsIntCom.setEnabled(false);
        this.jButtonCopyIntCom.setText("Copy...");
        this.jButtonCopyIntCom.setToolTipText("Copy selected comments to another version");
        this.jButtonCopyIntCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyIntComActionPerformed(evt);
            }
        });
        this.jButtonMoveIntCom.setText("Move...");
        this.jButtonMoveIntCom.setToolTipText("Move interval comments to a different version");
        this.jButtonMoveIntCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveIntComActionPerformed(evt);
            }
        });
        this.jButtonSelectAllIntCom.setText("Select all");
        this.jButtonSelectAllIntCom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllIntComActionPerformed(evt);
            }
        });
        GroupLayout jPanelIntCommentsLayout = new GroupLayout((Container)this.jPanelIntComments);
        this.jPanelIntComments.setLayout((LayoutManager)jPanelIntCommentsLayout);
        jPanelIntCommentsLayout.setHorizontalGroup((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIntCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add((Component)this.jSeparator16, -2, 83, -2).add((Component)this.jButtonSaveAsIntCom, -2, 83, -2).add((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add(2, (Component)this.jButtonEditIntCom, -2, 83, -2).add(2, (Component)this.jButtonDeleteIntCom, -2, 83, -2).add(2, (Component)this.jButtonAddIntCom, -2, 83, -2)).add((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add(2, (Component)this.jButtonSelectAllIntCom, -2, 83, -2).add(2, (Component)this.jButtonCopyIntCom, -2, 83, -2).add(2, (Component)this.jButtonMoveIntCom, -2, 83, -2))).addPreferredGap(0).add((Component)this.jScrollPaneIntComments, -1, 596, Short.MAX_VALUE)));
        jPanelIntCommentsLayout.setVerticalGroup((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelIntCommentsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelIntCommentsLayout.createParallelGroup(1).add((Component)this.jScrollPaneIntComments, -1, 508, Short.MAX_VALUE).add((GroupLayout.Group)jPanelIntCommentsLayout.createSequentialGroup().add((Component)this.jButtonAddIntCom).addPreferredGap(0).add((Component)this.jButtonEditIntCom).addPreferredGap(0).add((Component)this.jButtonDeleteIntCom).addPreferredGap(0).add((Component)this.jSeparator16, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllIntCom).addPreferredGap(0).add((Component)this.jButtonCopyIntCom, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveIntCom).add(22, 22, 22).add((Component)this.jButtonSaveAsIntCom).addContainerGap(279, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Interval Comments", this.jPanelIntComments);
        this.jTableEvents.setModel((TableModel)this.tableSorterEvents);
        this.jTableEvents.setRowHeight(20);
        this.jTableEvents.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableEventsMouseClicked(evt);
            }
        });
        this.jTableEvents.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableEventsKeyPressed(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.jTableEvents);
        this.jButtonAddEvent.setText("Add...");
        this.jButtonAddEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddEventActionPerformed(evt);
            }
        });
        this.jButtonDeleteEvent.setText("Delete");
        this.jButtonDeleteEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteEventActionPerformed(evt);
            }
        });
        this.jButtonGenerateEvents.setText("Generate...");
        this.jButtonGenerateEvents.setToolTipText("Generate events from occurrences");
        this.jButtonGenerateEvents.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonGenerateEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonGenerateEventsActionPerformed(evt);
            }
        });
        this.jButtonSelectAllEvents.setText("Select all");
        this.jButtonSelectAllEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSelectAllEventsActionPerformed(evt);
            }
        });
        this.jButtonMoveEvents.setText("Move...");
        this.jButtonMoveEvents.setToolTipText("Move selected events to a different version");
        this.jButtonMoveEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveEventsActionPerformed(evt);
            }
        });
        this.jButtonCopyEvents.setText("Copy...");
        this.jButtonCopyEvents.setToolTipText("Copy selected events to a different version");
        this.jButtonCopyEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyEventsActionPerformed(evt);
            }
        });
        this.jButtonEditEvent.setText("Edit...");
        this.jButtonEditEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditEventActionPerformed(evt);
            }
        });
        this.jButtonCreateComposite.setText("Composite...");
        this.jButtonCreateComposite.setToolTipText("<html>Create a new composite standard<br>based on this list of events</html>");
        this.jButtonCreateComposite.setMargin(new Insets(2, 6, 2, 6));
        this.jButtonCreateComposite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCreateCompositeActionPerformed(evt);
            }
        });
        this.jButtonEventComments.setText("Comments...");
        this.jButtonEventComments.setToolTipText("Create biostratigraphic comments from selected events");
        this.jButtonEventComments.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonEventComments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEventCommentsActionPerformed(evt);
            }
        });
        GroupLayout jPanelEventsLayout = new GroupLayout((Container)this.jPanelEvents);
        this.jPanelEvents.setLayout((LayoutManager)jPanelEventsLayout);
        jPanelEventsLayout.setHorizontalGroup((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1, false).add((Component)this.jButtonGenerateEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator14).add((Component)this.jSeparator15).add(2, (Component)this.jButtonCreateComposite, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEventComments, -1, 89, Short.MAX_VALUE).add((Component)this.jButtonMoveEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCopyEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSelectAllEvents, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteEvent, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditEvent, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddEvent, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jScrollPane5, -1, 590, Short.MAX_VALUE)));
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonCreateComposite, this.jButtonEventComments}, 1);
        jPanelEventsLayout.setVerticalGroup((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelEventsLayout.createParallelGroup(1).add((Component)this.jScrollPane5, -1, 508, Short.MAX_VALUE).add((GroupLayout.Group)jPanelEventsLayout.createSequentialGroup().add((Component)this.jButtonGenerateEvents).addPreferredGap(0).add((Component)this.jButtonAddEvent).addPreferredGap(0).add((Component)this.jButtonEditEvent).addPreferredGap(0).add((Component)this.jButtonDeleteEvent).addPreferredGap(0).add((Component)this.jSeparator14, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonSelectAllEvents).addPreferredGap(0).add((Component)this.jButtonCopyEvents).addPreferredGap(0).add((Component)this.jButtonMoveEvents).addPreferredGap(0).add((Component)this.jSeparator15, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonCreateComposite).addPreferredGap(0).add((Component)this.jButtonEventComments).addContainerGap()))));
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonAddEvent, this.jButtonDeleteEvent, this.jButtonEditEvent, this.jButtonGenerateEvents}, 2);
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonCopyEvents, this.jButtonMoveEvents, this.jButtonSelectAllEvents}, 2);
        jPanelEventsLayout.linkSize(new Component[]{this.jButtonCreateComposite, this.jButtonEventComments}, 2);
        this.jTabbedPaneInterpretations.addTab("Events", this.jPanelEvents);
        this.jTableLOC.setModel(this.tableModelLOC);
        this.jTableLOC.setRowHeight(20);
        this.jTableLOC.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableLOCKeyPressed(evt);
            }
        });
        this.jScrollPaneLOC.setViewportView(this.jTableLOC);
        this.jButtonAddLOC.setText("Add");
        this.jButtonAddLOC.setToolTipText("Add new LOC node");
        this.jButtonAddLOC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddLOCActionPerformed(evt);
            }
        });
        this.jButtonDeleteLOC.setText("Delete");
        this.jButtonDeleteLOC.setToolTipText("Delete selected LOC node");
        this.jButtonDeleteLOC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteLOCActionPerformed(evt);
            }
        });
        this.jButtonSaveAsLOC.setText("Save as...");
        this.jButtonSaveAsLOC.setToolTipText("Write LOC to .las file");
        this.jButtonSaveAsLOC.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveAsLOC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonSaveAsLOCActionPerformed(evt);
            }
        });
        this.jButtonCopyLOC.setText("Copy...");
        this.jButtonCopyLOC.setToolTipText("Copy entire LOC to a different version");
        this.jButtonCopyLOC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCopyLOCActionPerformed(evt);
            }
        });
        this.jButtonMoveLOC.setText("Move...");
        this.jButtonMoveLOC.setToolTipText("Move LOC to a different version");
        this.jButtonMoveLOC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonMoveLOCActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Line colour:");
        this.jTextFieldLOCColour.setEditable(false);
        this.jTextFieldLOCColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTextFieldLOCColourMouseClicked(evt);
            }
        });
        this.jButtonCreateSamples.setText("Create samples...");
        this.jButtonCreateSamples.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCreateSamples.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonCreateSamplesActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Display:"));
        this.buttonGroupAgeDisplay.add(this.jRadioButtonAgeFormatMA);
        this.jRadioButtonAgeFormatMA.setSelected(true);
        this.jRadioButtonAgeFormatMA.setText("Ma");
        this.jRadioButtonAgeFormatMA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jRadioButtonAgeFormatMAActionPerformed(evt);
            }
        });
        this.buttonGroupAgeDisplay.add(this.jRadioButtonAgeFormatKa);
        this.jRadioButtonAgeFormatKa.setText("Ka");
        this.jRadioButtonAgeFormatKa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jRadioButtonAgeFormatKaActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonAgeFormatMA).add((Component)this.jRadioButtonAgeFormatKa)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonAgeFormatMA).addPreferredGap(0).add((Component)this.jRadioButtonAgeFormatKa)));
        this.jLabelLOCAudit.setForeground(new Color(153, 153, 153));
        this.jLabelLOCAudit.setText("Created by: on:; Modified by: on:");
        GroupLayout jPanelLOCLayout = new GroupLayout((Container)this.jPanelLOC);
        this.jPanelLOC.setLayout((LayoutManager)jPanelLOCLayout);
        jPanelLOCLayout.setHorizontalGroup((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1, false).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(2).add((Component)this.jSeparator17, -2, 103, -2).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(2, false).add(1, (Component)this.jButtonCopyLOC, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonMoveLOC, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonSaveAsLOC, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonCreateSamples, -1, -1, Short.MAX_VALUE))).add((Component)this.jButtonDeleteLOC, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAddLOC, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().add((Component)this.jLabel10).addPreferredGap(0).add((Component)this.jTextFieldLOCColour, -2, 26, -2)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).add(8, 8, 8).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((Component)this.jLabelLOCAudit).add((Component)this.jScrollPaneLOC, -1, 560, Short.MAX_VALUE)).addContainerGap()));
        jPanelLOCLayout.setVerticalGroup((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().add((Component)this.jButtonAddLOC).addPreferredGap(0).add((Component)this.jButtonDeleteLOC).add(11, 11, 11).add((Component)this.jSeparator17, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonCopyLOC, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonMoveLOC).addPreferredGap(0).add((Component)this.jButtonSaveAsLOC).add(18, 18, 18).add((Component)this.jButtonCreateSamples).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanelLOCLayout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jTextFieldLOCColour, -2, -1, -2))).add((GroupLayout.Group)jPanelLOCLayout.createSequentialGroup().add((Component)this.jScrollPaneLOC, -1, 477, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabelLOCAudit))).addContainerGap()));
        this.jTabbedPaneInterpretations.addTab("LOC", this.jPanelLOC);
        this.jTableFaults.setModel((TableModel)this.tableSorterFaults);
        this.jTableFaults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JPanelWellInterp.this.jTableFaultsMouseClicked(evt);
            }
        });
        this.jTableFaults.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanelWellInterp.this.jTableFaultsKeyPressed(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableFaults);
        this.jButtonAddFault.setText("Add...");
        this.jButtonAddFault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonAddFaultActionPerformed(evt);
            }
        });
        this.jButtonEditFault.setText("Edit...");
        this.jButtonEditFault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonEditFaultActionPerformed(evt);
            }
        });
        this.jButtonDeleteFault.setText("Delete");
        this.jButtonDeleteFault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonDeleteFaultActionPerformed(evt);
            }
        });
        GroupLayout jPanelFaultsLayout = new GroupLayout((Container)this.jPanelFaults);
        this.jPanelFaults.setLayout((LayoutManager)jPanelFaultsLayout);
        jPanelFaultsLayout.setHorizontalGroup((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFaultsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((Component)this.jButtonAddFault).add((Component)this.jButtonEditFault).add((Component)this.jButtonDeleteFault)).addPreferredGap(0).add((Component)this.jScrollPane3, -1, 616, Short.MAX_VALUE)));
        jPanelFaultsLayout.setVerticalGroup((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFaultsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelFaultsLayout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 508, Short.MAX_VALUE).add((GroupLayout.Group)jPanelFaultsLayout.createSequentialGroup().add((Component)this.jButtonAddFault).addPreferredGap(0).add((Component)this.jButtonEditFault).addPreferredGap(0).add((Component)this.jButtonDeleteFault).addContainerGap(427, Short.MAX_VALUE)))));
        this.jTabbedPaneInterpretations.addTab("Faults", this.jPanelFaults);
        this.jButtonIGDHdrs.setText("Notes...");
        this.jButtonIGDHdrs.setToolTipText("Notes on use of schemes within interpretations");
        this.jButtonIGDHdrs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelWellInterp.this.jButtonIGDHdrsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jComboBoxVersion, -2, 121, -2).addPreferredGap(0).add((Component)this.jButtonVersionSelect, -2, 30, -2).addPreferredGap(1).add((Component)this.jButtonIGDHdrs).addContainerGap(-1, Short.MAX_VALUE)).add(2, (Component)this.jTabbedPaneInterpretations));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxVersion, -2, -1, -2).add((Component)this.jButtonVersionSelect).add((Component)this.jButtonIGDHdrs)).addPreferredGap(0).add((Component)this.jTabbedPaneInterpretations)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jComboBoxVersionActionPerformed(ActionEvent evt) {
        if (this.comboVersionLoading) {
            return;
        }
        if (this.jComboBoxVersion.getSelectedItem() == null || this.jComboBoxVersion.getSelectedItem().toString().equals(SELECT_STRING)) {
            return;
        }
        WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.well.loadInterp(wellInterp);
            wellInterp.getIGDSchemes(3);
            this.tableModelChrono.zones = wellInterp.getIGDList(3, 0);
            this.tableSorterChrono.reallocateIndexes();
            this.tableSorterChrono.fireTableDataChanged();
            wellInterp.getIGDSchemes(2);
            this.tableModelLstrat.zones = wellInterp.getIGDList(2, 0);
            this.tableSorterLstrat.reallocateIndexes();
            this.tableSorterLstrat.fireTableDataChanged();
            wellInterp.getIGDSchemes(4);
            this.tableModelBiozones.zones = wellInterp.getIGDList(4, 0);
            this.tableSorterBiozones.reallocateIndexes();
            this.tableSorterBiozones.fireTableDataChanged();
            this.tableModelBiocom.comments = wellInterp.getComments();
            this.tableSorterBiocom.reallocateIndexes();
            this.tableSorterBiocom.fireTableDataChanged();
            this.tableModelIntervalComments.comments = wellInterp.getIntcoms();
            this.tableSorterIntervalComments.reallocateIndexes();
            this.tableSorterIntervalComments.fireTableDataChanged();
            this.tableModelEnv.envs = wellInterp.getEnvs();
            this.tableSorterEnv.reallocateIndexes();
            this.tableSorterEnv.fireTableDataChanged();
            this.tableModelEvents.events = wellInterp.getEvents();
            this.tableSorterEvents.reallocateIndexes();
            this.tableSorterEvents.fireTableDataChanged();
            this.tableModelSQPicks.picks = wellInterp.getSQPicks();
            this.tableSorterSQPicks.reallocateIndexes();
            this.tableSorterSQPicks.fireTableDataChanged();
            this.tableModelFaults.faults = wellInterp.getFaults();
            this.tableSorterFaults.reallocateIndexes();
            this.tableSorterFaults.fireTableDataChanged();
            AgeFormat af = this.tableModelLOC.setLOC(wellInterp, this.jTableLOC, this.well.getWellID());
            this.setAgeFormatButton(af);
            this.tableModelLOC.fireTableDataChanged();
            if (wellInterp.getLOC() != null) {
                wellInterp.getLOC().addObserver((Observer)this);
                this.jLabelLOCAudit.setText(wellInterp.getLOC().getAudit().toString(this.sbdb, true));
            } else {
                this.jLabelLOCAudit.setText("");
            }
            if (this.tableModelLOC.getLOC() != null) {
                this.jTextFieldLOCColour.setBackground(this.tableModelLOC.getLOC().getColour());
            }
            Iterator it = wellInterp.getIGDSchemes(4).iterator();
            this.jComboBoxSchemeBio.removeAllItems();
            while (it.hasNext()) {
                this.jComboBoxSchemeBio.addItem(it.next());
            }
            this.jComboBoxSchemeBio.repaint();
            System.out.println("JPanelWellInterp adding observers to " + wellInterp);
            wellInterp.addObserver((Observer)this);
            wellInterp.addObserver((Observer)this.parentFrame.getSchemeChart());
            wellInterp.addObserver((Observer)this.parentPanel);
            this.parentPanel.setVersion(wellInterp);
            if (this.jComboBoxVersion.getItemAt(0).toString().equals(SELECT_STRING)) {
                this.jComboBoxVersion.removeItemAt(0);
                this.jComboBoxVersion.repaint();
            }
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonVersionSelectActionPerformed(ActionEvent evt) {
        try {
            DialogSelectVersion dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, this.sbdb.getProject(0));
            dialog.setLocation(this.jButtonVersionSelect.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                WellInterp wellInterp = this.well.getAddInterp(dialog.selection.get(0));
                for (int i = 0; i < this.jComboBoxVersion.getModel().getSize(); ++i) {
                    if (this.jComboBoxVersion.getModel().getElementAt(i) != wellInterp) continue;
                    this.jComboBoxVersion.setSelectedItem(wellInterp);
                    return;
                }
                this.jComboBoxVersion.addItem(wellInterp);
                this.jComboBoxVersion.setSelectedItem(wellInterp);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    private void jTableBiozonesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditBioActionPerformed(null);
        }
    }

    private void jButtonAddBioActionPerformed(ActionEvent evt) {
        IGDScheme scheme = (IGDScheme)this.jComboBoxSchemeBio.getSelectedItem();
        this.addZone(4, null, scheme);
    }

    private void jButtonEditBioActionPerformed(ActionEvent evt) {
        if (this.jTableBiozones.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalZone zone = this.tableModelBiozones.zones.get(this.tableSorterBiozones.getIndexOf(this.jTableBiozones.getSelectedRow()));
        this.editZone(zone);
    }

    private void jButtonDeleteBioActionPerformed(ActionEvent evt) {
        this.deleteZones(this.jTableBiozones, this.tableModelBiozones, this.tableSorterBiozones);
    }

    private void jButtonSelectAllBioActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableBiozones);
    }

    private void jComboBoxSchemeBioActionPerformed(ActionEvent evt) {
        if (this.jComboBoxVersion.getSelectedItem().getClass() == WellInterp.class) {
            WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
            int schemeID = 0;
            try {
                IGDScheme scheme = (IGDScheme)this.jComboBoxSchemeBio.getSelectedItem();
                schemeID = scheme.getID();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.tableModelBiozones.zones = wellInterp.getIGDList(4, schemeID);
            this.tableSorterBiozones.reallocateIndexes();
            this.tableSorterBiozones.fireTableDataChanged();
        }
    }

    private void jButtonAddChronoActionPerformed(ActionEvent evt) {
        this.addZone(3, null, null);
    }

    private void jButtonEditChronoActionPerformed(ActionEvent evt) {
        if (this.jTableChrono.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalZone zone = this.tableModelChrono.zones.get(this.tableSorterChrono.getIndexOf(this.jTableChrono.getSelectedRow()));
        this.editZone(zone);
    }

    private void jButtonDeleteChronoActionPerformed(ActionEvent evt) {
        this.deleteZones(this.jTableChrono, this.tableModelChrono, this.tableSorterChrono);
    }

    private void jButtonSelectAllChronoActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableChrono);
    }

    private void jTableChronoMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditChronoActionPerformed(null);
        }
    }

    private void jButtonAddLithActionPerformed(ActionEvent evt) {
        this.addZone(2, null, null);
    }

    private void jButtonEditLithActionPerformed(ActionEvent evt) {
        if (this.jTableLStrat.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalZone zone = this.tableModelLstrat.zones.get(this.tableSorterLstrat.getIndexOf(this.jTableLStrat.getSelectedRow()));
        this.editZone(zone);
    }

    private void jButtonDeleteLithActionPerformed(ActionEvent evt) {
        this.deleteZones(this.jTableLStrat, this.tableModelLstrat, this.tableSorterLstrat);
    }

    private void jButtonSelectAllLithActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableLStrat);
    }

    private void jTableLStratMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditLithActionPerformed(null);
        }
    }

    private void jButtonAddSQPickActionPerformed(ActionEvent evt) {
        this.addSQPick(null);
    }

    private void jButtonEditSQPickActionPerformed(ActionEvent evt) {
        int nRows = this.jTableSQPicks.getSelectedRowCount();
        if (nRows != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one pick from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        SQPick pick = this.tableModelSQPicks.picks.get(this.tableSorterSQPicks.getIndexOf(this.jTableSQPicks.getSelectedRow()));
        try {
            DialogSQPick dialog = new DialogSQPick(this.parentFrame, true, this.sbdb, null, this.well, wellInterp, this.units, pick, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error opening dialog", sql, this.sbdb);
        }
    }

    private void jButtonDeleteSQPickActionPerformed(ActionEvent evt) {
        int nRows = this.jTableSQPicks.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one or more picks from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        String msg = "Really delete ";
        msg = nRows == 1 ? msg + "this pick?" : msg + "these " + nRows + " picks?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        WellInterp wellInterp = this.getInterp();
        LinkedList<SQPick> toKill = new LinkedList<SQPick>();
        for (int row : this.jTableSQPicks.getSelectedRows()) {
            toKill.add(this.tableModelSQPicks.picks.get(this.tableSorterSQPicks.getIndexOf(row)));
        }
        try {
            for (SQPick pick : toKill) {
                wellInterp.deleteSQPick(pick, this.well.getWellID());
                this.sbdb.commit();
            }
            this.jTableSQPicks.clearSelection();
            wellInterp.notifyObservers((Object)21);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error deleting sequence picks", ex, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectAllSQPickActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableSQPicks);
    }

    private void jTableSQPicksMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditSQPickActionPerformed(null);
        }
    }

    private void jTableEventsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditEventActionPerformed(null);
        }
    }

    private void jButtonAddEventActionPerformed(ActionEvent evt) {
        this.addEvent(null, null);
    }

    private void jButtonDeleteEventActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one or more event from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        String msg = "Really delete ";
        msg = nRows == 1 ? msg + "this event?" : msg + "these " + nRows + " events?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<WellEvent> toKill = new LinkedList<WellEvent>();
        for (int row : this.jTableEvents.getSelectedRows()) {
            toKill.add(this.tableModelEvents.events.get(this.tableSorterEvents.getIndexOf(row)));
        }
        try {
            for (WellEvent event : toKill) {
                wellInterp.deleteEvent(event, this.well.getWellID());
                this.sbdb.commit();
            }
            this.jTableEvents.clearSelection();
            wellInterp.notifyObservers((Object)20);
        }
        catch (SBException ex) {
            FrameJsbugs.showStackError("Error deleting events", (Exception)((Object)ex), this.sbdb);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error deleting events", ex, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonGenerateEventsActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogGenerateEvent dialog = new DialogGenerateEvent(this.parentFrame, true, this.sbdb, this.well, wellInterp);
            dialog.setLocationRelativeTo(this.jButtonGenerateEvents);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
        catch (SBException e) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)e));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectAllEventsActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableEvents);
    }

    private void jButtonEditEventActionPerformed(ActionEvent evt) {
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one event from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getInterp();
        WellEvent wellEvent = this.tableModelEvents.events.get(this.tableSorterEvents.getIndexOf(this.jTableEvents.getSelectedRow()));
        DialogWellEvent dialog = new DialogWellEvent(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, wellEvent, null, null, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jTableEnvMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditPalActionPerformed(null);
        }
    }

    private void jButtonAddPalActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            Sample topSample = this.parentPanel.getSelectedTopSample();
            Sample baseSample = this.parentPanel.getSelectedBaseSample();
            DialogEnv dialog = new DialogEnv(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, null, topSample, baseSample);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonEditPalActionPerformed(ActionEvent evt) {
        if (this.jTableEnv.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one interval to edit", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDIntervalEnv zone = this.tableModelEnv.envs.get(this.tableSorterEnv.getIndexOf(this.jTableEnv.getSelectedRow()));
        try {
            WellInterp wellInterp = this.getInterp();
            DialogEnv dialog = new DialogEnv(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, zone, null, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonDeletePalActionPerformed(ActionEvent evt) {
        int nRows = this.jTableEnv.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select interval(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        String msg = "Really delete ";
        msg = nRows == 1 ? msg + "this interval?" : msg + "these " + nRows + " intervals?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<IGDIntervalEnv> toKill = new LinkedList<IGDIntervalEnv>();
        for (int row : this.jTableEnv.getSelectedRows()) {
            toKill.add(this.tableModelEnv.envs.get(this.tableSorterEnv.getIndexOf(row)));
        }
        try {
            for (IGDIntervalEnv env : toKill) {
                wellInterp.deleteEnv(env, this.well.getWellID());
                this.sbdb.commit();
            }
            this.jTableEnv.clearSelection();
            wellInterp.notifyObservers((Object)5);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error deleting environment intervals", ex, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectAllPalActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableEnv);
    }

    private void jTableCommentsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditComActionPerformed(null);
        }
    }

    private void jButtonAddComActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            Sample topSample = this.parentPanel.getSelectedTopSample();
            Sample baseSample = this.parentPanel.getSelectedBaseSample();
            DialogBiocom dialog = new DialogBiocom(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, null, topSample, baseSample);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.parentPanel.clearSampleSelection();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)sbe));
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonEditComActionPerformed(ActionEvent evt) {
        int nRows = this.jTableComments.getSelectedRowCount();
        if (nRows != 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select one comment from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            Biocom biocom = this.tableModelBiocom.comments.get(this.tableSorterBiocom.getIndexOf(this.jTableComments.getSelectedRow()));
            WellInterp wellInterp = this.getInterp();
            DialogBiocom dialog = new DialogBiocom(this.parentFrame, true, this.sbdb, this.well, wellInterp, this.units, biocom, null, null);
            dialog.setLocation(this.jButtonEditCom.getLocationOnScreen());
            dialog.setVisible(true);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonDeleteComActionPerformed(ActionEvent evt) {
        int nRows = this.jTableComments.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select comment(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        String msg = "Really delete ";
        msg = nRows == 1 ? msg + "this comment?" : msg + "these " + nRows + " comments?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<Biocom> toKill = new LinkedList<Biocom>();
        for (int row : this.jTableComments.getSelectedRows()) {
            toKill.add(this.tableModelBiocom.comments.get(this.tableSorterBiocom.getIndexOf(row)));
        }
        try {
            for (Biocom biocom : toKill) {
                wellInterp.deleteBiocom(this.well.getWellID(), biocom);
                this.sbdb.commit();
            }
            this.jTableComments.clearSelection();
            wellInterp.notifyObservers((Object)19);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error deleting biostrat comments", ex, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectAllComActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableComments);
    }

    private void jTableIntCommentsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditIntComActionPerformed(null);
        }
    }

    private void jButtonAddIntComActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        DialogIntervalComment dialog = new DialogIntervalComment(this.parentFrame, true, this.sbdb, this.well, wellInterp, null, this.units);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private WellInterp getSelectedVersion() {
        Object o = this.jComboBoxVersion.getSelectedItem();
        if (o != null && o instanceof WellInterp) {
            return (WellInterp)o;
        }
        JOptionPane.showMessageDialog(this, "Select a version", this.parentFrame.getTitle(), 2);
        return null;
    }

    private void jButtonEditIntComActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Intcom intcom = this.tableModelIntervalComments.comments.get(this.tableSorterIntervalComments.getIndexOf(this.jTableIntComments.getSelectedRow()));
        DialogIntervalComment dialog = new DialogIntervalComment(this.parentFrame, true, this.sbdb, this.well, wellInterp, intcom, this.units);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonDeleteIntComActionPerformed(ActionEvent evt) {
        int nRows = this.jTableIntComments.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select comment(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        String msg = "Really delete ";
        msg = nRows == 1 ? msg + "this comment?" : msg + "these " + nRows + " comments?";
        if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getSelectedItem();
        LinkedList<Intcom> toKill = new LinkedList<Intcom>();
        for (int row : this.jTableIntComments.getSelectedRows()) {
            toKill.add(this.tableModelIntervalComments.comments.get(this.tableSorterIntervalComments.getIndexOf(row)));
        }
        try {
            for (Intcom intcom : toKill) {
                wellInterp.deleteIntcom(this.well.getWellID(), intcom);
                this.sbdb.commit();
            }
            this.jTableIntComments.clearSelection();
            wellInterp.notifyObservers((Object)22);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error deleting interval comment", ex, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectAllIntComActionPerformed(ActionEvent evt) {
        SB.selectAllFocus((JTable)this.jTableIntComments);
    }

    private void jButtonAddLOCActionPerformed(ActionEvent evt) {
        if (this.tableModelLOC.getLOC() == null) {
            JOptionPane.showMessageDialog(this, "No LOC defined, use the Depth vs Age chart & right-click to create a new LOC.", this.parentFrame.getTitle(), 1);
            return;
        }
        DialogLOCnode dialog = new DialogLOCnode(this.parentFrame, true, this.units, this.well, this.getInterp(), this.tableModelLOC.getAgeFormat());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.tableModelLOC.fireTableDataChanged();
    }

    private void jButtonDeleteLOCActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null || this.tableModelLOC.getLOC() == null) {
            return;
        }
        int nRows = this.jTableLOC.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select node(s) to delete", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            if (this.tableModelLOC.getRowCount() == nRows) {
                if (JOptionPane.showConfirmDialog(this.parentFrame, "Delete this LOC?", this.parentFrame.getTitle(), 0, 3) != 0) {
                    return;
                }
                wellInterp.deleteLOC(this.well.getWellID());
                this.sbdb.commit();
                AgeFormat af = this.tableModelLOC.setLOC(wellInterp, this.jTableLOC, this.well.getWellID());
                this.setAgeFormatButton(af);
            } else {
                if (this.tableModelLOC.getRowCount() - nRows < 2) {
                    JOptionPane.showMessageDialog(this.parentFrame, "You must leave at least 2 nodes.", this.parentFrame.getTitle(), 2);
                    return;
                }
                String msg = "Really delete ";
                msg = nRows == 1 ? msg + "this node?" : msg + "these " + nRows + " nodes?";
                if (JOptionPane.showConfirmDialog(this.parentFrame, msg, this.parentFrame.getTitle(), 0, 3) != 0) {
                    return;
                }
                LinkedList<LOC.LOCNode> toKill = new LinkedList<LOC.LOCNode>();
                for (int row : this.jTableLOC.getSelectedRows()) {
                    toKill.add(this.tableModelLOC.getLOC().getNode(row));
                }
                for (LOC.LOCNode locNode : toKill) {
                    try {
                        wellInterp.deleteLOCNode(locNode, this.well.getWellID());
                    }
                    catch (InvalidFieldException ife) {
                        JOptionPane.showMessageDialog(this, ife.getMessage(), "Delete LOC nodes", 2);
                    }
                }
            }
            this.jTableLOC.clearSelection();
            wellInterp.notifyObservers((Object)23);
            this.tableModelLOC.fireTableDataChanged();
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTextFieldLOCColourMouseClicked(MouseEvent evt) {
        Color locColour;
        if (this.tableModelLOC.getLOC() != null && evt.getClickCount() > 1 && (locColour = JColorChooser.showDialog(this.parentFrame, "Select LOC colour", this.jTextFieldLOCColour.getBackground())) != null) {
            try {
                this.tableModelLOC.getLOC().setColour(locColour, this.well.getWellID(), this.getInterp().getHeader().getInterpID());
                this.jTextFieldLOCColour.setBackground(locColour);
                this.sbdb.commit();
            }
            catch (SQLException sqle) {
                FrameJsbugs.showStackError("SQL Error", sqle, this.sbdb);
            }
        }
    }

    private void jButtonMoveChronoActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableChrono, this.tableModelChrono, this.tableSorterChrono, true);
    }

    private void jButtonMoveBioActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableBiozones, this.tableModelBiozones, this.tableSorterBiozones, true);
    }

    private void jButtonMoveLithActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableLStrat, this.tableModelLstrat, this.tableSorterLstrat, true);
    }

    private void jButtonMoveSQPickActionPerformed(ActionEvent evt) {
        this.copySQPicks(true);
    }

    private void jButtonMoveEventsActionPerformed(ActionEvent evt) {
        this.copyEvents(true);
    }

    private void jButtonChronoColmapActionPerformed(ActionEvent evt) {
        this.showColMap(3);
    }

    private void jButtonBioColmapActionPerformed(ActionEvent evt) {
        this.showColMap(4);
    }

    private void jButtonLstratColmapActionPerformed(ActionEvent evt) {
        this.showColMap(2);
    }

    private void jButtonCreateCompositeActionPerformed(ActionEvent evt) {
        if (this.tableModelEvents.events.isEmpty()) {
            JOptionPane.showMessageDialog(this.parentFrame, "No events in list. Composite not created.", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            DialogCmpStd dialog = new DialogCmpStd((Frame)this.parentFrame, true, this.sbdb, null);
            dialog.loadWellEvents(this.getInterp());
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening composite standard dialog", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening composite standard dialog", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCopyLOCActionPerformed(ActionEvent evt) {
        this.copyLOC(false);
    }

    private void jButtonMoveLOCActionPerformed(ActionEvent evt) {
        this.copyLOC(true);
    }

    private void jTableChronoKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteChronoActionPerformed(null);
        }
    }

    private void jTableBiozonesKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteBioActionPerformed(null);
        }
    }

    private void jTableLStratKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteLithActionPerformed(null);
        }
    }

    private void jTableSQPicksKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteSQPickActionPerformed(null);
        }
    }

    private void jTableEventsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteEventActionPerformed(null);
        }
    }

    private void jTableEnvKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeletePalActionPerformed(null);
        }
    }

    private void jTableCommentsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteComActionPerformed(null);
        }
    }

    private void jTableIntCommentsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteIntComActionPerformed(null);
        }
    }

    private void jTableLOCKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteLOCActionPerformed(null);
        }
    }

    private void jButtonCopyChronoActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableChrono, this.tableModelChrono, this.tableSorterChrono, false);
    }

    private void jButtonCopyBioActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableBiozones, this.tableModelBiozones, this.tableSorterBiozones, false);
    }

    private void jButtonCopyLithActionPerformed(ActionEvent evt) {
        this.moveZones(this.jTableLStrat, this.tableModelLstrat, this.tableSorterLstrat, false);
    }

    private void jButtonCopyComActionPerformed(ActionEvent evt) {
        this.copyBiocom(false);
    }

    private void jButtonMoveComActionPerformed(ActionEvent evt) {
        this.copyBiocom(true);
    }

    private void jButtonCopyPalActionPerformed(ActionEvent evt) {
        this.copyPalenv(false);
    }

    private void jButtonMovePalActionPerformed(ActionEvent evt) {
        this.copyPalenv(true);
    }

    private void jButtonFillChronoHierachyActionPerformed(ActionEvent evt) {
        this.fillHierarchy(this.jTableChrono, this.tableModelChrono, this.tableSorterChrono);
    }

    private void jButtonFillBiozoneHierachyActionPerformed(ActionEvent evt) {
        this.fillHierarchy(this.jTableBiozones, this.tableModelBiozones, this.tableSorterBiozones);
    }

    private void jButtonFillLstratHierachyActionPerformed(ActionEvent evt) {
        this.fillHierarchy(this.jTableLStrat, this.tableModelLstrat, this.tableSorterLstrat);
    }

    private void jButtonSaveAsComActionPerformed(ActionEvent evt) {
        if (!this.canExport()) {
            return;
        }
        if (this.tableModelBiocom.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No data to save", "Comments", 1);
            return;
        }
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.sbdb, (String)"JBCFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                char delim;
                String fileName = jFileChooser1.getSelectedFile().getPath();
                if (jFileChooser1.getFileFilter().accept(new File("1.csv"))) {
                    if (fileName.toLowerCase().indexOf(".csv") < 0) {
                        fileName = fileName + ".csv";
                    }
                    delim = ',';
                } else {
                    if (fileName.toLowerCase().indexOf(".txt") < 0) {
                        fileName = fileName + ".txt";
                    }
                    delim = '\t';
                }
                DecimalFormat nFormat = new DecimalFormat("#####0.0##");
                FileWriter out = new FileWriter(fileName);
                boolean askCores = false;
                boolean askCuttings = false;
                boolean useCoreCorrections = false;
                boolean useCuttingCorrections = false;
                for (Biocom comment : this.tableModelBiocom.comments) {
                    int option;
                    if (comment.getTopSample().getType().equals("CO") && !askCores) {
                        askCores = true;
                        if (this.well.getCoreShift().getSize() > 0) {
                            option = JOptionPane.showConfirmDialog(this.parentFrame, "Do you want to output core-corrected depths for Core samples?", this.parentFrame.getTitle(), 1, 3);
                            if (option == 2) {
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (option == 0) {
                                useCoreCorrections = true;
                            }
                        }
                    } else if (comment.getTopSample().getType().equals("CU") && !askCuttings) {
                        askCuttings = true;
                        if (this.well.getCoreShift().getSize() > 0) {
                            option = JOptionPane.showConfirmDialog(this.parentFrame, "Do you want to output core-corrected depths for Cuttings?", this.parentFrame.getTitle(), 1, 3);
                            if (option == 2) {
                                this.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                            if (option == 0) {
                                useCuttingCorrections = true;
                            }
                        }
                    }
                    out.write(this.well.getWellCode() + delim + comment.getDiscipline().getNoun() + delim + nFormat.format(this.well.getDepth(comment.getTopSample(), this.units, useCoreCorrections, useCuttingCorrections)) + delim + (comment.getBaseSample() != null ? "" + nFormat.format(this.well.getDepth(comment.getBaseSample(), this.units, useCoreCorrections, useCuttingCorrections)) : "") + delim + comment.getAnalystString() + delim + "\"" + comment.getText().replace('\n', ' ') + "\"" + delim + (comment.getSource() != null ? comment.getSource() : "") + delim + "\r\n");
                }
                out.close();
                JOptionPane.showMessageDialog(this, "File written ");
                Lastval.putString((SBdb)this.sbdb, (String)"JBCFILE", (String)fileName);
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
            catch (SBException ex) {
                JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonAddFaultActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        Sample sample = null;
        try {
            sample = this.parentPanel.getSelectedSample();
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error getting samples", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        DialogFault dialog = new DialogFault(this.parentFrame, true, null, this.well, this.units, wellInterp, this.sbdb, sample);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonEditFaultActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        int nRows = this.jTableFaults.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select a fault from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        Fault selectedFault = this.tableModelFaults.faults.get(this.jTableFaults.getSelectedRow());
        DialogFault dialog = new DialogFault(this.parentFrame, true, selectedFault, this.well, this.units, wellInterp, this.sbdb, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.tableSorterFaults.reallocateIndexes();
            this.tableSorterFaults.fireTableDataChanged();
        }
    }

    private void jButtonDeleteFaultActionPerformed(ActionEvent evt) {
        int nRows = this.jTableFaults.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select one or more faults from the list", this.parentFrame.getTitle(), 2);
            return;
        }
        String msg = "Really delete ";
        msg = nRows == 1 ? msg + "this fault?" : msg + "these " + nRows + " faults?";
        if (JOptionPane.showConfirmDialog(this, msg, "Delete Faults", 0, 3) != 0) {
            return;
        }
        LinkedList<Fault> toKill = new LinkedList<Fault>();
        for (int row : this.jTableFaults.getSelectedRows()) {
            toKill.add(this.tableModelFaults.faults.get(this.tableSorterFaults.getIndexOf(row)));
        }
        try {
            for (Fault fault : toKill) {
                this.getInterp().deleteFault(fault, this.well.getWellID());
                this.sbdb.commit();
            }
            this.jTableFaults.clearSelection();
            this.getInterp().notifyObservers(Fault.class);
            this.tableSorterFaults.reallocateIndexes();
            this.tableSorterFaults.fireTableDataChanged();
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error deleting fault", ex, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTableFaultsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditFaultActionPerformed(null);
        }
    }

    private void jTableFaultsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            this.jButtonDeleteFaultActionPerformed(null);
        }
    }

    private void jButtonCreateSamplesActionPerformed(ActionEvent evt) {
        if (this.tableModelLOC.getLOC() == null) {
            JOptionPane.showMessageDialog(this.parentFrame, "No LOC defined.", this.parentFrame.getTitle(), 1);
            return;
        }
        boolean hasUnconf = false;
        LOC loc = this.tableModelLOC.getLOC();
        Iterator it = loc.getNodeIterator();
        while (it.hasNext()) {
            LOC.LOCNode node = (LOC.LOCNode)it.next();
            if (node.getBnd() != 4) continue;
            hasUnconf = true;
            break;
        }
        if (!hasUnconf) {
            JOptionPane.showMessageDialog(this.parentFrame, "No LOG samples created - unconformities defined.", this.parentFrame.getTitle(), 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(this.parentFrame, "This option creates a LOG pick sample at each unconformity on the LOC, to allow the unconformity to be picked as at a surface or boundary.\nContinue?", this.parentFrame.getTitle(), 0, 3) != 0) {
            return;
        }
        it = loc.getNodeIterator();
        int nAdded = 0;
        try {
            Sample lastSample = null;
            while (it.hasNext()) {
                LOC.LOCNode node = (LOC.LOCNode)it.next();
                if (node.getBnd() != 4 || this.well.getSample(Double.valueOf(node.getDepth()), Double.valueOf(node.getDepth()), "LOG") != null) continue;
                lastSample = this.well.addSample(Double.valueOf(node.getDepth()), Double.valueOf(node.getDepth()), "LOG", null);
                ++nAdded;
            }
            if (nAdded > 0) {
                this.sbdb.commit();
                JOptionPane.showMessageDialog(this.parentFrame, "" + nAdded + " Samples added.", this.parentFrame.getTitle(), 1);
                this.well.notifyObservers(lastSample);
            } else {
                JOptionPane.showMessageDialog(this.parentFrame, "No samples needed to be added.", this.parentFrame.getTitle(), 1);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.sbdb.doRollback();
        }
    }

    private void jButtonShowChronoSchemeActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            List schemes = wellInterp.getIGDSchemes(3);
            for (IGDScheme scheme : schemes) {
                this.parentFrame.addChartScheme(scheme);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jButtonShowSchemeBiozoneActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        IGDScheme scheme = (IGDScheme)this.jComboBoxSchemeBio.getSelectedItem();
        if (scheme == null) {
            JOptionPane.showMessageDialog(this, "Select a Scheme", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            this.parentFrame.addChartScheme(scheme);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jButtonShowLstratSchemeActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            List schemes = wellInterp.getIGDSchemes(2);
            for (IGDScheme scheme : schemes) {
                this.parentFrame.addChartScheme(scheme);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jButtonShowSQschemetSchemeActionPerformed(ActionEvent evt) {
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            List schemes = wellInterp.getIGDSchemes(10);
            for (IGDScheme scheme : schemes) {
                this.parentFrame.addChartScheme(scheme);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jButtonCopyEventsActionPerformed(ActionEvent evt) {
        this.copyEvents(false);
    }

    private void jButtonSaveAsLOCActionPerformed(ActionEvent evt) {
        if (!this.canExport()) {
            return;
        }
        LOC loc = this.getInterp().getLOC();
        if (loc == null) {
            JOptionPane.showMessageDialog(this, "No LOC to save", "Save LOC", 2);
            return;
        }
        if (loc.getSize() == 0) {
            JOptionPane.showMessageDialog(this, "LOC is empty", "Save LOC", 2);
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("las");
        filter.setDescription("LAS files");
        fileChooser.setFileFilter((FileFilter)filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.sbdb, (String)"WINLASFILE", (String)"UNXLASFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
            setDir = new File(".");
        }
        try {
            fileChooser.setCurrentDirectory(setDir);
        }
        catch (Exception ex1) {
            // empty catch block
        }
        if (fileChooser.showSaveDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            if (file.exists() && JOptionPane.showConfirmDialog(this, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (!file.getName().toLowerCase().endsWith("las")) {
                String rootName = file.getName();
                file = new File(file.getPath() + ".las");
            } else {
                String rootName = file.getName().substring(0, file.getName().length() - 4);
            }
            try {
                Lastval.putString((SBdb)this.sbdb, (String)"WINLASFILE", (String)"UNXLASFILE", (String)file.getPath());
                this.sbdb.commit();
                String fileName = file.getPath();
                String UWI = this.parentPanel.well.getWellName();
                if (UWI.indexOf("_SUMLOG") > 0) {
                    UWI = UWI.substring(0, UWI.indexOf("_SUMLOG"));
                }
                if (UWI.charAt(4) == '/') {
                    if (UWI.charAt(5) == '0') {
                        UWI = UWI.replaceAll("/0", "/");
                    }
                    if (UWI.substring(4).indexOf("-0") > 0) {
                        UWI = UWI.substring(0, UWI.indexOf("-0")) + "-" + UWI.substring(UWI.indexOf("-0") + 2);
                    }
                }
                if (this.parentPanel.well.getHeader().getCountry().startsWith("NO")) {
                    UWI = "NO " + UWI;
                }
                if ((UWI = JOptionPane.showInputDialog(this, "Enter Unique Well Identifier (UWI) to embed in file header: ", UWI)) == null) {
                    return;
                }
                new LASFile(fileName, this.sbdb, this.getInterp().getLOC(), this.parentPanel.well, this.units, UWI);
                JOptionPane.showMessageDialog(this, "File : '" + file.getPath() + "' written", "Write LAS", 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void jButtonEventCommentsActionPerformed(ActionEvent evt) {
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select event(s)", this.parentFrame.getTitle(), 2);
            return;
        }
        LinkedList<WellEvent> events = new LinkedList<WellEvent>();
        for (int row : this.jTableEvents.getSelectedRows()) {
            events.add(this.tableModelEvents.events.get(this.tableSorterEvents.getIndexOf(row)));
        }
        this.generateCommentsFromEvents(events);
    }

    private void jButtonSaveAsPalActionPerformed(ActionEvent evt) {
        if (!this.canExport()) {
            return;
        }
        if (this.tableModelEnv.envs.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No data to save", "IGD", 1);
            return;
        }
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.sbdb, (String)"JIGDEFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = System.getProperty("os.name").equals("SunOS") ? new File("~/") : new File("\\My Documents");
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        String FULLCSV = "CSV files, all columns";
        filter.setDescription("CSV files, all columns");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        filter = new SbugsFileFilter();
        filter.addExtension("csv");
        String PAIRCSV = "CSV files, pair of numerical columns";
        filter.setDescription("CSV files, pair of numerical columns");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        filter = new SbugsFileFilter();
        filter.addExtension("txt");
        String TABBED = "TAB delmited text files, all columns";
        filter.setDescription("TAB delmited text files, all columns");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                String fileName = jFileChooser1.getSelectedFile().getPath();
                String filterString = jFileChooser1.getFileFilter().getDescription();
                char delim = '\t';
                if (jFileChooser1.getFileFilter().accept(new File("1.csv"))) {
                    if (fileName.toLowerCase().indexOf(".csv") < 0) {
                        fileName = fileName + ".csv";
                    }
                    delim = ',';
                } else if (fileName.toLowerCase().indexOf(".txt") < 0) {
                    fileName = fileName + ".txt";
                }
                DecimalFormat nFormat = new DecimalFormat("#####0.0##");
                FileWriter out = new FileWriter(fileName);
                Iterator<IGDIntervalEnv> en = this.tableModelEnv.envs.iterator();
                int lastDepth = -99999;
                while (en.hasNext()) {
                    IGDIntervalEnv zone = en.next();
                    if (filterString.startsWith("CSV files, pair of numerical columns")) {
                        int intDepth = (int)zone.getTopSample().getDepth(this.units) * 100;
                        if (intDepth != lastDepth) {
                            out.write(this.well.getWellCode() + delim + nFormat.format(zone.getTopSample().getDepth(this.units)) + delim + zone.getUp() + delim + zone.getUd() + "\r\n");
                            lastDepth = intDepth;
                        }
                        if ((intDepth = (int)zone.getBaseSample().getDepth(this.units) * 100) == lastDepth) continue;
                        out.write(this.well.getWellCode() + delim + nFormat.format(zone.getBaseSample().getDepth(this.units)) + delim + zone.getLp() + delim + zone.getLd() + "\r\n");
                        lastDepth = intDepth;
                        continue;
                    }
                    out.write(this.well.getWellCode() + delim + nFormat.format(zone.getTopSample().getDepth(this.units)) + delim + zone.getTopSample().getType() + delim + nFormat.format(zone.getBaseSample().getDepth(this.units)) + delim + zone.getBaseSample().getType() + delim + zone.toString() + delim + (zone.getModifier() > 0 ? this.sbdb.getUser(zone.getModifier()) : "") + delim + (zone.getModified() != null ? df.format(zone.getModified()) : "") + delim + "\r\n");
                }
                out.close();
                JOptionPane.showMessageDialog(this, "File written ");
                Lastval.putString((SBdb)this.sbdb, (String)"JIGDEFILE", (String)fileName);
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonCopyIntComActionPerformed(ActionEvent evt) {
        this.copyIntcoms(false);
    }

    private void jButtonMoveIntComActionPerformed(ActionEvent evt) {
        this.copyIntcoms(true);
    }

    private void jButtonSaveAsChronoActionPerformed(ActionEvent evt) {
        this.saveOW(3);
    }

    private void jButtonSaveAsBioActionPerformed(ActionEvent evt) {
        this.saveOW(4);
    }

    private void jButtonSaveAsLithActionPerformed(ActionEvent evt) {
        this.saveOW(2);
    }

    private void jButtonSaveAsSQPickActionPerformed(ActionEvent evt) {
        this.saveOWSQPicks();
    }

    private void jButtonCopySQPicksActionPerformed(ActionEvent evt) {
        this.copySQPicks(false);
    }

    private void jRadioButtonAgeFormatMAActionPerformed(ActionEvent evt) {
        this.setAgeFormatTable(AgeFormat.MA);
    }

    private void jRadioButtonAgeFormatKaActionPerformed(ActionEvent evt) {
        this.setAgeFormatTable(AgeFormat.KA);
    }

    private void jButtonIGDHdrsActionPerformed(ActionEvent evt) {
        if (this.getInterp() == null) {
            JOptionPane.showMessageDialog(this.parentFrame, "No version selected");
            return;
        }
        try {
            DialogIGDHdrs dialog = new DialogIGDHdrs((Frame)this.parentFrame, true, this.well, this.getInterp());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SBException ex) {
            SB.showStackError((String)ex.toString(), (Exception)((Object)ex));
        }
    }

    private void jButtonCommentEventsActionPerformed(ActionEvent evt) {
        try {
            int opt;
            WellInterp interp = this.getInterp();
            if (interp.getComments().isEmpty()) {
                JOptionPane.showMessageDialog(this, "No comments to parse!", "Parse Events", 2);
                return;
            }
            LinkedList<Biocom> use = new LinkedList<Biocom>();
            if (this.jTableComments.getSelectedRowCount() > 0 && (opt = JOptionPane.showConfirmDialog(this, "Use selected comments only?", "Parse Events", 0)) == 0) {
                for (int row : this.jTableComments.getSelectedRows()) {
                    use.add(this.tableModelBiocom.comments.get(this.tableSorterBiocom.getIndexOf(row)));
                }
            }
            if (use.isEmpty()) {
                use.addAll(this.getInterp().getComments());
            }
            DialogSelectCmpStd dialog = new DialogSelectCmpStd((Frame)this.parentFrame, true, this.sbdb, true);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection == null) {
                return;
            }
            interp.generateEventsFromComments(use, dialog.selection, this.well);
            this.sbdb.commit();
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), "Error", 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void generateCommentsFromEvents(List<WellEvent> events) {
        DialogEventComments dialog = new DialogEventComments((Frame)this.parentFrame, true, this.sbdb);
        dialog.setLocationRelativeTo(this.parentFrame);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        Biocom newComm = null;
        WellInterp interp = this.getInterp();
        int nUpdated = 0;
        int nCreated = 0;
        for (WellEvent event : events) {
            Discipline discID = !DialogEventComments.override && event.getDiscipline() != null ? event.getDiscipline() : dialog.discID;
            assert (discID != null);
            String analyst = !DialogEventComments.override && event.getAnalystString() != null && !event.getAnalystString().isEmpty() ? event.getAnalystString() : dialog.analyst;
            try {
                Biocom found = null;
                List existing = interp.getComments(discID.getChar());
                for (Biocom biocom : existing) {
                    if (biocom.getTopID() != event.getSampID() || !biocom.getAnalystString().equals(analyst)) continue;
                    found = biocom;
                    break;
                }
                String text = event.toString(true, DialogEventComments.includeQualifiers, false);
                if (DialogEventComments.includeComments && event.getComments() != null && !event.getComments().trim().isEmpty()) {
                    text = text + " - " + event.getComments();
                }
                if (DialogEventComments.includeCompany && event.getSource() != null && !event.getSource().trim().isEmpty()) {
                    text = text + " - Source: " + event.getSource();
                }
                if (DialogEventComments.includeCompany && event.getCompany() != null && !event.getCompany().trim().isEmpty()) {
                    text = text + " - Company: " + event.getCompany();
                }
                if (found != null) {
                    newComm = interp.updateBiocom(found, this.well.getWellID(), discID, found.getTopSample(), found.getBaseSample(), found.getAnalystString(), found.getSource(), found.getText() + ", " + text);
                    ++nUpdated;
                } else {
                    newComm = interp.addBiocom(new Biocom.Builder(this.sbdb, discID, this.sbdb.getUser(analyst).getUsrID(), event.getSample(), text), this.well.getWellID()).getBiocom();
                    ++nCreated;
                }
                this.sbdb.commit();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("Error adding comment", sql, this.sbdb);
                this.sbdb.doRollback();
            }
            catch (InvalidFieldException e) {
                JOptionPane.showMessageDialog(this, "Cannot insert comment: " + e.getMessage(), "Cannot insert comment", 2);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error adding comment", (Exception)((Object)sbe));
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
        if (newComm != null) {
            interp.notifyObservers(newComm);
        }
        String msg = "";
        if (nCreated > 0) {
            msg = msg + nCreated + " comments generated.";
        }
        if (nUpdated > 0) {
            if (!msg.isEmpty()) {
                msg = msg + "\n";
            }
            msg = msg + nUpdated + " comments updated.";
        }
        if (!msg.isEmpty()) {
            JOptionPane.showMessageDialog(this.parentPanel, msg, "Generate comments", 1);
        }
    }

    private void copyEvents(boolean move) {
        int nRows = this.jTableEvents.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select event(s)", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            WellInterp wellInterp = this.getSelectedVersion();
            if (wellInterp == null) {
                return;
            }
            DialogSelectVersion dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, this.sbdb.getProject(0));
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
            if (dialog.selection == null || dialog.selection.isEmpty()) {
                return;
            }
            InterpHdr newInterp = dialog.selection.get(0);
            if (newInterp == wellInterp.getHeader()) {
                JOptionPane.showMessageDialog(this, "Cannot " + (move ? "move" : "copy") + " to the current version.", this.parentFrame.getTitle(), 2);
                return;
            }
            LinkedList<WellEvent> toProcess = new LinkedList<WellEvent>();
            for (int row : this.jTableEvents.getSelectedRows()) {
                toProcess.add(this.tableModelEvents.events.get(this.tableSorterEvents.getIndexOf(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            newWellInterp.loadEvents(this.well);
            for (WellEvent ev : toProcess) {
                try {
                    wellInterp.copyEvent(this.well, ev, newWellInterp, move);
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, "Cannot " + (move ? "move" : "copy") + " event: " + e.getMessage(), "Error copying", 2);
                    continue;
                }
                this.sbdb.commit();
            }
            this.jTableEvents.clearSelection();
            if (move) {
                wellInterp.notifyObservers((Object)20);
            }
            newWellInterp.notifyObservers((Object)20);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error moving/copying events", ex, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error moving/copying events", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void copySQPicks(boolean move) {
        int nRows = this.jTableSQPicks.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select pick(s) to move", this.parentFrame.getTitle(), 2);
            return;
        }
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        InterpHdr newInterp = this.getCopyVersion(wellInterp, move);
        if (newInterp == null) {
            return;
        }
        try {
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            newWellInterp.loadSQPicks(this.well);
            LinkedList<SQPick> toMove = new LinkedList<SQPick>();
            for (int row : this.jTableSQPicks.getSelectedRows()) {
                toMove.add(this.tableModelSQPicks.picks.get(this.tableSorterSQPicks.getIndexOf(row)));
            }
            for (SQPick pick : toMove) {
                try {
                    wellInterp.copySQPick(this.well, pick, newWellInterp, move);
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot " + (move ? "move" : "copy"), 2);
                    continue;
                }
                this.sbdb.commit();
            }
            this.jTableSQPicks.clearSelection();
            wellInterp.notifyObservers((Object)21);
            newWellInterp.notifyObservers((Object)21);
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error moving/copying picks", ex, this.sbdb);
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error moving/copying picks", (Exception)((Object)ex));
        }
    }

    private InterpHdr getCopyVersion(WellInterp current, boolean move) {
        DialogSelectVersion dialog;
        try {
            dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, this.sbdb.getProject(0));
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening Version dialog", e, this.sbdb);
            return null;
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening Version dialog", (Exception)((Object)sbe));
            return null;
        }
        dialog.setLocationRelativeTo(this.parentFrame);
        dialog.setVisible(true);
        if (dialog.selection == null || dialog.selection.isEmpty()) {
            return null;
        }
        InterpHdr newInterp = dialog.selection.get(0);
        if (newInterp == current.getHeader()) {
            JOptionPane.showMessageDialog(this, "Cannot " + (move ? "move" : "copy") + " to the current version.", this.parentFrame.getTitle(), 2);
            return null;
        }
        return newInterp;
    }

    private void fillHierarchy(JTable jTable, ZonesTableModel tableModel, TableSorter sorter) {
        if (jTable.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this.parentFrame, "Select at least one interval", this.parentFrame.getTitle(), 1);
            return;
        }
        LinkedList<IGDIntervalZone> list = new LinkedList<IGDIntervalZone>();
        int[] selectedRows = jTable.getSelectedRows();
        int schemeID = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            IGDIntervalZone zone = tableModel.zones.get(sorter.getIndexOf(selectedRows[i]));
            if (schemeID == 0) {
                schemeID = zone.getSchID();
            } else if (zone.getSchID() != schemeID) {
                JOptionPane.showMessageDialog(this.parentFrame, "You must select intervals which belong to the same scheme", this.parentFrame.getTitle(), 1);
                return;
            }
            list.add(zone);
        }
        try {
            DialogFillHierarchy dialog = new DialogFillHierarchy(this.parentFrame, true, this.well, this.getInterp(), this.sbdb.getIGDScheme(schemeID), list);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.setSelectedZones(jTable, tableModel, sorter, dialog.toAdd);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void setSelectedZones(JTable jTable, ZonesTableModel tableModel, TableSorter sorter, List<IGDIntervalZone> list) {
        for (IGDIntervalZone newZone : list) {
            int index = -1;
            for (int i = 0; i < tableModel.zones.size(); ++i) {
                IGDIntervalZone z = tableModel.zones.get(i);
                if (!z.getUppInf().equals(newZone.getUppInf())) continue;
                index = i;
                break;
            }
            if (index < 0) continue;
            int sortedIndex = sorter.getIndexOf(index);
            jTable.addRowSelectionInterval(sortedIndex, sortedIndex);
        }
    }

    private void copyPalenv(boolean toDelete) {
        int nRows = this.jTableEnv.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select interval(s) to move", this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
                return;
            }
            DialogSelectVersion dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, this.sbdb.getProject(0));
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
            if (dialog.selection == null || dialog.selection.isEmpty()) {
                return;
            }
            InterpHdr newInterp = dialog.selection.get(0);
            LinkedList<IGDIntervalEnv> toMove = new LinkedList<IGDIntervalEnv>();
            for (int row : this.jTableEnv.getSelectedRows()) {
                toMove.add(this.tableModelEnv.envs.get(this.tableSorterEnv.getIndexOf(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            List list = newWellInterp.getEnvs();
            for (IGDIntervalEnv zone : toMove) {
                for (IGDIntervalEnv newInterpZone : list) {
                    newWellInterp.checkOverlap(zone.getTopSample(), zone.getBaseSample(), newInterpZone);
                }
            }
            for (IGDIntervalEnv zone : toMove) {
                if (toDelete) {
                    wellInterp.moveEnv(this.well, zone, newWellInterp);
                } else {
                    wellInterp.copyEnv(this.well, zone, newWellInterp);
                }
                this.sbdb.commit();
            }
            this.jTableEnv.clearSelection();
            wellInterp.notifyObservers((Object)5);
            newWellInterp.notifyObservers((Object)5);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parentFrame, ex.getMessage() + '\n' + SB.sql, this.parentFrame.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parentFrame, ex.getMessage(), this.parentFrame.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
    }

    private void copyBiocom(boolean deleteOriginal) {
        try {
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
                return;
            }
            if (this.jTableComments.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.parentFrame.getTitle(), 1);
                return;
            }
            DialogSelectVersion dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, this.sbdb.getProject(0));
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
            if (dialog.selection == null || dialog.selection.isEmpty()) {
                return;
            }
            InterpHdr newInterp = dialog.selection.get(0);
            LinkedList<Biocom> toMove = new LinkedList<Biocom>();
            for (int row : this.jTableComments.getSelectedRows()) {
                toMove.add(this.tableModelBiocom.comments.get(this.tableSorterBiocom.getIndexOf(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            this.well.loadInterp(newWellInterp);
            List list = newWellInterp.getComments();
            for (Biocom biocom : toMove) {
                for (Biocom newInterpBiocom : list) {
                    if (biocom.getTopID() != newInterpBiocom.getTopID() || biocom.getDiscID() != newInterpBiocom.getDiscID() || biocom.getAnalyst() != newInterpBiocom.getAnalyst()) continue;
                    JOptionPane.showMessageDialog(this, "Cannot copy/move comment(s): a comment already exists at " + biocom.getTopSample().toString() + "/" + biocom.getAnalystString(), this.parentFrame.getTitle(), 1);
                    return;
                }
            }
            for (Biocom biocom : toMove) {
                if (deleteOriginal) {
                    wellInterp.moveBiocom(this.well, biocom, newWellInterp);
                } else {
                    wellInterp.copyBiocom(this.well, biocom, newWellInterp);
                }
                this.sbdb.commit();
            }
            this.jTableComments.clearSelection();
            wellInterp.notifyObservers(toMove.get(0));
            newWellInterp.notifyObservers(toMove.get(0));
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parentFrame, ex.getMessage() + '\n' + SB.sql, this.parentFrame.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parentFrame, ex.getMessage(), this.parentFrame.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
    }

    private void copyIntcoms(boolean move) {
        DialogSelectVersion dialog;
        WellInterp wellInterp = this.getInterp();
        if (wellInterp == null) {
            JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
            return;
        }
        if (this.jTableIntComments.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, this.sbdb.getProject(0));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error opening version selection dialog", sql, this.sbdb);
            return;
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening version selection dialog", (Exception)((Object)sbe));
            return;
        }
        dialog.setLocationRelativeTo(this.parentFrame);
        dialog.setVisible(true);
        if (dialog.selection == null || dialog.selection.isEmpty()) {
            return;
        }
        InterpHdr newInterp = dialog.selection.get(0);
        LinkedList<Intcom> toMove = new LinkedList<Intcom>();
        for (int row : this.jTableIntComments.getSelectedRows()) {
            toMove.add(this.tableModelIntervalComments.comments.get(this.tableSorterIntervalComments.getIndexOf(row)));
        }
        if (toMove.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.parentFrame.getTitle(), 1);
            return;
        }
        try {
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            this.well.loadInterp(newWellInterp);
            for (Intcom intcom : toMove) {
                try {
                    wellInterp.copyIntcom(this.well, intcom, newWellInterp, move);
                }
                catch (InvalidFieldException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot " + (move ? "move" : "copy"), 2);
                    continue;
                }
                this.sbdb.commit();
            }
            this.jTableIntComments.clearSelection();
            wellInterp.notifyObservers(toMove.get(0));
            newWellInterp.notifyObservers(toMove.get(0));
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error copying/moving interval comment", ex, this.sbdb);
        }
        catch (SBException e) {
            SB.showStackError((String)"Error moving copying/interval comment", (Exception)((Object)e));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void copyLOC(boolean deleteOriginal) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            LOC original = wellInterp.getLOC();
            if (original == null) {
                JOptionPane.showMessageDialog(this, "No LOC exists in current version.", this.parentFrame.getTitle(), 1);
                return;
            }
            InterpHdr newInterp = this.getCopyVersion(wellInterp, deleteOriginal);
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            if (newWellInterp.getLOC() != null && newWellInterp.getLOC().getSize() > 0) {
                JOptionPane.showMessageDialog(this, "An LOC already exists in selected version: delete all nodes in existing version first.", this.parentFrame.getTitle(), 1);
                return;
            }
            wellInterp.copyLOC(this.well.getWellID(), newWellInterp, deleteOriginal);
            this.sbdb.commit();
            newWellInterp.notifyObservers((Object)newWellInterp.getLOC());
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error moving LOC", sqle, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error moving LOC", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void showColMap(int igdType) {
        WellInterp wellInterp = this.getSelectedVersion();
        if (wellInterp == null) {
            return;
        }
        try {
            DialogIGDColmap dialog = new DialogIGDColmap(this.parentFrame, true, this.sbdb, this.well, wellInterp, igdType);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("SQL Error opening Column Mapping dialog", sqle, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void saveOW(int igdType) {
        block24: {
            if (!this.canExport()) {
                return;
            }
            List<Object> zones = new LinkedList();
            switch (igdType) {
                case 3: {
                    zones = this.tableModelChrono.zones;
                    break;
                }
                case 2: {
                    zones = this.tableModelLstrat.zones;
                    break;
                }
                case 4: {
                    zones = this.tableModelBiozones.zones;
                }
            }
            if (zones.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No data to save", "Save intervals", 1);
                return;
            }
            File setDir = null;
            try {
                setDir = new File(Lastval.getString((SBdb)this.sbdb, (String)"WINOWCSV2", (String)"UNXOWCSV2"));
            }
            catch (SQLException ex) {
                // empty catch block
            }
            if (setDir == null || !setDir.exists()) {
                setDir = new File(".");
            }
            JFileChooser jFileChooser1 = new JFileChooser();
            jFileChooser1.setCurrentDirectory(setDir);
            SbugsFileFilter filter = new SbugsFileFilter();
            filter.addExtension("csv");
            String OWCSV2 = "OpenWorks CSV files (2 lines per interval)";
            filter.setDescription("OpenWorks CSV files (2 lines per interval)");
            jFileChooser1.addChoosableFileFilter((FileFilter)filter);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (0 != jFileChooser1.showSaveDialog(this)) break block24;
                String fileName = jFileChooser1.getSelectedFile().getPath();
                String filterString = jFileChooser1.getFileFilter().getDescription();
                char delim = ',';
                if (!fileName.toLowerCase().endsWith(".csv")) {
                    fileName = fileName + ".csv";
                }
                String[] prefix = new String[]{"early", "middle", "late", "mid", "upper", "lower"};
                FileWriter out = new FileWriter(fileName);
                boolean useCoreCorrections = false;
                boolean useCuttingCorrections = false;
                boolean askCores = false;
                boolean askCuttings = false;
                for (IGDIntervalZone iGDIntervalZone : zones) {
                    if ((iGDIntervalZone.getTopSample().getType().equals("CO") || iGDIntervalZone.getBaseSample().getType().equals("CO")) && !askCores) {
                        askCores = true;
                        int option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for core samples?", "Save Intervals", 0, 3);
                        if (option == 0) {
                            useCoreCorrections = true;
                        }
                    } else if ((iGDIntervalZone.getTopSample().getType().equals("CU") || iGDIntervalZone.getBaseSample().getType().equals("CU")) && !askCuttings) {
                        askCuttings = true;
                        int option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for cuttings?", "Save Intervals", 0, 3);
                        if (option == 0) {
                            useCuttingCorrections = true;
                        }
                    }
                    if (!filterString.startsWith("OpenWorks CSV files (2 lines per interval)")) continue;
                    String zoneName = iGDIntervalZone.toString();
                    for (int i = 0; i < prefix.length; ++i) {
                        if (!zoneName.toLowerCase().startsWith(prefix[i] + " ") || zoneName.toLowerCase().startsWith(prefix[i] + " -")) continue;
                        String suffix = zoneName.substring(0, prefix[i].length());
                        zoneName = zoneName.substring(suffix.length() + 1) + " " + suffix;
                        break;
                    }
                    out.write(zoneName + " Top" + delim + SB.floatString((double)this.well.getDepth(iGDIntervalZone.getTopSample(), this.units, useCoreCorrections, useCuttingCorrections), (int)2) + delim + "BIOSTRAT\r\n");
                    out.write(zoneName + " Base" + delim + SB.floatString((double)this.well.getDepth(iGDIntervalZone.getBaseSample(), this.units, useCoreCorrections, useCuttingCorrections), (int)2) + delim + "BIOSTRAT\r\n");
                }
                out.close();
                try {
                    Lastval.putString((SBdb)this.sbdb, (String)"WINOWCSV2", (String)fileName);
                    this.sbdb.commit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                JOptionPane.showMessageDialog(this, "File written.");
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQL Error", (SQLException)sql);
            }
            catch (IOException ioe) {
                SB.showStackError((String)"Error writing file", (Exception)ioe);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void saveOWSQPicks() {
        if (!this.canExport()) {
            return;
        }
        List<SQPick> picks = this.tableModelSQPicks.picks;
        if (picks.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No picks to save", "Save picks", 2);
            return;
        }
        File file = FrameJsbugs.chooseFile(this.sbdb, this.parentFrame, "WINOWPICKS", "UNXOWPICKS", new String[]{"csv"}, new String[]{"CSV"}, null);
        if (file == null) {
            return;
        }
        String delim = ",";
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            FileWriter out = new FileWriter(file.getPath());
            boolean useCoreCorrections = false;
            boolean useCuttingCorrections = false;
            boolean askCores = false;
            boolean askCuttings = false;
            for (SQPick pick : picks) {
                int option;
                if (pick.getSample().getType().equals("CO") && !askCores) {
                    askCores = true;
                    option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for core samples?", "Save Picks", 0, 3);
                    if (option == 0) {
                        useCoreCorrections = true;
                    }
                } else if (pick.getSample().getType().equals("CU") && !askCuttings) {
                    askCuttings = true;
                    option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for cuttings?", "Save Picks", 0, 3);
                    if (option == 0) {
                        useCuttingCorrections = true;
                    }
                }
                out.write(pick.getSurface().toString() + delim + SB.floatString((double)this.well.getDepth(pick.getSample(), this.units, useCoreCorrections, useCuttingCorrections), (int)2) + "\n");
            }
            out.close();
            JOptionPane.showMessageDialog(this, "File written.", "Save Picks", 1);
        }
        catch (Exception e) {
            SB.showStackError((String)"Error writing file", (Exception)e);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private boolean canExport() {
        if ((this.sbdb.getUser().getPriv() & 0x4000) > 0) {
            JOptionPane.showMessageDialog(this, "You are not allowed to export data.", "Export Data", 2);
            return false;
        }
        return true;
    }

    void putTableColumnWidths() throws SQLException {
        HashMap<JTable, TableModelSB> tables = new HashMap<JTable, TableModelSB>();
        Component cTab = this.jTabbedPaneInterpretations.getSelectedComponent();
        if (cTab == this.jPanelBiozones) {
            tables.put(this.jTableBiozones, this.tableModelBiozones);
        } else if (cTab == this.jPanelLStrat) {
            tables.put(this.jTableLStrat, this.tableModelLstrat);
        } else {
            tables.put(this.jTableChrono, this.tableModelChrono);
        }
        tables.put(this.jTableComments, this.tableModelBiocom);
        tables.put(this.jTableEnv, this.tableModelEnv);
        tables.put(this.jTableEvents, this.tableModelEvents);
        tables.put(this.jTableIntComments, this.tableModelIntervalComments);
        tables.put(this.jTableLOC, this.tableModelLOC);
        tables.put(this.jTableSQPicks, this.tableModelSQPicks);
        for (Map.Entry entry : tables.entrySet()) {
            ((TableModelSB)entry.getValue()).putTableColumnWidths(this.sbdb, (JTable)entry.getKey());
        }
    }

    private void moveZones(JTable table, ZonesTableModel model, TableSorter sorter, boolean toDelete) {
        int nRows = table.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "Select interval(s) to " + (toDelete ? "move" : "copy"), this.parentFrame.getTitle(), 2);
            return;
        }
        try {
            int igdType;
            WellInterp wellInterp = this.getInterp();
            if (wellInterp == null) {
                JOptionPane.showMessageDialog(this, "Select a Version", this.parentFrame.getTitle(), 1);
                return;
            }
            DialogSelectVersion dialog = new DialogSelectVersion(this.parentFrame, true, this.sbdb, true, this.sbdb.getProject(0));
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
            if (dialog.selection == null || dialog.selection.isEmpty()) {
                return;
            }
            InterpHdr newInterp = dialog.selection.get(0);
            LinkedList<IGDIntervalZone> toMove = new LinkedList<IGDIntervalZone>();
            for (int row : table.getSelectedRows()) {
                toMove.add(model.zones.get(sorter.getIndexOf(row)));
            }
            WellInterp newWellInterp = this.well.getAddInterp(newInterp);
            List list = newWellInterp.getIGDList(igdType, (igdType = ((IGDIntervalZone)toMove.get(0)).getIGDType()) == 4 ? ((IGDIntervalZone)toMove.get(0)).getSchID() : 0);
            for (IGDIntervalZone zone : toMove) {
                for (IGDIntervalZone newInterpZone : list) {
                    newWellInterp.checkOverlap(IGDIntervalZone.Builder.copyOf((IGDIntervalZone)zone), newInterpZone, true);
                }
            }
            for (IGDIntervalZone zone : toMove) {
                igdType = zone.getIGDType();
                if (toDelete) {
                    wellInterp.moveZone(this.well, zone, newWellInterp);
                } else {
                    wellInterp.copyZone(this.well.getWellID(), zone, newWellInterp);
                }
                this.sbdb.commit();
            }
            table.clearSelection();
            wellInterp.notifyObservers((Object)igdType);
            newWellInterp.notifyObservers((Object)igdType);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parentFrame, ex.getMessage() + '\n' + SB.sql, this.parentFrame.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parentFrame, ex.getMessage(), this.parentFrame.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
    }

    void setVersion(InterpHdr header) {
        if (this.jComboBoxVersion.getSelectedIndex() != 0) {
            return;
        }
        for (int i = 1; i < this.jComboBoxVersion.getItemCount(); ++i) {
            WellInterp wellInterp = (WellInterp)this.jComboBoxVersion.getItemAt(i);
            if (wellInterp.getHeader() != header) continue;
            System.out.println("In JPanelWellInterp.setVersion: Set interp for well: " + this.well);
            this.jComboBoxVersion.setSelectedItem(wellInterp);
            break;
        }
    }

    private void setTableSelection(Object arg, JTable table, List list, TableSorter sorter) {
        int index = list.indexOf(arg);
        if (index >= 0) {
            int sortIndex = sorter.getRowOf(index);
            table.setRowSelectionInterval(sortIndex, sortIndex);
            table.scrollRectToVisible(table.getCellRect(sortIndex, 0, true));
        }
    }

    TableModelSB getSelectedTable() {
        Component c = this.jTabbedPaneInterpretations.getSelectedComponent();
        if (c == this.jPanelChrono) {
            return this.tableModelChrono;
        }
        if (c == this.jPanelLStrat) {
            return this.tableModelLstrat;
        }
        if (c == this.jPanelBiozones) {
            return this.tableModelBiozones;
        }
        if (c == this.jPanelComments) {
            return this.tableModelBiocom;
        }
        if (c == this.jPanelEvents) {
            return this.tableModelEvents;
        }
        if (c == this.jPanelIntComments) {
            return this.tableModelIntervalComments;
        }
        if (c == this.jPanelSQPick) {
            return this.tableModelSQPicks;
        }
        if (c == this.jPanelEnv) {
            return this.tableModelEnv;
        }
        if (c == this.jPanelLOC) {
            return this.tableModelLOC;
        }
        if (c == this.jPanelFaults) {
            return this.tableModelFaults;
        }
        return null;
    }

    LinkedList<TablePair> getTablePair(TableModelSB model) {
        LinkedList<TablePair> tables = new LinkedList<TablePair>();
        if (model instanceof ZonesTableModel) {
            tables.add(new TablePair(this.tableModelChrono, this.jTableChrono));
            tables.add(new TablePair(this.tableModelLstrat, this.jTableLStrat));
            tables.add(new TablePair(this.tableModelBiozones, this.jTableBiozones));
        } else if (model instanceof BiocomTableModel) {
            tables.add(new TablePair(this.tableModelBiocom, this.jTableComments));
        } else if (model instanceof EventsTableModel) {
            tables.add(new TablePair(this.tableModelEvents, this.jTableEvents));
        } else if (model instanceof IntervalCommentsTableModel) {
            tables.add(new TablePair(this.tableModelIntervalComments, this.jTableIntComments));
        } else if (model instanceof EnvTableModel) {
            tables.add(new TablePair(this.tableModelEnv, this.jTableEnv));
        } else if (model instanceof SQPickTableModel) {
            tables.add(new TablePair(this.tableModelSQPicks, this.jTableSQPicks));
        } else if (model instanceof LOCTableModel) {
            tables.add(new TablePair(this.tableModelLOC, this.jTableLOC));
        } else if (model instanceof FaultsTableModel) {
            tables.add(new TablePair(this.tableModelFaults, this.jTableFaults));
        } else {
            return null;
        }
        return tables;
    }

    private void setAgeFormatTable(AgeFormat af) {
        if (this.tableModelLOC.getAgeFormat() != af) {
            this.tableModelLOC.setAgeFormat(af);
            this.tableModelLOC.fireTableDataChanged();
        }
    }

    private void setAgeFormatButton(AgeFormat af) {
        switch (af) {
            case MA: {
                this.jRadioButtonAgeFormatMA.setSelected(true);
                break;
            }
            case KA: {
                this.jRadioButtonAgeFormatKa.setSelected(true);
            }
        }
    }
}

