/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JScrollPane;
import jsbugs.Chart;
import jsbugs.ChartJPanel;

public class JScrollPaneChart
extends JScrollPane {
    private final ChartJPanel view;
    private final ChartJPanel header;

    public JScrollPaneChart(ChartJPanel view) {
        this.getViewport().setScrollMode(0);
        this.getVerticalScrollBar().setUnitIncrement(20);
        this.getViewport().add(view);
        this.view = view;
        this.header = new ChartJPanel(view.chart);
        this.header.setChartMode(Chart.Mode.HEADER_ONLY);
    }

    public JScrollPaneChart(ChartJPanel view, ChartJPanel header) {
        this.getViewport().setScrollMode(0);
        this.getVerticalScrollBar().setUnitIncrement(20);
        assert (view.getClass() == header.getClass());
        this.getViewport().add(view);
        this.view = view;
        header.setChartMode(Chart.Mode.HEADER_ONLY);
        header.chart = view.chart;
        this.header = header;
    }

    public void setHeader(boolean display) {
        this.header.chart = this.view.chart;
        if (!display) {
            this.setColumnHeaderView(null);
            this.view.setChartMode(Chart.Mode.NORMAL);
            return;
        }
        this.header.zoom = this.view.zoom;
        int headerWidth = (int)this.getViewport().getViewSize().getWidth();
        int headerHeight = (int)(this.header.chart.getHeaderHeight() * 2.8346457f * this.header.zoom) + 1;
        this.header.setPreferredSize(new Dimension(headerWidth, headerHeight));
        this.setColumnHeaderView(this.header);
        this.view.setChartMode(Chart.Mode.NO_HEADER);
    }

    void addJPanelMouseMotionListener(MouseMotionListener l) {
        this.view.addMouseMotionListener(l);
        this.header.addMouseMotionListener(l);
    }

    void addJPanelMouseListener(MouseListener l) {
        this.view.addMouseListener(l);
        this.header.addMouseListener(l);
    }

    void registerDragRecognizer(DragGestureListener listener) {
        new DragSource().createDefaultDragGestureRecognizer(this.view, 1, listener);
        new DragSource().createDefaultDragGestureRecognizer(this.header, 1, listener);
    }

    public void zoom(boolean in) {
        this.view.zoom(this.view.zoom, 1.5f, in);
        if (this.header.chart != null) {
            this.header.zoom(this.header.zoom, 1.5f, in);
        }
    }

    public boolean hasHeader() {
        return this.view.getMode() == Chart.Mode.NO_HEADER;
    }

    public Chart.Mode getViewMode() {
        return this.view.getMode();
    }

    void setToolTipText(MouseEvent evt) {
        if (evt.getComponent() == this.header) {
            this.header.setToolTipText(this.header.getTooltip(evt));
        } else {
            this.view.setToolTipText(this.view.getTooltip(evt));
        }
    }

    Object getObject(MouseEvent evt) {
        if (evt.getComponent() == this.header) {
            return this.header.getObject(evt);
        }
        return this.view.getObject(evt);
    }

    Object getObject(DragGestureEvent dge) {
        if (dge.getComponent() == this.header) {
            return this.header.getObject(dge.getDragOrigin());
        }
        return this.view.getObject(dge.getDragOrigin());
    }

    boolean isHeaderEvent(Component c) {
        return c == this.header;
    }
}

