/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.event.MouseMotionListener;
import java.sql.SQLException;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.ComboCellRenderer;
import jsbugs.DepthRenderer;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import model2.IGDIntervalZone;
import model2.LOC;
import model2.SBdb;
import model2.WellInterp;
import util.AgeFormat;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.TableSorter;

public class LOCTableModel
extends TableModelSB {
    private char units = (char)77;
    char type = (char)87;
    private WellInterp interp;
    private int wellID = -1;
    SBdb db;
    private String[] columnTitles = new String[]{"Depth", "Age", "Style", "Accumulation rate/Disconformity duration"};
    private static final int[] defaultColumnWidths = new int[]{30, 30, 40, 30};
    static final int COL_DEPTH = 0;
    static final int COL_AGE = 1;
    static final int COL_STYLE = 2;
    static final int COL_LENGTH = 3;
    JComboBox bndEditor = new JComboBox();
    private AgeFormat ageFormat = AgeFormat.MA;

    @Override
    public int getColumnCount() {
        return this.columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.getLOC() == null) {
            return null;
        }
        LOC.LOCNode node = this.getLOC().getNode(row);
        switch (col) {
            case 0: {
                return SB.floatString((double)SB.convFromM((double)node.getDepth(), (char)this.units, (char)this.type), (int)2);
            }
            case 1: {
                return SB.floatString((double)(node.getAge() * this.ageFormat.getMultiplyer()), (int)this.ageFormat.getPrecision());
            }
            case 2: {
                return node.getBoundaryType();
            }
            case 3: {
                if (row >= this.getLOC().getSize() - 1) break;
                return this.getLOC().getRateString(node, this.units, this.ageFormat);
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.getLOC() == null) {
            return;
        }
        LOC.LOCNode node = this.getLOC().getNode(row);
        switch (col) {
            case 0: {
                try {
                    double depth = Double.parseDouble(obj.toString());
                    this.interp.updateLOCNode(node, SB.convToM((double)depth, (char)this.units, (char)this.type), node.getAge(), node.getBnd(), this.wellID);
                }
                catch (NumberFormatException nfe) {
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(null, ife.getMessage(), "Node editor", 2);
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("Error updating node", sql, this.db);
                }
                break;
            }
            case 1: {
                try {
                    double age = Double.parseDouble(obj.toString());
                    this.interp.updateLOCNode(node, node.getDepth(), age /= this.ageFormat.getMultiplyer(), node.getBnd(), this.wellID);
                }
                catch (NumberFormatException nfe) {
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(null, ife.getMessage(), "Node editor", 2);
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("Error updating node", sql, this.db);
                }
                break;
            }
            case 2: {
                try {
                    String style = obj.toString();
                    this.interp.updateLOCNode(node, node.getDepth(), node.getAge(), IGDIntervalZone.getBoundaryTypeFromString((String)style), this.wellID);
                    break;
                }
                catch (NumberFormatException nfe) {
                    break;
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(null, ife.getMessage(), "Node editor", 2);
                    break;
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("Error updating node", sql, this.db);
                }
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.getLOC() == null) {
            return 0;
        }
        return this.getLOC().getSize();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: 
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setupTable(JTable jTableLOC) throws SQLException, SBException {
        this.init(jTableLOC, this.db);
        TableColumnModel columns = jTableLOC.getColumnModel();
        columns.getColumn(0).setCellRenderer(new DepthRenderer());
        this.bndEditor.setModel(new DefaultComboBoxModel<String>(IGDIntervalZone.bnds));
        columns.getColumn(2).setCellEditor(new DefaultCellEditor(this.bndEditor));
        columns.getColumn(2).setCellRenderer(new ComboCellRenderer());
        String[] tips = new String[this.columnTitles.length];
        tips[3] = "<html>Sedimentation rate (depth units/Ma)<br>or duration of unconformity (Ma)</html>";
        jTableLOC.getTableHeader().addMouseMotionListener((MouseMotionListener)new TableSorter((TableModel)this).createColumnHeaderToolTips(tips, jTableLOC));
    }

    @Override
    void setDefaultColumnWidths() {
        System.arraycopy(this.getDefaultColumnWidths(), 0, this.getColumnWidths(), 0, this.getDefaultColumnWidths().length);
    }

    public LOC getLOC() {
        if (this.interp == null) {
            return null;
        }
        return this.interp.getLOC();
    }

    public AgeFormat setLOC(WellInterp interp, JTable jTableLOC, int wellID) throws SQLException, SBException {
        this.interp = interp;
        this.wellID = wellID;
        if (interp.getLOC() != null) {
            this.ageFormat = interp.getLOC().getAgeFormatIdeal();
        }
        return this.ageFormat;
    }

    public void setUnits(char units) {
        this.units = units;
    }

    @Override
    String[] getColumnTitles() {
        return this.columnTitles;
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }

    @Override
    String getPrefString() {
        return "TMLOC";
    }

    @Override
    String getPrefOrderString() {
        return "TOLOC";
    }

    @Override
    final String getAutoResizeString() {
        return "TARLOC";
    }

    void setAgeFormat(AgeFormat af) {
        this.ageFormat = af;
    }

    AgeFormat getAgeFormat() {
        return this.ageFormat;
    }
}

