/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import jsbugs.SBGraphics;
import model2.Lithology;
import model2.SampleLithologyUnit;

public class LithologyPattern {
    public static float STRINGER_HEIGHT = 1.5f;

    public static void draw(Lithology lith, SBGraphics g, float[] xVec, float[] yVec, int nVec, boolean mono, boolean drawOutline, boolean noPattern) {
        float base;
        float right;
        float top;
        float left;
        int lithID = lith.getLithID();
        Color backColour = lith.getBackColour();
        g.setColor(Color.BLACK);
        g.setFont("Arial", 1, 3.5f);
        if (nVec == 4) {
            left = xVec[0];
            top = yVec[0];
            right = xVec[1];
            base = yVec[2];
        } else {
            left = xVec[1];
            top = yVec[4];
            right = xVec[2];
            base = yVec[1];
        }
        float drawX = left;
        float drawY = top;
        float drawWidth = right - drawX;
        float drawHeight = base - drawY;
        float awidth = drawWidth;
        float aheight = drawHeight;
        if (lithID == 1900) {
            g.setColor(Color.WHITE);
            g.fillRect(drawX, drawY, drawWidth, drawHeight, Color.WHITE);
            g.setColor(Color.BLACK);
            g.drawLine(drawX, drawY, drawX + drawWidth, drawY + drawHeight);
            g.drawLine(drawX, drawY + drawHeight, drawX + drawWidth, drawY);
        } else if (lithID == 1901) {
            g.setColor(Color.WHITE);
            g.fillRect(drawX, drawY, drawWidth, drawHeight, Color.WHITE);
        } else if (lithID == 2006) {
            LithologyPattern.plotSymbolPebbly(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3000) {
            LithologyPattern.plotSymbolAlgalLumps(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3003) {
            LithologyPattern.plotSymbolBivalve(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3004) {
            LithologyPattern.plotSymbolBrachiopod(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3005) {
            LithologyPattern.plotSymbolBryzoan(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3018) {
            LithologyPattern.plotSymbolFishRemains(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3016) {
            LithologyPattern.plotSymbolEchinoderm(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3008) {
            LithologyPattern.plotSymbolCalcite(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3019) {
            LithologyPattern.plotSymbolFormaniferaLargeBenthic(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3021) {
            LithologyPattern.plotSymbolFormaniferaSmallBenthic(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 2000) {
            LithologyPattern.plotSymbolArgillaceous(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 2004) {
            LithologyPattern.plotSymbolCarbonaceous(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 2005) {
            LithologyPattern.plotSymbolDolomitic(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 2008) {
            LithologyPattern.plotSymbolSandy(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 2009) {
            LithologyPattern.plotSymbolSilty(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 2003) {
            LithologyPattern.plotSymbolCalcareous(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 2001) {
            LithologyPattern.plotSymbolBituminous(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3010) {
            LithologyPattern.plotSymbolCharophyte(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3020) {
            LithologyPattern.plotSymbolForamPlanktonic(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3041) {
            LithologyPattern.plotSymbolRelictGrains(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3033) {
            LithologyPattern.plotSymbolOolith(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3011) {
            LithologyPattern.plotSymbolChert(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3013) {
            LithologyPattern.plotSymbolCoatedParticle(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3040) {
            LithologyPattern.plotSymbolRadiolaria(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 3014) {
            LithologyPattern.plotSymbolCoral(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 1035) {
            LithologyPattern.plotRecrystallisedLimestone(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID == 1042) {
            LithologyPattern.plotChert(g, drawX, drawY, drawWidth, drawHeight, mono);
        } else if (lithID >= 1069 && lithID <= 1081) {
            LithologyPattern.plotDolomiticDunham(g, drawX, drawY, drawWidth, drawHeight, mono, lithID);
        } else if (lithID >= 1012 && lithID <= 1015) {
            float dens = 1.0f;
            int d = lithID - 1012;
            if (d == 0) {
                dens = 0.3f;
            }
            if (d == 1) {
                dens = 0.9f;
            }
            if (d == 2) {
                dens = 1.8f;
            }
            if (d == 3) {
                dens = 3.5f;
            }
            if (mono) {
                g.setColor(Color.WHITE);
                g.fillRect(drawX, drawY, drawWidth, drawHeight, Color.WHITE);
            } else {
                g.setColor(backColour);
                g.fillRect(drawX, drawY, drawWidth, drawHeight, backColour);
            }
            LithologyPattern.plotIrregularSandstone(g, drawX, drawY, drawWidth, drawHeight, mono, dens, 0.05f);
        } else if (lithID >= 1021 && lithID <= 1029 || lithID >= 1065 && lithID <= 1068) {
            LithologyPattern.plotDunham(g, drawX, drawY, drawWidth, drawHeight, mono, lithID);
        } else {
            boolean ok = true;
            float lastx = 0.0f;
            float lasty = 0.0f;
            float height = lith.getHeight();
            float width = lith.getWidth();
            float[] lineWidth = lith.getLineWidth();
            int[] style = lith.getStyle();
            int nLines = lith.getNLines();
            String[] oType = lith.getOType();
            Color[] colour = lith.getPenColour();
            float[] x1 = lith.getX1();
            float[] y1 = lith.getY1();
            float[] x2 = lith.getX2();
            float[] y2 = lith.getY2();
            Color brushColour = Color.WHITE;
            Color penColour = Color.BLACK;
            float penWidth = 0.0f;
            float brushWidth = 1.0f;
            if ((double)lith.getWidth() < 1.0 || (double)lith.getHeight() < 1.0) {
                return;
            }
            float alpha = 0.52359873f;
            g.setColor(Color.BLACK);
            g.setStroke(0.1f);
            char qtype = lith.getCmp();
            boolean fill_background = true;
            if (qtype == 'A' || qtype == 'Y') {
                fill_background = false;
            }
            if (fill_background) {
                if (lith.getBackColour() != null && !mono) {
                    if (drawOutline) {
                        g.setColor(Color.BLACK);
                        g.setStroke(0.1f);
                    } else {
                        g.setColor(backColour);
                        g.setStroke(0.0f);
                    }
                    g.fillPolygon(xVec, yVec, nVec, backColour);
                } else {
                    g.setColor(Color.WHITE);
                    g.setStroke(0.0f);
                    g.fillPolygon(xVec, yVec, nVec, Color.WHITE);
                }
            }
            if (nLines == 0 && lithID >= 3000 && lithID < 4000) {
                g.setFont("Arial", 1, 3.0f);
                String abr = lith.getAbr();
                int length = abr.length();
                float xc = left + 0.5f * drawWidth - 0.5f * (float)length - 1.0f;
                float yc = top + 0.5f * drawHeight + 1.25f;
                g.drawString(abr, xc, yc);
            } else {
                float nHorz = awidth / width;
                float nVert = aheight / height;
                switch (qtype) {
                    case 'A': 
                    case 'Y': {
                        nHorz = 0.0f;
                        left = left + drawWidth / 2.0f - width / 2.0f;
                        top = top + drawHeight / 2.0f - height / 2.0f;
                    }
                    case 'S': {
                        nVert = 0.0f;
                    }
                }
                g.setStroke(0.0f);
                g.setClip(left, top, awidth, aheight);
                g.setStroke(0.1f);
                int i = 0;
                while ((float)i <= nHorz) {
                    float xleft = left + (float)i * width;
                    int j = 0;
                    while ((float)j <= nVert) {
                        float ytop = top + (float)j * height;
                        for (int k = 0; k < nLines; ++k) {
                            float ry;
                            float rx;
                            float yc;
                            float xc;
                            float ty;
                            float fy;
                            float tx;
                            float fx;
                            if (oType[k] == null) continue;
                            if (oType[k].equals("L")) {
                                fx = xleft + x1[k];
                                tx = xleft + x2[k];
                                fy = ytop + y1[k];
                                ty = ytop + y2[k];
                                lastx = tx;
                                lasty = ty;
                                g.setColor(penColour);
                                g.drawLine(fx, fy, ty, ty);
                                continue;
                            }
                            if (oType[k].equals("C")) {
                                xc = xleft + x1[k];
                                yc = ytop + y1[k];
                                float r = x2[k];
                                fx = xc;
                                fy = yc + r;
                                g.setColor(penColour);
                                g.fillEllipse(xc - x2[k], yc - x2[k], 2.0f * x2[k], 2.0f * x2[k], brushColour);
                                continue;
                            }
                            if (oType[k].equals("MV")) {
                                lastx = xleft + x1[k];
                                lasty = ytop + y1[k];
                                continue;
                            }
                            if (oType[k].equals("LT")) {
                                fx = lastx;
                                fy = lasty;
                                tx = xleft + x1[k];
                                ty = ytop + y1[k];
                                ok = true;
                                lastx = tx;
                                lasty = ty;
                                if (ok) {
                                    g.setColor(penColour);
                                }
                                g.drawLine(fx, fy, tx, ty);
                                continue;
                            }
                            if (oType[k].equals("B") || oType[k].equals("RE")) {
                                fx = xleft + x1[k];
                                tx = xleft + x2[k];
                                fy = ytop + y1[k];
                                ty = ytop + y2[k];
                                if (ok) {
                                    g.setColor(penColour);
                                }
                                g.fillRect(fx, fy, tx - fx, ty - fy, brushColour);
                                continue;
                            }
                            if (oType[k].equals("E")) {
                                xc = xleft + x1[k];
                                yc = ytop + y1[k];
                                rx = x2[k];
                                ry = y2[k];
                                fx = xc;
                                fy = yc + ry;
                                g.setColor(penColour);
                                g.fillEllipse(xc - rx, yc - ry, 2.0f * rx, 2.0f * ry, brushColour);
                                continue;
                            }
                            if (oType[k].equals("EL")) {
                                xc = xleft + x1[k];
                                yc = ytop + y1[k];
                                rx = xleft + x2[k];
                                ry = ytop + y2[k];
                                g.setColor(penColour);
                                g.fillEllipse(xc, yc, rx - xc, ry - yc, brushColour);
                                continue;
                            }
                            if (oType[k].equals("CP")) {
                                penColour = colour[k];
                                g.setColor(penColour);
                                penWidth = lineWidth[k];
                                continue;
                            }
                            if (!oType[k].equals("CB")) continue;
                            brushColour = colour[k];
                            g.setColor(brushColour);
                            brushWidth = lineWidth[k];
                        }
                        ++j;
                    }
                    ++i;
                }
                g.setStroke(0.0f);
                g.setClip(0.0f, 0.0f, 0.0f, 0.0f);
            }
            if (lithID == 1007 || lithID == 1011) {
                LithologyPattern.plotIrregularSandstone(g, drawX, drawY, drawWidth, drawHeight, mono, 1.2f, 0.05f);
            }
        }
    }

    public static void drawList(List liths, SBGraphics g, float x, float y, float width, float height, boolean monochrome, boolean drawOutline, boolean noPattern) {
        if (liths != null && liths.size() > 0) {
            Iterator it = liths.iterator();
            float percent = 0.0f;
            float divide = 0.0f;
            float lastDivide = x;
            while (it.hasNext()) {
                SampleLithologyUnit lith = (SampleLithologyUnit)it.next();
                percent += (float)lith.getPercent();
                divide = width * ((float)lith.getPercent() / 100.0f);
                Lithology descr = lith.getDescription();
                int lithID = descr.getLithID();
                if (lithID >= 2000 && lithID < 4000) {
                    float xmid = lastDivide + 0.5f * divide;
                    float ymid = y + 0.5f * height;
                    LithologyPattern.draw(lith.getDescription(), g, xmid, ymid, monochrome, drawOutline, noPattern);
                }
                if (lithID >= 4000) {
                    float top = y + 0.5f * height;
                    LithologyPattern.drawStringer(lith.getDescription(), g, lastDivide, top, divide, monochrome, drawOutline, noPattern);
                }
                if (lithID < 2000) {
                    LithologyPattern.draw(lith.getDescription(), g, lastDivide, y, divide, height, monochrome, noPattern);
                }
                lastDivide += divide;
            }
            if (percent < 100.0f) {
                g.setColor(Color.WHITE);
                divide = x + width * (percent / 100.0f);
                g.fillRect(divide, y, width, height, Color.WHITE);
                g.setColor(Color.BLACK);
                g.drawLine(divide, y, width, height);
                g.drawLine(divide, height, width, y);
            }
        }
    }

    static void plotRegularSandstone(SBGraphics g, float left, float top, float width, float height, boolean mono_lith, float dens) {
        float bdim = 0.05f;
        float dx = 70.0f / dens;
        if (dens == 10.0f) {
            dx = 3.3333f;
        } else if (dens == 30.0f) {
            dx = 2.333f;
        } else if (dens == 50.0f) {
            dx = 1.666f;
        } else if (dens == 70.0f) {
            dx = 1.333f;
        }
        g.setColor(Color.BLACK);
        float x = left + 0.5f * dx;
        while (x + bdim <= left + width) {
            float y = top + 0.5f * dx;
            while (y + bdim <= top + height) {
                g.fillRect(x, y, bdim, bdim, Color.BLACK);
                y += dx;
            }
            x += dx;
        }
    }

    static void plotIrregularSandstone(SBGraphics g, float left, float top, float width, float height, boolean mono_lith, float dens, float bdim) {
        float CellSize = 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.25f);
        float nPlot = dens * width * height / (CellSize * CellSize);
        float w1 = width - bdim;
        float h1 = height - bdim;
        Random generator = new Random(1000L);
        int i = 0;
        while ((float)i < nPlot) {
            float x = left + w1 * (float)generator.nextDouble();
            float y = top + h1 * (float)generator.nextDouble();
            g.drawLine(x, y, x + 0.01f, y + 0.01f);
            ++i;
        }
    }

    private static void plotChert(SBGraphics g, float left, float top, float width, float height, boolean mono_lith) {
        float[] xpos = new float[4];
        float[] ypos = new float[4];
        g.setColor(Color.WHITE);
        g.fillRect(left, top, width, height, Color.WHITE);
        g.setColor(Color.BLACK);
        float nx = width / 5.0f;
        float ny = height / 5.0f;
        int i = 0;
        while ((float)i <= nx) {
            float x = left + (float)(i * 5);
            int j = 0;
            while ((float)j <= ny) {
                float y = top + (float)(j * 5);
                xpos[0] = x + 0.5f;
                ypos[0] = y + 0.25f;
                xpos[1] = x + 2.25f;
                ypos[1] = y + 0.25f;
                xpos[2] = x + 1.25f;
                ypos[2] = y + 2.5f;
                g.fillPolygon(xpos, ypos, 3, Color.BLACK);
                ++j;
            }
            ++i;
        }
    }

    private static void plotLimestone(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        boolean isMeta = false;
        boolean ok = true;
        float[] x1 = new float[]{0.0f, 0.0f, 3.0f, 1.0f, 3.0f};
        float[] y1 = new float[]{1.0f, 3.0f, 0.0f, 1.0f, 3.0f};
        float[] x2 = new float[]{4.0f, 4.0f, 3.0f, 1.0f, 3.0f};
        float[] y2 = new float[]{1.0f, 3.0f, 1.0f, 3.0f, 4.0f};
        Color backColour = new Color(128, 255, 255);
        if (mono) {
            g.setColor(Color.WHITE);
            g.fillRect(left, top, width, height, Color.WHITE);
        } else {
            g.setColor(backColour);
            g.fillRect(left, top, width, height, backColour);
        }
        float right = left + width;
        float base = top + height;
        g.setColor(Color.BLACK);
        g.setStroke(0.05f);
        float nx = width / 4.0f;
        float ny = height / 4.0f;
        g.setClip(left, top, width, height);
        int i = 0;
        while ((float)i <= nx) {
            float x = left + (float)(i * 4);
            int j = 0;
            while ((float)j <= ny) {
                float y = top + (float)(j * 4);
                for (int k = 0; k < 5; ++k) {
                    float fx = x + x1[k];
                    float fy = y + y1[k];
                    float tx = x + x2[k];
                    float ty = y + y2[k];
                    if (isMeta) {
                        if (!ok) continue;
                        g.drawLine(fx, fy, tx, ty);
                        continue;
                    }
                    g.drawLine(fx, fy, tx, ty);
                }
                ++j;
            }
            ++i;
        }
        g.setClip(0.0f, 0.0f, 0.0f, 0.0f);
    }

    private static void plotDolomite(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        boolean isMeta = false;
        boolean ok = false;
        float[] x1 = new float[]{0.0f, 0.0f, 3.0f, 2.0f, 3.5f};
        float[] y1 = new float[]{1.0f, 3.0f, 0.0f, 1.0f, 3.0f};
        float[] x2 = new float[]{4.0f, 4.0f, 2.5f, 1.0f, 3.0f};
        float[] y2 = new float[]{1.0f, 3.0f, 1.0f, 3.0f, 4.0f};
        Color backColour = new Color(128, 128, 255);
        if (mono) {
            g.setColor(Color.WHITE);
            g.fillRect(left, top, width, height, Color.WHITE);
        } else {
            g.setColor(backColour);
            g.fillRect(left, top, width, height, backColour);
        }
        float right = left + width;
        float base = top + height;
        g.setColor(Color.BLACK);
        g.setStroke(0.05f);
        float nx = width / 4.0f;
        float ny = height / 4.0f;
        int i = 0;
        while ((float)i <= nx) {
            float x = left + (float)(i * 4);
            int j = 0;
            while ((float)j <= ny) {
                float y = top + (float)(j * 4);
                for (int k = 0; k < 5; ++k) {
                    float fx = x + x1[k];
                    float fy = y + y1[k];
                    float tx = x + x2[k];
                    float ty = y + y2[k];
                    g.drawLine(fx, fy, tx, ty);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void plotRecrystallisedLimestone(SBGraphics g, float left, float top, float width, float height, boolean mono_lith) {
        Color backColour = new Color(128, 255, 255);
        g.setColor(backColour);
        g.fillRect(left, top, width, height, backColour);
        LithologyPattern.plotLimestone(g, left, top, width, height, mono_lith);
        g.setColor(Color.BLACK);
        g.setStroke(0.05f);
        float nx = width / 8.0f;
        float ny = height / 4.0f;
        int i = 0;
        while ((float)i <= nx) {
            float x = left + (float)(i * 8);
            int j = 0;
            while ((float)j <= ny) {
                float y = top + (float)(j * 4);
                float x1 = x + 2.0f;
                float y1 = y + 2.5f;
                float x2 = x + 4.0f;
                float y2 = y + 1.5f;
                g.drawLine(x1, y1, x2, y2);
                g.drawLine(x2, y2, x1, y1);
                ++j;
            }
            ++i;
        }
    }

    private static void plotSymbolCoral(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 1.5f;
        float sint = 0.5f;
        float cost = 0.8660254f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float x1 = xmid - radius;
        float y1 = ymid - radius;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillEllipse(x1, y1, 3.0f, 3.0f, Color.WHITE);
        float dx = radius * cost;
        float dy = radius * sint;
        g.drawLine(xmid, ymid - radius, xmid, ymid + radius);
        g.drawLine(xmid + dx, ymid - dy, xmid - dx, ymid + dy);
        g.drawLine(xmid - dx, ymid - dy, xmid + dx, ymid + dy);
    }

    private static void plotSymbolRelictGrains(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 1.5f;
        float f = 0.70710677f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float x1 = xmid - radius;
        float y1 = ymid - radius;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillEllipse(x1, y1, 3.0f, 3.0f, Color.WHITE);
        float dx = radius * f;
        float dy = radius * f;
        g.drawLine(xmid + dx, ymid - dy, xmid - dx, ymid + dy);
        g.drawLine(xmid - dx, ymid - dy, xmid + dx, ymid + dy);
    }

    private static void plotSymbolCalcite(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 1.5f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float x1 = xmid - radius;
        float x2 = xmid + radius;
        float y1 = ymid - radius;
        float y2 = ymid + radius;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillEllipse(x1, y1, 3.0f, 3.0f, Color.WHITE);
        g.drawArc(x1 += 0.4f, y1 += 0.4f, (x2 -= 0.4f) - x1, (y2 -= 0.4f) - y1, 45, 315);
    }

    private static void plotSymbolThreeBalls(SBGraphics g, float left, float top, float width, float height, boolean mono, Color colour) {
        float radius = 0.75f;
        float cos30 = 0.8660254f;
        float sin30 = 0.5f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float shellR = radius / cos30;
        float dy = shellR * sin30;
        float dx = shellR * cos30;
        float xmid1 = xmid + dx;
        float ymid1 = ymid + dy;
        g.fillEllipse(xmid1 - radius, ymid1 - radius, 1.5f, 1.5f, colour);
        xmid1 = xmid - dx;
        g.fillEllipse(xmid1 - radius, ymid1 - radius, 1.5f, 1.5f, colour);
        xmid1 = xmid;
        ymid1 = ymid - shellR;
        g.fillEllipse(xmid1 - radius, ymid1 - radius, 1.5f, 1.5f, colour);
    }

    private static void plotSymbolForamPlanktonic(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        LithologyPattern.plotSymbolThreeBalls(g, left, top, width, height, mono, Color.WHITE);
    }

    private static void plotSymbolForamBenthic(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        LithologyPattern.plotSymbolThreeBalls(g, left, top, width, height, mono, Color.BLACK);
    }

    private static void plotSymbolCharophyte(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 1.5f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float x1 = xmid - radius;
        float y1 = ymid - radius;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillEllipse(x1, y1, 3.0f, 3.0f, Color.WHITE);
        g.drawArc(x1 + 0.2f, y1 - 0.2f, radius * 2.0f, radius * 2.0f, 140, 165);
        g.drawArc(x1 + 0.5f, y1 - 0.5f, radius * 2.0f, radius * 2.0f, 150, 150);
        g.drawArc(x1 + 0.8f, y1 - 0.8f, radius * 2.0f, radius * 2.0f, 160, 130);
    }

    private static void plotSymbolOolith(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 1.5f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float x1 = xmid - radius;
        float y1 = ymid - radius;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillEllipse(x1, y1, 3.0f, 3.0f, Color.WHITE);
        g.fillEllipse(xmid - 0.5f, ymid - 0.5f, 1.0f, 1.0f, Color.BLACK);
    }

    private static void plotSymbolChert(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float[] xpos = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] ypos = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        xpos[0] = xmid - 1.25f;
        ypos[0] = ymid - 1.25f;
        xpos[1] = xmid + 1.25f;
        ypos[1] = ymid - 1.25f;
        xpos[2] = xmid;
        ypos[2] = ymid + 1.25f;
        g.fillPolygon(xpos, ypos, 3, Color.BLACK);
    }

    private static void plotSymbolRadiolaria(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 0.666666f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float x1 = xmid - radius;
        float y1 = ymid - radius;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillEllipse(x1, y1, 1.333333f, 1.333333f, Color.WHITE);
        g.drawLine(xmid, ymid - 1.25f, xmid, ymid + 1.25f);
        g.drawLine(xmid - 1.25f, ymid, xmid + 1.25f, ymid);
    }

    private static void plotSymbolCoatedParticle(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 1.5f;
        float xmid = left + 0.5f * width;
        float ymid = top + 0.5f * height;
        float x1 = xmid - radius;
        float y1 = ymid - radius;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillEllipse(x1, y1, 3.0f, 3.0f, Color.WHITE);
        g.fillEllipse(xmid - 0.5f, ymid - 0.5f, 1.0f, 1.0f, Color.WHITE);
    }

    private static void plotSymbolBituminous(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float radius = 1.5f;
        float[] xpos = new float[8];
        float[] ypos = new float[8];
        float xmid = left + 0.5f * width - 1.5f;
        float ymid = top + 0.5f * height - 1.5f;
        xpos[0] = xmid + 0.5f;
        ypos[0] = ymid + 2.0f;
        xpos[1] = xmid + 1.5f;
        ypos[1] = ymid + 1.5f;
        xpos[2] = xmid + 2.0f;
        ypos[2] = ymid + 0.5f;
        xpos[3] = xmid + 2.5f;
        ypos[3] = ymid + 1.5f;
        xpos[4] = xmid + 3.5f;
        ypos[4] = ymid + 2.0f;
        xpos[5] = xmid + 2.5f;
        ypos[5] = ymid + 2.5f;
        xpos[6] = xmid + 2.0f;
        ypos[6] = ymid + 3.5f;
        xpos[7] = xmid + 1.5f;
        ypos[7] = ymid + 2.5f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillPolygon(xpos, ypos, 8, Color.BLACK);
    }

    private static void plotSymbolArgillaceous(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        left = left + width / 2.0f - 1.0f;
        top = top + height / 2.0f - 0.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillRect(left, top, 3.0f, 1.0f, Color.BLACK);
    }

    private static void plotSymbolCalcareous(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        left = left + width / 2.0f - 1.0f;
        top = top + height / 2.0f - 1.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillRect(left, top, 2.0f, 0.5f, Color.BLACK);
        g.fillRect(left + 0.75f, top, 0.5f, 3.0f, Color.BLACK);
        g.fillRect(left, top, 2.0f, 0.5f, Color.BLACK);
    }

    private static void plotSymbolCarbonaceous(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        left = left + width / 2.0f - 1.0f;
        top = top + height / 2.0f - 0.75f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillRect(left, top, 2.0f, 1.5f, Color.BLACK);
    }

    private static void plotSymbolDolomitic(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float[] xpos = new float[5];
        float[] ypos = new float[5];
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        left = left + width / 2.0f - 1.0f;
        top = top + height / 2.0f - 1.0f;
        g.fillRect(left + 1.0f, top + 0.5f, 2.5f, 0.5f, Color.BLACK);
        xpos[0] = left + 2.0f;
        ypos[0] = top + 1.0f;
        xpos[1] = left + 2.5f;
        ypos[1] = top + 1.0f;
        xpos[2] = left + 2.0f;
        ypos[2] = top + 3.0f;
        xpos[3] = left + 1.5f;
        ypos[3] = top + 3.0f;
        g.fillPolygon(xpos, ypos, 4, Color.BLACK);
        g.fillRect(left + 0.5f, top + 3.0f, 2.5f, 0.5f, Color.BLACK);
    }

    private static void plotSymbolSandy(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        left = left + width / 2.0f - 1.0f;
        top = top + height / 2.0f - 0.15f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        g.fillRect(left, top, 0.3f, 0.3f, Color.BLACK);
        g.fillRect(left + 1.0f, top, 0.3f, 0.3f, Color.BLACK);
        g.fillRect(left + 2.0f, top, 0.3f, 0.3f, Color.BLACK);
    }

    private static void plotSymbolSilty(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        g.setColor(Color.BLACK);
        g.setStroke(0.0f);
        left = left + width / 2.0f - 1.875f;
        top = top + height / 2.0f - 0.15f;
        g.fillRect(left, top, 1.0f, 0.3f, Color.BLACK);
        g.fillRect(left + 1.75f, top, 1.0f, 0.3f, Color.BLACK);
    }

    private static void plotSymbolFishRemains(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float mult = 0.05f;
        float[] xdata = new float[]{20.0f, 10.0f, 10.0f, 20.0f, 40.0f, 70.0f, 70.0f, 40.0f, 20.0f, 0.0f};
        float[] ydata = new float[]{50.0f, 40.0f, 30.0f, 20.0f, 20.0f, 45.0f, 25.0f, 50.0f, 50.0f, 0.0f};
        float[] xpos = new float[10];
        float[] ypos = new float[10];
        int nPoints = 9;
        left = left + width / 2.0f - mult * 70.0f / 2.0f;
        top = top + height / 2.0f - mult * 50.0f / 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        for (int i = 0; i < nPoints; ++i) {
            xpos[i] = left + mult * xdata[i];
            ypos[i] = top + mult * ydata[i];
        }
        g.fillPolygon(xpos, ypos, 9, Color.WHITE);
        g.fillRect(left + mult * 2.0f, top + mult * 3.0f, 0.025f, 0.025f, Color.BLACK);
    }

    private static void plotSymbolEchinoderm(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        int i;
        float mult = 0.05f;
        float[] xdata1 = new float[]{10.0f, 14.0f, 25.0f, 40.0f, 55.0f, 66.0f, 70.0f, 10.0f};
        float[] ydata1 = new float[]{60.0f, 40.0f, 30.0f, 28.0f, 30.0f, 40.0f, 60.0f, 60.0f};
        float[] xdata2 = new float[]{20.0f, 24.0f, 32.0f, 48.0f, 56.0f, 60.0f};
        float[] ydata2 = new float[]{60.0f, 42.0f, 37.0f, 37.0f, 42.0f, 60.0f};
        float[] x1 = new float[]{11.0f, 22.0f, 58.0f, 69.0f, 40.0f};
        float[] y1 = new float[]{31.0f, 20.0f, 20.0f, 31.0f, 15.0f};
        float[] x2 = new float[]{24.0f, 32.0f, 48.0f, 56.0f, 40.0f};
        float[] y2 = new float[]{42.0f, 37.0f, 37.0f, 42.0f, 37.0f};
        float[] xpos = new float[10];
        float[] ypos = new float[10];
        int nPoints1 = 8;
        int nPoints2 = 6;
        int nVecs = 5;
        left = left + width / 2.0f - mult * 70.0f / 2.0f;
        top = top + height / 2.0f - mult * 60.0f / 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        for (i = 0; i < nPoints1; ++i) {
            xpos[i] = left + mult * xdata1[i];
            ypos[i] = top + mult * ydata1[i];
        }
        g.fillPolygon(xpos, ypos, nPoints1, Color.WHITE);
        for (i = 0; i < nPoints2; ++i) {
            xpos[i] = left + mult * xdata2[i];
            ypos[i] = top + mult * ydata2[i];
        }
        g.fillPolygon(xpos, ypos, nPoints2, Color.WHITE);
        for (i = 0; i < nVecs; ++i) {
            g.drawLine(left + mult * x1[i], top + mult * y1[i], left + mult * x2[i], top + mult * y2[i]);
        }
    }

    private static void plotSymbolPebbly(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        int i;
        float mult = 0.04f;
        float[] blob1_x = new float[]{6.0f, 20.0f, 35.0f, 42.0f, 43.0f, 27.0f, 19.0f, 13.0f, 6.0f};
        float[] blob1_y = new float[]{64.0f, 61.0f, 64.0f, 76.0f, 85.0f, 86.0f, 78.0f, 78.0f, 64.0f};
        int blob1_nvecs = 9;
        float[] blob2_x = new float[]{84.0f, 60.0f, 47.0f, 51.0f, 65.0f, 82.0f, 90.0f, 84.0f};
        float[] blob2_y = new float[]{61.0f, 64.0f, 75.0f, 82.0f, 91.0f, 82.0f, 72.0f, 61.0f};
        int blob2_nvecs = 8;
        float[] blob3_x = new float[]{34.0f, 23.0f, 10.0f, 7.0f, 7.0f, 28.0f, 54.0f, 76.0f, 87.0f, 92.0f, 82.0f, 65.0f, 59.0f, 54.0f, 46.0f, 34.0f};
        float[] blob3_y = new float[]{43.0f, 47.0f, 48.0f, 37.0f, 24.0f, 15.0f, 12.0f, 11.0f, 22.0f, 37.0f, 50.0f, 51.0f, 54.0f, 46.0f, 48.0f, 43.0f};
        int blob3_nvecs = 16;
        float[] xpos = new float[16];
        float[] ypos = new float[16];
        left = left + width / 2.0f - mult * 92.0f / 2.0f;
        top = top + height / 2.0f - mult * 91.0f / 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        for (i = 0; i < blob1_nvecs; ++i) {
            xpos[i] = left + mult * blob1_x[i];
            ypos[i] = top + mult * blob1_y[i];
        }
        g.fillPolygon(xpos, ypos, blob1_nvecs, Color.WHITE);
        for (i = 0; i < blob2_nvecs; ++i) {
            xpos[i] = left + mult * blob2_x[i];
            ypos[i] = top + mult * blob2_y[i];
        }
        g.fillPolygon(xpos, ypos, blob2_nvecs, Color.WHITE);
        for (i = 0; i < blob3_nvecs; ++i) {
            xpos[i] = left + mult * blob3_x[i];
            ypos[i] = top + mult * blob3_y[i];
        }
        g.fillPolygon(xpos, ypos, blob3_nvecs, Color.WHITE);
    }

    private static void plotSymbolAlgalLumps(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float mult = 0.04f;
        float[] blob1_x = new float[]{48.0f, 55.0f, 62.0f, 65.0f, 65.0f, 62.0f, 67.0f, 78.0f, 87.0f, 87.0f, 85.0f, 84.0f, 78.0f, 68.0f, 58.0f, 56.0f, 55.0f, 54.0f, 51.0f, 37.0f, 26.0f, 21.0f, 21.0f, 24.0f, 23.0f, 29.0f, 33.0f, 27.0f, 18.0f, 14.0f, 15.0f, 14.0f, 19.0f, 27.0f, 33.0f, 41.0f, 42.0f, 42.0f, 45.0f, 48.0f};
        float[] blob1_y = new float[]{15.0f, 14.0f, 14.0f, 24.0f, 32.0f, 36.0f, 35.0f, 40.0f, 45.0f, 53.0f, 68.0f, 74.0f, 77.0f, 77.0f, 77.0f, 73.0f, 66.0f, 71.0f, 78.0f, 80.0f, 78.0f, 71.0f, 66.0f, 63.0f, 54.0f, 51.0f, 47.0f, 51.0f, 48.0f, 38.0f, 29.0f, 19.0f, 15.0f, 16.0f, 12.0f, 13.0f, 19.0f, 25.0f, 18.0f, 15.0f};
        int blob1_nvecs = 40;
        float[] xpos = new float[40];
        float[] ypos = new float[40];
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        left = left + width / 2.0f - mult * 87.0f / 2.0f;
        top = top + height / 2.0f - mult * 80.0f / 2.0f;
        for (int i = 0; i < blob1_nvecs; ++i) {
            xpos[i] = left + mult * blob1_x[i];
            ypos[i] = top + mult * blob1_y[i];
        }
        g.fillPolygon(xpos, ypos, blob1_nvecs, Color.WHITE);
    }

    private static void plotSymbolBivalve(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float mult = 0.04f;
        float[] blob1_x = new float[]{9.0f, 23.0f, 15.0f, 9.0f, 14.0f, 30.0f, 50.0f, 72.0f, 85.0f, 91.0f, 86.0f, 77.0f, 91.0f, 9.0f};
        float[] blob1_y = new float[]{92.5f, 74.5f, 64.5f, 47.5f, 26.5f, 13.5f, 7.5f, 13.5f, 26.5f, 47.5f, 64.5f, 74.5f, 92.5f, 92.5f};
        int blob1_nvecs = 14;
        float[] xpos = new float[14];
        float[] ypos = new float[14];
        left = left + width / 2.0f - mult * 91.0f / 2.0f;
        top = top + height / 2.0f - mult * 92.5f / 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        for (int i = 0; i < blob1_nvecs; ++i) {
            xpos[i] = left + mult * blob1_x[i];
            ypos[i] = top + mult * blob1_y[i];
        }
        g.fillPolygon(xpos, ypos, blob1_nvecs, Color.WHITE);
        g.drawLine(left + mult * 50.0f, top + mult * 8.0f, left + mult * 50.0f, top + mult * 69.0f);
        g.drawLine(left + mult * 14.0f, top + mult * 25.0f, left + mult * 39.0f, top + mult * 75.0f);
        g.drawLine(left + mult * 84.0f, top + mult * 24.0f, left + mult * 59.0f, top + mult * 75.0f);
        g.drawLine(left + mult * 27.0f, top + mult * 16.0f, left + mult * 43.0f, top + mult * 70.0f);
        g.drawLine(left + mult * 73.0f, top + mult * 16.0f, left + mult * 56.0f, top + mult * 68.0f);
    }

    private static void plotSymbolBrachiopod(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float mult = 0.04f;
        float[] blob1_x = new float[]{11.0f, 89.0f, 75.0f, 56.0f, 50.0f, 44.0f, 25.0f, 11.0f, 11.0f};
        float[] blob1_y = new float[]{15.0f, 15.0f, 31.0f, 62.0f, 85.0f, 62.0f, 31.0f, 16.0f, 15.0f};
        int blob1_nvecs = 9;
        float[] xpos = new float[9];
        float[] ypos = new float[9];
        left = left + width / 2.0f - mult * 89.0f / 2.0f;
        top = top + height / 2.0f - mult * 85.0f / 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        for (int i = 0; i < blob1_nvecs; ++i) {
            xpos[i] = left + mult * blob1_x[i];
            ypos[i] = top + mult * blob1_y[i];
        }
        g.fillPolygon(xpos, ypos, blob1_nvecs, Color.WHITE);
    }

    private static void plotSymbolBryzoan(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float mult = 0.04f;
        float[] blob1_x = new float[]{20.0f, 40.0f, 50.0f, 60.0f, 80.0f, 62.0f, 62.0f, 38.0f, 38.0f, 38.0f, 20.0f};
        float[] blob1_y = new float[]{15.0f, 15.0f, 40.0f, 15.0f, 15.0f, 60.0f, 85.0f, 85.0f, 62.0f, 62.0f, 15.0f};
        int blob1_nvecs = 11;
        float[] xpos = new float[11];
        float[] ypos = new float[11];
        left = left + width / 2.0f - mult * 80.0f / 2.0f;
        top = top + height / 2.0f - mult * 85.0f / 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        for (int i = 0; i < blob1_nvecs; ++i) {
            xpos[i] = left + mult * blob1_x[i];
            ypos[i] = top + mult * blob1_y[i];
        }
        g.fillPolygon(xpos, ypos, blob1_nvecs, Color.WHITE);
    }

    private static void plotSymbolFormaniferaLargeBenthic(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float mult = 0.04f;
        float[] blob1_x = new float[]{50.0f, 70.0f, 80.0f, 70.0f, 50.0f, 30.0f, 20.0f, 30.0f, 50.0f};
        float[] blob1_y = new float[]{10.0f, 20.0f, 50.0f, 80.0f, 90.0f, 80.0f, 50.0f, 20.0f, 10.0f};
        int blob1_nvecs = 9;
        float[] xpos = new float[11];
        float[] ypos = new float[11];
        g.setColor(Color.BLACK);
        g.setStroke(0.15f);
        left = left + width / 2.0f - mult * 80.0f / 2.0f;
        top = top + height / 2.0f - mult * 90.0f / 2.0f;
        for (int i = 0; i < blob1_nvecs; ++i) {
            xpos[i] = left + mult * blob1_x[i];
            ypos[i] = top + mult * blob1_y[i];
        }
        g.fillPolygon(xpos, ypos, blob1_nvecs, Color.WHITE);
        g.drawLine(left + mult * 50.0f, top + mult * 10.0f, left + mult * 50.0f, top + mult * 90.0f);
        g.fillEllipse(left + mult * 43.0f, top + mult * 43.0f, mult * 14.0f, mult * 14.0f, Color.BLACK);
    }

    private static void plotSymbolFormaniferaSmallBenthic(SBGraphics g, float left, float top, float width, float height, boolean mono) {
        float mult = 0.04f;
        float[] blob1_x = new float[]{76.0f, 91.0f, 71.0f, 61.0f, 46.0f, 34.0f, 26.0f, 18.0f, 14.0f, 13.0f, 16.0f, 20.0f, 26.0f, 35.0f, 43.0f, 55.0f, 67.0f, 76.0f, 84.0f, 87.0f, 85.0f, 81.0f, 74.0f, 76.0f};
        float[] blob1_y = new float[]{37.0f, 22.0f, 12.0f, 11.0f, 12.0f, 16.0f, 23.0f, 32.0f, 43.0f, 56.0f, 68.0f, 79.0f, 85.0f, 90.0f, 92.0f, 93.0f, 92.0f, 85.0f, 72.0f, 61.0f, 50.0f, 40.0f, 36.0f, 37.0f};
        int blob1_nvecs = 24;
        float[] xpos = new float[24];
        float[] ypos = new float[24];
        left = left + width / 2.0f - mult * 84.0f / 2.0f;
        top = top + height / 2.0f - mult * 92.0f / 2.0f;
        g.setColor(Color.BLACK);
        g.setStroke(0.05f);
        for (int i = 0; i < blob1_nvecs; ++i) {
            xpos[i] = left + mult * blob1_x[i];
            ypos[i] = top + mult * blob1_y[i];
        }
        g.fillPolygon(xpos, ypos, blob1_nvecs, Color.WHITE);
        g.drawLine(left + mult * 76.0f, top + mult * 37.0f, left + mult * 63.0f, top + mult * 29.0f);
        g.drawLine(left + mult * 63.0f, top + mult * 29.0f, left + mult * 51.0f, top + mult * 29.0f);
        g.drawLine(left + mult * 51.0f, top + mult * 29.0f, left + mult * 36.0f, top + mult * 36.0f);
        g.drawLine(left + mult * 36.0f, top + mult * 36.0f, left + mult * 29.0f, top + mult * 47.0f);
        g.drawLine(left + mult * 29.0f, top + mult * 47.0f, left + mult * 27.0f, top + mult * 59.0f);
        g.drawLine(left + mult * 29.0f, top + mult * 64.0f, left + mult * 36.0f, top + mult * 71.0f);
        g.drawLine(left + mult * 36.0f, top + mult * 71.0f, left + mult * 48.0f, top + mult * 75.0f);
        g.drawLine(left + mult * 48.0f, top + mult * 75.0f, left + mult * 60.0f, top + mult * 74.0f);
        g.drawLine(left + mult * 60.0f, top + mult * 74.0f, left + mult * 69.0f, top + mult * 67.0f);
        g.drawLine(left + mult * 69.0f, top + mult * 67.0f, left + mult * 72.0f, top + mult * 55.0f);
        g.drawLine(left + mult * 72.0f, top + mult * 55.0f, left + mult * 69.0f, top + mult * 46.0f);
        g.drawLine(left + mult * 69.0f, top + mult * 46.0f, left + mult * 58.0f, top + mult * 40.0f);
        g.drawLine(left + mult * 58.0f, top + mult * 40.0f, left + mult * 49.0f, top + mult * 41.0f);
        g.drawLine(left + mult * 49.0f, top + mult * 41.0f, left + mult * 41.0f, top + mult * 51.0f);
        g.drawLine(left + mult * 41.0f, top + mult * 50.0f, left + mult * 41.0f, top + mult * 60.0f);
        g.drawLine(left + mult * 41.0f, top + mult * 60.0f, left + mult * 48.0f, top + mult * 65.0f);
        g.drawLine(left + mult * 48.0f, top + mult * 65.0f, left + mult * 56.0f, top + mult * 65.0f);
        g.drawLine(left + mult * 56.0f, top + mult * 65.0f, left + mult * 61.0f, top + mult * 62.0f);
        g.drawLine(left + mult * 61.0f, top + mult * 62.0f, left + mult * 62.0f, top + mult * 55.0f);
        g.drawLine(left + mult * 62.0f, top + mult * 55.0f, left + mult * 60.0f, top + mult * 52.0f);
        g.drawLine(left + mult * 60.0f, top + mult * 52.0f, left + mult * 56.0f, top + mult * 51.0f);
        g.drawLine(left + mult * 56.0f, top + mult * 51.0f, left + mult * 52.0f, top + mult * 51.0f);
        g.drawLine(left + mult * 52.0f, top + mult * 51.0f, left + mult * 50.0f, top + mult * 54.0f);
        g.drawLine(left + mult * 50.0f, top + mult * 54.0f, left + mult * 51.0f, top + mult * 57.0f);
        g.drawLine(left + mult * 51.0f, top + mult * 57.0f, left + mult * 53.0f, top + mult * 57.0f);
        g.drawLine(left + mult * 63.0f, top + mult * 29.0f, left + mult * 65.0f, top + mult * 20.0f);
        g.drawLine(left + mult * 39.0f, top + mult * 34.0f, left + mult * 35.0f, top + mult * 29.0f);
        g.drawLine(left + mult * 29.0f, top + mult * 49.0f, left + mult * 22.0f, top + mult * 46.0f);
        g.drawLine(left + mult * 28.0f, top + mult * 58.0f, left + mult * 28.0f, top + mult * 63.0f);
        g.drawLine(left + mult * 30.0f, top + mult * 66.0f, left + mult * 24.0f, top + mult * 69.0f);
        g.drawLine(left + mult * 43.0f, top + mult * 74.0f, left + mult * 41.0f, top + mult * 81.0f);
        g.drawLine(left + mult * 62.0f, top + mult * 72.0f, left + mult * 65.0f, top + mult * 81.0f);
        g.drawLine(left + mult * 72.0f, top + mult * 58.0f, left + mult * 79.0f, top + mult * 58.0f);
    }

    private static void plotDunham(SBGraphics g, float left, float top, float width, float height, boolean mono, int lithID) {
        String[] dmnem = new String[]{"M", "M/W", "W", "W/P", "P", "P/G", "G", "G/B", "B"};
        String[] addDmnem = new String[]{"F", "Ba", "Fr", "R"};
        String mnem = lithID < 1065 ? dmnem[lithID - 1021] : addDmnem[lithID - 1065];
        float base = top + height;
        LithologyPattern.plotLimestone(g, left, top, width, height, mono);
        float xwidth = 0.2f * width;
        float xmid = left + 0.5f * width;
        float xleft = xmid - 0.5f * xwidth;
        g.setColor(Color.WHITE);
        g.fillRect(xleft, top, xwidth, height, Color.WHITE);
        float ymid = 0.5f * (top + base);
        xleft = xmid - 0.5f * xwidth;
        float rectHeight = 5.0f;
        float rectWidth = 10.0f;
        if (lithID == 1021 || lithID == 1023 || lithID == 1025 || lithID == 1027 || lithID == 1029) {
            rectHeight = 3.5f;
            rectWidth = 4.0f;
            g.fillRect(xmid - 2.0f, ymid + 1.75f - rectHeight, rectWidth, rectHeight, Color.WHITE);
        }
        if (lithID == 1022 || lithID == 1024 || lithID == 1026 || lithID == 1028) {
            rectHeight = 3.5f;
            rectWidth = 6.5f;
            g.fillRect(xmid - 3.25f, ymid + 1.75f - rectHeight, rectWidth, rectHeight, Color.WHITE);
        }
        g.setColor(Color.BLACK);
        g.setFont("Arial", 1, 3.0f);
        if (lithID == 1021 || lithID == 1025 || lithID == 1027 || lithID == 1029 || lithID == 1065 || lithID == 1068) {
            g.drawString(mnem, xmid - 1.0f, ymid + 1.25f);
        }
        if (lithID == 1023 || lithID == 1066 || lithID == 1067) {
            g.drawString(mnem, xmid - 1.8f, ymid + 1.25f);
        }
        if (lithID == 1022 || lithID == 1024 || lithID == 1026 || lithID == 1028) {
            g.drawString(mnem, xmid - 3.0f, ymid + 1.25f);
        }
    }

    private static void plotDolomiticDunham(SBGraphics g, float left, float top, float width, float height, boolean mono, int lithID) {
        String[] dmnem = new String[]{"M", "M/W", "W", "W/P", "P", "P/G", "G", "G/B", "B", "F", "Ba", "Fr", "R"};
        String mnem = dmnem[lithID - 1069];
        LithologyPattern.plotDolomite(g, left, top, width, height, mono);
        float base = top + height;
        g.setStroke(0.0f);
        g.setColor(Color.WHITE);
        float xwidth = 0.2f * width;
        float xmid = left + 0.5f * width;
        float ymid = 0.5f * (top + base);
        float xleft = xmid - 0.5f * xwidth;
        float xright = xleft + xwidth;
        g.fillRect(xleft, top, xwidth, height, Color.WHITE);
        float rectHeight = 3.5f;
        float rectWidth = 4.0f;
        if (lithID == 1069 || lithID == 1071 || lithID == 1073 || lithID == 1075 || lithID == 1077 || lithID == 1078 || lithID == 1079 || lithID == 1080 || lithID == 1081) {
            rectHeight = 3.5f;
            rectWidth = 4.0f;
            g.fillRect(xmid - 2.0f, ymid + 1.75f - rectHeight, rectWidth, rectHeight, Color.WHITE);
        }
        if (lithID == 1070 || lithID == 1072 || lithID == 1074 || lithID == 1076) {
            rectHeight = 3.5f;
            rectWidth = 6.5f;
            g.fillRect(xmid - 3.25f, ymid + 1.75f - rectHeight, rectWidth, rectHeight, Color.WHITE);
        }
        g.setColor(Color.BLACK);
        g.setFont("Arial", 1, 3.0f);
        ymid = 0.5f * (top + base);
        if (lithID == 1069 || lithID == 1073 || lithID == 1075 || lithID == 1077 || lithID == 1078 || lithID == 1081) {
            g.drawString(mnem, xmid - 1.0f, ymid + 1.25f);
        }
        if (lithID == 1070 || lithID == 1072 || lithID == 1074 || lithID == 1076) {
            g.drawString(mnem, xmid - 3.0f, ymid + 1.25f);
        }
        if (lithID == 1079 || lithID == 1080) {
            g.drawString(mnem, xmid - 2.0f, ymid + 1.25f);
        }
        if (lithID == 1071) {
            g.drawString(mnem, xmid - 1.6f, ymid + 1.25f);
        }
    }

    public static void draw(Lithology lith, SBGraphics g, float xCentre, float yCentre, boolean mono, boolean drawOutline, boolean noPattern) {
        float height = lith.getHeight();
        float width = lith.getWidth();
        float top = yCentre - 0.5f * height;
        float left = xCentre - 0.5f * width;
        LithologyPattern.draw(lith, g, left, top, width, height, mono, noPattern);
    }

    public static void drawStringer(Lithology lith, SBGraphics g, float xleft, float yc, float drawWidth, boolean mono, boolean drawOutline, boolean noPattern) {
        float height = STRINGER_HEIGHT;
        float top = yc - 0.5f * height;
        g.setStroke(0.0f);
        LithologyPattern.draw(lith, g, xleft, top, drawWidth, height, mono, noPattern);
    }

    public static void draw(Lithology lith, SBGraphics g, float drawX, float drawY, float drawWidth, float drawHeight, boolean mono, boolean noPattern) {
        if (lith.getCmp() == 'S' && drawHeight > STRINGER_HEIGHT) {
            drawY += drawHeight / 2.0f;
            drawHeight = STRINGER_HEIGHT;
        }
        float[] x = new float[]{drawX, drawX + drawWidth, drawX + drawWidth, drawX};
        float[] y = new float[]{drawY, drawY, drawY + drawHeight, drawY + drawHeight};
        boolean drawOutline = false;
        LithologyPattern.draw(lith, g, x, y, 4, mono, drawOutline, noPattern);
    }
}

