/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.sql.SQLException;
import java.text.AttributedString;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import jsbugs.SBPrint;
import model2.AbnScheme;
import model2.SBImage;
import model2.SBdb;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.Userdef;
import model2.Well;
import util.SB;
import util.SBException;

public class LoggingSheet
extends SBPrint {
    double scale = 0.5;
    String font = "Arial";
    private boolean usingSmallFonts = true;
    int fontHeader = 22;
    int fontPanel = 18;
    int fontSmall = 14;
    Font fontBoldHdr = new Font(this.font, 1, this.fontHeader);
    Font fontPlainPanel = new Font(this.font, 0, this.fontPanel);
    Font fontBoldPanel = new Font(this.font, 1, this.fontPanel);
    Font fontPlainSmall = new Font(this.font, 0, this.fontSmall);
    Font fontItalicSmall = new Font(this.font, 2, this.fontSmall);
    Font fontBoldSmall = new Font(this.font, 1, this.fontSmall);
    int pad = 8;
    int margin = 12;
    int pages = 1;
    Well well;
    char units;
    Smpdtl smpdtl;
    Userdef user;
    String analyst;
    int xOccComms = 0;
    List<TaxonOcc> occs = null;
    int imageSize = 200;
    private String bsComment = "";
    private boolean drawWellCode = false;
    private boolean drawComments = true;
    private boolean drawImages = false;
    private boolean drawItalicNames = true;
    private boolean useCodes = false;
    private boolean drawBSComments = false;
    private boolean drawSpecType = true;
    private boolean alwaysShowSemiQuant = false;
    static final int SORT_GENUS = 1;
    static final int SORT_CODE = 2;
    static final int SORT_CAT = 3;
    static final int SORT_ABUND = 4;
    private int sort = 3;

    public LoggingSheet(Well well, Smpdtl smpdtl, Userdef user, char units) throws SQLException, SBException {
        this.well = well;
        this.units = units;
        this.smpdtl = smpdtl;
        this.user = user;
        this.analyst = smpdtl.getAnalyst();
        this.getOccs(this.getSortOrder());
    }

    public void setProperties(boolean wellCode, boolean comments, boolean images, boolean italics, boolean small, boolean useCodes, int sort, boolean bsComments, boolean semiQuant, boolean specType) {
        this.drawWellCode = wellCode;
        this.drawComments = comments;
        this.drawImages = images;
        this.drawItalicNames = italics;
        this.drawSpecType = specType;
        this.setFontSizes(small);
        this.useCodes = useCodes;
        this.sort = sort;
        this.drawBSComments = bsComments;
        this.alwaysShowSemiQuant = semiQuant;
        this.getOccs(this.getSortOrder());
    }

    public void setBSComment(String comment) {
        this.bsComment = comment;
    }

    private void getOccs(Smpdtl.SortOrder order) {
        if (this.smpdtl != null) {
            this.occs = this.smpdtl.getOccurSorted(order);
        }
    }

    private Smpdtl.SortOrder getSortOrder() {
        switch (this.sort) {
            case 3: {
                return Smpdtl.SortOrder.SORT_CATEGORY;
            }
            case 2: {
                return Smpdtl.SortOrder.SORT_ALPHACODE;
            }
            case 4: {
                return Smpdtl.SortOrder.SORT_ABUND;
            }
            case 1: {
                return Smpdtl.SortOrder.SORT_GENUS;
            }
        }
        return Smpdtl.SortOrder.SORT_CATEGORY;
    }

    private void setFontSizes(boolean small) {
        if (small) {
            this.fontHeader = 22;
            this.fontPanel = 18;
            this.fontSmall = 14;
            this.pad = 8;
            this.usingSmallFonts = true;
        } else {
            this.fontHeader = 30;
            this.fontPanel = 26;
            this.fontSmall = 22;
            this.pad = 12;
            this.usingSmallFonts = false;
        }
        this.fontBoldHdr = new Font(this.font, 1, this.fontHeader);
        this.fontPlainPanel = new Font(this.font, 0, this.fontPanel);
        this.fontBoldPanel = new Font(this.font, 1, this.fontPanel);
        this.fontPlainSmall = new Font(this.font, 0, this.fontSmall);
        this.fontItalicSmall = new Font(this.font, 2, this.fontSmall);
    }

    public boolean getDrawWellCode() {
        return this.drawWellCode;
    }

    public boolean getDrawComments() {
        return this.drawComments;
    }

    public boolean getDrawImages() {
        return this.drawImages;
    }

    public boolean getDrawItalicNames() {
        return this.drawItalicNames;
    }

    public boolean getDrawSemiQuant() {
        return this.alwaysShowSemiQuant;
    }

    public boolean getSmallFont() {
        return this.fontHeader == 22;
    }

    public boolean getUseCodes() {
        return this.useCodes;
    }

    public boolean getDrawSpecType() {
        return this.drawSpecType;
    }

    public int getSort() {
        return this.sort;
    }

    public boolean getDrawBSComments() {
        return this.drawBSComments;
    }

    @Override
    void draw(Graphics graphics, int x, int y, int unscaledWidth, int unscaledHeight, int page) {
        Graphics2D g = (Graphics2D)graphics;
        g.scale(this.scale, this.scale);
        int width = (int)((double)unscaledWidth / this.scale);
        int height = (int)((double)unscaledHeight / this.scale);
        g.setColor(Color.BLACK);
        AbnScheme abnScheme = null;
        if (this.alwaysShowSemiQuant) {
            try {
                abnScheme = this.well.getDataModel().getAbnScheme(this.smpdtl.getHeader().getAbnSchID(), true);
            }
            catch (Exception e) {
                SB.showStackError((String)"Error getting abundance scheme: ", (Exception)e);
            }
        }
        int yPos = this.drawMainHeader(g, x, y, width, page, page == 0);
        if (page != 0) {
            this.drawSmallHeader(g, x, y, width, page, true);
        }
        yPos += this.fontPanel + this.pad;
        int xPos = x + this.margin;
        HashMap<TextAttribute, Object> atts = new HashMap<TextAttribute, Object>();
        g.setFont(this.fontPlainSmall);
        Font f = g.getFont();
        atts.put(TextAttribute.FAMILY, f.getFamily());
        atts.put(TextAttribute.SIZE, new Float(f.getSize()));
        atts.put(TextAttribute.FOREGROUND, Color.black);
        int nameWidth = 0;
        for (TaxonOcc occ : this.occs) {
            int strgwidth;
            String txstrg;
            String string = txstrg = this.useCodes && occ.getTaxon().getAlphaCode() != null && !occ.getTaxon().getAlphaCode().isEmpty() ? occ.getTaxon().getAlphaCode() : occ.getTaxon().toString(false, false, false);
            if (this.drawSpecType && occ.getSpecType() > 0) {
                try {
                    txstrg = txstrg + "," + occ.getSpecTypeString();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
            if ((strgwidth = g.getFontMetrics().stringWidth(txstrg)) <= nameWidth) continue;
            nameWidth = strgwidth;
        }
        nameWidth += this.margin;
        ListIterator<TaxonOcc> it = this.occs.listIterator();
        int col = 44;
        int onPage = 0;
        while (it.hasNext()) {
            int commLines = 1;
            TaxonOcc occ = it.next();
            int xOcc = xPos;
            SBImage image = null;
            int imageOffset = 0;
            try {
                if (this.drawComments || this.drawImages) {
                    int commColOffset;
                    this.xOccComms = xOcc + nameWidth + (int)((double)col * 7.5) + (this.smpdtl.hasSplitCountData() ? col * 2 : 0);
                    int imageSpace = width - this.xOccComms;
                    if (this.imageSize > imageSpace) {
                        while (this.imageSize > imageSpace) {
                            this.imageSize -= 20;
                            if (this.imageSize >= 50) continue;
                            System.out.println("No space to write comments or print images");
                            this.drawImages = false;
                            this.drawComments = false;
                            break;
                        }
                    }
                    g.setFont(this.fontPlainSmall);
                    commLines = this.drawComments(g, occ, yPos, this.xOccComms, width, false);
                    image = occ.getImage();
                    if (image != null && this.drawImages) {
                        imageOffset = image.getImage(this.imageSize, this.imageSize, true).getImage().getHeight(null);
                    }
                    int commOffset = 0;
                    if (commLines > 1 && this.drawComments || imageOffset > 0 && (!occ.getComment().isEmpty() || !occ.getColour().isEmpty() || !occ.getPreservation().isEmpty())) {
                        commOffset = (this.fontSmall + this.pad) * commLines;
                    }
                    if ((commColOffset = yPos + imageOffset + commOffset) >= height - this.pad) {
                        yPos = y + this.drawSmallHeader(g, x, y, width, page, false) + this.fontSmall + this.pad;
                        ++onPage;
                        it.previous();
                        continue;
                    }
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (onPage == page) {
                g.setFont(this.fontPlainSmall);
                g.drawString(occ.getTaxon().getCatMnem(), xOcc, yPos);
                xOcc = (int)((double)xOcc + (double)col * 1.5);
                String occTypeString = "";
                if (this.drawSpecType && occ.getSpecType() > 0) {
                    try {
                        occTypeString = "," + occ.getSpecTypeString();
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
                if (this.useCodes && occ.getTaxon().getAlphaCode() != null && !occ.getTaxon().getAlphaCode().isEmpty()) {
                    g.drawString(occ.getTaxon().getAlphaCode(), xOcc, yPos);
                } else if (this.drawItalicNames) {
                    AttributedString attstrg = occ.getTaxon().toAttributedString(false, false, occTypeString, null);
                    attstrg.addAttributes(atts, 0, attstrg.getIterator().getEndIndex());
                    g.drawString(attstrg.getIterator(), xOcc, yPos);
                } else {
                    String strg = occ.getTaxon().toString(false, false) + occTypeString;
                    g.drawString(strg, xOcc, yPos);
                }
                xOcc += nameWidth;
                if (occ.isMarker()) {
                    g.setColor(Color.PINK);
                    g.fillRect(xOcc, yPos - this.fontSmall, this.fontSmall, this.fontSmall);
                    g.setColor(Color.BLACK);
                }
                xOcc += col;
                if (occ.getReworked()) {
                    g.drawString("Rw", xOcc, yPos);
                }
                xOcc += col;
                if (occ.getIdentType() == '?') {
                    g.drawString("?", xOcc, yPos);
                }
                xOcc += col;
                if (occ.isOutsideCount()) {
                    g.drawString("+", xOcc, yPos);
                } else if (this.alwaysShowSemiQuant && abnScheme != null) {
                    g.drawString("" + occ.getSubAbund(abnScheme), xOcc, yPos);
                } else {
                    g.drawString("" + occ.getSubAbund(), xOcc, yPos);
                }
                xOcc += col;
                if (this.smpdtl.hasSplitCountData()) {
                    g.drawString(occ.getCoarse() == 0 ? "" : "" + occ.getCoarse(), xOcc, yPos);
                    g.drawString(occ.getMedium() == 0 ? "" : "" + occ.getMedium(), xOcc += col, yPos);
                    g.drawString(occ.getFine() == 0 ? "" : "" + occ.getFine(), xOcc += col, yPos);
                } else {
                    g.drawString(occ.getMedium() == 0 ? "" : "" + occ.getMedium(), xOcc, yPos);
                }
                xOcc += col;
                if (occ.getCaved()) {
                    g.drawString("Cv", xOcc, yPos);
                }
                xOcc += col;
                g.setFont(this.fontPlainSmall);
                if (this.drawComments) {
                    this.drawComments(g, occ, yPos, this.xOccComms, width, true);
                }
                if (this.drawImages && image != null) {
                    try {
                        int imagePos = yPos;
                        imagePos -= this.fontSmall;
                        if (!(occ.getComment().isEmpty() && occ.getColour().isEmpty() && occ.getPreservation().isEmpty())) {
                            imagePos += (this.fontSmall + this.pad) * commLines;
                        }
                        g.drawImage(image.getImage(this.imageSize, this.imageSize, true).getImage(), this.xOccComms, imagePos, null);
                    }
                    catch (SQLException sql) {
                        sql.printStackTrace();
                    }
                    catch (SBException sbe) {
                        sbe.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            yPos += (this.fontSmall + this.pad) * commLines;
            if (image != null && this.drawImages) {
                yPos += imageOffset + this.pad;
            }
            if (yPos < height - this.pad) continue;
            yPos = y + this.drawSmallHeader(g, x, y, width, page, false) + this.fontSmall + this.pad;
            ++onPage;
        }
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0);
        g.setStroke(stroke);
        if (onPage <= this.pages - 1 && (page + 1 == this.pages || this.pages == 1)) {
            g.drawRect(x, y, width, yPos - y);
        } else {
            g.drawRect(x, y, width, height);
        }
    }

    private int drawComments(Graphics2D g, TaxonOcc occ, int yPos, int xOcc, int width, boolean draw) {
        String comment = occ.getComment();
        String preservation = occ.getPreservation();
        String colour = occ.getColour();
        String comments = comment;
        comments = comments + (preservation.isEmpty() ? "" : (comments.isEmpty() ? preservation : "; " + preservation));
        comments = comments + (colour.isEmpty() ? "" : (comments.isEmpty() ? colour : "; " + colour));
        int lines = 1;
        if (g.getFontMetrics().stringWidth(comments) > width - xOcc - this.margin) {
            StringTokenizer tokeniser = new StringTokenizer(comments, " ");
            String text = "";
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                if (g.getFontMetrics().stringWidth(text + tok) < width - xOcc - this.margin) {
                    text = text + tok + " ";
                    continue;
                }
                if (draw) {
                    g.drawString(text, xOcc, yPos);
                    yPos += this.fontSmall + this.pad;
                }
                text = tok + " ";
                ++lines;
            }
            if (draw) {
                g.drawString(text, xOcc, yPos);
            }
        } else if (draw) {
            g.drawString(comments, xOcc, yPos);
        }
        return lines;
    }

    private int drawMainHeader(Graphics2D g, int x, int y, int width, int page, boolean draw) {
        int yPos = this.drawSmallHeader(g, x, y, width, page, draw);
        int xPos = x + this.margin;
        yPos += this.fontHeader + this.pad;
        if (draw) {
            g.setFont(this.fontBoldHdr);
            String wellName = this.well.getWellName();
            wellName = wellName + (this.drawWellCode ? " (" + this.well.getWellCode() + ")" : "");
            g.drawString(wellName, xPos, yPos);
        }
        yPos = (int)((double)yPos + ((double)this.fontHeader + (double)this.pad * 1.5));
        if (draw) {
            g.drawString("" + this.smpdtl.getSample().toString(this.units), xPos, yPos);
        }
        yPos += this.fontPanel + this.pad + this.pad;
        if (draw) {
            g.setFont(this.fontPlainPanel);
            g.drawString("Analysis suite: " + this.analyst + "/" + this.smpdtl.getAnalyNo(), xPos, yPos);
        }
        yPos += this.fontSmall + this.pad;
        if (draw) {
            g.setFont(this.fontPlainSmall);
            g.drawString("Printed by: " + this.user.getName() + " on: " + new Date(), xPos, yPos);
        }
        yPos += this.pad * 2;
        if (draw) {
            g.drawLine(x, yPos, x + width, yPos);
        }
        yPos += this.fontPanel + this.pad / 2;
        if (draw) {
            g.setFont(this.fontPlainPanel);
            g.drawString("Taxa: " + this.smpdtl.getOccurUnsorted().size() + ", Total count: " + this.smpdtl.getTotalCount(), xPos, yPos);
        }
        yPos += this.pad;
        if (draw) {
            g.drawLine(x, yPos, x + width, yPos);
        }
        if (this.drawBSComments) {
            yPos = this.drawBSComments(g, x, yPos, width, draw);
            if (draw) {
                g.drawLine(x, yPos, x + width, yPos);
            }
        }
        return yPos;
    }

    private int drawBSComments(Graphics2D g, int x, int yPos, int width, boolean draw) {
        int APPROX_MAX_CHARS;
        if (this.bsComment == null || this.bsComment.isEmpty()) {
            return yPos;
        }
        int xPos = x + this.margin;
        yPos += this.fontSmall + this.pad;
        if (draw) {
            g.setFont(this.fontBoldSmall);
            g.drawString("Biostratigraphic comments:", xPos, yPos);
        }
        yPos += this.fontSmall + this.pad / 2;
        if (draw) {
            g.setFont(this.fontPlainSmall);
        }
        int n = APPROX_MAX_CHARS = this.usingSmallFonts ? 116 : 70;
        if (draw && g.getFontMetrics().stringWidth(this.bsComment) > width - this.margin || !draw && this.bsComment.length() > APPROX_MAX_CHARS) {
            StringTokenizer tokeniser = new StringTokenizer(this.bsComment, " ");
            String text = "";
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                if (draw && g.getFontMetrics().stringWidth(text + tok) < width - this.margin || !draw && (text + tok).length() < APPROX_MAX_CHARS) {
                    text = text + tok + " ";
                    continue;
                }
                if (draw) {
                    g.drawString(text, xPos, yPos);
                }
                yPos += this.fontSmall + this.pad / 2;
                text = tok + " ";
            }
            if (!text.isEmpty() && draw) {
                g.drawString(text, xPos, yPos);
            }
        } else if (draw) {
            g.drawString(this.bsComment, xPos, yPos);
        }
        return yPos += this.fontSmall;
    }

    private int drawSmallHeader(Graphics2D g, int x, int y, int width, int page, boolean draw) {
        int xPos = x + this.margin;
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0);
        int yPos = y + this.fontPanel + this.pad;
        if (draw) {
            g.setFont(this.fontBoldPanel);
            g.setStroke(stroke);
            g.drawString("StrataBugs: " + SBdb.getDiscAdj((char)this.smpdtl.getDiscID()) + " Sample Logging Sheet", xPos, yPos);
            g.setFont(this.fontPlainPanel);
            int strgw = g.getFontMetrics().stringWidth((page > 0 ? this.smpdtl.getSample() + " " + this.smpdtl.getHeader() : "") + " - Page XX of YY");
            if (this.pages > 1) {
                g.drawString((page > 0 ? this.smpdtl.getSample() + " " + this.smpdtl.getHeader() + " - " : "") + "Page " + (page + 1) + " of " + this.pages, width - strgw - this.margin, yPos);
            }
        }
        yPos = (int)((double)yPos + (double)this.pad * 1.5);
        if (draw) {
            g.drawLine(x, yPos, x + width, yPos);
        }
        return yPos;
    }

    @Override
    int getnPages(int unscaledHeight, int unscaledWidth) {
        int width = (int)((double)unscaledWidth / this.scale);
        int height = (int)((double)unscaledHeight / this.scale);
        int headerHeight = this.drawMainHeader(null, 0, 0, width, 0, false);
        int txLineHeight = this.fontSmall + this.pad;
        int ntaxa = this.smpdtl.getOccurUnsorted().size();
        int totalHeight = headerHeight + txLineHeight * (ntaxa + 5);
        int imageSpace = 0;
        if (this.drawImages) {
            for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
                try {
                    if (occ.getImage() == null) continue;
                    imageSpace += this.imageSize + this.pad;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        totalHeight += imageSpace;
        int nPages = 1;
        while (nPages * height < totalHeight) {
            ++nPages;
        }
        this.pages = nPages;
        return nPages;
    }
}

