/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import jsbugs.SBPrint;
import model2.Lastval;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import util.SB;
import util.SBException;

public class LoggingSheetCodes
extends SBPrint {
    double scale = 0.5;
    static final int MIN_COL_WIDTH = 275;
    boolean abbreviateGenus = true;
    boolean includeCat = true;
    static final int SORT_CODE = 0;
    static final int SORT_CAT = 1;
    static final int SORT_GENUS = 2;
    static final int SORT_SPECIES = 3;
    int sortOrder = 1;
    boolean subHeadings = true;
    boolean totalsCol = false;
    List<Object> master;
    LinkedList<LinkedList<Object>> pages;
    int dictID;
    LinkedList<TxGroup> groups;
    final String font = "Arial";
    private int fontSize = 14;
    int pad;
    final int fontSizeLarge = 20;
    Font fontPlain = new Font("Arial", 0, this.fontSize);
    Font fontBold = new Font("Arial", 1, this.fontSize);
    Font fontLarge = new Font("Arial", 1, 20);
    final int headerHeight = 60;
    final String dictTitle;
    int nColumns = 3;
    final int nEmpty;
    final String sheetName;

    LoggingSheetCodes(LinkedList<TxGroup> groups, SBdb sbdb, int dictID, int nEmpty, String sheetName) throws SQLException, SBException {
        this.dictID = dictID;
        this.dictTitle = sbdb.getSipmDict(dictID);
        this.groups = groups;
        this.nEmpty = nEmpty;
        this.sheetName = sheetName;
        this.init(sbdb);
    }

    private void init(SBdb sbdb) throws SQLException, SBException {
        this.decode(sbdb);
        this.initMaster(sbdb);
        this.setFontSize(this.fontSize);
    }

    void initMaster(SBdb sbdb) throws SQLException, SBException {
        Taxon.SortOrder order;
        LinkedList masterList = new LinkedList();
        switch (this.sortOrder) {
            case 0: {
                order = Taxon.SortOrder.SORT_SIPMCODE;
                break;
            }
            case 2: {
                order = Taxon.SortOrder.SORT_GENUS;
                break;
            }
            case 3: {
                order = Taxon.SortOrder.SORT_SPECIES;
                break;
            }
            default: {
                order = Taxon.SortOrder.SORT_CATEGORY;
            }
        }
        for (TxGroup group : this.groups) {
            Collection txGroupTaxa = sbdb.getTxGroupTaxa(group);
            if (this.subHeadings && this.groups.size() > 1) {
                LinkedList txGroupTaxaList = new LinkedList(txGroupTaxa);
                Taxon.sort(txGroupTaxaList, (Taxon.SortOrder)order, (int)this.dictID);
                masterList.addAll(txGroupTaxaList);
                continue;
            }
            masterList.addAll(txGroupTaxa);
        }
        if (!this.subHeadings || this.groups.size() <= 1) {
            Taxon.sort(masterList, (Taxon.SortOrder)order, (int)this.dictID);
        }
        this.master = new LinkedList<Object>();
        this.master.addAll(masterList);
        if (this.subHeadings) {
            if (this.groups.size() > 1) {
                int totalIndex = 0;
                for (TxGroup group : this.groups) {
                    this.master.add(totalIndex, group.getName());
                    totalIndex += group.getSize() + 1;
                }
            } else if (order == Taxon.SortOrder.SORT_CATEGORY) {
                ListIterator<Object> it = this.master.listIterator();
                String current = null;
                while (it.hasNext()) {
                    Taxon t = (Taxon)it.next();
                    if (current == null || !t.getCatMnem().equals(current)) {
                        it.previous();
                        it.add(t.getCatMnem());
                        it.next();
                    }
                    current = t.getCatMnem();
                }
            }
        }
        for (int i = 0; i < this.nEmpty; ++i) {
            this.master.add(null);
        }
    }

    @Override
    int getnPages(int unscaledHeight, int unscaledWidth) {
        int pageHeight = (int)((double)unscaledHeight / this.scale);
        int pageWidth = (int)((double)unscaledWidth / this.scale);
        this.pages = new LinkedList();
        return this.getnPages(pageHeight, pageWidth, this.fontSize, this.nColumns, this.pages);
    }

    int getnPages(int pageHeight, int pageWidth, int fontSize, int nColumns, LinkedList<LinkedList<Object>> pages) {
        int txLineHeight = fontSize + (int)((double)fontSize * 0.75);
        LinkedList<Object> page = new LinkedList<Object>();
        int colHeight = 60 + txLineHeight;
        int cols = 1;
        for (Object o : this.master) {
            if (colHeight + txLineHeight > pageHeight) {
                if (++cols > nColumns) {
                    pages.add(page);
                    page = new LinkedList();
                    cols = 1;
                }
                colHeight = (pages.size() > 0 ? 0 : 60) + txLineHeight;
            }
            page.add(o);
            colHeight += txLineHeight;
        }
        pages.add(page);
        return pages.size();
    }

    @Override
    void draw(Graphics graphics, int x, int y, int unscaledWidth, int unscaledHeight, int pageIndex) {
        int ix;
        String[] titles;
        float[] widths;
        Graphics2D g = (Graphics2D)graphics;
        g.scale(this.scale, this.scale);
        int width = (int)((double)unscaledWidth / this.scale);
        int pageHeight = (int)((double)unscaledHeight / this.scale);
        int vertPad = 2;
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(0.75f));
        int ypos = y;
        if (pageIndex == 0) {
            g.setFont(this.fontLarge);
            String header2 = this.sheetName + " (" + this.dictTitle + ")";
            String header1 = "Well:                       Sample:                     Type:            Discipline:             Analyst:";
            g.drawString(header1, x + 2, y + 20);
            g.drawString(header2, x + 2, y + 40 + this.pad / 2);
            ypos += 60;
        }
        int totalUnits = 20;
        int unit = width / (totalUnits * this.nColumns + (this.nColumns - 1));
        if (this.totalsCol) {
            widths = new float[]{(float)unit * 3.5f, (float)unit * 6.0f, (float)unit * 1.0f, (float)unit * 1.0f, (float)unit * 8.5f};
            titles = new String[]{"Code", "Count", "Q", "\u03a3", "Species Name"};
        } else {
            widths = new float[]{(float)unit * 3.5f, (float)unit * 7.0f, (float)unit * 1.0f, (float)unit * 8.5f};
            titles = new String[]{"Code", "Count", "Q", "Species Name"};
        }
        int xpos = x;
        List taxa = this.pages.get(pageIndex);
        ypos += this.fontSize + this.pad;
        g.setFont(this.fontPlain);
        Area pageArea = new Area(new Rectangle(0, 0, width, pageHeight));
        try {
            for (int i = 0; i < taxa.size(); ++i) {
                Object o = taxa.get(i);
                ypos += this.fontSize + this.pad / 2;
                if (o != null) {
                    if (o instanceof Taxon) {
                        Taxon t = (Taxon)o;
                        ix = xpos + 2;
                        String codeString = "" + t.getSipmCode(this.dictID);
                        g.drawString(codeString, (int)((float)xpos + widths[0] / 2.0f - (float)(g.getFontMetrics().stringWidth(codeString) / 2)), ypos);
                        for (int k = 0; k < widths.length - 1; ++k) {
                            ix = (int)((float)ix + widths[k]);
                        }
                        String tString = this.getTaxonString(t, g, widths[widths.length - 1]);
                        g.drawString(tString, ix, ypos);
                    } else if (o instanceof String) {
                        g.setColor(Color.LIGHT_GRAY);
                        pageArea.subtract(new Area(new Rectangle(xpos, ypos - this.fontSize - this.pad / 2, unit * totalUnits, this.fontSize + this.pad)));
                        g.fillRect(xpos, ypos - this.fontSize - this.pad / 2, unit * totalUnits, this.fontSize + this.pad);
                        g.setColor(Color.BLACK);
                        g.setFont(this.fontBold);
                        g.drawString((String)o, xpos + unit * totalUnits / 2 - g.getFontMetrics().stringWidth((String)o) / 2, ypos);
                        g.setFont(this.fontPlain);
                    }
                }
                g.setColor(Color.DARK_GRAY);
                g.drawLine(xpos, ypos += this.pad / 2, xpos + unit * totalUnits, ypos);
                g.setColor(Color.BLACK);
                if (ypos - y + (this.fontSize + this.pad) <= pageHeight) continue;
                ypos = y + (pageIndex == 0 ? 60 : 0) + this.fontSize + this.pad;
                xpos += unit * (totalUnits + 1);
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        int nRowsLeft = taxa.size();
        g.setFont(this.fontBold);
        g.setClip(pageArea);
        for (int j = 0; j < this.nColumns; ++j) {
            int totalHeight;
            ix = xpos = x + j * unit * (totalUnits + 1);
            ypos = y + (pageIndex == 0 ? 60 : 0) + this.fontSize + this.pad / 2;
            for (int k = 0; k < widths.length; ++k) {
                g.drawString(titles[k], (int)((float)ix + (widths[k] / 2.0f - (float)(g.getFontMetrics().stringWidth(titles[k]) / 2))), ypos);
                ix = (int)((float)ix + widths[k]);
            }
            g.drawLine(xpos, ypos + this.pad / 2, xpos + unit * totalUnits, ypos + this.pad / 2);
            for (totalHeight = this.fontSize + this.pad; totalHeight < pageHeight - (pageIndex == 0 ? 60 : 0) - this.fontSize - this.pad && nRowsLeft > 0; totalHeight += this.fontSize + this.pad, --nRowsLeft) {
            }
            ypos = pageIndex == 0 ? y + 60 : y;
            int jx = xpos;
            g.setColor(Color.DARK_GRAY);
            for (int i = 0; i < widths.length - 1; ++i) {
                jx = (int)((float)jx + widths[i]);
                g.drawLine(jx, ypos, jx, ypos + totalHeight);
            }
            g.setColor(Color.BLACK);
            g.drawRect(xpos, ypos, unit * totalUnits, totalHeight);
            if (nRowsLeft == 0) break;
        }
    }

    String getTaxonString(Taxon t, Graphics2D g, float maxWidth) {
        float width;
        String taxonString = t.toGenString(this.abbreviateGenus, this.includeCat);
        if (this.abbreviateGenus) {
            block0: for (LinkedList linkedList : this.pages) {
                for (Object taxon : linkedList) {
                    if (taxon == null || taxon instanceof String || !((Taxon)taxon).toGenString(this.abbreviateGenus, this.includeCat).equals(taxonString) || taxon == t) continue;
                    taxonString = t.toGenString(false, this.includeCat);
                    break block0;
                }
            }
        }
        if ((width = (float)g.getFontMetrics().stringWidth(taxonString)) > maxWidth) {
            block5: {
                do {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((float)g.getFontMetrics().stringWidth(stringBuilder.append(taxonString).append("...").toString()) > maxWidth - 2.0f)) break block5;
                    if (taxonString.length() >= 2) continue;
                    return null;
                } while (!(taxonString = taxonString.substring(1, taxonString.length())).isEmpty());
                return "";
            }
            taxonString = "..." + taxonString.trim();
        }
        return taxonString;
    }

    private void decode(SBdb sbdb) {
        try {
            String params = Lastval.getString((SBdb)sbdb, (String)"LOGSHTCODE");
            if (params.isEmpty()) {
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                boolean bl = this.abbreviateGenus = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.includeCat = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.sortOrder = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.setFontSize(Integer.parseInt(tok.nextToken()));
            }
            if (tok.hasMoreTokens()) {
                this.nColumns = Integer.parseInt(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                boolean bl = this.subHeadings = Integer.parseInt(tok.nextToken()) == 1;
            }
            if (tok.hasMoreTokens()) {
                this.totalsCol = Integer.parseInt(tok.nextToken()) == 1;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.pad = (int)((double)fontSize * 0.75);
        if (this.pad % 2 > 0) {
            --this.pad;
        }
    }

    int getFontSize() {
        return this.fontSize;
    }

    private String getString(Graphics2D g, String string, float maxWidth) {
        if (string.isEmpty()) {
            return string;
        }
        float width = g.getFontMetrics().stringWidth(string);
        if (width > maxWidth) {
            block3: {
                do {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((float)g.getFontMetrics().stringWidth(stringBuilder.append(string).append("...").toString()) > maxWidth - 2.0f)) break block3;
                    if (string.length() >= 2) continue;
                    return null;
                } while (!(string = string.substring(0, string.length() - 1)).isEmpty());
                return "";
            }
            string = string.trim() + "...";
        }
        return string;
    }
}

