/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.Clip;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.DialogTaxonImages;
import jsbugs.FrameSamples;
import jsbugs.TaxonTransferHandler;
import model2.AbnScheme;
import model2.ImageSet;
import model2.Overlay;
import model2.SBdb;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import util.SB;
import util.SBException;

public class OverlayJPanel
extends JPanel
implements Printable,
Observer,
DragGestureListener {
    private Overlay overlay = null;
    public float zoom = 1.0f;
    public static final float pixPerMM = 2.8346457f;
    public boolean antialias = true;
    final int nControls = 16;
    static final float BAR_HEIGHT = 50.0f;
    final Color selectedColour = new Color(255, 255, 150);
    final Color loggedColour = new Color(230, 230, 255);
    final Color SBUGSPURPLE = new Color(148, 49, 99);
    final Color bgGrey = new Color(240, 240, 240);
    int selectedCell = -1;
    int lastCell = -1;
    Point[] cellClicked = new Point[2];
    boolean inDrag = false;
    boolean countMode = true;
    Smpdtl smpdtl;
    Well well;
    SBdb db;
    int taxonTextSize = 0;
    Font taxonFont;
    int nCategories = 0;
    HashMap<Integer, Color> genColours = new HashMap();
    boolean isQuant = true;
    boolean isReworked = false;
    boolean isCaved = false;
    boolean isMarker = false;
    boolean isQuestionable = false;
    private boolean insertRow = true;
    private int totaliser = 0;
    boolean showCMF = false;
    private UndoableEditSupport undoSupport = new UndoableEditSupport();
    private Clip soundClip;
    private FrameSamples frameSamples;
    Sizes size = Sizes.MEDIUM;
    Font bigFont = new Font("Tahoma", 1, 40);
    static final int BUT_MODE = 0;
    static final int BUT_QUANT_MODE = 1;
    static final int BUT_QUANT = 2;
    static final int BUT_SAMPLE = 3;
    static final int BUT_MKR = 4;
    static final int BUT_CV = 5;
    static final int BUT_RW = 6;
    static final int BUT_CONF = 7;
    static final int BUT_IMAGE = 8;
    static final int BUT_ENTER = 9;
    int[] cBarButtons = new int[]{40, 30, 0, 0, 30, 30, 30, 30, 30, 50};
    Color[] cBarFillColours = new Color[]{Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
    Color[] cBarTextColours = new Color[]{Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.LIGHT_GRAY, Color.LIGHT_GRAY, Color.LIGHT_GRAY, Color.LIGHT_GRAY, Color.BLACK, Color.BLACK};
    String[] cBarText = new String[]{"Design", "Q/SQ", "", "", "Mkr", "Cv", "Rw", "?", "", "ENTER"};
    float cBarColWidth;
    static final int BUT_ROW = 0;
    static final int BUT_COL = 1;
    static final int BUT_CLEAR = 2;
    static final int BUT_ARRANGE = 3;
    static final int BUT_DIMAGE = 4;
    static final int BUT_OK = 5;
    static final int BUT_CANCEL = 6;
    int[] dBarButtons = new int[]{60, 60, 60, 60, 30, 60, 60};
    Color[] dBarFillColours = new Color[]{Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
    Color[] dBarTextColours = new Color[]{Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK, Color.BLACK};
    String[] dBarText = new String[]{"Insert by Row", "Insert by Column", "Remove Selected", "Auto Arrange", "", "OK", "Cancel"};
    float dBarColWidth;
    static final int BUT_COARSE = 100;
    static final int BUT_MED = 101;
    static final int BUT_FINE = 102;
    int[] quantBarButtons = new int[]{1, 1, 1};
    String[][] quantBarText = new String[][]{{"coarse", "medium", "fine"}, {"", "counts", ""}};
    Color[] quantBarFillColours = new Color[]{Color.LIGHT_GRAY, this.SBUGSPURPLE, Color.LIGHT_GRAY};
    Color[] quantBarTextColours = new Color[]{Color.BLACK, Color.WHITE, Color.BLACK};
    float quantBarColWidth;
    int quantX;
    AbnScheme scheme = null;
    int selectedAbn = 1;
    float quantBarWidth = 0.0f;
    Image backgroundImage;
    Image cameraIcon;
    boolean sampleTotalMessage = false;
    String tempCount = "-1";
    LastPos lastPos = null;
    public static final Map<Component, Integer> MULTI_CLICK_MAP = new HashMap<Component, Integer>();
    private Timer timer = new Timer();

    UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }

    Overlay getOverlay() {
        return this.overlay;
    }

    public void setTotaliser(int n) {
        this.totaliser = n;
    }

    void setCMF(boolean cmf) {
        this.showCMF = cmf;
        this.size = Sizes.MEDIUM;
        if (!this.isQuant || this.isQuant && this.showCMF) {
            this.cBarButtons[2] = 175;
            this.cBarButtons[3] = 100;
        } else {
            this.cBarButtons[2] = 0;
            this.cBarButtons[3] = 275;
        }
        this.repaint();
    }

    public int getTotaliser() {
        return this.totaliser;
    }

    void close() {
        this.overlay.deleteObservers();
    }

    public OverlayJPanel(SBdb db, Overlay overlay, Well well, Smpdtl smpdtl, boolean cmf, FrameSamples frameSamples) {
        this.setBackground(Color.WHITE);
        this.db = db;
        this.overlay = overlay;
        this.frameSamples = frameSamples;
        this.setSmpdtl(well, smpdtl);
        if (well == null) {
            this.countMode = false;
            this.setActiveDesignColour(this.insertRow, 0);
            this.setActiveDesignColour(!this.insertRow, 1);
        }
        this.init();
        this.setCMF(cmf);
        overlay.addObserver((Observer)this);
    }

    private void init() {
        this.cameraIcon = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/jsbugs/icon_new/Camera.gif"));
        this.setTransferHandler(new TaxonTransferHandler(null));
        DragSource ds = new DragSource();
        ds.createDefaultDragGestureRecognizer(this, 2, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Cursor cursor = null;
        if (dge.getDragAction() == 1) {
            cursor = DragSource.DefaultCopyDrop;
        }
        TaxonTransferHandler h = (TaxonTransferHandler)this.getTransferHandler();
        dge.startDrag(cursor, h.createTransferable(this));
    }

    public boolean isCountMode() {
        return this.countMode;
    }

    void setSmpdtl(Well w, Smpdtl d) {
        if (w != this.well) {
            this.well = w;
        }
        if (d != this.smpdtl) {
            if (this.smpdtl != null) {
                this.smpdtl.deleteObserver((Observer)this);
            }
            this.smpdtl = d;
            this.smpdtl.addObserver((Observer)this);
        }
        this.sampleTotalMessage = false;
        this.repaint();
    }

    @Override
    public void update(Observable obs, Object obj) {
        this.taxonTextSize = 0;
        this.repaint();
    }

    void setCellRange(int selectedCell, int clickedCell) throws SQLException, SBException {
        int minCol = Math.min(this.getCol(selectedCell), this.getCol(clickedCell));
        int maxCol = Math.max(this.getCol(selectedCell), this.getCol(clickedCell));
        int minRow = Math.min(this.getRow(selectedCell), this.getRow(clickedCell));
        int maxRow = Math.max(this.getRow(selectedCell), this.getRow(clickedCell));
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            if (row < minRow || row > maxRow) continue;
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                if (col < minCol || col > maxCol) continue;
                this.setCellSelection(new Point(row, col), true);
            }
        }
    }

    void setCellSelection(Point cell, boolean selected) throws SQLException, SBException {
        Graphics2D g = (Graphics2D)this.getGraphics();
        Rectangle thisVisibleRect = this.getVisibleRect();
        double gridWidth = thisVisibleRect.getWidth() / (double)this.overlay.getCols();
        double gridHeight = (thisVisibleRect.getHeight() - 50.0) / (double)this.overlay.getRows();
        g.setColor(selected ? this.selectedColour : Color.WHITE);
        int row = cell.x;
        int col = cell.y;
        this.overlay.setSelection(row, col, selected);
        g.fillRect((int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
        g.setColor(Color.BLACK);
        int specID = this.overlay.getSpecID(row, col);
        if (specID > 0) {
            Taxon taxon = this.db.getTaxon(specID);
            this.drawTaxonString(g, this.taxonFont, taxon, (int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight, this.overlay.getCols() / 32);
        }
    }

    public boolean setCellMoveDropRange(Point lastPoint, Point dropPoint) throws SQLException {
        int col;
        int row;
        Graphics2D g = (Graphics2D)this.getGraphics();
        Rectangle thisVisibleRect = this.getVisibleRect();
        double gridWidth = thisVisibleRect.getWidth() / (double)this.overlay.getCols();
        double gridHeight = (thisVisibleRect.getHeight() - 50.0) / (double)this.overlay.getRows();
        int minCol = this.overlay.getCols();
        int maxCol = -1;
        int minRow = this.overlay.getRows();
        int maxRow = -1;
        for (int row2 = 0; row2 < this.overlay.getRows(); ++row2) {
            for (int col2 = 0; col2 < this.overlay.getCols(); ++col2) {
                if (!this.overlay.getSelection(row2, col2)) continue;
                if (col2 < minCol) {
                    minCol = col2;
                }
                if (col2 > maxCol) {
                    maxCol = col2;
                }
                if (row2 < minRow) {
                    minRow = row2;
                }
                if (row2 <= maxRow) continue;
                maxRow = row2;
            }
        }
        boolean canDrop = true;
        int dropCol = this.getCell((Point)dropPoint).x;
        int dropRow = this.getCell((Point)dropPoint).y;
        int dropWidth = maxCol - minCol + 1;
        int dropHeight = maxRow - minRow + 1;
        if (dropRow >= this.overlay.getRows() || dropCol >= this.overlay.getCols()) {
            canDrop = false;
            return canDrop;
        }
        int[][] map = new int[this.overlay.getRows()][this.overlay.getCols()];
        for (row = 0; row < this.overlay.getRows(); ++row) {
            for (col = 0; col < this.overlay.getCols(); ++col) {
                map[row][col] = row >= minRow && row <= maxRow && col >= minCol && col <= maxCol ? 0 : this.overlay.getSpecID(row, col);
            }
        }
        block4: for (row = dropRow; row < dropRow + dropHeight; ++row) {
            if (row >= this.overlay.getRows()) {
                canDrop = false;
                break;
            }
            for (col = dropCol; col < dropCol + dropWidth; ++col) {
                if (col >= this.overlay.getCols()) {
                    canDrop = false;
                    break block4;
                }
                if (map[row][col] <= 0) continue;
                canDrop = false;
                break block4;
            }
        }
        float strokeWidth = 3.0f;
        float[] dash = new float[]{strokeWidth, strokeWidth};
        g.setStroke(new BasicStroke(strokeWidth, 0, 0, 1.0f, dash, 0.0f));
        g.drawRect((int)((double)minCol * gridWidth), (int)((double)minRow * gridHeight), (int)gridWidth * dropWidth, (int)gridHeight * dropHeight);
        if (canDrop) {
            g.setStroke(new BasicStroke(strokeWidth));
            if (lastPoint != null) {
                g.setColor(Color.lightGray);
                g.drawRect((int)((double)this.getCell((Point)lastPoint).x * gridWidth), (int)((double)this.getCell((Point)lastPoint).y * gridHeight), (int)gridWidth * dropWidth, (int)gridHeight * dropHeight);
            }
            g.setColor(Color.red);
            g.drawRect((int)((double)this.getCell((Point)dropPoint).x * gridWidth), (int)((double)this.getCell((Point)dropPoint).y * gridHeight), (int)gridWidth * dropWidth, (int)gridHeight * dropHeight);
        }
        return canDrop;
    }

    void moveSelectedTaxa(Point start) throws SQLException, SBException {
        int row;
        int minCol = this.overlay.getCols();
        int maxCol = -1;
        int minRow = this.overlay.getRows();
        int maxRow = -1;
        for (int row2 = 0; row2 < this.overlay.getRows(); ++row2) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                if (!this.overlay.getSelection(row2, col)) continue;
                if (col < minCol) {
                    minCol = col;
                }
                if (col > maxCol) {
                    maxCol = col;
                }
                if (row2 < minRow) {
                    minRow = row2;
                }
                if (row2 <= maxRow) continue;
                maxRow = row2;
            }
        }
        int[][] map = new int[this.overlay.getRows()][this.overlay.getCols()];
        for (int row3 = 0; row3 < this.overlay.getRows(); ++row3) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                map[row3][col] = row3 >= minRow && row3 <= maxRow && col >= minCol && col <= maxCol ? 0 : this.overlay.getSpecID(row3, col);
            }
        }
        Point startPoint = this.getCell(start);
        int insRow = startPoint.y;
        for (row = 0; row < this.overlay.getRows(); ++row) {
            int insCol = startPoint.x;
            boolean inSelectedRow = false;
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                if (!this.overlay.getSelection(row, col)) continue;
                map[insRow][insCol++] = this.overlay.getSpecID(row, col);
                inSelectedRow = true;
            }
            if (!inSelectedRow) continue;
            ++insRow;
        }
        for (row = 0; row < this.overlay.getRows(); ++row) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                this.overlay.setCell(map[row][col], row, col);
            }
        }
    }

    public void setCellDropRange(Point lastPoint, Point dropPoint, int nItems) throws SQLException {
        Graphics2D g = (Graphics2D)this.getGraphics();
        Rectangle thisVisibleRect = this.getVisibleRect();
        double gridWidth = thisVisibleRect.getWidth() / (double)this.overlay.getCols();
        double gridHeight = (thisVisibleRect.getHeight() - 50.0) / (double)this.overlay.getRows();
        if (lastPoint != null) {
            g.setColor(Color.white);
            this.paintCellDropRange(g, this.getCell(lastPoint), nItems, gridWidth, gridHeight);
        }
        g.setColor(Color.gray);
        this.paintCellDropRange(g, this.getCell(dropPoint), nItems, gridWidth, gridHeight);
        g.setColor(Color.BLACK);
    }

    private void paintCellDropRange(Graphics2D g, Point cell, int cols, int rows, double gridWidth, double gridHeight) throws SQLException {
        for (int row = cell.y; row < cell.y + rows; ++row) {
            for (int col = cell.x; col < cell.x + cols; ++col) {
                g.fillRect((int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
            }
        }
    }

    private void paintCellDropRange(Graphics2D g, Point cell, int nItems, double gridWidth, double gridHeight) throws SQLException {
        block8: {
            int filled = 0;
            if (this.insertRow) {
                for (int row = cell.y; row < this.overlay.getRows(); ++row) {
                    for (int col = cell.x; col < this.overlay.getCols(); ++col) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        g.fillRect((int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
                        if (++filled < nItems) {
                            continue;
                        }
                        break block8;
                    }
                    cell.y = 0;
                }
            } else {
                for (int col = cell.y; col < this.overlay.getCols(); ++col) {
                    for (int row = cell.x; row < this.overlay.getRows(); ++row) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        g.fillRect((int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
                        if (++filled < nItems) {
                            continue;
                        }
                        break block8;
                    }
                    cell.x = 0;
                }
            }
        }
    }

    void fillSpecies(Point start, List<Taxon> list) throws SQLException, SBException {
        block10: {
            Iterator<Taxon> it = list.iterator();
            Point cell = this.getCell(start);
            if (this.insertRow) {
                for (int row = cell.y; row < this.overlay.getRows(); ++row) {
                    for (int col = cell.x; col < this.overlay.getCols(); ++col) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        while (it.hasNext()) {
                            int specID = it.next().getSpecID();
                            if (this.overlay.hasSpecID(specID)) continue;
                            this.overlay.setCell(specID, row, col);
                            this.taxonTextSize = 0;
                            break;
                        }
                        if (it.hasNext()) {
                            continue;
                        }
                        break block10;
                    }
                    cell.y = 0;
                }
            } else {
                for (int col = cell.y; col < this.overlay.getCols(); ++col) {
                    for (int row = cell.x; row < this.overlay.getRows(); ++row) {
                        if (this.overlay.getSpecID(row, col) != 0) continue;
                        while (it.hasNext()) {
                            int specID = it.next().getSpecID();
                            if (this.overlay.hasSpecID(specID)) continue;
                            this.overlay.setCell(specID, row, col);
                            this.taxonTextSize = 0;
                            break;
                        }
                        if (it.hasNext()) {
                            continue;
                        }
                        break block10;
                    }
                    cell.x = 0;
                }
            }
        }
    }

    private void setActiveColour(boolean active, int i) {
        if (active) {
            this.cBarFillColours[i] = Color.RED;
            this.cBarTextColours[i] = Color.BLACK;
        } else {
            this.cBarFillColours[i] = Color.WHITE;
            this.cBarTextColours[i] = Color.LIGHT_GRAY;
        }
    }

    private void setActiveDesignColour(boolean active, int i) {
        if (active) {
            this.dBarFillColours[i] = this.SBUGSPURPLE;
            this.dBarTextColours[i] = Color.WHITE;
        } else {
            this.dBarFillColours[i] = Color.LIGHT_GRAY;
            this.dBarTextColours[i] = Color.BLACK;
        }
    }

    private void setQuantColour(int i) {
        for (int k = 0; k < Sizes.values().length; ++k) {
            this.quantBarFillColours[k] = Color.LIGHT_GRAY;
            this.quantBarTextColours[k] = Color.BLACK;
        }
        this.quantBarFillColours[i - 100] = this.SBUGSPURPLE;
        this.quantBarTextColours[i - 100] = Color.WHITE;
    }

    private void handleQuantMenu(MouseEvent evt) {
        if (this.isQuant) {
            int button = this.handleQuantMenuButton(evt);
            switch (button) {
                case 100: {
                    if (!this.showCMF) {
                        this.size = Sizes.MEDIUM;
                        break;
                    }
                    if (this.size == Sizes.COARSE) break;
                    this.setQuantColour(100);
                    this.size = Sizes.COARSE;
                    break;
                }
                case 101: {
                    if (this.size == Sizes.MEDIUM) break;
                    this.setQuantColour(101);
                    this.size = Sizes.MEDIUM;
                    break;
                }
                case 102: {
                    if (!this.showCMF) {
                        this.size = Sizes.MEDIUM;
                        break;
                    }
                    if (this.size == Sizes.FINE) break;
                    this.setQuantColour(102);
                    this.size = Sizes.FINE;
                }
            }
        } else {
            int button = this.handleQualMenuButton(evt);
            this.selectedAbn = button - 100;
        }
    }

    private void handleCountMenu(MouseEvent evt) {
        int button = this.getMenuButton(evt);
        switch (button) {
            case 0: {
                this.countMode = !this.countMode;
                this.setActiveDesignColour(this.insertRow, 0);
                this.setActiveDesignColour(!this.insertRow, 1);
                break;
            }
            case 1: {
                this.isQuant = !this.isQuant;
                this.setCMF(this.showCMF);
                break;
            }
            case 9: {
                try {
                    Taxon taxon = null;
                    if (this.selectedCell < 0 || (taxon = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell))) == null) break;
                    if (this.isQuant) {
                        this.incrementCount(taxon, true);
                        break;
                    }
                    this.clickedEnter(taxon);
                }
                catch (Exception e) {
                    SB.showStackError((String)e.getMessage(), (Exception)e);
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                this.isMarker = !this.isMarker;
                this.setActiveColour(this.isMarker, 4);
                break;
            }
            case 5: {
                this.isCaved = !this.isCaved;
                this.setActiveColour(this.isCaved, 5);
                break;
            }
            case 6: {
                this.isReworked = !this.isReworked;
                this.setActiveColour(this.isReworked, 6);
                break;
            }
            case 7: {
                this.isQuestionable = !this.isQuestionable;
                this.setActiveColour(this.isQuestionable, 7);
                break;
            }
            case 2: {
                this.handleQuantMenu(evt);
                break;
            }
            case 8: {
                this.overlay.setImages(!this.overlay.showImages());
            }
        }
    }

    private void handleDesignMenu(MouseEvent evt) {
        int button = this.getMenuButton(evt);
        switch (button) {
            case 6: {
                try {
                    this.selectedCell = -1;
                    this.overlay.clearSelection();
                    this.overlay.reload();
                    this.countMode = !this.countMode;
                }
                catch (Exception e) {
                    SB.showStackError((String)e.getMessage(), (Exception)e);
                }
                break;
            }
            case 5: {
                try {
                    this.selectedCell = -1;
                    this.overlay.clearSelection();
                    this.overlay.storeMap();
                    this.countMode = !this.countMode;
                }
                catch (Exception e) {
                    SB.showStackError((String)e.getMessage(), (Exception)e);
                }
                break;
            }
            case 0: {
                if (this.insertRow) break;
                this.insertRow = true;
                this.setActiveDesignColour(this.insertRow, 0);
                this.setActiveDesignColour(!this.insertRow, 1);
                break;
            }
            case 1: {
                if (!this.insertRow) break;
                this.insertRow = false;
                this.setActiveDesignColour(this.insertRow, 0);
                this.setActiveDesignColour(!this.insertRow, 1);
                break;
            }
            case 2: {
                this.overlay.clearSelected();
                this.overlay.clearSelection();
                this.taxonTextSize = 0;
                this.repaint();
                break;
            }
            case 4: {
                this.overlay.setImages(!this.overlay.showImages());
                break;
            }
            case 3: {
                this.overlay.clearSelection();
                this.overlay.autoArrange(this.insertRow);
                this.repaint();
            }
        }
    }

    boolean MouseClicked(MouseEvent evt) {
        boolean isDoubleClick = false;
        if (evt.getClickCount() > 1 && this.cellClicked[0].equals(this.cellClicked[1])) {
            isDoubleClick = true;
        } else {
            Component comp = evt.getComponent();
            if (!MULTI_CLICK_MAP.containsKey(comp)) {
                MULTI_CLICK_MAP.put(comp, 1);
            } else {
                int oldCounter = MULTI_CLICK_MAP.get(comp);
                MULTI_CLICK_MAP.put(comp, oldCounter + 1);
            }
            if (MULTI_CLICK_MAP.get(comp) == 2 && this.cellClicked[0].equals(this.cellClicked[1])) {
                MULTI_CLICK_MAP.remove(comp);
                isDoubleClick = true;
            } else {
                this.timer.schedule((TimerTask)new ClickResetter(comp), 800L);
            }
        }
        try {
            if (this.inMenuBar(evt)) {
                if (this.countMode) {
                    this.handleCountMenu(evt);
                } else {
                    this.handleDesignMenu(evt);
                }
                this.repaint();
                return true;
            }
            this.overlay.clearSelection();
            int clickedCell = this.getCellNumber(evt);
            Taxon taxon = null;
            taxon = this.overlay.getTaxon(this.getRow(clickedCell), this.getCol(clickedCell));
            if (this.countMode) {
                if (taxon == null) {
                    this.selectedCell = -1;
                } else {
                    if (this.selectedCell != clickedCell) {
                        this.tempCount = "-1";
                    }
                    this.selectedCell = clickedCell;
                }
                if (taxon != null && isDoubleClick) {
                    if (this.isQuant) {
                        if (evt.getButton() == 1) {
                            this.incrementCount(taxon, true);
                        } else {
                            this.incrementCount(taxon, false);
                        }
                    } else {
                        this.clickedEnter(taxon);
                    }
                }
                this.repaint();
                return true;
            }
            boolean extendSelection = false;
            int onmask = 64;
            int offmask = 128;
            if ((evt.getModifiersEx() & (onmask | offmask)) == onmask && this.selectedCell >= 0) {
                extendSelection = true;
            }
            Point pcell = this.getCell(evt);
            if (this.overlay.getSelection(pcell.x, pcell.y)) {
                this.setCellSelection(pcell, false);
            } else if (extendSelection) {
                this.setCellRange(this.selectedCell, clickedCell);
            } else {
                this.setCellSelection(pcell, true);
                this.selectedCell = clickedCell;
            }
            if (taxon != null && isDoubleClick) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                DialogTaxonImages dialog = new DialogTaxonImages((Frame)null, true, this.db, taxon);
                dialog.setAlwaysOnTop(true);
                Point p = evt.getLocationOnScreen();
                Rectangle bounds = this.getGraphicsConfiguration().getBounds();
                dialog.setLocation(Math.max(p.x - dialog.getWidth() / 2, bounds.x), Math.max(p.y - dialog.getHeight() / 2, bounds.y));
                this.setCursor(Cursor.getDefaultCursor());
                dialog.setVisible(true);
            }
            this.repaint();
            return true;
        }
        catch (Exception e) {
            System.out.println("Exception in mouseClicked: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    void outsideCount(Taxon taxon) throws SQLException, SBException, FileNotFoundException, IOException {
        if (this.smpdtl == null) {
            return;
        }
        TaxonOcc occ = this.smpdtl.getFss(taxon, this.isReworked, this.isQuestionable ? (char)'?' : 'P', 0);
        if (occ == null) {
            this.undoSupport.postEdit((UndoableEdit)this.smpdtl.insertOccurrence(new TaxonOcc.Builder(this.db, taxon, this.isReworked, this.isQuestionable, 0).marker(this.isMarker).caved(this.isCaved), this.well.getWellID()));
        }
        this.db.commit();
        this.smpdtl.notifyObservers();
    }

    void incrementCount(Taxon taxon, boolean toIncrease) throws SBException, SQLException, FileNotFoundException, IOException {
        if (this.smpdtl == null) {
            return;
        }
        int total = this.smpdtl.getTotalCount();
        TaxonOcc occ = this.smpdtl.getFss(taxon, this.isReworked, this.isQuestionable ? (char)'?' : 'P', 0);
        if (occ != null) {
            if (this.totaliser > 0 && total >= this.totaliser) {
                this.getToolkit().beep();
                if (!this.sampleTotalMessage) {
                    JOptionPane.showMessageDialog(this, "Total count reached", "Samples", 1);
                    this.sampleTotalMessage = true;
                }
                return;
            }
            int nSize = 0;
            switch (this.size) {
                case COARSE: {
                    if (occ.getCoarse() == 0 && !toIncrease) {
                        return;
                    }
                    nSize = 1;
                    break;
                }
                case MEDIUM: {
                    if (occ.getMedium() == 0 && !toIncrease) {
                        return;
                    }
                    nSize = 2;
                    break;
                }
                case FINE: {
                    if (occ.getFine() == 0 && !toIncrease) {
                        return;
                    }
                    nSize = 3;
                }
            }
            if (Integer.parseInt(this.tempCount) > 0) {
                this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), occ, nSize, Integer.parseInt(this.tempCount), true));
            } else {
                this.undoSupport.postEdit(this.smpdtl.incrementOcc(this.well.getWellID(), this.smpdtl.getSample().getSampID(), occ, nSize, toIncrease ? 1 : -1, true));
            }
        } else {
            int increment = 1;
            if (this.totaliser > 0 && total >= this.totaliser) {
                increment = 0;
            }
            if (Integer.parseInt(this.tempCount) > 0) {
                increment = Integer.parseInt(this.tempCount);
            }
            this.undoSupport.postEdit((UndoableEdit)this.smpdtl.insertOccurrence(new TaxonOcc.Builder(this.db, taxon, this.isReworked, this.isQuestionable, 0).marker(this.isMarker).caved(this.isCaved).count(this.size == Sizes.COARSE ? increment : 0, this.size == Sizes.MEDIUM ? increment : 0, this.size == Sizes.FINE ? increment : 0), this.well.getWellID()));
        }
        this.db.commit();
        this.smpdtl.notifyObservers();
        if (this.frameSamples.playOccSounds()) {
            this.playSound();
        }
    }

    private void clickedEnter(Taxon taxon) throws SQLException, SBException, FileNotFoundException, IOException {
        if (this.smpdtl == null) {
            return;
        }
        TaxonOcc occ = this.smpdtl.getFss(taxon, this.isReworked, this.isQuestionable ? (char)'?' : 'P', 0);
        if (this.scheme == null) {
            JOptionPane.showMessageDialog(this, "Select abundance scheme for suite", "Overlay", 1);
            this.getToolkit().beep();
            return;
        }
        String subjAbund = this.scheme.getEntry(this.selectedAbn);
        if (occ != null) {
            if (occ.getTotalCount() > 0) {
                return;
            }
            this.smpdtl.incremenetOcc(this.well.getWellID(), occ, subjAbund);
        } else {
            this.undoSupport.postEdit((UndoableEdit)this.smpdtl.insertOccurrence(new TaxonOcc.Builder(this.db, taxon, this.isReworked, this.isQuestionable, 0).subjAbund(subjAbund).marker(this.isMarker).caved(this.isCaved), this.well.getWellID()));
        }
        this.db.commit();
        this.smpdtl.notifyObservers();
        if (this.frameSamples.playOccSounds()) {
            this.playSound();
        }
    }

    private void playSound() {
        this.soundClip = SB.playSound((Frame)this.frameSamples, (Clip)this.soundClip, (String)"/jsbugs/wav/Swat.wav", (String)"win.sound.exclamation");
    }

    void keyPressed(KeyEvent evt) {
        try {
            if (evt.getKeyCode() == 10) {
                Taxon taxon;
                if (this.selectedCell >= 0 && (taxon = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell))) != null) {
                    if (this.isQuant) {
                        this.incrementCount(taxon, true);
                    } else {
                        this.clickedEnter(taxon);
                    }
                    this.repaint();
                }
                this.tempCount = "-1";
            } else if (evt.getKeyCode() == 127) {
                Taxon taxon;
                this.tempCount = "-1";
                if (this.selectedCell >= 0 && (taxon = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell))) != null) {
                    if (this.isQuant) {
                        this.incrementCount(taxon, false);
                    }
                    this.repaint();
                }
            } else if (evt.getKeyCode() == 107) {
                Taxon taxon = null;
                if (this.selectedCell >= 0 && (taxon = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell))) != null) {
                    if (this.isQuant) {
                        this.outsideCount(taxon);
                    }
                    this.repaint();
                }
                this.tempCount = "-1";
            } else if (evt.getKeyCode() == 40) {
                if (this.selectedCell >= 0) {
                    int row = this.getRow(this.selectedCell) + 1;
                    int col = this.getCol(this.selectedCell);
                    if (row < this.overlay.getRows() && this.overlay.getTaxon(row, col) != null) {
                        this.selectedCell = col + row * this.overlay.getCols();
                        this.tempCount = "-1";
                        this.repaint();
                    }
                }
            } else if (evt.getKeyCode() == 38) {
                if (this.selectedCell >= 0) {
                    int row = this.getRow(this.selectedCell) - 1;
                    int col = this.getCol(this.selectedCell);
                    if (row >= 0 && this.overlay.getTaxon(row, col) != null) {
                        this.selectedCell = col + row * this.overlay.getCols();
                        this.tempCount = "-1";
                        this.repaint();
                    }
                }
            } else if (evt.getKeyCode() == 37) {
                if (this.selectedCell >= 0) {
                    int row = this.getRow(this.selectedCell);
                    int col = this.getCol(this.selectedCell) - 1;
                    if (col >= 0 && this.overlay.getTaxon(row, col) != null) {
                        this.selectedCell = col + row * this.overlay.getCols();
                        this.tempCount = "-1";
                        this.repaint();
                    }
                }
            } else if (evt.getKeyCode() == 39) {
                if (this.selectedCell >= 0) {
                    int row = this.getRow(this.selectedCell);
                    int col = this.getCol(this.selectedCell) + 1;
                    if (col < this.overlay.getCols() && this.overlay.getTaxon(row, col) != null) {
                        this.selectedCell = col + row * this.overlay.getCols();
                        this.tempCount = "-1";
                        this.repaint();
                    }
                }
            } else if (evt.getKeyCode() == 27) {
                if (Integer.parseInt(this.tempCount) > 0) {
                    this.tempCount = "-1";
                    this.repaint();
                }
            } else if (evt.getKeyCode() == 8) {
                if (Integer.parseInt(this.tempCount) > 0) {
                    this.tempCount = this.tempCount.length() > 1 ? this.tempCount.substring(0, this.tempCount.length() - 1) : "-1";
                    this.repaint();
                }
            } else {
                char c = evt.getKeyChar();
                if (c >= '0' && c <= '9') {
                    if (!this.isQuant) {
                        JOptionPane.showMessageDialog(null, "Not in quantitative mode.", "Overlay", 2);
                        return;
                    }
                    this.tempCount = Integer.parseInt(this.tempCount) < 0 ? Character.toString(c) : this.tempCount + Character.toString(c);
                    this.repaint();
                }
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                    if (this.isQuant) {
                        switch (Character.toUpperCase(c)) {
                            case 'Q': {
                                this.isQuestionable = !this.isQuestionable;
                                this.setActiveColour(this.isQuestionable, 7);
                                this.repaint();
                                break;
                            }
                            case 'R': {
                                this.isReworked = !this.isReworked;
                                this.setActiveColour(this.isReworked, 6);
                                this.repaint();
                                break;
                            }
                            case 'C': {
                                this.isCaved = !this.isCaved;
                                this.setActiveColour(this.isCaved, 5);
                                this.repaint();
                                break;
                            }
                            case 'M': {
                                this.isMarker = !this.isMarker;
                                this.setActiveColour(this.isMarker, 4);
                                this.repaint();
                                break;
                            }
                            default: {
                                this.getToolkit().beep();
                            }
                        }
                        return;
                    }
                    for (int i = 0; i < this.scheme.getNClasses(); ++i) {
                        String abr = this.scheme.getEntry(i);
                        if (Character.toLowerCase(c) != Character.toLowerCase(abr.charAt(0))) continue;
                        this.selectedAbn = i;
                        this.repaint();
                        break;
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
            e.printStackTrace();
        }
    }

    boolean inMenuBar(MouseEvent evt) {
        return !((float)evt.getY() < (float)this.getVisibleRect().height - 50.0f);
    }

    void MousePressed(MouseEvent evt) {
        if (this.countMode || !this.inMenuBar(evt)) {
            // empty if block
        }
    }

    void MouseReleased(MouseEvent evt) {
        this.inDrag = false;
        this.cellClicked[0] = this.cellClicked[1];
        this.cellClicked[1] = this.getCell(evt);
    }

    void MouseDragged(MouseEvent evt) {
        try {
            if (!this.inMenuBar(evt)) {
                if (!this.countMode) {
                    this.setCellSelection(this.getCell(evt), true);
                } else {
                    this.inDrag = true;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in mouseDragged: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void MouseMoved(MouseEvent evt) {
        if (!this.inMenuBar(evt)) {
            int cell = this.getCellNumber(evt);
            if (cell == this.lastCell) return;
            try {
                if (this.overlay.getSpecID(this.getRow(cell), this.getCol(cell)) > 0) {
                    Taxon taxon = this.overlay.getTaxon(this.getRow(cell), this.getCol(cell));
                    this.setToolTipText(taxon.toString(false, false));
                } else {
                    if (this.getCol(cell) < this.overlay.getCols() - 1) {
                        this.setToolTipText(null);
                    } else {
                        this.setToolTipText(null);
                    }
                    this.lastPos = null;
                }
                if (this.countMode) return;
            }
            catch (Exception e) {
                System.out.println("Exception in mouseMoved: " + e.getMessage());
            }
            return;
        } else {
            this.setToolTipText(null);
            {
                // empty if block
            }
        }
    }

    Point2D getPoint(Point p) throws NoninvertibleTransformException {
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.zoom * 2.8346457f / 100.0f, this.zoom * 2.8346457f / 100.0f);
        Point2D p2 = tnf.inverseTransform(p, null);
        Point2D.Float pMM = new Point2D.Float((float)p2.getX() / 100.0f, (float)p2.getY() / 100.0f);
        return pMM;
    }

    public void drawLine(Graphics g, Point2D from, Point2D to) {
        g.drawLine((int)(from.getX() * 100.0), (int)(from.getY() * 100.0), (int)(to.getX() * 100.0), (int)(to.getY() * 100.0));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.overlay != null) {
            Cursor cursor = null;
            if (this.overlay.showImages()) {
                cursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            this.drawOverlay((Graphics2D)g);
            this.drawMenuBar((Graphics2D)g);
            if (this.overlay.showImages()) {
                this.setCursor(cursor);
            }
        }
    }

    private void drawOverlay(Graphics2D g) {
        Rectangle thisVisibleRect = this.getVisibleRect();
        double gridWidth = thisVisibleRect.getWidth() / (double)this.overlay.getCols();
        double gridHeight = (thisVisibleRect.getHeight() - 50.0) / (double)this.overlay.getRows();
        if (this.selectedCell >= 0) {
            g.setColor(this.selectedColour);
            int row = this.getRow(this.selectedCell);
            int col = this.getCol(this.selectedCell);
            g.fillRect((int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
            g.setColor(Color.BLACK);
        }
        g.setColor(new Color(60, 60, 60));
        float gridSizeX = 32 / this.overlay.getRows();
        float gridSizeY = 32 / this.overlay.getCols();
        float gridSize = Math.min(gridSizeX, gridSizeY);
        BasicStroke stroke = new BasicStroke(gridSize, 0, 0);
        g.setStroke(stroke);
        g.setColor(Color.LIGHT_GRAY);
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            g.drawLine(0, (int)(gridHeight * (double)row), thisVisibleRect.width, (int)(gridHeight * (double)row));
        }
        stroke = new BasicStroke(gridSize, 0, 0);
        g.setStroke(stroke);
        for (int col = 0; col <= this.overlay.getCols(); ++col) {
            g.drawLine((int)(gridWidth * (double)col), 0, (int)(gridWidth * (double)col), thisVisibleRect.height - 50);
        }
        this.setupTaxonTextSize(g);
        float occFontSize = (float)gridHeight * 0.2f;
        this.taxonFont = new Font("Tahoma", this.overlay.getMaximiseText() ? 0 : 1, this.taxonTextSize);
        Font occFont = new Font("Tahoma", 1, (int)occFontSize);
        g.setColor(Color.BLACK);
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                if (!this.countMode && this.overlay.getSelection(row, col)) {
                    g.setColor(this.selectedColour);
                    g.fillRect((int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
                    g.setColor(Color.BLACK);
                }
                try {
                    int cellNo = this.getCellNumber(row, col);
                    Taxon taxon = this.overlay.getTaxon(row, col);
                    if (taxon == null) continue;
                    boolean taxonDrawn = false;
                    if (this.smpdtl != null) {
                        boolean mkr = false;
                        boolean cv = false;
                        String strg = "";
                        for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
                            if (occ.getTaxon() != taxon) continue;
                            if (occ.isMarker()) {
                                mkr = true;
                            }
                            cv = occ.getCaved();
                            if (occ.getTotalCount() > 0) {
                                strg = strg + (strg.length() > 0 ? "," : "") + occ.getTotalCount();
                                strg = strg + (occ.getIdentType() == '?' ? "?" : "");
                                strg = strg + (occ.getReworked() ? "Rw" : "");
                                continue;
                            }
                            strg = strg + (strg.length() > 0 ? "," : "") + occ.getSubAbund(true);
                            strg = strg + (occ.getIdentType() == '?' ? "?" : "");
                            strg = strg + (occ.getReworked() ? "Rw" : "");
                        }
                        if (cv) {
                            strg = strg + " Cv";
                        }
                        if (strg.length() > 0) {
                            if (cellNo != this.selectedCell) {
                                g.setColor(mkr ? Color.PINK : this.loggedColour);
                                g.fillRect((int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
                                g.setColor(Color.BLACK);
                                this.drawTaxonString(g, this.taxonFont, taxon, (double)col * gridWidth, (double)row * gridHeight, gridWidth, gridHeight, gridSize);
                                taxonDrawn = true;
                            }
                            g.setFont(occFont);
                            g.setColor(this.loggedColour);
                            int fWidth = g.getFontMetrics().stringWidth(strg);
                            int fHeight = g.getFontMetrics().getAscent();
                            g.setColor(Color.BLUE);
                            g.drawString(strg, (float)((int)((double)col * gridWidth)) + gridSize * 2.0f, (float)((int)((double)(row + 1) * gridHeight)) - gridSize * 3.0f);
                            g.setColor(Color.BLACK);
                        }
                    }
                    if (taxonDrawn) continue;
                    this.drawTaxonString(g, this.taxonFont, taxon, (double)col * gridWidth, (double)row * gridHeight, gridWidth, gridHeight, gridSize);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.drawStringTokenized(g, e.getMessage(), (int)((double)col * gridWidth), (int)((double)row * gridHeight), (int)gridWidth, (int)gridHeight);
                }
            }
        }
    }

    private void drawTaxonString(Graphics2D g, Font taxonFont, Taxon taxon, double left, double top, double width, double height, float gridLineWidth) throws SQLException {
        try {
            ImageSet imageSet;
            boolean imageDrawn = false;
            double imageHeight = 0.0;
            if (this.overlay.showImages() && (imageSet = taxon.getImageType()) != null) {
                double imageWidth = width - (double)(gridLineWidth * 3.0f);
                imageHeight = height * 3.0 / 4.0 - (double)(gridLineWidth * 3.0f);
                g.drawImage(imageSet.getImage(0).getImage((int)imageWidth, (int)imageHeight, false).getImage(), (int)(left + (double)gridLineWidth * 1.5), (int)(top + (double)gridLineWidth * 1.5), this);
            }
            if (!imageDrawn) {
                g.setFont(taxonFont);
                String taxonString = null;
                if (this.overlay.useCodes() && taxon.getAlphaCode() != null && taxon.getAlphaCode().length() > 0) {
                    taxonString = taxon.getAlphaCode();
                    this.drawStringClipped(g, taxonString, (int)left, (int)(top + imageHeight), (int)width, (int)(height - imageHeight), 0);
                }
                if (taxonString == null || taxonString.length() == 0) {
                    double textHeight = height - imageHeight;
                    String genusString = taxon.getGenus().toString(false);
                    taxonString = taxon.toString(false, false);
                    taxonString = taxonString.substring(genusString.length()).trim();
                    this.drawStringClipped(g, genusString, (int)left, (int)(top + imageHeight), (int)width, (int)(textHeight / 2.0), 3);
                    this.drawStringClipped(g, taxonString, (int)left, (int)(top + imageHeight + textHeight / 2.0), (int)width, (int)(textHeight / 2.0), 1);
                }
            }
            Color colour = this.getTaxonColour(taxon);
            Color saveColour = g.getColor();
            g.setColor(colour);
            int boxBorderSize = (int)gridLineWidth;
            BasicStroke stroke = new BasicStroke(boxBorderSize, 0, 0);
            g.setStroke(stroke);
            g.drawRect((int)(left + (double)gridLineWidth), (int)(top + (double)gridLineWidth), (int)(width - (double)(2.0f * gridLineWidth)), (int)(height - (double)(2.0f * gridLineWidth)));
            g.setColor(saveColour);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Color getTaxonColour(Taxon taxon) throws SQLException {
        if (this.nCategories >= 2) {
            return this.db.getCatColour(taxon.getCatMnem(), Color.WHITE);
        }
        return this.genColours.get(taxon.getGenID());
    }

    private void drawCountBar(Graphics2D g) {
        this.quantX = 0;
        float windowHeight = (float)this.getVisibleRect().height - 50.0f;
        float barWidth = this.getVisibleRect().width;
        int cBarTotal = 0;
        for (int j = 0; j < this.cBarButtons.length; ++j) {
            cBarTotal += this.cBarButtons[j];
        }
        this.cBarColWidth = barWidth / (float)cBarTotal;
        int total = 0;
        for (int k = 0; k < this.cBarButtons.length; ++k) {
            int width = (int)((float)this.cBarButtons[k] * this.cBarColWidth);
            Rectangle rect = new Rectangle(total, (int)windowHeight, width, (int)(windowHeight + 50.0f));
            g.setColor(this.cBarFillColours[k]);
            if (k == 8) {
                g.setColor(this.overlay.showImages() ? this.loggedColour : Color.WHITE);
            }
            g.fill(rect);
            g.setColor(Color.BLACK);
            g.draw(rect);
            g.setColor(this.cBarTextColours[k]);
            this.drawStringTokenized(g, this.cBarText[k], total, (int)windowHeight, width, 50);
            if (k == 2) {
                this.quantX = total;
                this.quantBarWidth = (float)this.cBarButtons[k] * this.cBarColWidth;
            }
            if (k == 3) {
                g.drawImage(this.backgroundImage, total, (int)windowHeight, width, (int)(windowHeight + 50.0f), this);
                if (this.selectedCell >= 0) {
                    String strg;
                    try {
                        Taxon taxon = this.overlay.getTaxon(this.getRow(this.selectedCell), this.getCol(this.selectedCell));
                        strg = taxon != null ? taxon.toString(false, false) : "";
                    }
                    catch (Exception e) {
                        strg = e.getMessage();
                    }
                    this.drawStringTokenized(g, strg, total, (int)windowHeight, width, 50);
                    if (Integer.parseInt(this.tempCount) > 0) {
                        float occFontSize = 15.000001f;
                        Font occFont = new Font("Tahoma", 1, (int)occFontSize);
                        Font saveFont = g.getFont();
                        g.setFont(occFont);
                        g.setColor(this.loggedColour);
                        int fWidth = g.getFontMetrics().stringWidth(this.tempCount);
                        int fHeight = g.getFontMetrics().getAscent();
                        g.setColor(Color.BLUE);
                        g.drawString(this.tempCount, total + (int)((double)occFontSize / 4.0), (int)windowHeight + fHeight + (int)((double)occFontSize / 4.0));
                        g.setColor(Color.BLACK);
                        g.setFont(saveFont);
                    }
                }
            }
            if (k == 8) {
                int imgWidth = 24;
                g.drawImage(this.cameraIcon, total + (width - imgWidth) / 2, (int)(windowHeight + (50.0f - (float)imgWidth) / 2.0f), imgWidth, imgWidth, this);
            }
            total = (int)((float)total + (float)this.cBarButtons[k] * this.cBarColWidth);
        }
        if (this.isQuant) {
            this.drawQuantBar(g, this.quantX, this.quantBarWidth, (int)windowHeight);
        } else {
            this.drawQualBar(g, this.quantX, this.quantBarWidth, (int)windowHeight);
        }
    }

    private void drawDesignBar(Graphics2D g) {
        float windowHeight = (float)this.getVisibleRect().height - 50.0f;
        float barWidth = this.getVisibleRect().width;
        int dBarTotal = 0;
        for (int j = 0; j < this.dBarButtons.length; ++j) {
            dBarTotal += this.dBarButtons[j];
        }
        this.dBarColWidth = barWidth / (float)dBarTotal;
        int total = 0;
        for (int k = 0; k < this.dBarButtons.length; ++k) {
            g.setColor(Color.BLACK);
            int width = (int)((float)this.dBarButtons[k] * this.dBarColWidth);
            Rectangle dRect = new Rectangle(total, (int)windowHeight, width, (int)(windowHeight + 50.0f));
            g.setColor(this.dBarFillColours[k]);
            g.fill(dRect);
            g.setColor(Color.BLACK);
            g.draw(dRect);
            g.setColor(this.dBarTextColours[k]);
            this.drawStringTokenized(g, this.dBarText[k], total, (int)windowHeight, width, 50);
            if (k == 4) {
                int imgWidth = 24;
                g.drawImage(this.cameraIcon, total + (width - imgWidth) / 2, (int)(windowHeight + (50.0f - (float)imgWidth) / 2.0f), imgWidth, imgWidth, this);
            }
            total += width;
        }
    }

    private void drawQuantBar(Graphics2D g, int topX, float quantBarWidth, int windowHeight) {
        int quantBarTotal = 0;
        for (int j = 0; j < this.quantBarButtons.length; ++j) {
            quantBarTotal += this.quantBarButtons[j];
        }
        this.quantBarColWidth = quantBarWidth / (float)quantBarTotal;
        int total = topX;
        if (this.isQuant) {
            for (int k = 0; k < this.quantBarButtons.length; ++k) {
                Rectangle rect = new Rectangle(total, windowHeight, (int)((float)this.quantBarButtons[k] * this.quantBarColWidth), (int)((float)windowHeight + 50.0f));
                g.setColor(this.quantBarFillColours[k]);
                g.fill(rect);
                g.setColor(Color.BLACK);
                g.draw(rect);
                g.setColor(this.quantBarTextColours[k]);
                this.drawStringTokenized(g, this.quantBarText[this.showCMF ? 0 : 1][k], total, windowHeight, (int)((float)this.quantBarButtons[k] * this.quantBarColWidth), 50);
                total = (int)((float)total + (float)this.quantBarButtons[k] * this.quantBarColWidth);
            }
        }
    }

    private void drawQualBar(Graphics2D g, int topX, float quantBarWidth, int windowHeight) {
        block8: {
            if (this.well != null && this.smpdtl != null) {
                try {
                    this.scheme = this.db.getAbnScheme(this.smpdtl.getHeader().getAbnSchID(), false);
                    if (this.scheme != null) {
                        float qTotal = topX;
                        float colWidth = quantBarWidth / (float)this.scheme.getNClasses();
                        g.setColor(Color.BLACK);
                        for (int k = 0; k < this.scheme.getNClasses(); ++k) {
                            Rectangle rect = new Rectangle((int)qTotal, windowHeight, (int)colWidth, (int)((float)windowHeight + 50.0f));
                            if (k == this.selectedAbn) {
                                g.setColor(this.SBUGSPURPLE);
                                g.fill(rect);
                                g.setColor(Color.BLACK);
                                g.draw(rect);
                                g.setColor(Color.WHITE);
                            } else {
                                g.setColor(Color.LIGHT_GRAY);
                                g.fill(rect);
                                g.setColor(Color.BLACK);
                                g.draw(rect);
                            }
                            this.drawStringTokenized(g, this.scheme.getEntry(k), (int)qTotal, windowHeight, (int)colWidth, 50);
                            qTotal += colWidth;
                        }
                        break block8;
                    }
                    this.drawStringTokenized(g, "Select abundance scheme for suite", topX, windowHeight, (int)quantBarWidth, 50);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.isQuant = true;
                this.setCMF(this.showCMF);
                this.repaint();
            }
        }
    }

    private void drawMenuBar(Graphics2D g) {
        float windowHeight = (float)this.getVisibleRect().height - 50.0f;
        float barWidth = this.getVisibleRect().width;
        GradientPaint grad = new GradientPaint(0.0f, windowHeight, new Color(192, 192, 192), 0.0f, windowHeight + 25.0f, new Color(255, 255, 255), true);
        g.setPaint(grad);
        Rectangle rect = new Rectangle(0, (int)windowHeight, (int)barWidth, 50);
        g.draw(rect);
        g.fill(rect);
        g.setColor(Color.BLACK);
        BasicStroke stroke = new BasicStroke(4.0f, 0, 0);
        g.setStroke(stroke);
        float fontSize = 18.0f;
        g.setColor(Color.BLACK);
        g.setFont(new Font("Tahoma", 1, (int)fontSize));
        if (this.countMode) {
            this.drawCountBar(g);
        } else {
            this.drawDesignBar(g);
        }
    }

    private void setupTaxonTextSize(Graphics2D g) {
        if (this.taxonTextSize > 0) {
            return;
        }
        Rectangle thisVisibleRect = this.getVisibleRect();
        double gridWidth = thisVisibleRect.getWidth() / (double)this.overlay.getCols();
        double gridHeight = (thisVisibleRect.getHeight() - 50.0) / (double)this.overlay.getRows();
        String largest = "";
        HashSet<String> cats = new HashSet<String>();
        this.genColours.clear();
        float fontSize = (float)(gridHeight / 2.0);
        g.setFont(new Font("Tahoma", this.overlay.getMaximiseText() ? 0 : 1, (int)fontSize));
        LinkedList<String> stringLengths = new LinkedList<String>();
        for (int row = 0; row < this.overlay.getRows(); ++row) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                try {
                    int cellNo = this.getCellNumber(row, col);
                    Taxon taxon = this.overlay.getTaxon(row, col);
                    if (taxon == null) continue;
                    cats.add(taxon.getCatMnem());
                    this.genColours.put(taxon.getGenID(), Color.WHITE);
                    String compString = "";
                    if (this.overlay.useCodes() && taxon.getAlphaCode() != null && taxon.getAlphaCode().length() > 0) {
                        compString = taxon.getAlphaCode();
                    } else {
                        int fWidthSpecies;
                        String genus = taxon.getGenus().toString(false);
                        String species = taxon.toString(false, false);
                        species = species.substring(genus.length());
                        int fWidthGenus = g.getFontMetrics().stringWidth(genus);
                        compString = fWidthGenus > (fWidthSpecies = g.getFontMetrics().stringWidth(species)) ? genus : species;
                    }
                    int fWidthComp = g.getFontMetrics().stringWidth(compString);
                    stringLengths.add(compString);
                    int fWidthLong = g.getFontMetrics().stringWidth(largest);
                    if (fWidthComp <= fWidthLong) continue;
                    largest = compString;
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Exception in findTaxonTextSize" + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
        if (this.overlay.getMaximiseText()) {
            // empty if block
        }
        while (true) {
            int fWidth = g.getFontMetrics().stringWidth(largest);
            float totalLength = 0.0f;
            LinkedList<Integer> lengths = new LinkedList<Integer>();
            for (String l : stringLengths) {
                int len = g.getFontMetrics().stringWidth(l);
                totalLength += (float)len;
                lengths.add(len);
            }
            double meanLength = totalLength / (float)stringLengths.size();
            float squareSum = 0.0f;
            Iterator i$ = lengths.iterator();
            while (i$.hasNext()) {
                int l = (Integer)i$.next();
                squareSum = (float)((double)squareSum + Math.pow((double)l - meanLength, 2.0));
            }
            double stdDev = Math.sqrt(squareSum / (float)(stringLengths.size() - 1));
            fWidth = (int)(meanLength + stdDev);
            int fHeight = g.getFontMetrics().getHeight();
            if (this.overlay.getMaximiseText()) {
                if (!((double)(fHeight * 2) > gridHeight)) break;
                fontSize *= 0.875f;
            } else {
                if (!((double)fWidth > gridWidth)) break;
                fontSize *= 0.875f;
            }
            g.setFont(new Font("Tahoma", 1, (int)fontSize));
        }
        this.taxonTextSize = (int)fontSize;
        this.nCategories = cats.size();
        if (this.nCategories < 2) {
            int nGenera = this.genColours.size();
            int colourInc = 0x1000000 / (nGenera + 4);
            Iterator<Integer> it = this.genColours.keySet().iterator();
            boolean i = false;
            Color c = null;
            while (it.hasNext()) {
                c = c == null ? Color.black : new Color(c.getRGB() + colourInc);
                this.genColours.put(it.next(), c);
            }
        }
    }

    private void drawStringClipped(Graphics2D g, String string, int left, int top, int width, int height, int vertJust) {
        int fHeight = g.getFontMetrics().getHeight();
        int border = width / 15;
        float fudgeFactor = 0.9f;
        g.setClip(left, top, width - border, height);
        top = vertJust == 1 ? (int)((float)top + (float)g.getFontMetrics().getAscent() * fudgeFactor) : (vertJust == 3 ? (int)((float)top + ((float)height - (float)g.getFontMetrics().getDescent() * fudgeFactor)) : (int)((float)top + ((float)height / 2.0f + (float)g.getFontMetrics().getAscent() * fudgeFactor / 2.0f)));
        g.drawString(string, left += border, top);
        g.setClip(null);
    }

    private void drawStringTokenized(Graphics2D g, String string, int left, int top, int width, int height) {
        int fWidth = g.getFontMetrics().stringWidth(string);
        int fHeight = g.getFontMetrics().getHeight();
        if (fWidth < width) {
            left += width / 2 - fWidth / 2;
        } else {
            StringTokenizer tok = new StringTokenizer(string);
            if (tok.countTokens() > 1) {
                Font saveFont = g.getFont();
                if (height < fHeight * tok.countTokens()) {
                    g.setFont(new Font(saveFont.getFontName(), saveFont.getStyle(), (int)((float)height / (float)tok.countTokens())));
                }
                height = (int)((float)height / (float)tok.countTokens());
                while (tok.hasMoreTokens()) {
                    this.drawStringTokenized(g, tok.nextToken(), left, top - height / 6, width, height);
                    top += height * 5 / 6;
                }
                g.setFont(saveFont);
                return;
            }
            if (this.overlay.getMaximiseText()) {
                while (string.length() >= 2) {
                    string = string.substring(0, string.length() - 1);
                    fWidth = g.getFontMetrics().stringWidth(string);
                    if (fWidth > width) continue;
                    break;
                }
            } else {
                do {
                    Font saveFont = g.getFont();
                    g.setFont(new Font(saveFont.getFontName(), saveFont.getStyle(), saveFont.getSize() - 1));
                } while ((fWidth = g.getFontMetrics().stringWidth(string)) > width);
            }
        }
        g.drawString(string, left, top += height / 2 + fHeight / 2);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        System.out.println("Printing page number: " + pageIndex);
        if (pageIndex >= 1) {
            return 1;
        }
        float imageWidth = (float)pf.getImageableWidth() / 2.8346457f;
        float imageHeight = (float)pf.getImageableHeight() / 2.8346457f;
        System.out.println(" Imageable Width (mm): " + imageWidth + " Imageable Height (mm): " + imageHeight);
        g.setFont(new Font("Tahoma", 1, 5));
        g.setColor(Color.GREEN);
        g.drawString("StrataBugs v2/Jsbugs Page " + (pageIndex + 1), (int)pf.getImageableX(), (int)pf.getImageableY() + 5);
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        return 0;
    }

    private int handleCountMenuButton(MouseEvent evt) {
        int i = 100;
        int total = 0;
        for (int k = 0; k < this.cBarButtons.length; ++k) {
            total = (int)((float)total + (float)this.cBarButtons[k] * this.cBarColWidth);
            if (evt.getX() >= total || !((float)evt.getX() > (float)total - (float)this.cBarButtons[k] * this.cBarColWidth)) continue;
            i = k;
        }
        return i;
    }

    private int handleQualMenuButton(MouseEvent evt) {
        if (this.scheme == null) {
            return 0;
        }
        int i = 100;
        int total = this.quantX;
        float qualBarColWidth = this.quantBarWidth / (float)this.scheme.getNClasses();
        for (int k = 0; k < this.scheme.getNClasses(); ++k) {
            total = (int)((float)total + qualBarColWidth);
            if (evt.getX() >= total || !((float)evt.getX() > (float)total - qualBarColWidth)) continue;
            i = k;
        }
        return i + 100;
    }

    private int handleQuantMenuButton(MouseEvent evt) {
        int i = 100;
        int total = this.quantX;
        for (int k = 0; k < this.quantBarButtons.length; ++k) {
            total = (int)((float)total + (float)this.quantBarButtons[k] * this.quantBarColWidth);
            if (evt.getX() >= total || !((float)evt.getX() > (float)total - (float)this.quantBarButtons[k] * this.quantBarColWidth)) continue;
            i = k;
        }
        return i + 100;
    }

    private int handleDesignMenuButton(MouseEvent evt) {
        int i = 100;
        int total = 0;
        for (int k = 0; k < this.dBarButtons.length; ++k) {
            total = (int)((float)total + (float)this.dBarButtons[k] * this.dBarColWidth);
            if (evt.getX() >= total || !((float)evt.getX() > (float)total - (float)this.dBarButtons[k] * this.dBarColWidth)) continue;
            i = k;
        }
        return i;
    }

    private int getMenuButton(MouseEvent evt) {
        int i = this.countMode ? this.handleCountMenuButton(evt) : this.handleDesignMenuButton(evt);
        return i;
    }

    Point getCell(MouseEvent evt) {
        Rectangle grid = new Rectangle(this.getVisibleRect().x, this.getVisibleRect().y, this.getVisibleRect().width, this.getVisibleRect().height - 50);
        int row = (int)((float)evt.getY() / (float)grid.height * (float)this.overlay.getRows());
        int col = (int)((float)evt.getX() / (float)grid.width * (float)this.overlay.getCols());
        return new Point(row, col);
    }

    private int getCellNumber(MouseEvent evt) {
        Point cellPoint = this.getCell(evt);
        int cell = cellPoint.y + cellPoint.x * this.overlay.getCols();
        return cell;
    }

    Point getCell(Point location) {
        Rectangle grid = new Rectangle(this.getVisibleRect().x, this.getVisibleRect().y, this.getVisibleRect().width, this.getVisibleRect().height - 50);
        int row = (int)((float)location.getY() / (float)grid.height * (float)this.overlay.getRows());
        int col = (int)((float)location.getX() / (float)grid.width * (float)this.overlay.getCols());
        return new Point(col, row);
    }

    private int getRow(int selectedCell) {
        return selectedCell / this.overlay.getCols();
    }

    private int getCol(int selectedCell) {
        return selectedCell - this.getRow(selectedCell) * this.overlay.getCols();
    }

    private int getCellNumber(int row, int col) {
        return col + row * this.overlay.getCols();
    }

    public AffineTransform setRubberBandMode(Graphics g) {
        AffineTransform saveTransform = ((Graphics2D)g).getTransform();
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.zoom * 2.8346457f / 100.0f, this.zoom * 2.8346457f / 100.0f);
        Color bg = this.getBackground();
        ((Graphics2D)g).transform(tnf);
        int origin = 0;
        g.translate(origin, origin);
        Point visibleRectTopLeft = new Point();
        Point visibleRectBottomRight = new Point();
        try {
            Rectangle thisVisibleRect = this.getVisibleRect();
            tnf.inverseTransform(thisVisibleRect.getLocation(), visibleRectTopLeft);
            tnf.inverseTransform(new Point(thisVisibleRect.x + this.getVisibleRect().width, thisVisibleRect.y + thisVisibleRect.height), visibleRectBottomRight);
            Rectangle transformedVisibleRect = new Rectangle(visibleRectTopLeft, new Dimension(visibleRectBottomRight.x - visibleRectTopLeft.x, visibleRectBottomRight.y - visibleRectTopLeft.y));
            transformedVisibleRect.width += origin;
            transformedVisibleRect.height += origin;
            transformedVisibleRect.x -= origin;
            transformedVisibleRect.y -= origin;
            g.setXORMode(bg);
        }
        catch (NoninvertibleTransformException ex) {
            System.out.println("Failed inverse transform");
        }
        return saveTransform;
    }

    public void clearRubberBandMode(Graphics g, AffineTransform saveTransform) {
        ((Graphics2D)g).setTransform(saveTransform);
        g.setPaintMode();
        g.dispose();
    }

    public class ClickResetter
    extends TimerTask {
        private Component component;

        public ClickResetter(Component component) {
            this.component = component;
        }

        @Override
        public void run() {
            MULTI_CLICK_MAP.remove(this.component);
        }
    }

    class LastPos {
        String string;
        int x;
        int y;

        private LastPos(String string, int x, int y) {
            this.string = string;
            this.x = x;
            this.y = y;
        }
    }

    static enum Sizes {
        COARSE,
        MEDIUM,
        FINE;

    }
}

