/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.List;
import javax.sound.sampled.Clip;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.FrameSamples;
import jsbugs.JPanelWell;
import model2.AbnScheme;
import model2.Overlay;
import model2.SBdb;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import util.SB;
import util.SBException;

public class OverlayWebServer
extends Thread {
    private int port;
    private String clientString = null;
    FrameSamples parent;
    JPanelWell wellPanel;
    Overlay overlay;
    SBdb sbdb;
    boolean needsRefresh = false;
    int tableTextSize;
    boolean useSounds;
    String[] controlLabels = new String[]{"Marker", "Caved", "Reworked", "Questionable", "OutsideCount"};
    boolean[] controlOption = new boolean[]{false, false, false, false, false};
    String subjAbund = null;
    final int MKR = 0;
    final int CV = 1;
    final int RW = 2;
    final int QUESTION = 3;
    final int OUTSIDECOUNT = 4;
    ServerSocket serversocket = null;
    int counts = 0;
    private Clip soundClip;
    private boolean deleteEntry = false;
    private boolean sampleTotalMessage = false;
    private boolean showImages = false;
    private UndoableEditSupport undoSupport = new UndoableEditSupport();

    public OverlayWebServer(int listen_port, int tableTextSize, boolean useSounds, SBdb sbdb, FrameSamples parent, JPanelWell wellPanel, Overlay overlay) {
        this.port = listen_port;
        this.tableTextSize = tableTextSize;
        this.useSounds = useSounds;
        this.sbdb = sbdb;
        this.overlay = overlay;
        this.parent = parent;
        this.wellPanel = wellPanel;
        this.start();
    }

    private void s(String s2) {
        System.out.print(s2);
    }

    void setWellPanel(JPanelWell jpanelWell) {
        this.wellPanel = jpanelWell;
    }

    public void close() {
        if (this.serversocket != null) {
            try {
                this.s("\nClosing server socket...");
                this.serversocket.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        try {
            this.s("Trying to bind to localhost on port " + Integer.toString(this.port) + "...");
            this.serversocket = new ServerSocket(this.port);
        }
        catch (Exception e) {
            this.s("\nFatal Error:" + e.getMessage());
            e.printStackTrace();
            return;
        }
        this.s("OK!\n");
        while (true) {
            try {
                while (true) {
                    this.s("\nWaiting for accept..");
                    Socket connectionsocket = this.serversocket.accept();
                    InetAddress client = connectionsocket.getInetAddress();
                    if (this.clientString == null) {
                        this.clientString = client.getHostAddress();
                    }
                    this.s("\nConnected to server.");
                    BufferedReader input = new BufferedReader(new InputStreamReader(connectionsocket.getInputStream()));
                    DataOutputStream output = new DataOutputStream(connectionsocket.getOutputStream());
                    boolean rejectRequest = false;
                    if (!this.clientString.equalsIgnoreCase(client.getHostAddress())) {
                        this.s("\nWARNING: Rejecting client request from device: " + client.getHostName());
                        rejectRequest = true;
                    }
                    this.http_handler(input, output, rejectRequest);
                }
            }
            catch (SocketException se) {
                this.s("\nSocket closed - exiting read loop");
            }
            catch (Exception e) {
                this.s("\nError:" + e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void http_handler(BufferedReader input, DataOutputStream output, boolean rejectRequest) {
        int method = 0;
        String request = new String();
        try {
            if (rejectRequest) {
                try {
                    output.writeBytes(this.construct_http_header(403, 0));
                    output.close();
                    return;
                }
                catch (Exception e3) {
                    this.s("error: " + e3.getMessage());
                }
            }
            if (input != null) {
                String tmp;
                String tmp2 = tmp = input.readLine();
                this.s("\nRequest received is: " + tmp2);
                if (tmp2 == null) {
                    return;
                }
                if (tmp.startsWith("GET")) {
                    method = 1;
                }
                if (tmp.startsWith("HEAD")) {
                    method = 0;
                }
                if (tmp.startsWith("POST")) {
                    method = 2;
                }
                if (method == 0) {
                    try {
                        output.writeBytes(this.construct_http_header(501, 0));
                        output.close();
                        return;
                    }
                    catch (Exception e3) {
                        this.s("\nerror: " + e3.getMessage());
                    }
                }
                int start = 0;
                int end = 0;
                for (int a = 0; a < tmp2.length(); ++a) {
                    if (tmp2.charAt(a) == ' ' && start != 0) {
                        end = a;
                        break;
                    }
                    if (tmp2.charAt(a) != ' ' || start != 0) continue;
                    start = a;
                }
                request = tmp2.substring(start + 2, end);
            }
        }
        catch (Exception e) {
            this.s("\nException in httphandler: " + e.toString());
            e.printStackTrace();
        }
        try {
            if (request == null || request.isEmpty() || request.equals("?")) {
                int b;
                output.writeBytes(this.construct_http_header(200, 4));
                InputStream headerFile = this.getClass().getResourceAsStream("/jsbugs/html/OverlayHeader.html");
                while ((b = headerFile.read()) != -1) {
                    output.write(b);
                }
                headerFile.close();
                this.writeOverlayHTML(output);
                output.writeBytes("</html>");
                this.needsRefresh = false;
                output.close();
                return;
            }
            this.s("\nClient requested:" + request + "\n");
            if (!this.needsRefresh) {
                switch (method) {
                    case 2: {
                        this.s("\nWriting post request to server");
                        output.writeBytes(this.construct_http_header(200, 5));
                        this.s("\nWritten header");
                        if (request.equals("NextSmpdtl")) {
                            this.s("\nNext sample requested");
                            if (this.wellPanel == null) break;
                            try {
                                this.wellPanel.nextOcc(true);
                                this.sampleTotalMessage = false;
                                output.writeBytes("OK");
                            }
                            catch (SBException ex) {
                                output.writeBytes(ex.getMessage());
                            }
                            break;
                        }
                        if (request.equals("PreviousSmpdtl")) {
                            this.s("\nPrevious sample requested");
                            if (this.wellPanel == null) break;
                            try {
                                this.wellPanel.nextOcc(false);
                                this.sampleTotalMessage = false;
                                output.writeBytes("OK");
                            }
                            catch (SBException ex) {
                                output.writeBytes(ex.getMessage());
                            }
                            break;
                        }
                        if (request.equals("DeleteEntry")) {
                            this.deleteEntry = true;
                            break;
                        }
                        if (request.equals("ToggleImages")) {
                            this.showImages = !this.showImages;
                            break;
                        }
                        if (request.startsWith("ABN-")) {
                            boolean wasAbn = false;
                            if (this.parent.isNumeric()) {
                                output.writeBytes("Press refresh");
                                break;
                            }
                            AbnScheme abnScheme = this.parent.getAbnScheme();
                            if (abnScheme != null) {
                                for (int i = 0; i < abnScheme.getNClasses(); ++i) {
                                    if (!request.equals("ABN-" + abnScheme.getEntry(i))) continue;
                                    this.subjAbund = abnScheme.getEntry(i);
                                    wasAbn = true;
                                    break;
                                }
                            }
                            if (wasAbn) break;
                        }
                        boolean wasControl = false;
                        for (int i = 0; i < this.controlLabels.length; ++i) {
                            if (!request.equals(this.controlLabels[i])) continue;
                            output.writeBytes(this.processControlClick(request, i));
                            wasControl = true;
                            break;
                        }
                        if (wasControl) break;
                        try {
                            this.counts = Integer.parseInt(request);
                        }
                        catch (NumberFormatException ex) {
                            if (this.wellPanel == null || this.wellPanel.getSmpdtl() == null) break;
                            output.writeBytes(this.processCellClick(request));
                            this.s("\nWritten cell content");
                        }
                        break;
                    }
                    case 1: {
                        int specID;
                        Taxon taxon;
                        if (!request.endsWith(".jpg") || (taxon = this.sbdb.getTaxon(specID = Integer.parseInt(request.substring(0, request.indexOf(46))))) == null) break;
                        this.s("Writing image");
                        output.writeBytes(this.construct_http_header(200, 2));
                        taxon.getImageType().getImage(0).writeImage(35, 35, (OutputStream)output);
                        this.s("Written image");
                    }
                }
            } else {
                this.s("\nREFRESH REQUIRED");
                output.writeBytes(this.construct_http_header(200, 5));
                output.writeBytes("<font color=\"red\">REFRESH PAGE</font>");
            }
            output.close();
        }
        catch (Exception e) {
            SB.showStackError((String)e.toString(), (Exception)e);
            this.s("\nError in request body: " + e.toString());
            e.printStackTrace();
        }
    }

    private String construct_http_header(int return_code, int file_type) {
        String s = "HTTP/1.1 ";
        switch (return_code) {
            case 200: {
                s = s + "200 OK";
                break;
            }
            case 400: {
                s = s + "400 Bad Request";
                break;
            }
            case 403: {
                s = s + "403 Connection rejected. There is already a connection to this overlay server.";
                break;
            }
            case 404: {
                s = s + "404 Not Found";
                break;
            }
            case 500: {
                s = s + "500 Internal Server Error";
                break;
            }
            case 501: {
                s = s + "501 Not Implemented";
            }
        }
        s = s + "\r\n";
        s = s + "Cache-Control: no-cache\r\n";
        s = s + "Connection: close\r\n";
        s = s + "Server: StrataBugsOverlay v0\r\n";
        switch (file_type) {
            case 0: {
                break;
            }
            case 1: {
                s = s + "Content-Type: image/jpeg\r\n";
                break;
            }
            case 2: {
                s = s + "Content-Type: image/gif\r\n";
            }
            case 3: {
                s = s + "Content-Type: application/x-zip-compressed\r\n";
            }
            default: {
                s = s + "Content-Type: text/html\r\n";
            }
        }
        s = s + "\r\n";
        return s;
    }

    private void writeOverlayHTML(DataOutputStream output) throws IOException, SQLException, SBException {
        String id;
        int row;
        output.writeBytes("$(document).ready(function(){");
        for (row = 0; row < this.overlay.getRows(); ++row) {
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                if (this.overlay.getSpecID(row, col) <= 0) continue;
                id = "r" + row + "c" + col;
                output.writeBytes("$(\"#" + id + "\").click(function(){ $.post('" + id + "', function(data) {$('#" + id + "').html(data);});$.ajax({data:\"" + id + "-click\"});})\n");
            }
        }
        for (int i = 0; i < this.controlLabels.length; ++i) {
            String strg = "$('#" + this.controlLabels[i] + "').click(function() {$.post('" + this.controlLabels[i] + "', function(data) {$('#" + this.controlLabels[i] + "').html(data);});})\n";
            output.writeBytes(strg);
        }
        output.writeBytes("\n});");
        output.writeBytes("</script>");
        output.writeBytes("</head><body>");
        output.writeBytes("<h3>" + this.overlay.getName() + "</h3>");
        output.writeBytes("<table>");
        for (row = 0; row < this.overlay.getRows(); ++row) {
            output.writeBytes("<tr>");
            for (int col = 0; col < this.overlay.getCols(); ++col) {
                output.writeBytes("<td");
                if (this.overlay.getSpecID(row, col) > 0) {
                    id = "r" + row + "c" + col;
                    if (this.showImages && this.overlay.getTaxon(row, col).hasTypeImage()) {
                        output.writeBytes(" style=\"background:url('" + this.overlay.getTaxon(row, col).getSpecID() + ".jpg') no-repeat;\"");
                    }
                    output.writeBytes(" id='" + id + "'>" + this.getCellContents(this.overlay.getTaxon(row, col)));
                } else {
                    output.writeBytes(">");
                }
                output.writeBytes("</td>");
            }
            output.writeBytes("</tr>");
        }
        output.writeBytes("</table>");
        if (this.parent.isNumeric()) {
            output.writeBytes("<br><form>Add count :<input type='number' id='countsField' onchange='counts()' onclick=\"this.value='';\"></form>");
        } else {
            output.writeBytes("<br>Abundance :<select id='semiQuant' onchange='semiQuant()'> ");
            AbnScheme abnScheme = this.parent.getAbnScheme();
            if (abnScheme != null) {
                this.subjAbund = abnScheme.getEntry(0);
                for (int i = 0; i < abnScheme.getNClasses(); ++i) {
                    output.writeBytes("<option value=\"ABN-" + abnScheme.getEntry(i) + "\">" + abnScheme.getClassName(i) + "</option>");
                }
            }
            output.writeBytes("</select>");
        }
        output.writeBytes("<button onclick='deleteEntry()'>Delete Entry</button><br>");
        this.writeControlBarTable(output);
        output.writeBytes("<button onclick='refresh()'>Refresh</button>");
        output.writeBytes("<button onclick='next(\"PreviousSmpdtl\")'>Previous Sample</button>");
        output.writeBytes("<button onclick='next(\"NextSmpdtl\")'>Next Sample</button>");
        output.writeBytes("<br><button onclick='toggleImages()'>Toggle Images</button>");
        output.writeBytes("</body>");
        if (this.wellPanel.getWell() != null) {
            output.writeBytes("<title>StrataBugs Input: " + this.wellPanel.getWell().getWellName());
            if (this.wellPanel.getSmpdtl() != null) {
                output.writeBytes(", " + this.wellPanel.getSmpdtl().getSample().toString());
            }
            output.writeBytes("</title>");
            if (this.wellPanel.getSmpdtl() != null) {
                output.writeBytes("<h3>Sample contents: " + this.wellPanel.getWell().getWellName() + " " + this.wellPanel.getSmpdtl().getSample().toString() + " " + this.wellPanel.getSmpdtl().getAnalyst() + "</h3><br>");
                if (this.wellPanel.getSmpdtl().getBarren()) {
                    output.writeBytes("<h3>Barren</h3><br>");
                } else {
                    output.writeBytes("<table color='red'>");
                    List occs = this.wellPanel.getSmpdtl().getOccurSorted(Smpdtl.SortOrder.SORT_GENUS);
                    for (TaxonOcc occ : occs) {
                        output.writeBytes("<tr>");
                        output.writeBytes("<td>" + occ.getTaxon().getCatMnem() + "</td>");
                        output.writeBytes("<td>" + occ.getTaxon().toString(false, false) + "</td>");
                        output.writeBytes("<td>" + occ.toAbnString() + "</td>");
                        output.writeBytes("</tr>");
                    }
                    output.writeBytes("</table>");
                }
            }
        }
    }

    private String processControlClick(String request, int controlIndex) {
        this.s("\nIn process control click: request is: " + request);
        this.controlOption[controlIndex] = !this.controlOption[controlIndex];
        return "<font color='" + (this.controlOption[controlIndex] ? "red" : "black") + "'><b>" + request + "</b></font>";
    }

    private String processCellClick(String request) {
        try {
            int row = Integer.parseInt(request.substring(1, request.indexOf(99)));
            int col = Integer.parseInt(request.substring(request.indexOf(99) + 1));
            System.out.println("\nRow: " + row + " Column: " + col);
            Taxon taxon = this.overlay.getTaxon(row, col);
            Smpdtl smpdtl = this.wellPanel.getSmpdtl();
            int total = smpdtl.getTotalCount();
            TaxonOcc occ = smpdtl.getFss(taxon, this.controlOption[2], this.controlOption[3] ? (char)'?' : 'P', 0);
            if (this.deleteEntry) {
                if (occ == null) {
                    this.deleteEntry = false;
                    return this.getCellContents(taxon);
                }
                smpdtl.deleteOcc(this.wellPanel.getWell().getWellID(), occ);
            } else {
                int totaliser = this.parent.getPicklistTotaliser();
                if (this.parent.isNumeric()) {
                    if (this.controlOption[4] || totaliser > 0 && total >= totaliser) {
                        this.counts = 0;
                    } else if (this.counts == 0) {
                        this.counts = 1;
                    }
                }
                if (occ != null && this.subjAbund == null) {
                    if (totaliser > 0 && total >= totaliser) {
                        this.parent.getToolkit().beep();
                        if (!this.sampleTotalMessage) {
                            this.sampleTotalMessage = true;
                            this.s("Sending outside count alert");
                            return this.getCellContents(taxon) + "<br><font strong color=\"red\">Outside count reached</font>";
                        }
                        return this.getCellContents(taxon);
                    }
                    this.undoSupport.postEdit(smpdtl.incrementOcc(this.wellPanel.getWell().getWellID(), this.wellPanel.getSmpdtl().getSample().getSampID(), occ, 2, this.counts, true));
                } else if (occ == null) {
                    TaxonOcc.Builder builder = new TaxonOcc.Builder(this.sbdb, taxon, this.controlOption[2], this.controlOption[3], 0);
                    builder.count(this.counts).subjAbund(this.subjAbund).caved(this.controlOption[1]).marker(this.controlOption[0]);
                    Smpdtl.OccAddDelete edit = smpdtl.insertOccurrence(builder, this.wellPanel.getWell().getWellID());
                    this.undoSupport.postEdit((UndoableEdit)edit);
                    occ = edit.getOccurrence();
                } else {
                    return this.getCellContents(taxon);
                }
            }
            if (this.useSounds) {
                this.playSound();
            }
            this.deleteEntry = false;
            this.counts = 0;
            this.sbdb.commit();
            smpdtl.notifyObservers();
            this.parent.getWellPanel().setSelectedTaxonOcc(occ);
            return this.getCellContents(taxon);
        }
        catch (NumberFormatException ne) {
            ne.printStackTrace();
            return "Bad request: " + request;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Error: " + ex.toString();
        }
    }

    private void playSound() {
        this.soundClip = SB.playSound((Frame)this.parent, (Clip)this.soundClip, (String)"/jsbugs/wav/Swat.wav", (String)"win.sound.exclamation");
    }

    private String getCellContents(Taxon taxon) {
        TaxonOcc occ;
        String retString = taxon.toString(false, false);
        if (this.wellPanel.getSmpdtl() != null && (occ = this.wellPanel.getSmpdtl().getFss(taxon, this.controlOption[2], this.controlOption[3] ? (char)'?' : 'P', 0)) != null) {
            retString = retString + "<br><font strong color=\"blue\">" + occ.toAbnString() + "</font>";
        }
        return retString;
    }

    private void writeControlBarTable(DataOutputStream output) throws IOException {
        output.writeBytes("<br><table cellpadding='8' bgcolor='#DCFFFF'><tr>");
        int width = 100 / this.controlLabels.length;
        for (int i = 0; i < this.controlLabels.length; ++i) {
            output.writeBytes("<td width=" + width + "% id=" + this.controlLabels[i] + "><font color='" + (this.controlOption[i] ? "red" : "black") + "'><b>" + this.controlLabels[i] + "</b></td>");
        }
        output.writeBytes("</tr></table><br>");
    }

    UndoableEditSupport getUndoSupport() {
        return this.undoSupport;
    }
}

