/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.Iterator;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelAgeCurveProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.AgeCurve;
import util.SBException;

public class PanelAgeCurve
extends SBPanel {
    AgeCurve curve;
    private double hScale;
    private SchemeBlock block;
    private PanelAgeCurveProperties p;

    public PanelAgeCurve(SchemeBlock block, AgeCurve curve) {
        this.block = block;
        this.curve = curve;
        this.p = new PanelAgeCurveProperties(curve.getMin(), curve.getMax(), curve.getColour(), curve.getLineWidth());
        this.calcHScale();
    }

    public PanelAgeCurve(SchemeBlock block, AgeCurve curve, String props) {
        this.block = block;
        this.curve = curve;
        this.p = new PanelAgeCurveProperties(props);
        this.calcHScale();
    }

    public int getAgeCurveID() {
        return this.curve.getCurveID();
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                if (this.curve == null) break;
                this.drawCurve(g, x, y, cp, bp, mode);
            }
        }
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                g.setColor(Color.BLACK);
                g.setFont(cp.font, 0, cp.fontPanel);
                g.drawStringAngleCentre("(" + this.curve.getUnits() + ")", x + this.p.width / 2.0f, y + PanelAgeCurve.getPanelHeaderHeight(cp, mode) - cp.fontPanel * 2.0f, 0.0, 0.0, 0.0);
                g.setFont(cp.font, 0, cp.fontSmall);
                g.drawString(this.p.scaleMax + "", x + 0.5f, y + PanelAgeCurve.getPanelHeaderHeight(cp, mode) - cp.fontTiny);
                String min = this.p.scaleMin + "";
                g.drawString(min, x + this.p.width - 0.5f - g.stringWidth(min), y + PanelAgeCurve.getPanelHeaderHeight(cp, mode) - cp.fontTiny);
                for (double d = this.p.scaleMin + 50.0; d < this.p.scaleMax; d += 50.0) {
                    g.drawLine(x + this.scaleValue(d), y + PanelAgeCurve.getPanelHeaderHeight(cp, mode), x + this.scaleValue(d), y + PanelAgeCurve.getPanelHeaderHeight(cp, mode) - cp.fontTiny * 0.7f);
                }
                break;
            }
        }
        return x + this.p.width;
    }

    @Override
    String getCaption() {
        if (this.curve != null) {
            return this.curve.toString();
        }
        return "";
    }

    private void drawCurve(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        g.setColor(this.curve.getColour());
        g.setStroke(this.curve.getLineWidth());
        if (bp.scaleType == BlockProperties.ScaleType.AGE) {
            this.drawCurveAge(g, x, y, p, bp, mode);
        } else {
            this.drawCurveDepth(g, x, y, p, bp, mode);
        }
    }

    private void drawCurveAge(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        Iterator it = this.curve.getTrace().iterator();
        Float lastX = null;
        Float lastY = null;
        while (it.hasNext()) {
            AgeCurve.AgeCurveValue value = (AgeCurve.AgeCurveValue)it.next();
            if (value.getAge() < (double)bp.min) continue;
            if (value.getAge() > (double)bp.max) break;
            float x1 = x + this.scaleValue(value.getValue());
            float y1 = this.calcYPos(value.getAge(), y, bp, p, mode);
            if (lastX != null && lastY != null) {
                g.drawLine(x1, y1, lastX.floatValue(), lastY.floatValue());
            }
            lastX = Float.valueOf(x1);
            lastY = Float.valueOf(y1);
        }
    }

    private void drawCurveDepth(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        if (this.block.interp == null || this.block.interp.getLOC() == null) {
            return;
        }
        int n = this.curve.getTrace().size();
        double minDepth = Math.max(this.block.interp.getLOC().getMinDepth(), (double)bp.min);
        double increment = (Math.min((double)bp.max, this.block.interp.getLOC().getMaxDepth()) - minDepth) / (double)n;
        double[] depths = new double[n];
        for (int i = 0; i < n; ++i) {
            depths[i] = minDepth + (double)i * increment;
        }
        float y1 = 0.0f;
        Float lastX = null;
        Float lastY = null;
        for (double depth : depths) {
            double age = this.block.interp.getLOC().getAge(depth, true);
            double value = this.curve.getValue(age);
            float x1 = x + this.scaleValue(value);
            try {
                y1 = this.block.scaleValue((float)depth, BlockProperties.ScaleType.MD) + y + PanelAgeCurve.getPanelHeaderHeight(p, mode);
            }
            catch (SBException sbe) {
                System.out.println(sbe.getMessage());
                y1 = 0.0f;
            }
            if (lastX != null && lastY != null) {
                g.drawLine(x1, y1, lastX.floatValue(), lastY.floatValue());
            }
            lastX = Float.valueOf(x1);
            lastY = Float.valueOf(y1);
        }
    }

    private void calcHScale() {
        double newMin;
        double newMax;
        if (this.curve == null) {
            return;
        }
        double min = this.curve.getMin();
        double max = this.curve.getMax();
        double startVal = 0.0;
        while (min > startVal && max > startVal || max < startVal && min < startVal) {
            if (min > startVal) {
                startVal -= 1.0;
                continue;
            }
            startVal += 1.0;
        }
        for (newMax = startVal; newMax < max; newMax += 50.0) {
        }
        for (newMin = startVal; newMin > min; newMin -= 50.0) {
        }
        this.p.scaleMax = newMax;
        this.p.scaleMin = newMin;
        this.hScale = (double)this.p.width / (this.p.scaleMax - this.p.scaleMin);
    }

    private float scaleValue(double value) {
        double retval = value * this.hScale;
        retval = this.p.scaleMax * this.hScale - retval;
        return (float)retval;
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Age Curve";
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Age Curve";
    }

    private float calcYPos(double age, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode) {
        return y + PanelAgeCurve.getPanelHeaderHeight(cp, mode) + (float)age * bp.scale - bp.min * bp.scale;
    }

    public String toString() {
        if (this.curve != null) {
            return "Age Curve - " + this.curve.getTitle();
        }
        return "Age Curve - (no curve)";
    }

    @Override
    float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        g.setColor(this.curve.getColour());
        g.setStroke(this.curve.getLineWidth());
        Iterator it = this.curve.getTrace().iterator();
        Float lastX = null;
        Float lastY = null;
        float headerHeight = 12.0f;
        g.setClip(x + headerHeight, y, this.getXPos(bp.ageLeftToRight ? bp.max : bp.min, bp) - headerHeight, this.p.width);
        while (it.hasNext()) {
            AgeCurve.AgeCurveValue value = (AgeCurve.AgeCurveValue)it.next();
            if (value.getAge() < (double)bp.min) continue;
            if (value.getAge() > (double)bp.max) break;
            float y1 = y + this.scaleValue(value.getValue());
            float x1 = x + this.getXPos((float)value.getAge(), bp);
            if (lastX != null && lastY != null) {
                g.drawLine(x1, y1, lastX.floatValue(), lastY.floatValue());
            }
            lastX = Float.valueOf(x1);
            lastY = Float.valueOf(y1);
        }
        g.setClip(null);
        g.setColor(Color.BLACK);
        g.setStroke(0.2f);
        g.drawRect(x, y, this.getXPos(bp.ageLeftToRight ? bp.max : bp.min, bp), this.p.width);
        g.drawLine(x + headerHeight, y, x + headerHeight, y + this.p.width);
        g.setFont(cp.font, 1, cp.fontHeader - 1.0f);
        g.drawStringVertical(this.curve.getTitle(), x + cp.fontHeader - 1.0f, y + this.p.width, this.p.width, false, true);
        g.setFont(cp.font, 0, cp.fontSmall);
        g.drawStringVertical(this.p.scaleMin + "", x + headerHeight - 2.0f, y + this.p.width - 0.5f, this.p.width, false, false);
        String max = this.p.scaleMax + "";
        g.drawStringVertical(max, x + headerHeight - 2.0f, y + g.stringWidth(max) + 0.5f, this.p.width, false, false);
        g.setStroke(0.1f);
        for (double d = this.p.scaleMin + 50.0; d < this.p.scaleMax; d += 50.0) {
            g.drawLine(x + headerHeight, y + this.scaleValue(d), x + headerHeight - 1.0f, y + this.scaleValue(d));
        }
        return this.p.width;
    }

    @Override
    int getIdentifier() {
        return this.curve.getCurveID();
    }

    @Override
    public int getType() {
        return 41;
    }

    @Override
    public PanelAgeCurveProperties getProperties() {
        return this.p;
    }
}

