/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.PanelAgeScaleProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import jsbugs.TickScheme;
import util.SB;
import util.SBException;

public class PanelAgeScale
extends SBPanel {
    TickScheme scheme = new TickScheme();
    boolean isWell;
    final SchemeBlock block;
    PanelAgeScaleProperties p;

    PanelAgeScale(SchemeBlock block, boolean isWell) {
        this.block = block;
        this.isWell = isWell;
        this.p = new PanelAgeScaleProperties();
    }

    PanelAgeScale(SchemeBlock block, boolean isWell, String props) {
        this.block = block;
        this.isWell = isWell;
        this.p = new PanelAgeScaleProperties(props);
    }

    public String toString() {
        return "Age Scale";
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Age Scale";
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Age Scale";
    }

    @Override
    public int getType() {
        return 43;
    }

    @Override
    public PanelAgeScaleProperties getProperties() {
        return this.p;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float x2;
        float x1;
        float ypos;
        g.setClip(x, y + PanelAgeScale.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height);
        float minAge = this.block.getMinAge();
        float maxAge = this.block.getMaxAge();
        g.setFont(cp.font, 0, cp.fontSmall);
        this.scheme.calcScaleLabels(minAge, this.block.getScale());
        float age = this.scheme.start;
        age -= this.scheme.tickInterval;
        float left = x;
        float SMALL = 1.0E-6f;
        while (age > minAge) {
            if (age < maxAge) {
                ypos = this.calcPlotPosition(y, age, cp, bp, mode);
                x1 = left;
                x2 = left + 1.0f;
                g.drawLine(x1, ypos, x2, ypos);
            }
            age -= this.scheme.tickInterval;
        }
        age = this.scheme.start;
        float yPreviousLabel = -9999999.0f;
        while (age <= maxAge + 1.0E-6f) {
            String buffer = SB.floatString((float)age, (int)this.scheme.precision);
            ypos = this.calcPlotPosition(y, age, cp, bp, mode);
            x1 = left;
            x2 = left + 2.0f;
            g.drawLine(x1, ypos, x2, ypos);
            float w = g.stringWidth(buffer);
            float h = g.stringHeight();
            float xpos = x2;
            if (ypos > yPreviousLabel + h) {
                g.drawString(buffer, xpos, ypos + 0.3f * h);
                yPreviousLabel = ypos;
            }
            float nextDepth = age + this.scheme.labelInterval;
            age += this.scheme.tickInterval;
            while (age < nextDepth && age <= maxAge) {
                ypos = this.calcPlotPosition(y, age, cp, bp, mode);
                x1 = left;
                x2 = left + 1.0f;
                g.drawLine(x1, ypos, x2, ypos);
                age += this.scheme.tickInterval;
            }
            age = nextDepth;
        }
        g.setClip(null);
        return x + this.p.width;
    }

    float calcPlotPosition(float y, float value, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        try {
            return this.block.scaleValue(value, BlockProperties.ScaleType.AGE) + y + PanelAgeScale.getPanelHeaderHeight(cp, mode);
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        float xpos;
        g.setClip(x, y, this.getXPos(bp.ageLeftToRight ? bp.max : bp.min, bp), this.p.width);
        g.setColor(Color.BLACK);
        float minAge = this.block.getMinAge();
        float maxAge = this.block.getMaxAge();
        g.setFont(cp.font, 0, cp.fontSmall);
        this.scheme.calcScaleLabels(minAge, this.block.getScale());
        float age = this.scheme.start;
        age -= this.scheme.tickInterval;
        float SMALL = 1.0E-6f;
        float y1 = y + this.p.width;
        float y2 = y1 - 1.0f;
        float h = g.stringHeightSB();
        while (age > minAge) {
            if (age < maxAge) {
                xpos = x + this.getXPos(age, bp);
                g.drawLine(xpos, y1, xpos, y2);
            }
            age -= this.scheme.tickInterval;
        }
        age = this.scheme.start;
        Float xPreviousLabel = null;
        while (age <= maxAge + 1.0E-6f) {
            String buffer = SB.floatString((float)age, (int)this.scheme.precision);
            xpos = x + this.getXPos(age, bp);
            y2 = y1 - 2.0f;
            g.drawLine(xpos, y1, xpos, y2);
            float ypos = y2;
            if (xPreviousLabel == null || bp.ageLeftToRight && xpos > xPreviousLabel.floatValue() + h || !bp.ageLeftToRight && xpos < xPreviousLabel.floatValue()) {
                g.drawStringVertical(buffer, xpos + h / 2.0f, ypos);
                xPreviousLabel = Float.valueOf(xpos);
            }
            float nextDepth = age + this.scheme.labelInterval;
            age += this.scheme.tickInterval;
            while (age < nextDepth && age <= maxAge) {
                xpos = x + this.getXPos(age, bp);
                y2 = y1 - 1.0f;
                g.drawLine(xpos, y1, xpos, y2);
                age += this.scheme.tickInterval;
            }
            age = nextDepth;
        }
        g.setClip(null);
        g.setColor(Color.BLACK);
        g.setStroke(0.2f);
        g.drawRect(x, y, this.getXPos(bp.ageLeftToRight ? bp.max : bp.min, bp), this.p.width);
        g.drawLine(x, y, x, y + this.p.width);
        return this.p.width;
    }

    @Override
    String getCaption() {
        return "Age";
    }

    @Override
    String getSubHeader() {
        if (this.isWell) {
            return "Ma";
        }
        return null;
    }
}

