/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartObject;
import jsbugs.ChartProperties;
import jsbugs.PanelBiocomsProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanelHTML;
import jsbugs.WellBlock;
import model2.Biocom;
import model2.Discipline;
import model2.SBdb;
import model2.Sample;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class PanelBiocoms
extends SBPanelHTML
implements Observer {
    WellBlock block;
    int interpID;
    private PanelBiocomsProperties p;
    double[][] sections = null;
    private boolean useAltColour = true;
    static final float RANGE_ARROW_SIZE = 2.2f;
    List<ChartObject> totalChartComments;
    float[] totalMovedPositions;
    float[] totalSymbolSizes;

    public PanelBiocoms(WellBlock block, int interpID, SBdb sbdb) throws SQLException, SBException {
        this.block = block;
        this.interpID = interpID;
        this.init(sbdb, null);
    }

    public PanelBiocoms(WellBlock block, int interpID, SBdb sbdb, String prop) throws SQLException, SBException {
        this.block = block;
        this.interpID = interpID;
        this.init(sbdb, prop);
    }

    private void init(SBdb sbdb, String prop) throws SBException {
        this.p = prop == null ? new PanelBiocomsProperties(sbdb) : new PanelBiocomsProperties(prop);
        this.block.well.getInterp(this.interpID).addObserver((Observer)this);
    }

    @Override
    synchronized float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, (bp == this.block.prop ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max)) + y + PanelBiocoms.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height + (this.block.prop == bp ? y + PanelBiocoms.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        try {
            int i;
            WellInterp interp = this.block.well.getInterp(this.interpID);
            g.setFont(cp.font, 0, cp.getFontSize(this.p.fontSize));
            g.setStroke(0.1f);
            this.useAltColour = false;
            LinkedList<ChartObject> chartComments = new LinkedList<ChartObject>();
            float sampleWidth = 0.0f;
            float analystWidth = 0.0f;
            float minDepth = bp == this.block.prop ? this.block.getTopDepth() : Math.min(bp.min, bp.max);
            float maxDepth = bp == this.block.prop ? this.block.getBaseDepth() : Math.max(bp.min, bp.max);
            for (Biocom biocom : interp.getComments()) {
                double corrDepth = this.block.well.getDepth(biocom.getTopSample(), cp.correctDepths, cp.correctCuttings);
                if (!(corrDepth >= (double)minDepth) || !(corrDepth <= (double)maxDepth) || !this.p.useDisc(biocom.getDiscipline()) || !this.p.useAnalyst(biocom.getAnalystString())) continue;
                float yPos = y + this.block.scaleDepth((float)corrDepth) + PanelBiocoms.getPanelHeaderHeight(cp, mode);
                ChartObject chartComment = new ChartObject(biocom, yPos);
                float depth = (float)biocom.getTopSample().getDepth();
                if (Math.abs((double)depth - corrDepth) > (double)0.0029f) {
                    chartComment.corrDepth = corrDepth;
                }
                chartComments.add(chartComment);
                g.drawLine(x, yPos, x + 1.0f, yPos);
            }
            float[] symbolSizes = new float[chartComments.size()];
            float[] movedPositions = new float[chartComments.size()];
            Collections.sort(chartComments);
            for (int i2 = 0; i2 < chartComments.size(); ++i2) {
                float analyS;
                movedPositions[i2] = ((ChartObject)chartComments.get((int)i2)).yPos;
                Biocom comment = (Biocom)((ChartObject)chartComments.get((int)i2)).o;
                if (this.p.drawSamples) {
                    float sampS = g.stringWidth(comment.getTopSample().toString(this.block.prop.units, false, false, true, true, null, null));
                    if (sampS > sampleWidth) {
                        sampleWidth = sampS;
                    }
                    if (comment.getBaseSample() != null && (sampS = g.stringWidth(comment.getBaseSample().toString(this.block.prop.units, false, false, true, true, null, null)) + 2.2f) > sampleWidth) {
                        sampleWidth = sampS;
                    }
                }
                if (!this.p.drawAnalyst || !((analyS = g.stringWidth(comment.getAnalystString())) > analystWidth)) continue;
                analystWidth = analyS;
            }
            float textWidth = x + this.p.panelWidth - (x + 4.5f + (this.p.drawSamples ? sampleWidth + 1.0f : 0.0f) + (this.p.drawAnalyst ? analystWidth + 1.0f : 0.0f)) - 1.5f;
            for (int i3 = 0; i3 < chartComments.size(); ++i3) {
                Biocom comment = (Biocom)((ChartObject)chartComments.get((int)i3)).o;
                symbolSizes[i3] = this.calcSymbolSize(g, comment, textWidth);
            }
            if (this.sections != null) {
                boolean ypos = false;
                boolean ddepth = true;
                int pos = 0;
                for (int j = 0; j < this.sections.length - 1; ++j) {
                    int k;
                    for (k = pos; k < movedPositions.length && !(((ChartObject)chartComments.get(k)).getDepth() > this.sections[j + 1][1]); ++k) {
                    }
                    if (k - pos > 0) {
                        float[] section = Arrays.copyOfRange(movedPositions, pos, k);
                        float[] sizes = Arrays.copyOfRange(symbolSizes, pos, k);
                        float hPosition = (float)Math.min(this.sections[j][0], this.sections[j + 1][0]) + y + PanelBiocoms.getPanelHeaderHeight(cp, mode) + cp.getFontSize(this.p.fontSize);
                        float lPosition = (float)Math.max(this.sections[j][0], this.sections[j + 1][0]) + y + PanelBiocoms.getPanelHeaderHeight(cp, mode) - sizes[sizes.length - 1];
                        PanelBiocoms.moveSamplePositions(k - pos, section, sizes, hPosition, lPosition);
                        System.arraycopy(section, 0, movedPositions, pos, k - pos);
                    }
                    pos = k;
                }
            } else {
                float hPosition = y + this.block.scaleDepth(this.block.getTopDepth()) + PanelBiocoms.getPanelHeaderHeight(cp, mode) + cp.fontPanel / 2.0f;
                float lPosition = y + this.block.scaleDepth(this.block.getBaseDepth()) + PanelBiocoms.getPanelHeaderHeight(cp, mode) - cp.fontPanel / 2.0f;
                PanelBiocoms.moveSamplePositions(chartComments.size(), movedPositions, symbolSizes, hPosition, lPosition);
            }
            for (i = 0; i < chartComments.size(); ++i) {
                g.setColor(Color.BLACK);
                g.drawLine(x + 1.0f, ((ChartObject)chartComments.get((int)i)).yPos, x + 3.0f, movedPositions[i]);
                Biocom biocom = (Biocom)((ChartObject)chartComments.get((int)i)).o;
                Color analystColour = null;
                if (this.p.useAnalystColours) {
                    analystColour = this.block.well.getDataModel().getUser(biocom.getAnalyst()).getColour();
                }
                this.drawComment(g, biocom, x, movedPositions[i], sampleWidth, analystWidth, analystColour, cp);
            }
            i = 0;
            while (i < movedPositions.length) {
                int n = i++;
                movedPositions[n] = movedPositions[n] - (y + PanelBiocoms.getPanelHeaderHeight(cp, mode));
            }
            if (this.block.prop == bp || (double)Math.abs(this.block.getTopDepth() - bp.min) < 0.01) {
                this.totalChartComments = chartComments;
                this.totalMovedPositions = movedPositions;
                this.totalSymbolSizes = symbolSizes;
            } else {
                this.totalChartComments.addAll(chartComments);
                float[] temp = new float[this.totalMovedPositions.length + movedPositions.length];
                System.arraycopy(this.totalMovedPositions, 0, temp, 0, this.totalMovedPositions.length);
                System.arraycopy(movedPositions, 0, temp, this.totalMovedPositions.length, movedPositions.length);
                this.totalMovedPositions = temp;
                temp = new float[this.totalSymbolSizes.length + symbolSizes.length];
                System.arraycopy(this.totalSymbolSizes, 0, temp, 0, this.totalSymbolSizes.length);
                System.arraycopy(symbolSizes, 0, temp, this.totalSymbolSizes.length, symbolSizes.length);
                this.totalSymbolSizes = temp;
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error drawing comments panel", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error drawing comments panel", (SQLException)sql);
        }
        return x + this.getWidth(bp);
    }

    private void drawComment(SBGraphics g, Biocom biocom, float x, float yPos, float sampleWidth, float analystWidth, Color analystColour, ChartProperties cp) throws SQLException, SBException {
        float xPos = x + 3.0f;
        float horzPad = 1.0f;
        g.drawLine(xPos, yPos, xPos += horzPad, yPos);
        yPos += g.stringHeightSB() / 2.0f;
        xPos += horzPad / 2.0f;
        if (this.p.drawSamples) {
            String comString = biocom.getTopSample().toString(this.block.prop.units, false, false, true, true, null, null);
            g.drawString(comString, xPos, yPos);
            if (biocom.getBaseSample() != null) {
                g.drawLine(xPos, yPos, xPos, yPos + g.stringHeightSB() / 2.0f);
                g.drawLine(xPos, yPos + g.stringHeightSB() / 2.0f, xPos + 2.2f, yPos + g.stringHeightSB() / 2.0f);
                float[] xpoints = new float[]{xPos + 1.1f, xPos + 2.2f, xPos + 1.1f};
                float[] ypoints = new float[]{yPos + g.stringHeightSB() / 2.0f - 0.4f, yPos + g.stringHeightSB() / 2.0f, yPos + g.stringHeightSB() / 2.0f + 0.4f};
                g.fillPolygon(xpoints, ypoints, 3);
                comString = biocom.getBaseSample().toString(this.block.prop.units, false, false, true, true, null, null);
                float tempypos = yPos + g.stringHeightSB();
                g.setFontSize(cp.getFontSize(this.p.fontSize) * 0.75f);
                g.drawString(comString, xPos + 2.2f + 0.5f, tempypos);
                g.setFontSize(cp.getFontSize(this.p.fontSize));
            }
            xPos += sampleWidth + horzPad;
        }
        if (this.p.drawAnalyst) {
            if (analystColour != null) {
                g.setColor(analystColour);
            }
            g.drawString(biocom.getAnalystString(), xPos, yPos);
            if (analystColour != null) {
                g.setColor(Color.BLACK);
            }
            xPos += analystWidth + horzPad;
        }
        xPos = (float)((double)xPos + (double)horzPad * 0.5);
        if (this.useAltColour) {
            g.setColor(PanelBiocomsProperties.altColour);
        }
        if (this.p.useAltColour) {
            this.useAltColour = !this.useAltColour;
        }
        String comment = biocom.getText();
        float width = x + this.p.panelWidth - xPos - horzPad;
        if (g.stringWidth(comment) > width) {
            StringTokenizer tokeniser = new StringTokenizer(comment, " ");
            String text = "";
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                StringBuilder stringBuilder = new StringBuilder();
                if (g.stringWidth(stringBuilder.append(text).append(tok).toString()) < width) {
                    text = text + tok + " ";
                    continue;
                }
                g.drawString(text, xPos, yPos);
                text = tok + " ";
                yPos += g.stringHeight();
            }
            g.drawString(text, xPos, yPos);
        } else {
            g.drawString(comment, xPos, yPos);
        }
    }

    @Override
    String getCaption() {
        return "Comments";
    }

    @Override
    String getSubCaption() {
        try {
            WellInterp interp = this.block.well.getInterp(this.interpID);
            return interp.getHeader().toString();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
            return null;
        }
    }

    @Override
    String getSubHeader() {
        if (this.p.discs == null || this.p.discs.size() == Discipline.values().length) {
            return null;
        }
        String hdr = "";
        for (Discipline discID : this.p.discs) {
            if (!hdr.isEmpty()) {
                hdr = hdr + ", ";
            }
            hdr = hdr + discID.getAbr(true);
        }
        return hdr;
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        this.sections = sections;
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.p.panelWidth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.totalMovedPositions == null || this.totalChartComments == null) {
            return null;
        }
        float BRACKET = 2.5f / zoom;
        int i = 0;
        for (ChartObject chartComment : this.totalChartComments) {
            float yPos = this.totalMovedPositions[i];
            float symbolSize = this.totalSymbolSizes[i];
            if (y > yPos - BRACKET && y < yPos + symbolSize) {
                try {
                    if (bp == this.block.prop || chartComment.getDepth() > (double)bp.min && chartComment.getDepth() < (double)bp.max) {
                        return chartComment.o;
                    }
                }
                catch (SBException sbe) {
                    sbe.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && o instanceof Biocom) {
            try {
                Biocom b = (Biocom)o;
                return b.getTopSample().toString(bp.units) + ", " + b.getAnalystString();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        String name = "Comments";
        try {
            if (this.interpID >= 0) {
                name = name + " : " + this.block.well.getInterp(this.interpID);
            }
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
        }
        return name;
    }

    private float calcSymbolSize(SBGraphics g, Biocom comment, float width) {
        int lines = 1;
        if (g.stringWidth(comment.getText()) > width) {
            StringTokenizer tokeniser = new StringTokenizer(comment.getText(), " ");
            String text = "";
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                StringBuilder stringBuilder = new StringBuilder();
                if (g.stringWidth(stringBuilder.append(text).append(tok).toString()) < width) {
                    text = text + tok + " ";
                    continue;
                }
                text = tok + " ";
                ++lines;
            }
        }
        if (this.p.drawSamples && comment.getBaseID() > 0 && lines == 1) {
            ++lines;
        }
        return g.stringHeight() * (float)lines + g.stringHeightSB() * 0.4f;
    }

    @Override
    public PanelBiocomsProperties getProperties() {
        return this.p;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    int getIdentifier() {
        return this.interpID;
    }

    void setProperties(PanelBiocomsProperties p) {
        this.p = p;
    }

    @Override
    int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        if (this.totalChartComments == null) {
            return 0;
        }
        for (ChartObject comment : this.totalChartComments) {
            try {
                Sample.insert(samples, (Sample)comment.getSample(), (char)this.block.prop.units);
            }
            catch (SBException sbe) {}
        }
        return this.totalChartComments.size();
    }

    @Override
    String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Sample sample = samples.get(index);
        String row = "<td>";
        if (this.totalChartComments != null) {
            for (ChartObject comment : this.totalChartComments) {
                Biocom biocom = (Biocom)comment.o;
                if (!biocom.getTopSample().equals(sample)) continue;
                if (!row.equals("<td>")) {
                    row = row + "<br>";
                }
                if (this.p.drawSamples) {
                    row = row + biocom.getTopSample().toString(this.block.prop.units, false, false, true, true, null, null) + " ";
                }
                try {
                    if (this.p.drawAnalyst) {
                        if (this.p.useAnalystColours) {
                            Color analystColour = this.block.well.getDataModel().getUser(biocom.getAnalyst()).getColour();
                            row = row + PanelBiocoms.getHTMLFontColour(analystColour);
                        }
                        row = row + biocom.getAnalystString() + " ";
                        if (this.p.useAnalystColours) {
                            row = row + "</font>";
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                row = row + biocom.toString();
            }
        }
        row = row + "</td>";
        return row;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp && ((WellInterp)o).getHeader().getInterpID() == this.interpID && arg instanceof Biocom) {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

