/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jsbugs.ChartProperties;
import jsbugs.PanelProperties;
import model2.Discipline;
import model2.Lastval;
import model2.SBdb;

public class PanelBiocomsProperties
implements PanelProperties {
    float panelWidth = 70.0f;
    boolean drawSamples = true;
    boolean drawAnalyst = true;
    boolean useAnalystColours = true;
    List<String> analysts = null;
    Set<Discipline> discs = null;
    boolean useAltColour = true;
    ChartProperties.FontSize fontSize = ChartProperties.FontSize.SMALL;
    static final Color altColour = new Color(110, 110, 110);

    PanelBiocomsProperties(SBdb db) {
        try {
            this.decode(db);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    PanelBiocomsProperties(PanelBiocomsProperties rhs) {
        this.panelWidth = rhs.panelWidth;
        this.drawSamples = rhs.drawSamples;
        this.drawAnalyst = rhs.drawAnalyst;
        this.useAnalystColours = rhs.useAnalystColours;
        this.useAltColour = rhs.useAltColour;
        this.analysts = rhs.analysts != null ? new LinkedList<String>(rhs.analysts) : null;
        this.discs = rhs.discs != null ? new HashSet<Discipline>(rhs.discs) : null;
        this.fontSize = rhs.fontSize;
    }

    @Override
    public void writeProperties(SBdb sbdb, String key, String valuePrefix) throws SQLException {
        String prefs = this.getPrefs();
        String disc = "";
        if (this.discs != null) {
            for (Discipline d : this.discs) {
                if (!disc.isEmpty()) {
                    disc = disc + ",";
                }
                disc = disc + d.getChar();
            }
        }
        String analy = "";
        if (this.analysts != null) {
            for (String s : this.analysts) {
                if (!analy.isEmpty()) {
                    analy = analy + ",";
                }
                analy = analy + s;
            }
        }
        prefs = prefs + disc + "|" + analy;
        Lastval.putString((SBdb)sbdb, (String)key, (String)(valuePrefix + prefs));
    }

    @Override
    public String getPrefs() {
        String string = new String();
        String[] props = new String[]{"" + this.panelWidth, "" + (this.drawSamples ? 1 : 0), "" + (this.drawAnalyst ? 1 : 0), "" + (this.useAnalystColours ? 1 : 0), "" + (this.useAltColour ? 1 : 0), "" + this.fontSize.name()};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    PanelBiocomsProperties(String prop) {
        this.decode(prop);
    }

    void encode(SBdb db) {
        String string = this.getPrefs();
        try {
            Lastval.putString((SBdb)db, (String)"PANBIOCOM", (String)string);
            db.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decode(SBdb db) throws SQLException {
        String params = Lastval.getString((SBdb)db, (String)"PANBIOCOM");
        if (params.isEmpty()) {
            return;
        }
        this.decode(params);
    }

    /*
     * Unable to fully structure code
     */
    private void decode(String prop) {
        s = prop.split("\\|");
        block12: for (i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.panelWidth = Float.parseFloat(s[i]);
                    continue block12;
                }
                case 1: {
                    this.drawSamples = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 2: {
                    this.drawAnalyst = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 3: {
                    this.useAnalystColours = Integer.parseInt(s[i]) == 1;
                    continue block12;
                }
                case 4: {
                    if (s[i].equals("1") || s[i].equals("0")) {
                        this.useAltColour = Integer.parseInt(s[i]) == 1;
                        continue block12;
                    }
                    if (i + 1 < s.length) {
                        ++i;
                    }
                }
                case 5: {
                    try {
                        this.fontSize = ChartProperties.FontSize.valueOf(s[i]);
                        continue block12;
                    }
                    catch (IllegalArgumentException e) {
                        if (i + 1 >= s.length) ** GOTO lbl29
                        ++i;
                    }
                }
lbl29:
                // 3 sources

                case 6: {
                    if (s[i].isEmpty()) continue block12;
                    t = s[i].split(",");
                    this.discs = new HashSet<Discipline>();
                    for (j = 0; j < t.length; ++j) {
                        this.discs.add(Discipline.getDisc((String)t[j]));
                    }
                    continue block12;
                }
                case 7: {
                    if (s[i].isEmpty()) continue block12;
                    t = s[i].split(",");
                    this.analysts = new LinkedList<String>();
                    this.analysts.addAll(Arrays.asList(t));
                    if (!this.analysts.isEmpty()) continue block12;
                    this.analysts = null;
                }
            }
        }
    }

    boolean useDisc(Discipline discID) {
        if (this.discs == null) {
            return true;
        }
        return this.discs.contains(discID);
    }

    boolean useAnalyst(String analyst) {
        if (this.analysts == null) {
            return true;
        }
        return this.analysts.contains(analyst);
    }
}

