/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.List;
import java.util.Observable;
import jsbugs.PanelZones;
import jsbugs.WellBlock;
import model2.IGDColMap;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.SBdb;
import model2.WellInterp;
import util.SBException;

public class PanelBiozones
extends PanelZones {
    int schID;

    public PanelBiozones(SBdb db, WellBlock block, int igdType, int interpID, int schID) throws SBException, SQLException {
        super(db, block, igdType, interpID);
        this.schID = schID;
    }

    public PanelBiozones(SBdb db, WellBlock block, int igdType, int interpID, String props, int schID) throws SBException, SQLException {
        super(db, block, igdType, interpID, props);
        this.schID = schID;
    }

    @Override
    public String toString() {
        String string = "Intervals";
        try {
            string = string + " : " + IGDInterval.getIGDName((int)this.igdType) + " : " + this.db.getIGDScheme(this.schID) + " : " + this.block.well.getInterp(this.interpID);
        }
        catch (SBException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
        }
        catch (SQLException se) {
            System.out.println(se.getMessage());
            se.printStackTrace();
        }
        return string;
    }

    @Override
    List<IGDIntervalZone> getIGDList() throws SBException, SQLException {
        WellInterp wellInterp = this.block.well.getInterp(this.interpID);
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelBiozones");
        }
        return this.block.well.getInterp(this.interpID).getIGDList(this.igdType, this.schID);
    }

    @Override
    List<IGDIntervalZone> getIGDList(int column) throws SBException, SQLException {
        WellInterp wellInterp = this.block.well.getInterp(this.interpID);
        IGDColMap colmap = this.block.well.getInterp(this.interpID).getColMap(this.block.well.getWellID(), this.igdType);
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelZones");
        }
        if (colmap != null) {
            return this.block.well.getInterp(this.interpID).getIGDList(this.igdType, this.schID, colmap.getMinhier(column), colmap.getMaxhier(column));
        }
        throw new SBException("Colmap is null in PanelBiozones");
    }

    @Override
    String getPanelTitle() throws SQLException {
        IGDScheme scheme = this.db.getIGDScheme(this.schID);
        String title = "Biozones : " + scheme.toString();
        return title;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp && ((WellInterp)o).getHeader().getInterpID() == this.interpID && arg instanceof IGDIntervalZone && ((IGDIntervalZone)arg).getIGDType() == this.igdType && ((IGDIntervalZone)arg).getSchID() == this.schID) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    @Override
    int getIdentifier2() {
        return this.schID;
    }

    @Override
    public int getSchID() {
        return this.schID;
    }
}

