/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.sql.SQLException;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Casing;
import model2.CasingPoint;
import model2.SBdb;
import util.SB;

public class PanelCasing
extends SBPanel {
    WellBlock block;
    SBdb sbdb;
    private float panelWidth = 20.0f;

    public PanelCasing(SBdb sbdb, WellBlock block) {
        this.block = block;
        this.sbdb = sbdb;
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (!g.isVisible(x, y, this.getWidth(bp), y + PanelCasing.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(bp.max))) {
            return x + this.getWidth(bp);
        }
        Casing casing = null;
        try {
            casing = this.block.well.getCasing();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error loading casing: ", (SQLException)sql);
            sql.printStackTrace();
        }
        if (casing.getList().isEmpty()) {
            return x + this.getWidth(bp);
        }
        g.setClip(x, y + PanelCasing.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.prop), this.block.getHeight());
        float casWidth = 8.0f;
        if (this.panelWidth < casWidth) {
            casWidth = this.panelWidth;
        }
        g.setColor(Color.BLACK);
        float[] triX = new float[3];
        float[] triY = new float[3];
        float xmid = x + this.panelWidth / 2.0f;
        g.setStroke(1.0f);
        g.setFont(cp.font, 0, cp.fontSmall);
        for (CasingPoint casingPoint : casing.getList()) {
            double depth = casingPoint.getDepth();
            if (depth < (double)this.block.getTopDepth() || depth > (double)this.block.getBaseDepth()) continue;
            float yPos = y + this.block.scaleDepth((float)casingPoint.getDepth()) + PanelCasing.getPanelHeaderHeight(cp, mode);
            g.drawLine(xmid - casWidth / 2.0f, yPos, xmid + casWidth / 2.0f, yPos);
            g.drawLine(xmid + casWidth / 2.0f, yPos + 0.5f, xmid + casWidth / 2.0f, yPos - casWidth * 2.0f);
            triX[0] = xmid - casWidth / 2.0f + casWidth * 0.35f;
            triX[1] = xmid + casWidth / 2.0f;
            triX[2] = triX[1];
            triY[0] = yPos;
            triY[1] = yPos;
            triY[2] = yPos - casWidth * 0.65f;
            g.fillPolygon(triX, triY, 3);
            String depthString = SB.getDepthString((double)casingPoint.getDepth(), (char)this.block.prop.units, (int)2);
            g.drawString(depthString, x, yPos + g.stringHeight(), this.getWidth(bp), 0);
            g.drawStringVertical(casingPoint.getDiameter(), xmid - casWidth / 2.0f + casWidth * 0.35f, yPos - 2.0f, this.getWidth(bp), false, false);
        }
        g.setClip(null);
        return x + this.getWidth(bp);
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.panelWidth;
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Casing points";
    }

    public String toString() {
        return "Casing Points";
    }

    @Override
    String getCaption() {
        return "Casing";
    }
}

