/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartProperties;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.SBdb;
import util.SB;

public class PanelChromalog
extends SBPanel {
    private static float headerSpace = 10.0f;
    private float columnWidth = 40.0f;
    private WellBlock block;
    final SBdb db;
    List<Interval> data = new LinkedList<Interval>();
    File file;

    public float getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(float columnWidth) {
        this.columnWidth = columnWidth;
    }

    public PanelChromalog(WellBlock block, SBdb db) {
        this.block = block;
        this.db = db;
    }

    public void setFileData(float width, File file) throws FileNotFoundException, IOException {
        this.setColumnWidth(width);
        this.file = file;
        this.data.clear();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String buff = in.readLine();
        while (buff != null) {
            String[] tokens = buff.split("[^\\d]");
            if (tokens.length >= 4) {
                try {
                    int nTok;
                    for (nTok = 0; tokens[nTok].isEmpty() && nTok < tokens.length; ++nTok) {
                    }
                    double top = Double.parseDouble(tokens[nTok]);
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    double base = Double.parseDouble(tokens[nTok]);
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    int r = Integer.parseInt(tokens[nTok]);
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    int g = Integer.parseInt(tokens[nTok]);
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    int b = Integer.parseInt(tokens[nTok]);
                    this.data.add(new Interval(top, base, new Color(r, g, b)));
                }
                catch (Exception ex) {
                    System.out.println("Exception in reading: " + ex.toString());
                }
            }
            buff = in.readLine();
        }
        System.out.println("Got: " + this.data.size() + " intervals");
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float baseDepth;
        float topDepth;
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.prop || (double)Math.abs(bp.min - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.min : bp.max) + y + PanelChromalog.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.height)) {
            return x + this.getWidth(bp);
        }
        if (bp == this.block.prop) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.min;
            baseDepth = bp.max;
        }
        try {
            for (Interval interval : this.data) {
                g.setColor(interval.colour);
                float top = (float)SB.convToM((double)interval.top, (char)bp.units);
                float base = (float)SB.convToM((double)interval.base, (char)bp.units);
                if (base < topDepth) continue;
                if (!(top > baseDepth)) {
                    if (top < topDepth) {
                        top = topDepth;
                    }
                    if (base > baseDepth) {
                        base = baseDepth;
                    }
                    float yPos1 = y + PanelChromalog.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(top);
                    float yPos2 = y + PanelChromalog.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(base);
                    g.fillRect(x, yPos1, this.getColumnWidth(), yPos2 - yPos1, interval.colour);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return x + this.getColumnWidth();
    }

    @Override
    float getWidth(BlockProperties bp) {
        return this.getColumnWidth();
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Chromalog panel";
    }

    @Override
    String getCaption() {
        return "Chromalog";
    }

    @Override
    String getSubHeader() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public String toString() {
        return this.getCaption();
    }

    private static class Interval {
        double top;
        double base;
        Color colour;

        Interval(double top, double base, Color colour) {
            this.top = top;
            this.base = base;
            this.colour = colour;
        }
    }
}

